MODULE trac_types_mod

  USE strings_mod, ONLY: maxlen
  PRIVATE

!=== TRACERS DESCRIPTOR DERIVED TYPE AND ASSOCIATED ROUTINES INTERFACES =======================================================
  PUBLIC :: trac_type, isot_type, keys_type
!------------------------------------------------------------------------------------------------------------------------------
  TYPE :: keys_type                                        !=== TYPE FOR A SET OF KEYS ASSOCIATED TO AN ELEMENT
    CHARACTER(LEN=maxlen)              :: name             !--- Tracer name
    CHARACTER(LEN=maxlen), ALLOCATABLE :: key(:)           !--- Keys string list
    CHARACTER(LEN=maxlen), ALLOCATABLE :: val(:)           !--- Corresponding values string list
  END TYPE keys_type
!------------------------------------------------------------------------------------------------------------------------------
  TYPE :: trac_type                                        !=== TYPE FOR A SINGLE TRACER NAMED "name"
    CHARACTER(LEN=maxlen) :: name        = ''              !--- Name of the tracer
    CHARACTER(LEN=maxlen) :: gen0Name    = ''              !--- First generation ancestor name
    CHARACTER(LEN=maxlen) :: parent      = ''              !--- Parent name
    CHARACTER(LEN=maxlen) :: longName    = ''              !--- Long name (with advection scheme suffix)
    CHARACTER(LEN=maxlen) :: type        = 'tracer'        !--- Type  (so far: 'tracer' / 'tag')
    CHARACTER(LEN=maxlen) :: phase       = 'g'             !--- Phase ('g'as / 'l'iquid / 's'olid)
    CHARACTER(LEN=maxlen) :: component                     !--- Coma-separated list of components (Ex: lmdz,inca)
    INTEGER               :: iadv        = 10              !--- Advection scheme used
    INTEGER               :: iGeneration = -1              !--- Generation number (>=0)
    LOGICAL               :: isAdvected  = .FALSE.         !--- "true" tracers: iadv > 0 . COUNT(     isAdvected) =nqtrue
    LOGICAL               :: isH2Ofamily = .FALSE.         !--- H2O tracers/isotopes/tags. COUNT(.NOT.isH2Ofamily)=nqtottr
    INTEGER               :: iqParent    = 0               !--- Parent index
    INTEGER,  ALLOCATABLE :: iqDescen(:)                   !--- Descendants index (in growing generation order)
    INTEGER               :: nqDescen    = 0               !--- Number of descendants (all generations)
    INTEGER               :: nqChilds    = 0               !--- Number of childs    (first generation)
    INTEGER               :: iso_iGroup  = 0               !--- Isotopes group index in isotopes(:)
    INTEGER               :: iso_iName   = 0               !--- Isotope  name  index in isotopes(iso_iGroup)%trac(:)
    INTEGER               :: iso_iZone   = 0               !--- Isotope  zone  index in isotopes(iso_iGroup)%zone(:)
    INTEGER               :: iso_iPhase  = 0               !--- Isotope  phase index in isotopes(iso_iGroup)%phas
    TYPE(keys_type)       :: keys                          !--- <key>=<val> pairs vector
  END TYPE trac_type
!------------------------------------------------------------------------------------------------------------------------------
  TYPE :: isot_type                                        !=== TYPE FOR AN ISOTOPES FAMILY DESCENDING ON TRACER "parent"
    CHARACTER(LEN=maxlen)              :: parent           !--- Isotopes family name (parent tracer name ; ex: H2O)
    LOGICAL                            :: check=.FALSE.    !--- Triggering of the checking routines
    TYPE(keys_type),       ALLOCATABLE :: keys(:)          !--- Isotopes keys/values pairs list     (length: niso)
    CHARACTER(LEN=maxlen), ALLOCATABLE :: trac(:)          !--- Isotopes + tagging tracers list     (length: ntiso)
    CHARACTER(LEN=maxlen), ALLOCATABLE :: zone(:)          !--- Geographic tagging zones names list (length: nzone)
    CHARACTER(LEN=maxlen)              :: phase = 'g'      !--- Phases list: [g][l][s]              (length: nphas)
    INTEGER                            :: niso  = 0        !--- Number of isotopes, excluding tagging tracers
    INTEGER                            :: nzone = 0        !--- Number of geographic tagging zones
    INTEGER                            :: ntiso = 0        !--- Number of isotopes, including tagging tracers
    INTEGER                            :: nphas = 0        !--- Number phases
    INTEGER,               ALLOCATABLE :: iTraPha(:,:)     !--- Idx in "trac(1:niso)" = f(name(1:ntiso)),phas)
                                                           !---        "iTraPha" former name: "iqiso"
    INTEGER,               ALLOCATABLE :: iZonIso(:,:)     !--- Idx in "trac(1:ntiso)" = f(zone, name(1:niso))
                                                           !---        "iZonIso" former name: "index_trac"
  END TYPE isot_type

END MODULE trac_types_mod
