
#define DEBUG_IO
#undef DEBUG_IO
SUBROUTINE advtrac_loc(pbarug, pbarvg, wg, p, massem, q, teta, pk)
   !     Auteur :  F. Hourdin
   !
   !     Modif. P. Le Van     (20/12/97)
   !            F. Codron     (10/99)
   !            D. Le Croller (07/2001)
   !            M.A Filiberti (04/2002)
   !
   USE infotrac,     ONLY: nqtot, tracers, ok_iso_verif
   USE control_mod,  ONLY: iapp_tracvl, day_step, planet_type
   USE comconst_mod, ONLY: dtvr
   USE parallel_lmdz
   USE Write_Field_loc
   USE Write_Field
   USE Bands
   USE mod_hallo
   USE Vampir
   USE times
   USE advtrac_mod, ONLY: finmasse

   IMPLICIT NONE
   !
   include "dimensions.h"
   include "paramet.h"
   include "comdissip.h"
   include "comgeom2.h"
   include "description.h"
!   include "iniprint.h"

   !---------------------------------------------------------------------------
   !     Arguments
   !---------------------------------------------------------------------------
   REAL, INTENT(IN) ::  pbarug(ijb_u:ije_u,llm)
   REAL, INTENT(IN) ::  pbarvg(ijb_v:ije_v,llm)
   REAL, INTENT(IN) ::      wg(ijb_u:ije_u,llm)
   REAL, INTENT(IN) ::       p(ijb_u:ije_u,llmp1)
   REAL, INTENT(IN) ::  massem(ijb_u:ije_u,llm)
   REAL, INTENT(INOUT) ::    q(ijb_u:ije_u,llm,nqtot)
   REAL, INTENT(IN) ::    teta(ijb_u:ije_u,llm)
   REAL, INTENT(IN) ::      pk(ijb_u:ije_u,llm)
   !---------------------------------------------------------------------------
   !     Ajout PPM
   !---------------------------------------------------------------------------
   REAL :: massebx(ijb_u:ije_u,llm), masseby(ijb_v:ije_v,llm)
   !---------------------------------------------------------------------------
   !     Variables locales
   !---------------------------------------------------------------------------
   INTEGER :: ij, l, iq, iiq, iadv
   REAL(KIND=KIND(1.d0)) :: t_initial, t_final, tps_cpu
   REAL :: zdp(ijb_u:ije_u), zdpmin, zdpmax
   INTEGER, SAVE :: iadvtr=0
!$OMP THREADPRIVATE(iadvtr)
   EXTERNAL  minmax

   !---------------------------------------------------------------------------
   !     Rajouts pour PPM
   !---------------------------------------------------------------------------
   INTEGER :: indice, n
   REAL :: dtbon                       ! Pas de temps adaptatif pour que CFL<1
   REAL :: CFLmaxz, aaa, bbb           ! CFL maximum
   REAL, DIMENSION(iim,jjb_u:jje_u,llm) :: unatppm, vnatppm, fluxwppm
   REAL ::    qppm(iim*jjnb_u,llm,nqtot)
   REAL ::   psppm(iim,jjb_u:jje_u)    ! pression  au sol
   REAL, DIMENSION(llmp1) :: apppm, bpppm
   LOGICAL, SAVE :: dum=.TRUE., fill=.TRUE.
   INTEGER :: ijb, ije, ijbu, ijbv, ijeu, ijev, j
   TYPE(Request),SAVE :: testRequest
!$OMP THREADPRIVATE(testRequest)

! Test sur l'eventuelle creation de valeurs negatives de la masse
   ijb = ij_begin; IF(pole_nord) ijb = ij_begin+iip1
   ije = ij_end;   IF(pole_sud)  ije = ij_end-iip1

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
   DO l=1,llm-1
      DO ij = ijb+1,ije
         zdp(ij) = pbarug(ij-1,l)    - pbarug(ij,l) &
                 - pbarvg(ij-iip1,l) + pbarvg(ij,l) &
                 +     wg(ij,l+1)    -     wg(ij,l)
      END DO
! ym  ---> pourquoi jjm-1 et non jjm ? a cause du pole ?
!     CALL SCOPY( jjm -1 ,zdp(iip1+iip1),iip1,zdp(iip2),iip1 )
      DO ij = ijb,ije-iip1+1,iip1
         zdp(ij)=zdp(ij+iip1-1)
      END DO
      DO ij = ijb,ije
         zdp(ij)= zdp(ij)*dtvr/ massem(ij,l) 
      END DO 
!     CALL minmax ( ip1jm-iip1, zdp(iip2), zdpmin,zdpmax )
! ym ---> eventuellement a revoir
      CALL minmax( ije-ijb+1, zdp(ijb), zdpmin,zdpmax )
      IF(MAX(ABS(zdpmin),ABS(zdpmax)) >0.5) &
         WRITE(*,*)'WARNING DP/P l=',l,'  MIN:',zdpmin,'   MAX:', zdpmax
   END DO
!$OMP END DO NOWAIT

   !---------------------------------------------------------------------------
   !   Advection proprement dite (Modification Le Croller (07/2001)
   !---------------------------------------------------------------------------

   !---------------------------------------------------------------------------
   !   Calcul des moyennes basees sur la masse
   !---------------------------------------------------------------------------
!ym   CALL massbar_p(massem,massebx,masseby)
!ym   ----> Normalement, inutile pour les schemas classiques
!ym   ----> Reverifier lors de la parallelisation des autres schemas

#ifdef DEBUG_IO    
   CALL WriteField_u('massem',massem)
   CALL WriteField_u('wg',wg)
   CALL WriteField_u('pbarug',pbarug)
   CALL WriteField_v('pbarvg',pbarvg)
   CALL WriteField_u('p_tmp',p)
   CALL WriteField_u('pk_tmp',pk)
   CALL WriteField_u('teta_tmp',teta)
   DO iq=1,nqtot
      CALL WriteField_u('q_adv'//trim(int2str(iq)),q(:,:,iq))
   END DO
#endif

!          
!  CALL Register_Hallo_v(pbarvg,llm,1,1,1,1,TestRequest)
!  CALL SendRequest(TestRequest)
!!$OMP BARRIER
!  CALL WaitRequest(TestRequest)
!$OMP BARRIER

!  WRITE(*,*) 'advtrac 157: appel de vlspltgen_loc'
   CALL vlspltgen_loc(q, 2., massem, wg, pbarug, pbarvg, dtvr, p, pk, teta )

#ifdef DEBUG_IO     
   DO iq = 1, nqtot
      CALL WriteField_u('q_adv'//trim(int2str(iq)),q(:,:,iq))
   END DO
#endif
         
   GOTO 1234     
   !-------------------------------------------------------------------------
   !       Appel des sous programmes d'advection
   !-------------------------------------------------------------------------
   DO iq = 1, nqtot
!     CALL clock(t_initial)
      IF(tracers(iq)%parent /= 'air') CYCLE
      iadv = tracers(iq)%iadv
      !-----------------------------------------------------------------------
      SELECT CASE(iadv)
      !-----------------------------------------------------------------------
         CASE(0); CYCLE
         !--------------------------------------------------------------------
         CASE(10)  !--- Schema de Van Leer I MUSCL
         !--------------------------------------------------------------------
!           WRITE(*,*) 'advtrac 239: iq,q(1721,19,:)=',iq,q(1721,19,:)     
!LF         CALL vlsplt_p(q(1,1,iq),2.,massem,wg,pbarug,pbarvg,dtvr)

         !--------------------------------------------------------------------
         CASE(14)  !--- Schema "pseuDO amont" + test sur humidite specifique
                   !--- pour la vapeur d'eau. F. Codron
         !--------------------------------------------------------------------
!           WRITE(*,*) 'advtrac 248: iq,q(1721,19,:)=',iq,q(1721,19,:)
            STOP 'advtrac : appel a vlspltqs :schema non parallelise'
!LF         CALL vlspltqs_p(q(1,1,1),2.,massem,wg,pbarug,pbarvg,dtvr,p,pk,teta )

         !--------------------------------------------------------------------
         CASE(12)  !--- Schema de Frederic Hourdin
         !--------------------------------------------------------------------
            STOP 'advtrac : appel a vlspltqs :schema non parallelise'
            CALL adaptdt(iadv,dtbon,n,pbarug,massem)   ! pas de temps adaptatif
            IF(n > 1) WRITE(*,*) 'WARNING horizontal dt=',dtbon,'dtvr=',dtvr,'n=',n
            DO indice=1,n
              CALL advn(q(1,1,iq),massem,wg,pbarug,pbarvg,dtbon,1)
            END DO

         !--------------------------------------------------------------------
         CASE(13)  !--- Pas de temps adaptatif
         !--------------------------------------------------------------------
            STOP 'advtrac : schema non parallelise'
            CALL adaptdt(iadv,dtbon,n,pbarug,massem)
            IF(n > 1) WRITE(*,*) 'WARNING horizontal dt=',dtbon,'dtvr=',dtvr,'n=',n
            DO indice=1,n
               CALL advn(q(1,1,iq),massem,wg,pbarug,pbarvg,dtbon,2)
            END DO

         !--------------------------------------------------------------------
         CASE(20)  !--- Schema de pente SLOPES
         !--------------------------------------------------------------------
            STOP 'advtrac : schema non parallelise'
            CALL pentes_ini (q(1,1,iq),wg,massem,pbarug,pbarvg,0)

         !--------------------------------------------------------------------
         CASE(30)  !--- Schema de Prather
         !--------------------------------------------------------------------
            STOP 'advtrac : schema non parallelise'
            ! Pas de temps adaptatif
            CALL adaptdt(iadv,dtbon,n,pbarug,massem)
            IF(n > 1) WRITE(*,*) 'WARNING horizontal dt=',dtbon,'dtvr=',dtvr,'n=',n
            CALL prather(q(1,1,iq),wg,massem,pbarug,pbarvg,n,dtbon)

         !--------------------------------------------------------------------
         CASE(11,16,17,18)   !--- Schemas PPM Lin et Rood
         !--------------------------------------------------------------------
     	    STOP 'advtrac : schema non parallelise'
            ! Test sur le flux horizontal
            CALL adaptdt(iadv,dtbon,n,pbarug,massem)   ! pas de temps adaptatif
            IF(n > 1) WRITE(*,*) 'WARNING horizontal dt=',dtbon,'dtvr=',dtvr,'n=',n
            ! Test sur le flux vertical
            CFLmaxz=0.
            DO l=2,llm
               DO ij=iip2,ip1jm
                  aaa=wg(ij,l)*dtvr/massem(ij,l)
                  CFLmaxz=max(CFLmaxz,aaa)
                  bbb=-wg(ij,l)*dtvr/massem(ij,l-1)
                  CFLmaxz=max(CFLmaxz,bbb)
               END DO
            END DO
            IF(CFLmaxz.GE.1) WRITE(*,*) 'WARNING vertical','CFLmaxz=', CFLmaxz
            !----------------------------------------------------------------
            !     Ss-prg interface LMDZ.4->PPM3d (ss-prg de Lin)
            !----------------------------------------------------------------
            CALL interpre(q(1,1,iq),qppm(1,1,iq),wg,fluxwppm,massem, &
                 apppm,bpppm,massebx,masseby,pbarug,pbarvg, &
                 unatppm,vnatppm,psppm)

            !----------------------------------------------------------------
            DO indice=1,n     !--- VL (version PPM) horiz. et PPM vert.
            !----------------------------------------------------------------
               SELECT CASE(iadv)
                  !----------------------------------------------------------
                  CASE(11)
                  !----------------------------------------------------------
                     CALL ppm3d(1,qppm(1,1,iq),psppm,psppm,unatppm,vnatppm,fluxwppm,dtbon, &
                                2,2,2,1,iim,jjp1,2,llm,apppm,bpppm,0.01,6400000,fill,dum,220.)
                  !----------------------------------------------------------
                  CASE(16) !--- Monotonic PPM
                  !----------------------------------------------------------
                     CALL ppm3d(1,qppm(1,1,iq),psppm,psppm,unatppm,vnatppm,fluxwppm,dtbon, &
                                3,3,3,1,iim,jjp1,2,llm,apppm,bpppm,0.01,6400000,fill,dum,220.)
                  !----------------------------------------------------------
                  CASE(17) !--- Semi monotonic PPM
                  !----------------------------------------------------------
                     CALL ppm3d(1,qppm(1,1,iq),psppm,psppm,unatppm,vnatppm,fluxwppm,dtbon, &
                                4,4,4,1,iim,jjp1,2,llm,apppm,bpppm,0.01,6400000, fill,dum,220.)
                  !----------------------------------------------------------
                  CASE(18) !--- Positive Definite PPM
                  !----------------------------------------------------------
                     CALL ppm3d(1,qppm(1,1,iq),psppm,psppm,unatppm,vnatppm,fluxwppm,dtbon, &
                                5,5,5,1,iim,jjp1,2,llm,apppm,bpppm,0.01,6400000,fill,dum,220.)
               END SELECT
            !----------------------------------------------------------------
            END DO
            !----------------------------------------------------------------
            !     Ss-prg interface PPM3d-LMDZ.4
            !----------------------------------------------------------------
            CALL interpost(q(1,1,iq),qppm(1,1,iq))
      !----------------------------------------------------------------------
      END SELECT
      !----------------------------------------------------------------------

      !----------------------------------------------------------------------
      ! On impose une seule valeur du traceur au pole Sud j=jjm+1=jjp1 et Nord j=1
      !----------------------------------------------------------------------
      !  CALL traceurpole(q(1,1,iq),massem)

      !--- Calcul du temps cpu pour un schema donne
      !  CALL clock(t_final)
      !ym  tps_cpu=t_final-t_initial
      !ym  cpuadv(iq)=cpuadv(iq)+tps_cpu

   END DO

1234 CONTINUE
!$OMP BARRIER
   IF(planet_type=="earth") THEN
      ijb=ij_begin
      ije=ij_end
!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)      
      DO l = 1, llm
         DO ij = ijb, ije
            finmasse(ij,l) =  p(ij,l) - p(ij,l+1) 
         END DO
      END DO
!$OMP END DO

      CALL qminimum_loc( q, nqtot, finmasse )

   END IF ! of if (planet_type=="earth")

END SUBROUTINE advtrac_loc

