      SUBROUTINE iotd_ini(fichnom,iim,jjm,llm,prlon,prlat,pcoordv,jour0,mois0,an0,t0,timestep,calendrier)
      IMPLICIT NONE

!=======================================================================
!
!   Auteur:  F. Hourdin
!   -------
!
!   Objet:
!   ------
!   Light interface for netcdf outputs. can be used outside LMDZ
!
!=======================================================================
!-----------------------------------------------------------------------
!   Declarations:
!   -------------

#include "netcdf.inc"
#include "iotd.h"

!   Arguments:
!   ----------

      integer iim,jjm,llm
      real prlon(iim),prlat(jjm),pcoordv(llm),timestep,t0
      INTEGER id_FOCE
      INTEGER jour0,mois0,an0
      CHARACTER*(*) calendrier

      integer corner(4),edges(4),ndim
      real  px(1000)
      character (len=10) :: nom
      real*4 rlon(iim),rlat(jjm),coordv(llm)

!   Local:
!   ------
      CHARACTER*3,DIMENSION(12) :: cmois=(/'JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP','OCT','NOV','DEC'/)
      CHARACTER*10 date0
      CHARACTER*11 date0b

      INTEGER ierr

      integer :: nvarid
      integer, dimension(2) :: id  

      character*(*) fichnom

      real pi

      iotd_ts=timestep
      iotd_t0=t0
      print*,'iotd_ini, ',timestep,iotd_ts
      imax=iim
      jmax=jjm
      lmax=llm
      ! Utile pour passer en real*4 pour les ecritures
      rlon=prlon
      rlat=prlat
      coordv=pcoordv


!-----------------------------------------------------------------------


      pi=2.*asin(1.)

! Define dimensions
    
      ! Create the NetCDF file
      ierr=NF_CREATE(fichnom, NF_CLOBBER, nid)
      ierr=NF_DEF_DIM(nid, "lon", iim, dim_coord(1))
      ierr=NF_DEF_DIM(nid, "lat", jjm, dim_coord(2))
      ierr=NF_DEF_DIM(nid, "lev", llm, dim_coord(3))
      ierr=NF_DEF_DIM(nid,"time",NF_UNLIMITED,dim_coord(4))
      ierr = NF_PUT_ATT_TEXT(nid,NF_GLOBAL,'Conventions',6,"CF-1.1")
      !ierr = NF_PUT_ATT_TEXT(nid,NF_GLOBAL,'file_name',TRIM(fname))
      ierr=NF_ENDDEF(nid)

      ! Switch out of NetCDF Define mode


      ierr=NF_ENDDEF(nid)
!
!  Contol parameters for this run
! ---- longitude -----------

      ierr=NF_REDEF(nid)
      ierr=NF_DEF_VAR(nid,"lon", NF_FLOAT, 1, dim_coord(1),nvarid)
      ierr = NF_PUT_ATT_TEXT(nid,nvarid,'axis',1,'X')
      ierr=NF_PUT_ATT_TEXT(nid,nvarid,'units',12,"degrees_east")
      ierr=NF_ENDDEF(nid)
      ierr=NF_PUT_VAR_REAL(nid,nvarid,rlon)
       print*,ierr

! ---- latitude ------------
      ierr=NF_REDEF(nid)
      ierr=NF_DEF_VAR(nid, "lat", NF_FLOAT, 1, dim_coord(2),nvarid)
      ierr = NF_PUT_ATT_TEXT(nid,nvarid,'axis',1,'Y')
      ierr=NF_PUT_ATT_TEXT(nid,nvarid,'units',13,"degrees_north")
      ierr=NF_ENDDEF(nid)
      ierr=NF_PUT_VAR_REAL(nid,nvarid,rlat)
!
! ---- vertical ------------
      ierr=NF_REDEF(nid)
      ierr=NF_DEF_VAR(nid, "lev", NF_FLOAT, 1,dim_coord(3),nvarid)
      ierr=NF_PUT_ATT_TEXT(nid,nvarid,"long_name",10,"vert level")
      if ( coordv(2)>coordv(1) ) then
         ierr=NF_PUT_ATT_TEXT(nid,nvarid,"long_name",10,"pseudo-alt")
         ierr=NF_PUT_ATT_TEXT(nid,nvarid,'positive',2,"up")
      else
         ierr=NF_PUT_ATT_TEXT(nid,nvarid,"long_name",8,"pressure")
         ierr = NF_PUT_ATT_TEXT (nid,nvarid,'positive',4,"down")
      endif
      ierr=NF_ENDDEF(nid)
      ierr=NF_PUT_VAR_REAL(nid,nvarid,coordv)

!
! ---- time ----------------
      ierr=NF_REDEF(nid)
      ! Define the 'time' variable
      ierr=NF_DEF_VAR(nid, "time", NF_FLOAT, 1, dim_coord(4),nvarid)
!     ! Add attributes
      ierr = NF_PUT_ATT_TEXT(nid,nvarid,'axis',1,'T')
      ierr = NF_PUT_ATT_TEXT(nid,nvarid,'standard_name',4,'time')
      WRITE(date0,'(i4.4,"-",i2.2,"-",i2.2)') an0,mois0,jour0
      ierr=NF_PUT_ATT_TEXT(nid, nvarid,'units',33, &
     & "seconds since "//date0//" 00:00:00")
      ierr = NF_PUT_ATT_TEXT(nid,nvarid,'calendar',9,calendrier)
      !ierr = NF_PUT_ATT_TEXT(nid,nvarid,'calendar',4,'360d')
      ierr = NF_PUT_ATT_TEXT(nid,nvarid,'title',4,'Time')
      ierr = NF_PUT_ATT_TEXT(nid,nvarid,'long_name',9,'Time axis')
      WRITE(date0b,'(i4.4,"-",a3,"-",i2.2)') an0,cmois(mois0),jour0
      ierr = NF_PUT_ATT_TEXT(nid,nvarid,'time_origin',20, &
     &        date0b//' 00:00:00')
      ierr=NF_ENDDEF(nid)


      END
