#!/bin/bash

set -vx

#####################################################################
# Choix eventuel de la version : branche ou trunk et svn particuliere
#####################################################################

branche=IPSLCM6.0.15
branche=trunk
rev="-r r3258"
rev=""
latest=""
#latest=20210512 # Pour imposer de tester la convergence avec une version passee

TMP_D=/tmp/lmdz ; mkdir -p $TMP_D

if [ $branche != trunk ] ; then
    echo cas non prevu
#     exit
fi

check=1 # On verifie un certain nombre de choses.
force=0

optionnel=" -cpp ORCHIDEE_NOZ0H "

local=`pwd`
while (($# > 0)) ; do
  case $1 in
      "-h") cat <<fin
USAGE creation_modipsl.sh
Crée les archives du modele pour installation par install.sh
-force : pour créeer une seconde version le meme jour
fin
        exit ;;
      "-force") force=1 ; shift ;;
      "-r") rev="-r $2" ; shift ; shift ;;
      "-b") branche="$2" ; shift ; shift ;;
      "-latest") latest=$2 ; shift ; shift ;;
      *) echo option non prevue ; ./creation_modipsl.sh -h ; exit
  esac
done

# machine_cible=erskine.lmd.jussieu.fr
#machine_cible=carey
machine_cible=lmdz-cq
if [ "`hostname`" != "$machine_cible" ] ; then echo Lancer sur $machine_cible ; exit ; fi
set -ex

###########################################################################
# localisation svn
###########################################################################
# cvs -d :pserver:lmdzbrowse@cvs.lmd.jussieu.fr:/home/cvsroot checkout LMDZ5 
LMDZv=LMDZ6
if [ $LMDZv = LMDZ6 ] ; then
   LMDZ=LMDZ
else
   LMDZ=LMDZ5
fi

if [ $branche == trunk ] ; then
   branchepath=trunk
else
   branchepath=branches/$branche
fi
svnmodel=http://svn.lmd.jussieu.fr/LMDZ/$LMDZv/$branchepath


##########################################################################
# Recuperation des infos svn pour le choix du nom du modele
##########################################################################
echo svn info $rev $svnmodel :
svn info $rev $svnmodel
datesvn=`svn info $rev $svnmodel | grep "Last Changed Date" | awk ' { print $4 } ' | sed -e 's/-//g'`
echo DATESVN $datesvn

if [  "$datesvn" = "" ] ; then
#    DATESVN vide
    datesvn=`svn info http://svn.lmd.jussieu.fr/LMDZ/$LMDZv/$branchepath $rev | grep 'Date de la dern' | awk ' { print $6 } '  | sed -e 's/-//g'`
fi
echo datesvn $datesvn
version=$datesvn.$branche
echo version $version

##########################################################################
# Sauvegarde eventuelle de la version precedente si deux versions
# sont creees le meme jour
##########################################################################
if [ -f modipsl.$version.tar.gz ] ; then
   if [ $force = 1 ] ; then
      if [ -d $TMP_D/LMDZ$version ] ; then mv -f $TMP_D/LMDZ$version $TMP_D/LMDZ${version}_$$ ; fi
      cd /home/users/lmdz/WWW/RESUBENCH/$branche/gfortran
      if [ -f ${datesvn} ] ; then mv -f ${datesvn} ${datesvn}_$$ ; fi
      ln -sf ${datesvn}_$$ latest
      cd $local
      if [ -f modipsl.$version.tar.gz ] ; then mv modipsl.$version.tar.gz modipsl.${version}_$$.tar.gz ; fi
      echo ${datesvn} ${datesvn}_$$
    else
      echo Le fichier modipsl.$version.tar.gz existe deja
      echo Preparer un changement automatique de nom pour automatiser
      echo la creation de plusieurs versions dans la journee
      exit
    fi
fi

if [ "$latest" != "" ] ; then
   cd /home/users/lmdz/WWW/RESUBENCH/$branche/gfortran
   \rm -f latest
   ln -s $latest latest
fi

#####################################################################
# Les fichiers modipsl.vN.tar.gz contiennent des versions successives
# de IOIPSL
# Les versions modipsl.20080305.v5.tar.gz contiennent des versions
# successives avec de modipsl les dates correspondant a des versions
# successives de LMDZ4 puis LMDZ5
#####################################################################
vorig=v8  # updated version of IOIPSL 04/04/2012, including 'rebuild' script
vorig=v9  # updated version of IOIPSL 07/08/2013, modfication de AA_male.ldef pour g95
vorig=v10 # 'rebuild' is reintroduced in v9 . Was lost even in v8 ... (FH)
vorig=v11 # update ORCHIDEE version to r2247, changes needed in install.sh for ORCHIDEE compilation
vorig=v12 # modification AA_make.gdef pour ada. on garde g95 pour install alors qu'il a disparu dans modipsl
vorig=v13 # mise a jour ORCHIDEE (r3013) pour problème d'interface après le rajout de sinang=rmu0 dans surf_land_orchidee_mod.F90
vorig=v14 # dans ioipsl/histcom.f9, nb_var_max : 600 -> 1OOO, nb_zax_max : 5 -> 100, flio_max_dims : 15 -> 50 pour rebuild cosp
vorig=v15 # modifications pour tenir compte de jean-zay nouvelle machine Idris

modipsltar=modipsl.$vorig.tar

##### tmpdir=/tmp/tmpmodipsl$$
tmpdir=$local/tmpmodipsl$$
mkdir -p $tmpdir
cd $tmpdir
if [ -f /u/lmdz/WWW/Distrib/$modipsltar.gz ] ; then
   cp /u/lmdz/WWW/Distrib/$modipsltar.gz .
else
   wget http://www.lmd.jussieu.fr/~lmdz/Distrib/$modipsltar.gz
fi

tar xvf $modipsltar.gz
#gzip -9 $modipsltar

cd modipsl/modeles



###########################################################################
# On effectue le svn checkout sur une machine avec un ancien svn
# pour eviter que les utilisateurs se retrouvent avec un svn plus ancien
# que celui sur lequel la version a été créée.
echo Premier svn checkout $rev $svnmodel $LMDZ
ssh butler ' ( cd '`pwd`' ; svn checkout '$rev' '$svnmodel' '$LMDZ' ) '
###########################################################################


## Modif Ehouarn: on garde les sources d'IOIPSL de $modipsltar 
#mkdir -p IOIPSL
#cd IOIPSL
#\rm -r src
# cp -r /u/lmdz/WWW/Distrib/IOIPSL/src_fairhead_v3c src
# A partir du  13/10/2008
#cp -r /u/lmdz/WWW/Distrib/IOIPSL/src_20081014 src
#cd ../../..

cd ../..
echo $version
tar cvf modipsl.$version.tar modipsl


gzip modipsl.$version.tar
mv modipsl.$version.tar.gz ~/WWW/Distrib

## en attendant la bascule sur orchide CMIP, on fait un modipsl.tar avec la nouvelle version d'orchidee
modipsltar=modipsl_orc_cmip6.$vorig.tar
tmpdir=$local/tmpmodipslcmip6$$
mkdir -p $tmpdir
cd $tmpdir
if [ -f /u/lmdz/WWW/Distrib/$modipsltar.gz ] ; then
   cp /u/lmdz/WWW/Distrib/$modipsltar.gz .
else
   wget http://www.lmd.jussieu.fr/~lmdz/Distrib/$modipsltar.gz
fi
tar xvf $modipsltar.gz
cd modipsl/modeles

echo Second svn checkout $rev $svnmodel $LMDZ
ssh butler ' ( cd '`pwd`' ; svn checkout '$rev' '$svnmodel' '$LMDZ' ) '
cd ../..
echo $version
tar cvf modipsl_orc_cmip6.$version.tar modipsl


gzip modipsl_orc_cmip6.$version.tar
mv modipsl_orc_cmip6.$version.tar.gz ~/WWW/Distrib

#######

cd  ~/WWW/Distrib
ln -sf modipsl.$version.tar.gz modipsl.$branche.tar.gz
ln -sf modipsl_orc_cmip6.$version.tar.gz modipsl_orc_cmip6.$branche.tar.gz
cd ~/WWW/pub/src

# Ajout pour la nouvelle arborescence
ln -sf ../../Distrib/modipsl.$version.tar.gz .
ln -sf modipsl.$version.tar.gz modipsl.$branche.tar.gz
ln -sf ../../Distrib/modipsl_orc_cmip6.$version.tar.gz .
ln -sf modipsl_orc_cmip6.$version.tar.gz modipsl_orc_cmip6.$branche.tar.gz
cd  ~/WWW/Distrib


if [ $check = 1 ] ; then
./check_version.sh $version >| WORK/check.out 2>&1
#./check_version_old.sh $version >| WORK/check.out 2>&1
tmpcheck=`tail -1 WORK/check.out`
echo "$tmpcheck" >> Correspondance
echo "$tmpcheck" >> LISMOI.$branche

\cp -f LISMOI.trunk ../pub/src/Readme


# mail -r lmdz-owner -s "Nouvelle version pour install.sh" poihl@lmd.jussieu.fr <<eod
ssh lmdz@django "mail -s 'Nouvelle version pour install.sh' lmdz-commit@listes.lmd.ipsl.fr <<eod

disponible sur
https://www.lmd.jussieu.fr/~lmdz/Distrib/modipsl.$version.tar.gz

      Test local LMD network, gfortran, 48x36x19
      ==========================================

install version         SVN     Bench   Conv.   1+1=2   Init
                                run     Nnum.      &
                                        /prev.  mpiXomp

$tmpcheck


                                        ||
                                        \/

S/s/-: 3D standard physics  Converging/runing/not runing
N/n/-: -  new        -                  -
D/d/-: new with debug                   -
U/u/-: unicolonne                       -
I/i/-: isotope                          -
OK <=> SNDUI

eod
"

fi
