#!/bin/bash
# $Id: check_version.sh 3955 2021-07-05 17:00:15Z fairhead $

#########################################################################
# Verification de a convergence du modele par rapport aux versions
# precedentes
# + 1+1=2
#########################################################################


version_ref=latest
resolution=48x36x19
resolution=48x36x39 #20160622 : nouveau bench avec deux versions de la physique
compilo=gfortran
parallel=none
parallel=mpi_omp
justcheck=0 # just compare results not writing of results in RESUBENCH
tmpdir=/tmp/`whoami` ; mkdir -p $tmpdir

if [ `whoami` = lmdz ] ; then
   get="ln -sf /u/lmdz/WWW/pub"
   getold="ln -sf /u/lmdz/WWW/Distrib"
else
   get="wget https://www.lmd.jussieu.fr/~lmdz/pub"
   getold="wget https://www.lmd.jussieu.fr/~lmdz/Distrib"
fi

if [ `hostname` != cameron.lmd.jussieu.fr ] ; then
    echo Machine non prevu
fi


# Option pour le debug du script check_version lui meme qui consiste a ne
# pars reexecuter l'installation et les simulations mais a simplement
# refaire les diff sur des simulations existantes.
diagonly=0



while (($# > 0))
  do
  case $1 in
      "-h") cat <<fin
check_version.sh [-h] version [version_ref]
version is the name of the version of LMDZ to be checked modipsl.version.tar.gz
version_ref is the version to be compared with.
Default "latest".
enfo
fin
          exit;;

      "-c")
          compilo="$2" ; shift ; shift ;;
      "-j")
          justcheck="$2" ; shift ; shift ;;
      *)
          version="$1" ; shift ; if [ "$#" = 1 ] ; then version_ref=$1 ; shift ; fi ;;
   esac
done


# branche=`echo $version | cut -d. -f2`
branche=`echo $version |cut -c 10-`
datelmdz=`echo $version | cut -d. -f1`
echo version $version $branche $datelmdz

RESU_D=~/WWW/RESUBENCH/$branche/$compilo
mkdir -p $RESU_D
resubench=$RESU_D/$datelmdz
latest=$RESU_D/$version_ref
echo version_ref $version_ref $latest
ls -l  $latest

# recuperation de la version a laquelle on compare pour le message final :
comparea=`ls -ld $RESU_D/$version_ref | awk -F/ ' { print $NF } '`

#  LANCEMENT D UN CERTAIN NOMBRE DE TESTS


# Edition de install.sh, install.sh avec bench 48x36x19
cd $tmpdir
MODEL=$tmpdir/LMDZ$version
if [ $diagonly = 0 ] ; then
  \rm -f install_lmdz.sh ; $get/install_lmdz.sh ; chmod +x install_lmdz.sh
  ./install_lmdz.sh -v $version -d $resolution -SCM -parallel $parallel -veget CMIP6
fi

######################################################
# Sauvegarde du 1D
######################################################
outf=$MODEL/1D/EXEC/NPv6.1L79/ARMCU/REF/restartphy.nc
if [ -f $outf ] ; then
    if [ $justcheck = 0 ] ; then
	mkdir -p $resubench/ARMCU/REF
	cp $MODEL/1D/EXEC/NPv6.1L79/ARMCU/REF/restartphy.nc $resubench/ARMCU/REF/
    fi
#   cmp -s $resubench/ARMCU/REF/restartphy.nc $latest/ARMCU/REF/restartphy.nc
    cmp -s $MODEL/1D/EXEC/NPv6.1L79/ARMCU/REF/restartphy.nc $latest/ARMCU/REF/restartphy.nc
    if [ $? = 0 ] ; then converge1D=U ; else converge1D=u ; fi
else
   converge1D=-
fi


######################################################
BENCH=BENCH$resolution
cd $MODEL/modipsl/mod*/LMD*/$BENCH
echo BENCH FINI
ls -lrt
pwd





if [ -f restartphy.nc ] ; then
#########################################################################
   echo Verification de la convergence avec la version precedente
#########################################################################
# Faite soit sur les restart.nc soit sur une exctraction de ps.nc
# A une epoque, ne marchait paps avec les restart a cause des traceurs.
# Le 2014/01/30, ne marchait plus avec ps.nc car les axes de lattiudes
# s'étaient inversés pour une raison inconnue.
# 2016/06/21 : on utilise deux versions de la physique pour le test.

# Aide a l'interpretation de resultats problematiques
#    Les resultats de la simu ancienne physique sont directement 
#      dans BENC*
#    Les resultats de la nouvelle physique sont dans SIM1 utilise
#      pour 1+1=2
#    Les resultats de la simulation debug sont dans SIMD

   if [ $justcheck = 0 ] ; then mkdir -p $resubench/$BENCH; fi
   if [ -f restartphy.nc ] ; then
       if [ $justcheck = 0 ] ; then
	   ncks -M -m -h -v ps -O restart.nc $resubench/$BENCH/ps.nc
	   cp restart.nc $resubench/$BENCH/restart.nc
       fi
#       cmp -s $resubench/$BENCH/restart.nc $latest/$BENCH/restart.nc
       cmp -s ./restart.nc $latest/$BENCH/restart.nc
      if [ $? = 0 ] ; then converge=S ; else converge=s ; fi
   else
      converge=-
   fi

#########################################################################
   echo Verification de 1+1=2
#########################################################################
# 2016/06/21 : 1+1=2 est fait sur la nouvelle physique
# Permet de tester aussi la convergence numérique

   suf=NPv5.5
   suf=NPv6.0.14splith
#   cp -f config.def_oraer config.def
   sed -e 's/VEGET=y/VEGET=n/' config.def_oraer > config.def
   if [ -f physiq.def_$suf ] ; then \cp -f physiq.def_$suf physiq.def ; fi
   if [ $diagonly = 0 ] ; then 
       $getold/unpun.sh
       chmod +x unpun.sh ; ./unpun.sh -parallel $parallel
   fi
   cmp -s SIM2/ps_end.nc SIM1+1/ps_end.nc
   if [ $? = 0 ] ; then
       unpun=OK
   else
       unpun=-
   fi

#########################################################################
   echo Test en fonction du nombre de processeurs
#########################################################################
   if [ "$parallel" == "mpi_omp" ] ; then
      mkdir SIM1_41
      cd SIM1_41
      ln -s ../SIM1/start* ../SIM1/limit* ../SIM1/sechiba_rest_in.nc ../SIM1/aer*nc ../SIM1/*def .
      ../run_local.sh 4 1 ../gcm.e > listing
      cd ..
      cmp -s SIM1/restart.nc SIM1_41/restart.nc
      if [ $? = 0 ] ; then
          if [ "$unpun" = "OK" ] ; then
             unpun=OK2
          else
             unpun=-OK
          fi
      else
          unpun=${unpun}-
      fi
   fi

# 2016/06/21 : comparaison des versions nouvelles physique (dans SIM1)
#   if [ -f restartphy.nc ] ; then  Correction 2017/04/26
   if [ -f SIM1/restartphy.nc ] ; then
       if [ $justcheck = 0 ] ; then
	   ncks -M -m -h -v ps -O SIM1/restart.nc $resubench/$BENCH/ps$suf.nc
	   cp SIM1/restart.nc $resubench/$BENCH/restart$suf.nc
       fi
       \rm sechiba_out_2.nc sechiba_history.nc sechiba_rest_out.nc
#       cmp -s $resubench/$BENCH/restart$suf.nc $latest/$BENCH/restart$suf.nc
       cmp -s SIM1/restart.nc $latest/$BENCH/restart$suf.nc
      if [ $? = 0 ] ; then convergeNP=N ; else convergeNP=n ; fi
   else
      convergeNP=-
   fi

#########################################################################
   echo Verification en mode debug + parallele
#########################################################################
   if [ -f compilegcm.sh ] ; then
      mv gcm.e gcm.install
      ./compilegcm.sh -debug
      mkdir SIMD
      cd SIMD
      ln -s ../SIM1/start* ../SIM1/limit* ../SIM1/sechiba_rest_in.nc ../SIM1/aer*nc ../SIM1/*def .
      ../run_local.sh 2 2 ../gcm.e > listing 2>&1
      cd ../
      suf=D
      if [ -f SIMD/restartphy.nc ] ; then
	  if [ $justcheck = 0 ] ; then
              ncks -M -m -h -v ps -O SIMD/restart.nc $resubench/$BENCH/ps$suf.nc
              cp SIMD/restart.nc $resubench/$BENCH/restart$suf.nc
	  fi
          cmp -s SIMD/restart.nc $latest/$BENCH/restart$suf.nc
          if [ $? = 0 ] ; then convergeD=D ; else convergeD=d ; fi
      else
         convergeD=-
      fi
   fi
#########################################################################
   echo Verification des isotopes
#########################################################################
   set -vx
   cd ..
   ./makelmdz_fcm  -arch local -j 8 -rrtm true  -d 48x36x39 -v false -p lmdiso -isotopes true -isoverif true gcm
   cd $BENCH 
   if [ -f ../bin/gcm_48x36x39_phylmdiso_seq_iso_isoverif.e ] ; then
	  mkdir ISO
	  cp ../bin/gcm_48x36x39_phylmdiso_seq_iso_isoverif.e ISO/gcm_iso.e
	  cd ISO
          ln -s ../SIM1/start* ../SIM1/limit* ../SIM1/aer*nc .
	  cp ../SIM1/physiq.def ../SIM1/gcm.def ../SIM1/vert.def . 
	  for def in gcm run config traceur physiq
	  do
	      cp ../${def}_iso.def ${def}.def
	  done
	  cp ../iso.def .
	  ./gcm_iso.e  > listing 2>&1
	  cd ..
	  suf=I
	  if [ -f ISO/restartphy.nc ] ; then
	      if [ $justcheck = 0 ] ; then
		  cp SIMD/restart.nc $resubench/$BENCH/restart$suf.nc
	      fi
              cmp -s SIMD/restart.nc $latest/$BENCH/restart$suf.nc
              if [ $? = 0 ] ; then convergeI=I ; else convergeI=i ; fi
	  else
              convergeI=-
	  fi
   fi

#########################################################################
   echo Verification de initialisation
###############################################################y##########
   rm -rf ../INIT
   mkdir ../INIT
   cp *def ../INIT
   cd ../INIT
   pwd
   $getold/initialisation.sh
   sed -e 's/grid_resolution=48x36x39/grid_resolution='$resolution'/' initialisation.sh > ini.sh
   chmod +x ini.sh ; ./ini.sh
   if [ -f limit.nc ] ; then
      var=Tsoil01srf01
      if [ $justcheck = 0 ] ; then
	  mkdir -p $resubench/START$resolution
	  ncks -M -m -h -v $var startphy.nc -O  $resubench/START$resolution/$var.nc
	  cp startphy.nc $resubench/START$resolution/
      fi
#!     cmp -s  $resubench/START$resolution/$var.nc  $latest/START$resolution/$var.nc
       cmp -s  startphy.nc  $latest/START$resolution/startphy.nc
      if [ $? = 0 ] ; then
          init=OK
      else
          init=noc
      fi
   else
      init=-
   fi

########################################################################
   echo end of test cases
########################################################################   
   bench=OK
else
   echo PROBLEME : LE BENCH N EST PAS ALLE AU BOUT
   bench=-
fi

if [ $justcheck = 0 ] ; then
    latest=$RESU_D/latest
    \rm -f $latest
    ln -sf  $resubench $latest
fi


cd $MODEL/m*/m*/
LMDZ=`\ls -d LMD*` #Nom du modele LMDZ sur modeles/ : LMDZ4, LMDZ5, LMDZ

svn upgrade # Il faut mettre à jour le svn si la version sur 
            # laquelle le checkout a ete fait est plus ancienne
            # ce qu'on souhaite par ailleurs pour pouvoir ensuite
            # commettre depuis une version ancienne de svn (comme celles
            # des SL du réseau local
svnrel=`svn info $LMDZ | grep 'Changed Rev' | head -1 | awk ' { print $4 } '`
#FH 20160822
if [ "$svnrel" = "" ] ; then
  svnrel=`svn info $LMDZ | grep vision | head -1 | awk ' { print $2 } '`
fi

ccc=$converge$convergeNP$convergeD$converge1D$convergeI
if [ "$ccc" = "SNDUI" ] ; then ccc="OK " ;  fi


echo $version'		'$svnrel'	'$bench'	'$ccc '	'$unpun'	'$init'   (ref:' $comparea ')'

exit
rm -fr $MODEL
