#!/bin/bash 

comp=$1

local=`pwd -P`
runstxt=$local/runs.txt
echo runstxt= $runstxt

login=`whoami`
login=${login}
DODSDIR=/thredds/ipsl

echo DODSDIR : $DODSDIR
MAIN_SE=$DODSDIR/$login/lmdz/SE
TS_DA=$DODSDIR/$login/lmdz/TS_DA
TS_MO=$DODSDIR/$login/lmdz/TS_MO
MULTIDIR=$DODSDIR/$login/lmdz/MultiSimu

COMP_D=$MULTIDIR/$comp

###
# RUNS= :def.txt
DEF_FILE=$COMP_D/def.txt ; if [ ! -f $DEF_FILE ] ; then echo renseigner $DEF_FILE ; exit ; fi

listsims=""  ; for s  in `awk ' {print $1} ' $DEF_FILE | uniq`          ; do listsims="$listsims $s"    ; done
echo listsims $listsims

DEF_FILE=$COMP_D/def.txt ; if [ ! -f $DEF_FILE ] ; then echo renseigner $DEF_FILE ; exit ; fi

RUNS=""
RUNS=`awk ' {print $1"_"$2 } ' $DEF_FILE`
echo $RUNS
echo listrunss=$RUNS

nrun=0
for run in $RUNS; do
let "nrun = ${nrun} + 1"
done
echo nrun=$nrun

natlas=`wc -l $COMP_D/atlas-def | awk ' { print $1 } '`

nvar=0
il=1
while [ $il -le $natlas ] ; do
   line=`sed -n -e ${il}p $COMP_D/atlas-def`
   seas=`echo $line | awk ' { print $1 } '`
   proj=`echo $line | awk ' { print $2 } '`
   vars=`echo $line | awk ' { print $3 } '`
   varg=`echo $vars | sed -e 's/,/ /g'`

for var in $varg; do
let "nvar = ${nvar} + 1"
done
echo il=$il nvar=$nvar
(( il = $il + 1 ))
done

let ngpervar=4
let "ngrafs = ${nrun} * ${nvar} * ${ngpervar}"

echo ngrafs=${ngrafs}

let ntpervarsfact=75
let sfact=10
let "nts = ${ngrafs}* ${ntpervar}"
let "nts = ${nts}/${sfact}"

echo
echo ngpervar=$ngpervar est le nombre de graphiques par variable
echo ntpervarsfact=$ntpervarsfact est le temps en secondes pour faire un graphe
echo avec un facteur multiplicatif de $sfact
echo

echo ======================================================= 
echo
echo La production des cartes du Multi-atlas $comp prendra
echo environ $nts secondes
echo
echo ======================================================= 

exit
