!
! $Id: surface_data.F90 3901 2021-05-17 14:05:36Z evignon $
!
MODULE surface_data

  IMPLICIT NONE

  REAL, PARAMETER        :: calice=1.0/(5.1444e+06*0.15)
  REAL, PARAMETER        :: calsno=1./(2.3867e+06*.15)
  
  LOGICAL, SAVE          :: ok_veget      ! true for use of vegetation model ORCHIDEE
  !$OMP THREADPRIVATE(ok_veget)

  CHARACTER(len=10), SAVE :: type_veget   ! orchidee/y/bucket/n/betaclim
  !$OMP THREADPRIVATE(type_veget)

  CHARACTER(len=6), SAVE :: type_ocean    ! force/slab/couple
  !$OMP THREADPRIVATE(type_ocean)

  ! if type_ocean=couple : version_ocean=opa8 ou nemo
  ! if type_ocean=slab   : version_ocean=sicOBS or sicINT or sicNO
  CHARACTER(len=6), SAVE :: version_ocean 
  !$OMP THREADPRIVATE(version_ocean)

  ! Pas de temps couplage atm/oce (en secondes)
  REAL, SAVE             :: t_coupl
  !$OMP THREADPRIVATE(t_coupl)

  ! FOR INLANDSIS:
  !===============
 
   ! 1 for coupling with INLANDSIS
   INTEGER, SAVE          :: landice_opt   ! 1 for coupling with INLANDSIS
  !$OMP THREADPRIVATE(landice_opt)

  ! temperature calculation options within the soil and at the surface
   INTEGER, SAVE          :: iflag_tsurf_inlandsis,iflag_temp_inlandsis 
   !$OMP THREADPRIVATE(iflag_tsurf_inlandsis,iflag_temp_inlandsis)

  ! flags for albedo and roughness calc.
   INTEGER, SAVE          :: iflag_albcalc,iflag_z0m_snow
  !$OMP THREADPRIVATE(iflag_albcalc,iflag_z0m_snow)  

  ! with or without snow module/ blowing snow, ascii outfile
   LOGICAL, SAVE          :: SnoMod,BloMod,ok_outfor 
  !$OMP THREADPRIVATE(SnoMod,BloMod,ok_outfor)    

  ! activate slush, korlyakov snow density, RN z0h calc.
   LOGICAL, SAVE          :: is_ok_slush,is_ok_density_kotlyakov,is_ok_z0h_rn
  !$OMP THREADPRIVATE(is_ok_slush,is_ok_density_kotlyakov,is_ok_z0h_rn) 

  ! activate detection snow/ice layers and option XF discrtet/option runoff AC
   LOGICAL, SAVE          :: ok_zsn_ii,discret_xf,opt_runoff_ac
  !$OMP THREADPRIVATE(ok_zsn_ii,discret_xf, opt_runoff_ac)

  ! value of z0m snow when prescribed and albedo correction term
   REAL, SAVE             :: prescribed_z0m_snow,correc_alb
  !$OMP THREADPRIVATE(prescribed_z0m_snow, correc_alb)

  ! value of sphericity [0-99] and snow grain size [e-4m] for polar buffer snow
  ! layer
   REAL, SAVE             :: buf_sph_pol,buf_siz_pol
  !$OMP THREADPRIVATE(buf_sph_pol,buf_siz_pol)



END MODULE surface_data
