#!/bin/bash
####################################################################
# Frederic Hourdin. 2015/09/07
# Script de calcl de moyennes saisonnieres sur une grille reduite
# en utilisant cdo. Preparation des tracers d'atlas.
####################################################################

login=`whoami`
ulimit -s unlimited
GR=VLR

hostname=`hostname`
if [ ${hostname:0:5} = cicla ] ; then
DODSDIR=/thredds/ipsl
fi
if [ ${hostname:0:5} = camel ] ; then
DODSDIR=/thredds/ipsl
fi
if [ ${hostname:0:5} = irene ] ; then
DODSDIR=
fi
if [ ${hostname:0:5} = jean- ] ; then
DODSDIR=
fi

MAINDIR=$DODSDIR/$login/lmdz

force_create=0

####################################################################
# Interactive options
####################################################################

COMP_D=""
listeseas="JJA,YEAR"
listeseas="JJA,YEAR,DJF"
listesim=""
listeseas="YEAR,DJF,JJA,JJAS"


while (($# > 0))
   do
   case $1 in
     "-h") cat <<........fin
        Usage : cmor.sh [ -s sim1,sim2... -seas DJF,YEAR -f]
        -f forces execution even if the output file already exists
........fin
        shift ; exit ;;
     "-s") listesim=`echo $2 | sed -e 's/,/ /g'` ; shift ; shift ;;
     "-f") force_create=1 ; shift ;;
     "-comp") COMP_D=/thredds/ipsl/fabric/lmdz/MultiSimu/$2 ; shift ; shift ;;
     "-seas") listeseas=$2 ; shift ; shift ;;
     *) ./cmor.sh -h ; shift ; exit ;;
   esac
done

i=1
while [ "`ps -ux | grep season.sh | grep bin | wc -l`" != "2" ] ; do
   echo Mise en attente de season.sh deja en cours d execution $i
   sleep 2 ; (( i = $i + 1 ))
   if [ "$i" = "3600" ] ; then exit ; fi
done


####################################################################
# About the grid
####################################################################
case $GR in
   VLR) remapf="/home/hourdin/CMIP5/Anal/Feb21_2012_tsol_OBS_AVE_ANM.nc" ;;
   *) echo "grille $GR non prevue" ; exit
esac
mkdir -p $MAINDIR/$GR/GR
if [ ! -f $MAINDIR/$GR/GR/LAT ] ; then
   ncks -v LAT $remapf  | grep 'LAT\[' | sed -e '/LAT_bn/d' | cut -d= -f2 | awk ' { print $1 } ' >| $MAINDIR/$GR/GR/LAT
fi
if [ "$remapf" != "" ] ; then remap="-remapcon,$remapf" ; fi
   

################################################################################
# Loop on seasons
for SEAS in `echo $listeseas | sed -e 's/,/ /g'` ; do
################################################################################
echo $SEAS

case $SEAS in
   YEAR)  months="" ;;
   DJF)   months="-selmon,1,2,12" ;;
   JJA)   months="-selmon,6,7,8" ;; 
   JJAS)   months="-selmon,6,7,8,9" ;; 
   *) echo "Cas $cas non prevu" ; exit
esac


################################################################################
# Boucle sur les simulations
################################################################################

cd $MAINDIR/SE/CMOR ; \rm ferret*

if [ "$COMP_D" != "" ] ; then
listesim=`awk ' { print $1"_"$2 } ' $COMP_D/def.txt`
fi
echo listesim $listesim


if [ "$listesim" = "" ] ; then listesim=`ls` ; fi

for sim in $listesim ; do

 IN_DIR=$MAINDIR/SE/CMOR/$sim
 echo $IN_DIR

 if [ -d $IN_DIR ] ; then

   echo seasons.sh : mise a jour pour $sim
   if [ $force_create = 1 ] ; then
       rm -rf $MAINDIR/$GR/$SEAS/$sim
   fi
   OUT_DIR=$MAINDIR/$GR/$SEAS/$sim/NC   ; mkdir -p $OUT_DIR

   cd $IN_DIR
# boucle sur les variables (chacune correspondant à un .nc)
   for f in *nc ; do
      var=`basename $f .nc`
# Pour le 3D, on prend directement les moyennes zonales

# facteurs mutliplicatifs si besoin
      mulc=1.
      case $var in
         pr) mulc=86400. ;;
         autre) mulc=achanger ;;
         dernier) mulc=bou
      esac

# Moyenne saisonniere (et zonale pour les champs 3D)
      if [ ! -f $OUT_DIR/$f -a -f $IN_DIR/$f ] ; then
         echo cdo mulc,$mulc -timavg $months $remap $IN_DIR/$f $OUT_DIR/$f
         cdo mulc,$mulc -timavg $months $remap $IN_DIR/$f $OUT_DIR/$f
      else
         echo $OUT_DIR/$f : deja cree
      fi

   done


########################################################################
# Regroupement des variables 2D dans all.nc
########################################################################
   cd $OUT_DIR
   liste3d=""
   listef=""
   if [ "`ls -rt *nc | tail -1`" != "all.nc" ] ; then
      for f in `ls *nc | sed -e 's/all.nc//'` ; do
         var=`basename $f .nc`
         case $var in
            ua|va|wap|ta|hus|hur) liste3d="$liste3d $f" ;;
            *) listef="$listef $f"
         esac
      done
      \rm -f all.nc
      echo cdo merge $listef all.nc
      cdo merge $listef all.nc
   fi

 else
    echo ERREUR: repertoire $IN_DIR absent
 fi # Boucle sur $sim
done

done
