#!/bin/bash
set -vx

comp=$1

local=`pwd -P`
login=`whoami`
hostname=`hostname`
if [ ${hostname:0:5} = cicla ] ; then
DODSDIR=/thredds/ipsl
HTML00=http://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/$login
machine=ciclad
fi
if [ ${hostname:0:5} = camel ] ; then
DODSDIR=/thredds/ipsl
fi
if [ ${hostname:0:5} = irene ] ; then
DODSDIR=
fi
if [ ${hostname:0:5} = jean- ] ; then
DODSDIR=
fi

COMP_D=$DODSDIR/$login/lmdz/MultiSimu/$comp
entetef=$COMP_D/entete.html

#############################################################################
#echo YEARS $years
#############################################################################

compf=$COMP_D/AXE3.html
HTML=$HTML00/lmdz/MultiSimu/$comp

cat $entetef > $compf

echo '<hr>' >> $compf

cat <<eod>> $compf
<h1> Axe 3: Nuages et rayonnement </h1>

<hr>
Responsable : Ionela Musat  <br>
 musat@lmd.jussieu.fr <br>
Liste de diffusion : lmdz_nuages@mailhost.lmd.jussieu.fr

<h2> Moyennes zonales </h2>

<h3> <a href="$HTML/ZON/YEAR/index.html"> Moyennes zonales YEAR </a> </h3>

<h3> <a href="$HTML/ZON/JJA/index.html"> Moyennes zonales JJA </a> </h3>

<h3> <a href="$HTML/ZON/DJF/index.html"> Moyennes zonales DJF </a> </h3>

<h3> <a href="$HTML/AMMACROSS/JJAS/index.html"> Moyennes zonales AMMACROSS JJAS  </a> </h3>

<h2> Histogram Reflectance - Cloud Fraction  </h2>

<h3> <a href="$HTML/AXE3/ReflCld/index.html"> Histogram 2D Reflectance vs Cloud Fraction </a> </h3>

eod


# Concaténer les figures sur une page
# Création de l'argument pour l'appel de concat_html.sh:
# Prendre la liste des chemins, isoler les noms de fichiers, enlever
# l'extension, faire une ligne, enlever la dernière virgule

echo $concatarg

for SEAS in YEAR JJA DJF ; do
cat $entetef >| $COMP_D/ZON/$SEAS/index.html
concatarg=`ls $COMP_D/ZON/$SEAS/*.png | sed "s/.*\///" | \
  sed "s/\.png//" | awk '{printf "%s,",$0}' | sed 's/\(.*\),/\1/'`
$local/concat_html.sh $COMP_D/ZON/$SEAS "Moyennes zonales" $concatarg 3 >> $COMP_D/ZON/$SEAS/index.html
cat $entetef >| $COMP_D/AXE3/ReflCld/index.html
done

concatarg=`ls $COMP_D/AMMACROSS/JJAS/*.png | sed "s/.*\///" | \
  sed "s/\.png//" | awk '{printf "%s,",$0}' | sed 's/\(.*\),/\1/'`
cat $entetef >| $COMP_D/AMMACROSS/JJAS/index.html
$local//concat_html.sh $COMP_D/AMMACROSS/JJAS "Moyennes zonales" $concatarg 3 >> $COMP_D/AMMACROSS/JJAS/index.html

#Diagno Refl vs Cld
#AI janvier 2017

# Concaténer les figures sur une page
# Création de l'argument pour l'appel de concat_html.sh:
# Prendre la liste des chemins, isoler les noms de fichiers, enlever
# l'extension, faire une ligne, enlever la dernière virgule
concatarg=`ls $COMP_D/AXE3/ReflCld/*.png | sed "s/.*\///" | \
  sed "s/\.png//" | awk '{printf "%s,",$0}' | sed 's/\(.*\),/\1/'`

echo $concatarg


cat $entetef >| $COMP_D/AXE3/ReflCld/index.html
echo "$local/concat_html.sh $COMP_D/AXE3/ReflCld "Histogram Refl vs Cld" $concatarg 4 >> $COMP_D/AXE3/ReflCld/index.html"



####################################################################
### REG ############################################################
####################################################################

cat <<eod>> $compf

<h2> Diagnostiques Classifications en regimes </h2>
<h3> <a href="$HTML/REG/index.html"> Regimes dynamiques tropicaux </a> </h3>

<li><a href="$HTML/1D.html">SCM(1D)</a>

</body>
</html>
eod


# Concaténer les figures sur une page
# Création de l'argument pour l'appel de concat_html.sh:
# Prendre la liste des chemins, isoler les noms de fichiers, enlever
# l'extension, faire une ligne, enlever la dernière virgule
concatarg=`ls $COMP_D/REG/*.png | sed "s/.*\///" | \
  sed "s/\.png//" | awk '{printf "%s,",$0}' | sed 's/\(.*\),/\1/'`

echo $concatarg
#exit

cat $entetef >| $COMP_D/REG/index.html
$local/concat_html.sh $COMP_D/REG "Regimes dynamiques tropicaux" $concatarg 3 >> $COMP_D/REG/index.html

echo $compf | sed -e 's:/thredds/ipsl/:http\://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/:'
