#!/bin/bash

comp=$1

local=`pwd -P`
login=`whoami`
hostname=`hostname`
if [ ${hostname:0:5} = cicla ] ; then
DODSDIR=/thredds/ipsl
HTML00=http://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/$login
machine=ciclad
fi
if [ ${hostname:0:5} = camel ] ; then
DODSDIR=/thredds/ipsl
fi
if [ ${hostname:0:5} = irene ] ; then
DODSDIR=
fi
if [ ${hostname:0:5} = jean- ] ; then
DODSDIR=
fi

ATLAS_DIR=$DODSDIR/$login/lmdz/atlas
OUT_DIR=$DODSDIR/$login/lmdz/MultiSimu/$comp
entetef=$OUT_DIR/entete.html
ZON_DIR=$OUT_DIR/ZON

#############################################################################
#############################################################################

compf=$OUT_DIR/METRICS_min.html
echo $compf
emptyelt='<td> - </td>'

# Modification du html après l'introduction des tuning saisonniers
HTML=$HTML00/lmdz/MultiSimu/$comp

if [ -d $OUT_DIR/METRICS/YEAR ] ; then # Nouvelle version
   MET_D=METRICS/YEAR
else
   MET_D=METRICS
fi

entete=1

rm -f $compf ; touch $compf

      cat $entetef >> $compf

      echo '<hr/>' >> $compf
      cat <<......eod>> $compf
      <h2> Calcul de métriques sur des masques </h2>
      <h3> Les flux sont orientés vers le bas.
      Les moyennes sont faites sur les masques montrés entre le titre et le graphe.
      Pour ETOA, la figure correspond à la différence entre le rouge et le bleu.
      </h3>
......eod
      echo '<hr/>' >> $compf

      echo '<h3>' >> $compf

      echo '<hr/>' >> $compf
      echo '<h2> Moyennes annuelles - Annual mean </h2>' >> $compf
      echo '<table>' >> $compf

      echo '<TR>' >> $compf

      ################   3 premieres metriques #####################"
      masks="conv weak subs"
      for MET in "Convective" "Weak" "Subsidence"  ; do
          echo "<TD ALIGN=CENTER> $MET </TD>" >> $compf
      done

      echo '<TR>' >> $compf
      for mask in $masks ; do
         thredds=$HTML/$MET_D/mask$mask.png
         echo '<TD  ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=80 WIDTH=120 SRC="'$thredds'"></a></TD>' >> $compf
      done

      echo '<TR>' >> $compf
      for mask in $masks ; do
         thredds=$HTML/$MET_D/$mask.png
         echo '<TD ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=400 WIDTH=500 SRC="'$thredds'"></a></TD>' >> $compf
      done

      echo '<TR>' >> $compf

      ################   3 premieres metriques #####################"


# Nouveaux tunings saisonniers
if [ -d $OUT_DIR/METRICS/YEAR ] ; then # Nouvelle version


      seas=( YEAR DJF JJA )
      comment=( "ETO-Weak YEAR" "circA DJF" "Sibe JJA" )
      mask=( etow circA Sibe )

      echo '<hr/>' >> $compf
      echo '<h2> '$seas' mean </h2>' >> $compf
      echo '<table>' >> $compf

      ################   3 premieres metriques #####################"

      for i in 0 1 2 ; do
          echo "<TD ALIGN=CENTER> ${comment[$i]} </TD>" >> $compf
      done

      echo '<TR>' >> $compf
      for i in 0 1 2 ; do
         thredds=$HTML/METRICS/${seas[$i]}/mask${mask[$i]}.png
         echo '<TD  ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=80 WIDTH=120 SRC="'$thredds'"></a></TD>' >> $compf
      done

      echo '<TR>' >> $compf
      for i in 0 1 2 ; do
         thredds=$HTML/METRICS/${seas[$i]}/${mask[$i]}.png
         echo '<TD ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=400 WIDTH=500 SRC="'$thredds'"></a></TD>' >> $compf
      done

      echo '</table>' >> $compf



fi

echo UN NOVEL MULTI ATLAS EST DISPONIBLE SUR $HTML00/lmdz/MultiSimu/$comp/entete.html
