#!/bin/bash

comp=$1

local=`pwd -P`
login=`whoami`
hostname=`hostname`
if [ ${hostname:0:5} = cicla ] ; then
DODSDIR=/thredds/ipsl
HTML00=http://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/$login
machine=ciclad
fi
if [ ${hostname:0:5} = camel ] ; then
DODSDIR=/thredds/ipsl
fi
if [ ${hostname:0:5} = irene ] ; then
DODSDIR=
fi
if [ ${hostname:0:5} = jean- ] ; then
DODSDIR=
fi

ATLAS_DIR=$DODSDIR/$login/lmdz/atlas
OUT_DIR=$DODSDIR/$login/lmdz/MultiSimu/$comp
entetef=$OUT_DIR/entete.html
ZON_DIR=$OUT_DIR/ZON

#############################################################################
#############################################################################

compf=$OUT_DIR/METRICS.html
echo $compf
emptyelt='<td> - </td>'

# Modification du html après l'introduction des tuning saisonniers
HTML=$HTML00/lmdz/MultiSimu/$comp

if [ -d $OUT_DIR/METRICS/YEAR ] ; then # Nouvelle version
   MET_D=METRICS/YEAR
else
   MET_D=METRICS
fi

entete=1

rm -f $compf ; touch $compf

      cat $entetef >> $compf

      echo '<hr/>' >> $compf
      cat <<......eod>> $compf
      <h2> Calcul de métriques sur des masques </h2>
      <h3> Les flux sont orientés vers le bas.
      Les moyennes sont faites sur les masques montrés entre le titre et le graphe.
      Pour ETOA, la figure correspond à la différence entre le rouge et le bleu.
      </h3>
......eod
      echo '<hr/>' >> $compf

      echo '<h3>' >> $compf

      echo '<hr/>' >> $compf
      echo '<h2> Moyennes annuelles - Annual mean </h2>' >> $compf
      echo '<table>' >> $compf

      ################   3 premieres metriques #####################"
      masks="glob circA circAa interH"
      for MET in "Global" "Circum. Antart" "Circum. Antart anom" "Inter Hemispheric" ; do
          echo "<TD ALIGN=CENTER> $MET </TD>" >> $compf
      done

      echo '<TR>' >> $compf
      for mask in $masks ; do
         thredds=$HTML/$MET_D/mask$mask.png
         echo '<TD  ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=150 WIDTH=200 SRC="'$thredds'"></a></TD>' >> $compf
      done

      echo '<TR>' >> $compf
      for mask in $masks ; do
         thredds=$HTML/$MET_D/$mask.png
         echo '<TD ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=400 WIDTH=500 SRC="'$thredds'"></a></TD>' >> $compf
      done

      echo '<TR>' >> $compf

      ################   3 premieres metriques #####################"
      masks="etoa etow etows" 
      for MET in "East Tropic Ocean Anom. (ETOA)" "ETO anom : ETO - WEAK" "ETO anom : SUBS - WEAK" ; do
          echo "<TD ALIGN=CENTER> $MET </TD>" >> $compf
      done

      echo '<TR>' >> $compf
      for mask in $masks ; do
         thredds=$HTML/$MET_D/mask$mask.png
         echo '<TD  ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=150 WIDTH=200 SRC="'$thredds'"></a></TD>' >> $compf
      done

      echo '<TR>' >> $compf
      for mask in $masks ; do
         thredds=$HTML/$MET_D/$mask.png
         echo '<TD ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=400 WIDTH=500 SRC="'$thredds'"></a></TD>' >> $compf
      done

      echo '<TR>' >> $compf

      ################   3 premieres metriques #####################"
      masks="conv weak subs otrop"
      for MET in "Convective" "Weak" "Subsidence" "Tropic oceans"   ; do
          echo "<TD ALIGN=CENTER> $MET </TD>" >> $compf
      done

      echo '<TR>' >> $compf
      for mask in $masks ; do
         thredds=$HTML/$MET_D/mask$mask.png
         echo '<TD  ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=150 WIDTH=200 SRC="'$thredds'"></a></TD>' >> $compf
      done

      echo '<TR>' >> $compf
      for mask in $masks ; do
         thredds=$HTML/$MET_D/$mask.png
         echo '<TD ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=400 WIDTH=500 SRC="'$thredds'"></a></TD>' >> $compf
      done

      echo '<TR>' >> $compf

      ################   3 premieres metriques #####################"
      masks="oce ter NAtl Arct"
      for MET in "Oceans" "Continent" "N. Atlantic" "Arctic Oce." ; do
          echo "<TD ALIGN=CENTER> $MET </TD>" >> $compf
      done

      echo '<TR>' >> $compf
      for mask in $masks ; do
         thredds=$HTML/$MET_D/mask$mask.png
         echo '<TD  ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=150 WIDTH=200 SRC="'$thredds'"></a></TD>' >> $compf
      done

      echo '<TR>' >> $compf
      for mask in $masks ; do
         thredds=$HTML/$MET_D/$mask.png
         echo '<TD ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=400 WIDTH=500 SRC="'$thredds'"></a></TD>' >> $compf
      done

      echo '</table>' >> $compf

     #####################################################################


# Nouveaux tunings saisonniers
if [ -d $OUT_DIR/METRICS/YEAR ] ; then # Nouvelle version

for seas in DJF JJA ; do
      MET_D=METRICS/$seas
      echo '<hr/>' >> $compf
      echo '<h2> '$seas' mean </h2>' >> $compf
      echo '<table>' >> $compf

      ################   3 premieres metriques #####################"
      masks="Sibe USA Arct NAtl circA"
      for MET in "Siberia" "US gr. plains" "Arctic" "N. Atlantic" "Circum Antart." ; do
          echo "<TD ALIGN=CENTER> $MET </TD>" >> $compf
      done

      echo '<TR>' >> $compf
      for mask in $masks ; do
         thredds=$HTML/$MET_D/mask$mask.png
         echo '<TD  ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=150 WIDTH=200 SRC="'$thredds'"></a></TD>' >> $compf
      done

      echo '<TR>' >> $compf
      for mask in $masks ; do
         thredds=$HTML/$MET_D/$mask.png
         echo '<TD ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=400 WIDTH=500 SRC="'$thredds'"></a></TD>' >> $compf
      done

      echo '</table>' >> $compf


     #####################################################################
done

fi

echo UN NOVEL MULTI ATLAS EST DISPONIBLE SUR $HTML00/lmdz/MultiSimu/$comp/entete.html
