#!/bin/bash

comp=$1
shift

local=`pwd -P`
login=`whoami`
hostname=`hostname`
if [ ${hostname:0:5} = cicla ] ; then
DODSDIR=/thredds/ipsl
HTML00=http://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/$login
machine=ciclad
fi
if [ ${hostname:0:5} = camel ] ; then
DODSDIR=/thredds/ipsl
fi
if [ ${hostname:0:5} = irene ] ; then
DODSDIR=
fi
if [ ${hostname:0:5} = jean- ] ; then
DODSDIR=
fi

echo OK0
ATLAS_DIR=$DODSDIR/$login/lmdz/atlas
OUT_DIR=$DODSDIR/$login/lmdz/MultiSimu/$comp
ref=`head -1 $OUT_DIR/def.txt | awk ' { print $1 } '`

ZON_DIR=$OUT_DIR/ZON
ZONC_DIR=$OUT_DIR/ZONC
OUT_DIR_CESMEP=$DODSDIR/$login/C-ESM-EP/tmp_${comp}_C-ESM-EP_v2

echo OK1
#############################################################################

compf=$OUT_DIR/entete.html
\cp -f $local/HOWTO.html $OUT_DIR/../

HTML0=$HTML00/lmdz/MultiSimu
HTML=$HTML0/$comp
HTML_CESMEP=$HTML00/C-ESM-EP/tmp_${comp}_C-ESM-EP_v2

emptyelt='<td> - </td>'



rm -f $compf ; touch $compf


      ##############################################################
      # MENU DEROULANT 
      ##############################################################
      cat $local/enteteMulti.html >> $compf
      echo '<h1 ALIGN=CENTER> <a href="'$HTML0'/all.html">(AUTRES) </a>Série de simulations préparatoires à CMIP6, LMDZ-Orchidee, CTRL : '$ref'</h1> ' >> $compf
      cat <<......eod>> $compf
       <ul id="menu">
       <li><a href="#">Comparaisons</a>
          <ul>
          <li><a href="$HTML/ACCUEIL.html">$comp: Cette page</a> </li>
          <li><a href="$HTML0/V5.3to5/ACCUEIL.html">V5.3to5 : Evolutions v5.3 -> v5.5</a> </li>
          <li><a href="$HTML0/V5.4/ACCUEIL.html">V5.4 : Test sur v5.4</a> </li>
          <li><a href="$HTML0/CMIP5to6/ACCUEIL.html">CMIP5to6 : Evolutions CMIP5->6</a> </li>
          <li><a href="$HTML0/CPLV5.3to5/ACCUEIL.html">CPLV5.3to5 : NPv5.3->5.5, couplé</a> </li>
          <li><a href="$HTML0/CPL5to6/ACCUEIL.html">CPL5to6 : IPSL-CM5 -> CM6, couplé</a> </li>
          <li><a href="$HTML0/Guides5.3et5/ACCUEIL.html">Guides5.3et5 : NPv5.3->5.5, guidé</a> </li>
          <li><a href="$HTML0/HOWTO.html">HOWTO contribute</a> </li>
          <li><a href="http://forge.ipsl.jussieu.fr/igcmg/wiki/IPSLCM6 ">Liste des simulations CM6</a> </li>
          <li><a href="https://vesg.ipsl.upmc.fr/thredds/catalog/IPSLFS/fabric/lmdz/MultiSimu/catalog.html">ALL : avail. directories </a> </li>
        </ul></li>
......eod
      for SEAS in YEAR DJF JJA ; do
      cat <<......eod>> $compf
        <li><a href="#">Atlas $SEAS</a>
          <ul>
......eod
      for proj in GLOB SH NH ; do for maps in BIAS MAPS ; do echo '<li><a href="'$HTML'/'$maps$proj$SEAS'.html">'$maps, $proj'</a> </li>' >> $compf ; done ; done
      cat <<......eod>> $compf
          </ul>
        </li>
......eod
      done
cat <<......eod>> $compf
        <li><a href="#">Atlas C-ESM-EP</a>
           <ul>
......eod
if [ -d $OUT_DIR_CESMEP ] ; then
      cat <<......eod>> $compf
       <li><a href="$HTML_CESMEP/JJACLIMvsOBS/atlas_JJACLIMvsOBS_tmp_${comp}.html">JJACLIMvsOBS</a> </li>
       <li><a href="$HTML_CESMEP/ANMClimato/atlas_ANMClimato_tmp_${comp}.html">ANMClimato</a> </li>
       <li><a href="$HTML_CESMEP/JJACLIMvsCTRL/atlas_JJACLIMvsCTRL_tmp_${comp}.html">JJACLIMvsCTRL</a> </li>
       <li><a href="$HTML_CESMEP/JJAClimato/atlas_JJAClimato_tmp_${comp}.html">JJAClimato</a> </li>
       <li><a href="$HTML_CESMEP/ANMCLIMvsCTRL/atlas_ANMCLIMvsCTRL_tmp_${comp}.html">ANMCLIMvsCTRL</a> </li>
       <li><a href="$HTML_CESMEP/DJFCLIMvsCTRL/atlas_DJFCLIMvsCTRL_tmp_${comp}.html">DJFCLIMvsCTRL</a> </li>
       <li><a href="$HTML_CESMEP/DJFCLIMvsOBS/atlas_DJFCLIMvsOBS_tmp_${comp}.html">DJFCLIMvsOBS</a> </li>
       <li><a href="$HTML_CESMEP/JJACLIMvsOBS/atlas_DJFClimato_tmp_${comp}.html">DJFClimato</a> </li>
       <li><a href="$HTML_CESMEP/ANMCLIMvsOBS/atlas_ANMCLIMvsOBS_tmp_${comp}.html">ANMCLIMvsOBS</a> </li>       
......eod
fi
cat <<......eod>> $compf
       </ul></li> 
       <li><a href="#">ESMvalTool</a>
          <ul>
......eod
if [ -d $OUT_DIR/ESMVal_CVDP ] ; then
      cat <<......eod>> $compf
        <li><a href="$HTML/ESMVal_CVDP/index.html">Variability</a> </li>
......eod
fi
if [ -d $OUT_DIR/ESMVal_PM ] ; then
      cat <<......eod>> $compf
          <li><a href="$HTML/ESMVal_PM/ta_zonal.html">ta_zonal</a> </li>
          <li><a href="$HTML/ESMVal_PM/clt_latlon.html">clt_latlon</a> </li>
          <li><a href="$HTML/ESMVal_PM/tas_latlon.html">tas_latlon</a> </li>
          <li><a href="$HTML/ESMVal_PM/SW_CRE_latlon.html">SW_CRE_latlon</a> </li>
          <li><a href="$HTML/ESMVal_PM/LW_CRE_latlon.html">LW_CRE_latlon</a> </li>
          <li><a href="$HTML/ESMVal_PM/NET_CRE_latlon.html">NET_CRE_latlon</a> </li>
          <li><a href="$HTML/ESMVal_PM/METRICS.html">Metrics</a> </li>
......eod
fi
      cat <<......eod>> $compf
        </ul></li>
       <li><a href="#">METRICS</a>
           <ul>
              <li><a href="$HTML/METRICS.html">Tuning</a>
              <li><a href="$HTML/METRICS_min.html">Tuning minimale</a>
              <li><a href="$HTML/PCMDI.html">PCMDI metrics</a>
           </ul>
        </li>
       <li><a href="#">Axes d'évaluation</a>
          <ul>
          <li><a href="$HTML/AXE1.html">Axe 1 : Continents</a> </li>
          <li><a href="$HTML/AXE2.html">Axe 2 : Variabilité tropicale</a> </li>
          <li><a href="$HTML/AXE3.html">Axe 3 : Nuages / rayonnement</a> </li>
          <li><a href="$HTML/AXE4.html">Axe 4 : Régions polaires </a> </li>
          <li><a href="$HTML/AXE5.html">Axe 5 : Moyennes latitudes</a> </li>
          <li><a href="$HTML/AXE6.html">Axe 6 : Stratosphère</a> </li>
          <li><a href="$HTML/AXE7.html">Axe 7 : Comparaisons Stations </a> </li>
          </ul>
        </li>

......eod
      cat <<......eod>> $compf
      </ul> <hr> 
......eod


 
      #####################################################################
      # Fichiers pour l'enetete
      #####################################################################
      cat $OUT_DIR/Table_simulations_$comp.html >> $compf
     #####################################################################


echo UN NOVEL MULTI ATLAS EST DISPONIBLE SUR $HTML/entete.html
