MODULE xios_interface
  ! This module provides a minimal empty xios implementation for phy_output_write_xios
  ! when LMDZ is compiled without xios
#ifdef CPP_XIOS
  use xios, ONLY : xios_field_is_active, xios_send_field, xios_fieldgroup, xios_field, &
                   xios_get_handle, xios_add_child, xios_set_attr, xios_update_calendar, xios_setvar
  logical :: CPP_XIOS_defined = .true.
#else
  logical :: CPP_XIOS_defined = .false.

  type xios_field
  end type
  type xios_fieldgroup
  end type

  interface xios_send_field
    subroutine xios_send_field_r0(name, buffer)
      character(*) :: name
      real :: buffer
    end subroutine
    subroutine xios_send_field_r1(name, buffer)
      character(*) :: name
      real :: buffer(:)
    end subroutine
    subroutine xios_send_field_r2(name, buffer)
      character(*) :: name
      real :: buffer(:,:)
    end subroutine
    subroutine xios_send_field_r3(name, buffer)
      character(*) :: name
      real :: buffer(:,:,:)
    end subroutine
  end interface

  contains
  function xios_field_is_active(name, at_current_timestep_arg)
    character(*) :: name
    logical :: at_current_timestep_arg
    logical :: xios_field_is_active
    xios_field_is_active = .false.
  end function

  subroutine xios_set_attr(hdl, name, unit)
    TYPE(xios_field) :: hdl
    character(*) :: name, unit
  end subroutine

  subroutine xios_get_handle(name, hdl)
    character(*) :: name
    TYPE(xios_fieldgroup) :: hdl
  end subroutine 

  subroutine xios_add_child(ghdl, hdl, name)
    TYPE(xios_fieldgroup) :: ghdl
    TYPE(xios_field) :: hdl
    character(*) :: name    
  end subroutine 

  subroutine xios_update_calendar(i)
    integer :: i
  end subroutine

  logical function xios_setVar(varId, data_k8)
      LOGICAL  (kind = 1)                           :: val
      CHARACTER(len = *)               , INTENT(IN) :: varId
      REAL     (kind = 8)              , INTENT(IN) :: data_k8
      xios_setVar = .true.
  end function xios_setVar
#endif
end module
