MODULE phys_output_write_xios_preprocess

  use phys_output_var_mod, only: ctrl_out
#ifdef REPROBUS
  USE phys_output_ctrlout_mod, ONLY: o_nas
  USE CHEM_REP, ONLY: nas, nbnas
#endif
#ifdef CPP_StratAer
  USE phys_output_ctrlout_mod, ONLY: &
    o_budg_3D_nucl, o_budg_3D_cond_evap, o_budg_3D_ocs_to_so2, o_budg_3D_so2_to_h2so4, &
    o_budg_sed_part, o_R2SO4, o_OCS_lifetime, o_SO2_lifetime, &
    o_budg_3D_backgr_ocs, o_budg_3D_backgr_so2, &
    o_budg_dep_dry_ocs, o_budg_dep_wet_ocs, &
    o_budg_dep_dry_so2, o_budg_dep_wet_so2, &
    o_budg_dep_dry_h2so4, o_budg_dep_wet_h2so4, &
    o_budg_dep_dry_part, o_budg_dep_wet_part, &
    o_budg_emi_ocs, o_budg_emi_so2, o_budg_emi_h2so4, o_budg_emi_part, &
    o_budg_ocs_to_so2, o_budg_so2_to_h2so4, o_budg_h2so4_to_part, &
    o_surf_PM25_sulf, o_ext_strat_550, o_tau_strat_550, &
    o_vsed_aer, o_tau_strat_1020, o_ext_strat_1020, o_f_r_wet
  USE phys_local_var_mod, ONLY: &
    budg_3D_nucl, budg_3D_cond_evap, budg_3D_ocs_to_so2, budg_3D_so2_to_h2so4, &
    budg_sed_part, R2SO4, OCS_lifetime, SO2_lifetime, &
    budg_3D_backgr_ocs, budg_3D_backgr_so2, &
    budg_dep_dry_ocs, budg_dep_wet_ocs, &
    budg_dep_dry_so2, budg_dep_wet_so2, &
    budg_dep_dry_h2so4, budg_dep_wet_h2so4, &
    budg_dep_dry_part, budg_dep_wet_part, &
    budg_emi_ocs, budg_emi_so2, budg_emi_h2so4, budg_emi_part, &
    budg_ocs_to_so2, budg_so2_to_h2so4, budg_h2so4_to_part, &
    surf_PM25_sulf, tau_strat_550, tausum_strat, &
    vsed_aer, tau_strat_1020, f_r_wet
#endif
#ifdef CPP_RRTM
  USE YOESW, ONLY: RSUN
#endif
  implicit none
#ifdef REPROBUS
  !USE phys_output_ctrlout_mod, ONLY: o_nas
  !USE CHEM_REP, ONLY: nas, nbnas
  LOGICAL, PARAMETER :: ok_reprobus = .true.
#else
  LOGICAL, PARAMETER :: ok_reprobus = .false.
  INTEGER, PARAMETER :: nbnas = 0
  TYPE(ctrl_out), allocatable :: o_nas(:)
  real, allocatable, dimension(:, :, :) :: nas
#endif
#ifdef CPP_StratAer
  LOGICAL, PARAMETER :: ok_strataer = .true., debug_strataer = .false.
#else
  LOGICAL, PARAMETER :: ok_strataer = .false., debug_strataer = .false.
  TYPE(ctrl_out) :: o_budg_3D_nucl, o_budg_3D_cond_evap, o_budg_3D_ocs_to_so2, o_budg_3D_so2_to_h2so4, &
                    o_budg_sed_part, o_R2SO4, o_OCS_lifetime, o_SO2_lifetime, &
                    o_budg_3D_backgr_ocs, o_budg_3D_backgr_so2, &
                    o_budg_dep_dry_ocs, o_budg_dep_wet_ocs, &
                    o_budg_dep_dry_so2, o_budg_dep_wet_so2, &
                    o_budg_dep_dry_h2so4, o_budg_dep_wet_h2so4, &
                    o_budg_dep_dry_part, o_budg_dep_wet_part, &
                    o_budg_emi_ocs, o_budg_emi_so2, o_budg_emi_h2so4, o_budg_emi_part, &
                    o_budg_ocs_to_so2, o_budg_so2_to_h2so4, o_budg_h2so4_to_part, &
                    o_surf_PM25_sulf, o_ext_strat_550, o_tau_strat_550, &
                    o_vsed_aer, o_tau_strat_1020, o_ext_strat_1020, o_f_r_wet
  real, allocatable, dimension(:, :) :: budg_3D_nucl, budg_3D_cond_evap, budg_3D_ocs_to_so2, budg_3D_so2_to_h2so4, &
                                        budg_sed_part, R2SO4, OCS_lifetime, SO2_lifetime, &
                                        budg_3D_backgr_ocs, budg_3D_backgr_so2, &
                                        budg_dep_dry_ocs, budg_dep_wet_ocs, &
                                        budg_dep_dry_so2, budg_dep_wet_so2, &
                                        budg_dep_dry_h2so4, budg_dep_wet_h2so4, &
                                        budg_dep_dry_part, budg_dep_wet_part, &
                                        budg_emi_ocs, budg_emi_so2, budg_emi_h2so4, budg_emi_part, &
                                        budg_ocs_to_so2, budg_so2_to_h2so4, budg_h2so4_to_part, &
                                        surf_PM25_sulf, tau_strat_550, tausum_strat, &
                                        vsed_aer, tau_strat_1020, f_r_wet
#endif
#ifdef CPP_RRTM
  !USE YOESW, ONLY: RSUN
  LOGICAL, PARAMETER :: ok_rrtm = .true.
#else
  LOGICAL, PARAMETER :: ok_rrtm = .false.
  REAL :: RSUN(6)
#endif
END MODULE