#!/bin/bash

#################################################################################
# A.I  : 1e version : Decembre 2019
# Reprise Mars 2020
# installer les scripts de post-traitement multi-atlas pour LMDZ sur une machine
# le packege sera integre sous svn aux ..../BOL/Multi-Atlas
# Ce script permet de definir les differents repertoires en fonction de la machine
# Permet de creer les sscripts job_multi.sh et atlas.sh
#################################################################################
#
#
# Definition des coleurs d'affichage
noir='\e[0;30m' gris='\e[1;30m' rougefonce='\e[0;31m' rose='\e[1;31m' vertfonce='\e[0;32m' vertclair='\e[1;32m' orange='\e[0;33m' jaune='\e[1;33m' bleufonce='\e[0;34m' bleuclair='\e[1;34m' violetfonce='\e[0;35m' violetclair='\e[1;35m' cyanfonce='\e[0;36m' cyanclair='\e[1;36m' grisclair='\e[0;37m' blanc='\e[1;37m' neutre='\e[0;m'
##
##
# AI avril 2020 : A FAIRE :
# Utiliser des fonctions entete, ...
# A function pour definir l entete du job en fonction de la machine
#function jobentete { #1er argument doit etre le nom de la machine 

#set -x
# Nom machine et login
hostname=`hostname`
login=`whoami`

# Definitions en fonction de la machine
# CICLAD
if [ ${hostname:0:5} = cicla ] ; then
# chemin vers le rep dods de base
DODSDIR=/modfs/ipslfs/dods
# Rep ou sont stockes les multiatlas
MULTIDIR=$DODSDIR/$login/lmdz/MultiSimu
# Rep ou se trouve les sorties cmorizees
ROOT_SIM_DIR=$DODSDIR/$login/lmdz/SE/ORIG
ROOT_OBS_DIR=$DODSDIR/fabric/lmdz/SE/CMOR/OBS
if [ ! -d $MULTIDIR ] ; then mkdir -p $MULTIDIR ; fi
# Def entete des jobs 
cat <<eod >> entete.sh
#PBS -N atlas
#PBS -m a
#PBS -j oe
#PBS -q h12
#PBS -o atlasNOMSIMULATION.out
#PBS -S /bin/bash
#PBS -l nodes=1:ppn=1
#PBS -l mem=30gb
#PBS -l vmem=30gb
#
# Commande pour soumettre en bash
submit=qsub

login=$login
DODSDIR=$DODSDIR
eod
fi

# CLIMSERV
if [ ${hostname:0:5} = camel ] ; then
DODSDIR=/modfs/ipslfs/dods
cat <<eod > entete.sh
#PBS -N atlas
#PBS -m a
#PBS -j oe
#PBS -q h12
#PBS -o atlasNOMSIMULATION.out
#PBS -S /bin/bash
#PBS -l nodes=1:ppn=1
#PBS -l mem=30gb
#PBS -l vmem=30gb
#
# Commande pour soumettre en bash
submit=qsub
eod
fi

# IRENE
if [ ${hostname:0:5} = irene ] ; then
cat <<eod > definerep.sh
MAIN_SE=
TS_DA=
TS_MO=
MULTIDIR=
groupe=
eod
cat <<eod > entete.sh
######################
## IRENE   TGCC/CEA ##
######################
#MSUB -r multiatlas            # Job name
#MSUB -o multi.out_%I
#MSUB -e multi.out_%I
#MSUB -n 1
#MSUB -T 36000         # Maximum elapsed time
#MSUB -q xlarge 
#MSUB -c 8
#MSUB -Q normal
#MSUB -A $groupe
#MSUB -m store,work,scratch
#
# Commande pour soumettre en bash
submit=ccc_msub
eod
fi

# JEAN-ZAY
if [ ${hostname:0:5} = jean- ] ; then
cat <<eod > definerep.sh
MAIN_SE=
TS_DA=
TS_MO=
MULTIDIR=
groupe=
eod
cat <<eod > entete.sh
######################
## IRENE   TGCC/CEA ##
######################
#MSUB -r multiatlas            # Job name
#MSUB -o multi.out_%I
#MSUB -e multi.out_%I
#MSUB -n 1
#MSUB -T 36000         # Maximum elapsed time
#MSUB -q xlarge 
#MSUB -c 8
#MSUB -Q normal
#MSUB -A $groupe
#MSUB -m store,work,scratch
#
# Commande pour soumettre en bash
submit=sbash
eod
fi

# PC (formation et perso linux)
# Machines locales lmd

local=`pwd -P`

echo -e "${noir}%%%%%%%%%%%%%%%%%%%%%%% ${rougefonce} LMDZ MULTIATLAS ${noir}%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
echo
echo -e "${bleufonce}"To create your multi-atlas you needs :
echo 1.  to create your multiatlas directory "example Multi01" :
echo     mkdir -p /modfs/ipslfs/dods/$login/lmdz/MultiSimu/Multi01
echo  
echo 2.  to define some characeristics of your multi-atlas "names, dates, description of simulations and atlas variables" :
echo     cp Utils/def.txt  Utils/atlas-def /modfs/ipslfs/dods/$login/lmdz/MultiSimu/Multi01/.
echo     define "names, date, description" of simulations in file :
echo     /modfs/ipslfs/dods/$login/lmdz/MultiSimu/Multi01/def.txt
echo     define atlas variables in file :
echo     /modfs/ipslfs/dods/$login/lmdz/MultiSimu/Multi01/atlas-def
echo
echo 3.   Add the link to the simulation outputs in your file : $local/runs.txt
echo 

### creer le job principal
rm -f job_multi.sh
cat entete.sh >| job_multi.sh 
cat Utils/multi.sh >> job_multi.sh
chmod +x job_multi.sh

#### script pour creer les atlas 
rm -f atlas.sh
cat entete.sh >| atlas.sh
cat Utils/atlas0.sh >> atlas.sh
chmod +x atlas.sh
\mv atlas.sh atlas/.
cp Utils/lmdz_SE0.py tmp0.py
sed -e s:ROOT_SIM_DIR:$ROOT_SIM_DIR:g tmp0.py > tmp.py
sed -e s:ROOT_OBS_DIR:$ROOT_OBS_DIR:g tmp.py > lmdz_SE.py
rm -f tmp0.py tmp.py
\mv lmdz_SE.py atlas/.

echo 4. Then you can run your multiatlas :
echo ./job_multi.sh Multi01
echo -e "${noir}%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
