#!/bin/bash

###################################################
# remplace l'ancien multi_ZON.sh
# Trace les moyennes zonales multi-simulations
# a partir de fichiers ascii deja traités.
###################################################

 SEAS=$1
 comp=$2
 ZONE=$3

login=`whoami`
hostname=`hostname`
if [ ${hostname:0:5} = cicla ] ; then
DODSDIR=/modfs/ipslfs/dods
fi
if [ ${hostname:0:5} = camel ] ; then
DODSDIR=/modfs/ipslfs/dods
fi
if [ ${hostname:0:5} = irene ] ; then
DODSDIR=
fi
if [ ${hostname:0:5} = jean- ] ; then
DODSDIR=
fi

MAINDIR=$DODSDIR/$login/lmdz

runstxt=/home/fabric/LMDZ/MultiSimu/runs.txt

while test -n "${1}"; do
    case $1 in
       "-runsfile") runstxt=$2 ; shift ;;
    esac
    shift
done


GR=VLR
force_create=1

local=`pwd`

latmin=-90.
latmax=90.
if [ $ZONE = AMMACROSS ] ; then
   latmin=-5.
   latmax=25.
fi

COMP_D=$MAINDIR/MultiSimu/$comp
outd=$COMP_D/$ZONE/$SEAS

DEF_FILE=$COMP_D/def.txt
echo $COMP_D

#sims="OBS " ; for ss in `awk ' {print $1"_"$2 } ' $DEF_FILE` ; do sims="$sims $ss" ; done
#echo sims $sims
#exit
listsims=""  ; for s  in `awk ' {print $1} ' $DEF_FILE`          ; do listsims="$listsims $s"    ; done
echo listsims $listsims
sims="OBS "
for s in $listsims ; do
simdir=`grep -w "^$s "  $runstxt | awk ' { print $2 } '`
ss=`basename $simdir `
#year=`grep -w "^$s " $DEF_FILE | awk ' { print $2 } '`
year=`grep -w "^$s" $DEF_FILE | awk ' { print $2 } '`
sims="$sims ${s}_$year"
done

echo $SEAS $outd "$sims"

vars='psl'
#vars="pr rstt rlut rtt crelt crest crett hfns hfls tas sst tauu tauv psl zg500 rsts rsut rlutcs albs albt cress crels crets rts rah rahcs rahcre rlah rlahcs rlahcre rsah rsahcs rsahcre cltcalipso clhcalipso clmcalipso cllcalipso hurs hfss rldscs rlds rlus rsdscs rsds rsus rsuscs rsutcs prw"
#vars="pr prw rstt rlut rtt crelt crest crett hfns hfls tas sst tauu tauv psl zg500 rsts rsut rlutcs albs albt cress crels crets rts rah rahcs rahcre rlah rlahcs rlahcre rsah rsahcs rsahcre hurs hfss rldscs rlds rlus rsdscs rsds rsus rsuscs rsutcs prw"
vars="pr prw rstt rlut rtt crelt crest crett hfns hfls tas sst tauu tauv psl zg500 rsts rsut rlutcs albs albt cress crels crets rts rah rahcs rahcre rlah rlahcs rlahcre rsah rsahcs rsahcre hurs hfss rldscs rlds rlus rsdscs rsds rsus rsuscs rsutcs prw rttcs rsttcs cllcalipso clmcalipso clhcalipso cll clm clh"
#vars=$4
#vars="eva"
echo $vars

for var in $vars; do 

echo TRAITEMENT DE LA VARIABLE $var

if [ $force_create = 1 ] ; then \rm -f $outd/${var}zon.p* ; fi

if [ ! -f $outd/${var}zon.pdf -o ! -f $outd/${var}zon.png ] ; then

echo zon var=$var
echo zon GR=$GR 
echo zon SEAS=$SEAS
echo zon sims=$sims

nsims=$#
echo NSIMS $nsims


#line=`grep  "$var," $local/description.zon`
line=`grep  "$var," $local/description${SEAS}.zon`
if [ "$line" = "" ] ; then echo $var non prevue dans description ; exit ; fi
name=`echo $line | awk -F, ' { print $2 } '`
unit=`echo $line | awk -F, ' { print $3 } '`
 min=`echo $line | awk -F, ' { print $4 } '`
 max=`echo $line | awk -F, ' { print $5 } '`

echo $line $name $unit $min $max
GR=VLR


WRK=`pwd`/WORK/XMGR$$/$var

mkdir -p $outd
cd $outd
pwd

pwd
echo OK0 $sims
for sim in $sims ; do
   if [ $sim = OBS ] ; then MAINDIR=$DODSDIR/fabric/lmdz ; fi
   ZONDIR=$MAINDIR/$GR/$SEAS/$sim/$ZONE
   echo $ZONDIR
   pwd
   file=`echo $sim | sed -e 's/_[0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9]//'`
   echo ln -sf $ZONDIR/$var $file
   ln -sf $ZONDIR/$var $file
done


    #yaxis  tick major 5
    #yaxis  tick minor 1

#if [ $nsims = 2 ] ; then
#    view="0.15, 0.15, 1, 0.6"
#    legend="0.15,0.7"
if [ $var == "prl" ] || [ $var == "prc" ] ; then
    legend="0.72,0.7"
elif [ $var == "pr" ] || [ $var == "clmcalipso" ] || [ $var == "eva" ] ; then
    legend="0.72,0.7"
elif [ $var == "clhcalipso" ] || [ $var == "crelt" ] ; then
    legend="0.72,0.7"
elif [ $var == "crest" ] ; then
    view="0.15, 0.15, 1, 0.6"
    legend="0.25,0.25"
elif [ $var == "hfls" ] || [ $var == "prw" ] ; then
    view="0.15, 0.15, 1, 0.6"
    legend="0.72,0.7"
elif [ $var == "hfns" ] ; then
    view="0.15, 0.15, 1, 0.6"
    legend="0.72,0.7"
elif [ $var == "rstt" ] && [ $SEAS == "YEAR" ]; then
    legend="0.42,0.45"
else
    #view="0.15, 0.15, 0.7, 0.45"
    #legend="0.72,0.45"
    legend="0.72,0.25"
fi
view="0.15, 0.15, 1, 0.6"
legend="1.02,0.6"


\rm tmp.param
cat <<eod>| tmp.param
world $latmin, $min, $latmax, $max
stack world 0, 0, 0, 0
xaxis label "Latitude"
yaxis label "$name ($unit)"
view $view
legend $legend
s0 linewidth 10
s0 color 7
eod

ii=0
for style in 1 3 2 ; do
for color in 1 2 3 4 9 8 10 ; do
(( ii = $ii + 1 ))
cat <<eod>> tmp.param
s$ii linewidth 2
s$ii color $color
s$ii linestyle $style
eod
done
done

#cat tmp.param
pwd

if [ $var == "rstt" -o 0 = 0 ] ; then
 xmgrace `echo $sims | sed -e 's/_[0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9]//g'` -param tmp.param -legend load  -hardcopy -hdevice EPS -printfile tmp.eps
else
 xmgrace `echo $sims | sed -e 's/_[0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9]//g'` -param tmp.param  -hardcopy -hdevice EPS -printfile tmp.eps
fi

echo xmgrace `echo $sims | sed -e 's/_[0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9]//g'` -param tmp.param -legend load  -hardcopy -hdevice EPS -printfile tmp.eps

echo xmgrace $sims -param tmp.param -legend load  -hardcopy -hdevice EPS -printfile tmp.eps

epstopdf tmp.eps
mv -f tmp.pdf ${var}zon.pdf
convert ${var}zon.pdf ${var}zon.png

fi # sur existence de ${var}zon.p*

done

pwd
ls
