#!/bin/bash

comp=$1

local=`pwd -P`
login=`whoami`
hostname=`hostname`
if [ ${hostname:0:5} = cicla ] ; then
DODSDIR=/modfs/ipslfs/dods
HTML00=http://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/$login
machine=ciclad
fi
if [ ${hostname:0:5} = camel ] ; then
DODSDIR=/modfs/ipslfs/dods
fi
if [ ${hostname:0:5} = irene ] ; then
DODSDIR=
fi
if [ ${hostname:0:5} = jean- ] ; then
DODSDIR=
fi

COMP_D=$DODSDIR/$login/lmdz/MultiSimu/$comp
entetef=$COMP_D/entete.html

#############################################################################
echo YEARS $years
#############################################################################

compf=$COMP_D/AXE4.html
HTML=$HTML00/lmdz/MultiSimu/$comp



cat $entetef > $compf

echo '<hr>' >> $compf

cat <<eod>> $compf
<h1> Axe 4: climats polaires </h1>

<hr>
Responsable : Jean-Baptiste Madeleine  <br>
 jmadeleine@lmd.jussieu.fr <br>
Liste de diffusion : lmdz_poles@lmd.jussieu.fr

<h2> <a href="$HTML/AXE4/PRECIP/index.html"> Précipitation Antarctique (CloudSat) </a> </h2>

<h2> <a href="$HTML/AXE4/TZ1DC/index.html"> Température 1er niveau Dôme C (CALVA) </a> </h2>

</body>
</html>
eod

# CREATION DE LA PAGE+PDF: PRECIP
# -------------------------------

cat $entetef >| $COMP_D/AXE4/PRECIP/index.html

# Concaténer les figures sur une page
# Création de l'argument pour l'appel de concat_html.sh:
# Prendre la liste des chemins, isoler les noms de fichiers, enlever
# l'extension, faire une ligne, enlever la dernière virgule
# mais ne marche pas vraiment
#concatarg=`ls $COMP_D/AXE4/PRECIP/PNG/*.png | sed "s/.*\///" | \
#  sed "s/\.png//" | awk '{printf "%s,",$0}' | sed 's/\(.*\),/\1/'`
# plus manuel :
concatarg="" ; virg="" ; for i in `ls $COMP_D/AXE4/PRECIP/PNG/*.png | sed "s/.*\///" |   sed "s/\.png//"` ; do concatarg="$concatarg$virg$i" ; virg="," ; done


./concat_html.sh $COMP_D/AXE4/PRECIP/PNG "Precip CloudSat" $concatarg 4 >> $COMP_D/AXE4/PRECIP/index.html

# CREATION DE LA PAGE+PDF: TZ1DC
# ------------------------------

cat $entetef >| $COMP_D/AXE4/TZ1DC/index.html

# Concaténer les figures sur une page
# Création de l'argument pour l'appel de concat_html.sh:
# Prendre la liste des chemins, isoler les noms de fichiers, enlever
# l'extension, faire une ligne, enlever la dernière virgule
#concatarg=`ls $COMP_D/AXE4/TZ1DC/PNG/*.png | sed "s/.*\///" | \
#  sed "s/\.png//" | awk '{printf "%s,",$0}' | sed 's/\(.*\),/\1/'`


liste=`for s in \`awk ' { print $1"_"$2 } ' $COMP_D/def.txt\`; do sb=\`echo $s\` ; ( cd $COMP_D/AXE4/TZ1DC/PNG/ ; ls t*${sb}*png ; ls [pL]*${s}*png ; ls wi*${sb}*png ) ; done`
#liste=`for s in \`awk ' { print $1"_"$2 } ' $COMP_D/def.txt\`; do sb=\`echo $s | sed -e 's/\./-/g'\` ; ( cd $COMP_D/AXE4/TZ1DC/PNG/ ; ls t*${sb}*png ; ls [pL]*${s}*png ; ls wi*${sb}*png ) ; done`

echo LISTE $liste
concatarg=`echo $liste | sed -e 's/ /,/g' -e 's/.png//g'`
echo $concatarg 

mkdir -p $COMP_D/AXE4/TZ1DC/PNG/POUB ; mv $COMP_D/AXE4/TZ1DC/PNG/tso*png $COMP_D/AXE4/TZ1DC/PNG/POUB
./concat_html.sh $COMP_D/AXE4/TZ1DC/PNG "Tz1 dome C" $concatarg 5  >> $COMP_D/AXE4/TZ1DC/index.html


echo $compf | sed -e 's:/modfs/ipslfs/dods/:http\://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/:'

