#!/bin/bash

##########################################################################
# Concatenne une liste de fichiers fichA1,fichA2:fichB1,fichB2:fichC1,fichC2
# sous forme d'un LaTeX tabular et d'un html
##########################################################################

PNG_D=$1
title=$2
vvvvv=$3


if [ "$vvvvv" = "." ] ; then
   vvvvv=`ls $PNG_D/*.png | sed "s/.*\///" | \
  sed "s/\.png//" | awk '{printf "%s,",$0}' | sed 's/\(.*\),/\1/'`
fi



if [ "$#" = "4" ] ; then
   ligne=$4
   vvvv=`ic=0 ; sep="" ; list="" ; for i in \`echo $vvvvv | sed -e 's/[,\:]/ /g'\` ; do list="$list$sep$i" ; ((ic=$ic+1)) ; if [ $ic = $ligne ] ; then sep=":" ; ic=0 ; else sep="," ; fi ; done ; echo $list`
fi



cat <<eod
<table>

<h1> $2 <A HREF=`echo $PNG_D/index.pdf | sed -e 's:/prodigfs/ipslfs/dods/:http\://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/:'`> PDF </A></h1>
eod

for vvv in `echo $vvvv | sed -e 's/:/ /g'` ; do
   listetmp="`echo $vvv | sed -e 's/,/ /g'`"
   # Ecriture d'une ligne de 3 variables
   for vv in $listetmp ; do echo '<TD>' $vv '</TD>' ; done
   echo '<TR>' 
   for vv in $listetmp ; do
       file=$PNG_D/${vv}.png
       if [ -f $file ] ; then
          thredds=`echo $file | sed -e 's:/prodigfs/ipslfs/dods/:http\://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/:'`
          echo '<TD ALIGN=CENTER><A HREF="'$thredds'"><IMG HEIGHT=250 WIDTH=350 SRC="'$thredds'"></a></TD>'
       else
          echo '<TD>' Missing '</TD>'
       fi
   done
   echo '<TR>'
done


cat <<eod
</table>
eod


# Version Latex pdf

# Calcul du nombre de colonnes pour le tableau
nnn=0
for vvv in `echo $vvvv | sed -e 's/:/ /g'` ; do
   nn=`echo $vvv | sed -e 's/,/ /g' | wc -w`
   if [ $nn  -gt $nnn ] ; then nnn=$nn ; fi
done
lll="" ; i=0 ; while [ $i != $nnn ] ; do lll="${lll}l" ; (( i = i + 1 )) ; done


cat <<eod>| $PNG_D/index.tex
\documentclass{article}
\RequirePackage[babel,multidot,extendedchars,space]{grffile}
\usepackage{a4}
\usepackage{longtable}
\usepackage[landscape]{geometry}
\textwidth 27cm
\oddsidemargin -2cm
\topmargin -3cm
\textheight 20cm
\def\sizea{5cm}
\def\sizeb{8cm}
\pagestyle{empty}
\usepackage{graphicx}
\begin{document}
\begin{longtable}{$lll}
eod

for vvv in `echo $vvvv | sed -e 's/:/ /g'` ; do
   listetmp="`echo $vvv | sed -e 's/,/ /g'`"
   # Ecriture d'une ligne de 3 variables
   i=0
   for vv in $listetmp ; do
       (( i = $i + 1 )) ; if [ $i = `echo $listetmp | wc -w` ] ; then sep="" ; else sep='&' ; fi
       file=$PNG_D/${vv}.png
       if [ -f $file ] ; then
          echo '\includegraphics[width=\sizea]{'$file'} '$sep >> $PNG_D/index.tex 
       else
          echo Missing >> $PNG_D/index.tex 
       fi
   done
   echo '\\'  >> $PNG_D/index.tex 
   i=0
   for vv in $listetmp ; do
       (( i = $i + 1 )) ; if [ $i = `echo $listetmp | wc -w` ] ; then sep="" ; else sep='&' ; fi
       echo  $vv $sep  | sed -e 's/\_/\\_/g'  >> $PNG_D/index.tex
   done
   echo '\\'  >> $PNG_D/index.tex 
done


cat <<eod>> $PNG_D/index.tex
\end{longtable}
\end{document}
eod

cd $PNG_D
pdflatex index > out.tex 2>&1 
