# Definitions en fonction de la machine
# CICLAD
if [ ${hostname:0:5} = cicla ] ; then
########################################################################################################
# Environnement
module purge
module load netcdf4/4.3.3.1-ifort cdo/1.6.8 nco/4.5.2  ncl/6.3.0
ulimit -s unlimited
export PYTHONPATH=:/opt/canopy-1.3.0/Canopy_64bit/User/bin/python:/home/igcmg/prodiguer-client:/home/fabric/users/denvil/climaf:/home/fabric/users/denvil/climaf
export PATH=$PATH:/home/fabric/users/denvil/climaf/bin
STORAGE=$DODSDIR/$login/lmdz/STORE
if [ ! -d $DODSDIR/$login/climafCache ] ; then mkdir -p $DODSDIR/$login/climafCache ; fi
export CLIMAF_CACHE=$DODSDIR/$login/climafCache
echo CLIMAF_CACHE $DODSDIR/$login/climafCache
MULTIDIR=$DODSDIR/$login/lmdz/MultiSimu
DIRATLAS=$DODSDIR/$login/lmdz/atlas
########################################################################################################
ATLAS_DIR=$DODSDIR/$login/lmdz/atlas/Atlas$$
if [ ! -d $DODSDIR/$login/lmdz/atlas/Atlas$$ ] ; then mkdir -p $DODSDIR/$login/lmdz/atlas/Atlas$$ ; fi
fi
local=`pwd -P`

date

vars=""
vars="sst"
#runstxt=$local/../runs.txt

if [ $# = 1 ] ; then
   opts="`echo $1 | sed -e 's/,/ /g'`"
   for opt in $opts ; do
       echo $opt
       key=`echo $opt | cut -d= -f1`
       val=`echo $opt | cut -d= -f2`
       echo $key $val
       if [ "$key" = "RUN" ] ; then sim=$val ; fi
       if [ "$key" = "REF" ] ; then ref=$val ; fi
       if [ "$key" = "SEASON" ] ; then seas=$val ; fi
       if [ "$key" = "PROJ" ] ; then proj=$val ; fi
       if [ "$key" = "OUTDIR" ] ; then OUT_D=$val ; fi
       if [ "$key" = "RUNSTXT" ] ; then runstxt=$val ; fi
       if [ "$key" = "VARS" ] ; then vars="`echo $val | sed -e 's/+/,/g'`" ; fi
   done
elif [ $# = 0 ] ; then
   sim=$RUN
   ref=OBS
   seas=$SEASON
   proj=$PROJ
   OUT_D=$OUTDIR
   runstxt=$RUNSTXT
   vars=`echo $VARS | sed -e 's/+/,/g'`
else
  echo USE
  echo Job mode :
  echo $submit -v RUN=NPv5.3_1982_1989,SEASON=YEAR,PROJ=GLOB,OUTDIR=$MULTIDIR/V5/ATLAS,VARS=pr+tas atlas.sh
  echo interactif :
  echo ./atlas.sh RUN=NPv5.3_1982_1989,SEASON=YEAR,PROJ=GLOB,OUTDIR=$MULTIDIR/V5/ATLAS,VARS=pr+tas
  exit
fi

if [ "$vars" = "" ] ; then
   vars=pr,tas,hurs,hfls,hfss,albt,albtcs,albs,rldscs,rlds,rlus,rsdscs,rsds,rsuscs,rsus,rsutcs,rsut,rlut,rlutcs,psl,prw,sst,pme,tasmax,tasmin
fi

#,ua850,va850,ta850,ua500,va500,ta500,ua200,va200,ta200
echo sim $sim
srun=`echo $sim | sed -e 's/_[0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9]//'`
echo srun $srun
simdir=`grep -w "^$srun" $runstxt | awk ' { print $2 } '`
run=`basename $simdir `
years=`echo $sim | sed -e 's/'$srun'//' | sed -e 's/_//'`
sim=${run}_${years}
echo $run $years $sim $ref
echo ENTREES : $run, $years, $seas, $vars, $ref
echo simdir $simdir

echo run $run 
echo sim $sim
echo simdir $simdir

keys_strgv=$sim$seas$proj$vars$ref
keys_strg=$sim$seas$proj$ref

mkdir -p $OUT_D
if [ -f $OUT_D/$keys_strg.ENCOURS ] ; then 
   echo $OUT_D/$keys_strg.ENCOURS
   exit # Si le même atlas est deja en cours de realisation on sort
else
   touch $OUT_D/$keys_strg.ENCOURS
fi

if [ "$OUT_D" = "" ] ; then
   $OUT_D=$STORAGE/NPV5LRL79/$run/ATLAS/SE_$years/ATM
fi

cd $ATLAS_DIR
echo sim $sim seas $seas > atlas.sh.log

###########################################################################
# Boucle pour construire l'atlas en plusieurs passages
echo IL FAUT FAIRE L ATLAS EN PLUSIEURS PASSAGE SINON CA PLANTE ...
###########################################################################

case "$proj" in
   "SH"|"NH") pyatlas="atlas_SH.py --projection $proj" ;;
   "GLOB") Var3D=,ua,va,ta,hus,hur ; pyatlas=atlas_none.py ;;
esac


npass=5
ipass=1

while [ $ipass -le $npass ] ; do

   echo Nettoyage des fichiers corrompus du cache
   $local/clean_cache.sh $DIRATLAS
   echo passage $ipass >> atlas.sh.log
   html=index_example_"$seas"_"$sim".html
   htmlopt=index_${proj}_"$seas"_"$sim".html
   rm -f $html
   echo python $local/$pyatlas -v $vars -s `basename $simdir`_$years -t $ref -p $seas --root $simdir/ATM/Analyse/SE
   python $local/$pyatlas -v $vars -s `basename $simdir`_$years -t $ref -p $seas --root $simdir/ATM/Analyse/SE

   if [ ! -f "$html"  -o "`wc -l $html | awk ' { print $1 } '`" = "0" ] ; then
      echo ECHEC ATLAS : $html inexistant ou vide | tee >>  atlas.sh.log
      echo ECHEC ATLAS : $html inexistant ou vide
   else
      echo cp -f $html tmp$$.$passage
      cp -f $html tmp$$.$passage
      pwd
      echo tmp$$.$passage
      echo LS  LS
      ls -lrt | tail
# A ADAPTER en fonction de la machine
      sed -e "s:/prodigfs/ipslfs/dods/:/thredds/fileServer/IPSLFS/:g" tmp$$.$passage >| $htmlopt
      \cp -f $htmlopt $OUT_D/
      PathHtml=`echo $OUT_D/$htmlopt | sed -e 's:/prodigfs/ipslfs/dods/:http\://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/:'`
      echo NOUVEL ATLAS DISPONIBLE SUR $PathHtml | tee >>  atlas.sh.log
      echo NOUVEL ATLAS DISPONIBLE SUR $PathHtml
      echo $keys_strgv >> $OUT_D/atlas_OK
      echo ${sim}+${seas}+${proj}+$vars >> $OUT_D/atlas_OK
   fi
   (( ipass = $ipass + 1 ))

done

\rm -f $OUT_D/$keys_strg.ENCOURS
