#!/bin/bash
# Par exemple:
# ./make_axe4.sh V6.5AIS8

# -----------------------------------------------------------------

if [ $# -ne 1 ]
then
  echo "Example: ./make_axe4.sh V6.5AIS8"
exit
fi

# -----------------------------------------------------------------
# Based on /home/fabric/LMDZ/UTILS/config.sh

comp=$1

season=YEAR
GR=VLR
MAIN_SE=/prodigfs/ipslfs/dods/fabric/lmdz/SE
EXPNAME=NPV5LRL79
STOREDIR=/prodigfs/ipslfs/dods/fabric/lmdz/STORE/$EXPNAME
MULTIDIR=/prodigfs/ipslfs/dods/fabric/lmdz/MultiSimu
COMP_D=$MULTIDIR/$comp
runstxt=/home/fabric/LMDZ/MultiSimu/runs.txt
if [ ! -d $COMP_D ] ; then echo "$COMP_D not found" && exit ; fi

# Liste des simulations de la comparasion $comp
# -----------------------------------------------------------------
liste_sim=""
DEF_FILE=$COMP_D/def.txt
for s in `awk ' {print $1} ' $DEF_FILE` ; do liste_sim="$liste_sim $s" ; done

# -----------------------------------------------------------------
# Comparaison to CloudSat precipitation rates over Antarctica
# -----------------------------------------------------------------

outputdir=$COMP_D/AXE4/PRECIP/PNG
if [ ! -d $outputdir ]
then
  mkdir -pv $outputdir
else
  echo "$outputdir has been found."
fi

# PLOT OBSERVED PRECIP
cmdtmp="./AXE4/make_axe4-map-precip-obs.py -o $outputdir"
echo $cmdtmp && ./$cmdtmp

# PLOT SIMULATION RESULTS
if [ 0 = 0 ] ; then
for sim in  $liste_sim ; do
  years=`grep '^'$sim' ' $DEF_FILE | awk ' { print $2 }'`
  echo FICHIERS POUR LA SIMULATION $sim annees $years
  simdir=`grep -w "^$sim "  $runstxt | awk ' { print $2 } '`
  run=`basename $simdir `
#  input=/prodigfs/ipslfs/dods/fabric/lmdz/SE/ORIG/${sim}_SE_${years}_1M_histmth.nc
  input=$simdir/ATM/Analyse/SE/${run}_SE_${years}_1M_histmth.nc
  if [ -e $input ]
  then
    cmdtmp="./AXE4/make_axe4-map-precip.py -i $input -o $outputdir"
    echo $cmdtmp && ./$cmdtmp
  else
    echo $input' file not found'
  fi
# -----------------------------------------------------------------
done
fi
 

# -----------------------------------------------------------------
# Comparaison to Dome C temperatures (40m mast)
# -----------------------------------------------------------------

outputdir=$COMP_D/AXE4/TZ1DC/PNG
if [ ! -d $outputdir ]
then
  mkdir -pv $outputdir
else
  echo "$outputdir has been found."
fi

# PLOT SIMULATION RESULTS
for sim in  $liste_sim ; do
  years=`grep '^'$sim' ' $DEF_FILE | awk ' { print $2 }'`
  echo FICHIERS POUR LA SIMULATION $sim annees $years
#  input=/prodigfs/ipslfs/dods/fabric/lmdz/SE/ORIG/${sim}_SE_${years}_1M_histmth.nc
  simdir=`grep -w "^$sim "  $runstxt | awk ' { print $2 } '`
  run=`basename $simdir ` 
  input=$simdir/ATM/Analyse/SE/${run}_SE_${years}_1M_histmth.nc
  if [ -e $input ]
  then
    cmdtmp="./AXE4/make_axe4-temp-DC-mast.py -i $input -o $outputdir"
    echo $cmdtmp && ./$cmdtmp
    ( cd ./AXE4/ETIENNE3/ ; ./plot.sh -i $input -o $outputdir ; cd ../.. )
  else
    echo $input' file not found'
  fi
# -----------------------------------------------------------------
done

