#!/bin/bash

#################################################################################
# A.I  : 1e version : Decembre 2019
# Reprise Mars 2020
# installer les scripts de post-traitement multi-atlas pour LMDZ sur une machine
# le packege sera integrer sous svn aux sources du modele ..../BOL/
# Ce script permet de definir les differents repertoires en fonction de la machine
# Permet de creer les sscripts job_multi.sh et atlas.sh
#################################################################################
# Definition des coleurs d'affichage
noir='\e[0;30m' gris='\e[1;30m' rougefonce='\e[0;31m' rose='\e[1;31m' vertfonce='\e[0;32m' vertclair='\e[1;32m' orange='\e[0;33m' jaune='\e[1;33m' bleufonce='\e[0;34m' bleuclair='\e[1;34m' violetfonce='\e[0;35m' violetclair='\e[1;35m' cyanfonce='\e[0;36m' cyanclair='\e[1;36m' grisclair='\e[0;37m' blanc='\e[1;37m' neutre='\e[0;m'
# AI avril 2020 : A FAIRE :
# A FAIRE
# Utiliser des fonctions entete, ...
# A function pour definir l entete du job en fonction de la machine
#function jobentete { #1er argument doit etre le nom de la machine 

hostname=`hostname`
login=`whoami`

# CICLAD
if [ ${hostname:0:5} = cicla ] ; then
DODSDIR=/prodigfs/ipslfs/dods
cat <<eod >> entete.sh
#PBS -N atlas
#PBS -m a
#PBS -j oe
#PBS -q h12
#PBS -o atlasNOMSIMULATION.out
#PBS -S /bin/bash
#PBS -l nodes=1:ppn=1
#PBS -l mem=30gb
#PBS -l vmem=30gb
#
# Commande pour soumettre en bash
submit=qsub

login=$login
DODSDIR=$DODSDIR
eod

cat <<eod >> defatlasenv.sh
###########################################################################
# Environnement
module list
which python
ulimit -s unlimited
ATLAS_DIR=$DODSDIR/$login/lmdz/atlas/Atlas$$ ; mkdir -p $ATLAS_DIR
export PYTHONPATH=$PYTHONPATH:/home/fabric/users/denvil/climaf
export PATH=$PATH:/home/fabric/users/denvil/climaf/bin
STORAGE=$DODSDIR/$login/lmdz/STORE
if [ ! -d $DODSDIR/$login/climafCache ] ; then mkdir -p $DODSDIR/$login/climafCache ; fi
export CLIMAF_CACHE=$DODSDIR/$login/climafCache
echo CLIMAF_CACHE $CLIMAF_CACHE
MULTIDIR=$DODSDIR/ipslfs/dods/$login/lmdz/MultiSimu
###########################################################################
eod

fi

# CLIMSERV
if [ ${hostname:0:5} = camel ] ; then
DODSDIR=/prodigfs/ipslfs/dods
cat <<eod > entete.sh
#PBS -N atlas
#PBS -m a
#PBS -j oe
#PBS -q h12
#PBS -o atlasNOMSIMULATION.out
#PBS -S /bin/bash
#PBS -l nodes=1:ppn=1
#PBS -l mem=30gb
#PBS -l vmem=30gb
#
# Commande pour soumettre en bash
submit=qsub
eod
fi

# IRENE
if [ ${hostname:0:5} = irene ] ; then
cat <<eod > definerep.sh
MAIN_SE=
TS_DA=
TS_MO=
MULTIDIR=
groupe=
eod
cat <<eod > entete.sh
######################
## IRENE   TGCC/CEA ##
######################
#MSUB -r multiatlas            # Job name
#MSUB -o multi.out_%I
#MSUB -e multi.out_%I
#MSUB -n 1
#MSUB -T 36000         # Maximum elapsed time
#MSUB -q xlarge 
#MSUB -c 8
#MSUB -Q normal
#MSUB -A $groupe
#MSUB -m store,work,scratch
#
# Commande pour soumettre en bash
submit=ccc_msub
eod
fi

# JEAN-
if [ ${hostname:0:5} = jean- ] ; then
cat <<eod > definerep.sh
MAIN_SE=
TS_DA=
TS_MO=
MULTIDIR=
groupe=
eod
cat <<eod > entete.sh
######################
## IRENE   TGCC/CEA ##
######################
#MSUB -r multiatlas            # Job name
#MSUB -o multi.out_%I
#MSUB -e multi.out_%I
#MSUB -n 1
#MSUB -T 36000         # Maximum elapsed time
#MSUB -q xlarge 
#MSUB -c 8
#MSUB -Q normal
#MSUB -A $groupe
#MSUB -m store,work,scratch
#
# Commande pour soumettre en bash
submit=sbash
eod
fi

# PC (formation et perso linux)

# Machines locales lmd

MULTIDIR=$DODSDIR/ipslfs/dods/$login/lmdz/MultiSimu
if [ ! -d $MULTIDIR ] ; then mkdir -p $MULTIDIR ; fi

echo -e "${noir}%%%%%%%%%%%%%%%%%%%%%%%%% ${rougefonce} MULTIATLAS LMDZ ${noir}%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
echo -e "${bleufonce}" To create your multi-atlas you needs :
echo 1.  to create your multiatlas directory "example Multi01" :
echo    - mkdir -p /prodigfs/ipslfs/dods/YourLoginName/lmdz/MultiSimu/Multi01
echo 2.  to define some characeristics of your multi-atlas "names, dates, description of simulations and atlas variables" :
echo    - cp Utils/def.txt  Utils/atlas-def /prodigfs/ipslfs/dods/YourLoginName/lmdz/MultiSimu/Multi01/.
echo     define "names, date, description" of simulations in file :
echo    - /prodigfs/ipslfs/dods/YourLoginName/lmdz/MultiSimu/Multi01/def.txt
echo     define atlas variables in file
echo    - /prodigfs/ipslfs/dods/YourLoginName/lmdz/MultiSimu/Multi01/atlas.def

rm -f job_multi.sh
cat entete.sh >| job_multi.sh 
cat Utils/multi.sh >> job_multi.sh
chmod +x job_multi.sh

rm -f atlas.sh
cat entete.sh >| atlas.sh
cat defatlasenv.sh >> atlas.sh
cat Utils/atlas0.sh >> atlas.sh
chmod +x atlas.sh
\mv atlas.sh atlas/.

echo Then you can run your multiatlas :
echo ./job_multi.sh Multi01
echo -e "${noir}%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
