#!/bin/bash

#A REFAIRE 

local=`pwd -P`
login=`whoami`
hostname=`hostname`
if [ ${hostname:0:5} = cicla ] ; then
DODSDIR=/prodigfs/ipslfs/dods
HTML00=http://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/$login
machine=ciclad
fi
if [ ${hostname:0:5} = camel ] ; then
DODSDIR=/prodigfs/ipslfs/dods
fi
if [ ${hostname:0:5} = irene ] ; then
DODSDIR=
fi
if [ ${hostname:0:5} = jean- ] ; then
DODSDIR=
fi

runstxt=$local/runs.txt
PREF_F=$DODSDIR
PREF_W=http\://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS
MULTIDIR=$PREF_F/$login/lmdz/MultiSimu
#BASE_D=/home/fabric/users/dcugnet
BASE_D=$local/LMA
OUT_D=/prodigfs/$login/LMDZ6/AXE2/LMA_LMDZ
#TS_DA=$PREF_F/fabric/lmdz/TS_DA

#=== CHECK WETHER REQUIRED ARGUMENT HAS IS PRESENT
if [ $# -ne 1 ]; then
  echo "This script needs a single argument: the comparison name"
  echo "   (the name of the folder containing the def.txt file)"
  exit
fi
comp=$1

#=== CHECK WETHER GIVEN ARGUMENT IS VALID
COMP_D=$MULTIDIR/$comp
if [ ! -f $COMP_D/def.txt ]; then
  echo "Nonexisting comparison file $COMP_D/def.txt"; exit
fi

#=== SOME MORE PATHS/FILES
AXE_D=$COMP_D/AXE2; if [ ! -d $AXE_D/AXE2 ]; then mkdir -p $AXE_D/AXE2; fi
FIG_D=$AXE_D/METRICS         #--- FIGURES STORAGE PATH
headf=$COMP_D/entete.html    #--- HTML PAGES HEADER
compf=$COMP_D/lma2.html       #--- GENERATED HTML PAGE
if [ ! -d $FIG_D ]; then mkdir -p $FIG_D; fi
AXE_W=$(echo $AXE_D | sed -e "s%$PREF_F%$PREF_W%")
FIG_W=$(echo $FIG_D | sed -e "s%$PREF_F%$PREF_W%")
webf=$AXE_W/lma.html
PLOT_D=$BASE_D/LMA_LMDZ/$comp

#=== GENERATE THE pdf FILES ; CONVERT THEM INTO png FILES
cd $PLOT_D
./plot_lma.bash
for f in `ls *.pdf`; do convert -density 600 $f -resample 600 $FIG_D/${f%.*}.png; done
cd - 1> /dev/null

#=== BUILD THE HTML PAGE
boxes=($(ls $FIG_D/boxes_*.png))
modes=($(ls $FIG_D/modes_*.png))
cat $headf                                                             > $compf
echo "</style> </head> <body>"                                        >> $compf
echo "<h2> Local Modes Analysis (LMA) </h2>"                          >> $compf
echo "<hr/> <!--- this draws a line --->"                             >> $compf
echo "<div width=100%>"                                               >> $compf
echo "<table>"                                                        >> $compf
for i in $(eval echo {1..${#boxes[@]}}); do
  box=${boxes[$((i-1))]}; mod=${modes[$((i-1))]}
  echo "<tr><td><img src="$FIG_W/${box##*/}" width="100%" border=0></td></tr>" >> $compf
  echo "<tr><td><img src="$FIG_W/${mod##*/}" width="100%" border=0></td></tr>" >> $compf
done
echo "</table>"                                                       >> $compf

echo $compf | sed -e "s%$PREF_F%$PREF_W%"
