#!/bin/bash


comp=$1

local=`pwd -P`
login=`whoami`
hostname=`hostname`
if [ ${hostname:0:5} = cicla ] ; then
DODSDIR=/prodigfs/ipslfs/dods
HTML00=http://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/$login
machine=ciclad
fi
if [ ${hostname:0:5} = camel ] ; then
DODSDIR=/prodigfs/ipslfs/dods
fi
if [ ${hostname:0:5} = irene ] ; then
DODSDIR=
fi
if [ ${hostname:0:5} = jean- ] ; then
DODSDIR=
fi

COMP_D=$DODSDIR/$login/lmdz/MultiSimu/$comp
entetef=$COMP_D/entete.html

local=`pwd`


compf=$COMP_D/AXE7.html
HTML=$HTML00/lmdz/MultiSimu/$comp

DIRST=$DODSDIR/$login/lmdz/STATIONS
HTMLST=$HTML00/lmdz/STATIONS

DEF_FILE=$COMP_D/def.txt


if [ -f $entetef ] ; then cat $entetef > $compf ; else \rm -f $compf ; touch $compf ; fi

echo '<hr>' >> $compf

cat <<eod>> $compf
<h1> Comparaison aux stations </h1>

<hr>
Responsable : Fredho <br>

eod

liste_sim=""
for s in `awk ' {print $1} ' $DEF_FILE | uniq` ; do liste_sim="$liste_sim $s" ; done


# Regroupement des fichiers images stations concernes
#----------------------------------------------------
mkdir -p $COMP_D/STATIONS ; cd $COMP_D/STATIONS

sortir=1
for s in  $liste_sim  ; do
   if [ -d $DIRST/Figure_AMMA/$s -o -d $DIRST/Figure_SIRTA/$s -o -d $DIRST/Figure_SGP/$s ] ; then
      ln -sf $DIRST/Figure_AMMA/$s/*png .
      ln -sf $DIRST/Figure_SIRTA/$s/*png .
      ln -sf $DIRST/Figure_SGP/$s/*png .
      sortir=0
   fi
done

if [ $sortir = 0 ] ; then

# html multi simulations par station
# ----------------------------------
virgu=""
for year in 2006 2007 2009 2011 2012; do
   echo '<li><h2> '$year' :' >> $compf
   for station in wj ba ag na SIRTA SGP  ; do
     if [ "`ls *${station}*_${year}.png`" != "" ] ; then
      lvar=( `ls *${station}*_${year}.png | cut -d_ -f1 | uniq` )
      echo ${lvar[*]}
      echo ${#lvar[@]}
      lsim=( $liste_sim )
       lpng="" ; virg="" ; for var in ${lvar[*]} ; do for s in $liste_sim ; do file=${var}_${station}_${s}_${year} ; echo FILE $file ; if [ -f "$file.png" ] ; then lpng="$lpng$virg$file" ; fi ; virg="," ; done  ; done
      ~/LMDZ/MultiSimu/concat_html.sh . "OK" $lpng ${#lsim[@]} > $station$year.html
cat <<eod>> $compf
$virgu <a href="$HTML/STATIONS/$station$year.html"> $station </a>
eod
virgu=","
     fi
   done
   echo '</li></h2>' >> $compf
done


cd $local

for figu in AMMA SIRTA SGP; do
cat <<eod>> $compf
<li><h2> $figu simulation  :
eod
virg=""
for s in $liste_sim ; do
if [ -d $DIRST/Figure_$figu/$s ] ; then
cat <<eod>> $compf
$virg <a href="$HTMLST/Figure_$figu/$s/index2006.html"> $s </a>
eod
virg=,
fi
done
cat <<eod>> $compf
</li></h2>
eod
done

fi # sortir=0


if [ -d $COMP_D/STATSE ] ; then
cat <<eod>> $compf
<br><hr><br>
<h2><li><a href="$HTML/STATSE/index.html"> Cycle saisonniers moyens aux bouees </a> </li></h2>
eod
fi

cat <<eod>> $compf
</body>
</html>
eod


echo $compf | sed -e 's:/prodigfs/ipslfs/dods/:http\://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/:'
