#!/bin/bash
set -vx

comp=$1

local=`pwd -P`
login=`whoami`
hostname=`hostname`
if [ ${hostname:0:5} = cicla ] ; then
DODSDIR=/prodigfs/ipslfs/dods
HTML00=http://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/$login
machine=ciclad
fi
if [ ${hostname:0:5} = camel ] ; then
DODSDIR=/prodigfs/ipslfs/dods
fi
if [ ${hostname:0:5} = irene ] ; then
DODSDIR=
fi
if [ ${hostname:0:5} = jean- ] ; then
DODSDIR=
fi

COMP_D=$DODSDIR/$login/lmdz/MultiSimu/$comp
entetef=$COMP_D/entete.html

#############################################################################
#echo YEARS $years
#############################################################################

compf=$COMP_D/AXE1.html
HTML=$HTML00/lmdz/MultiSimu/$comp

cat $entetef > $compf

echo '<hr>' >> $compf

cat <<eod>> $compf
<h1> Axe 1: Surface Continentale </h1>

<hr>
Responsable : Frédérique Chéruy   <br>
 cheruy@lmd.jussieu.fr <br>
Liste de diffusion : lmdz_continent@lmd.jussieu.fr

<h2> EXTREMA  diurne lmdz  </h2>

<h3> <a href="$HTML/AXE1/JJA/MAX/lmdz/index.html"> Maximum journalier JJA </a> </h3>

<h3> <a href="$HTML/AXE1/JJA/MIN/lmdz/index.html"> Minima journalier JJA </a> </h3>

<h3> <a href="$HTML/AXE1/DJF/MAX/lmdz/index.html"> Maximum journalier DJF </a> </h3>

<h3> <a href="$HTML/AXE1/DJF/MIN/lmdz/index.html"> Minima journalier  DJF </a> </h3>

<h2> EXTREMA  diurne obs </h2>

<h3> <a href="$HTML/AXE1/JJA/MAX/obs/index.html"> Maximum journalier JJA </a> </h3>

<h3> <a href="$HTML/AXE1/JJA/MIN/obs/index.html"> Minima journalier JJA </a> </h3>

<h3> <a href="$HTML/AXE1/DJF/MAX/obs/index.html"> Maximum journalier DJF </a> </h3>

<h3> <a href="$HTML/AXE1/DJF/MAX/obs/index.html"> Minima journalier DJF </a> </h3>


<h2> BIAIS EXTREMA DIURNE OBS  </h2>

<h3> <a href="$HTML/AXE1/JJA/MAX/biais/index.html"> Biais du Maximum journalier JJA lmdz-CRU </a> </h3>

<h3> <a href="$HTML/AXE1/JJA/MIN/biais/index.html"> Biais du Minimum journalier JJA lmdz-CRU </a> </h3>

<h3> <a href="$HTML/AXE1/DJF/MAX/biais/index.html"> Biais du Maximum journalier DJF lmdz-CRU </a> </h3>

<h3> <a href="$HTML/AXE1/DJF/MIN/biais/index.html"> Biais du Minimum journalier DJF lmdz-CRU </a> </h3>

<h2> River discharge  </h2>
 
<h3> <a href="$HTML/AXE1/River/index.html"> River discharge </a> </h3>

eod


# Concaténer les figures sur une page
# Création de l'argument pour l'appel de concat_html.sh:
# Prendre la liste des chemins, isoler les noms de fichiers, enlever
# l'extension, faire une ligne, enlever la dernière virgule

for sim    in lmdz obs biais ; do
for OP    in MAX MIN ; do
for SEAS in  JJA DJF ; do
cat $entetef >| $COMP_D/AXE1/index.html
concatarg=`ls $COMP_D/AXE1/$SEAS/$OP/$sim/*.png | sed "s/.*\///" | \
  sed "s/\.png//" | awk '{printf "%s,",$0}' | sed 's/\(.*\),/\1/'`
$local/concat_html.sh $COMP_D/AXE1/$SEAS/$OP/$sim "extrema journaliers " $concatarg 3 >> $COMP_D/AXE1/$SEAS/$OP/$sim/index.html
done
done
done

# A REFAIRE
echo $compf | sed -e 's:/prodigfs/ipslfs/dods/:http\://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/:'

