#!/bin/bash

mkdir -p WORK$$
cd WORK$$

wget="wget -t 1"

vars="pourc_ter pourc_oce w500 cldh cldl cldm cldq cldt evap flat pluc plul precip prw psol q2m sens sicf slp soll soll0 sols sols0 t2m topl0 topl tops0 tops tsol u10m v10m wind10m clhcalipso clmcalipso cllcalipso cltcalipso"

simu=$1
echo simu $simu
run=`echo $simu | sed -e 's/_[0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9]//'`

echo run $run

years=`echo $simu | sed -e 's/'$run'//' | sed -e 's/_//'`
ANS_deb=`echo $years | cut -c1-4`
ANS_fin=`echo $years | cut -c6-9`
echo years $years

runstxt=/home/fabric/LMDZ/MultiSimu/runs.txt
simdir=`grep -w "^$run " $runstxt | awk ' { print $2 } '`
echo simdir $simdir
sim=`basename $simdir `

for var in $vars ; do
echo sim ${sim:0:4}
time=${ANS_deb}0101_${ANS_fin}1230
file=${sim}_${time}_1M_$var.nc
echo $file

if [ ! -f $simdir/ATM/Analyse/TS_MO/$file ] ; then

if [ "${sim:0:2}" = "MR" ] ; then
   #$wget http://dodsp.idris.fr/rdzt401/MTH/$file
   echo Voir si les TS existent dans ce cas
elif [ "${sim}" = "CM605-LR-sstClim-01" ] ; then
# A definr la decinie pour le couple
     $wget https://esgf.extra.cea.fr/thredds/fileServer/store_thredds/p86denv/IPSLCM6/PROD/clim/$sim/ATM/Analyse/TS_MO/$file
elif [ "${sim:0:5}" = "CM605" ] ; then
    case $sim in
        CM605-LR-pdCtrl-01|CM605.THC1-LR-pdCtrl-01) login=p86caub ;;
        CM605.calv-LR-pdCtrl-02|CM605.dt20-LR-pdCtrl-02) login=p86mart ;;
        CM605.NOSU-LR-pdCtrl-02|CM605.NOSU-LR-pdCtrl-03) login=p86maf ;;
        CM605.Z0-LR-pdCtrl-01|CM605.GUST-LR-pdCtrl-01) login=p529tra ;;
        *) exit
    esac
    $wget https://esgf.extra.cea.fr/thredds/fileServer/store_thredds/$login/IPSLCM6/DEVT/pdControl/$sim/ATM/Analyse/TS_MO/$file

elif [ "${sim:0:4}" = "NPv5" ] ; then
      if [ "${sim:0:6}" = "NPv5.8" ] || [ "$sim" = "NPv5.70svn2685" ] || [ "$sim" = "NPv5.MixAdiab" ] || [ "$sim" = "NPv5.V5.70Orolf" ] || [ "$sim" = "NPv5.70OrodrOrolf" ] || [ "$sim" = "NPv5.vn2709" ] || [ "$sim" = "NPv5.vn2709cv72" ] ; then
         echo $wget https://esgf.extra.cea.fr/thredds/fileServer/store_thredds/aidel/LMDZOR/DEVT/clim/$sim/ATM/Analyse/TS_MO/$file
         $wget https://esgf.extra.cea.fr/thredds/fileServer/store_thredds/aidel/LMDZOR/DEVT/clim/$sim/ATM/Analyse/TS_MO/$file
      else
         echo $wget http://esgf.extra.cea.fr/thredds/fileServer/store/aidel/LMDZOR/DEVT/clim//$sim/ATM/Analyse/TS_MO/$file
         $wget $wget http://esgf.extra.cea.fr/thredds/fileServer/store/aidel/LMDZOR/DEVT/clim//$sim/ATM/Analyse/TS_MO/$file
      fi

elif [ "${sim:0:4}" = "LMDZ" ] ; then
    echo $wget https://esgf.extra.cea.fr/thredds/fileServer/store_thredds/aidel/LMDZOR/DEVT/clim/$sim/ATM/Analyse/TS_MO/$file
    $wget https://esgf.extra.cea.fr/thredds/fileServer/store_thredds/aidel/LMDZOR/DEVT/clim/$sim/ATM/Analyse/TS_MO/$file

elif [ "${sim:0:7}" = "NPv4.12" ] ; then
   $wget http://dodsp.idris.fr/rlmd093/IGCM_OUT/LMDZOR/DEVT/clim/$sim/ATM/Analyse/TS_MO/$file
elif [ "${sim:0:8}" = "AR4.0ada" -o "${sim:0:9}" = "NPv3.1ada" ] ; then
   $wget http://dodsp.idris.fr/rlmd093/IGCM_OUT/LMDZOR/DEVT/CLIM/$sim/ATM/Analyse/TS_MO/$file
elif [ "${sim:0:6}" = "CPL6v5" ] ; then
   $wget http://dods.extra.cea.fr/store/p86fair/IPSLCM6/PROD/piControl/$sim/ATM/Analyse/TS_MO/$file
elif [ "${sim:0:16}" = "v5.5pftXORCA1V01" ] ; then
   $wget http://dods.extra.cea.fr/store/p86fair/IPSLCM6/PROD/piControl/${sim}_tmp/ATM/Analyse/TS_MO/$file
elif [ "${sim:0:18}" = "CL5.CWRR90mSu.3607" ] ; then
   $wget http://esgf.extra.cea.fr/thredds/fileServer/store/p86ghatt/LMDZOR/PROD/ref3607/${sim}/ATM/Analyse/SE/$file
elif [ "${sim:0:22}" = "CL5.CWRR90msnowSu.3607" ] ; then
   $wget http://esgf.extra.cea.fr/thredds/fileServer/store/p86ghatt/LMDZOR/PROD/ref3607/${sim}/ATM/Analyse/TS_MO/$file
elif [ "${sim:0:16}" = "CL5.CWRRcSu.3607" ] ; then
   $wget http://esgf.extra.cea.fr/thredds/fileServer/store/p86ghatt/LMDZOR/PROD/ref3607/${sim}/ATM/Analyse/TS_MO/$file
elif [ "${sim:0:22}" = "CL5.CWRR90msnowZ0.3607" ] ; then
   $wget http://esgf.extra.cea.fr/thredds/fileServer/store/p86ghatt/LMDZOR/PROD/ref3607/${sim}/ATM/Analyse/TS_MO/$file
elif [ "${sim:0:18}" = "CL5.CWRR90mZ0.3607" ] ; then
   $wget http://esgf.extra.cea.fr/thredds/fileServer/store/p86ghatt/LMDZOR/PROD/ref3607/${sim}/ATM/Analyse/TS_MO/$file
#elif [ "${sim:0:18}" = "CL5.CWRR90mSu.3525" ] ; then
#   $wget http://dods.extra.cea.fr/store/p86ghatt/LMDZOR/PROD/ref3525/${sim}/ATM/Analyse/SE/$file
#echo OK c est la ; exit
elif [ "${sim:0:12}" = "v5.5XORCA1V01" ] ; then
   $wget http://dods.extra.cea.fr/store/p86fair/IPSLCM6/PROD/piControl/${sim}/ATM/Analyse/TS_MO/$file
elif [ "${sim:0:12}" = "v5.63XORCA1T" ] ; then
   $wget http://dods.extra.cea.fr/store/p86fair/IPSLCM6/PROD/piControl/${sim}_temp/ATM/Analyse/TS_MO/$file
elif [ "${sim:0:5}" = "v5.5X" ] ; then
   $wget http://dods.extra.cea.fr/store/p86fair/IPSLCM6/PROD/piControl/$sim/ATM/Analyse/TS_MO/$file
elif [ "${sim:0:4}" = "AMIP" ] ; then
   $wget http://dods.extra.cea.fr/store/mellull/LMDZOR/PROD/amip/$sim/ATM/Analyse/TS_MO/$file
elif [ "${sim:2:12}" = ".historical1" ] ; then
   $wget http://dods.extra.cea.fr/store/p86denv/IPSLCM5A/PROD/historical/v3.historical1/ATM/Analyse/TS_MO/$file
elif [ "${sim:2:8}" = ".histNP1" ] ; then
   $wget http://dods.extra.cea.fr/store/p86fair/IPSLCM5B/PROD/historical/v5.histNP1/ATM/Analyse/TS_MO/$file
elif [ "${sim:2:15}" = ".historicalCMR5" ] ; then
   $wget http://dods.extra.cea.fr/store/p86maf/IPSLCM5A-MR/PROD/historical/v5.historicalCMR5/ATM/Analyse/TS_MO/$file
elif [ "${sim:0:11}" = "ADA2016COMP" ] ; then
   $wget http://dods.idris.fr/rlmd007/LMDZOR/PROD/clim/$sim/ATM/Analyse/TS_MO/$file
elif [ "${sim:0:7}" = "MP65vd2" ] ; then
#   $wget http://dods.extra.cea.fr/store/p86musat/Tuning_runs/tun141479_svn2574_xios2/$sim/TS_MO/$file
    echo TS pour ce cas ?
elif [ "${sim:0:7}" = "MP68vd2" ] ; then
#   $wget http://dods.extra.cea.fr/store/p86musat/Tuning_runs/tun141479_svn2574_xios2/$sim/$file
    echo TS pour ce cas ?
elif [ "${sim:0:2}" = "T0" ] ; then
   fileb=`echo $file | sed -e 's/T0//'`
   simb=`echo $sim | sed -e 's/T0//'`
   echo FILEB $fileb
  # $wget http://dods.extra.cea.fr/store/p86musat/Tuning_runs/tun141479_svn2468/$simb/$fileb
   echo TS pour ce cas ?
   \mv -f $fileb $file
else
   echo Cas non prevu
   exit
fi

if [ ! -d $simdir/ATM/Analyse/TS_MO ] ; then
mkdir -p $simdir/ATM/Analyse/TS_MO
fi

mv $file $simdir/ATM/Analyse/TS_MO/
else
echo Le fichier $file est deja rapatrie
fi
done
