# -*- coding: iso-8859-1 -*-
# Created : S.Snsi - nov 2015


desc="\nMoyenne par saison et projection des donnees mono-variables issues des donnees SE\n"+\
"    avec ecriture sur fichier \n"+\
"  Exemple : python season.py -s NPv3.1ada_1982_1991 --seasons DJF -g VLR "

Nota=""" Avec CliMAF, cette etape est loin d'etre necessaire; on la realise
 pour 'exposer' ces fichiers dans une arborescence a laquelle sont
 habitues certains utilisateurs On ne se repose pas sur l'existence de
 fichiers dit 'cmorises', : on accde directement aux donnees SE via
 le 'projet' CliMAF adhoc (cf infra) """

dir_default='/data/hourdin/LMDZ6/'

# Rpertoire de base pour les entres et les rsultats
seasons_default='JJA,YEAR,DJF'

# Gestion des options et arguments d'appel
from optparse import OptionParser
parser = OptionParser(desc) ; parser.set_usage("%%prog [-h]\n%s" % desc)
parser.add_option("-i", "--input", help="repertoire des donnes SE d'origine (optionnel)", action="store")
parser.add_option("-o", "--output", 
                  help="repertoire de sortie (un sous rep <GRID>/<SEASON>/<SIMU> sera cree)(defaut : %s)"%dir_default, 
                  action="store",default=dir_default)
parser.add_option("-p", "--seasons", help="saisons a traiter, separees par des virgules "
                  "(defaut=%s)"%`seasons_default`, action="store", default=seasons_default)
parser.add_option("-g", "--grid", help="nom de grille", action="store",default='')
parser.add_option("-s", "--simulations", help="simulation+annees a traiter (sim_YYY1_YYY2)"
                  "(separees par des virgules)(defaut : toutes)", action="store",default=None)
parser.add_option("-f", "--force", help="force le recalcul de champs existants", 
                  action="store_true",default=None)
(options, args) = parser.parse_args()

#---------------------------------------------------------------------------------
from climaf.api import *
# La description de l'organisation des donnes SE, des alias et rescalings 
# et de la gestion des saisons et grilles , est partage dans une micro-librairie :
from lmdz_SE import * # variables_list, all_SE_simulations, svsg, seasons
#---------------------------------------------------------------------------------
#
if options.simulations is None : options.simulations=all_SE_simulations()
else : options.simulations=options.simulations.split(",")
#
for season in options.seasons.split(",") :
    if season not in seasons : 
        print "La saison %s n'est pas connue"%season
        continue
    for simulation in options.simulations :
        out_dir=options.output+"/"+options.grid+"/"+season+"/"+simulation+"/"
        #
        for var in variables_list :
            result=svsg(simulation,var,season,options.grid)
            try :
                cfile(result,out_dir+var+".nc",deep=options.force,ln=True)
                #cfile(result,out_dir+var+".nc",deep=None,ln=True)
            except :
                print "Pb avec la simulation %s , la saison %s et la variable %s"%(simu,season,var)
            
