# -*- coding: iso-8859-1 -*-
# Created : S.Snsi - nov 2015


desc="\nReformatage des donnees SE en fichiers mono-variable ('cmorises')\n"+\
"  Exemples : \n"+\
"  >>> python ./pseudo_cmor.py -v hfls -s NPv3.1ada_1982_1991\n"+\
"  >>> python ./pseudo_cmor.py  (! couteux : traite tout !)\n"

# Avec CliMAF, cette etape est loin d'etre necessaire; on la ralise pour 'exposer' ces fichiers
# dans une arborescence  laquelle sont habitues certains utilisateurs


# Gestion des options et arguments d'appel
from optparse import OptionParser
parser = OptionParser(desc) ; parser.set_usage("%%prog [-h]\n%s" % desc)
parser.add_option("-f", "--force", help="force le recalcul de champs existants", action="store_true",default=None)
parser.add_option("-i", "--input", help="repertoire des donnees SE (optionnel)", action="store",default=None)
parser.add_option("-o", "--output", help="repertoire de sortie", action="store",default='./test/')
parser.add_option("-v", "--variables", help="liste des variables (separees par des virgules)(deafut : toutes celles definies dans lmdz_SE)", action="store",default=None)
#simu='NPv3.1ada_1982_1991' ; 
parser.add_option("-s", "--simulations", help="simulations a traiter (defaut : toutes)", action="store",default=None)
(options, args) = parser.parse_args()

#---------------------------------------------------------------------------------
verbose=True
from climaf.api import *
# La description de l'organisation des donnes SE et des alias et rescalings 
# est partage dans une micro-librairie :
from lmdz_SE import * # dont : variables_list
#---------------------------------------------------------------------------------

if (options.input) :  cdef('root',options.input,project='SE')
#
lvars=options.variables
if lvars is not None : lvars=lvars.split(',')
else : lvars=variables_list

def create_mono_var_files(simu,lvars,rootout,force=None) :
    """ Use CliMAF basics to create a mono-variable file in dir rootout/simulation/ 
    for each var in 'lvars', using SE data for simulation 'simu' 

    The file will also be known to CliMAF cache, through a symbolic link
    """
    #
    # Il faut identifier les annees dans le nom de la simu
    yeardeb=simu.split('_')[1]
    yearfin=simu.split('_')[2]
    years=yeardeb+"_"+yearfin
    simu=simu.split('_')[0]
    #
    dirout=rootout+'/'+simu+'_'+years+'/'
    print "vars : ",
    for var in lvars :
        print " %s, "%(var),
        data=ds(project='SE',variable=var,years=years, simulation=simu)
        try : 
            cfile(data,dirout+var+'.nc',ln=True, deep=force)
        except : print " Pb ",

if options.simulations is None : options.simulations=all_SE_simulations()
else : options.simulations=options.simulations.split(",")

for simulation in options.simulations :
    print "simu=%s"%(simulation),
    create_mono_var_files(simulation,lvars,rootout=options.output,force=options.force)

