#!/bin/bash


#########################################################
# Transformation des contours de (xmin,xmax,dx) en x0 x1 ...
#########################################################
cat <<eod>| contours.sh
#!/bin/bash

sed -e 's/(Inf)//' -e 's/(-Inf)//' -e 's/^.*.=.(//' -e 's/(//g' -e s:\'.*.\$:: -e 's/)/ /g' -e s/[\"\']//g tt  > ttt


n=\`wc -w ttt | awk ' { print \$1 } '\`
i=0
cont=""
while [ \$i -lt \$n ] ; do
   (( i = \$i + 1 ))
   sub=\`cut -d" " -f\$i ttt\`
   if [ "\`echo \$sub | grep , \`" = "" ] ; then
      cont="\$cont \$sub"
   else
      ci=\`echo \$sub | cut -d, -f1\`
      cf=\`echo \$sub | cut -d, -f2\`
      dc=\`echo \$sub | cut -d, -f3\`
      c=\$ci
      cont="\$cont \$c"
      diff="-"
      while [ "\$diff" = "-" ] ; do
         c=\`echo \$c \$dc | awk ' { print \$1 + \$2 } '\`
         cont="\$cont \$c"
         diff=\`echo \$c \$cf | awk ' { print \$1 - \$2 } ' | cut -c1\`
      done
   fi
done
echo \$cont
eod
chmod +x contours.sh

#########################################################
# Entete du fichier plot_params.py.ferret
#########################################################
cat <<eod>| plot_params.py.ferret
# -*- coding: iso-8859-1 -*-
# Created : S.Sénési - nov 2015

"""
Une fonction qui rend des paramètres régissant l'apparence de
graphiques, en fonction de la variable géophysique et du contexte

Encore au stade de brouilllon ; peu de variables traitées

"""

def plot_params(variable,context) :
    """
    Return plot parameters as a dict() , according to LMDZ habits , for a given
    variable and a context (among full_field, bias, model_model)

    """

    defaults = {
        'contours' : 1 ,
        'color'    :'temp_19lev',
    }

    per_variable = {
eod


######################################################################
# Boucle sur les variables
######################################################################

vars1="pr hurs rstt rlut rtt crelt crest crett hfns hfss hfls tas tasc tauu tauv pslhPa zg500"
vars2="rsah rsahcs rsahcre rlah rlahcs rlahcre rah rahcs rahcre cress rsts rsut rlutcs albs albt cress crels crets rts crelt"
vars3="cltcalipso clhcalipso clmcalipso cllcalipso"

file_ferret=/data/hourdin/LMDZ6/cartes.sh

for vvv in $vars1 $vars2 $vars3 ; do

case $vvv in
   "pslhPa") var=psl ;;
   *) var=$vvv
esac


lev=`grep ${vvv}"[)\|]" $file_ferret | grep 'lev=' | awk ' { print $2 } ' `
#| sed -e 's/lev=.//' -e 's/(Inf)//' -e 's/(-Inf)//' -e s:[\)\(\']:\ :g` 

levd=`grep ${vvv}"[)\|]" $file_ferret | grep 'lev=' | awk ' { print $4 } ' `
if [  `echo $levd | cut -d\" -f2 | cut -c1` = "\$" ] ; then
   vard=`echo $levd | cut -d\" -f2 | sed -e 's/^.//'`
   levd=`grep ${vard}"\=" $file_ferret`
fi

echo $lev >| tt
lev=`./contours.sh`

echo $levd >| tt
levd=`./contours.sh`

echo VAR $var
echo $lev
echo $levd

cat <<eod>> plot_params.py.ferret
       '$var' : {
eod
grep ' '$var' ' default.txt | sed -e 's/ '$var' //' >>  plot_params.py.ferret
offset=`grep ' '$var' ' offset.txt | awk ' { print $2 } '`
echo $offset
if [ "$offset" != "" ] ; then offset=" , 'offset' : $offset" ; fi
cat <<eod>> plot_params.py.ferret
            'full_field'   : {'colors':'$lev' $offset },
            'bias'        : {'colors': '$levd' , 'color':'BlueDarkRed18' },
            'model_model' : {'colors': '$levd'},
        },
eod


done


########################################################################
# Fin du fichier
########################################################################
cat <<eod>> plot_params.py.ferret
    }
    #
    rep=defaults.copy()
    if variable in per_variable :
        var_entry=per_variable[variable]
        for cont in [ 'default', context ] :
            if cont in var_entry : rep.update(var_entry[cont])
    return rep

eod
