#!/bin/bash

RUN=$1
SEASON=$2
PROJ=$3 
OUTDIR=$4 
REF=$5 
VARS=$6

set -vx

date
###########################################################################
# Environnement
module list
which python
ulimit -s unlimited
ATLAS_DIR=/prodigfs/ipslfs/dods/fabric/lmdz/atlas/Atlas$$ ; mkdir -p $ATLAS_DIR
export PYTHONPATH=$PYTHONPATH:/home/fabric/users/denvil/climaf
export PATH=$PATH:/home/fabric/users/denvil/climaf/bin
STORAGE=/prodigfs/ipslfs/dods/fabric/lmdz/STORE
###########################################################################
vars=""
vars="sst"

if [ $# = 1 ] ; then
   opts="`echo $1 | sed -e 's/,/ /g'`"
   for opt in $opts ; do
       echo $opt
       key=`echo $opt | cut -d= -f1`
       val=`echo $opt | cut -d= -f2`
       echo $key $val
       if [ "$key" = "RUN" ] ; then sim=$val ; fi
       if [ "$key" = "REF" ] ; then ref=$val ; fi
       if [ "$key" = "SEASON" ] ; then seas=$val ; fi
       if [ "$key" = "PROJ" ] ; then proj=$val ; fi
       if [ "$key" = "OUTDIR" ] ; then OUT_D=$val ; fi
       if [ "$key" = "VARS" ] ; then vars="`echo $val | sed -e 's/+/,/g'`" ; fi
   done
elif [ $# = 0 ] ; then
   sim=$RUN
   ref=$REF
   seas=$SEASON
   proj=$PROJ
   OUT_D=$OUTDIR
   vars=`echo $VARS | sed -e 's/+/,/g'`
else
  echo USE
  echo Job mode :
  echo qsub -v RUN=NPv5.3_1982_1989,SEASON=YEAR,PROJ=GLOB,OUTDIR=/prodigfs/ipslfs/dods/fabric/lmdz/MultiSimu/V5/ATLAS,VARS=pr+tas atlas.sh
  echo interactif :
  echo ./atlas.sh RUN=NPv5.3_1982_1989,SEASON=YEAR,PROJ=GLOB,OUTDIR=/prodigfs/ipslfs/dods/fabric/lmdz/MultiSimu/V5/ATLAS,VARS=pr+tas
  exit
fi

if [ "$vars" = "" ] ; then
   vars=pr,tas,hurs,hfls,hfss,albt,albtcs,albs,rldscs,rlds,rlus,rsdscs,rsds,rsuscs,rsus,rsutcs,rsut,rlut,rlutcs,psl,prw
fi


run=`echo $sim | sed -e 's/_[0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9]//'`
years=`echo $sim | sed -e 's/'$run'//' | sed -e 's/_//'`
sim=${run}_$years
echo $run $years $sim $ref
echo ENTREES : $run, $years, $seas, $vars, $ref
#exit

keys_strg=$sim$seas$proj$vars$ref

if [ -f $keys_strg.ENCOURS ] ; then 
   exit # Si le même atlas est deja en cours de realisation on sort
else
   touch $OUT_D/$keys_strg.ENCOURS
fi

if [ "$OUT_D" = "" ] ; then
   $OUT_D=$STORAGE/NPV5LRL79/$run/ATLAS/SE_$years/ATM
fi
mkdir -p $OUT_D

cd $ATLAS_DIR
echo sim $sim seas $seas > atlas.sh.log

###########################################################################
# Boucle pour construire l'atlas en plusieurs passages
echo IL FAUT FAIRE L ATLAS EN PLUSIEURS PASSAGE SINON CA PLANTE ...
###########################################################################

case "$proj" in
   "SH"|"NH") pyatlas="atlas_SH.py --projection $proj" ;;
   "GLOB") Var3D=,ua,va,ta,hus ; pyatlas=atlas.py ;;
esac


npass=5
ipass=1

while [ $ipass -le $npass ] ; do

   echo Nettoyage des fichiers corrompus du cache
   ~/LMDZ/atlas/clean_cache.sh
   echo passage $ipass >> atlas.sh.log
   html=index_example_"$seas"_"$sim".html
   htmlopt=index_${proj}_"$seas"_"$sim".html
   rm -f $html

   python /home/fabric/LMDZ/atlas/$pyatlas --force -v $vars -s $sim -t $ref -p $seas

   if [ ! -f "$html"  -o "`wc -l $html | awk ' { print $1 } '`" = "0" ] ; then
      echo ECHEC ATLAS : $html inexistant ou vide | tee >>  atlas.sh.log
      echo ECHEC ATLAS : $html inexistant ou vide
   else
      echo cp -f $html tmp$$.$passage
      cp -f $html tmp$$.$passage
      pwd
      echo tmp$$.$passage
      echo LS  LS
      ls -lrt | tail
      sed -e "s:/prodigfs/ipslfs/dods/:/thredds/fileServer/IPSLFS/:g" tmp$$.$passage >| $htmlopt
      \cp -f $htmlopt $OUT_D/
      PathHtml=`echo $OUT_D/$htmlopt | sed -e 's:/prodigfs/ipslfs/dods/:http\://vesg.ipsl.upmc.fr/thredds/fileServer/IPSLFS/:'`
      echo NOUVEL ATLAS DISPONIBLE SUR $PathHtml | tee >>  atlas.sh.log
      echo NOUVEL ATLAS DISPONIBLE SUR $PathHtml
      echo $keys_strg >> $OUT_D/atlas_OK
      echo ${sim}+${seas}+${proj}+$vars >> $OUT_D/atlas_OK
   fi
   (( ipass = $ipass + 1 ))

done

#\rm -f $OUT_D/$keys_strg.ENCOURS
