
! $Id: transp.F90 3250 2018-03-12 13:42:42Z fairhead $

SUBROUTINE transp(paprs, tsol, t, q, ql, qs, u, v, geom, vtran_e, vtran_q, utran_e, &
    utran_q, vtran_w, utran_w)

  USE dimphy
  IMPLICIT NONE
  ! ======================================================================
  ! Auteur(s): Z.X.Li (LMD/CNRS)
  ! Date: le 25 avril 1994
  ! Objet: Calculer le transport de l'energie et de la vapeur d'eau
  ! ======================================================================

  include "YOMCST.h"

  REAL paprs(klon, klev+1), tsol(klon)
  REAL t(klon, klev), q(klon, klev), ql(klon, klev), qs(klon, klev)
  REAL u(klon, klev), v(klon, klev)
  REAL utran_e(klon), utran_q(klon), vtran_e(klon), vtran_q(klon)
  REAL utran_w(klon), vtran_w(klon)

  INTEGER i, l
  ! ------------------------------------------------------------------
  REAL geom(klon, klev), e
  ! ------------------------------------------------------------------
  DO i = 1, klon
    utran_e(i) = 0.0
    utran_q(i) = 0.0
    vtran_e(i) = 0.0
    vtran_q(i) = 0.0
    utran_w(i) = 0.0
    vtran_w(i) = 0.0
  END DO

  DO l = 1, klev
    DO i = 1, klon
!      e = rcpd*t(i, l) + rlvtt*q(i, l) + geom(i, l)
      e = rcpd*t(i, l) + geom(i, l)
      utran_e(i) = utran_e(i) + u(i, l)*e*(paprs(i,l)-paprs(i,l+1))/rg
      utran_q(i) = utran_q(i) + u(i, l)*q(i, l)*(paprs(i,l)-paprs(i,l+1))/rg
      utran_w(i) = utran_w(i) + u(i, l)*(q(i, l)+ql(i, l)+qs(i, l))           &
                                       *(paprs(i,l)-paprs(i,l+1))/rg
      vtran_e(i) = vtran_e(i) + v(i, l)*e*(paprs(i,l)-paprs(i,l+1))/rg
      vtran_q(i) = vtran_q(i) + v(i, l)*q(i, l)*(paprs(i,l)-paprs(i,l+1))/rg
      vtran_w(i) = vtran_w(i) + v(i, l)*(q(i, l)+ql(i, l)+qs(i, l))           &
                                       *(paprs(i,l)-paprs(i,l+1))/rg
    END DO
  END DO

  RETURN
END SUBROUTINE transp
