!
! $Id: climoz_mod.F90 3065 2017-11-10 13:25:09Z fairhead $
!
! This module may contains all subroutine and function used
! for ozone climatology
! code re-design is needed

MODULE climoz_mod





CONTAINS


  SUBROUTINE create_climoz(read_climoz)
  USE mod_grid_phy_lmdz, ONLY :  grid_type, unstructured
  USE regr_lat_time_climoz_m
  USE mod_phys_lmdz_para
#ifdef CPP_XIOS
  USE XIOS
#endif
  IMPLICIT NONE
  INTEGER, INTENT(IN)  :: read_climoz

    !--- OZONE CLIMATOLOGY
    IF (grid_type==unstructured) THEN
#ifdef CPP_XIOS    
      IF(read_climoz>=1) THEN 
        IF (is_master) CALL regr_lat_time_climoz(read_climoz,.FALSE.)
        IF (is_omp_master) THEN
          CALL xios_set_field_attr( "tro3_reg",  enabled=.TRUE.)
          CALL xios_set_field_attr( "tro3_read", enabled=.TRUE.)
          IF (read_climoz==2) THEN
            CALL xios_set_field_attr( "tro3_daylight_reg",  enabled=.TRUE.)
            CALL xios_set_field_attr( "tro3_daylight_read", enabled=.TRUE.)
          ENDIF
        ENDIF
      ENDIF
#endif    
    ENDIF

  END SUBROUTINE create_climoz


  
  SUBROUTINE get_ozone_var(name,press_in_edg,paprs,v3)
  USE dimphy
  USE mod_phys_lmdz_para
#ifdef CPP_XIOS
  USE xios
#endif
  USE regr1_step_av_m, only: regr1_step_av
  IMPLICIT NONE
    CHARACTER(LEN=*), INTENT(in):: name(:) ! of the NetCDF variables      
    REAL, INTENT(IN):: press_in_edg(:)    ! edges of pressure intervals for input data, in Pa, in strictly ascending order
    REAL, INTENT(IN):: paprs(:, :) ! (klon, klev + 1)
    REAL, INTENT(OUT):: v3(:, :, :) ! (klon, klev, size(name))
    
    REAL  :: v1_mpi(klon_mpi, size(press_in_edg) - 1, size(v3,3))
    REAL  :: v1(klon, size(press_in_edg) - 1, size(v3,3))
    INTEGER :: m,i

#ifdef CPP_XIOS    
    DO m=1,size(name)
      IF (is_omp_master) CALL xios_recv_field(name(m),v1_mpi(:,:,m))
      CALL scatter_omp(v1_mpi,v1)
      ! Regrid in pressure at each horizontal position:
      DO i = 1, klon
         v3(i, klev:1:-1, m) = regr1_step_av(v1(i,:,m), press_in_edg, &
              paprs(i, klev+1:1:-1))
         ! (invert order of indices because "paprs" is in descending order)
      END DO
    ENDDO
#endif
  END SUBROUTINE get_ozone_var  
  

END MODULE climoz_mod
