      subroutine writehist( histid, histvid, nq, time, vcov, 
     ,                          ucov,teta,phi,q,masse,ps,phis)

      USE ioipsl
      implicit none

C
C   Ecriture du fichier histoire au format IOIPSL
C
C   Appels succesifs des routines: histwrite
C
C   Entree:
C      histid: ID du fichier histoire
C      histvid:ID du fichier histoire pour les vents V (appele a disparaitre)
C      nqmx: nombre maxi de traceurs
C      time: temps de l'ecriture
C      vcov: vents v covariants
C      ucov: vents u covariants
C      teta: temperature potentielle
C      phi : geopotentiel instantane
C      q   : traceurs
C      masse: masse
C      ps   :pression au sol
C      phis : geopotentiel au sol
C      
C
C   Sortie:
C      fileid: ID du fichier netcdf cree
C
C   L. Fairhead, LMD, 03/99
C
C =====================================================================
C
C   Declarations
#include "dimensions.h"
#include "paramet.h"
#include "comconst.h"
#include "comvert.h"
#include "comgeom.h"
#include "temps.h"
#include "ener.h"
#include "logic.h"
#include "description.h"
#include "serre.h"

C
C   Arguments
C

      INTEGER histid, nq, histvid
      REAL vcov(ip1jm,llm),ucov(ip1jmp1,llm) 
      REAL teta(ip1jmp1,llm),phi(ip1jmp1,llm)                   
      REAL ps(ip1jmp1),masse(ip1jmp1,llm)                   
      REAL phis(ip1jmp1)                  
      REAL q(ip1jmp1,llm,nq)
      integer time


C   Variables locales
C
      integer iq, ii, ll
      integer ndexu(ip1jmp1,llm),ndexv(ip1jm,llm),ndex2d(ip1jmp1)
      character*3 str
      logical ok_sync
C
C  Initialisations
C
      str='q  '
      ndexu = 0
      ndexv = 0
      ndex2d = 0
      ok_sync =.TRUE.
C
C  Appels a histwrite pour l'ecriture des variables a sauvegarder
C
C  Vents U
C
      call histwrite(histid, 'ucov', time, ucov, 
     .               iip1*jjp1*llm, ndexu)

C
C  Vents V
C
      call histwrite(histvid, 'vcov', time, vcov, 
     .               iip1*jjm*llm, ndexv)

C
C  Temperature potentielle
C
      call histwrite(histid, 'teta', time, teta, 
     .                iip1*jjp1*llm, ndexu)
C
C  Geopotentiel
C
      call histwrite(histid, 'phi', time, phi, 
     .                iip1*jjp1*llm, ndexu)
C
C  Traceurs
C
      IF(nq.GE.1) THEN
        DO iq=1,nq
          IF ( iq.LE.9 ) THEN
            WRITE(str(2:2),'(i1.1)') iq
          ELSE
            WRITE(str(2:3),'(i2.2)') iq
          ENDIF
          call histwrite(histid, str, time, q(:,:,iq), 
     .                   iip1*jjp1*llm, ndexu)
        enddo
      endif
C
C  Masse
C
      call histwrite(histid, 'masse', time, masse, iip1*jjp1, ndex2d)
C
C  Pression au sol
C
      call histwrite(histid, 'ps', time, ps, iip1*jjp1, ndex2d)
C
C  Geopotentiel au sol
C
      call histwrite(histid, 'phis', time, phis, iip1*jjp1, ndex2d)
C
C  Fin
C
      if (ok_sync) then
        call histsync(histid)
        call histsync(histvid)
      endif
      return
      end
