!----------------------------------------------------------------------------
SUBROUTINE RRTM_TAUMOL2 (KLEV,P_TAU,P_COLDRY,&
 & P_TAUAERL,P_FAC00,P_FAC01,P_FAC10,P_FAC11,P_FORFAC,K_JP,K_JT,K_JT1,&
 & P_COLH2O,K_LAYTROP,P_SELFFAC,P_SELFFRAC,K_INDSELF,PFRAC)  

!     BAND 2:  250-500 cm-1 (low - H2O; high - H2O)

! Modifications
!        M.Hamrud      01-Oct-2003 CY28 Cleaning

!     D Salmond   2000-05-15 speed-up
!     JJMorcrette 2000-05-17 speed-up
!     JJMorcrette 2000-07-14 bugfix
!     Y. Seity    2006-09-26 Nec optimisation

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE PARRRTM  , ONLY : JPLAY  ,JPBAND ,JPGPT  ,NG2   ,NGS1
USE YOERRTWN , ONLY :      NSPA   ,NSPB
USE YOERRTA2 , ONLY : ABSA   ,ABSB   ,FRACREFA, FRACREFB,&
 & FORREF   ,SELFREF , REFPARAM  
USE YOERRTBG2, ONLY : CORR1  ,CORR2

!  Input
!#include "yoeratm.h"

IMPLICIT NONE

INTEGER(KIND=JPIM),INTENT(IN)    :: KLEV 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: P_TAU(JPGPT,JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLDRY(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_TAUAERL(JPLAY,JPBAND) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC00(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC01(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC10(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC11(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FORFAC(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JP(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT1(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLH2O(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_LAYTROP 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFAC(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFRAC(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_INDSELF(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRAC(JPGPT,JPLAY) 
!  Output
!- from AER
!- from INTFAC      
!- from INTIND
!- from PROFDATA             
!- from SELF             
!- from SP             
REAL(KIND=JPRB) :: Z_FC00(JPLAY),Z_FC01(JPLAY),Z_FC10(JPLAY),Z_FC11(JPLAY)
!      REAL TAUAER(JPLAY)
REAL(KIND=JPRB) :: Z_FRACINT(JPLAY)
INTEGER(KIND=JPIM) :: IND0(JPLAY),IND1(JPLAY),INDS(JPLAY), INDEX(JPLAY)

INTEGER(KIND=JPIM) :: IFP, IFRAC, IG, JFRAC, I_LAY

REAL(KIND=JPRB) :: Z_FP, Z_H2OPARAM, Z_WATER
REAL(KIND=JPRB) :: ZHOOK_HANDLE

!      EQUIVALENCE (TAUAERL(1,2),TAUAER)

!     Compute the optical depth by interpolating in ln(pressure) and 
!     temperature.  Below LAYTROP, the water vapor self-continuum is 
!     interpolated (in temperature) separately.

IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL2',0,ZHOOK_HANDLE)
DO I_LAY = 1, K_LAYTROP
  Z_WATER = 1.E20_JPRB * P_COLH2O(I_LAY) / P_COLDRY(I_LAY)
  Z_H2OPARAM = Z_WATER/(Z_WATER +.002_JPRB)
  
!  DO IFRAC = 2, 12
!    IF (H2OPARAM  >=  REFPARAM(IFRAC)) GO TO 1900
!  ENDDO
!  1900 CONTINUE
!  FRACINT(LAY) = (H2OPARAM-REFPARAM(IFRAC))/&
!   &(REFPARAM(IFRAC-1)-REFPARAM(IFRAC))
  IFRAC=INDEX(I_LAY)
  IF (Z_H2OPARAM >= REFPARAM(2)) THEN
          IFRAC=2
  ELSE
!cdir unroll=11
    DO JFRAC = 2, 12
      IF (Z_H2OPARAM < REFPARAM(JFRAC)) THEN
         IFRAC=JFRAC+1
      ENDIF  
    ENDDO
  ENDIF  
  
!---- JJM_000714
! set above IFRAC instead of INDEX(I_LAY), store now - NEC jh
! IFRAC=INDEX(I_LAY)
  INDEX(I_LAY)=IFRAC

  Z_FRACINT(I_LAY) = (Z_H2OPARAM-REFPARAM(IFRAC))/&
   & (REFPARAM(IFRAC-1)-REFPARAM(IFRAC))  
ENDDO

DO I_LAY = 1, K_LAYTROP

  Z_FP = P_FAC11(I_LAY) + P_FAC01(I_LAY)
  IFP = 2.E2_JPRB*Z_FP+0.5_JPRB

!---MI 981104        
!       IF (IFP.LE.0) IFP=0

  IFP=MAX(0,IFP)

! FH 2017/05/02
! Modification parce qu'on avait un plantage sur un cas 1D.
! C'est evidemment une correction suspecte
  IF (IFP>201) STOP'Ce plantage dans rrtm_taumol2 est il normal ...'
  IF (IFP==201) IFP=200

  Z_FC00(I_LAY) = P_FAC00(I_LAY) * CORR2(IFP)
  Z_FC10(I_LAY) = P_FAC10(I_LAY) * CORR2(IFP)
  Z_FC01(I_LAY) = P_FAC01(I_LAY) * CORR1(IFP)
  Z_FC11(I_LAY) = P_FAC11(I_LAY) * CORR1(IFP)
  IND0(I_LAY) = ((K_JP(I_LAY)-1)*5+(K_JT(I_LAY)-1))*NSPA(2) + 1
  IND1(I_LAY) = (K_JP(I_LAY)*5+(K_JT1(I_LAY)-1))*NSPA(2) + 1
  INDS(I_LAY) = K_INDSELF(I_LAY)
ENDDO

!-- DS_000515  
DO IG = 1, NG2
  DO I_LAY = 1, K_LAYTROP
!-- JJM_000714
    IFRAC=INDEX(I_LAY)  
!-- DS_000515  
    P_TAU (NGS1+IG,I_LAY) = P_COLH2O(I_LAY) *&
     & (Z_FC00(I_LAY) * ABSA(IND0(I_LAY)  ,IG) +&
     & Z_FC10(I_LAY) * ABSA(IND0(I_LAY)+1,IG) +&
     & Z_FC01(I_LAY) * ABSA(IND1(I_LAY)  ,IG) +&
     & Z_FC11(I_LAY) * ABSA(IND1(I_LAY)+1,IG) +&
     & P_SELFFAC(I_LAY) * (SELFREF(INDS(I_LAY),IG) + &
     & P_SELFFRAC(I_LAY) *&
     & (SELFREF(INDS(I_LAY)+1,IG) - SELFREF(INDS(I_LAY),IG)))&
     & + P_FORFAC(I_LAY) * FORREF(IG) ) &
     & + P_TAUAERL(I_LAY,2)  
    PFRAC(NGS1+IG,I_LAY) = FRACREFA(IG,IFRAC) + Z_FRACINT(I_LAY) *&
     & (FRACREFA(IG,IFRAC-1)-FRACREFA(IG,IFRAC))  
  ENDDO
ENDDO

DO I_LAY = K_LAYTROP+1, KLEV
  Z_FP = P_FAC11(I_LAY) + P_FAC01(I_LAY)
  IFP = 2.E2_JPRB*Z_FP+0.5_JPRB

!---MI 981104        
  IF (IFP <= 0) IFP=0

  Z_FC00(I_LAY) = P_FAC00(I_LAY) * CORR2(IFP)
  Z_FC10(I_LAY) = P_FAC10(I_LAY) * CORR2(IFP)
  Z_FC01(I_LAY) = P_FAC01(I_LAY) * CORR1(IFP)
  Z_FC11(I_LAY) = P_FAC11(I_LAY) * CORR1(IFP)
  IND0(I_LAY) = ((K_JP(I_LAY)-13)*5+(K_JT(I_LAY)-1))*NSPB(2) + 1
  IND1(I_LAY) = ((K_JP(I_LAY)-12)*5+(K_JT1(I_LAY)-1))*NSPB(2) + 1
ENDDO

!-- JJM_000517
DO IG = 1, NG2
  DO I_LAY = K_LAYTROP+1, KLEV
!-- JJM_000517
    P_TAU (NGS1+IG,I_LAY) = P_COLH2O(I_LAY) *&
     & (Z_FC00(I_LAY) * ABSB(IND0(I_LAY)  ,IG) +&
     & Z_FC10(I_LAY) * ABSB(IND0(I_LAY)+1,IG) +&
     & Z_FC01(I_LAY) * ABSB(IND1(I_LAY)  ,IG) +&
     & Z_FC11(I_LAY) * ABSB(IND1(I_LAY)+1,IG)&
     & + P_FORFAC(I_LAY) * FORREF(IG) ) &
     & + P_TAUAERL(I_LAY,2)  
    PFRAC(NGS1+IG,I_LAY) = FRACREFB(IG)
  ENDDO
ENDDO

IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL2',1,ZHOOK_HANDLE)
END SUBROUTINE RRTM_TAUMOL2
