SUBROUTINE ocs_to_so2(pdtphys,tr_seri,t_seri,pplay,paprs,sh,is_strato)

  USE dimphy, ONLY : klon,klev
  USE aerophys
  USE infotrac
  USE YOMCST, ONLY : RG
  USE phys_local_var_mod, ONLY : OCS_lifetime, ocs_convert

  IMPLICIT NONE

  !--------------------------------------------------------
  ! transfer variables when calling this routine
  REAL,INTENT(IN)                               :: pdtphys ! Pas d'integration pour la physique (seconde)
  REAL,DIMENSION(klon,klev,nbtr),INTENT(INOUT)  :: tr_seri ! Concentration Traceur [U/KgA]
  REAL,DIMENSION(klon,klev),INTENT(IN)          :: t_seri  ! Temperature
  REAL,DIMENSION(klon,klev),INTENT(IN)          :: pplay   ! pression pour le mileu de chaque couche (en Pa)
  REAL,DIMENSION(klon,klev+1),INTENT(IN)        :: paprs   ! pression pour chaque inter-couche (en Pa)
  REAL,DIMENSION(klon,klev),INTENT(IN)          :: sh      ! humidite specifique   
  LOGICAL,DIMENSION(klon,klev),INTENT(IN)       :: is_strato

  ! local variables
  INTEGER                                       :: i,j,k,nb,ilon,ilev

!--convert OCS to SO2
  ocs_convert(:,:)=0.0
  DO ilon=1, klon
  DO ilev=1, klev
  !only in the stratosphere
  IF (is_strato(ilon,ilev)) THEN
    IF (OCS_lifetime(ilon,ilev).GT.0.0) THEN
      ocs_convert(ilon,ilev)=tr_seri(ilon,ilev,id_OCS_strat)*(1.0-exp(-pdtphys/OCS_lifetime(ilon,ilev)))
    ENDIF
    tr_seri(ilon,ilev,id_OCS_strat)=tr_seri(ilon,ilev,id_OCS_strat) - ocs_convert(ilon,ilev)
    tr_seri(ilon,ilev,id_SO2_strat)=tr_seri(ilon,ilev,id_SO2_strat) + mSO2mol/mOCSmol*ocs_convert(ilon,ilev)
    !convert ocs_convert from kg(OCS)/kgA to kg(S)/m2/layer/s for saving as diagnostic
    ocs_convert(ilon,ilev)=ocs_convert(ilon,ilev)*mSatom/mOCSmol*(paprs(ilon,ilev)-paprs(ilon,ilev+1))/RG/pdtphys
  ENDIF
  ENDDO
  ENDDO

END SUBROUTINE ocs_to_so2
