SUBROUTINE SO2_TO_H2SO4(pdtphys,tr_seri,t_seri,pplay,paprs,sh,SO2_lifetime,is_strato,sulf_convert_sub)

  USE dimphy, ONLY : klon,klev
  USE aerophys
  USE infotrac
  USE YOMCST, ONLY : RG

  IMPLICIT NONE

  !--------------------------------------------------------

  ! transfer variables when calling this routine
  REAL,INTENT(IN)                               :: pdtphys ! Pas d'integration pour la physique (seconde)
  REAL,DIMENSION(klon,klev,nbtr),INTENT(INOUT)  :: tr_seri ! Concentration Traceur [U/KgA]
  REAL,DIMENSION(klon,klev),INTENT(IN)          :: t_seri  ! Temperature
  REAL,DIMENSION(klon,klev),INTENT(IN)          :: pplay   ! pression pour le mileu de chaque couche (en Pa)
  REAL,DIMENSION(klon,klev+1),INTENT(IN)        :: paprs   ! pression pour chaque inter-couche (en Pa)
  REAL,DIMENSION(klon,klev),INTENT(IN)          :: sh      ! humidite specifique   
  REAL,DIMENSION(klon,klev),INTENT(IN)          :: SO2_lifetime
  LOGICAL,DIMENSION(klon,klev),INTENT(IN)  :: is_strato

  ! local variables in coagulation routine
  INTEGER                                       :: i,j,k,nb,ilon,ilev
  REAL,DIMENSION(klon,klev)                     :: sulf_convert_sub ! SO2 converted to H2SO4 [kg(S)/m2/layer/s]

!--convert SO2 to H2SO4
  DO ilon=1, klon
  DO ilev=1, klev
  !only in the stratosphere
  IF (is_strato(ilon,ilev)) THEN
    IF (SO2_lifetime(ilon,ilev).GT.0.0) THEN
      sulf_convert_sub(ilon,ilev)=tr_seri(ilon,ilev,id_SO2_strat)*(1-exp(-pdtphys/SO2_lifetime(ilon,ilev)))
    ELSE
      sulf_convert_sub(ilon,ilev)=0.0
    ENDIF
    tr_seri(ilon,ilev,id_SO2_strat)=tr_seri(ilon,ilev,id_SO2_strat) - sulf_convert_sub(ilon,ilev)
    tr_seri(ilon,ilev,id_H2SO4_strat)=tr_seri(ilon,ilev,id_H2SO4_strat) + mH2SO4mol/mSO2mol*sulf_convert_sub(ilon,ilev)
    !convert sulf_convert from kg(SO2)/kgA to kg(S)/m2/layer/s for saving as diagnostic
    sulf_convert_sub(ilon,ilev)=sulf_convert_sub(ilon,ilev)*mSatom/mSO2mol*(paprs(ilon,ilev)-paprs(ilon,ilev+1))/RG/pdtphys
  ENDIF
  ENDDO
  ENDDO

END SUBROUTINE SO2_TO_H2SO4
