      FUNCTION q_sat(kelvin, millibar)
c
      IMPLICIT none
c======================================================================
c Autheur(s): Z.X. Li (LMD/CNRS)
c Objet: calculer la vapeur d'eau saturante (formule Centre Euro.)
c======================================================================
c Arguments:
c kelvin---input-R: temperature en Kelvin
c millibar--input-R: pression en mb
c
c q_sat----output-R: vapeur d'eau saturante en kg/kg
c======================================================================
c
      REAL q_sat, kelvin, millibar
c
      REAL r2es
      PARAMETER (r2es=611.14 *18.0153/28.9644)
c
      REAL r3les, r3ies, r3es
      PARAMETER (R3LES=17.269)
      PARAMETER (R3IES=21.875)
c
      REAL r4les, r4ies, r4es
      PARAMETER (R4LES=35.86)
      PARAMETER (R4IES=7.66)
c
      REAL rtt
      PARAMETER (rtt=273.16)
c
      REAL retv
      PARAMETER (retv=28.9644/18.0153 - 1.0)
c
      REAL zqsat
      REAL temp, pres
C     ------------------------------------------------------------------
c
c
      temp = kelvin
      pres = millibar * 100.0
c      write(*,*)'kelvin,millibar=',kelvin,millibar
c      write(*,*)'temp,pres=',temp,pres
c
      IF (temp .LE. rtt) THEN
         r3es = r3ies
         r4es = r4ies
      ELSE
         r3es = r3les
         r4es = r4les
      ENDIF
c
      zqsat=r2es/pres * EXP ( r3es*(temp-rtt) / (temp-r4es) )
      zqsat=MIN(0.5,ZQSAT)
      zqsat=zqsat/(1.-retv  *zqsat)
c
      q_sat = zqsat
c
      RETURN
      END
