!
! $Id: phys_local_var_mod.F90 2499 2016-04-24 10:38:19Z oboucher $
!
      MODULE phys_local_var_mod
! Variables locales pour effectuer les appels en serie
!======================================================================
!
!
!======================================================================
! Declaration des variables

      REAL, SAVE, ALLOCATABLE :: t_seri(:,:), q_seri(:,:)
      !$OMP THREADPRIVATE(t_seri, q_seri)
      REAL, SAVE, ALLOCATABLE :: ql_seri(:,:),qs_seri(:,:)
      !$OMP THREADPRIVATE(ql_seri,qs_seri)
      REAL, SAVE, ALLOCATABLE :: u_seri(:,:), v_seri(:,:)
      !$OMP THREADPRIVATE(u_seri, v_seri)

      REAL, SAVE, ALLOCATABLE :: tr_seri(:,:,:)
      !$OMP THREADPRIVATE(tr_seri)
      REAL, SAVE, ALLOCATABLE :: d_t_dyn(:,:), d_q_dyn(:,:)
      !$OMP THREADPRIVATE(d_t_dyn, d_q_dyn)
      REAL, SAVE, ALLOCATABLE :: d_ql_dyn(:,:), d_qs_dyn(:,:)
      !$OMP THREADPRIVATE(d_ql_dyn, d_qs_dyn)
      REAL, SAVE, ALLOCATABLE :: d_q_dyn2d(:), d_ql_dyn2d(:), d_qs_dyn2d(:)
      !$OMP THREADPRIVATE(d_q_dyn2d, d_ql_dyn2d, d_qs_dyn2d)
      REAL, SAVE, ALLOCATABLE :: d_u_dyn(:,:), d_v_dyn(:,:)
      !$OMP THREADPRIVATE(d_u_dyn, d_v_dyn)
!!!!
      REAL, SAVE, ALLOCATABLE :: d_tr_dyn(:,:,:)
      !$OMP THREADPRIVATE(d_tr_dyn)
!!!!
      REAL, SAVE, ALLOCATABLE :: d_t_con(:,:),d_q_con(:,:)
      !$OMP THREADPRIVATE(d_t_con,d_q_con)
      REAL, SAVE, ALLOCATABLE :: d_u_con(:,:),d_v_con(:,:)
      !$OMP THREADPRIVATE(d_u_con,d_v_con)
      REAL, SAVE, ALLOCATABLE :: d_t_wake(:,:),d_q_wake(:,:)
      !$OMP THREADPRIVATE( d_t_wake,d_q_wake)
      REAL, SAVE, ALLOCATABLE :: d_t_lsc(:,:),d_q_lsc(:,:),d_ql_lsc(:,:),d_qi_lsc(:,:)
      !$OMP THREADPRIVATE(d_t_lsc,d_q_lsc,d_ql_lsc,d_qi_lsc)
      REAL, SAVE, ALLOCATABLE :: d_t_lwr(:,:),d_t_lw0(:,:),d_t_swr(:,:),d_t_sw0(:,:)
      !$OMP THREADPRIVATE(d_t_lwr,d_t_lw0,d_t_swr,d_t_sw0)
      REAL, SAVE, ALLOCATABLE :: d_t_ajsb(:,:), d_q_ajsb(:,:)
      !$OMP THREADPRIVATE(d_t_ajsb, d_q_ajsb)
      REAL, SAVE, ALLOCATABLE :: d_t_ajs(:,:), d_q_ajs(:,:)
      !$OMP THREADPRIVATE(d_t_ajs, d_q_ajs)
      REAL, SAVE, ALLOCATABLE :: d_u_ajs(:,:), d_v_ajs(:,:)
      !$OMP THREADPRIVATE(d_u_ajs, d_v_ajs)
!nrlmd<
      REAL, SAVE, ALLOCATABLE :: d_t_ajs_w(:,:), d_q_ajs_w(:,:)
      !$OMP THREADPRIVATE(d_t_ajs_w, d_q_ajs_w)
      REAL, SAVE, ALLOCATABLE :: d_t_ajs_x(:,:), d_q_ajs_x(:,:)
      !$OMP THREADPRIVATE(d_t_ajs_x, d_q_ajs_x)
!>nrlmd
      REAL, SAVE, ALLOCATABLE :: d_t_eva(:,:),d_q_eva(:,:)
      !$OMP THREADPRIVATE(d_t_eva,d_q_eva)
      REAL, SAVE, ALLOCATABLE :: d_t_lscst(:,:),d_q_lscst(:,:)
      !$OMP THREADPRIVATE(d_t_lscst,d_q_lscst)
      REAL, SAVE, ALLOCATABLE :: d_t_lscth(:,:),d_q_lscth(:,:)
      !$OMP THREADPRIVATE(d_t_lscth,d_q_lscth)
      REAL, SAVE, ALLOCATABLE :: plul_th(:),plul_st(:)
      !$OMP THREADPRIVATE(plul_th,plul_st)
!tendances dues a oro et lif
      REAL, SAVE, ALLOCATABLE :: d_t_oli(:,:)
      !$OMP THREADPRIVATE(d_t_oli)
      REAL, SAVE, ALLOCATABLE :: d_u_oli(:,:), d_v_oli(:,:)
      !$OMP THREADPRIVATE(d_u_oli, d_v_oli)
      REAL, SAVE, ALLOCATABLE :: d_t_vdf(:,:), d_q_vdf(:,:), d_t_diss(:,:)
      !$OMP THREADPRIVATE( d_t_vdf, d_q_vdf,d_t_diss)
      REAL, SAVE, ALLOCATABLE :: d_u_vdf(:,:), d_v_vdf(:,:)
      !$OMP THREADPRIVATE(d_u_vdf, d_v_vdf)
!nrlmd+jyg<
      REAL, SAVE, ALLOCATABLE :: d_t_vdf_w(:,:), d_q_vdf_w(:,:)
      !$OMP THREADPRIVATE( d_t_vdf_w, d_q_vdf_w)
      REAL, SAVE, ALLOCATABLE :: d_t_vdf_x(:,:), d_q_vdf_x(:,:)
      !$OMP THREADPRIVATE( d_t_vdf_x, d_q_vdf_x)
!>nrlmd+jyg
      REAL, SAVE, ALLOCATABLE :: d_t_oro(:,:)
      !$OMP THREADPRIVATE(d_t_oro)
      REAL, SAVE, ALLOCATABLE :: d_u_oro(:,:), d_v_oro(:,:)
      !$OMP THREADPRIVATE(d_u_oro, d_v_oro)
      REAL, SAVE, ALLOCATABLE :: d_t_lif(:,:)
      !$OMP THREADPRIVATE(d_t_lif)
      REAL, SAVE, ALLOCATABLE :: d_u_lif(:,:), d_v_lif(:,:)
      !$OMP THREADPRIVATE(d_u_lif, d_v_lif)
! Tendances Ondes de G non oro (runs strato).
      REAL, SAVE, ALLOCATABLE :: du_gwd_hines(:,:)
      !$OMP THREADPRIVATE(du_gwd_hines)
      REAL, SAVE, ALLOCATABLE :: dv_gwd_hines(:,:)
      !$OMP THREADPRIVATE(dv_gwd_hines)
      REAL, SAVE, ALLOCATABLE :: dv_gwd_rando(:,:)
      !$OMP THREADPRIVATE(dv_gwd_rando)
      REAL, SAVE, ALLOCATABLE :: dv_gwd_front(:,:)
      !$OMP THREADPRIVATE(dv_gwd_front)
      REAL, SAVE, ALLOCATABLE :: east_gwstress(:,:)
      !$OMP THREADPRIVATE(east_gwstress)
      REAL, SAVE, ALLOCATABLE :: west_gwstress(:,:)
      !$OMP THREADPRIVATE(west_gwstress)
      REAL, SAVE, ALLOCATABLE :: d_t_hin(:,:)
      !$OMP THREADPRIVATE(d_t_hin)
! tendance due a l'oxydation du methane
      REAL, SAVE, ALLOCATABLE :: d_q_ch4(:,:)
      !$OMP THREADPRIVATE(d_q_ch4)

! tendance du a la conersion Ec -> E thermique
      REAL, SAVE, ALLOCATABLE :: d_t_ec(:,:)
      !$OMP THREADPRIVATE(d_t_ec)
      REAL, SAVE, ALLOCATABLE :: d_ts(:,:), d_tr(:,:,:)
      !$OMP THREADPRIVATE(d_ts, d_tr)

! diagnostique pour le rayonnement
      REAL, SAVE, ALLOCATABLE :: topswad_aero(:),  solswad_aero(:)      ! diag
      !$OMP THREADPRIVATE(topswad_aero,solswad_aero)
      REAL, SAVE, ALLOCATABLE :: topswai_aero(:),  solswai_aero(:)      ! diag
      !$OMP THREADPRIVATE(topswai_aero,solswai_aero)
      REAL, SAVE, ALLOCATABLE :: topswad0_aero(:), solswad0_aero(:)     ! diag
      !$OMP THREADPRIVATE(topswad0_aero,solswad0_aero)
      REAL, SAVE, ALLOCATABLE :: topsw_aero(:,:),  solsw_aero(:,:)      ! diag
      !$OMP THREADPRIVATE(topsw_aero,solsw_aero)
      REAL, SAVE, ALLOCATABLE :: topsw0_aero(:,:), solsw0_aero(:,:)     ! diag
      !$OMP THREADPRIVATE(topsw0_aero,solsw0_aero)
      REAL, SAVE, ALLOCATABLE :: topswcf_aero(:,:),  solswcf_aero(:,:)  ! diag
      !$OMP THREADPRIVATE(topswcf_aero,solswcf_aero)
! LW radiation diagnostics CK
      REAL, SAVE, ALLOCATABLE :: toplwad_aero(:),  sollwad_aero(:)      ! diag
      !$OMP THREADPRIVATE(toplwad_aero,sollwad_aero)
      REAL, SAVE, ALLOCATABLE :: toplwai_aero(:),  sollwai_aero(:)      ! diag
      !$OMP THREADPRIVATE(toplwai_aero,sollwai_aero)
      REAL, SAVE, ALLOCATABLE :: toplwad0_aero(:), sollwad0_aero(:)     ! diag
      !$OMP THREADPRIVATE(toplwad0_aero,sollwad0_aero)
! Special RRTM
      REAL, SAVE, ALLOCATABLE :: ZLWFT0_i(:,:),  ZSWFT0_i(:,:)      ! diag
      !$OMP THREADPRIVATE(ZLWFT0_i,ZSWFT0_i)
      REAL, SAVE, ALLOCATABLE :: ZFLDN0(:,:),  ZFLUP0(:,:)      ! diag
      !$OMP THREADPRIVATE(ZFLDN0,ZFLUP0)
      REAL, SAVE, ALLOCATABLE :: ZFSDN0(:,:),  ZFSUP0(:,:)      ! diag
      !$OMP THREADPRIVATE(ZFSDN0,ZFSUP0)
!
      REAL, SAVE, ALLOCATABLE :: tausum_aero(:,:,:) 
      !$OMP THREADPRIVATE(tausum_aero) 
      REAL, SAVE, ALLOCATABLE :: tau3d_aero(:,:,:,:) 
      !$OMP THREADPRIVATE(tau3d_aero) 
      REAL, SAVE, ALLOCATABLE :: scdnc(:,:)
      !$OMP THREADPRIVATE(scdnc)
      REAL, SAVE, ALLOCATABLE :: cldncl(:)
      !$OMP THREADPRIVATE(cldncl)
      REAL, SAVE, ALLOCATABLE :: reffclwtop(:)
      !$OMP THREADPRIVATE(reffclwtop)
      REAL, SAVE, ALLOCATABLE :: lcc(:)
      !$OMP THREADPRIVATE(lcc)
      REAL, SAVE, ALLOCATABLE :: reffclws(:,:)
      !$OMP THREADPRIVATE(reffclws)
      REAL, SAVE, ALLOCATABLE :: reffclwc(:,:)
      !$OMP THREADPRIVATE(reffclwc)
      REAL, SAVE, ALLOCATABLE :: cldnvi(:) 
      !$OMP THREADPRIVATE(cldnvi)
      REAL, SAVE, ALLOCATABLE :: lcc3d(:,:)
      !$OMP THREADPRIVATE(lcc3d)
      REAL, SAVE, ALLOCATABLE :: lcc3dcon(:,:)
      !$OMP THREADPRIVATE(lcc3dcon)
      REAL, SAVE, ALLOCATABLE :: lcc3dstra(:,:)
      !$OMP THREADPRIVATE(lcc3dstra)
      REAL, SAVE, ALLOCATABLE :: od550aer(:) 
      !$OMP THREADPRIVATE(od550aer) 
      REAL, SAVE, ALLOCATABLE :: absvisaer(:) 
      !$OMP THREADPRIVATE(absvisaer) 
      REAL, SAVE, ALLOCATABLE :: od865aer(:) 
      !$OMP THREADPRIVATE(od865aer) 
      REAL, SAVE, ALLOCATABLE :: ec550aer(:,:) 
      !$OMP THREADPRIVATE(ec550aer) 
      REAL, SAVE, ALLOCATABLE :: od550lt1aer(:) 
      !$OMP THREADPRIVATE(od550lt1aer) 
      REAL, SAVE, ALLOCATABLE :: sconcso4(:) 
      !$OMP THREADPRIVATE(sconcso4) 
      REAL, SAVE, ALLOCATABLE :: sconcno3(:) 
      !$OMP THREADPRIVATE(sconcno3) 
      REAL, SAVE, ALLOCATABLE :: sconcoa(:) 
      !$OMP THREADPRIVATE(sconcoa) 
      REAL, SAVE, ALLOCATABLE :: sconcbc(:) 
      !$OMP THREADPRIVATE(sconcbc) 
      REAL, SAVE, ALLOCATABLE :: sconcss(:) 
      !$OMP THREADPRIVATE(sconcss) 
      REAL, SAVE, ALLOCATABLE :: sconcdust(:) 
      !$OMP THREADPRIVATE(sconcdust) 
      REAL, SAVE, ALLOCATABLE :: concso4(:,:) 
      !$OMP THREADPRIVATE(concso4) 
      REAL, SAVE, ALLOCATABLE :: concno3(:,:) 
      !$OMP THREADPRIVATE(concno3) 
      REAL, SAVE, ALLOCATABLE :: concoa(:,:) 
      !$OMP THREADPRIVATE(concoa) 
      REAL, SAVE, ALLOCATABLE :: concbc(:,:) 
      !$OMP THREADPRIVATE(concbc) 
      REAL, SAVE, ALLOCATABLE :: concss(:,:) 
      !$OMP THREADPRIVATE(concss) 
      REAL, SAVE, ALLOCATABLE :: concdust(:,:) 
      !$OMP THREADPRIVATE(concdust) 
      REAL, SAVE, ALLOCATABLE :: loadso4(:) 
      !$OMP THREADPRIVATE(loadso4) 
      REAL, SAVE, ALLOCATABLE :: loadoa(:) 
      !$OMP THREADPRIVATE(loadoa) 
      REAL, SAVE, ALLOCATABLE :: loadbc(:) 
      !$OMP THREADPRIVATE(loadbc) 
      REAL, SAVE, ALLOCATABLE :: loadss(:) 
      !$OMP THREADPRIVATE(loadss) 
      REAL, SAVE, ALLOCATABLE :: loaddust(:) 
      !$OMP THREADPRIVATE(loaddust) 
      REAL, SAVE, ALLOCATABLE :: load_tmp1(:) 
      !$OMP THREADPRIVATE(load_tmp1) 
      REAL, SAVE, ALLOCATABLE :: load_tmp2(:) 
      !$OMP THREADPRIVATE(load_tmp2) 
      REAL, SAVE, ALLOCATABLE :: load_tmp3(:) 
      !$OMP THREADPRIVATE(load_tmp3) 
      REAL, SAVE, ALLOCATABLE :: load_tmp4(:) 
      !$OMP THREADPRIVATE(load_tmp4) 
      REAL, SAVE, ALLOCATABLE :: load_tmp5(:) 
      !$OMP THREADPRIVATE(load_tmp5) 
      REAL, SAVE, ALLOCATABLE :: load_tmp6(:) 
      !$OMP THREADPRIVATE(load_tmp6) 
      REAL, SAVE, ALLOCATABLE :: load_tmp7(:) 
      !$OMP THREADPRIVATE(load_tmp7) 

!IM ajout variables CFMIP2/CMIP5
      REAL,ALLOCATABLE,SAVE :: topswad_aerop(:), solswad_aerop(:)
!$OMP THREADPRIVATE(topswad_aerop, solswad_aerop)
      REAL,ALLOCATABLE,SAVE :: topswai_aerop(:), solswai_aerop(:)
!$OMP THREADPRIVATE(topswai_aerop, solswai_aerop)
      REAL,ALLOCATABLE,SAVE :: topswad0_aerop(:), solswad0_aerop(:)
!$OMP THREADPRIVATE(topswad0_aerop, solswad0_aerop)
      REAL,ALLOCATABLE,SAVE :: topsw_aerop(:,:), topsw0_aerop(:,:)  
!$OMP THREADPRIVATE(topsw_aerop, topsw0_aerop)
      REAL,ALLOCATABLE,SAVE :: solsw_aerop(:,:), solsw0_aerop(:,:)
!$OMP THREADPRIVATE(solsw_aerop, solsw0_aerop)
      REAL,ALLOCATABLE,SAVE :: topswcf_aerop(:,:), solswcf_aerop(:,:)
!$OMP THREADPRIVATE(topswcf_aerop, solswcf_aerop)

! additional LW variables CK
      REAL,ALLOCATABLE,SAVE :: toplwad_aerop(:), sollwad_aerop(:)
!$OMP THREADPRIVATE(toplwad_aerop, sollwad_aerop)
      REAL,ALLOCATABLE,SAVE :: toplwai_aerop(:), sollwai_aerop(:)
!$OMP THREADPRIVATE(toplwai_aerop, sollwai_aerop)
      REAL,ALLOCATABLE,SAVE :: toplwad0_aerop(:), sollwad0_aerop(:)
!$OMP THREADPRIVATE(toplwad0_aerop, sollwad0_aerop)

!Ajout de celles nécessaires au phys_output_write_mod
      REAL, SAVE, ALLOCATABLE :: tal1(:), pal1(:), pab1(:), pab2(:)
!$OMP THREADPRIVATE(tal1, pal1, pab1, pab2)
      REAL, SAVE, ALLOCATABLE :: ptstar(:), pt0(:), slp(:)
!$OMP THREADPRIVATE(ptstar, pt0, slp)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: sens, flwp, fiwp 
!$OMP THREADPRIVATE(sens, flwp, fiwp)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: ale_wake, alp_wake, bils
!$OMP THREADPRIVATE(ale_wake, alp_wake, bils)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: cdragm, cdragh
!$OMP THREADPRIVATE(cdragm, cdragh)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: cldh, cldl, cldm, cldq, cldt, qsat2m
!$OMP THREADPRIVATE(cldh, cldl, cldm, cldq, cldt, qsat2m )
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: cldhjn, cldljn, cldmjn,cldtjn
!$OMP THREADPRIVATE(cldhjn, cldljn, cldmjn, cldtjn)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: JrNt
!$OMP THREADPRIVATE(JrNt)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: dthmin, evap, fder, plcl, plfc, prw, prlw, prsw
!$OMP THREADPRIVATE(dthmin, evap, fder, plcl, plfc, prw, prlw, prsw)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: zustar, zu10m, zv10m, rh2m
!$OMP THREADPRIVATE(zustar, zu10m, zv10m, rh2m)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: s_lcl, s_pblh, s_pblt, s_therm
!$OMP THREADPRIVATE(s_lcl, s_pblh, s_pblt, s_therm)
!
!nrlmd+jyg<
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: s_pblh_x, s_pblh_w
!$OMP THREADPRIVATE(s_pblh_x, s_pblh_w)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: s_lcl_x, s_lcl_w
!$OMP THREADPRIVATE(s_lcl_x, s_lcl_w)
!>nrlmd+jyg
!
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: slab_wfbils
!$OMP THREADPRIVATE(slab_wfbils)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: tpot, tpote, ue, uq, ve, vq, zxffonte
!$OMP THREADPRIVATE(tpot, tpote, ue, uq, ve, vq, zxffonte)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: zxfqcalving
!$OMP THREADPRIVATE(zxfqcalving)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: zxfluxlat, zxtsol, snow_lsc, zxfqfonte
!$OMP THREADPRIVATE(zxfluxlat, zxtsol, snow_lsc, zxfqfonte)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: zxqsurf, rain_lsc
!$OMP THREADPRIVATE(zxqsurf, rain_lsc)
!
!jyg+nrlmd<
!!!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!                                                                          c
!       Declarations liees a la couche limite differentiee w-x             c
!                                                                          c
!!!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: sens_x, sens_w
!$OMP THREADPRIVATE(sens_x, sens_w)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: zxfluxlat_x, zxfluxlat_w
!$OMP THREADPRIVATE(zxfluxlat_x, zxfluxlat_w)
!jyg<
!!! Entres supplmentaires couche-limite
!!      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: t_x, t_w
!!!$OMP THREADPRIVATE(t_x, t_w)
!!      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: q_x, q_w
!!!$OMP THREADPRIVATE(q_x, q_w)
!>jyg
!!! Sorties ferret
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: dtvdf_x, dtvdf_w
!$OMP THREADPRIVATE(dtvdf_x, dtvdf_w)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: dqvdf_x, dqvdf_w
!$OMP THREADPRIVATE(dqvdf_x, dqvdf_w)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: undi_tke, wake_tke
!$OMP THREADPRIVATE(undi_tke, wake_tke)
! Variables supplmentaires dans physiq.F relative au splitting de la surface
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:) :: pbl_tke_input
!$OMP THREADPRIVATE(pbl_tke_input)
! Entree supplementaire Thermiques :
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: t_therm, q_therm
!$OMP THREADPRIVATE(t_therm, q_therm)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: cdragh_x, cdragh_w
!$OMP THREADPRIVATE(cdragh_x, cdragh_w)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: cdragm_x, cdragm_w
!$OMP THREADPRIVATE(cdragm_x, cdragm_w)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: kh, kh_x, kh_w
!$OMP THREADPRIVATE(kh, kh_x, kh_w)
!!!
!!!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!>jyg+nrlmd
  !
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: wake_h, wbeff, zmax_th, zq2m, zt2m
!$OMP THREADPRIVATE(wake_h, wbeff, zmax_th, zq2m, zt2m)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: zt2m_min_mon, zt2m_max_mon
!$OMP THREADPRIVATE(zt2m_min_mon, zt2m_max_mon)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: t2m_min_mon, t2m_max_mon
!$OMP THREADPRIVATE(t2m_min_mon, t2m_max_mon)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: weak_inversion
!$OMP THREADPRIVATE(weak_inversion)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: ale_bl_stat,alp_bl_conv,alp_bl_det
!$OMP THREADPRIVATE(ale_bl_stat,alp_bl_conv,alp_bl_det)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: alp_bl_fluct_m,alp_bl_fluct_tke
!$OMP THREADPRIVATE(alp_bl_fluct_m,alp_bl_fluct_tke)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: alp_bl_stat, n2, s2
!$OMP THREADPRIVATE(alp_bl_stat, n2, s2)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: proba_notrig, random_notrig
!$OMP THREADPRIVATE(proba_notrig, random_notrig)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: fsolsw, wfbils, wfbilo
!$OMP THREADPRIVATE(fsolsw, wfbils, wfbilo)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: t2m, fluxlat, fsollw,evap_pot
!$OMP THREADPRIVATE(t2m, fluxlat, fsollw,evap_pot)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: dnwd, dnwd0, upwd, omega
!$OMP THREADPRIVATE(dnwd, dnwd0, upwd, omega)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: epmax_diag ! epmax_cape
!$OMP THREADPRIVATE(epmax_diag)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: ep ! epmax_cape
!$OMP THREADPRIVATE(ep)
!      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: coefh, coefm, lambda_th
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: lambda_th
!$OMP THREADPRIVATE(lambda_th)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: cldemi, cldfra, cldtau, fiwc, fl, re, flwc
!$OMP THREADPRIVATE(cldemi, cldfra, cldtau, fiwc, fl, re, flwc)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: ref_liq, ref_ice, theta, zphi
!$OMP THREADPRIVATE(ref_liq, ref_ice, theta, zphi)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: ref_liq_pi, ref_ice_pi
!$OMP THREADPRIVATE(ref_liq_pi, ref_ice_pi)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: wake_omg, zx_rh
!$OMP THREADPRIVATE(wake_omg, zx_rh)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: pmflxr, pmflxs, prfl, psfl, fraca
!$OMP THREADPRIVATE(pmflxr, pmflxs, prfl, psfl, fraca)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: Vprecip, zw2
!$OMP THREADPRIVATE(Vprecip, zw2)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: pmfd, pmfu
!$OMP THREADPRIVATE(pmfd, pmfu)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:) :: fluxt, fluxu, fluxv
!$OMP THREADPRIVATE(fluxt, fluxu, fluxv)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:) :: uwriteSTD, vwriteSTD, wwriteSTD
!$OMP THREADPRIVATE(uwriteSTD, vwriteSTD, wwriteSTD)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:) :: phiwriteSTD, qwriteSTD, twriteSTD, rhwriteSTD
!$OMP THREADPRIVATE(phiwriteSTD, qwriteSTD, twriteSTD, rhwriteSTD)

! ug et d'autres encore:
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: wdtrainA, wdtrainM
!$OMP THREADPRIVATE(wdtrainA, wdtrainM)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: beta_prec
!$OMP THREADPRIVATE(beta_prec)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: rneb,rnebjn
!$OMP THREADPRIVATE(rneb,rnebjn)

! variables de sorties MM
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: zxsnow,snowhgt,qsnow,to_ice
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: sissnow,runoff,albsol3_lic
!$OMP THREADPRIVATE(zxsnow,snowhgt,qsnow,to_ice)
!$OMP THREADPRIVATE(sissnow,runoff,albsol3_lic)

CONTAINS

!======================================================================
SUBROUTINE phys_local_var_init
USE dimphy
USE infotrac_phy, ONLY : nbtr
USE aero_mod
USE indice_sol_mod
USE phys_output_var_mod
USE phys_state_var_mod

IMPLICIT NONE
      allocate(t_seri(klon,klev),q_seri(klon,klev),ql_seri(klon,klev),qs_seri(klon,klev))
      allocate(u_seri(klon,klev),v_seri(klon,klev))

      allocate(tr_seri(klon,klev,nbtr))
      allocate(d_t_dyn(klon,klev),d_q_dyn(klon,klev))
      allocate(d_ql_dyn(klon,klev),d_qs_dyn(klon,klev))
      allocate(d_q_dyn2d(klon),d_ql_dyn2d(klon),d_qs_dyn2d(klon))
      allocate(d_u_dyn(klon,klev),d_v_dyn(klon,klev))
      allocate(d_tr_dyn(klon,klev,nbtr))                   !RomP
      allocate(d_t_con(klon,klev),d_q_con(klon,klev))
      allocate(d_u_con(klon,klev),d_v_con(klon,klev))
      allocate(d_t_wake(klon,klev),d_q_wake(klon,klev))
      allocate(d_t_lsc(klon,klev),d_q_lsc(klon,klev))
      allocate(d_t_lwr(klon,klev),d_t_lw0(klon,klev))
      allocate(d_t_swr(klon,klev),d_t_sw0(klon,klev))
      allocate(d_ql_lsc(klon,klev),d_qi_lsc(klon,klev))
      allocate(d_t_ajsb(klon,klev),d_q_ajsb(klon,klev))
      allocate(d_t_ajs(klon,klev),d_q_ajs(klon,klev))
!nrlmd<
      allocate(d_t_ajs_w(klon,klev),d_q_ajs_w(klon,klev))
      allocate(d_t_ajs_x(klon,klev),d_q_ajs_x(klon,klev))
!>nrlmd
      allocate(d_u_ajs(klon,klev),d_v_ajs(klon,klev))
      allocate(d_t_eva(klon,klev),d_q_eva(klon,klev))
      allocate(d_t_lscst(klon,klev),d_q_lscst(klon,klev))
      allocate(d_t_lscth(klon,klev),d_q_lscth(klon,klev))
      allocate(plul_st(klon),plul_th(klon))
      allocate(d_t_vdf(klon,klev),d_q_vdf(klon,klev),d_t_diss(klon,klev))
!nrlmd+jyg<
      allocate(d_t_vdf_w(klon,klev),d_q_vdf_w(klon,klev))
      allocate(d_t_vdf_x(klon,klev),d_q_vdf_x(klon,klev))
!>nrlmd+jyg
      allocate(d_u_vdf(klon,klev),d_v_vdf(klon,klev))
      allocate(d_t_oli(klon,klev),d_t_oro(klon,klev))
      allocate(d_u_oli(klon,klev),d_v_oli(klon,klev))
      allocate(d_u_oro(klon,klev),d_v_oro(klon,klev))
      allocate(d_t_lif(klon,klev),d_t_ec(klon,klev))
      allocate(d_u_lif(klon,klev),d_v_lif(klon,klev))
      allocate(d_ts(klon,nbsrf), d_tr(klon,klev,nbtr))
! Special RRTM
      allocate(ZLWFT0_i(klon,klev+1),ZSWFT0_i(klon,klev+1),ZFLDN0(klon,klev+1))
      allocate(ZFLUP0(klon,klev+1),ZFSDN0(klon,klev+1),ZFSUP0(klon,klev+1))
!
      allocate(topswad_aero(klon), solswad_aero(klon))
      allocate(topswai_aero(klon), solswai_aero(klon))
      allocate(topswad0_aero(klon), solswad0_aero(klon))
     ! LW diagnostics CK
      allocate(toplwad_aero(klon), sollwad_aero(klon))
      allocate(toplwai_aero(klon), sollwai_aero(klon))
      allocate(toplwad0_aero(klon), sollwad0_aero(klon))
      ! end
      allocate(topsw_aero(klon,naero_grp), solsw_aero(klon,naero_grp))
      allocate(topsw0_aero(klon,naero_grp), solsw0_aero(klon,naero_grp))
      allocate(topswcf_aero(klon,3), solswcf_aero(klon,3))
      allocate(du_gwd_hines(klon,klev),dv_gwd_hines(klon,klev))
      allocate(dv_gwd_rando(klon,klev),dv_gwd_front(klon,klev))
      allocate(east_gwstress(klon,klev),west_gwstress(klon,klev))
      allocate(d_t_hin(klon,klev))
      allocate(d_q_ch4(klon,klev))
!      allocate(tausum_aero(klon,nwave,naero_spc))
!      allocate(tau3d_aero(klon,klev,nwave,naero_spc)) 
!--correction mini bug OB
      allocate(tausum_aero(klon,nwave,naero_tot))
      allocate(tau3d_aero(klon,klev,nwave,naero_tot)) 
      allocate(scdnc(klon, klev))
      allocate(cldncl(klon))
      allocate(reffclwtop(klon))
      allocate(lcc(klon))
      allocate(reffclws(klon, klev))
      allocate(reffclwc(klon, klev))
      allocate(cldnvi(klon))
      allocate(lcc3d(klon, klev))
      allocate(lcc3dcon(klon, klev))
      allocate(lcc3dstra(klon, klev))
      allocate(od550aer(klon))
      allocate(od865aer(klon))
      allocate(absvisaer(klon))
      allocate(ec550aer(klon,klev))
      allocate(od550lt1aer(klon))
      allocate(sconcso4(klon))
      allocate(sconcno3(klon))
      allocate(sconcoa(klon))
      allocate(sconcbc(klon))
      allocate(sconcss(klon))
      allocate(sconcdust(klon))
      allocate(concso4(klon,klev))
      allocate(concno3(klon,klev))
      allocate(concoa(klon,klev))
      allocate(concbc(klon,klev))
      allocate(concss(klon,klev))
      allocate(concdust(klon,klev))
      allocate(loadso4(klon))
      allocate(loadoa(klon))
      allocate(loadbc(klon))
      allocate(loadss(klon))
      allocate(loaddust(klon))
      allocate(load_tmp1(klon))
      allocate(load_tmp2(klon))
      allocate(load_tmp3(klon))
      allocate(load_tmp4(klon))
      allocate(load_tmp5(klon))
      allocate(load_tmp6(klon))
      allocate(load_tmp7(klon))

!IM ajout variables CFMIP2/CMIP5
      ALLOCATE(topswad_aerop(klon), solswad_aerop(klon))
      ALLOCATE(topswai_aerop(klon), solswai_aerop(klon))
      ALLOCATE(topswad0_aerop(klon), solswad0_aerop(klon))
      ALLOCATE(topsw_aerop(klon,naero_grp), topsw0_aerop(klon,naero_grp))
      ALLOCATE(solsw_aerop(klon,naero_grp), solsw0_aerop(klon,naero_grp))
      ALLOCATE(topswcf_aerop(klon,naero_grp), solswcf_aerop(klon,naero_grp))

! additional LW variables CK
      ALLOCATE(toplwad_aerop(klon), sollwad_aerop(klon))
      ALLOCATE(toplwai_aerop(klon), sollwai_aerop(klon))
      ALLOCATE(toplwad0_aerop(klon), sollwad0_aerop(klon))

! FH Ajout de celles nécessaires au phys_output_write_mod

      ALLOCATE(tal1(klon), pal1(klon), pab1(klon), pab2(klon))
      ALLOCATE(ptstar(klon),pt0(klon),slp(klon))
      ALLOCATE(ale_wake(klon), alp_wake(klon), bils(klon))
      ALLOCATE(cdragm(klon), cdragh(klon), cldh(klon), cldl(klon))
      ALLOCATE(cldm(klon), cldq(klon), cldt(klon), qsat2m(klon))
      ALLOCATE(cldhjn(klon), cldljn(klon), cldmjn(klon), cldtjn(klon))
      ALLOCATE(JrNt(klon))
      ALLOCATE(dthmin(klon), evap(klon), fder(klon), plcl(klon), plfc(klon))
      ALLOCATE(prw(klon), prlw(klon), prsw(klon), zustar(klon), zu10m(klon), zv10m(klon), rh2m(klon))
      ALLOCATE(s_lcl(klon))
      ALLOCATE(s_pblh(klon), s_pblt(klon), s_therm(klon))
!
!nrlmd+jyg<
      ALLOCATE(s_pblh_x(klon), s_pblh_w(klon))
      ALLOCATE(s_lcl_x(klon), s_lcl_w(klon))
!>nrlmd+jyg
!
      ALLOCATE(slab_wfbils(klon), tpot(klon), tpote(klon), ue(klon))
      ALLOCATE(uq(klon), ve(klon), vq(klon), zxffonte(klon))
      ALLOCATE(zxfqcalving(klon), zxfluxlat(klon))
      ALLOCATE(zxtsol(klon), snow_lsc(klon), zxfqfonte(klon), zxqsurf(klon))
      ALLOCATE(rain_lsc(klon))
!
      ALLOCATE(sens_x(klon), sens_w(klon))
      ALLOCATE(zxfluxlat_x(klon), zxfluxlat_w(klon))
!jyg<
!!      ALLOCATE(t_x(klon,klev), t_w(klon,klev))
!!      ALLOCATE(q_x(klon,klev), q_w(klon,klev))
!>jyg
      ALLOCATE(dtvdf_x(klon,klev), dtvdf_w(klon,klev))
      ALLOCATE(dqvdf_x(klon,klev), dqvdf_w(klon,klev))
      ALLOCATE(undi_tke(klon,klev), wake_tke(klon,klev))
      ALLOCATE(pbl_tke_input(klon,klev+1,nbsrf))
      ALLOCATE(t_therm(klon,klev), q_therm(klon,klev))
      ALLOCATE(cdragh_x(klon), cdragh_w(klon))
      ALLOCATE(cdragm_x(klon), cdragm_w(klon))
      ALLOCATE(kh(klon), kh_x(klon), kh_w(klon))
!
      ALLOCATE(wake_h(klon), wbeff(klon), zmax_th(klon))
      ALLOCATE(zq2m(klon), zt2m(klon), weak_inversion(klon))
      ALLOCATE(zt2m_min_mon(klon), zt2m_max_mon(klon))
      ALLOCATE(t2m_min_mon(klon), t2m_max_mon(klon))
      ALLOCATE(sens(klon), flwp(klon), fiwp(klon))
      ALLOCATE(ale_bl_stat(klon), alp_bl_conv(klon), alp_bl_det(klon))
      ALLOCATE(alp_bl_fluct_m(klon), alp_bl_fluct_tke(klon))
      ALLOCATE(alp_bl_stat(klon), n2(klon), s2(klon))
      ALLOCATE(proba_notrig(klon), random_notrig(klon))

      ALLOCATE(dnwd(klon, klev), dnwd0(klon, klev))
!      ALLOCATE(upwd(klon, klev), omega(klon, klev), coefh(klon, klev))
      ALLOCATE(upwd(klon, klev), omega(klon, klev))
      ALLOCATE(epmax_diag(klon)) ! epmax_cape
      ALLOCATE(ep(klon,klev)) ! epmax_cape
!      ALLOCATE(coefm(klon, klev), lambda_th(klon, klev), cldemi(klon, klev))
      ALLOCATE(lambda_th(klon, klev), cldemi(klon, klev))
      ALLOCATE(cldfra(klon, klev), cldtau(klon, klev), fiwc(klon, klev))
      ALLOCATE(fl(klon, klev), re(klon, klev), flwc(klon, klev))
      ALLOCATE(ref_liq(klon, klev), ref_ice(klon, klev), theta(klon, klev))
      ALLOCATE(ref_liq_pi(klon, klev), ref_ice_pi(klon, klev))
      ALLOCATE(zphi(klon, klev), wake_omg(klon, klev), zx_rh(klon, klev))
      ALLOCATE(pmfd(klon, klev), pmfu(klon, klev))

      ALLOCATE(t2m(klon, nbsrf), fluxlat(klon, nbsrf))
      ALLOCATE(fsollw(klon, nbsrf))
      ALLOCATE(fsolsw(klon, nbsrf), wfbils(klon, nbsrf), wfbilo(klon, nbsrf))
      ALLOCATE(evap_pot(klon, nbsrf))

      ALLOCATE(pmflxr(klon, klev+1), pmflxs(klon, klev+1), prfl(klon, klev+1))
      ALLOCATE(psfl(klon, klev+1), fraca(klon, klev+1), Vprecip(klon, klev+1))
      ALLOCATE(zw2(klon, klev+1))

      ALLOCATE(fluxu(klon, klev, nbsrf), fluxv(klon, klev, nbsrf))
      ALLOCATE(fluxt(klon, klev, nbsrf))

      ALLOCATE(uwriteSTD(klon,nlevSTD,nfiles), vwriteSTD(klon,nlevSTD,nfiles))
      ALLOCATE(wwriteSTD(klon,nlevSTD,nfiles), phiwriteSTD(klon,nlevSTD,nfiles))
      ALLOCATE(qwriteSTD(klon,nlevSTD,nfiles), twriteSTD(klon,nlevSTD,nfiles))
      ALLOCATE(rhwriteSTD(klon,nlevSTD,nfiles))

! ug et d'autres encore:
      ALLOCATE(wdtrainA(klon,klev),wdtrainM(klon,klev))
      ALLOCATE(beta_prec(klon,klev))
      ALLOCATE(rneb(klon,klev),rnebjn(klon,klev))


      ALLOCATE (zxsnow(klon),snowhgt(klon),qsnow(klon),to_ice(klon))
      ALLOCATE (sissnow(klon),runoff(klon),albsol3_lic(klon))



END SUBROUTINE phys_local_var_init

!======================================================================
SUBROUTINE phys_local_var_end
USE dimphy
USE indice_sol_mod
IMPLICIT NONE
      deallocate(t_seri,q_seri,ql_seri,qs_seri)
      deallocate(u_seri,v_seri)

      deallocate(tr_seri)
      deallocate(d_t_dyn,d_q_dyn)
      deallocate(d_ql_dyn,d_qs_dyn)
      deallocate(d_q_dyn2d,d_ql_dyn2d,d_qs_dyn2d)
      deallocate(d_u_dyn,d_v_dyn)
      deallocate(d_tr_dyn)                      !RomP
      deallocate(d_t_con,d_q_con)
      deallocate(d_u_con,d_v_con)
      deallocate(d_t_wake,d_q_wake)
      deallocate(d_t_lsc,d_q_lsc)
      deallocate(d_t_lwr,d_t_lw0)
      deallocate(d_t_swr,d_t_sw0)
      deallocate(d_ql_lsc,d_qi_lsc)
      deallocate(d_t_ajsb,d_q_ajsb)
      deallocate(d_t_ajs,d_q_ajs)
!nrlmd<
      deallocate(d_t_ajs_w,d_q_ajs_w)
      deallocate(d_t_ajs_x,d_q_ajs_x)
!>nrlmd
      deallocate(d_u_ajs,d_v_ajs)
      deallocate(d_t_eva,d_q_eva)
      deallocate(d_t_lscst,d_q_lscst)
      deallocate(d_t_lscth,d_q_lscth)
      deallocate(plul_st,plul_th)
      deallocate(d_t_vdf,d_q_vdf,d_t_diss)
!nrlmd+jyg<
      deallocate(d_t_vdf_w,d_q_vdf_w)
      deallocate(d_t_vdf_x,d_q_vdf_x)
!>nrlmd+jyg
      deallocate(d_u_vdf,d_v_vdf)
      deallocate(d_t_oli,d_t_oro)
      deallocate(d_u_oli,d_v_oli)
      deallocate(d_u_oro,d_v_oro)
      deallocate(d_t_lif,d_t_ec)
      deallocate(d_u_lif,d_v_lif)
      deallocate(d_ts, d_tr)
      deallocate(topswad_aero,solswad_aero)
      deallocate(topswai_aero,solswai_aero)
      deallocate(topswad0_aero,solswad0_aero)
      ! LW additional CK
      deallocate(toplwad_aero,sollwad_aero)
      deallocate(toplwai_aero,sollwai_aero)
      deallocate(toplwad0_aero,sollwad0_aero)
      ! end
      deallocate(topsw_aero,solsw_aero)
      deallocate(topsw0_aero,solsw0_aero)
      deallocate(topswcf_aero,solswcf_aero)
      deallocate(tausum_aero) 
      deallocate(tau3d_aero) 
      deallocate(scdnc)
      deallocate(cldncl)
      deallocate(reffclwtop)
      deallocate(lcc)
      deallocate(reffclws)
      deallocate(reffclwc)
      deallocate(cldnvi)
      deallocate(lcc3d)
      deallocate(lcc3dcon)
      deallocate(lcc3dstra)
      deallocate(od550aer)
      deallocate(od865aer)
      deallocate(absvisaer)
      deallocate(ec550aer)
      deallocate(od550lt1aer)
      deallocate(sconcso4) 
      deallocate(sconcno3) 
      deallocate(sconcoa) 
      deallocate(sconcbc) 
      deallocate(sconcss) 
      deallocate(sconcdust) 
      deallocate(concso4) 
      deallocate(concno3) 
      deallocate(concoa) 
      deallocate(concbc) 
      deallocate(concss) 
      deallocate(concdust) 
      deallocate(loadso4) 
      deallocate(loadoa) 
      deallocate(loadbc) 
      deallocate(loadss) 
      deallocate(loaddust) 
      deallocate(load_tmp1)
      deallocate(load_tmp2)
      deallocate(load_tmp3)
      deallocate(load_tmp4)
      deallocate(load_tmp5)
      deallocate(load_tmp6)
      deallocate(load_tmp7)
      deallocate(du_gwd_hines,dv_gwd_hines,d_t_hin)
      deallocate(d_q_ch4)
      deallocate(dv_gwd_rando,dv_gwd_front)
      deallocate(east_gwstress,west_gwstress)

!IM ajout variables CFMIP2/CMIP5
      deallocate(topswad_aerop, solswad_aerop)
      deallocate(topswai_aerop, solswai_aerop)
      deallocate(topswad0_aerop, solswad0_aerop)
      deallocate(topsw_aerop, topsw0_aerop)
      deallocate(solsw_aerop, solsw0_aerop)
      deallocate(topswcf_aerop, solswcf_aerop)

!CK LW diagnostics
      deallocate(toplwad_aerop, sollwad_aerop)
      deallocate(toplwai_aerop, sollwai_aerop)
      deallocate(toplwad0_aerop, sollwad0_aerop)

! FH Ajout de celles nécessaires au phys_output_write_mod
      DEALLOCATE(tal1, pal1, pab1, pab2)
      DEALLOCATE(ptstar, pt0, slp)
      DEALLOCATE(ale_wake, alp_wake, bils)
      DEALLOCATE(cdragm, cdragh, cldh, cldl)
      DEALLOCATE(cldm, cldq, cldt, qsat2m)
      DEALLOCATE(cldljn, cldmjn, cldhjn, cldtjn, JrNt)
      DEALLOCATE(dthmin, evap, fder, plcl, plfc)
      DEALLOCATE(prw, prlw, prsw, zustar, zu10m, zv10m, rh2m, s_lcl)
      DEALLOCATE(s_pblh, s_pblt, s_therm)
!
!nrlmd+jyg<
      DEALLOCATE(s_pblh_x, s_pblh_w)
      DEALLOCATE(s_lcl_x, s_lcl_w)
!>nrlmd+jyg
!
      DEALLOCATE(slab_wfbils, tpot, tpote, ue)
      DEALLOCATE(uq, ve, vq, zxffonte)
      DEALLOCATE(zxfqcalving, zxfluxlat)
      DEALLOCATE(zxtsol, snow_lsc, zxfqfonte, zxqsurf)
      DEALLOCATE(rain_lsc)
!
      DEALLOCATE(sens_x, sens_w)
      DEALLOCATE(zxfluxlat_x, zxfluxlat_w)
!jyg<
!!      DEALLOCATE(t_x, t_w)
!!      DEALLOCATE(q_x, q_w)
!>jyg
      DEALLOCATE(dtvdf_x, dtvdf_w)
      DEALLOCATE(dqvdf_x, dqvdf_w)
      DEALLOCATE(undi_tke, wake_tke)
      DEALLOCATE(pbl_tke_input)
      DEALLOCATE(t_therm, q_therm)
      DEALLOCATE(cdragh_x, cdragh_w)
      DEALLOCATE(cdragm_x, cdragm_w)
      DEALLOCATE(kh, kh_x, kh_w)
!
      DEALLOCATE(wake_h, wbeff, zmax_th)
      DEALLOCATE(zq2m, zt2m, weak_inversion)
      DEALLOCATE(zt2m_min_mon, zt2m_max_mon)
      DEALLOCATE(t2m_min_mon, t2m_max_mon)
      DEALLOCATE(sens, flwp, fiwp)
      DEALLOCATE(ale_bl_stat,alp_bl_conv,alp_bl_det)
      DEALLOCATE(alp_bl_fluct_m,alp_bl_fluct_tke)
      DEALLOCATE(alp_bl_stat, n2, s2)
      DEALLOCATE(proba_notrig, random_notrig)

      DEALLOCATE(dnwd, dnwd0)
!      DEALLOCATE(upwd, omega, coefh)
      DEALLOCATE(upwd, omega)
      DEALLOCATE(epmax_diag)
      DEALLOCATE(ep)
!      DEALLOCATE(coefm, lambda_th, cldemi)
      DEALLOCATE(lambda_th, cldemi)
      DEALLOCATE(cldfra, cldtau, fiwc)
      DEALLOCATE(fl, re, flwc)
      DEALLOCATE(ref_liq, ref_ice, theta)
      DEALLOCATE(ref_liq_pi, ref_ice_pi)
      DEALLOCATE(zphi, wake_omg, zx_rh)
      DEALLOCATE(pmfd, pmfu)

      DEALLOCATE(t2m, fluxlat)
      DEALLOCATE(fsollw, evap_pot)
      DEALLOCATE(fsolsw, wfbils, wfbilo)

      DEALLOCATE(pmflxr, pmflxs, prfl)
      DEALLOCATE(psfl, fraca, Vprecip)
      DEALLOCATE(zw2)

      DEALLOCATE(fluxu, fluxv)
      DEALLOCATE(fluxt)

      DEALLOCATE(uwriteSTD, vwriteSTD)
      DEALLOCATE(wwriteSTD, phiwriteSTD)
      DEALLOCATE(qwriteSTD, twriteSTD, rhwriteSTD)

! ug et d'autres encore:
      DEALLOCATE(wdtrainA, wdtrainM)
      DEALLOCATE(beta_prec)
      DEALLOCATE(rneb)
      DEALLOCATE (zxsnow,snowhgt,qsnow,to_ice,sissnow,runoff,albsol3_lic)

END SUBROUTINE phys_local_var_end

END MODULE phys_local_var_mod 
