! $Id: $

MODULE vertical_layers_mod

   REAL,SAVE             :: preff  ! reference surface pressure (Pa)
   REAL,SAVE             :: scaleheight ! atmospheric reference scale height (km)
   REAL,SAVE,ALLOCATABLE :: ap(:) ! hybrid (pressure contribution) coordinate 
                                  ! at layer interfaces (Pa)
   REAL,SAVE,ALLOCATABLE :: bp(:) ! hybrid (sigma contribution) coordinate 
                                  ! at layer interfaces (Pa)
   REAL,SAVE,ALLOCATABLE :: presnivs(:) ! reference pressure at mid-layer (Pa),
                                        ! based on preff, ap and bp
   REAL,SAVE,ALLOCATABLE :: pseudoalt(:) ! pseudo-altitude of model layers (km),
                                         ! based on preff and scaleheight
   
!$OMP THREADPRIVATE(preff,scaleheight,ap,bp,presnivs,pseudoalt)


CONTAINS

  SUBROUTINE init_vertical_layers(nlayer,preff_,scaleheight_,ap_,bp_,&
                                 presnivs_, pseudoalt_)
    IMPLICIT NONE
    INTEGER,INTENT(IN) :: nlayer ! number of atmospheric layers
    REAL,INTENT(IN)    :: preff_ ! reference surface pressure (Pa)
    REAL,INTENT(IN)    :: scaleheight_ ! atmospheric scale height (km)
    REAL,INTENT(IN)    :: ap_(nlayer+1) ! hybrid coordinate at interfaces
    REAL,INTENT(IN)    :: bp_(nlayer+1) ! hybrid coordinate at interfaces
    REAL,INTENT(IN)    :: presnivs_(nlayer) ! Appproximative pressure of atm. layers (Pa)
    REAL,INTENT(IN)    :: pseudoalt_(nlayer) ! pseudo-altitude of atm. layers (km)
  
    ALLOCATE(ap(nlayer+1))
    ALLOCATE(bp(nlayer+1))
    ALLOCATE(presnivs(nlayer))
    ALLOCATE(pseudoalt(nlayer))
  
    preff = preff_
    scaleheight=scaleheight_
    ap(:) = ap_(:)
    bp(:) = bp_(:)
    presnivs(:) = presnivs_(:)
    pseudoalt(:) = pseudoalt_(:)

  END SUBROUTINE init_vertical_layers

END MODULE vertical_layers_mod
