!
! $Id: ce0l.F90 2248 2015-03-25 18:04:54Z lguez $
!
!-------------------------------------------------------------------------------
!
PROGRAM ce0l
!-------------------------------------------------------------------------------
! Purpose: Calls etat0, creates initial states and limit_netcdf
!
!     interbar=.T. for barycentric interpolation inter_barxy
!     extrap  =.T. for data extrapolation, like for the SSTs when file does not
!                  contain ocean points only.
!     oldice  =.T. for old-style ice, obtained using grille_m (grid_atob).
!     masque is created in etat0, passed to limit to ensure consistancy.
!-------------------------------------------------------------------------------
  USE control_mod
#ifdef CPP_EARTH
! This prog. is designed to work for Earth
  USE dimphy
  USE comgeomphy
  USE infotrac
  USE indice_sol_mod

#ifdef CPP_IOIPSL
  USE ioipsl, ONLY: ioconf_calendar, getin
#else
  ! if not using IOIPSL, we still need to use (a local version of) getin
  use ioipsl_getincom, only: getin
#endif

#endif
  IMPLICIT NONE
#ifndef CPP_EARTH
#include "iniprint.h"
  WRITE(lunout,*)'limit_netcdf: Earth-specific routine, needs Earth physics'
#else
!-------------------------------------------------------------------------------
! Local variables:
  LOGICAL, PARAMETER :: interbar=.TRUE., extrap=.FALSE., oldice=.FALSE.
#include "dimensions.h"
#include "paramet.h"
!#include "indicesol.h"
#include "iniprint.h"
#include "temps.h"
#include "logic.h"
  REAL,    DIMENSION(iip1,jjp1) :: masque
  CHARACTER(LEN=15)             :: calnd
  REAL,    DIMENSION(iip1,jjp1) :: phis ! geopotentiel au sol
  logical use_filtre_fft
!-------------------------------------------------------------------------------
  CALL conf_gcm( 99, .TRUE. )

  use_filtre_fft=.FALSE.
  CALL getin('use_filtre_fft',use_filtre_fft)
  IF (use_filtre_fft) THEN
     write(lunout, fmt = *) 'FFT filter is not available in the ' &
          // 'sequential version of the dynamics.'
     write(lunout, fmt = *) &
          "Your setting of variable use_filtre_fft is not used."
  ENDIF

  CALL Init_Phys_lmdz(iim,jjp1,llm,1,(/(jjm-1)*iim+2/))
  WRITE(lunout,*)'---> klon=',klon
  CALL InitComgeomphy

#ifdef CPP_IOIPSL
  SELECT CASE(calend)
    CASE('earth_360d');CALL ioconf_calendar('360d');      calnd='a 360 jours/an'
    CASE('earth_365d');CALL ioconf_calendar('noleap');    calnd='a 365 jours/an'
    CASE('earth_366d');CALL ioconf_calendar('366d');      calnd='bissextile'
    CASE('gregorian'); CALL ioconf_calendar('gregorian'); calnd='gregorien'
    CASE('standard');  CALL ioconf_calendar('gregorian'); calnd='gregorien'
    CASE('julian');    CALL ioconf_calendar('julian');    calnd='julien'
    CASE('proleptic_gregorian'); CALL ioconf_calendar('gregorian')
  !--- DC Bof...  => IOIPSL a mettre a jour: proleptic_gregorian /= gregorian
    CASE DEFAULT
      CALL abort_gcm('ce0l','Mauvais choix de calendrier',1)
  END SELECT
  WRITE(lunout,*)'CALENDRIER CHOISI: Terrestre '//TRIM(calnd)
#endif

  IF (type_trac == 'inca') THEN
#ifdef INCA
    CALL init_const_lmdz(nbtr,anneeref,dayref,iphysiq,day_step,nday)
    CALL init_inca_para(iim,jjm+1,klon,1,klon_mpi_para_nb,0)
    WRITE(lunout,*)'nbtr =' , nbtr 
#endif
  END IF

  WRITE(lunout,'(//)')
  WRITE(lunout,*) '  *********************  '
  WRITE(lunout,*) '  ***  etat0_netcdf ***  '
  WRITE(lunout,*) '  *********************  '
  WRITE(lunout,'(//)')
  WRITE(lunout,*) ' interbar = ',interbar
  CALL etat0_netcdf(interbar,masque,phis,ok_etat0)

  IF(ok_limit) THEN
  WRITE(lunout,'(//)')
  WRITE(lunout,*) '  *********************  '
  WRITE(lunout,*) '  ***  Limit_netcdf ***  '
  WRITE(lunout,*) '  *********************  '
  WRITE(lunout,'(//)')
  CALL limit_netcdf(interbar,extrap,oldice,masque)
  END IF

  
  WRITE(lunout,'(//)')
  WRITE(lunout,*) '  ***************************  '
  WRITE(lunout,*) '  ***  grilles_gcm_netcdf ***  '
  WRITE(lunout,*) '  ***************************  '
  WRITE(lunout,'(//)')
  CALL grilles_gcm_netcdf_sub(masque,phis)

#endif
! of #ifndef CPP_EARTH #else

END PROGRAM ce0l
!
!-------------------------------------------------------------------------------
