!
MODULE surf_ocean_mod

  IMPLICIT NONE

CONTAINS
!
!****************************************************************************************
!
  SUBROUTINE surf_ocean(rlon, rlat, swnet, lwnet, alb1, &
       rugos, windsp, rmu0, fder, tsurf_in, &
       itime, dtime, jour, knon, knindex, &
       p1lay, cdragh, cdragm, precip_rain, precip_snow, temp_air, spechum, &
       AcoefH, AcoefQ, BcoefH, BcoefQ, &
       AcoefU, AcoefV, BcoefU, BcoefV, &
       ps, u1, v1, gustiness, rugoro, pctsrf, &
       snow, qsurf, agesno, &
!albedo SB >>>
!      z0_new, alb1_new, alb2_new, evap, fluxsens, fluxlat, &
       z0_new, SFRWL, alb_dir_new, alb_dif_new, evap, fluxsens, fluxlat, & 
!albedo SB <<<
       tsurf_new, dflux_s, dflux_l, lmt_bils, &
       flux_u1, flux_v1)

  USE dimphy
  USE surface_data, ONLY     : type_ocean
  USE ocean_forced_mod, ONLY : ocean_forced_noice
  USE ocean_slab_mod, ONLY   : ocean_slab_noice
  USE ocean_cpl_mod, ONLY    : ocean_cpl_noice
  USE indice_sol_mod
!
! This subroutine will make a call to ocean_XXX_noice according to the ocean mode (force, 
! slab or couple). The calculations of albedo and rugosity for the ocean surface are 
! done in here because they are identical for the different modes of ocean. 


    INCLUDE "YOMCST.h"

    include "clesphys.h"
    ! for cycle_diurne

! Input variables
!****************************************************************************************
    INTEGER, INTENT(IN)                      :: itime, jour, knon
    INTEGER, DIMENSION(klon), INTENT(IN)     :: knindex
    REAL, INTENT(IN)                         :: dtime
    REAL, DIMENSION(klon), INTENT(IN)        :: rlon, rlat
    REAL, DIMENSION(klon), INTENT(IN)        :: swnet  ! net shortwave radiation at surface  
    REAL, DIMENSION(klon), INTENT(IN)        :: lwnet  ! net longwave radiation at surface  
    REAL, DIMENSION(klon), INTENT(IN)        :: alb1   ! albedo in visible SW interval
    REAL, DIMENSION(klon), INTENT(IN)        :: rugos
    REAL, DIMENSION(klon), INTENT(IN)        :: windsp
    REAL, DIMENSION(klon), INTENT(IN)        :: rmu0  
    REAL, DIMENSION(klon), INTENT(IN)        :: fder
    REAL, DIMENSION(klon), INTENT(IN)        :: tsurf_in
    REAL, DIMENSION(klon), INTENT(IN)        :: p1lay
    REAL, DIMENSION(klon), INTENT(IN)        :: cdragh
    REAL, DIMENSION(klon), INTENT(IN)        :: cdragm
    REAL, DIMENSION(klon), INTENT(IN)        :: precip_rain, precip_snow
    REAL, DIMENSION(klon), INTENT(IN)        :: temp_air, spechum
    REAL, DIMENSION(klon), INTENT(IN)        :: AcoefH, AcoefQ, BcoefH, BcoefQ
    REAL, DIMENSION(klon), INTENT(IN)        :: AcoefU, AcoefV, BcoefU, BcoefV
    REAL, DIMENSION(klon), INTENT(IN)        :: ps
    REAL, DIMENSION(klon), INTENT(IN)        :: u1, v1, gustiness
    REAL, DIMENSION(klon), INTENT(IN)        :: rugoro
    REAL, DIMENSION(klon,nbsrf), INTENT(IN)  :: pctsrf

! In/Output variables
!****************************************************************************************
    REAL, DIMENSION(klon), INTENT(INOUT)     :: snow
    REAL, DIMENSION(klon), INTENT(INOUT)     :: qsurf
    REAL, DIMENSION(klon), INTENT(INOUT)     :: agesno

! Output variables
!****************************************************************************************
    REAL, DIMENSION(klon), INTENT(OUT)       :: z0_new
!albedo SB >>>
!    REAL, DIMENSION(klon), INTENT(OUT)       :: alb1_new  ! new albedo in visible SW interval
!    REAL, DIMENSION(klon), INTENT(OUT)       :: alb2_new  ! new albedo in near IR interval
    REAL, DIMENSION(6), INTENT(IN)          :: SFRWL 
    REAL, DIMENSION(klon,nsw), INTENT(OUT)       :: alb_dir_new,alb_dif_new
!albedo SB <<<     
    REAL, DIMENSION(klon), INTENT(OUT)       :: evap, fluxsens, fluxlat
    REAL, DIMENSION(klon), INTENT(OUT)       :: tsurf_new
    REAL, DIMENSION(klon), INTENT(OUT)       :: dflux_s, dflux_l      
    REAL, DIMENSION(klon), INTENT(OUT)       :: lmt_bils
    REAL, DIMENSION(klon), INTENT(OUT)       :: flux_u1, flux_v1

! Local variables
!****************************************************************************************
    INTEGER               :: i, k
    REAL                  :: tmp
    REAL, PARAMETER       :: cepdu2=(0.1)**2
    REAL, DIMENSION(klon) :: alb_eau
    REAL, DIMENSION(klon) :: radsol

! End definition
!****************************************************************************************


!****************************************************************************************
! Calculate total net radiance at surface
!
!****************************************************************************************
    radsol(:) = 0.0
    radsol(1:knon) = swnet(1:knon) + lwnet(1:knon)

!****************************************************************************************
! Switch according to type of ocean (couple, slab or forced)
!****************************************************************************************
    SELECT CASE(type_ocean)
    CASE('couple')
       CALL ocean_cpl_noice( &
            swnet, lwnet, alb1, &
            windsp, fder, & 
            itime, dtime, knon, knindex, &
            p1lay, cdragh, cdragm, precip_rain, precip_snow,temp_air,spechum,& 
            AcoefH, AcoefQ, BcoefH, BcoefQ, &
            AcoefU, AcoefV, BcoefU, BcoefV, &
            ps, u1, v1, gustiness, &
            radsol, snow, agesno, &
            qsurf, evap, fluxsens, fluxlat, flux_u1, flux_v1, &
            tsurf_new, dflux_s, dflux_l)

    CASE('slab')
       CALL ocean_slab_noice( &
            itime, dtime, jour, knon, knindex, &
            p1lay, cdragh, cdragm, precip_rain, precip_snow, temp_air, spechum,&
            AcoefH, AcoefQ, BcoefH, BcoefQ, &
            AcoefU, AcoefV, BcoefU, BcoefV, &
            ps, u1, v1, gustiness, tsurf_in, &
            radsol, snow, &
            qsurf, evap, fluxsens, fluxlat, flux_u1, flux_v1, &
            tsurf_new, dflux_s, dflux_l, lmt_bils)
       
    CASE('force')
       CALL ocean_forced_noice( &
            itime, dtime, jour, knon, knindex, &
            p1lay, cdragh, cdragm, precip_rain, precip_snow, &
            temp_air, spechum, &
            AcoefH, AcoefQ, BcoefH, BcoefQ, &
            AcoefU, AcoefV, BcoefU, BcoefV, &
            ps, u1, v1, gustiness, &
            radsol, snow, agesno, &
            qsurf, evap, fluxsens, fluxlat, flux_u1, flux_v1, &
            tsurf_new, dflux_s, dflux_l)
    END SELECT

!****************************************************************************************
! fcodron: compute lmt_bils  forced case (same as wfbils_oce / 1.-contfracatm)
!****************************************************************************************
    IF (type_ocean.NE.'slab') THEN
        lmt_bils(:)=0.
        DO i=1,knon
           lmt_bils(knindex(i))=(swnet(i)+lwnet(i)+fluxsens(i)+fluxlat(i)) &
           *pctsrf(knindex(i),is_oce)/(1.-zmasq(knindex(i))) 
        END DO
    END IF

!****************************************************************************************
! Calculate albedo
!
!****************************************************************************************
!albedo SB >>>


  if(iflag_albedo==1)then
    call ocean_albedo(knon,rmu0,knindex,windsp,SFRWL,alb_dir_new,alb_dif_new)
  else
    IF (cycle_diurne) THEN
       CALL alboc_cd(rmu0,alb_eau)
    ELSE
       CALL alboc(REAL(jour),rlat,alb_eau)
    ENDIF

    DO i =1, knon
      do  k=1,nsw
       alb_dir_new(i,k) = alb_eau(knindex(i))
      enddo
    ENDDO
     alb_dif_new=0.05 !alb_dir_new
endif

!albedo SB <<<

!****************************************************************************************
! Calculate the rugosity
!
!****************************************************************************************
    DO i = 1, knon
       tmp = MAX(cepdu2,u1(i)**2+v1(i)**2)
       z0_new(i) = 0.018*cdragm(i) * (u1(i)**2+v1(i)**2)/RG  &
            +  0.11*14e-6 / SQRT(cdragm(i) * tmp)
       z0_new(i) = MAX(1.5e-05,z0_new(i))
    ENDDO   
!
!****************************************************************************************
!    
  END SUBROUTINE surf_ocean
!
!****************************************************************************************
!
END MODULE surf_ocean_mod
