!
! $Header$
!
MODULE icefrac_lsc_mod

IMPLICIT NONE

CONTAINS
!*******************************************************************

SUBROUTINE icefrac_lsc(np,temp, sig, icefrac)
  !
  ! Compute the ice fraction 1-xliq (see e.g.
  ! Doutriaux-Boucher & Quaas 2004, section 2.2.)
  !
  ! (JBM 3/14 8/14)
  
  INCLUDE "nuage.h"

  ! nuage.h contains:
  ! t_glace_min: if T < Tmin, the cloud is only made of water ice
  ! t_glace_max: if T > Tmax, the cloud is only made of liquid water
  ! exposant_glace: controls the sharpness of the transition
  INTEGER :: np
  REAL, DIMENSION(np), INTENT(IN) :: temp ! temperature
  REAL, DIMENSION(np), INTENT(IN) :: sig
  REAL, DIMENSION(np), INTENT(OUT) :: icefrac

  REAL :: sig0,www,tmin_tmp,icefrac_tmp
  INTEGER :: ip

  sig0=0.8

  DO ip=1,np
     www=(max(sig(ip)-sig0,0.))/(1.-sig0) ! w=1 at the surface and 0 for sig < sig0
     tmin_tmp=www*t_glace_max+(1.-www)*t_glace_min
     icefrac_tmp= 1.0 - (temp(ip)-tmin_tmp) / (t_glace_max-tmin_tmp)
     icefrac_tmp = MIN(MAX(icefrac_tmp,0.0),1.0)
     icefrac(ip) = icefrac_tmp**exposant_glace
  ENDDO

  RETURN
END SUBROUTINE icefrac_lsc

!*******************************************************************
!
END MODULE icefrac_lsc_mod
