SUBROUTINE SUSWN (KTSW,KSW)

!**** *SUSW*   - INITIALIZE COMMON YOESW

!     PURPOSE.
!     --------
!           INITIALIZE YOESW, THE COMMON THAT CONTAINS COEFFICIENTS
!           NEEDED TO RUN THE SHORTWAVE RADIATION SUBROUTINES

!**   INTERFACE.
!     ----------
!        *CALL* *SUSW

!        EXPLICIT ARGUMENTS :
!        --------------------
!        NONE

!        IMPLICIT ARGUMENTS :
!        --------------------
!        COMMON YOESW

!     METHOD.
!     -------
!        SEE DOCUMENTATION

!     EXTERNALS.
!     ----------

!     REFERENCE.
!     ----------
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE IFS

!     AUTHOR.
!     -------
!        JEAN-JACQUES MORCRETTE *ECMWF*

!     MODIFICATIONS.
!     --------------
!        ORIGINAL : 88-12-15
!        97-04-16 JJ Morcrette  2 and 4 interval spectral resolution
!        00-10-24 JJ Morcrette  sea-ice albedo revisited
!        00-12-14 JJ Morcrette 
!               and Ph.Dubuisson B.Bonnel 6 spectral interval resolution

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOMCST   , ONLY : RG
USE YOERAD   , ONLY : NTSW     ,LONEWSW
USE YOESW    , ONLY : APAD     ,BPAD     ,RRAY     ,RSUN     ,&
           &RPDH1    ,RPDU1    ,RPNH     ,RPNU     ,RSWCE    ,&
           &RSWCP    ,RTDH2O   ,RTDUMG   ,RTH2O    ,RTUMG    ,&
           &D        ,RROMA    ,RROMB    ,RRASY    ,RHSRA    ,&
           &RHSRB    ,RHSRC    ,RHSRD    ,RHSRE    ,RHSRF    ,&
           &RHSRTA   ,RHSRTB   ,REXPO3   ,&
           &RALBICE_AR         ,RALBICE_AN         ,RWEIGHT  ,&
           &RADJUST  ,NTYPS    ,NEXPO3


IMPLICIT NONE


!     DUMMY INTEGER SCALARS
INTEGER_M :: KSW
INTEGER_M :: KTSW



!     ----------------------------------------------------------------
REAL_B :: ZAPAD2(2,3,7)  , ZBPAD2(2,3,7)  , ZD2(2,3)&
  &,  ZRAY2(2,6)     , ZSUN2(2)       , ZSWCE2(2)  , ZSWCP2(2)&
  &,  ZWEIGHT2(2,8)  , ZROMA2(2)      , ZROMB2(2)  , ZRASY2(2)&
  &,  ZRA2(2)        , ZRB2(2)        , ZRC2(2)&
  &,  ZRD2(2)        , ZRE2(2)        , ZRF2(2)    , ZALBICE2(12,2)

REAL_B :: ZAPAD4(4,3,7)  , ZBPAD4(4,3,7)  , ZD4(4,3)&
  &,  ZRAY4(4,6)     , ZSUN4(4)       , ZSWCE4(4)  , ZSWCP4(4)&
  &,  ZWEIGHT4(4,8)  , ZROMA4(4)      , ZROMB4(4)  , ZRASY4(4)&
  &,  ZRA4(4)        , ZRB4(4)        , ZRC4(4)&
  &,  ZRD4(4)        , ZRE4(4)        , ZRF4(4)    , ZALBICE4(12,4)
  
REAL_B :: ZAPAD6(6,3,7)  , ZBPAD6(6,3,7)  , ZD6(6,3)&
  &,  ZRAY6(6,6)     , ZSUN6(6)       , ZSWCE6(6)  , ZSWCP6(6)&
  &,  ZWEIGHT6(6,8)  , ZROMA6(6)      , ZROMB6(6)  , ZRASY6(6)&
  &,  ZRA6(6)        , ZRB6(6)        , ZRC6(6)&
  &,  ZRD6(6)        , ZRE6(6)        , ZRF6(6)    , ZALBICE6(12,6)
  
REAL_B :: ZTWEIGHT(8)  

!     LOCAL INTEGER SCALARS
INTEGER_M :: JC3, JC6, JI, JJ, JW, K, JTYPS, IM, JM

!     LOCAL REAL SCALARS
REAL_B :: ZH2O, ZPDHNIS, ZPDH2O, ZPDUNIS,&
          &ZPDUMG, ZPRHNIS, ZPRH2O, &
          &ZPRUNIS, ZPRUMG, ZRTO1, ZRTO2, ZTDHNIS, &
          &ZTDUNIS, ZTHNIS, &
          &ZTUNIS, ZUMG, ZADJUS2, ZADJUS4, ZADJUS6


!     ----------------------------------------------------------------

!*        1.  CLEAR-SKY ABSORPTION COEFFICIENTS FOR N SPECTRAL INTERVALS
!             --------------------------------------------------------

!* spectrally independent

ZTDHNIS = 0.450_JPRB
ZTDUNIS = 0.375_JPRB
ZTHNIS  = 296._JPRB
ZTUNIS  = 296._JPRB
ZPDHNIS = 0.90_JPRB
ZPDUNIS = 0.75_JPRB
ZPRHNIS = 100000._JPRB
ZPRUNIS = 100000._JPRB

!     ----------------------------------------------------------------

!*        1.1  COEFFICIENTS FOR TWO SPECTRAL INTERVALS
!              ---------------------------------------


!* DERIVED FROM HITRAN APRIL 1992 with LOWTRAN P AND T SCALING
!       H2O:  Pref=1000hPa, Tref=296K, Pdep=0.9
!       UMG:  Pref=1000hPa, Tref=296K, Pdep=0.75 (CO2+N2O+CO+CH4+O2)
!       O3 :  unchanged in interval 1, from HITRAN 92 in interval 4

ZADJUS2 = _ONE_

!* 1st spectral interval: U.V. and Visible (0.25 - 0.69 Micron)

ZSUN2(1) = 0.459760_JPRB

ZD2(1,:)= (/ 0.000000000_JPRB, 0.000000000_JPRB, 0.000000000_JPRB /)

ZAPAD2(1, 1, :) = (/&
 &0.184678379E+06_JPRB,&
 &0.553080884E+05_JPRB,&
 &0.248143712E+04_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZAPAD2(1, 2, :) = (/&
 &0.715303869E+01_JPRB,&
 &0.219386847E+03_JPRB,&
 &0.830001089E+03_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZAPAD2(1, 3, :) = (/&
 &0.925887084E-04_JPRB,&
 &0.129353723E-01_JPRB,&
 &0.800821928E+00_JPRB,&
 &0.242715973E+02_JPRB,&
 &0.878331486E+02_JPRB,&
 &0.191559725E+02_JPRB,&
 &0.000000000E+00_JPRB/)

ZBPAD2(1, 1, :) = (/&
 &0.184678379E+06_JPRB,&
 &0.555188347E+05_JPRB,&
 &0.253257443E+04_JPRB,&
 &0.100000000E+01_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZBPAD2(1, 2, :) = (/&
 &0.715303869E+01_JPRB,&
 &0.219441875E+03_JPRB,&
 &0.831119997E+03_JPRB,&
 &0.100000000E+01_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZBPAD2(1, 3, :) = (/&
 &0.925887084E-04_JPRB,&
 &0.131812683E-01_JPRB,&
 &0.812706117E+00_JPRB,&
 &0.249863591E+02_JPRB,&
 &0.931071925E+02_JPRB,&
 &0.252233437E+02_JPRB,&
 &0.100000000E+01_JPRB/)

ZRAY2(1,:)= (/&
 &.428937E-01_JPRB, .890743E+00_JPRB,-.288555E+01_JPRB,&
 &.522744E+01_JPRB,-.469173E+01_JPRB, .161645E+01_JPRB/)

ZSWCE2(1) = _ZERO_
ZSWCP2(1) = _ZERO_

!     ----------------------------------------------------------------

!* Near-Infrared (0.69 - 4.0 Microns) is not sub-divided

!     ----------------------------------------------------------------

!* 0.68 - 4.00 Micron

ZSUN2(2) = 0.540240_JPRB

ZD2(2,:)= (/ 0.000000000_JPRB, 0.000000000_JPRB, 0.000000000_JPRB/)

ZAPAD2(2, 1, :) = (/&
 &0.577160808E-06_JPRB,&
 &0.681760991E-02_JPRB,&
 &0.502416370E+01_JPRB,&
 &0.209771270E+03_JPRB,&
 &0.644493139E+03_JPRB,&
 &0.120654163E+03_JPRB,&
 &0.000000000E+00_JPRB/)
ZAPAD2(2, 2, :) = (/&
 &0.422874202E-09_JPRB,&
 &0.257499477E-05_JPRB,&
 &0.349570458E-02_JPRB,&
 &0.917758876E+00_JPRB,&
 &0.327669989E+02_JPRB,&
 &0.874155115E+02_JPRB,&
 &0.000000000E+00_JPRB/)
ZAPAD2(2, 3, :) = (/&
 &0.932012720E+02_JPRB,&
 &0.437866983E+03_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E+00_JPRB/)

ZBPAD2(2, 1, :) = (/&
 &0.577160808E-06_JPRB,&
 &0.682595589E-02_JPRB,&
 &0.508797283E+01_JPRB,&
 &0.223901000E+03_JPRB,&
 &0.770640908E+03_JPRB,&
 &0.186812480E+03_JPRB,&
 &0.100000000E+01_JPRB/)
ZBPAD2(2, 2, :) = (/&
 &0.422874202E-09_JPRB,&
 &0.257567242E-05_JPRB,&
 &0.349912408E-02_JPRB,&
 &0.920770481E+00_JPRB,&
 &0.330990960E+02_JPRB,&
 &0.903249595E+02_JPRB,&
 &0.100000000E+01_JPRB/)
ZBPAD2(2, 3, :) = (/&
 &0.932012720E+02_JPRB,&
 &0.439078599E+03_JPRB,&
 &0.100000000E+01_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)

ZRAY2(2,:)= (/&
 &.697200E-02_JPRB, .173297E-01_JPRB,-.850903E-01_JPRB,&
 &.248261E+00_JPRB,-.302031E+00_JPRB, .129662E+00_JPRB/)

ZSWCE2(2) = _ZERO_
ZSWCP2(2) = _ZERO_

!=====================================================================

!*        1.2  COEFFICIENTS FOR FOUR SPECTRAL INTERVALS
!              ----------------------------------------


!* DERIVED FROM HITRAN APRIL 1992 with LOWTRAN P AND T SCALING
!       H2O:  Pref=1000hPa, Tref=296K, Pdep=0.9
!       UMG:  Pref=1000hPa, Tref=296K, Pdep=0.75 (CO2+N2O+CO+CH4+O2)
!       O3 :  unchanged in interval 1, from HITRAN 92 in interval 4

ZADJUS4 = _ONE_

!* 1st spectral interval: U.V. and Visible (0.25 - 0.69 Micron)

ZSUN4(1) = 0.459760_JPRB

ZD4(1,:)= (/ 0.000000000_JPRB, 0.000000000_JPRB, 0.000000000_JPRB /)

ZAPAD4(1, 1, :) = (/&
 &0.184678379E+06_JPRB,&
 &0.553080884E+05_JPRB,&
 &0.248143712E+04_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZAPAD4(1, 2, :) = (/&
 &0.715303869E+01_JPRB,&
 &0.219386847E+03_JPRB,&
 &0.830001089E+03_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZAPAD4(1, 3, :) = (/&
 &0.925887084E-04_JPRB,&
 &0.129353723E-01_JPRB,&
 &0.800821928E+00_JPRB,&
 &0.242715973E+02_JPRB,&
 &0.878331486E+02_JPRB,&
 &0.191559725E+02_JPRB,&
 &0.000000000E+00_JPRB/)

ZBPAD4(1, 1, :) = (/&
 &0.184678379E+06_JPRB,&
 &0.555188347E+05_JPRB,&
 &0.253257443E+04_JPRB,&
 &0.100000000E+01_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZBPAD4(1, 2, :) = (/&
 &0.715303869E+01_JPRB,&
 &0.219441875E+03_JPRB,&
 &0.831119997E+03_JPRB,&
 &0.100000000E+01_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZBPAD4(1, 3, :) = (/&
 &0.925887084E-04_JPRB,&
 &0.131812683E-01_JPRB,&
 &0.812706117E+00_JPRB,&
 &0.249863591E+02_JPRB,&
 &0.931071925E+02_JPRB,&
 &0.252233437E+02_JPRB,&
 &0.100000000E+01_JPRB/)

ZRAY4(1,:)= (/&
 &.428937E-01_JPRB, .890743E+00_JPRB,-.288555E+01_JPRB,&
 &.522744E+01_JPRB,-.469173E+01_JPRB, .161645E+01_JPRB/)

ZSWCE4(1) = _ZERO_
ZSWCP4(1) = _ZERO_

!     ----------------------------------------------------------------

!* Near-Infrared (0.69 - 4.0 Microns) is sub-divided into:

!     ----------------------------------------------------------------

!* 0.69 - 1.19 Micron

ZSUN4(2) = 0.326158_JPRB

ZD4(2,:)= (/ 0.000000000_JPRB, 0.000000000_JPRB, 1.000000000_JPRB /)

ZAPAD4(2, 1, :) = (/&
 &0.690730834E-02_JPRB,&
 &0.151704275E+01_JPRB,&
 &0.751477543E+02_JPRB,&
 &0.759770236E+03_JPRB,&
 &0.109800326E+04_JPRB,&
 &0.148407574E+03_JPRB,&
 &0.000000000E+00_JPRB/)
ZAPAD4(2, 2, :) = (/&
 &0.863790752E-03_JPRB,&
 &0.448762291E+00_JPRB,&
 &0.332530367E+02_JPRB,&
 &0.190914146E+03_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)
ZAPAD4(2, 3, :) = (/&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)

ZBPAD4(2, 1, :) = (/&
 &0.690730834E-02_JPRB,&
 &0.151954406E+01_JPRB,&
 &0.756512527E+02_JPRB,&
 &0.779384997E+03_JPRB,&
 &0.121113108E+04_JPRB,&
 &0.207678436E+03_JPRB,&
 &0.100000000E+01_JPRB/)
ZBPAD4(2, 2, :) = (/&
 &0.863790752E-03_JPRB,&
 &0.448948107E+00_JPRB,&
 &0.333186750E+02_JPRB,&
 &0.192727216E+03_JPRB,&
 &0.100000000E+01_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)
ZBPAD4(2, 3, :) = (/&
 &1.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)
 
DATA (ZRAY4(2,K),K=1,6) /&
 &.164261E-01_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 &.000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/

ZSWCE4(2) = _ZERO_
ZSWCP4(2) = _ZERO_

!     ----------------------------------------------------------------

!* 1.19 - 2.38 Microns

ZSUN4(3) = 0.180608_JPRB

ZD4(3,:)= (/ 0.000000000_JPRB, 0.000000000_JPRB, 1.000000000_JPRB /)

ZAPAD4(3, 1, :) = (/&
 &0.837531303E-05_JPRB,&
 &0.173886341E-01_JPRB,&
 &0.518852799E+01_JPRB,&
 &0.159078416E+03_JPRB,&
 &0.493273523E+03_JPRB,&
 &0.102567293E+03_JPRB,&
 &0.000000000E+00_JPRB/)
ZAPAD4(3, 2, :) = (/&
 &0.657978575E-02_JPRB,&
 &0.752617872E+00_JPRB,&
 &0.158209734E+02_JPRB,&
 &0.410274915E+02_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)
ZAPAD4(3, 3, :) = (/&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)

ZBPAD4(3, 1, :) = (/&
 &0.837531303E-05_JPRB,&
 &0.174882536E-01_JPRB,&
 &0.534536580E+01_JPRB,&
 &0.180351767E+03_JPRB,&
 &0.673126838E+03_JPRB,&
 &0.182718543E+03_JPRB,&
 &0.100000000E+01_JPRB/)
ZBPAD4(3, 2, :) = (/&
 &0.657978575E-02_JPRB,&
 &0.753752065E+00_JPRB,&
 &0.159286262E+02_JPRB,&
 &0.424278450E+02_JPRB,&
 &0.100000000E+01_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)
ZBPAD4(3, 3, :) = (/&
 &1.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)

ZRAY4(3,:)= (/&
 &.180438E-02_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 &.000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)

ZSWCE4(3) = _ZERO_
ZSWCP4(3) = _ZERO_

!     ----------------------------------------------------------------

!* 2.38 - 4.00 Microns

ZSUN4(4) = 0.033474_JPRB

ZD4(4,:)= (/ 0.000000000_JPRB, 0.000000000_JPRB, 0.000000000_JPRB /)

ZAPAD4(4, 1, :) = (/&
 &0.122118185E-06_JPRB,&
 &0.154042531E-02_JPRB,&
 &0.141152193E+01_JPRB,&
 &0.685368761E+02_JPRB,&
 &0.216522281E+03_JPRB,&
 &0.421228746E+02_JPRB,&
 &0.000000000E+00_JPRB/)
ZAPAD4(4, 2, :) = (/&
 &0.364233560E-10_JPRB,&
 &0.217340835E-06_JPRB,&
 &0.292623386E-03_JPRB,&
 &0.797100631E-01_JPRB,&
 &0.319103672E+01_JPRB,&
 &0.110530283E+02_JPRB,&
 &0.000000000E+00_JPRB/)
ZAPAD4(4, 3, :) = (/&
 &0.263068898E+02_JPRB,&
 &0.146425875E+03_JPRB,&
 &0.860137809E+02_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)

ZBPAD4(4, 1, :) = (/&
 &0.122118185E-06_JPRB,&
 &0.156287582E-02_JPRB,&
 &0.156994562E+01_JPRB,&
 &0.102304103E+03_JPRB,&
 &0.475479878E+03_JPRB,&
 &0.188714799E+03_JPRB,&
 &0.100000000E+01_JPRB/)
ZBPAD4(4, 2, :) = (/&
 &0.364233560E-10_JPRB,&
 &0.218265806E-06_JPRB,&
 &0.297085917E-03_JPRB,&
 &0.834253403E-01_JPRB,&
 &0.358290002E+01_JPRB,&
 &0.139206164E+02_JPRB,&
 &0.100000000E+01_JPRB/)
ZBPAD4(4, 3, :) = (/&
 &0.263068898E+02_JPRB,&
 &0.152569217E+03_JPRB,&
 &0.976791971E+02_JPRB,&
 &0.100000000E+01_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)

ZRAY4(4,:)= (/&
 &.136020E-03_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 &.000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)

ZSWCE4(4) = _ZERO_
ZSWCP4(4) = _ZERO_

!=====================================================================

!*        1.3  COEFFICIENTS FOR SIX SPECTRAL INTERVALS
!              ---------------------------------------


!* DERIVED FROM HITRAN APRIL 1992 with LOWTRAN P AND T SCALING
!       H2O:  Pref=1000hPa, Tref=296K, Pdep=0.9
!       UMG:  Pref=1000hPa, Tref=296K, Pdep=0.75 (CO2+N2O+CO+CH4+O2)
!       O3 :  unchanged in interval 1, from HITRAN 92 in interval 4

ZADJUS6 = 0.9905709_JPRB

!* 1st spectral interval: U.V.  (0.18 - 0.25 Micron)

ZSUN6(1) = 0.0019124_JPRB

ZD6(1,:)= (/ 1.000000000_JPRB, 1.000000000_JPRB, 0.000000000_JPRB /)

ZAPAD6(1, 1, :) = (/&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZAPAD6(1, 2, :) = (/&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZAPAD6(1, 3, :) = (/&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
 
ZBPAD6(1, 1, :) = (/&
 &0.100000000E+01_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZBPAD6(1, 2, :) = (/&
 &0.100000000E+01_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZBPAD6(1, 3, :) = (/&
 &0.100000000E+01_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
 
ZRAY6(1,:)= (/&
 &.43959002E+01_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 &.000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)

ZSWCE6(1) = _ZERO_
ZSWCP6(1) = _ZERO_

NEXPO3(1) = 6
REXPO3(1, 1, :) =(/&
  &0.000334E+00_JPRB, 0.011131E+00_JPRB, 0.000064E+00_JPRB,&
  &0.218900E+00_JPRB, 0.134118E+00_JPRB, 0.635453E+00_JPRB,&
  &0.000000E+00_JPRB /)
REXPO3(1, 2, :) =(/&
  &0.467737E+03_JPRB, 0.389056E+02_JPRB, 0.223872E+04_JPRB,&
  &0.102346E+02_JPRB, 0.794561E+01_JPRB, 0.138054E+02_JPRB,&
  &0.000000E+00_JPRB /)
  


!* 2nd spectral interval: U.V.  (0.25 - 0.44 Micron)

ZSUN6(2) = 0.1353560_JPRB

ZD6(2,:)= (/ 1.000000000_JPRB, 1.000000000_JPRB, 0.000000000_JPRB /)

ZAPAD6(2, 1, :) = (/&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZAPAD6(2, 2, :) = (/&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZAPAD6(2, 3, :) = (/&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
 
ZBPAD6(2, 1, :) = (/&
 &0.100000000E+01_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZBPAD6(2, 2, :) = (/&
 &0.100000000E+01_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
ZBPAD6(2, 3, :) = (/&
 &0.100000000E+01_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
 
ZRAY6(2,:)= (/&
 &.55503070E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 &.000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)

ZSWCE6(2) = _ZERO_
ZSWCP6(2) = _ZERO_

NEXPO3(2) = 7
REXPO3(2, 1, :) =(/&
  &0.043801E+00_JPRB, 0.078893E+00_JPRB, 0.036839E+00_JPRB,&
  &0.022503E+00_JPRB, 0.042333E+00_JPRB, 0.037870E+00_JPRB,&
  &0.737762E+00_JPRB /)
REXPO3(2, 2, :) =(/&
  &0.234249E+01_JPRB, 0.125170E+00_JPRB, 0.549527E+02_JPRB,&
  &0.257041E+03_JPRB, 0.476838E+00_JPRB, 0.911993E+01_JPRB,&
  &0.000000E+00_JPRB /)


!* 3rd spectral interval: Visible  (0.44 - 0.69 Micron)

ZSUN6(3) = 0.3213000_JPRB

ZD6(3,:)= (/ 0.800000000_JPRB, 1.000000000_JPRB, 0.000000000_JPRB /)

ZAPAD6(3, 1, :) = (/&
 &0.3682644E+02_JPRB,&
 &0.6491415E+03_JPRB,&
 &0.8720916E+02_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB/)
ZAPAD6(3, 2, :) = (/&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB/)
ZAPAD6(3, 3, :) = (/&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
 
ZBPAD6(3, 1, :) = (/&
 &0.3682644E+02_JPRB,&
 &0.6495968E+03_JPRB,&
 &0.9637657E+02_JPRB,&
 &0.1000000E+01_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB/)
ZBPAD6(3, 2, :) = (/&
 &0.1000000E+01_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB,&
 &0.0000000E-00_JPRB/)
ZBPAD6(3, 3, :) = (/&
 &0.100000000E+01_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
 
ZRAY6(3,:)= (/&
 &.10528199E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 &.000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)

ZSWCE6(3) = _ZERO_
ZSWCP6(3) = _ZERO_

NEXPO3(3) = 6
REXPO3(3, 1, :) =(/&
  &0.063442E+00_JPRB, 0.058550E+00_JPRB, 0.237534E+00_JPRB,&
  &0.412292E+00_JPRB, 0.126141E+00_JPRB, 0.102041E+00_JPRB,&
  &0.000000E+00_JPRB /)
REXPO3(3, 2, :) =(/&
  &0.125170E+00_JPRB, 0.119209E-01_JPRB, 0.119209E+00_JPRB,&
  &0.417233E-01_JPRB, 0.894070E-01_JPRB, 0.000000E+00_JPRB,&
  &0.000000E+00_JPRB /)

!     ----------------------------------------------------------------

!* Near-Infrared (0.69 - 4.0 Microns) is sub-divided into:

!     ----------------------------------------------------------------

!* 0.69 - 1.19 Micron

!* UMG is O2 only

ZSUN6(4) = 0.3211833_JPRB

ZD6(4,:)= (/ 0.000000000_JPRB, 0.800000000_JPRB, 1.000000000_JPRB /)

ZAPAD6(4, 1, :) = (/&
 &0.9969941E+02_JPRB,&
 &0.7496307E+04_JPRB,&
 &0.7003009E+05_JPRB,&
 &0.9381446E+05_JPRB,&
 &0.1827735E+05_JPRB,&
 &0.3459400E+03_JPRB,&
 &0.0000000E+00_JPRB/)
ZAPAD6(4, 2, :) = (/&
 &0.1567941E+10_JPRB,&
 &0.3094160E+09_JPRB,&
 &0.3650192E+07_JPRB,&
 &0.5026130E+04_JPRB,&
 &0.0000000E+00_JPRB,&
 &0.0000000E+00_JPRB,&
 &0.0000000E+00_JPRB/)
ZAPAD6(4, 3, :) = (/&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)

ZBPAD6(4, 1, :) = (/&
 &0.9969941E+02_JPRB,&
 &0.7517916E+04_JPRB,&
 &0.7149485E+05_JPRB,&
 &0.1020564E+06_JPRB,&
 &0.2337706E+05_JPRB,&
 &0.6874490E+03_JPRB,&
 &0.1000000E+01_JPRB/)
ZBPAD6(4, 2, :) = (/&
 &0.1567941E+10_JPRB,&
 &0.3332380E+09_JPRB,&
 &0.4940093E+07_JPRB,&
 &0.1026382E+05_JPRB,&
 &0.1000000E+01_JPRB,&
 &0.0000000E+00_JPRB,&
 &0.0000000E+00_JPRB/)
ZBPAD6(4, 3, :) = (/&
 &1.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)
 
DATA (ZRAY6(4,K),K=1,6) /&
 &.16436996E-01_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 &.000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/

ZSWCE6(4) = _ZERO_
ZSWCP6(4) = _ZERO_

NEXPO3(4) = 4
REXPO3(4, 1, :) =(/&
  &0.000074E+00_JPRB, 0.320194E+00_JPRB, 0.082915E+00_JPRB,&
  &0.596816E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
  &0.000000E+00_JPRB /)
REXPO3(4, 2, :) =(/&
  &0.232458E+00_JPRB, 0.119209E-01_JPRB, 0.178814E-01_JPRB,&
  &0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
  &0.000000E+00_JPRB /)


!     ----------------------------------------------------------------

!* 1.19 - 2.38 Microns

!* UMG is CO2 only

ZSUN6(5) = 0.1778533_JPRB

ZD6(5,:)= (/ 0.000000000_JPRB, 0.800000000_JPRB, 1.000000000_JPRB /)

ZAPAD6(5, 1, :) = (/&
 &0.3325841E-03_JPRB,&
 &0.6194496E+00_JPRB,&
 &0.1497138E+03_JPRB,&
 &0.2314864E+04_JPRB,&
 &0.2380109E+04_JPRB,&
 &0.9553823E+02_JPRB,&
 &0.0000000E+00_JPRB/)
ZAPAD6(5, 2, :) = (/&
 &0.2419549E-02_JPRB,&
 &0.1504652E+01_JPRB,&
 &0.1339335E+02_JPRB,&
 &0.8932533E+01_JPRB,&
 &0.0000000E+00_JPRB,&
 &0.0000000E+00_JPRB,&
 &0.0000000E+00_JPRB/)
ZAPAD6(5, 3, :) = (/&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)

ZBPAD6(5, 1, :) = (/&
 &0.3325841E-03_JPRB,&
 &0.6231947E+00_JPRB,&
 &0.1553098E+03_JPRB,&
 &0.2822458E+04_JPRB,&
 &0.3885194E+04_JPRB,&
 &0.2700235E+03_JPRB,&
 &0.1000000E+01_JPRB/)
ZBPAD6(5, 2, :) = (/&
 &0.2419549E-02_JPRB,&
 &0.1507850E+01_JPRB,&
 &0.1489144E+03_JPRB,&
 &0.1425322E+02_JPRB,&
 &0.1000000E+01_JPRB,&
 &0.0000000E+00_JPRB,&
 &0.0000000E+00_JPRB/)
ZBPAD6(5, 3, :) = (/&
 &1.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)

ZRAY6(5,:)= (/&
 &.18073079E-02_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 &.000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)

ZSWCE6(5) = _ZERO_
ZSWCP6(5) = _ZERO_

NEXPO3(5) = 0
REXPO3(5, 1, :) =(/&
  &0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
  &0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
  &0.000000E+00_JPRB /)
REXPO3(5, 2, :) =(/&
  &0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
  &0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
  &0.000000E+00_JPRB /)

!     ----------------------------------------------------------------

!* 2.38 - 4.00 Microns

ZSUN6(6) = 0.0329659_JPRB

ZD6(6,:)= (/ 0.000000000_JPRB, 0.600000000_JPRB, 0.000000000_JPRB /)

ZAPAD6(6, 1, :) = (/&
 &0.2122889E-06_JPRB,&
 &0.9030576E-03_JPRB,&
 &0.2431282E+00_JPRB,&
 &0.4901345E+01_JPRB,&
 &0.3996347E+01_JPRB,&
 &0.3910227E+01_JPRB,&
 &0.0000000E+00_JPRB/)
ZAPAD6(6, 2, :) = (/&
 &0.2051629E-02_JPRB,&
 &0.8053325E+00_JPRB,&
 &0.1826847E+02_JPRB,&
 &0.1991453E+02_JPRB,&
 &0.0000000E+00_JPRB,&
 &0.0000000E+00_JPRB,&
 &0.0000000E+00_JPRB/)
ZAPAD6(6, 3, :) = (/&
 &0.263068898E+02_JPRB,&
 &0.146425875E+03_JPRB,&
 &0.860137809E+02_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)

ZBPAD6(6, 1, :) = (/&
 &0.2122889E-06_JPRB,&
 &0.9379083E-03_JPRB,&
 &0.2957335E+00_JPRB,&
 &0.8747190E+01_JPRB,&
 &0.1015794E+02_JPRB,&
 &0.1361277E+02_JPRB,&
 &0.1000000E+01_JPRB/)
ZBPAD6(6, 2, :) = (/&
 &0.2051629E-02_JPRB,&
 &0.9455932E+00_JPRB,&
 &0.3030076E+02_JPRB,&
 &0.4307387E+02_JPRB,&
 &0.1000000E+01_JPRB,&
 &0.0000000E+00_JPRB,&
 &0.0000000E+00_JPRB/)
ZBPAD6(6, 3, :) = (/&
 &0.263068898E+02_JPRB,&
 &0.152569217E+03_JPRB,&
 &0.976791971E+02_JPRB,&
 &0.100000000E+01_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)

ZRAY6(6,:)= (/&
 &.13618247E-03_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 &.000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)

ZSWCE6(6) = _ZERO_
ZSWCP6(6) = _ZERO_

NEXPO3(6) = 0
REXPO3(6, 1, :) =(/&
  &0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
  &0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
  &0.000000E+00_JPRB /)
REXPO3(6, 2, :) =(/&
  &0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
  &0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
  &0.000000E+00_JPRB /)

!=====================================================================
!     ----------------------------------------------------------------

!*    2.3   WEIGHTS FOR SPECTRAL SURFACE ALBEDO
!           Water
!           Sea-Ice (Ebert, Curry, 1993)
!           Wet skin
!           Low vegetation (snow free) (BR, 1982)
!           Snow on low vegetation (Warren, 1982)
!           High vegetation (snow free) (BR, 1982)
!           Snow under high vegetation  (Warren, 1982)
!           Bare soil (Briegleb & Ramanathan, 1982)

NTYPS = 8
ZWEIGHT2(:,1)= (/ 1._JPRB, 1._JPRB /)
ZWEIGHT2(:,2)= (/ 1._JPRB, 1._JPRB /)
ZWEIGHT2(:,3)= (/ 1._JPRB, 1._JPRB /)
ZWEIGHT2(:,4)= (/ 1._JPRB, 3._JPRB /)
ZWEIGHT2(:,5)= (/ 0.920_JPRB, 0.537_JPRB /)
ZWEIGHT2(:,6)= (/ 1._JPRB, 3._JPRB /)
ZWEIGHT2(:,7)= (/ 0.860_JPRB, 0.432_JPRB /)
ZWEIGHT2(:,8)= (/ 1._JPRB, 2._JPRB /)

ZWEIGHT4(:,1)= (/ 1._JPRB, 1._JPRB, 1._JPRB, 1._JPRB /)
ZWEIGHT4(:,2)= (/ 1._JPRB, 1._JPRB, 1._JPRB, 1._JPRB /)
ZWEIGHT4(:,3)= (/ 1._JPRB, 1._JPRB, 1._JPRB, 1._JPRB /)
ZWEIGHT4(:,4)= (/ 1._JPRB, 4._JPRB, 2._JPRB, 1._JPRB /)
ZWEIGHT4(:,5)= (/ 0.920_JPRB, 0.798_JPRB , 0.159_JPRB, 0.010_JPRB /)
ZWEIGHT4(:,6)= (/ 1._JPRB, 4._JPRB, 2._JPRB, 1._JPRB /)
ZWEIGHT4(:,7)= (/ 0.860_JPRB, 0.664_JPRB , 0.092_JPRB, 0.010_JPRB /)
ZWEIGHT4(:,8)= (/ 1._JPRB, 2._JPRB, 2._JPRB, 1._JPRB /)

ZWEIGHT6(:,1)= (/ 1._JPRB, 1._JPRB, 1._JPRB, 1._JPRB, 1._JPRB, 1._JPRB /)
ZWEIGHT6(:,2)= (/ 1._JPRB, 1._JPRB, 1._JPRB, 1._JPRB, 1._JPRB, 1._JPRB /)
ZWEIGHT6(:,3)= (/ 1._JPRB, 1._JPRB, 1._JPRB, 1._JPRB, 1._JPRB, 1._JPRB /)
ZWEIGHT6(:,4)= (/ 1._JPRB, 1._JPRB, 1._JPRB, 4._JPRB, 2._JPRB, 1._JPRB /)
ZWEIGHT6(:,5)= (/ 0.920_JPRB, 0.920_JPRB, 0.920_JPRB, 0.798_JPRB , 0.159_JPRB, 0.010_JPRB /)
ZWEIGHT6(:,6)= (/ 1._JPRB, 1._JPRB, 1._JPRB, 4._JPRB, 2._JPRB, 1._JPRB /)
ZWEIGHT6(:,7)= (/ 0.860_JPRB, 0.860_JPRB, 0.860_JPRB, 0.664_JPRB , 0.092_JPRB, 0.010_JPRB /)
ZWEIGHT6(:,8)= (/ 1._JPRB, 1._JPRB, 1._JPRB, 2._JPRB, 2._JPRB, 1._JPRB /)

!*  For sea ice, monthly values are based on Ebert and Curry, 1993, Table 2.
!   We take dry snow albedo as the representative value for non-summer
!   months, and bare sea-ice as the representative value for summer
!   months. The values for Antarctic are shifted six-months.

!- 2-spectral intervals

!*  Sea ice surf. albedo for 0.25-0.69 micron (snow covered; Ebert and Curry, 1993)
ZALBICE2(1:12,1) = (/0.975_JPRB,0.975_JPRB,0.975_JPRB,0.975_JPRB,&
                   &0.975_JPRB,0.876_JPRB,0.778_JPRB,0.778_JPRB,&
                   &0.975_JPRB,0.975_JPRB,0.975_JPRB,0.975_JPRB/)
!*  Sea ice surf. albedo for 0.69-4.00 microns (snow covered; Ebert and Curry, 1993)
!ZALBICE2(1:12,2) = (/0.664_JPRB,0.664_JPRB,0.664_JPRB,0.664_JPRB,&
!                    &0.664_JPRB,0.476_JPRB,0.288_JPRB,0.288_JPRB,&
!                    &0.664_JPRB,0.664_JPRB,0.664_JPRB,0.664_JPRB/)
ZALBICE2(1:12,2) = (/0.587_JPRB,0.587_JPRB,0.587_JPRB,0.587_JPRB,&
                    &0.587_JPRB,0.438_JPRB,0.288_JPRB,0.288_JPRB,&
                    &0.587_JPRB,0.587_JPRB,0.587_JPRB,0.587_JPRB/)
                      
!- 4-spectral intervals

!*  Sea ice surf. albedo for 0.25-0.69 micron (snow covered; Ebert and Curry, 1993)
ZALBICE4(1:12,1) = (/0.975_JPRB,0.975_JPRB,0.975_JPRB,0.975_JPRB,&
                    &0.975_JPRB,0.876_JPRB,0.778_JPRB,0.778_JPRB,&
                    &0.975_JPRB,0.975_JPRB,0.975_JPRB,0.975_JPRB/)
!*  Sea ice surf. albedo for 0.69-1.19 micron (snow covered; Ebert and Curry, 1993)
ZALBICE4(1:12,2) = (/0.832_JPRB,0.832_JPRB,0.832_JPRB,0.832_JPRB,&
                    &0.832_JPRB,0.638_JPRB,0.443_JPRB,0.443_JPRB,&
                    &0.832_JPRB,0.832_JPRB,0.832_JPRB,0.832_JPRB/)
!*  Sea ice surf. albedo for 1.19-2.38 micron (snow covered; Ebert and Curry, 1993)
ZALBICE4(1:12,3) = (/0.250_JPRB,0.250_JPRB,0.250_JPRB,0.250_JPRB,&
                    &0.250_JPRB,0.153_JPRB,0.055_JPRB,0.055_JPRB,&
                    &0.250_JPRB,0.250_JPRB,0.250_JPRB,0.250_JPRB/)
!*  Sea ice surf. albedo for 2.38-4.00 microns (snow covered; Ebert and Curry, 1993)
ZALBICE4(1:12,4) = (/0.025_JPRB,0.025_JPRB,0.025_JPRB,0.025_JPRB,&
                    &0.025_JPRB,0.030_JPRB,0.036_JPRB,0.036_JPRB,&
                    &0.025_JPRB,0.025_JPRB,0.025_JPRB,0.025_JPRB/)
                      
!- 6-spectral intervals

!*  Sea ice surf. albedo for 0.185-0.25 micron (snow covered; Ebert and Curry, 1993)
ZALBICE6(1:12,1) = (/0.975_JPRB,0.975_JPRB,0.975_JPRB,0.975_JPRB,&
                    &0.975_JPRB,0.876_JPRB,0.778_JPRB,0.778_JPRB,&
                    &0.975_JPRB,0.975_JPRB,0.975_JPRB,0.975_JPRB/)
!*  Sea ice surf. albedo for 0.25-0.44 micron (snow covered; Ebert and Curry, 1993)
ZALBICE6(1:12,2) = (/0.975_JPRB,0.975_JPRB,0.975_JPRB,0.975_JPRB,&
                    &0.975_JPRB,0.876_JPRB,0.778_JPRB,0.778_JPRB,&
                    &0.975_JPRB,0.975_JPRB,0.975_JPRB,0.975_JPRB/)
!*  Sea ice surf. albedo for 0.44-0.69 micron (snow covered; Ebert and Curry, 1993)
ZALBICE6(1:12,3) = (/0.975_JPRB,0.975_JPRB,0.975_JPRB,0.975_JPRB,&
                    &0.975_JPRB,0.876_JPRB,0.778_JPRB,0.778_JPRB,&
                    &0.975_JPRB,0.975_JPRB,0.975_JPRB,0.975_JPRB/)
!*  Sea ice surf. albedo for 0.69-1.19 micron (snow covered; Ebert and Curry, 1993)
ZALBICE6(1:12,4) = (/0.832_JPRB,0.832_JPRB,0.832_JPRB,0.832_JPRB,&
                    &0.832_JPRB,0.638_JPRB,0.443_JPRB,0.443_JPRB,&
                    &0.832_JPRB,0.832_JPRB,0.832_JPRB,0.832_JPRB/)
!*  Sea ice surf. albedo for 1.19-2.38 micron (snow covered; Ebert and Curry, 1993)
ZALBICE6(1:12,5) = (/0.250_JPRB,0.250_JPRB,0.250_JPRB,0.250_JPRB,&
                    &0.250_JPRB,0.153_JPRB,0.055_JPRB,0.055_JPRB,&
                    &0.250_JPRB,0.250_JPRB,0.250_JPRB,0.250_JPRB/)
!*  Sea ice surf. albedo for 2.38-4.00 microns (snow covered; Ebert and Curry, 1993)
ZALBICE6(1:12,6) = (/0.025_JPRB,0.025_JPRB,0.025_JPRB,0.025_JPRB,&
                    &0.025_JPRB,0.030_JPRB,0.036_JPRB,0.036_JPRB,&
                    &0.025_JPRB,0.025_JPRB,0.025_JPRB,0.025_JPRB/)
                                            
!     ----------------------------------------------------------------

!*    2.4   OPTICAL PARAMETERS FOR RAIN DROPS
!           Savijarvi et al. (1996)

ZRTO1 =  0.003_JPRB
ZRTO2 = -0.22_JPRB
! CAUTION JUST TEMPORARY PARAMETERS      
ZROMA2(1:2)= (/ 0.00008_JPRB , 0.264_JPRB  /)
ZROMB2(1:2)= (/ 0.23_JPRB    , 0.09_JPRB   /)
ZRASY2(1:2)= (/ 0.88_JPRB    , 0.94_JPRB   /)

ZRA2(1:2)= (/ 1.5_JPRB     , 1.5_JPRB    /)
ZRB2(1:2)= (/ 0.50_JPRB    , 1.13_JPRB   /)
ZRC2(1:2)= (/ 5.58E-7_JPRB , 8.55E-4_JPRB/)
ZRD2(1:2)= (/ 1.25E-7_JPRB , 1.28E-3_JPRB/)
ZRE2(1:2)= (/ 0.841_JPRB   , 0.786_JPRB  /)
ZRF2(1:2)= (/ 2.08E-3_JPRB , 5.32E-3_JPRB/)

ZROMA4(1:4)= (/ 0.00008_JPRB , 0.0105_JPRB , 0.264_JPRB  , 0.465_JPRB   /)
ZROMB4(1:4)= (/ 0.23_JPRB    , 0.22_JPRB   , 0.09_JPRB   , 0.001_JPRB   /)
ZRASY4(1:4)= (/ 0.88_JPRB    , 0.89_JPRB   , 0.94_JPRB   , 0.97_JPRB    /)

ZRA4(1:4)= (/ 1.5_JPRB     , 1.5_JPRB    , 1.5_JPRB    , 1.5_JPRB     /)
ZRB4(1:4)= (/ 0.50_JPRB    , 0.78_JPRB   , 1.13_JPRB   , 2.00_JPRB    /)
ZRC4(1:4)= (/ 5.58E-7_JPRB , 2.18E-5_JPRB, 8.55E-4_JPRB, 1.94E-1_JPRB /)
ZRD4(1:4)= (/ 1.25E-7_JPRB , 2.25E-5_JPRB, 1.28E-3_JPRB, 8.04E-3_JPRB /)
ZRE4(1:4)= (/ 0.841_JPRB   , 0.821_JPRB  , 0.786_JPRB  , 0.820_JPRB   /)
ZRF4(1:4)= (/ 2.08E-3_JPRB , 3.06E-3_JPRB, 5.32E-3_JPRB, 5.59E-3_JPRB /)

ZROMA6(1:6)= (/ 0.00008_JPRB , 0.00008_JPRB , 0.00008_JPRB , 0.0105_JPRB , 0.264_JPRB  , 0.465_JPRB   /)
ZROMB6(1:6)= (/ 0.23_JPRB    , 0.23_JPRB    , 0.23_JPRB    , 0.22_JPRB   , 0.09_JPRB   , 0.001_JPRB   /)
ZRASY6(1:6)= (/ 0.88_JPRB    , 0.88_JPRB    , 0.88_JPRB    , 0.89_JPRB   , 0.94_JPRB   , 0.97_JPRB    /)

ZRA6(1:6)= (/ 1.5_JPRB     , 1.5_JPRB     , 1.5_JPRB     , 1.5_JPRB    , 1.5_JPRB    , 1.5_JPRB     /)
ZRB6(1:6)= (/ 0.50_JPRB    , 0.50_JPRB    , 0.50_JPRB    , 0.78_JPRB   , 1.13_JPRB   , 2.00_JPRB    /)
ZRC6(1:6)= (/ 5.58E-7_JPRB , 5.58E-7_JPRB , 5.58E-7_JPRB , 2.18E-5_JPRB, 8.55E-4_JPRB, 1.94E-1_JPRB /)
ZRD6(1:6)= (/ 1.25E-7_JPRB , 1.25E-7_JPRB , 1.25E-7_JPRB , 2.25E-5_JPRB, 1.28E-3_JPRB, 8.04E-3_JPRB /)
ZRE6(1:6)= (/ 0.841_JPRB   , 0.841_JPRB   , 0.841_JPRB   , 0.821_JPRB  , 0.786_JPRB  , 0.820_JPRB   /)
ZRF6(1:6)= (/ 2.08E-3_JPRB , 2.08E-3_JPRB , 2.08E-3_JPRB , 3.06E-3_JPRB, 5.32E-3_JPRB, 5.59E-3_JPRB /)


!=====================================================================

!*       2.    SET VALUES.
!              -----------


IF (LONEWSW) THEN
  ZPDH2O = ZPDHNIS
  ZPDUMG = ZPDUNIS
  ZPRH2O = ZPRHNIS
  ZPRUMG = ZPRUNIS
  RTDH2O = ZTDHNIS
  RTDUMG = ZTDUNIS
  RTH2O  = ZTHNIS
  RTUMG  = ZTUNIS
ENDIF

RPDH1=ZPDH2O+_ONE_
RPDU1=ZPDUMG+_ONE_
ZH2O=_ONE_/( 10._JPRB* RG * RPDH1 )
ZUMG=_ONE_/( 10._JPRB* RG * RPDU1 )
RPNU = ZUMG/(ZPRUMG**ZPDUMG)
RPNH = ZH2O/(ZPRH2O**ZPDH2O)

DO JTYPS=1,NTYPS
  ZTWEIGHT(JTYPS)=_ZERO_
END DO
  
DO JW=1,NTSW
  RSUN(JW)=_ZERO_
  RSWCE(JW)=_ZERO_
  RSWCP(JW)=_ZERO_
  
  DO JTYPS=1,NTYPS
    RWEIGHT(JW,JTYPS)=_ZERO_
  END DO
  
  DO JC3=1,3
    D(JW,JC3)=_ZERO_
  ENDDO
  DO JC6=1,6
    RRAY(JW,JC6)=_ZERO_
  ENDDO
  DO JI=1,3
    DO JJ=1,7
      APAD(JW,JI,JJ)=_ZERO_
      BPAD(JW,JI,JJ)=_ZERO_
    ENDDO
  ENDDO
ENDDO

IF (KSW == 2) THEN
  RADJUST=ZADJUS2
  RHSRTA=ZRTO1
  RHSRTB=ZRTO2
  DO JW=1,KSW
    RSUN (JW)=ZSUN2(JW)

    RSWCE(JW)=ZSWCE2(JW)
    RSWCP(JW)=ZSWCP2(JW)

    DO JTYPS=1,NTYPS
      ZTWEIGHT(JTYPS)=ZTWEIGHT(JTYPS)+ZWEIGHT2(JW,JTYPS)*ZSUN2(JW)
    END DO

    RROMA(JW)=ZROMA2(JW)
    RROMB(JW)=ZROMB2(JW)
    RRASY(JW)=ZRASY2(JW)
    RHSRA(JW)=ZRA2(JW)
    RHSRB(JW)=ZRB2(JW)
    RHSRC(JW)=ZRC2(JW)
    RHSRD(JW)=ZRD2(JW)
    RHSRE(JW)=ZRE2(JW)
    RHSRF(JW)=ZRF2(JW)

    DO JC3=1,3
      D(JW,JC3)=ZD2(JW,JC3)
    ENDDO
    DO JC6=1,6
      RRAY(JW,JC6)=ZRAY2(JW,JC6)
    ENDDO
    DO JI=1,3
      DO JJ=1,7
        APAD(JW,JI,JJ)=ZAPAD2(JW,JI,JJ)
        BPAD(JW,JI,JJ)=ZBPAD2(JW,JI,JJ)
      ENDDO
    ENDDO
  ENDDO
  
  DO JW=1,KSW
    DO JTYPS=1,NTYPS
      RWEIGHT(JW,JTYPS)=ZWEIGHT2(JW,JTYPS)/ZTWEIGHT(JTYPS)
    END DO
  
    DO JM=1,12
      IM=MOD(JM+5,12)+1
      RALBICE_AR(IM,JW)=ZALBICE2(IM,JW)
      RALBICE_AN(JM,JW)=RALBICE_AR(IM,JW)
    END DO  
  END DO    

ELSEIF (KSW == 4) THEN
  RADJUST=ZADJUS4
  RHSRTA=ZRTO1
  RHSRTB=ZRTO2
  DO JW=1,KSW
    RSUN (JW)=ZSUN4(JW)

    RSWCE(JW)=ZSWCE4(JW)
    RSWCP(JW)=ZSWCP4(JW)

    DO JTYPS=1,NTYPS
      ZTWEIGHT(JTYPS)=ZTWEIGHT(JTYPS)+ZWEIGHT4(JW,JTYPS)*ZSUN4(JW)
    END DO

    RROMA(JW)=ZROMA4(JW)
    RROMB(JW)=ZROMB4(JW)
    RRASY(JW)=ZRASY4(JW)
    RHSRA(JW)=ZRA4(JW)
    RHSRB(JW)=ZRB4(JW)
    RHSRC(JW)=ZRC4(JW)
    RHSRD(JW)=ZRD4(JW)
    RHSRE(JW)=ZRE4(JW)
    RHSRF(JW)=ZRF4(JW)

    DO JC3=1,3
      D(JW,JC3)=ZD4(JW,JC3)
    ENDDO
    DO JC6=1,6
      RRAY(JW,JC6)=ZRAY4(JW,JC6)
    ENDDO
    DO JI=1,3
      DO JJ=1,7
        APAD(JW,JI,JJ)=ZAPAD4(JW,JI,JJ)
        BPAD(JW,JI,JJ)=ZBPAD4(JW,JI,JJ)
      ENDDO
    ENDDO
  ENDDO
  
  DO JW=1,KSW
    DO JTYPS=1,NTYPS
      RWEIGHT(JW,JTYPS)=ZWEIGHT4(JW,JTYPS)/ZTWEIGHT(JTYPS)
    END DO
    
    DO JM=1,12
      IM=MOD(JM+5,12)+1
      RALBICE_AR(IM,JW)=ZALBICE4(IM,JW)
      RALBICE_AN(JM,JW)=RALBICE_AR(IM,JW)
    END DO  
  END DO    
  
ELSEIF (KSW == 6) THEN
  RADJUST=ZADJUS6
  RHSRTA=ZRTO1
  RHSRTB=ZRTO2
  DO JW=1,KSW
    RSUN (JW)=ZSUN6(JW)

    RSWCE(JW)=ZSWCE6(JW)
    RSWCP(JW)=ZSWCP6(JW)

    DO JTYPS=1,NTYPS
      ZTWEIGHT(JTYPS)=ZTWEIGHT(JTYPS)+ZWEIGHT6(JW,JTYPS)*ZSUN6(JW)
    END DO

    RROMA(JW)=ZROMA6(JW)
    RROMB(JW)=ZROMB6(JW)
    RRASY(JW)=ZRASY6(JW)
    RHSRA(JW)=ZRA6(JW)
    RHSRB(JW)=ZRB6(JW)
    RHSRC(JW)=ZRC6(JW)
    RHSRD(JW)=ZRD6(JW)
    RHSRE(JW)=ZRE6(JW)
    RHSRF(JW)=ZRF6(JW)

    DO JC3=1,3
      D(JW,JC3)=ZD6(JW,JC3)
    ENDDO
    DO JC6=1,6
      RRAY(JW,JC6)=ZRAY6(JW,JC6)
    ENDDO
    DO JI=1,3
      DO JJ=1,7
        APAD(JW,JI,JJ)=ZAPAD6(JW,JI,JJ)
        BPAD(JW,JI,JJ)=ZBPAD6(JW,JI,JJ)
      ENDDO
    ENDDO
  ENDDO
  
  DO JW=1,KSW
    DO JTYPS=1,NTYPS
      RWEIGHT(JW,JTYPS)=ZWEIGHT6(JW,JTYPS)/ZTWEIGHT(JTYPS)
    END DO
    
    DO JM=1,12
      IM=MOD(JM+5,12)+1
      RALBICE_AR(IM,JW)=ZALBICE6(IM,JW)
      RALBICE_AN(JM,JW)=RALBICE_AR(IM,JW)
    END DO  
  END DO    
  
ELSE
!  CALL ABOR1('SUSWN: WRONG NUMBER OF SW INTERVALS')
  STOP 'SUSWN: WRONG NUMBER OF SW INTERVALS'
ENDIF

!     ----------------------------------------------------------------

!*       7.    PRINT VALUES.
!              ------------


!     PRINT 9700,RPDH1,RPDU1,RPNU,RPNH
!9700 FORMAT(1X,'RPDH1,RPDU1,RPNU,RPNH ',4F10.5)      
!     DO JW=1,KSW      
!       PRINT *,' SW INTERVAL ',JW
!       PRINT 9701,JW,RSUN(JW),RSWCE(JW),RSWCP(JW)
!9701   FORMAT(1X,I3,F10.7,2F10.5)
!       PRINT 9702,JW,(D(JW,JC3),JC3=1,3)
!9702   FORMAT(1X,I3,3F10.5)
!       PRINT 9703,JW,(RRAY(JW,JC6),JC6=1,6)
!9703   FORMAT(1X,I3,6E15.8)
!       PRINT 9704,JW,(JABS,(APAD(JW,JABS,JJ),JJ=1,7),JABS=1,3)
!9704   FORMAT(1X,I3,(I3,7E15.8))
!       PRINT 9706,JW,RROMA(JW),RROMB(JW),RRASY(JW),RHSRTA,RHSRTB
!9706   FORMAT(1X,I3,' Rain Optics from Rain Rate: ',F8.5,F6.3,3F6.3)
!       PRINT 9707,JW,RHSRA(JW),RHSRB(JW),RHSRC(JW),RHSRD(JW)
!    &   ,RHSRE(JW),RHSRF(JW)  
!9707   FORMAT(1X,I3,' Rain Optics as function of Reff: ',6E11.4)
!     ENDDO

!     ----------------------------------------------------------------

RETURN
END SUBROUTINE SUSWN
