SUBROUTINE SUECOZC ( KINDAT, KMINUT )


!**** *SUECOZC* - DEFINES CLIMATOLOGICAL DISTRIBUTION OF OZONE
!                 (FORTUIN LANGEMATZ CLIMATOLOGY OF OZONE)

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECOZC* FROM *UPDTIM*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===
! ROZT    :                : AMOUNT OF OZONE (KG/KG) 


!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    95/01/25

!     MODIFICATIONS.
!     --------------
!     JJMorcrette 971117 Cy18
!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOMCST   , ONLY : RPI      ,RDAY
USE YOERDI   , ONLY : RO3
USE YOEOZOC  , ONLY : RSINC    ,ROZT     ,RPROC


IMPLICIT NONE


!     DUMMY INTEGER SCALARS
INTEGER_M :: KINDAT
INTEGER_M :: KMINUT




!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------


!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZOZCL(19,34,12)
REAL_B :: ZYTIME(12), ZMDAY(12)

!     LOCAL INTEGER SCALARS
INTEGER_M :: IDY, IM, IM1, IM2, IMN, JK, JL

!     LOCAL REAL SCALARS
REAL_B :: ZTIMI, ZXTIME


#include "fcttim.h"      
!     ------------------------------------------------------------------

ZMDAY = (/&
      &31._JPRB,    59.25_JPRB,  90.25_JPRB, 120.25_JPRB, 151.25_JPRB, 181.25_JPRB &
  &,  212.25_JPRB, 243.25_JPRB, 273.25_JPRB, 304.25_JPRB, 334.25_JPRB, 365.25_JPRB &
        &/)
ZYTIME= (/&
     &22320._JPRB,  64980._JPRB, 107640._JPRB, 151560._JPRB, 195480._JPRB, 239400._JPRB &
  &, 283320._JPRB, 327960._JPRB, 371880._JPRB, 415800._JPRB, 459720._JPRB, 503640._JPRB &
        &/)

!* Ozone climatological mixing ratio (ppmv)
!        from Langematz and Fortuin 

! Month:  1
ZOZCL(:, 1, 1) = (/&
 &0.5500_JPRB, 0.5500_JPRB, 0.7200_JPRB, 0.8000_JPRB, 0.7700_JPRB, 0.7000_JPRB, 0.6300_JPRB, 0.5600_JPRB,&
 &0.5300_JPRB, 0.5300_JPRB, 0.5200_JPRB, 0.5200_JPRB, 0.6600_JPRB, 0.8100_JPRB, 0.8400_JPRB, 0.8300_JPRB,&
 &0.7700_JPRB, 0.7200_JPRB, 0.7200_JPRB /)
ZOZCL(:, 2, 1) = (/&
 &0.2500_JPRB, 0.2500_JPRB, 0.3500_JPRB, 0.4500_JPRB, 0.5100_JPRB, 0.4900_JPRB, 0.4600_JPRB, 0.4300_JPRB,&
 &0.4200_JPRB, 0.4100_JPRB, 0.3800_JPRB, 0.3500_JPRB, 0.4100_JPRB, 0.5000_JPRB, 0.5200_JPRB, 0.5000_JPRB,&
 &0.4600_JPRB, 0.4300_JPRB, 0.4300_JPRB /)
ZOZCL(:, 3, 1) = (/&
 &0.1800_JPRB, 0.1800_JPRB, 0.2100_JPRB, 0.2800_JPRB, 0.3500_JPRB, 0.3600_JPRB, 0.3600_JPRB, 0.3700_JPRB,&
 &0.3800_JPRB, 0.3900_JPRB, 0.3700_JPRB, 0.3200_JPRB, 0.3000_JPRB, 0.3100_JPRB, 0.3000_JPRB, 0.2700_JPRB,&
 &0.2500_JPRB, 0.2300_JPRB, 0.2300_JPRB /)
ZOZCL(:, 4, 1) = (/&
 &0.1500_JPRB, 0.1500_JPRB, 0.1500_JPRB, 0.1700_JPRB, 0.2200_JPRB, 0.2300_JPRB, 0.2500_JPRB, 0.2800_JPRB,&
 &0.3100_JPRB, 0.3200_JPRB, 0.3400_JPRB, 0.3200_JPRB, 0.2800_JPRB, 0.2300_JPRB, 0.1900_JPRB, 0.1400_JPRB,&
 &0.1300_JPRB, 0.1200_JPRB, 0.1200_JPRB /)
ZOZCL(:, 5, 1) = (/&
 &0.1600_JPRB, 0.1600_JPRB, 0.1500_JPRB, 0.1400_JPRB, 0.1600_JPRB, 0.1500_JPRB, 0.1600_JPRB, 0.1900_JPRB,&
 &0.2000_JPRB, 0.2100_JPRB, 0.2300_JPRB, 0.2700_JPRB, 0.2800_JPRB, 0.2600_JPRB, 0.2300_JPRB, 0.1700_JPRB,&
 &0.1600_JPRB, 0.1500_JPRB, 0.1500_JPRB /)
ZOZCL(:, 6, 1) = (/&
 &0.1700_JPRB, 0.1700_JPRB, 0.1600_JPRB, 0.1500_JPRB, 0.1400_JPRB, 0.1400_JPRB, 0.1300_JPRB, 0.1400_JPRB,&
 &0.1600_JPRB, 0.1600_JPRB, 0.1700_JPRB, 0.2100_JPRB, 0.2500_JPRB, 0.2700_JPRB, 0.2800_JPRB, 0.2400_JPRB,&
 &0.2200_JPRB, 0.2100_JPRB, 0.2100_JPRB /)
ZOZCL(:, 7, 1) = (/&
 &0.2100_JPRB, 0.2100_JPRB, 0.1900_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1500_JPRB, 0.1400_JPRB, 0.1500_JPRB,&
 &0.1500_JPRB, 0.1500_JPRB, 0.1600_JPRB, 0.1700_JPRB, 0.1900_JPRB, 0.2400_JPRB, 0.3200_JPRB, 0.3700_JPRB,&
 &0.3400_JPRB, 0.3200_JPRB, 0.3200_JPRB /)
ZOZCL(:, 8, 1) = (/&
 &0.3100_JPRB, 0.3100_JPRB, 0.2800_JPRB, 0.2600_JPRB, 0.2500_JPRB, 0.2400_JPRB, 0.2200_JPRB, 0.2200_JPRB,&
 &0.2200_JPRB, 0.2300_JPRB, 0.2300_JPRB, 0.2400_JPRB, 0.2700_JPRB, 0.3000_JPRB, 0.3700_JPRB, 0.4700_JPRB,&
 &0.4300_JPRB, 0.4100_JPRB, 0.4100_JPRB /)
ZOZCL(:, 9, 1) = (/&
 &0.4100_JPRB, 0.4100_JPRB, 0.3800_JPRB, 0.3700_JPRB, 0.3600_JPRB, 0.3400_JPRB, 0.3200_JPRB, 0.3100_JPRB,&
 &0.3200_JPRB, 0.3200_JPRB, 0.3200_JPRB, 0.3400_JPRB, 0.4100_JPRB, 0.4600_JPRB, 0.4900_JPRB, 0.5300_JPRB,&
 &0.4900_JPRB, 0.4600_JPRB, 0.4600_JPRB /)
ZOZCL(:,10, 1) = (/&
 &0.5400_JPRB, 0.5400_JPRB, 0.5200_JPRB, 0.5100_JPRB, 0.4900_JPRB, 0.4800_JPRB, 0.4800_JPRB, 0.4900_JPRB,&
 &0.4900_JPRB, 0.4700_JPRB, 0.4600_JPRB, 0.4900_JPRB, 0.5200_JPRB, 0.6900_JPRB, 0.6900_JPRB, 0.6700_JPRB,&
 &0.6200_JPRB, 0.5800_JPRB, 0.5800_JPRB /)
ZOZCL(:,11, 1) = (/&
 &0.7500_JPRB, 0.7500_JPRB, 0.7400_JPRB, 0.7300_JPRB, 0.7300_JPRB, 0.7400_JPRB, 0.7500_JPRB, 0.7400_JPRB,&
 &0.7100_JPRB, 0.6800_JPRB, 0.6800_JPRB, 0.6900_JPRB, 0.7500_JPRB, 0.7900_JPRB, 1.0100_JPRB, 0.9300_JPRB,&
 &0.8600_JPRB, 0.8000_JPRB, 0.8000_JPRB /)
ZOZCL(:,12, 1) = (/&
 &0.8900_JPRB, 0.8900_JPRB, 0.9000_JPRB, 0.9200_JPRB, 0.9200_JPRB, 0.9600_JPRB, 0.9800_JPRB, 0.9600_JPRB,&
 &0.9200_JPRB, 0.8900_JPRB, 0.8900_JPRB, 0.9200_JPRB, 0.9900_JPRB, 1.0300_JPRB, 1.2800_JPRB, 1.1900_JPRB,&
 &1.1000_JPRB, 1.0300_JPRB, 1.0300_JPRB /)
ZOZCL(:,13, 1) = (/&
 &1.1300_JPRB, 1.1300_JPRB, 1.1700_JPRB, 1.2100_JPRB, 1.2500_JPRB, 1.3200_JPRB, 1.3700_JPRB, 1.3500_JPRB,&
 &1.3000_JPRB, 1.2600_JPRB, 1.2700_JPRB, 1.3300_JPRB, 1.4200_JPRB, 1.4800_JPRB, 1.7700_JPRB, 1.6300_JPRB,&
 &1.5000_JPRB, 1.4100_JPRB, 1.4100_JPRB /)
ZOZCL(:,14, 1) = (/&
 &1.4100_JPRB, 1.4100_JPRB, 1.5000_JPRB, 1.6200_JPRB, 1.7500_JPRB, 1.8600_JPRB, 1.9300_JPRB, 1.9100_JPRB,&
 &1.8500_JPRB, 1.8300_JPRB, 1.8400_JPRB, 1.8800_JPRB, 1.9900_JPRB, 2.1600_JPRB, 2.2600_JPRB, 2.0700_JPRB,&
 &1.9100_JPRB, 1.7800_JPRB, 1.7800_JPRB /)
ZOZCL(:,15, 1) = (/&
 &1.6600_JPRB, 1.6600_JPRB, 1.7900_JPRB, 1.9700_JPRB, 2.1400_JPRB, 2.2800_JPRB, 2.3600_JPRB, 2.3500_JPRB,&
 &2.3000_JPRB, 2.2900_JPRB, 2.2900_JPRB, 2.3100_JPRB, 2.4500_JPRB, 2.7100_JPRB, 2.8000_JPRB, 2.7000_JPRB,&
 &2.3600_JPRB, 2.2200_JPRB, 2.2200_JPRB /)
ZOZCL(:,16, 1) = (/&
 &2.1500_JPRB, 2.1500_JPRB, 2.2800_JPRB, 2.4600_JPRB, 2.6300_JPRB, 2.8200_JPRB, 2.9700_JPRB, 3.0300_JPRB,&
 &3.0300_JPRB, 3.0400_JPRB, 3.0500_JPRB, 3.1000_JPRB, 3.3300_JPRB, 3.6700_JPRB, 3.7500_JPRB, 3.5500_JPRB,&
 &3.0400_JPRB, 2.8900_JPRB, 2.8900_JPRB /)
ZOZCL(:,17, 1) = (/&
 &2.9900_JPRB, 2.9900_JPRB, 3.0700_JPRB, 3.2600_JPRB, 3.4300_JPRB, 3.6700_JPRB, 3.9200_JPRB, 4.1000_JPRB,&
 &4.1900_JPRB, 4.2300_JPRB, 4.2800_JPRB, 4.4200_JPRB, 4.7400_JPRB, 5.0500_JPRB, 5.0400_JPRB, 4.6500_JPRB,&
 &3.9800_JPRB, 3.7500_JPRB, 3.7500_JPRB /)

ZOZCL(:,18, 1) = (/&
 &3.9200_JPRB, 3.9200_JPRB, 3.9600_JPRB, 4.1700_JPRB, 4.3800_JPRB, 4.6600_JPRB, 4.9500_JPRB, 5.2000_JPRB,&
 &5.3500_JPRB, 5.4000_JPRB, 5.4600_JPRB, 5.6000_JPRB, 5.8700_JPRB, 6.0300_JPRB, 5.8800_JPRB, 5.3300_JPRB,&
 &4.6500_JPRB, 4.3400_JPRB, 4.3400_JPRB /)
ZOZCL(:,19, 1) = (/&
 &5.4500_JPRB, 5.4500_JPRB, 5.4800_JPRB, 5.7700_JPRB, 6.1300_JPRB, 6.4800_JPRB, 6.8200_JPRB, 7.1300_JPRB,&
 &7.3400_JPRB, 7.3500_JPRB, 7.3100_JPRB, 7.2700_JPRB, 7.2100_JPRB, 7.0400_JPRB, 6.6400_JPRB, 5.9600_JPRB,&
 &5.3400_JPRB, 5.0600_JPRB, 5.0600_JPRB /)
ZOZCL(:,20, 1) = (/&
 &5.9900_JPRB, 5.9900_JPRB, 6.0600_JPRB, 6.7300_JPRB, 7.3900_JPRB, 8.0400_JPRB, 8.5500_JPRB, 8.9100_JPRB,&
 &9.2500_JPRB, 8.9400_JPRB, 8.7000_JPRB, 8.3200_JPRB, 7.7900_JPRB, 7.3100_JPRB, 6.7000_JPRB, 6.1400_JPRB,&
 &5.5500_JPRB, 5.3900_JPRB, 5.3900_JPRB /)
ZOZCL(:,21, 1) = (/&
 &5.4900_JPRB, 5.4900_JPRB, 5.7400_JPRB, 6.7300_JPRB, 7.6100_JPRB, 8.3800_JPRB, 8.9400_JPRB, 9.3700_JPRB,&
 &9.8400_JPRB, 9.5400_JPRB, 9.0200_JPRB, 8.2900_JPRB, 7.6000_JPRB, 7.0100_JPRB, 6.3500_JPRB, 6.0200_JPRB,&
 &5.3700_JPRB, 5.2700_JPRB, 5.2700_JPRB /)
ZOZCL(:,22, 1) = (/&
 &4.6200_JPRB, 4.6200_JPRB, 5.1400_JPRB, 6.2500_JPRB, 7.2600_JPRB, 8.0600_JPRB, 8.6200_JPRB, 9.1000_JPRB,&
 &9.7500_JPRB, 9.6500_JPRB, 8.9000_JPRB, 7.8900_JPRB, 7.1200_JPRB, 6.5200_JPRB, 5.9100_JPRB, 5.8300_JPRB,&
 &5.0100_JPRB, 4.9100_JPRB, 4.9100_JPRB /)
ZOZCL(:,23, 1) = (/&
 &3.8600_JPRB, 3.8600_JPRB, 4.3700_JPRB, 5.5300_JPRB, 6.4200_JPRB, 7.0900_JPRB, 7.4500_JPRB, 7.7700_JPRB,&
 &8.1700_JPRB, 8.1200_JPRB, 7.5600_JPRB, 6.8500_JPRB, 6.4300_JPRB, 6.1000_JPRB, 5.7400_JPRB, 5.5200_JPRB,&
 &4.6200_JPRB, 4.4500_JPRB, 4.4500_JPRB /)
ZOZCL(:,24, 1) = (/&
 &3.5200_JPRB, 3.5200_JPRB, 3.9800_JPRB, 5.0200_JPRB, 5.7300_JPRB, 6.1700_JPRB, 6.3200_JPRB, 6.4600_JPRB,&
 &6.6000_JPRB, 6.4900_JPRB, 6.1600_JPRB, 5.8800_JPRB, 5.8200_JPRB, 5.7600_JPRB, 5.5700_JPRB, 5.1900_JPRB,&
 &4.3400_JPRB, 4.1400_JPRB, 4.1400_JPRB /)
ZOZCL(:,25, 1) = (/&
 &3.1583_JPRB, 3.1583_JPRB, 3.4234_JPRB, 4.0208_JPRB, 4.4000_JPRB, 4.5357_JPRB, 4.5075_JPRB, 4.4100_JPRB,&
 &4.0617_JPRB, 3.9694_JPRB, 4.0400_JPRB, 4.0400_JPRB, 4.6674_JPRB, 4.9255_JPRB, 5.0897_JPRB, 4.7433_JPRB,&
 &4.0426_JPRB, 3.8076_JPRB, 3.8076_JPRB /)
ZOZCL(:,26, 1) = (/&
 &2.7966_JPRB, 2.7966_JPRB, 2.9248_JPRB, 2.8100_JPRB, 2.7300_JPRB, 2.2675_JPRB, 1.8250_JPRB, 1.7800_JPRB,&
 &1.4507_JPRB, 1.4660_JPRB, 1.4200_JPRB, 1.7600_JPRB, 2.2840_JPRB, 3.0940_JPRB, 3.4392_JPRB, 3.3920_JPRB,&
 &3.1930_JPRB, 3.0524_JPRB, 3.0524_JPRB /)
ZOZCL(:,27, 1) = (/&
 &2.0098_JPRB, 2.0098_JPRB, 1.9997_JPRB, 1.9061_JPRB, 1.7000_JPRB, 1.0890_JPRB, 0.6650_JPRB, 0.7000_JPRB,&
 &0.4262_JPRB, 0.4404_JPRB, 0.5600_JPRB, 0.7400_JPRB, 0.9924_JPRB, 1.7507_JPRB, 2.1023_JPRB, 2.6257_JPRB,&
 &2.1653_JPRB, 2.3068_JPRB, 2.3068_JPRB /)
ZOZCL(:,28, 1) = (/&
 &1.0717_JPRB, 1.0717_JPRB, 0.9591_JPRB, 0.9040_JPRB, 0.4530_JPRB, 0.3100_JPRB, 0.1690_JPRB, 0.1608_JPRB,&
 &0.1179_JPRB, 0.1440_JPRB, 0.1650_JPRB, 0.1439_JPRB, 0.2560_JPRB, 0.8109_JPRB, 1.0131_JPRB, 1.6720_JPRB,&
 &1.2675_JPRB, 1.6752_JPRB, 1.6752_JPRB /)
ZOZCL(:,29, 1) = (/&
 &0.4372_JPRB, 0.4372_JPRB, 0.4127_JPRB, 0.3820_JPRB, 0.1893_JPRB, 0.1654_JPRB, 0.0933_JPRB, 0.0885_JPRB,&
 &0.0626_JPRB, 0.0781_JPRB, 0.0923_JPRB, 0.0892_JPRB, 0.0999_JPRB, 0.4074_JPRB, 0.5184_JPRB, 0.8047_JPRB,&
 &0.5976_JPRB, 0.7238_JPRB, 0.7238_JPRB /)
ZOZCL(:,30, 1) = (/&
 &0.3147_JPRB, 0.3147_JPRB, 0.2824_JPRB, 0.2924_JPRB, 0.1360_JPRB, 0.0735_JPRB, 0.0805_JPRB, 0.0748_JPRB,&
 &0.0441_JPRB, 0.0555_JPRB, 0.0608_JPRB, 0.0650_JPRB, 0.0710_JPRB, 0.2430_JPRB, 0.2822_JPRB, 0.4525_JPRB,&
 &0.3080_JPRB, 0.3950_JPRB, 0.3950_JPRB /)
ZOZCL(:,31, 1) = (/&
 &0.0827_JPRB, 0.0827_JPRB, 0.0859_JPRB, 0.1133_JPRB, 0.0513_JPRB, 0.0565_JPRB, 0.0620_JPRB, 0.0574_JPRB,&
 &0.0367_JPRB, 0.0479_JPRB, 0.0467_JPRB, 0.0498_JPRB, 0.0609_JPRB, 0.0785_JPRB, 0.0848_JPRB, 0.1037_JPRB,&
 &0.0876_JPRB, 0.1068_JPRB, 0.1068_JPRB /)
ZOZCL(:,32, 1) = (/&
 &0.0266_JPRB, 0.0266_JPRB, 0.0351_JPRB, 0.0262_JPRB, 0.0320_JPRB, 0.0417_JPRB, 0.0518_JPRB, 0.0495_JPRB,&
 &0.0445_JPRB, 0.0492_JPRB, 0.0342_JPRB, 0.0469_JPRB, 0.0435_JPRB, 0.0447_JPRB, 0.0486_JPRB, 0.0466_JPRB,&
 &0.0475_JPRB, 0.0488_JPRB, 0.0488_JPRB /)
ZOZCL(:,33, 1) = (/&
 &0.0173_JPRB, 0.0173_JPRB, 0.0252_JPRB, 0.0169_JPRB, 0.0233_JPRB, 0.0311_JPRB, 0.0424_JPRB, 0.0399_JPRB,&
 &0.0274_JPRB, 0.0313_JPRB, 0.0293_JPRB, 0.0409_JPRB, 0.0403_JPRB, 0.0393_JPRB, 0.0406_JPRB, 0.0419_JPRB,&
 &0.0408_JPRB, 0.0404_JPRB, 0.0404_JPRB /)
ZOZCL(:,34, 1) = (/&
 &0.0173_JPRB, 0.0173_JPRB, 0.0252_JPRB, 0.0169_JPRB, 0.0233_JPRB, 0.0311_JPRB, 0.0424_JPRB, 0.0399_JPRB,&
 &0.0274_JPRB, 0.0313_JPRB, 0.0293_JPRB, 0.0409_JPRB, 0.0403_JPRB, 0.0393_JPRB, 0.0406_JPRB, 0.0419_JPRB,&
 &0.0408_JPRB, 0.0404_JPRB, 0.0404_JPRB /)

! Month:  2
ZOZCL(:, 1, 2) = (/&
 &0.4300_JPRB, 0.4300_JPRB, 0.5600_JPRB, 0.6400_JPRB, 0.6400_JPRB, 0.6000_JPRB, 0.5700_JPRB, 0.6000_JPRB,&
 &0.6900_JPRB, 0.7300_JPRB, 0.7000_JPRB, 0.6500_JPRB, 0.6300_JPRB, 0.6600_JPRB, 0.7300_JPRB, 0.7500_JPRB,&
 &0.7700_JPRB, 0.7400_JPRB, 0.7400_JPRB /)
ZOZCL(:, 2, 2) = (/&
 &0.2100_JPRB, 0.2100_JPRB, 0.2900_JPRB, 0.3700_JPRB, 0.3900_JPRB, 0.3800_JPRB, 0.3900_JPRB, 0.4400_JPRB,&
 &0.4700_JPRB, 0.4700_JPRB, 0.4700_JPRB, 0.4400_JPRB, 0.4200_JPRB, 0.4200_JPRB, 0.4300_JPRB, 0.4100_JPRB,&
 &0.3700_JPRB, 0.3600_JPRB, 0.3600_JPRB /)
ZOZCL(:, 3, 2) = (/&
 &0.1400_JPRB, 0.1400_JPRB, 0.1800_JPRB, 0.2400_JPRB, 0.2800_JPRB, 0.3000_JPRB, 0.3500_JPRB, 0.4100_JPRB,&
 &0.4200_JPRB, 0.4200_JPRB, 0.4200_JPRB, 0.3900_JPRB, 0.3300_JPRB, 0.3000_JPRB, 0.2700_JPRB, 0.2300_JPRB,&
 &0.1800_JPRB, 0.1700_JPRB, 0.1700_JPRB /)
ZOZCL(:, 4, 2) = (/&
 &0.1300_JPRB, 0.1300_JPRB, 0.1400_JPRB, 0.1600_JPRB, 0.1900_JPRB, 0.2300_JPRB, 0.2900_JPRB, 0.3400_JPRB,&
 &0.3500_JPRB, 0.3600_JPRB, 0.3800_JPRB, 0.3800_JPRB, 0.3300_JPRB, 0.2700_JPRB, 0.2200_JPRB, 0.1700_JPRB,&
 &0.1200_JPRB, 0.1200_JPRB, 0.1200_JPRB /)
ZOZCL(:, 5, 2) = (/&
 &0.1400_JPRB, 0.1400_JPRB, 0.1300_JPRB, 0.1400_JPRB, 0.1400_JPRB, 0.1600_JPRB, 0.1800_JPRB, 0.2100_JPRB,&
 &0.2200_JPRB, 0.2300_JPRB, 0.2600_JPRB, 0.3000_JPRB, 0.3200_JPRB, 0.3100_JPRB, 0.2800_JPRB, 0.2400_JPRB,&
 &0.2000_JPRB, 0.1900_JPRB, 0.1900_JPRB /)
ZOZCL(:, 6, 2) = (/&
 &0.1500_JPRB, 0.1500_JPRB, 0.1500_JPRB, 0.1400_JPRB, 0.1400_JPRB, 0.1300_JPRB, 0.1400_JPRB, 0.1500_JPRB,&
 &0.1600_JPRB, 0.1700_JPRB, 0.1800_JPRB, 0.2100_JPRB, 0.2600_JPRB, 0.3000_JPRB, 0.3100_JPRB, 0.3000_JPRB,&
 &0.2700_JPRB, 0.2600_JPRB, 0.2600_JPRB /)
ZOZCL(:, 7, 2) = (/&
 &0.2000_JPRB, 0.2000_JPRB, 0.1900_JPRB, 0.1800_JPRB, 0.1700_JPRB, 0.1500_JPRB, 0.1500_JPRB, 0.1500_JPRB,&
 &0.1600_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1700_JPRB, 0.1900_JPRB, 0.2300_JPRB, 0.2800_JPRB, 0.3500_JPRB,&
 &0.3800_JPRB, 0.3600_JPRB, 0.3600_JPRB /)
ZOZCL(:, 8, 2) = (/&
 &0.3000_JPRB, 0.3000_JPRB, 0.2900_JPRB, 0.2800_JPRB, 0.2600_JPRB, 0.2400_JPRB, 0.2400_JPRB, 0.2300_JPRB,&
 &0.2300_JPRB, 0.2300_JPRB, 0.2400_JPRB, 0.2500_JPRB, 0.2700_JPRB, 0.2900_JPRB, 0.3200_JPRB, 0.3900_JPRB,&
 &0.4600_JPRB, 0.4400_JPRB, 0.4400_JPRB /)
ZOZCL(:, 9, 2) = (/&
 &0.4000_JPRB, 0.4000_JPRB, 0.4000_JPRB, 0.4000_JPRB, 0.3800_JPRB, 0.3600_JPRB, 0.3400_JPRB, 0.3300_JPRB,&
 &0.3200_JPRB, 0.3100_JPRB, 0.3200_JPRB, 0.3600_JPRB, 0.4000_JPRB, 0.4300_JPRB, 0.4500_JPRB, 0.4700_JPRB,&
 &0.5200_JPRB, 0.5000_JPRB, 0.5000_JPRB /)
ZOZCL(:,10, 2) = (/&
 &0.5600_JPRB, 0.5600_JPRB, 0.5400_JPRB, 0.5300_JPRB, 0.5100_JPRB, 0.5000_JPRB, 0.5000_JPRB, 0.5000_JPRB,&
 &0.5000_JPRB, 0.4800_JPRB, 0.4600_JPRB, 0.4700_JPRB, 0.5100_JPRB, 0.5200_JPRB, 0.6400_JPRB, 0.6300_JPRB,&
 &0.6300_JPRB, 0.6100_JPRB, 0.6100_JPRB /)
ZOZCL(:,11, 2) = (/&
 &0.7600_JPRB, 0.7600_JPRB, 0.7500_JPRB, 0.7500_JPRB, 0.7700_JPRB, 0.7800_JPRB, 0.7700_JPRB, 0.7500_JPRB,&
 &0.7300_JPRB, 0.7100_JPRB, 0.7000_JPRB, 0.7000_JPRB, 0.7100_JPRB, 0.7200_JPRB, 0.7500_JPRB, 0.7400_JPRB,&
 &0.8500_JPRB, 0.8200_JPRB, 0.8200_JPRB /)
ZOZCL(:,12, 2) = (/&
 &0.9200_JPRB, 0.9200_JPRB, 0.9200_JPRB, 0.9400_JPRB, 0.9700_JPRB, 1.0100_JPRB, 1.0100_JPRB, 0.9800_JPRB,&
 &0.9400_JPRB, 0.9200_JPRB, 0.9100_JPRB, 0.9300_JPRB, 0.9400_JPRB, 0.9500_JPRB, 0.9500_JPRB, 0.9300_JPRB,&
 &1.0400_JPRB, 1.0000_JPRB, 1.0000_JPRB /)
ZOZCL(:,13, 2) = (/&
 &1.2000_JPRB, 1.2000_JPRB, 1.2200_JPRB, 1.2600_JPRB, 1.3100_JPRB, 1.3900_JPRB, 1.4100_JPRB, 1.3600_JPRB,&
 &1.3000_JPRB, 1.2900_JPRB, 1.3000_JPRB, 1.3400_JPRB, 1.3700_JPRB, 1.3700_JPRB, 1.3500_JPRB, 1.3200_JPRB,&
 &1.5000_JPRB, 1.4400_JPRB, 1.4400_JPRB /)
ZOZCL(:,14, 2) = (/&
 &1.5900_JPRB, 1.5900_JPRB, 1.6300_JPRB, 1.7300_JPRB, 1.8300_JPRB, 1.9300_JPRB, 1.9600_JPRB, 1.9000_JPRB,&
 &1.8300_JPRB, 1.8200_JPRB, 1.8500_JPRB, 1.8800_JPRB, 1.9400_JPRB, 2.0200_JPRB, 2.1400_JPRB, 2.2200_JPRB,&
 &2.2500_JPRB, 2.1600_JPRB, 2.1600_JPRB /)
ZOZCL(:,15, 2) = (/&
 &2.0000_JPRB, 2.0000_JPRB, 2.0100_JPRB, 2.1200_JPRB, 2.2500_JPRB, 2.3700_JPRB, 2.4200_JPRB, 2.3400_JPRB,&
 &2.2400_JPRB, 2.2200_JPRB, 2.2500_JPRB, 2.2900_JPRB, 2.4000_JPRB, 2.6000_JPRB, 2.8600_JPRB, 2.9800_JPRB,&
 &2.9500_JPRB, 2.6000_JPRB, 2.6000_JPRB /)
ZOZCL(:,16, 2) = (/&
 &2.7300_JPRB, 2.7300_JPRB, 2.6800_JPRB, 2.7300_JPRB, 2.8600_JPRB, 3.0000_JPRB, 3.0900_JPRB, 3.0300_JPRB,&
 &2.9000_JPRB, 2.8600_JPRB, 2.9100_JPRB, 3.0200_JPRB, 3.2400_JPRB, 3.5800_JPRB, 3.9300_JPRB, 4.0000_JPRB,&
 &3.8000_JPRB, 3.2200_JPRB, 3.2200_JPRB /)
ZOZCL(:,17, 2) = (/&
 &3.8100_JPRB, 3.8100_JPRB, 3.7100_JPRB, 3.7100_JPRB, 3.8100_JPRB, 3.9700_JPRB, 4.1100_JPRB, 4.1000_JPRB,&
 &3.9500_JPRB, 3.8700_JPRB, 3.9800_JPRB, 4.2000_JPRB, 4.5800_JPRB, 5.1000_JPRB, 5.3800_JPRB, 5.2200_JPRB,&
 &4.7900_JPRB, 4.1100_JPRB, 4.1100_JPRB /)

ZOZCL(:,18, 2) = (/&
 &4.6500_JPRB, 4.6500_JPRB, 4.6100_JPRB, 4.6800_JPRB, 4.8000_JPRB, 4.9800_JPRB, 5.1500_JPRB, 5.1700_JPRB,&
 &5.0500_JPRB, 4.9900_JPRB, 5.0900_JPRB, 5.3000_JPRB, 5.7300_JPRB, 6.2400_JPRB, 6.2900_JPRB, 5.9200_JPRB,&
 &5.4100_JPRB, 4.8200_JPRB, 4.8200_JPRB /)
ZOZCL(:,19, 2) = (/&
 &5.5900_JPRB, 5.5900_JPRB, 5.8400_JPRB, 6.1600_JPRB, 6.4200_JPRB, 6.6800_JPRB, 6.9100_JPRB, 7.0300_JPRB,&
 &7.0800_JPRB, 7.0500_JPRB, 7.0400_JPRB, 7.0900_JPRB, 7.3700_JPRB, 7.4500_JPRB, 7.0400_JPRB, 6.4700_JPRB,&
 &6.0700_JPRB, 5.6900_JPRB, 5.6900_JPRB /)
ZOZCL(:,20, 2) = (/&
 &5.5100_JPRB, 5.5100_JPRB, 6.2800_JPRB, 6.7600_JPRB, 7.5800_JPRB, 8.0500_JPRB, 8.5100_JPRB, 8.9700_JPRB,&
 &9.3600_JPRB, 9.2400_JPRB, 8.9200_JPRB, 8.7000_JPRB, 8.3300_JPRB, 7.7400_JPRB, 7.0600_JPRB, 6.4900_JPRB,&
 &6.4200_JPRB, 6.3000_JPRB, 6.3000_JPRB /)
ZOZCL(:,21, 2) = (/&
 &4.8400_JPRB, 4.8400_JPRB, 5.7800_JPRB, 6.5500_JPRB, 7.6000_JPRB, 8.2800_JPRB, 8.9000_JPRB, 9.5400_JPRB,&
 &10.1000_JPRB,10.0400_JPRB, 9.5400_JPRB, 8.9100_JPRB, 8.1200_JPRB, 7.3500_JPRB, 6.7200_JPRB, 6.3100_JPRB,&
 &6.4600_JPRB, 6.3100_JPRB, 6.3100_JPRB /)
ZOZCL(:,22, 2) = (/&
 &3.9800_JPRB, 3.9800_JPRB, 4.8400_JPRB, 5.9100_JPRB, 7.0800_JPRB, 7.9400_JPRB, 8.6700_JPRB, 9.4300_JPRB,&
 &10.0300_JPRB,10.1400_JPRB, 9.5200_JPRB, 8.5500_JPRB, 7.4700_JPRB, 6.7300_JPRB, 6.2600_JPRB, 6.1500_JPRB,&
 &6.4200_JPRB, 6.0700_JPRB, 6.0700_JPRB /)
ZOZCL(:,23, 2) = (/&
 &3.3900_JPRB, 3.3900_JPRB, 4.0800_JPRB, 5.1000_JPRB, 6.1900_JPRB, 6.9700_JPRB, 7.5100_JPRB, 8.0200_JPRB,&
 &8.3900_JPRB, 8.4300_JPRB, 7.9400_JPRB, 7.2600_JPRB, 6.6300_JPRB, 6.2100_JPRB, 5.9800_JPRB, 6.0100_JPRB,&
 &6.0600_JPRB, 5.7200_JPRB, 5.7200_JPRB /)
ZOZCL(:,24, 2) = (/&
 &3.2200_JPRB, 3.2200_JPRB, 3.7800_JPRB, 4.6000_JPRB, 5.4900_JPRB, 6.0500_JPRB, 6.3400_JPRB, 6.5800_JPRB,&
 &6.6900_JPRB, 6.6400_JPRB, 6.3600_JPRB, 6.0900_JPRB, 5.9300_JPRB, 5.8200_JPRB, 5.7800_JPRB, 5.8000_JPRB,&
 &5.5400_JPRB, 5.3000_JPRB, 5.3000_JPRB /)
ZOZCL(:,25, 2) = (/&
 &3.0003_JPRB, 3.0003_JPRB, 3.5474_JPRB, 3.1658_JPRB, 4.1800_JPRB, 4.3948_JPRB, 4.4725_JPRB, 4.3000_JPRB,&
 &4.3085_JPRB, 4.2517_JPRB, 4.0900_JPRB, 4.2500_JPRB, 4.7925_JPRB, 5.0370_JPRB, 5.0522_JPRB, 5.6167_JPRB,&
 &5.0366_JPRB, 4.8128_JPRB, 4.8128_JPRB /)
ZOZCL(:,26, 2) = (/&
 &2.7806_JPRB, 2.7806_JPRB, 2.8474_JPRB, 2.4030_JPRB, 2.5500_JPRB, 2.1512_JPRB, 1.8790_JPRB, 1.7200_JPRB,&
 &1.3503_JPRB, 1.2765_JPRB, 1.4200_JPRB, 2.0100_JPRB, 2.4662_JPRB, 3.2013_JPRB, 3.5803_JPRB, 4.0760_JPRB,&
 &3.5538_JPRB, 3.3464_JPRB, 3.3464_JPRB /)
ZOZCL(:,27, 2) = (/&
 &2.0816_JPRB, 2.0816_JPRB, 2.0919_JPRB, 1.6632_JPRB, 1.6600_JPRB, 1.0644_JPRB, 0.6293_JPRB, 0.6900_JPRB,&
 &0.4460_JPRB, 0.4129_JPRB, 0.5400_JPRB, 0.7800_JPRB, 1.0097_JPRB, 1.8169_JPRB, 2.2099_JPRB, 2.6986_JPRB,&
 &2.5496_JPRB, 2.7674_JPRB, 2.7674_JPRB /)
ZOZCL(:,28, 2) = (/&
 &1.1115_JPRB, 1.1115_JPRB, 1.0466_JPRB, 0.8470_JPRB, 0.4340_JPRB, 0.3083_JPRB, 0.1470_JPRB, 0.1402_JPRB,&
 &0.0730_JPRB, 0.1244_JPRB, 0.1460_JPRB, 0.1402_JPRB, 0.2737_JPRB, 0.8487_JPRB, 1.1139_JPRB, 1.6160_JPRB,&
 &1.5777_JPRB, 1.7738_JPRB, 1.7738_JPRB /)
ZOZCL(:,29, 2) = (/&
 &0.4523_JPRB, 0.4523_JPRB, 0.4153_JPRB, 0.2980_JPRB, 0.1827_JPRB, 0.1452_JPRB, 0.0900_JPRB, 0.0857_JPRB,&
 &0.0410_JPRB, 0.0631_JPRB, 0.0707_JPRB, 0.0789_JPRB, 0.1307_JPRB, 0.5048_JPRB, 0.6104_JPRB, 0.7773_JPRB,&
 &0.7942_JPRB, 0.9243_JPRB, 0.9243_JPRB /)
ZOZCL(:,30, 2) = (/&
 &0.3011_JPRB, 0.3011_JPRB, 0.2841_JPRB, 0.2348_JPRB, 0.1190_JPRB, 0.0620_JPRB, 0.0770_JPRB, 0.0732_JPRB,&
 &0.0302_JPRB, 0.0446_JPRB, 0.0515_JPRB, 0.0643_JPRB, 0.0864_JPRB, 0.3351_JPRB, 0.3536_JPRB, 0.5345_JPRB,&
 &0.4412_JPRB, 0.4547_JPRB, 0.4547_JPRB /)
ZOZCL(:,31, 2) = (/&
 &0.1151_JPRB, 0.1151_JPRB, 0.0983_JPRB, 0.1083_JPRB, 0.0503_JPRB, 0.0461_JPRB, 0.0730_JPRB, 0.0698_JPRB,&
 &0.0308_JPRB, 0.0374_JPRB, 0.0450_JPRB, 0.0457_JPRB, 0.0681_JPRB, 0.0962_JPRB, 0.0882_JPRB, 0.1167_JPRB,&
 &0.1221_JPRB, 0.1011_JPRB, 0.1011_JPRB /)
ZOZCL(:,32, 2) = (/&
 &0.0214_JPRB, 0.0214_JPRB, 0.0319_JPRB, 0.0236_JPRB, 0.0360_JPRB, 0.0395_JPRB, 0.0518_JPRB, 0.0499_JPRB,&
 &0.0277_JPRB, 0.0309_JPRB, 0.0322_JPRB, 0.0447_JPRB, 0.0439_JPRB, 0.0484_JPRB, 0.0503_JPRB, 0.0484_JPRB,&
 &0.0507_JPRB, 0.0452_JPRB, 0.0452_JPRB /)
ZOZCL(:,33, 2) = (/&
 &0.0172_JPRB, 0.0172_JPRB, 0.0237_JPRB, 0.0167_JPRB, 0.0269_JPRB, 0.0359_JPRB, 0.0436_JPRB, 0.0416_JPRB,&
 &0.0222_JPRB, 0.0309_JPRB, 0.0286_JPRB, 0.0397_JPRB, 0.0397_JPRB, 0.0434_JPRB, 0.0428_JPRB, 0.0423_JPRB,&
 &0.0434_JPRB, 0.0392_JPRB, 0.0392_JPRB /)
ZOZCL(:,34, 2) = (/&
 &0.0172_JPRB, 0.0172_JPRB, 0.0237_JPRB, 0.0167_JPRB, 0.0269_JPRB, 0.0359_JPRB, 0.0436_JPRB, 0.0416_JPRB,&
 &0.0222_JPRB, 0.0309_JPRB, 0.0286_JPRB, 0.0397_JPRB, 0.0397_JPRB, 0.0434_JPRB, 0.0428_JPRB, 0.0423_JPRB,&
 &0.0434_JPRB, 0.0392_JPRB, 0.0392_JPRB /)

! Month:  3
ZOZCL(:, 1, 3) = (/&
 &0.3700_JPRB, 0.3700_JPRB, 0.5800_JPRB, 0.6600_JPRB, 0.6800_JPRB, 0.7400_JPRB, 0.8200_JPRB, 0.8100_JPRB,&
 &0.7400_JPRB, 0.6900_JPRB, 0.7100_JPRB, 0.7600_JPRB, 0.7600_JPRB, 0.6800_JPRB, 0.5800_JPRB, 0.5700_JPRB,&
 &0.6000_JPRB, 0.6100_JPRB, 0.6100_JPRB /)
ZOZCL(:, 2, 3) = (/&
 &0.2100_JPRB, 0.2100_JPRB, 0.2800_JPRB, 0.3100_JPRB, 0.3800_JPRB, 0.4800_JPRB, 0.5300_JPRB, 0.5200_JPRB,&
 &0.4700_JPRB, 0.4400_JPRB, 0.4600_JPRB, 0.4900_JPRB, 0.4800_JPRB, 0.4200_JPRB, 0.3500_JPRB, 0.3300_JPRB,&
 &0.3100_JPRB, 0.2700_JPRB, 0.2700_JPRB /)
ZOZCL(:, 3, 3) = (/&
 &0.1500_JPRB, 0.1500_JPRB, 0.2100_JPRB, 0.2400_JPRB, 0.3000_JPRB, 0.3800_JPRB, 0.4300_JPRB, 0.4300_JPRB,&
 &0.4100_JPRB, 0.4000_JPRB, 0.4100_JPRB, 0.4200_JPRB, 0.4100_JPRB, 0.3600_JPRB, 0.3000_JPRB, 0.2600_JPRB,&
 &0.2200_JPRB, 0.1600_JPRB, 0.1600_JPRB /)
ZOZCL(:, 4, 3) = (/&
 &0.1200_JPRB, 0.1200_JPRB, 0.1900_JPRB, 0.2200_JPRB, 0.2600_JPRB, 0.3300_JPRB, 0.3800_JPRB, 0.3700_JPRB,&
 &0.3400_JPRB, 0.3200_JPRB, 0.3400_JPRB, 0.3700_JPRB, 0.3900_JPRB, 0.3800_JPRB, 0.3400_JPRB, 0.2800_JPRB,&
 &0.2200_JPRB, 0.1500_JPRB, 0.1500_JPRB /)
ZOZCL(:, 5, 3) = (/&
 &0.1200_JPRB, 0.1200_JPRB, 0.1500_JPRB, 0.1600_JPRB, 0.2000_JPRB, 0.2400_JPRB, 0.2500_JPRB, 0.2300_JPRB,&
 &0.2100_JPRB, 0.2000_JPRB, 0.2200_JPRB, 0.2600_JPRB, 0.3200_JPRB, 0.3800_JPRB, 0.3900_JPRB, 0.3500_JPRB,&
 &0.3100_JPRB, 0.2300_JPRB, 0.2300_JPRB /)
ZOZCL(:, 6, 3) = (/&
 &0.1500_JPRB, 0.1500_JPRB, 0.1500_JPRB, 0.1400_JPRB, 0.1500_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1600_JPRB,&
 &0.1500_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1900_JPRB, 0.2400_JPRB, 0.3200_JPRB, 0.3800_JPRB, 0.3900_JPRB,&
 &0.3700_JPRB, 0.3100_JPRB, 0.3100_JPRB /)
ZOZCL(:, 7, 3) = (/&
 &0.2000_JPRB, 0.2000_JPRB, 0.1800_JPRB, 0.1700_JPRB, 0.1500_JPRB, 0.1400_JPRB, 0.1500_JPRB, 0.1700_JPRB,&
 &0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1800_JPRB, 0.2300_JPRB, 0.2900_JPRB, 0.3700_JPRB,&
 &0.4300_JPRB, 0.4100_JPRB, 0.4100_JPRB /)
ZOZCL(:, 8, 3) = (/&
 &0.3000_JPRB, 0.3000_JPRB, 0.3000_JPRB, 0.2800_JPRB, 0.2700_JPRB, 0.2500_JPRB, 0.2500_JPRB, 0.2500_JPRB,&
 &0.2400_JPRB, 0.2300_JPRB, 0.2400_JPRB, 0.2500_JPRB, 0.2600_JPRB, 0.2800_JPRB, 0.3000_JPRB, 0.3700_JPRB,&
 &0.4600_JPRB, 0.4800_JPRB, 0.4800_JPRB /)
ZOZCL(:, 9, 3) = (/&
 &0.4000_JPRB, 0.4000_JPRB, 0.4000_JPRB, 0.4100_JPRB, 0.4000_JPRB, 0.3800_JPRB, 0.3500_JPRB, 0.3400_JPRB,&
 &0.3200_JPRB, 0.3100_JPRB, 0.3200_JPRB, 0.3600_JPRB, 0.3900_JPRB, 0.4100_JPRB, 0.4300_JPRB, 0.4600_JPRB,&
 &0.5000_JPRB, 0.5200_JPRB, 0.5200_JPRB /)
ZOZCL(:,10, 3) = (/&
 &0.5500_JPRB, 0.5500_JPRB, 0.5400_JPRB, 0.5300_JPRB, 0.5200_JPRB, 0.5100_JPRB, 0.5000_JPRB, 0.5100_JPRB,&
 &0.5000_JPRB, 0.4800_JPRB, 0.4700_JPRB, 0.4800_JPRB, 0.4900_JPRB, 0.5200_JPRB, 0.5400_JPRB, 0.5500_JPRB,&
 &0.5700_JPRB, 0.6100_JPRB, 0.6100_JPRB /)
ZOZCL(:,11, 3) = (/&
 &0.7900_JPRB, 0.7900_JPRB, 0.7600_JPRB, 0.7700_JPRB, 0.7800_JPRB, 0.7700_JPRB, 0.7500_JPRB, 0.7500_JPRB,&
 &0.7400_JPRB, 0.7300_JPRB, 0.7200_JPRB, 0.7100_JPRB, 0.7200_JPRB, 0.7400_JPRB, 0.7400_JPRB, 0.7300_JPRB,&
 &0.7400_JPRB, 0.7500_JPRB, 0.7500_JPRB /)
ZOZCL(:,12, 3) = (/&
 &0.9900_JPRB, 0.9900_JPRB, 0.9700_JPRB, 0.9800_JPRB, 1.0000_JPRB, 0.9900_JPRB, 0.9700_JPRB, 0.9600_JPRB,&
 &0.9600_JPRB, 0.9500_JPRB, 0.9400_JPRB, 0.9300_JPRB, 0.9200_JPRB, 0.9400_JPRB, 0.9400_JPRB, 0.9000_JPRB,&
 &0.9100_JPRB, 0.9300_JPRB, 0.9300_JPRB /)
ZOZCL(:,13, 3) = (/&
 &1.3300_JPRB, 1.3300_JPRB, 1.3500_JPRB, 1.3600_JPRB, 1.3800_JPRB, 1.3900_JPRB, 1.3700_JPRB, 1.3300_JPRB,&
 &1.3300_JPRB, 1.3400_JPRB, 1.3300_JPRB, 1.3200_JPRB, 1.3200_JPRB, 1.3300_JPRB, 1.3200_JPRB, 1.2800_JPRB,&
 &1.2900_JPRB, 1.3500_JPRB, 1.3500_JPRB /)
ZOZCL(:,14, 3) = (/&
 &1.9700_JPRB, 1.9700_JPRB, 1.9600_JPRB, 1.9200_JPRB, 1.9300_JPRB, 1.9500_JPRB, 1.9200_JPRB, 1.8900_JPRB,&
 &1.8800_JPRB, 1.8900_JPRB, 1.8900_JPRB, 1.9200_JPRB, 1.9400_JPRB, 1.9400_JPRB, 1.9600_JPRB, 2.0200_JPRB,&
 &2.1200_JPRB, 2.2700_JPRB, 2.2700_JPRB /)
ZOZCL(:,15, 3) = (/&
 &2.8200_JPRB, 2.8200_JPRB, 2.5800_JPRB, 2.4200_JPRB, 2.4000_JPRB, 2.4000_JPRB, 2.3700_JPRB, 2.3200_JPRB,&
 &2.3000_JPRB, 2.3000_JPRB, 2.3100_JPRB, 2.3500_JPRB, 2.4100_JPRB, 2.4200_JPRB, 2.5000_JPRB, 2.6800_JPRB,&
 &2.8900_JPRB, 3.0000_JPRB, 3.0000_JPRB /)
ZOZCL(:,16, 3) = (/&
 &3.8600_JPRB, 3.8600_JPRB, 3.6200_JPRB, 3.3000_JPRB, 3.2000_JPRB, 3.1700_JPRB, 3.1100_JPRB, 2.9900_JPRB,&
 &2.9000_JPRB, 2.8800_JPRB, 2.9200_JPRB, 3.0300_JPRB, 3.1700_JPRB, 3.2700_JPRB, 3.4500_JPRB, 3.7500_JPRB,&
 &3.9600_JPRB, 3.9300_JPRB, 3.9300_JPRB /)
ZOZCL(:,17, 3) = (/&
 &5.0100_JPRB, 5.0100_JPRB, 5.0400_JPRB, 4.6600_JPRB, 4.4600_JPRB, 4.3600_JPRB, 4.2800_JPRB, 4.0600_JPRB,&
 &3.8300_JPRB, 3.7700_JPRB, 3.8600_JPRB, 4.1000_JPRB, 4.3900_JPRB, 4.6700_JPRB, 5.0200_JPRB, 5.3300_JPRB,&
 &5.3200_JPRB, 5.0000_JPRB, 5.0000_JPRB /)

ZOZCL(:,18, 3) = (/&
 &5.4100_JPRB, 5.4100_JPRB, 5.8000_JPRB, 5.6800_JPRB, 5.5300_JPRB, 5.4500_JPRB, 5.3700_JPRB, 5.1200_JPRB,&
 &4.8000_JPRB, 4.7100_JPRB, 4.8500_JPRB, 5.1500_JPRB, 5.5100_JPRB, 5.9200_JPRB, 6.2800_JPRB, 6.4200_JPRB,&
 &6.1800_JPRB, 5.7400_JPRB, 5.7400_JPRB /)
ZOZCL(:,19, 3) = (/&
 &5.3900_JPRB, 5.3900_JPRB, 6.2600_JPRB, 6.7600_JPRB, 6.9300_JPRB, 7.0000_JPRB, 7.0600_JPRB, 6.9300_JPRB,&
 &6.6000_JPRB, 6.4800_JPRB, 6.6300_JPRB, 6.9100_JPRB, 7.2100_JPRB, 7.6100_JPRB, 7.7300_JPRB, 7.4100_JPRB,&
 &6.8800_JPRB, 6.4900_JPRB, 6.4900_JPRB /)
ZOZCL(:,20, 3) = (/&
 &5.0800_JPRB, 5.0800_JPRB, 6.0500_JPRB, 6.8800_JPRB, 7.5300_JPRB, 7.9800_JPRB, 8.4100_JPRB, 8.7200_JPRB,&
 &8.8900_JPRB, 8.7600_JPRB, 8.6400_JPRB, 8.5200_JPRB, 8.4500_JPRB, 8.4200_JPRB, 7.9600_JPRB, 7.2500_JPRB,&
 &6.6500_JPRB, 6.5000_JPRB, 6.5000_JPRB /)
ZOZCL(:,21, 3) = (/&
 &4.6500_JPRB, 4.6500_JPRB, 5.4000_JPRB, 6.4000_JPRB, 7.3000_JPRB, 7.9900_JPRB, 8.6900_JPRB, 9.3100_JPRB,&
 &9.8800_JPRB, 9.9200_JPRB, 9.5300_JPRB, 9.0600_JPRB, 8.6000_JPRB, 8.0800_JPRB, 7.4200_JPRB, 6.7000_JPRB,&
 &6.2800_JPRB, 6.3000_JPRB, 6.3000_JPRB /)
ZOZCL(:,22, 3) = (/&
 &4.0900_JPRB, 4.0900_JPRB, 4.5200_JPRB, 5.6100_JPRB, 6.6400_JPRB, 7.5300_JPRB, 8.4300_JPRB, 9.2700_JPRB,&
 &10.1800_JPRB,10.4300_JPRB, 9.8000_JPRB, 9.0300_JPRB, 8.1800_JPRB, 7.3100_JPRB, 6.6500_JPRB, 6.1500_JPRB,&
 &6.0300_JPRB, 6.1800_JPRB, 6.1800_JPRB /)
ZOZCL(:,23, 3) = (/&
 &3.7300_JPRB, 3.7300_JPRB, 3.9800_JPRB, 4.8800_JPRB, 5.8300_JPRB, 6.6300_JPRB, 7.3900_JPRB, 8.0300_JPRB,&
 &8.6500_JPRB, 8.8000_JPRB, 8.3400_JPRB, 7.8100_JPRB, 7.1800_JPRB, 6.4600_JPRB, 6.0500_JPRB, 5.8200_JPRB,&
 &5.8600_JPRB, 5.9500_JPRB, 5.9500_JPRB /)
ZOZCL(:,24, 3) = (/&
 &3.6100_JPRB, 3.6100_JPRB, 3.8500_JPRB, 4.4800_JPRB, 5.2200_JPRB, 5.8100_JPRB, 6.2800_JPRB, 6.6300_JPRB,&
 &6.9400_JPRB, 6.9800_JPRB, 6.7600_JPRB, 6.5900_JPRB, 6.3300_JPRB, 5.9100_JPRB, 5.6800_JPRB, 5.6600_JPRB,&
 &5.6800_JPRB, 5.5800_JPRB, 5.5800_JPRB /)
ZOZCL(:,25, 3) = (/&
 &3.1224_JPRB, 3.1224_JPRB, 3.6151_JPRB, 3.7775_JPRB, 4.1300_JPRB, 4.3723_JPRB, 4.4483_JPRB, 4.4100_JPRB,&
 &4.1969_JPRB, 4.0694_JPRB, 4.1500_JPRB, 4.4000_JPRB, 4.8127_JPRB, 4.9401_JPRB, 4.9680_JPRB, 5.3133_JPRB,&
 &5.0041_JPRB, 4.9122_JPRB, 4.9122_JPRB /)
ZOZCL(:,26, 3) = (/&
 &2.6334_JPRB, 2.6334_JPRB, 2.7121_JPRB, 2.6930_JPRB, 2.5200_JPRB, 2.2178_JPRB, 1.8100_JPRB, 1.7700_JPRB,&
 &1.4103_JPRB, 1.4057_JPRB, 1.6100_JPRB, 2.0200_JPRB, 2.5684_JPRB, 3.3099_JPRB, 3.5610_JPRB, 3.9360_JPRB,&
 &3.8361_JPRB, 4.1727_JPRB, 4.1727_JPRB /)
ZOZCL(:,27, 3) = (/&
 &2.0332_JPRB, 2.0332_JPRB, 1.9125_JPRB, 1.8489_JPRB, 1.6700_JPRB, 1.1312_JPRB, 0.5907_JPRB, 0.7700_JPRB,&
 &0.4366_JPRB, 0.4548_JPRB, 0.6900_JPRB, 0.8800_JPRB, 1.1434_JPRB, 1.9708_JPRB, 2.2482_JPRB, 2.6371_JPRB,&
 &2.6979_JPRB, 3.0926_JPRB, 3.0926_JPRB /)
ZOZCL(:,28, 3) = (/&
 &1.1385_JPRB, 1.1385_JPRB, 0.9831_JPRB, 0.8470_JPRB, 0.4810_JPRB, 0.3561_JPRB, 0.1400_JPRB, 0.1253_JPRB,&
 &0.0974_JPRB, 0.1627_JPRB, 0.2000_JPRB, 0.1653_JPRB, 0.3618_JPRB, 0.9371_JPRB, 1.0914_JPRB, 1.5090_JPRB,&
 &1.6604_JPRB, 2.0711_JPRB, 2.0711_JPRB /)
ZOZCL(:,29, 3) = (/&
 &0.4663_JPRB, 0.4663_JPRB, 0.4136_JPRB, 0.2400_JPRB, 0.1867_JPRB, 0.1333_JPRB, 0.0967_JPRB, 0.0849_JPRB,&
 &0.0506_JPRB, 0.0800_JPRB, 0.1020_JPRB, 0.0796_JPRB, 0.1820_JPRB, 0.5252_JPRB, 0.6249_JPRB, 0.8747_JPRB,&
 &0.8605_JPRB, 1.1893_JPRB, 1.1893_JPRB /)
ZOZCL(:,30, 3) = (/&
 &0.2737_JPRB, 0.2737_JPRB, 0.2403_JPRB, 0.1800_JPRB, 0.1205_JPRB, 0.0946_JPRB, 0.0740_JPRB, 0.0662_JPRB,&
 &0.0375_JPRB, 0.0530_JPRB, 0.0740_JPRB, 0.0561_JPRB, 0.1221_JPRB, 0.3503_JPRB, 0.3935_JPRB, 0.5720_JPRB,&
 &0.5387_JPRB, 0.6621_JPRB, 0.6621_JPRB /)
ZOZCL(:,31, 3) = (/&
 &0.0813_JPRB, 0.0813_JPRB, 0.0808_JPRB, 0.0600_JPRB, 0.0493_JPRB, 0.0642_JPRB, 0.0617_JPRB, 0.0560_JPRB,&
 &0.0363_JPRB, 0.0436_JPRB, 0.0510_JPRB, 0.0466_JPRB, 0.0676_JPRB, 0.0846_JPRB, 0.0938_JPRB, 0.1320_JPRB,&
 &0.1410_JPRB, 0.1591_JPRB, 0.1591_JPRB /)
ZOZCL(:,32, 3) = (/&
 &0.0285_JPRB, 0.0285_JPRB, 0.0364_JPRB, 0.0294_JPRB, 0.0320_JPRB, 0.0354_JPRB, 0.0586_JPRB, 0.0538_JPRB,&
 &0.0366_JPRB, 0.0472_JPRB, 0.0610_JPRB, 0.0460_JPRB, 0.0515_JPRB, 0.0539_JPRB, 0.0573_JPRB, 0.0522_JPRB,&
 &0.0549_JPRB, 0.0467_JPRB, 0.0467_JPRB /)
ZOZCL(:,33, 3) = (/&
 &0.0220_JPRB, 0.0220_JPRB, 0.0279_JPRB, 0.0243_JPRB, 0.0254_JPRB, 0.0318_JPRB, 0.0404_JPRB, 0.0373_JPRB,&
 &0.0268_JPRB, 0.0363_JPRB, 0.0471_JPRB, 0.0443_JPRB, 0.0465_JPRB, 0.0492_JPRB, 0.0480_JPRB, 0.0470_JPRB,&
 &0.0471_JPRB, 0.0386_JPRB, 0.0386_JPRB /)
ZOZCL(:,34, 3) = (/&
 &0.0220_JPRB, 0.0220_JPRB, 0.0279_JPRB, 0.0243_JPRB, 0.0254_JPRB, 0.0318_JPRB, 0.0404_JPRB, 0.0373_JPRB,&
 &0.0268_JPRB, 0.0363_JPRB, 0.0471_JPRB, 0.0443_JPRB, 0.0465_JPRB, 0.0492_JPRB, 0.0480_JPRB, 0.0470_JPRB,&
 &0.0471_JPRB, 0.0386_JPRB, 0.0386_JPRB /)

! Month:  4
ZOZCL(:, 1, 4) = (/&
 &0.8500_JPRB, 0.8500_JPRB, 0.8100_JPRB, 0.7700_JPRB, 0.8300_JPRB, 0.9200_JPRB, 0.9300_JPRB, 0.8400_JPRB,&
 &0.7700_JPRB, 0.7600_JPRB, 0.7900_JPRB, 0.9300_JPRB, 1.0100_JPRB, 0.8300_JPRB, 0.5800_JPRB, 0.5200_JPRB,&
 &0.5600_JPRB, 0.6300_JPRB, 0.6300_JPRB /)
ZOZCL(:, 2, 4) = (/&
 &0.3900_JPRB, 0.3900_JPRB, 0.3700_JPRB, 0.3500_JPRB, 0.4300_JPRB, 0.5400_JPRB, 0.5700_JPRB, 0.5000_JPRB,&
 &0.4400_JPRB, 0.4300_JPRB, 0.4700_JPRB, 0.6200_JPRB, 0.7200_JPRB, 0.6100_JPRB, 0.4300_JPRB, 0.3600_JPRB,&
 &0.3800_JPRB, 0.4200_JPRB, 0.4200_JPRB /)
ZOZCL(:, 3, 4) = (/&
 &0.2600_JPRB, 0.2600_JPRB, 0.2500_JPRB, 0.2400_JPRB, 0.3200_JPRB, 0.4100_JPRB, 0.4400_JPRB, 0.4100_JPRB,&
 &0.3900_JPRB, 0.3900_JPRB, 0.4100_JPRB, 0.4900_JPRB, 0.5600_JPRB, 0.5100_JPRB, 0.4100_JPRB, 0.3400_JPRB,&
 &0.3200_JPRB, 0.3000_JPRB, 0.3000_JPRB /)
ZOZCL(:, 4, 4) = (/&
 &0.2800_JPRB, 0.2800_JPRB, 0.2600_JPRB, 0.2500_JPRB, 0.3000_JPRB, 0.3400_JPRB, 0.3400_JPRB, 0.3400_JPRB,&
 &0.3500_JPRB, 0.3500_JPRB, 0.3500_JPRB, 0.3800_JPRB, 0.4600_JPRB, 0.4800_JPRB, 0.4400_JPRB, 0.4100_JPRB,&
 &0.3500_JPRB, 0.2500_JPRB, 0.2500_JPRB /)
ZOZCL(:, 5, 4) = (/&
 &0.3100_JPRB, 0.3100_JPRB, 0.2900_JPRB, 0.2800_JPRB, 0.2700_JPRB, 0.2600_JPRB, 0.2200_JPRB, 0.2000_JPRB,&
 &0.2200_JPRB, 0.2300_JPRB, 0.2200_JPRB, 0.2400_JPRB, 0.3200_JPRB, 0.4100_JPRB, 0.4400_JPRB, 0.4300_JPRB,&
 &0.3900_JPRB, 0.2900_JPRB, 0.2900_JPRB /)
ZOZCL(:, 6, 4) = (/&
 &0.3100_JPRB, 0.3100_JPRB, 0.2900_JPRB, 0.2800_JPRB, 0.2200_JPRB, 0.1900_JPRB, 0.1600_JPRB, 0.1500_JPRB,&
 &0.1500_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1700_JPRB, 0.2300_JPRB, 0.3100_JPRB, 0.3500_JPRB, 0.3700_JPRB,&
 &0.3700_JPRB, 0.3100_JPRB, 0.3100_JPRB /)
ZOZCL(:, 7, 4) = (/&
 &0.2900_JPRB, 0.2900_JPRB, 0.2700_JPRB, 0.2600_JPRB, 0.1800_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1700_JPRB,&
 &0.1600_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1900_JPRB, 0.2100_JPRB, 0.2300_JPRB, 0.2600_JPRB,&
 &0.3000_JPRB, 0.3300_JPRB, 0.3300_JPRB /)
ZOZCL(:, 8, 4) = (/&
 &0.3500_JPRB, 0.3500_JPRB, 0.3400_JPRB, 0.3200_JPRB, 0.2800_JPRB, 0.2700_JPRB, 0.2600_JPRB, 0.2600_JPRB,&
 &0.2500_JPRB, 0.2500_JPRB, 0.2500_JPRB, 0.2700_JPRB, 0.2700_JPRB, 0.2800_JPRB, 0.2900_JPRB, 0.3100_JPRB,&
 &0.3500_JPRB, 0.3900_JPRB, 0.3900_JPRB /)
ZOZCL(:, 9, 4) = (/&
 &0.4600_JPRB, 0.4600_JPRB, 0.4400_JPRB, 0.4200_JPRB, 0.4100_JPRB, 0.4000_JPRB, 0.3800_JPRB, 0.3700_JPRB,&
 &0.3500_JPRB, 0.3400_JPRB, 0.3400_JPRB, 0.3700_JPRB, 0.3800_JPRB, 0.3900_JPRB, 0.4100_JPRB, 0.4300_JPRB,&
 &0.4600_JPRB, 0.4900_JPRB, 0.4900_JPRB /)
ZOZCL(:,10, 4) = (/&
 &0.6200_JPRB, 0.6200_JPRB, 0.5900_JPRB, 0.5600_JPRB, 0.5600_JPRB, 0.5500_JPRB, 0.5400_JPRB, 0.5400_JPRB,&
 &0.5200_JPRB, 0.5000_JPRB, 0.4900_JPRB, 0.5000_JPRB, 0.4900_JPRB, 0.4900_JPRB, 0.5000_JPRB, 0.5300_JPRB,&
 &0.5500_JPRB, 0.5600_JPRB, 0.5600_JPRB /)
ZOZCL(:,11, 4) = (/&
 &0.8800_JPRB, 0.8800_JPRB, 0.8400_JPRB, 0.8000_JPRB, 0.8100_JPRB, 0.7900_JPRB, 0.7900_JPRB, 0.7900_JPRB,&
 &0.7800_JPRB, 0.7600_JPRB, 0.7500_JPRB, 0.7500_JPRB, 0.7400_JPRB, 0.7300_JPRB, 0.7300_JPRB, 0.7300_JPRB,&
 &0.7300_JPRB, 0.7300_JPRB, 0.7300_JPRB /)
ZOZCL(:,12, 4) = (/&
 &1.1700_JPRB, 1.1700_JPRB, 1.1100_JPRB, 1.0600_JPRB, 1.0500_JPRB, 1.0100_JPRB, 1.0000_JPRB, 1.0100_JPRB,&
 &1.0000_JPRB, 0.9800_JPRB, 0.9700_JPRB, 0.9600_JPRB, 0.9500_JPRB, 0.9400_JPRB, 0.9300_JPRB, 0.9100_JPRB,&
 &0.9000_JPRB, 0.8900_JPRB, 0.8900_JPRB /)
ZOZCL(:,13, 4) = (/&
 &1.7000_JPRB, 1.7000_JPRB, 1.6100_JPRB, 1.5400_JPRB, 1.5000_JPRB, 1.4300_JPRB, 1.4000_JPRB, 1.3900_JPRB,&
 &1.3800_JPRB, 1.3600_JPRB, 1.3500_JPRB, 1.3500_JPRB, 1.3300_JPRB, 1.3200_JPRB, 1.2900_JPRB, 1.2600_JPRB,&
 &1.2400_JPRB, 1.2400_JPRB, 1.2400_JPRB /)
ZOZCL(:,14, 4) = (/&
 &2.5000_JPRB, 2.5000_JPRB, 2.3800_JPRB, 2.2700_JPRB, 2.1700_JPRB, 2.0400_JPRB, 1.9600_JPRB, 1.9300_JPRB,&
 &1.9400_JPRB, 1.9400_JPRB, 1.9300_JPRB, 1.9400_JPRB, 1.9400_JPRB, 1.8900_JPRB, 1.8400_JPRB, 1.8300_JPRB,&
 &1.8600_JPRB, 1.9000_JPRB, 1.9000_JPRB /)
ZOZCL(:,15, 4) = (/&
 &3.4900_JPRB, 3.4900_JPRB, 3.3400_JPRB, 2.9600_JPRB, 2.7700_JPRB, 2.5600_JPRB, 2.4200_JPRB, 2.3600_JPRB,&
 &2.3700_JPRB, 2.3700_JPRB, 2.3700_JPRB, 2.4000_JPRB, 2.4100_JPRB, 2.3300_JPRB, 2.2600_JPRB, 2.2800_JPRB,&
 &2.3700_JPRB, 2.4800_JPRB, 2.4800_JPRB /)
ZOZCL(:,16, 4) = (/&
 &4.6400_JPRB, 4.6400_JPRB, 4.6400_JPRB, 4.1900_JPRB, 3.8700_JPRB, 3.5200_JPRB, 3.2500_JPRB, 3.0700_JPRB,&
 &2.9900_JPRB, 2.9700_JPRB, 2.9900_JPRB, 3.0600_JPRB, 3.1100_JPRB, 3.0300_JPRB, 2.9600_JPRB, 3.0300_JPRB,&
 &3.1800_JPRB, 3.3500_JPRB, 3.3500_JPRB /)
ZOZCL(:,17, 4) = (/&
 &5.5900_JPRB, 5.5900_JPRB, 6.0600_JPRB, 5.8400_JPRB, 5.4800_JPRB, 5.0100_JPRB, 4.5700_JPRB, 4.1600_JPRB,&
 &3.9300_JPRB, 3.8800_JPRB, 3.9400_JPRB, 4.0800_JPRB, 4.2100_JPRB, 4.1800_JPRB, 4.1600_JPRB, 4.3000_JPRB,&
 &4.4800_JPRB, 4.5700_JPRB, 4.5700_JPRB /)

ZOZCL(:,18, 4) = (/&
 &5.6500_JPRB, 5.6500_JPRB, 6.3900_JPRB, 6.6500_JPRB, 6.5100_JPRB, 6.1400_JPRB, 5.7100_JPRB, 5.2300_JPRB,&
 &4.9000_JPRB, 4.8300_JPRB, 4.9300_JPRB, 5.1300_JPRB, 5.3100_JPRB, 5.3500_JPRB, 5.3900_JPRB, 5.5500_JPRB,&
 &5.6300_JPRB, 5.4900_JPRB, 5.4900_JPRB /)
ZOZCL(:,19, 4) = (/&
 &5.1800_JPRB, 5.1800_JPRB, 5.9800_JPRB, 6.9300_JPRB, 7.3400_JPRB, 7.4000_JPRB, 7.3000_JPRB, 6.9900_JPRB,&
 &6.5800_JPRB, 6.4900_JPRB, 6.6600_JPRB, 6.9500_JPRB, 7.1200_JPRB, 7.2500_JPRB, 7.3100_JPRB, 7.3000_JPRB,&
 &7.0200_JPRB, 6.4200_JPRB, 6.4200_JPRB /)
ZOZCL(:,20, 4) = (/&
 &4.9400_JPRB, 4.9400_JPRB, 5.5400_JPRB, 6.4800_JPRB, 6.9800_JPRB, 7.8100_JPRB, 8.3300_JPRB, 8.5800_JPRB,&
 &8.4600_JPRB, 8.4400_JPRB, 8.3600_JPRB, 8.5700_JPRB, 8.5700_JPRB, 8.6400_JPRB, 8.4100_JPRB, 7.6400_JPRB,&
 &6.9900_JPRB, 6.1400_JPRB, 6.1400_JPRB /)
ZOZCL(:,21, 4) = (/&
 &4.6600_JPRB, 4.6600_JPRB, 5.0900_JPRB, 5.9000_JPRB, 6.5300_JPRB, 7.5700_JPRB, 8.4200_JPRB, 9.1000_JPRB,&
 &9.4700_JPRB, 9.5600_JPRB, 9.3000_JPRB, 9.1100_JPRB, 8.8600_JPRB, 8.5900_JPRB, 8.0400_JPRB, 7.1700_JPRB,&
 &6.3700_JPRB, 5.6800_JPRB, 5.6800_JPRB /)
ZOZCL(:,22, 4) = (/&
 &4.1800_JPRB, 4.1800_JPRB, 4.5000_JPRB, 5.2300_JPRB, 5.8700_JPRB, 6.9900_JPRB, 8.0400_JPRB, 9.0300_JPRB,&
 &9.9400_JPRB,10.2500_JPRB, 9.7100_JPRB, 9.0500_JPRB, 8.5700_JPRB, 7.9100_JPRB, 7.1600_JPRB, 6.4400_JPRB,&
 &5.7800_JPRB, 5.4000_JPRB, 5.4000_JPRB /)
ZOZCL(:,23, 4) = (/&
 &3.7300_JPRB, 3.7300_JPRB, 4.1500_JPRB, 4.8200_JPRB, 5.3000_JPRB, 6.2100_JPRB, 7.1300_JPRB, 7.9400_JPRB,&
 &8.6900_JPRB, 8.8900_JPRB, 8.5000_JPRB, 7.9700_JPRB, 7.5700_JPRB, 6.9000_JPRB, 6.2800_JPRB, 5.8000_JPRB,&
 &5.4000_JPRB, 5.3000_JPRB, 5.3000_JPRB /)
ZOZCL(:,24, 4) = (/&
 &3.4600_JPRB, 3.4600_JPRB, 4.0300_JPRB, 4.6300_JPRB, 4.8800_JPRB, 5.5400_JPRB, 6.1700_JPRB, 6.6300_JPRB,&
 &7.0600_JPRB, 7.1500_JPRB, 7.0200_JPRB, 6.8100_JPRB, 6.6500_JPRB, 6.1900_JPRB, 5.7400_JPRB, 5.4200_JPRB,&
 &5.2400_JPRB, 5.2600_JPRB, 5.2600_JPRB /)
ZOZCL(:,25, 4) = (/&
 &3.0632_JPRB, 3.0632_JPRB, 3.4158_JPRB, 3.5100_JPRB, 4.3100_JPRB, 4.3752_JPRB, 4.5208_JPRB, 4.4600_JPRB,&
 &4.2765_JPRB, 4.1155_JPRB, 4.5100_JPRB, 4.7700_JPRB, 4.8950_JPRB, 4.9389_JPRB, 4.9170_JPRB, 4.8658_JPRB,&
 &4.6739_JPRB, 4.4704_JPRB, 4.4704_JPRB /)
ZOZCL(:,26, 4) = (/&
 &2.7866_JPRB, 2.7866_JPRB, 2.8827_JPRB, 2.2940_JPRB, 2.3100_JPRB, 2.3000_JPRB, 1.8480_JPRB, 1.7500_JPRB,&
 &1.4017_JPRB, 1.3223_JPRB, 1.9100_JPRB, 2.1500_JPRB, 2.4873_JPRB, 3.0727_JPRB, 3.3838_JPRB, 3.6860_JPRB,&
 &3.4798_JPRB, 3.6792_JPRB, 3.6792_JPRB /)
ZOZCL(:,27, 4) = (/&
 &2.0170_JPRB, 2.0170_JPRB, 2.1027_JPRB, 1.5043_JPRB, 1.2057_JPRB, 1.2311_JPRB, 0.6146_JPRB, 0.7500_JPRB,&
 &0.4326_JPRB, 0.4324_JPRB, 0.8300_JPRB, 0.9200_JPRB, 1.0115_JPRB, 1.7445_JPRB, 2.1317_JPRB, 2.5600_JPRB,&
 &2.4715_JPRB, 2.6507_JPRB, 2.6507_JPRB /)
ZOZCL(:,28, 4) = (/&
 &1.0687_JPRB, 1.0687_JPRB, 1.1158_JPRB, 0.8870_JPRB, 0.4880_JPRB, 0.4550_JPRB, 0.1530_JPRB, 0.1371_JPRB,&
 &0.0946_JPRB, 0.1433_JPRB, 0.2040_JPRB, 0.1863_JPRB, 0.3347_JPRB, 0.8332_JPRB, 1.1081_JPRB, 1.4170_JPRB,&
 &1.3721_JPRB, 1.5628_JPRB, 1.5628_JPRB /)
ZOZCL(:,29, 4) = (/&
 &0.4071_JPRB, 0.4071_JPRB, 0.4014_JPRB, 0.2647_JPRB, 0.1933_JPRB, 0.1891_JPRB, 0.0920_JPRB, 0.0776_JPRB,&
 &0.0395_JPRB, 0.0654_JPRB, 0.0907_JPRB, 0.0952_JPRB, 0.1664_JPRB, 0.4858_JPRB, 0.6369_JPRB, 0.7840_JPRB,&
 &0.8782_JPRB, 1.0681_JPRB, 1.0681_JPRB /)
ZOZCL(:,30, 4) = (/&
 &0.2599_JPRB, 0.2599_JPRB, 0.2491_JPRB, 0.1898_JPRB, 0.0915_JPRB, 0.0924_JPRB, 0.0690_JPRB, 0.0586_JPRB,&
 &0.0327_JPRB, 0.0566_JPRB, 0.0740_JPRB, 0.0723_JPRB, 0.1213_JPRB, 0.3358_JPRB, 0.4177_JPRB, 0.5340_JPRB,&
 &0.6533_JPRB, 0.6759_JPRB, 0.6759_JPRB /)
ZOZCL(:,31, 4) = (/&
 &0.0723_JPRB, 0.0723_JPRB, 0.0732_JPRB, 0.0400_JPRB, 0.0433_JPRB, 0.0441_JPRB, 0.0517_JPRB, 0.0451_JPRB,&
 &0.0301_JPRB, 0.0512_JPRB, 0.0647_JPRB, 0.0615_JPRB, 0.0745_JPRB, 0.0995_JPRB, 0.1084_JPRB, 0.1423_JPRB,&
 &0.1592_JPRB, 0.1711_JPRB, 0.1711_JPRB /)
ZOZCL(:,32, 4) = (/&
 &0.0306_JPRB, 0.0306_JPRB, 0.0345_JPRB, 0.0334_JPRB, 0.0346_JPRB, 0.0344_JPRB, 0.0400_JPRB, 0.0366_JPRB,&
 &0.0300_JPRB, 0.0491_JPRB, 0.0620_JPRB, 0.0554_JPRB, 0.0574_JPRB, 0.0620_JPRB, 0.0659_JPRB, 0.0626_JPRB,&
 &0.0634_JPRB, 0.0558_JPRB, 0.0558_JPRB /)
ZOZCL(:,33, 4) = (/&
 &0.0251_JPRB, 0.0251_JPRB, 0.0280_JPRB, 0.0281_JPRB, 0.0269_JPRB, 0.0290_JPRB, 0.0376_JPRB, 0.0341_JPRB,&
 &0.0280_JPRB, 0.0385_JPRB, 0.0357_JPRB, 0.0480_JPRB, 0.0493_JPRB, 0.0564_JPRB, 0.0559_JPRB, 0.0556_JPRB,&
 &0.0570_JPRB, 0.0493_JPRB, 0.0493_JPRB /)
ZOZCL(:,34, 4) = (/&
 &0.0251_JPRB, 0.0251_JPRB, 0.0280_JPRB, 0.0281_JPRB, 0.0269_JPRB, 0.0290_JPRB, 0.0376_JPRB, 0.0341_JPRB,&
 &0.0280_JPRB, 0.0385_JPRB, 0.0357_JPRB, 0.0480_JPRB, 0.0493_JPRB, 0.0564_JPRB, 0.0559_JPRB, 0.0556_JPRB,&
 &0.0570_JPRB, 0.0493_JPRB, 0.0493_JPRB /)

! Month:  5
ZOZCL(:, 1, 5) = (/&
 &0.9400_JPRB, 0.9400_JPRB, 1.0600_JPRB, 0.9900_JPRB, 0.9900_JPRB, 1.0200_JPRB, 0.9200_JPRB, 0.7500_JPRB,&
 &0.6500_JPRB, 0.6300_JPRB, 0.6700_JPRB, 0.7500_JPRB, 0.8500_JPRB, 0.8400_JPRB, 0.7400_JPRB, 0.6400_JPRB,&
 &0.5600_JPRB, 0.4800_JPRB, 0.4800_JPRB /)
ZOZCL(:, 2, 5) = (/&
 &0.4800_JPRB, 0.4800_JPRB, 0.5500_JPRB, 0.5100_JPRB, 0.5100_JPRB, 0.5700_JPRB, 0.5300_JPRB, 0.4600_JPRB,&
 &0.4200_JPRB, 0.4100_JPRB, 0.4300_JPRB, 0.5200_JPRB, 0.6200_JPRB, 0.6300_JPRB, 0.5600_JPRB, 0.4900_JPRB,&
 &0.4100_JPRB, 0.3300_JPRB, 0.3300_JPRB /)
ZOZCL(:, 3, 5) = (/&
 &0.3100_JPRB, 0.3100_JPRB, 0.3500_JPRB, 0.3300_JPRB, 0.3300_JPRB, 0.3800_JPRB, 0.3800_JPRB, 0.4000_JPRB,&
 &0.4200_JPRB, 0.4300_JPRB, 0.4300_JPRB, 0.4500_JPRB, 0.5000_JPRB, 0.5000_JPRB, 0.4600_JPRB, 0.4100_JPRB,&
 &0.3300_JPRB, 0.2500_JPRB, 0.2500_JPRB /)
ZOZCL(:, 4, 5) = (/&
 &0.2600_JPRB, 0.2600_JPRB, 0.2900_JPRB, 0.2700_JPRB, 0.2600_JPRB, 0.2900_JPRB, 0.3200_JPRB, 0.3700_JPRB,&
 &0.4100_JPRB, 0.4200_JPRB, 0.4000_JPRB, 0.3800_JPRB, 0.3800_JPRB, 0.3800_JPRB, 0.3500_JPRB, 0.3300_JPRB,&
 &0.2800_JPRB, 0.2100_JPRB, 0.2100_JPRB /)
ZOZCL(:, 5, 5) = (/&
 &0.2300_JPRB, 0.2300_JPRB, 0.2600_JPRB, 0.2400_JPRB, 0.2400_JPRB, 0.2200_JPRB, 0.2300_JPRB, 0.2400_JPRB,&
 &0.2600_JPRB, 0.2600_JPRB, 0.2500_JPRB, 0.2400_JPRB, 0.2500_JPRB, 0.2500_JPRB, 0.2500_JPRB, 0.2400_JPRB,&
 &0.2100_JPRB, 0.1900_JPRB, 0.1900_JPRB /)
ZOZCL(:, 6, 5) = (/&
 &0.2100_JPRB, 0.2100_JPRB, 0.2400_JPRB, 0.2200_JPRB, 0.2200_JPRB, 0.1800_JPRB, 0.1700_JPRB, 0.1700_JPRB,&
 &0.1800_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1900_JPRB, 0.1900_JPRB, 0.2000_JPRB, 0.1900_JPRB,&
 &0.1900_JPRB, 0.1800_JPRB, 0.1800_JPRB /)
ZOZCL(:, 7, 5) = (/&
 &0.2100_JPRB, 0.2100_JPRB, 0.2400_JPRB, 0.2200_JPRB, 0.2200_JPRB, 0.1700_JPRB, 0.1600_JPRB, 0.1600_JPRB,&
 &0.1600_JPRB, 0.1600_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1900_JPRB, 0.1900_JPRB, 0.2000_JPRB, 0.1900_JPRB,&
 &0.1900_JPRB, 0.2000_JPRB, 0.2000_JPRB /)
ZOZCL(:, 8, 5) = (/&
 &0.2800_JPRB, 0.2800_JPRB, 0.3200_JPRB, 0.3000_JPRB, 0.3000_JPRB, 0.2800_JPRB, 0.2800_JPRB, 0.2700_JPRB,&
 &0.2600_JPRB, 0.2700_JPRB, 0.2700_JPRB, 0.2700_JPRB, 0.2700_JPRB, 0.2800_JPRB, 0.2900_JPRB, 0.2800_JPRB,&
 &0.2900_JPRB, 0.3100_JPRB, 0.3100_JPRB /)
ZOZCL(:, 9, 5) = (/&
 &0.3900_JPRB, 0.3900_JPRB, 0.4400_JPRB, 0.4100_JPRB, 0.4100_JPRB, 0.4100_JPRB, 0.4000_JPRB, 0.3900_JPRB,&
 &0.3800_JPRB, 0.3800_JPRB, 0.3800_JPRB, 0.3800_JPRB, 0.3700_JPRB, 0.3800_JPRB, 0.3900_JPRB, 0.3900_JPRB,&
 &0.4000_JPRB, 0.4300_JPRB, 0.4300_JPRB /)
ZOZCL(:,10, 5) = (/&
 &0.5600_JPRB, 0.5600_JPRB, 0.6300_JPRB, 0.5900_JPRB, 0.5800_JPRB, 0.5700_JPRB, 0.5600_JPRB, 0.5600_JPRB,&
 &0.5500_JPRB, 0.5300_JPRB, 0.5300_JPRB, 0.5200_JPRB, 0.5000_JPRB, 0.4900_JPRB, 0.5100_JPRB, 0.5300_JPRB,&
 &0.5400_JPRB, 0.5400_JPRB, 0.5400_JPRB /)
ZOZCL(:,11, 5) = (/&
 &0.8000_JPRB, 0.8000_JPRB, 0.9100_JPRB, 0.8500_JPRB, 0.8500_JPRB, 0.8100_JPRB, 0.8100_JPRB, 0.8300_JPRB,&
 &0.8100_JPRB, 0.7900_JPRB, 0.7900_JPRB, 0.8000_JPRB, 0.7800_JPRB, 0.7600_JPRB, 0.7500_JPRB, 0.7600_JPRB,&
 &0.7500_JPRB, 0.7300_JPRB, 0.7300_JPRB /)
ZOZCL(:,12, 5) = (/&
 &1.0600_JPRB, 1.0600_JPRB, 1.2000_JPRB, 1.1200_JPRB, 1.1200_JPRB, 1.0500_JPRB, 1.0300_JPRB, 1.0500_JPRB,&
 &1.0300_JPRB, 1.0100_JPRB, 1.0200_JPRB, 1.0200_JPRB, 1.0000_JPRB, 0.9700_JPRB, 0.9500_JPRB, 0.9400_JPRB,&
 &0.9100_JPRB, 0.8800_JPRB, 0.8800_JPRB /)
ZOZCL(:,13, 5) = (/&
 &1.5800_JPRB, 1.5800_JPRB, 1.7900_JPRB, 1.6800_JPRB, 1.6700_JPRB, 1.5200_JPRB, 1.4300_JPRB, 1.4200_JPRB,&
 &1.4100_JPRB, 1.3900_JPRB, 1.4000_JPRB, 1.3900_JPRB, 1.3600_JPRB, 1.3300_JPRB, 1.2900_JPRB, 1.2500_JPRB,&
 &1.2000_JPRB, 1.1600_JPRB, 1.1600_JPRB /)
ZOZCL(:,14, 5) = (/&
 &2.3200_JPRB, 2.3200_JPRB, 2.6400_JPRB, 2.4700_JPRB, 2.4600_JPRB, 2.2400_JPRB, 2.0200_JPRB, 1.9600_JPRB,&
 &1.9700_JPRB, 1.9700_JPRB, 1.9700_JPRB, 1.9600_JPRB, 1.9500_JPRB, 1.8900_JPRB, 1.8200_JPRB, 1.7400_JPRB,&
 &1.6500_JPRB, 1.5900_JPRB, 1.5900_JPRB /)
ZOZCL(:,15, 5) = (/&
 &3.0600_JPRB, 3.0600_JPRB, 3.6600_JPRB, 3.5000_JPRB, 3.3500_JPRB, 2.8900_JPRB, 2.5400_JPRB, 2.4300_JPRB,&
 &2.4200_JPRB, 2.4200_JPRB, 2.4200_JPRB, 2.4200_JPRB, 2.4000_JPRB, 2.3300_JPRB, 2.2300_JPRB, 2.1200_JPRB,&
 &2.0400_JPRB, 1.9700_JPRB, 1.9700_JPRB /)
ZOZCL(:,16, 5) = (/&
 &4.0500_JPRB, 4.0500_JPRB, 4.9700_JPRB, 4.9100_JPRB, 4.7900_JPRB, 4.0900_JPRB, 3.4900_JPRB, 3.1800_JPRB,&
 &3.0900_JPRB, 3.0700_JPRB, 3.0600_JPRB, 3.0700_JPRB, 3.0300_JPRB, 2.9200_JPRB, 2.7900_JPRB, 2.6700_JPRB,&
 &2.5900_JPRB, 2.5900_JPRB, 2.5900_JPRB /)
ZOZCL(:,17, 5) = (/&
 &4.9600_JPRB, 4.9600_JPRB, 6.3000_JPRB, 6.3900_JPRB, 6.6100_JPRB, 5.8500_JPRB, 4.9800_JPRB, 4.3300_JPRB,&
 &4.1000_JPRB, 4.0500_JPRB, 4.0400_JPRB, 4.0600_JPRB, 4.0200_JPRB, 3.8800_JPRB, 3.7300_JPRB, 3.6200_JPRB,&
 &3.5400_JPRB, 3.6400_JPRB, 3.6400_JPRB /)

ZOZCL(:,18, 5) = (/&
 &5.1300_JPRB, 5.1300_JPRB, 6.5200_JPRB, 6.7700_JPRB, 7.3800_JPRB, 6.9400_JPRB, 6.1500_JPRB, 5.4100_JPRB,&
 &5.1000_JPRB, 5.0300_JPRB, 5.0500_JPRB, 5.1100_JPRB, 5.0700_JPRB, 4.9400_JPRB, 4.8100_JPRB, 4.7200_JPRB,&
 &4.6200_JPRB, 4.7500_JPRB, 4.7500_JPRB /)
ZOZCL(:,19, 5) = (/&
 &4.8900_JPRB, 4.8900_JPRB, 6.0700_JPRB, 6.3900_JPRB, 7.4600_JPRB, 7.7600_JPRB, 7.5400_JPRB, 7.0600_JPRB,&
 &6.7400_JPRB, 6.6800_JPRB, 6.7700_JPRB, 6.9300_JPRB, 6.9200_JPRB, 6.8200_JPRB, 6.7300_JPRB, 6.6000_JPRB,&
 &6.3100_JPRB, 6.3000_JPRB, 6.3000_JPRB /)
ZOZCL(:,20, 5) = (/&
 &4.3800_JPRB, 4.3800_JPRB, 5.7900_JPRB, 5.7300_JPRB, 6.7400_JPRB, 7.6000_JPRB, 8.1900_JPRB, 8.4000_JPRB,&
 &8.2700_JPRB, 8.2200_JPRB, 8.4500_JPRB, 8.5700_JPRB, 8.4800_JPRB, 8.3900_JPRB, 8.1700_JPRB, 7.5400_JPRB,&
 &6.7500_JPRB, 6.1900_JPRB, 6.1900_JPRB /)
ZOZCL(:,21, 5) = (/&
 &3.8700_JPRB, 3.8700_JPRB, 5.4600_JPRB, 5.3100_JPRB, 6.1900_JPRB, 7.1700_JPRB, 8.0700_JPRB, 8.7900_JPRB,&
 &9.1300_JPRB, 9.1000_JPRB, 9.2400_JPRB, 9.0900_JPRB, 8.8600_JPRB, 8.5900_JPRB, 8.1300_JPRB, 7.3100_JPRB,&
 &6.2600_JPRB, 5.4700_JPRB, 5.4700_JPRB /)
ZOZCL(:,22, 5) = (/&
 &3.3700_JPRB, 3.3700_JPRB, 4.9300_JPRB, 4.9300_JPRB, 5.6200_JPRB, 6.5700_JPRB, 7.5700_JPRB, 8.6900_JPRB,&
 &9.6300_JPRB, 9.7700_JPRB, 9.5700_JPRB, 8.9800_JPRB, 8.6100_JPRB, 8.1500_JPRB, 7.5200_JPRB, 6.6900_JPRB,&
 &5.6300_JPRB, 4.8400_JPRB, 4.8400_JPRB /)
ZOZCL(:,23, 5) = (/&
 &3.1200_JPRB, 3.1200_JPRB, 4.4300_JPRB, 4.7400_JPRB, 5.3300_JPRB, 6.0400_JPRB, 6.8000_JPRB, 7.7200_JPRB,&
 &8.4800_JPRB, 8.6400_JPRB, 8.4400_JPRB, 7.9500_JPRB, 7.6400_JPRB, 7.1700_JPRB, 6.5900_JPRB, 5.9200_JPRB,&
 &5.0600_JPRB, 4.4300_JPRB, 4.4300_JPRB /)
ZOZCL(:,24, 5) = (/&
 &3.0200_JPRB, 3.0200_JPRB, 4.1300_JPRB, 4.6100_JPRB, 5.0700_JPRB, 5.5500_JPRB, 6.0100_JPRB, 6.5600_JPRB,&
 &6.9800_JPRB, 7.0700_JPRB, 7.0400_JPRB, 6.8200_JPRB, 6.6900_JPRB, 6.3900_JPRB, 5.9200_JPRB, 5.4100_JPRB,&
 &4.7600_JPRB, 4.3200_JPRB, 4.3200_JPRB /)
ZOZCL(:,25, 5) = (/&
 &2.9516_JPRB, 2.9516_JPRB, 3.4781_JPRB, 3.6833_JPRB, 4.4667_JPRB, 4.8018_JPRB, 4.7850_JPRB, 4.5500_JPRB,&
 &4.2181_JPRB, 4.1108_JPRB, 4.5700_JPRB, 4.8100_JPRB, 5.0088_JPRB, 4.8876_JPRB, 4.7114_JPRB, 4.5625_JPRB,&
 &4.0898_JPRB, 4.1086_JPRB, 4.1086_JPRB /)
ZOZCL(:,26, 5) = (/&
 &2.8832_JPRB, 2.8832_JPRB, 2.7087_JPRB, 2.6900_JPRB, 2.3040_JPRB, 2.5666_JPRB, 1.9860_JPRB, 1.8200_JPRB,&
 &1.5096_JPRB, 1.4102_JPRB, 1.7700_JPRB, 2.1900_JPRB, 2.5664_JPRB, 2.8653_JPRB, 3.0488_JPRB, 3.2530_JPRB,&
 &3.2127_JPRB, 3.2361_JPRB, 3.2361_JPRB /)
ZOZCL(:,27, 5) = (/&
 &2.0883_JPRB, 2.0883_JPRB, 1.8960_JPRB, 1.9786_JPRB, 1.3543_JPRB, 1.4206_JPRB, 0.7654_JPRB, 0.7400_JPRB,&
 &0.4328_JPRB, 0.4241_JPRB, 0.6800_JPRB, 1.0200_JPRB, 1.0424_JPRB, 1.5531_JPRB, 1.8924_JPRB, 2.2554_JPRB,&
 &2.3132_JPRB, 2.4103_JPRB, 2.4103_JPRB /)
ZOZCL(:,28, 5) = (/&
 &1.1625_JPRB, 1.1625_JPRB, 1.0276_JPRB, 0.9200_JPRB, 0.5320_JPRB, 0.5041_JPRB, 0.1900_JPRB, 0.1769_JPRB,&
 &0.1036_JPRB, 0.1433_JPRB, 0.1935_JPRB, 0.2574_JPRB, 0.3144_JPRB, 0.7746_JPRB, 0.9693_JPRB, 1.1890_JPRB,&
 &1.3057_JPRB, 1.4491_JPRB, 1.4491_JPRB /)
ZOZCL(:,29, 5) = (/&
 &0.4193_JPRB, 0.4193_JPRB, 0.3927_JPRB, 0.4000_JPRB, 0.3267_JPRB, 0.2070_JPRB, 0.1120_JPRB, 0.1028_JPRB,&
 &0.0514_JPRB, 0.0754_JPRB, 0.0987_JPRB, 0.1170_JPRB, 0.1789_JPRB, 0.4257_JPRB, 0.5698_JPRB, 0.7120_JPRB,&
 &0.7996_JPRB, 0.8829_JPRB, 0.8829_JPRB /)
ZOZCL(:,30, 5) = (/&
 &0.2230_JPRB, 0.2230_JPRB, 0.2099_JPRB, 0.2939_JPRB, 0.1485_JPRB, 0.1130_JPRB, 0.0840_JPRB, 0.0767_JPRB,&
 &0.0367_JPRB, 0.0658_JPRB, 0.0820_JPRB, 0.0748_JPRB, 0.1186_JPRB, 0.2669_JPRB, 0.3765_JPRB, 0.5405_JPRB,&
 &0.6006_JPRB, 0.6398_JPRB, 0.6398_JPRB /)
ZOZCL(:,31, 5) = (/&
 &0.0655_JPRB, 0.0655_JPRB, 0.0684_JPRB, 0.0817_JPRB, 0.0553_JPRB, 0.0403_JPRB, 0.0480_JPRB, 0.0450_JPRB,&
 &0.0287_JPRB, 0.0469_JPRB, 0.0673_JPRB, 0.0601_JPRB, 0.0723_JPRB, 0.0953_JPRB, 0.1043_JPRB, 0.1463_JPRB,&
 &0.2142_JPRB, 0.2053_JPRB, 0.2053_JPRB /)
ZOZCL(:,32, 5) = (/&
 &0.0340_JPRB, 0.0340_JPRB, 0.0374_JPRB, 0.0290_JPRB, 0.0324_JPRB, 0.0353_JPRB, 0.0408_JPRB, 0.0392_JPRB,&
 &0.0312_JPRB, 0.0474_JPRB, 0.0555_JPRB, 0.0564_JPRB, 0.0634_JPRB, 0.0663_JPRB, 0.0679_JPRB, 0.0658_JPRB,&
 &0.0669_JPRB, 0.0658_JPRB, 0.0658_JPRB /)
ZOZCL(:,33, 5) = (/&
 &0.0291_JPRB, 0.0291_JPRB, 0.0310_JPRB, 0.0279_JPRB, 0.0276_JPRB, 0.0307_JPRB, 0.0397_JPRB, 0.0378_JPRB,&
 &0.0271_JPRB, 0.0307_JPRB, 0.0318_JPRB, 0.0465_JPRB, 0.0547_JPRB, 0.0581_JPRB, 0.0590_JPRB, 0.0570_JPRB,&
 &0.0535_JPRB, 0.0531_JPRB, 0.0531_JPRB /)
ZOZCL(:,34, 5) = (/&
 &0.0291_JPRB, 0.0291_JPRB, 0.0310_JPRB, 0.0279_JPRB, 0.0276_JPRB, 0.0307_JPRB, 0.0397_JPRB, 0.0378_JPRB,&
 &0.0271_JPRB, 0.0307_JPRB, 0.0318_JPRB, 0.0465_JPRB, 0.0547_JPRB, 0.0581_JPRB, 0.0590_JPRB, 0.0570_JPRB,&
 &0.0535_JPRB, 0.0531_JPRB, 0.0531_JPRB /)

! Month:  6
ZOZCL(:, 1, 6) = (/&
 &0.7500_JPRB, 0.7500_JPRB, 0.7700_JPRB, 0.8700_JPRB, 0.8600_JPRB, 0.8000_JPRB, 0.7800_JPRB, 0.5900_JPRB,&
 &0.4700_JPRB, 0.4700_JPRB, 0.5400_JPRB, 0.6200_JPRB, 0.7300_JPRB, 0.8700_JPRB, 0.9400_JPRB, 0.8800_JPRB,&
 &0.7200_JPRB, 0.5700_JPRB, 0.5700_JPRB /)
ZOZCL(:, 2, 6) = (/&
 &0.4700_JPRB, 0.4700_JPRB, 0.4800_JPRB, 0.5400_JPRB, 0.5400_JPRB, 0.5000_JPRB, 0.5000_JPRB, 0.3800_JPRB,&
 &0.3400_JPRB, 0.3800_JPRB, 0.4100_JPRB, 0.4300_JPRB, 0.5100_JPRB, 0.6300_JPRB, 0.6300_JPRB, 0.5000_JPRB,&
 &0.3900_JPRB, 0.3200_JPRB, 0.3200_JPRB /)
ZOZCL(:, 3, 6) = (/&
 &0.3300_JPRB, 0.3300_JPRB, 0.3400_JPRB, 0.3800_JPRB, 0.3700_JPRB, 0.3500_JPRB, 0.3700_JPRB, 0.3400_JPRB,&
 &0.3500_JPRB, 0.3800_JPRB, 0.3800_JPRB, 0.3600_JPRB, 0.3800_JPRB, 0.4600_JPRB, 0.4200_JPRB, 0.3000_JPRB,&
 &0.2500_JPRB, 0.2200_JPRB, 0.2200_JPRB /)
ZOZCL(:, 4, 6) = (/&
 &0.2500_JPRB, 0.2500_JPRB, 0.2600_JPRB, 0.2900_JPRB, 0.2900_JPRB, 0.2600_JPRB, 0.2900_JPRB, 0.3000_JPRB,&
 &0.3100_JPRB, 0.3100_JPRB, 0.3000_JPRB, 0.2800_JPRB, 0.2700_JPRB, 0.2800_JPRB, 0.2500_JPRB, 0.1900_JPRB,&
 &0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB /)
ZOZCL(:, 5, 6) = (/&
 &0.2000_JPRB, 0.2000_JPRB, 0.2000_JPRB, 0.2300_JPRB, 0.2200_JPRB, 0.2100_JPRB, 0.2200_JPRB, 0.2100_JPRB,&
 &0.2000_JPRB, 0.1900_JPRB, 0.1900_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1800_JPRB, 0.1800_JPRB, 0.1700_JPRB,&
 &0.1600_JPRB, 0.1600_JPRB, 0.1600_JPRB /)
ZOZCL(:, 6, 6) = (/&
 &0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.2000_JPRB, 0.1900_JPRB, 0.1800_JPRB, 0.1700_JPRB, 0.1600_JPRB,&
 &0.1500_JPRB, 0.1400_JPRB, 0.1500_JPRB, 0.1400_JPRB, 0.1400_JPRB, 0.1600_JPRB, 0.1700_JPRB, 0.1700_JPRB,&
 &0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB /)
ZOZCL(:, 7, 6) = (/&
 &0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.2000_JPRB, 0.1900_JPRB, 0.1800_JPRB, 0.1700_JPRB, 0.1700_JPRB,&
 &0.1600_JPRB, 0.1600_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1900_JPRB, 0.2000_JPRB, 0.2000_JPRB,&
 &0.2000_JPRB, 0.2000_JPRB, 0.2000_JPRB /)
ZOZCL(:, 8, 6) = (/&
 &0.2900_JPRB, 0.2900_JPRB, 0.3000_JPRB, 0.3400_JPRB, 0.3300_JPRB, 0.3100_JPRB, 0.3000_JPRB, 0.2800_JPRB,&
 &0.2600_JPRB, 0.2600_JPRB, 0.2600_JPRB, 0.2600_JPRB, 0.2700_JPRB, 0.2700_JPRB, 0.2800_JPRB, 0.2700_JPRB,&
 &0.2800_JPRB, 0.3000_JPRB, 0.3000_JPRB /)
ZOZCL(:, 9, 6) = (/&
 &0.4200_JPRB, 0.4200_JPRB, 0.4300_JPRB, 0.4900_JPRB, 0.4800_JPRB, 0.4500_JPRB, 0.4500_JPRB, 0.4100_JPRB,&
 &0.3800_JPRB, 0.3700_JPRB, 0.3700_JPRB, 0.3800_JPRB, 0.3900_JPRB, 0.3800_JPRB, 0.3800_JPRB, 0.3800_JPRB,&
 &0.3900_JPRB, 0.4000_JPRB, 0.4000_JPRB /)
ZOZCL(:,10, 6) = (/&
 &0.5400_JPRB, 0.5400_JPRB, 0.5600_JPRB, 0.6300_JPRB, 0.6200_JPRB, 0.5700_JPRB, 0.5600_JPRB, 0.5600_JPRB,&
 &0.5600_JPRB, 0.5700_JPRB, 0.5800_JPRB, 0.5800_JPRB, 0.5500_JPRB, 0.5200_JPRB, 0.5300_JPRB, 0.5600_JPRB,&
 &0.5500_JPRB, 0.5600_JPRB, 0.5600_JPRB /)
ZOZCL(:,11, 6) = (/&
 &0.7600_JPRB, 0.7600_JPRB, 0.7900_JPRB, 0.8900_JPRB, 0.8800_JPRB, 0.8200_JPRB, 0.8200_JPRB, 0.8300_JPRB,&
 &0.8300_JPRB, 0.8300_JPRB, 0.8500_JPRB, 0.8800_JPRB, 0.8400_JPRB, 0.8000_JPRB, 0.8000_JPRB, 0.8000_JPRB,&
 &0.8000_JPRB, 0.7800_JPRB, 0.7800_JPRB /)
ZOZCL(:,12, 6) = (/&
 &0.9900_JPRB, 0.9900_JPRB, 1.0200_JPRB, 1.1500_JPRB, 1.1400_JPRB, 1.0600_JPRB, 1.0400_JPRB, 1.0500_JPRB,&
 &1.0600_JPRB, 1.0600_JPRB, 1.0800_JPRB, 1.1100_JPRB, 1.0800_JPRB, 1.0300_JPRB, 1.0100_JPRB, 0.9900_JPRB,&
 &0.9600_JPRB, 0.9300_JPRB, 0.9300_JPRB /)
ZOZCL(:,13, 6) = (/&
 &1.4300_JPRB, 1.4300_JPRB, 1.4700_JPRB, 1.6700_JPRB, 1.6400_JPRB, 1.5300_JPRB, 1.4400_JPRB, 1.4400_JPRB,&
 &1.4700_JPRB, 1.4700_JPRB, 1.4800_JPRB, 1.4900_JPRB, 1.4400_JPRB, 1.3900_JPRB, 1.3500_JPRB, 1.3000_JPRB,&
 &1.2400_JPRB, 1.1800_JPRB, 1.1800_JPRB /)
ZOZCL(:,14, 6) = (/&
 &2.1000_JPRB, 2.1000_JPRB, 2.1700_JPRB, 2.4600_JPRB, 2.4200_JPRB, 2.2600_JPRB, 2.0200_JPRB, 1.9800_JPRB,&
 &2.0000_JPRB, 2.0000_JPRB, 1.9900_JPRB, 1.9800_JPRB, 1.9500_JPRB, 1.8700_JPRB, 1.7800_JPRB, 1.6700_JPRB,&
 &1.5500_JPRB, 1.4600_JPRB, 1.4600_JPRB /)
ZOZCL(:,15, 6) = (/&
 &2.8600_JPRB, 2.8600_JPRB, 2.9400_JPRB, 3.5600_JPRB, 3.5400_JPRB, 2.9600_JPRB, 2.5600_JPRB, 2.4600_JPRB,&
 &2.4600_JPRB, 2.4600_JPRB, 2.4500_JPRB, 2.4400_JPRB, 2.4100_JPRB, 2.3000_JPRB, 2.1600_JPRB, 1.9900_JPRB,&
 &1.8300_JPRB, 1.7100_JPRB, 1.7100_JPRB /)
ZOZCL(:,16, 6) = (/&
 &3.9200_JPRB, 3.9200_JPRB, 4.0200_JPRB, 5.0100_JPRB, 5.1600_JPRB, 4.2900_JPRB, 3.5600_JPRB, 3.3000_JPRB,&
 &3.2200_JPRB, 3.1900_JPRB, 3.1600_JPRB, 3.1300_JPRB, 3.0500_JPRB, 2.8800_JPRB, 2.6800_JPRB, 2.4700_JPRB,&
 &2.2800_JPRB, 2.1600_JPRB, 2.1600_JPRB /)
ZOZCL(:,17, 6) = (/&
 &5.1400_JPRB, 5.1400_JPRB, 5.2800_JPRB, 6.5000_JPRB, 7.1100_JPRB, 6.1800_JPRB, 5.0600_JPRB, 4.5100_JPRB,&
 &4.3000_JPRB, 4.2400_JPRB, 4.1900_JPRB, 4.1500_JPRB, 3.9800_JPRB, 3.7300_JPRB, 3.4900_JPRB, 3.2400_JPRB,&
 &3.0500_JPRB, 2.9700_JPRB, 2.9700_JPRB /) 

ZOZCL(:,18, 6) = (/&
 &5.5200_JPRB, 5.5200_JPRB, 5.6800_JPRB, 6.7700_JPRB, 7.7400_JPRB, 7.2700_JPRB, 6.1600_JPRB, 5.5500_JPRB,&
 &5.3000_JPRB, 5.2300_JPRB, 5.2100_JPRB, 5.2000_JPRB, 5.0100_JPRB, 4.7300_JPRB, 4.4900_JPRB, 4.2400_JPRB,&
 &4.0500_JPRB, 4.0300_JPRB, 4.0300_JPRB /)
ZOZCL(:,19, 6) = (/&
 &5.3000_JPRB, 5.3000_JPRB, 5.4800_JPRB, 6.2000_JPRB, 7.3600_JPRB, 7.9600_JPRB, 7.4300_JPRB, 7.0500_JPRB,&
 &6.9100_JPRB, 6.8800_JPRB, 6.9400_JPRB, 7.0200_JPRB, 6.8400_JPRB, 6.5900_JPRB, 6.3800_JPRB, 6.0700_JPRB,&
 &5.8300_JPRB, 5.8700_JPRB, 5.8700_JPRB /)
ZOZCL(:,20, 6) = (/&
 &4.7300_JPRB, 4.7300_JPRB, 4.9300_JPRB, 5.6400_JPRB, 6.3100_JPRB, 7.4700_JPRB, 7.8600_JPRB, 8.1400_JPRB,&
 &8.4500_JPRB, 8.4900_JPRB, 8.5700_JPRB, 8.5600_JPRB, 8.3800_JPRB, 8.1600_JPRB, 7.8800_JPRB, 7.1400_JPRB,&
 &6.3500_JPRB, 6.0800_JPRB, 6.0800_JPRB /)
ZOZCL(:,21, 6) = (/&
 &4.3200_JPRB, 4.3200_JPRB, 4.5000_JPRB, 5.3200_JPRB, 5.7000_JPRB, 6.9600_JPRB, 7.7100_JPRB, 8.4200_JPRB,&
 &8.9600_JPRB, 9.1200_JPRB, 9.1600_JPRB, 8.9800_JPRB, 8.8100_JPRB, 8.4600_JPRB, 7.9800_JPRB, 7.0100_JPRB,&
 &5.9300_JPRB, 5.3700_JPRB, 5.3700_JPRB /)
ZOZCL(:,22, 6) = (/&
 &3.9400_JPRB, 3.9400_JPRB, 4.0500_JPRB, 5.0200_JPRB, 5.1000_JPRB, 6.3100_JPRB, 7.1900_JPRB, 8.2200_JPRB,&
 &9.0000_JPRB, 9.2500_JPRB, 9.1600_JPRB, 8.6800_JPRB, 8.5500_JPRB, 8.0800_JPRB, 7.4800_JPRB, 6.5100_JPRB,&
 &5.4300_JPRB, 4.7100_JPRB, 4.7100_JPRB /)
ZOZCL(:,23, 6) = (/&
 &3.7800_JPRB, 3.7800_JPRB, 3.8600_JPRB, 4.8200_JPRB, 5.0700_JPRB, 5.8700_JPRB, 6.4500_JPRB, 7.2000_JPRB,&
 &7.7800_JPRB, 8.0500_JPRB, 7.9600_JPRB, 7.5000_JPRB, 7.4100_JPRB, 7.0200_JPRB, 6.4900_JPRB, 5.6900_JPRB,&
 &4.7500_JPRB, 4.1800_JPRB, 4.1800_JPRB /)
ZOZCL(:,24, 6) = (/&
 &3.7000_JPRB, 3.7000_JPRB, 3.7900_JPRB, 4.6800_JPRB, 5.0000_JPRB, 5.5100_JPRB, 5.7800_JPRB, 6.1900_JPRB,&
 &6.4500_JPRB, 6.6400_JPRB, 6.6800_JPRB, 6.4200_JPRB, 6.4300_JPRB, 6.2200_JPRB, 5.8200_JPRB, 5.1700_JPRB,&
 &4.3800_JPRB, 3.9400_JPRB, 3.9400_JPRB /)
ZOZCL(:,25, 6) = (/&
 &3.2554_JPRB, 3.2554_JPRB, 3.5115_JPRB, 3.8000_JPRB, 4.5633_JPRB, 4.9030_JPRB, 4.8933_JPRB, 4.6000_JPRB,&
 &4.3704_JPRB, 4.5273_JPRB, 4.8100_JPRB, 4.8000_JPRB, 4.8910_JPRB, 4.8032_JPRB, 4.4982_JPRB, 4.1575_JPRB,&
 &3.6667_JPRB, 3.5714_JPRB, 3.5714_JPRB /)
ZOZCL(:,26, 6) = (/&
 &2.8571_JPRB, 2.8571_JPRB, 2.7376_JPRB, 2.9200_JPRB, 2.5300_JPRB, 2.6316_JPRB, 2.1180_JPRB, 1.9200_JPRB,&
 &1.5042_JPRB, 1.5932_JPRB, 1.8100_JPRB, 2.1200_JPRB, 2.3813_JPRB, 2.7239_JPRB, 2.8073_JPRB, 2.9790_JPRB,&
 &2.8574_JPRB, 2.9008_JPRB, 2.9008_JPRB /)
ZOZCL(:,27, 6) = (/&
 &2.1443_JPRB, 2.1443_JPRB, 2.0070_JPRB, 2.0500_JPRB, 1.5029_JPRB, 1.5219_JPRB, 0.7621_JPRB, 0.7800_JPRB,&
 &0.4756_JPRB, 0.5596_JPRB, 0.6700_JPRB, 0.9900_JPRB, 1.0350_JPRB, 1.4139_JPRB, 1.6538_JPRB, 1.9796_JPRB,&
 &2.0081_JPRB, 2.1384_JPRB, 2.1384_JPRB /)
ZOZCL(:,28, 6) = (/&
 &1.1405_JPRB, 1.1405_JPRB, 1.0828_JPRB, 0.9800_JPRB, 0.7300_JPRB, 0.6089_JPRB, 0.2110_JPRB, 0.1911_JPRB,&
 &0.1132_JPRB, 0.1752_JPRB, 0.1830_JPRB, 0.2386_JPRB, 0.2869_JPRB, 0.5876_JPRB, 0.8400_JPRB, 1.0000_JPRB,&
 &1.1505_JPRB, 1.1950_JPRB, 1.1950_JPRB /)
ZOZCL(:,29, 6) = (/&
 &0.4485_JPRB, 0.4485_JPRB, 0.3870_JPRB, 0.4187_JPRB, 0.3760_JPRB, 0.3635_JPRB, 0.1067_JPRB, 0.0965_JPRB,&
 &0.0605_JPRB, 0.1267_JPRB, 0.1067_JPRB, 0.1310_JPRB, 0.1509_JPRB, 0.3484_JPRB, 0.4746_JPRB, 0.5433_JPRB,&
 &0.6391_JPRB, 0.6481_JPRB, 0.6481_JPRB /)
ZOZCL(:,30, 6) = (/&
 &0.2079_JPRB, 0.2079_JPRB, 0.1828_JPRB, 0.2929_JPRB, 0.2540_JPRB, 0.2042_JPRB, 0.0855_JPRB, 0.0775_JPRB,&
 &0.0487_JPRB, 0.0990_JPRB, 0.0900_JPRB, 0.0729_JPRB, 0.1079_JPRB, 0.1876_JPRB, 0.3129_JPRB, 0.4250_JPRB,&
 &0.5245_JPRB, 0.5229_JPRB, 0.5229_JPRB /)
ZOZCL(:,31, 6) = (/&
 &0.0536_JPRB, 0.0536_JPRB, 0.0557_JPRB, 0.0413_JPRB, 0.0500_JPRB, 0.0645_JPRB, 0.0503_JPRB, 0.0490_JPRB,&
 &0.0452_JPRB, 0.0680_JPRB, 0.0700_JPRB, 0.0552_JPRB, 0.0754_JPRB, 0.0816_JPRB, 0.1056_JPRB, 0.1360_JPRB,&
 &0.1443_JPRB, 0.1905_JPRB, 0.1905_JPRB /)
ZOZCL(:,32, 6) = (/&
 &0.0372_JPRB, 0.0372_JPRB, 0.0384_JPRB, 0.0340_JPRB, 0.0340_JPRB, 0.0406_JPRB, 0.0426_JPRB, 0.0422_JPRB,&
 &0.0413_JPRB, 0.0520_JPRB, 0.0490_JPRB, 0.0509_JPRB, 0.0590_JPRB, 0.0627_JPRB, 0.0704_JPRB, 0.0678_JPRB,&
 &0.0703_JPRB, 0.0628_JPRB, 0.0628_JPRB /)
ZOZCL(:,33, 6) = (/&
 &0.0315_JPRB, 0.0315_JPRB, 0.0332_JPRB, 0.0326_JPRB, 0.0304_JPRB, 0.0351_JPRB, 0.0373_JPRB, 0.0363_JPRB,&
 &0.0331_JPRB, 0.0377_JPRB, 0.0279_JPRB, 0.0438_JPRB, 0.0537_JPRB, 0.0538_JPRB, 0.0587_JPRB, 0.0533_JPRB,&
 &0.0534_JPRB, 0.0438_JPRB, 0.0438_JPRB /)
ZOZCL(:,34, 6) = (/&
 &0.0315_JPRB, 0.0315_JPRB, 0.0332_JPRB, 0.0326_JPRB, 0.0304_JPRB, 0.0351_JPRB, 0.0373_JPRB, 0.0363_JPRB,&
 &0.0331_JPRB, 0.0377_JPRB, 0.0279_JPRB, 0.0438_JPRB, 0.0537_JPRB, 0.0538_JPRB, 0.0587_JPRB, 0.0533_JPRB,&
 &0.0534_JPRB, 0.0438_JPRB, 0.0438_JPRB /) 

! Month:  7
ZOZCL(:, 1, 7) = (/&
 &0.4800_JPRB, 0.4800_JPRB, 0.5100_JPRB, 0.5600_JPRB, 0.5800_JPRB, 0.6600_JPRB, 0.6300_JPRB, 0.5300_JPRB,&
 &0.4800_JPRB, 0.4700_JPRB, 0.5100_JPRB, 0.6000_JPRB, 0.6600_JPRB, 0.7100_JPRB, 0.8500_JPRB, 0.9300_JPRB,&
 &0.8000_JPRB, 0.5800_JPRB, 0.5800_JPRB /)
ZOZCL(:, 2, 7) = (/&
 &0.2800_JPRB, 0.2800_JPRB, 0.3000_JPRB, 0.3300_JPRB, 0.3400_JPRB, 0.4100_JPRB, 0.4100_JPRB, 0.3700_JPRB,&
 &0.3400_JPRB, 0.3700_JPRB, 0.4000_JPRB, 0.4200_JPRB, 0.4400_JPRB, 0.4900_JPRB, 0.5500_JPRB, 0.5200_JPRB,&
 &0.4000_JPRB, 0.3100_JPRB, 0.3100_JPRB /)
ZOZCL(:, 3, 7) = (/&
 &0.2000_JPRB, 0.2000_JPRB, 0.2100_JPRB, 0.2300_JPRB, 0.2400_JPRB, 0.2800_JPRB, 0.3200_JPRB, 0.3200_JPRB,&
 &0.3300_JPRB, 0.3500_JPRB, 0.3600_JPRB, 0.3500_JPRB, 0.3400_JPRB, 0.3600_JPRB, 0.3700_JPRB, 0.3000_JPRB,&
 &0.2300_JPRB, 0.2100_JPRB, 0.2100_JPRB /)
ZOZCL(:, 4, 7) = (/&
 &0.1700_JPRB, 0.1700_JPRB, 0.1800_JPRB, 0.1900_JPRB, 0.2000_JPRB, 0.2300_JPRB, 0.2700_JPRB, 0.2800_JPRB,&
 &0.2800_JPRB, 0.2800_JPRB, 0.2700_JPRB, 0.2500_JPRB, 0.2400_JPRB, 0.2400_JPRB, 0.2200_JPRB, 0.1900_JPRB,&
 &0.1600_JPRB, 0.1700_JPRB, 0.1700_JPRB /)
ZOZCL(:, 5, 7) = (/&
 &0.1700_JPRB, 0.1700_JPRB, 0.1900_JPRB, 0.2000_JPRB, 0.2100_JPRB, 0.2000_JPRB, 0.2000_JPRB, 0.1900_JPRB,&
 &0.1700_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1600_JPRB,&
 &0.1600_JPRB, 0.1600_JPRB, 0.1600_JPRB /)
ZOZCL(:, 6, 7) = (/&
 &0.1700_JPRB, 0.1700_JPRB, 0.1900_JPRB, 0.2000_JPRB, 0.2100_JPRB, 0.1700_JPRB, 0.1600_JPRB, 0.1500_JPRB,&
 &0.1400_JPRB, 0.1400_JPRB, 0.1400_JPRB, 0.1400_JPRB, 0.1400_JPRB, 0.1500_JPRB, 0.1600_JPRB, 0.1700_JPRB,&
 &0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB /)
ZOZCL(:, 7, 7) = (/&
 &0.1800_JPRB, 0.1800_JPRB, 0.1900_JPRB, 0.2100_JPRB, 0.2200_JPRB, 0.1700_JPRB, 0.1600_JPRB, 0.1600_JPRB,&
 &0.1600_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1800_JPRB, 0.1900_JPRB, 0.2000_JPRB,&
 &0.2000_JPRB, 0.2100_JPRB, 0.2100_JPRB /)
ZOZCL(:, 8, 7) = (/&
 &0.2600_JPRB, 0.2600_JPRB, 0.2700_JPRB, 0.3000_JPRB, 0.3100_JPRB, 0.3100_JPRB, 0.2900_JPRB, 0.2600_JPRB,&
 &0.2500_JPRB, 0.2500_JPRB, 0.2500_JPRB, 0.2400_JPRB, 0.2400_JPRB, 0.2700_JPRB, 0.2800_JPRB, 0.2800_JPRB,&
 &0.2800_JPRB, 0.3100_JPRB, 0.3100_JPRB /)
ZOZCL(:, 9, 7) = (/&
 &0.3600_JPRB, 0.3600_JPRB, 0.3800_JPRB, 0.4100_JPRB, 0.4300_JPRB, 0.4600_JPRB, 0.4400_JPRB, 0.3900_JPRB,&
 &0.3600_JPRB, 0.3600_JPRB, 0.3500_JPRB, 0.3500_JPRB, 0.3600_JPRB, 0.3900_JPRB, 0.3900_JPRB, 0.3800_JPRB,&
 &0.3800_JPRB, 0.4100_JPRB, 0.4100_JPRB /)
ZOZCL(:,10, 7) = (/&
 &0.5100_JPRB, 0.5100_JPRB, 0.5400_JPRB, 0.5800_JPRB, 0.6100_JPRB, 0.6000_JPRB, 0.6000_JPRB, 0.5600_JPRB,&
 &0.5500_JPRB, 0.5500_JPRB, 0.5600_JPRB, 0.5700_JPRB, 0.5700_JPRB, 0.5500_JPRB, 0.5500_JPRB, 0.5700_JPRB,&
 &0.5500_JPRB, 0.5600_JPRB, 0.5600_JPRB /)
ZOZCL(:,11, 7) = (/&
 &0.7400_JPRB, 0.7400_JPRB, 0.7900_JPRB, 0.8500_JPRB, 0.8900_JPRB, 0.8500_JPRB, 0.8600_JPRB, 0.8300_JPRB,&
 &0.8100_JPRB, 0.8100_JPRB, 0.8300_JPRB, 0.8700_JPRB, 0.8800_JPRB, 0.8500_JPRB, 0.8200_JPRB, 0.8100_JPRB,&
 &0.8100_JPRB, 0.7900_JPRB, 0.7900_JPRB /)
ZOZCL(:,12, 7) = (/&
 &0.9400_JPRB, 0.9400_JPRB, 1.0100_JPRB, 1.0900_JPRB, 1.1400_JPRB, 1.0900_JPRB, 1.0800_JPRB, 1.0500_JPRB,&
 &1.0400_JPRB, 1.0400_JPRB, 1.0600_JPRB, 1.1100_JPRB, 1.1200_JPRB, 1.0900_JPRB, 1.0400_JPRB, 1.0000_JPRB,&
 &0.9800_JPRB, 0.9500_JPRB, 0.9500_JPRB /)
ZOZCL(:,13, 7) = (/&
 &1.2200_JPRB, 1.2200_JPRB, 1.3000_JPRB, 1.4100_JPRB, 1.4700_JPRB, 1.5300_JPRB, 1.4900_JPRB, 1.4500_JPRB,&
 &1.4400_JPRB, 1.4400_JPRB, 1.4600_JPRB, 1.5000_JPRB, 1.5100_JPRB, 1.4600_JPRB, 1.3900_JPRB, 1.3200_JPRB,&
 &1.2600_JPRB, 1.1900_JPRB, 1.1900_JPRB /)
ZOZCL(:,14, 7) = (/&
 &1.7700_JPRB, 1.7700_JPRB, 1.8900_JPRB, 2.0500_JPRB, 2.1400_JPRB, 2.2200_JPRB, 2.0700_JPRB, 2.0000_JPRB,&
 &1.9900_JPRB, 1.9900_JPRB, 1.9900_JPRB, 2.0000_JPRB, 2.0000_JPRB, 1.9300_JPRB, 1.8100_JPRB, 1.6800_JPRB,&
 &1.5500_JPRB, 1.4400_JPRB, 1.4400_JPRB /)
ZOZCL(:,15, 7) = (/&
 &2.3400_JPRB, 2.3400_JPRB, 2.4900_JPRB, 2.8500_JPRB, 3.0300_JPRB, 2.8600_JPRB, 2.6000_JPRB, 2.4800_JPRB,&
 &2.4400_JPRB, 2.4400_JPRB, 2.4400_JPRB, 2.4800_JPRB, 2.4900_JPRB, 2.3900_JPRB, 2.2000_JPRB, 2.0000_JPRB,&
 &1.8200_JPRB, 1.6600_JPRB, 1.6600_JPRB /)
ZOZCL(:,16, 7) = (/&
 &3.3100_JPRB, 3.3100_JPRB, 3.4800_JPRB, 4.0600_JPRB, 4.4000_JPRB, 4.0500_JPRB, 3.5800_JPRB, 3.3400_JPRB,&
 &3.2300_JPRB, 3.1900_JPRB, 3.1800_JPRB, 3.2200_JPRB, 3.1900_JPRB, 3.0100_JPRB, 2.7600_JPRB, 2.5200_JPRB,&
 &2.3000_JPRB, 2.1400_JPRB, 2.1400_JPRB /)
ZOZCL(:,17, 7) = (/&
 &4.5300_JPRB, 4.5300_JPRB, 4.8100_JPRB, 5.6200_JPRB, 6.2800_JPRB, 5.7600_JPRB, 5.0400_JPRB, 4.6100_JPRB,&
 &4.3900_JPRB, 4.3100_JPRB, 4.2900_JPRB, 4.3100_JPRB, 4.1800_JPRB, 3.9100_JPRB, 3.6100_JPRB, 3.3200_JPRB,&
 &3.0800_JPRB, 2.9700_JPRB, 2.9700_JPRB /) 

ZOZCL(:,18, 7) = (/&
 &5.0800_JPRB, 5.0800_JPRB, 5.4400_JPRB, 6.2400_JPRB, 7.1700_JPRB, 6.8600_JPRB, 6.1300_JPRB, 5.6900_JPRB,&
 &5.4700_JPRB, 5.3800_JPRB, 5.3700_JPRB, 5.3800_JPRB, 5.2000_JPRB, 4.9000_JPRB, 4.5900_JPRB, 4.2800_JPRB,&
 &4.0300_JPRB, 3.9700_JPRB, 3.9700_JPRB /)
ZOZCL(:,19, 7) = (/&
 &5.2800_JPRB, 5.2800_JPRB, 5.5700_JPRB, 6.2200_JPRB, 7.3900_JPRB, 7.7900_JPRB, 7.4300_JPRB, 7.2300_JPRB,&
 &7.1600_JPRB, 7.1200_JPRB, 7.1500_JPRB, 7.1800_JPRB, 6.9800_JPRB, 6.6800_JPRB, 6.3700_JPRB, 6.0000_JPRB,&
 &5.6600_JPRB, 5.6400_JPRB, 5.6400_JPRB /)
ZOZCL(:,20, 7) = (/&
 &5.0800_JPRB, 5.0800_JPRB, 5.2300_JPRB, 5.7900_JPRB, 6.6700_JPRB, 7.5300_JPRB, 7.9200_JPRB, 8.2000_JPRB,&
 &8.6400_JPRB, 8.6300_JPRB, 8.6100_JPRB, 8.6300_JPRB, 8.3900_JPRB, 8.0600_JPRB, 7.7000_JPRB, 6.9900_JPRB,&
 &6.1400_JPRB, 5.8400_JPRB, 5.8400_JPRB /)
ZOZCL(:,21, 7) = (/&
 &4.7200_JPRB, 4.7200_JPRB, 4.8100_JPRB, 5.3900_JPRB, 6.0700_JPRB, 7.0900_JPRB, 7.8200_JPRB, 8.3200_JPRB,&
 &8.9500_JPRB, 9.0900_JPRB, 9.1600_JPRB, 9.0100_JPRB, 8.8100_JPRB, 8.3800_JPRB, 7.7900_JPRB, 6.8600_JPRB,&
 &5.7500_JPRB, 5.1800_JPRB, 5.1800_JPRB /)
ZOZCL(:,22, 7) = (/&
 &4.1900_JPRB, 4.1900_JPRB, 4.2800_JPRB, 4.9800_JPRB, 5.4600_JPRB, 6.4700_JPRB, 7.3400_JPRB, 7.9800_JPRB,&
 &8.8100_JPRB, 9.0200_JPRB, 9.1000_JPRB, 8.7200_JPRB, 8.5500_JPRB, 8.0400_JPRB, 7.2800_JPRB, 6.3300_JPRB,&
 &5.2300_JPRB, 4.5000_JPRB, 4.5000_JPRB /)
ZOZCL(:,23, 7) = (/&
 &3.8200_JPRB, 3.8200_JPRB, 3.9700_JPRB, 4.7400_JPRB, 5.2600_JPRB, 5.9600_JPRB, 6.5700_JPRB, 6.9900_JPRB,&
 &7.5400_JPRB, 7.7800_JPRB, 7.9000_JPRB, 7.5300_JPRB, 7.4000_JPRB, 6.9700_JPRB, 6.3300_JPRB, 5.5000_JPRB,&
 &4.5300_JPRB, 3.9400_JPRB, 3.9400_JPRB /)
ZOZCL(:,24, 7) = (/&
 &3.7100_JPRB, 3.7100_JPRB, 3.8900_JPRB, 4.6500_JPRB, 5.1700_JPRB, 5.6000_JPRB, 5.9100_JPRB, 6.0600_JPRB,&
 &6.2700_JPRB, 6.4500_JPRB, 6.6600_JPRB, 6.4300_JPRB, 6.3800_JPRB, 6.1300_JPRB, 5.6600_JPRB, 4.9800_JPRB,&
 &4.1400_JPRB, 3.6800_JPRB, 3.6800_JPRB /)
ZOZCL(:,25, 7) = (/&
 &3.4701_JPRB, 3.4701_JPRB, 3.5162_JPRB, 3.9933_JPRB, 4.6133_JPRB, 5.0536_JPRB, 4.9825_JPRB, 4.5500_JPRB,&
 &4.1718_JPRB, 4.4264_JPRB, 4.7800_JPRB, 4.8400_JPRB, 4.8924_JPRB, 4.7025_JPRB, 4.4212_JPRB, 3.9383_JPRB,&
 &3.5126_JPRB, 3.1965_JPRB, 3.1965_JPRB /)
ZOZCL(:,26, 7) = (/&
 &2.9388_JPRB, 2.9388_JPRB, 2.7899_JPRB, 2.9840_JPRB, 2.7140_JPRB, 2.9684_JPRB, 2.3390_JPRB, 2.0700_JPRB,&
 &1.6414_JPRB, 1.6086_JPRB, 1.9200_JPRB, 2.1400_JPRB, 2.2499_JPRB, 2.5745_JPRB, 2.6698_JPRB, 2.7470_JPRB,&
 &2.6827_JPRB, 2.6723_JPRB, 2.6723_JPRB /)
ZOZCL(:,27, 7) = (/&
 &1.9786_JPRB, 1.9786_JPRB, 2.0127_JPRB, 2.0657_JPRB, 1.6057_JPRB, 1.6493_JPRB, 0.8961_JPRB, 0.8600_JPRB,&
 &0.5157_JPRB, 0.5622_JPRB, 0.8200_JPRB, 1.0500_JPRB, 0.9857_JPRB, 1.2802_JPRB, 1.5339_JPRB, 1.8314_JPRB,&
 &1.8882_JPRB, 2.0093_JPRB, 2.0093_JPRB /)
ZOZCL(:,28, 7) = (/&
 &1.2198_JPRB, 1.2198_JPRB, 1.1289_JPRB, 0.8280_JPRB, 0.7900_JPRB, 0.6996_JPRB, 0.2260_JPRB, 0.2119_JPRB,&
 &0.1338_JPRB, 0.1909_JPRB, 0.2510_JPRB, 0.2425_JPRB, 0.2364_JPRB, 0.4753_JPRB, 0.7528_JPRB, 0.9720_JPRB,&
 &1.0715_JPRB, 1.1551_JPRB, 1.1551_JPRB /)
ZOZCL(:,29, 7) = (/&
 &0.4683_JPRB, 0.4683_JPRB, 0.4347_JPRB, 0.5000_JPRB, 0.3573_JPRB, 0.3828_JPRB, 0.1227_JPRB, 0.1129_JPRB,&
 &0.0627_JPRB, 0.0932_JPRB, 0.1120_JPRB, 0.0643_JPRB, 0.0984_JPRB, 0.2115_JPRB, 0.3913_JPRB, 0.4927_JPRB,&
 &0.5340_JPRB, 0.5590_JPRB, 0.5590_JPRB /)
ZOZCL(:,30, 7) = (/&
 &0.2218_JPRB, 0.2218_JPRB, 0.1946_JPRB, 0.3528_JPRB, 0.2505_JPRB, 0.2352_JPRB, 0.0930_JPRB, 0.0859_JPRB,&
 &0.0536_JPRB, 0.0781_JPRB, 0.0850_JPRB, 0.0484_JPRB, 0.0767_JPRB, 0.1375_JPRB, 0.2833_JPRB, 0.3725_JPRB,&
 &0.4364_JPRB, 0.4529_JPRB, 0.4529_JPRB /)
ZOZCL(:,31, 7) = (/&
 &0.0448_JPRB, 0.0448_JPRB, 0.0520_JPRB, 0.0583_JPRB, 0.0640_JPRB, 0.0620_JPRB, 0.0693_JPRB, 0.0642_JPRB,&
 &0.0442_JPRB, 0.0606_JPRB, 0.0560_JPRB, 0.0391_JPRB, 0.0618_JPRB, 0.0840_JPRB, 0.1020_JPRB, 0.1090_JPRB,&
 &0.1481_JPRB, 0.1344_JPRB, 0.1344_JPRB /)
ZOZCL(:,32, 7) = (/&
 &0.0361_JPRB, 0.0361_JPRB, 0.0398_JPRB, 0.0390_JPRB, 0.0362_JPRB, 0.0367_JPRB, 0.0572_JPRB, 0.0539_JPRB,&
 &0.0400_JPRB, 0.0499_JPRB, 0.0476_JPRB, 0.0394_JPRB, 0.0482_JPRB, 0.0667_JPRB, 0.0718_JPRB, 0.0686_JPRB,&
 &0.0652_JPRB, 0.0560_JPRB, 0.0560_JPRB /)
ZOZCL(:,33, 7) = (/&
 &0.0312_JPRB, 0.0312_JPRB, 0.0337_JPRB, 0.0334_JPRB, 0.0329_JPRB, 0.0350_JPRB, 0.0493_JPRB, 0.0465_JPRB,&
 &0.0319_JPRB, 0.0340_JPRB, 0.0307_JPRB, 0.0343_JPRB, 0.0299_JPRB, 0.0549_JPRB, 0.0563_JPRB, 0.0479_JPRB,&
 &0.0495_JPRB, 0.0394_JPRB, 0.0394_JPRB /)
ZOZCL(:,34, 7) = (/&
 &0.0312_JPRB, 0.0312_JPRB, 0.0337_JPRB, 0.0334_JPRB, 0.0329_JPRB, 0.0350_JPRB, 0.0493_JPRB, 0.0465_JPRB,&
 &0.0319_JPRB, 0.0340_JPRB, 0.0307_JPRB, 0.0343_JPRB, 0.0299_JPRB, 0.0549_JPRB, 0.0563_JPRB, 0.0479_JPRB,&
 &0.0495_JPRB, 0.0394_JPRB, 0.0394_JPRB /) 

! Month:  8
ZOZCL(:, 1, 8) = (/&
 &0.6000_JPRB, 0.6000_JPRB, 0.6200_JPRB, 0.6200_JPRB, 0.6600_JPRB, 0.6900_JPRB, 0.6700_JPRB, 0.6100_JPRB,&
 &0.6000_JPRB, 0.6100_JPRB, 0.6200_JPRB, 0.6500_JPRB, 0.6800_JPRB, 0.6700_JPRB, 0.6400_JPRB, 0.6700_JPRB,&
 &0.6000_JPRB, 0.4400_JPRB, 0.4400_JPRB /)
ZOZCL(:, 2, 8) = (/&
 &0.3600_JPRB, 0.3600_JPRB, 0.3700_JPRB, 0.3700_JPRB, 0.4000_JPRB, 0.4300_JPRB, 0.4300_JPRB, 0.4100_JPRB,&
 &0.4000_JPRB, 0.4000_JPRB, 0.4100_JPRB, 0.4400_JPRB, 0.4600_JPRB, 0.4300_JPRB, 0.4100_JPRB, 0.4100_JPRB,&
 &0.3500_JPRB, 0.2400_JPRB, 0.2400_JPRB /)
ZOZCL(:, 3, 8) = (/&
 &0.2500_JPRB, 0.2500_JPRB, 0.2600_JPRB, 0.2600_JPRB, 0.2900_JPRB, 0.3200_JPRB, 0.3400_JPRB, 0.3500_JPRB,&
 &0.3500_JPRB, 0.3600_JPRB, 0.3600_JPRB, 0.3800_JPRB, 0.3600_JPRB, 0.3200_JPRB, 0.2900_JPRB, 0.2800_JPRB,&
 &0.2200_JPRB, 0.1800_JPRB, 0.1800_JPRB /)
ZOZCL(:, 4, 8) = (/&
 &0.2200_JPRB, 0.2200_JPRB, 0.2300_JPRB, 0.2200_JPRB, 0.2500_JPRB, 0.2800_JPRB, 0.3000_JPRB, 0.3100_JPRB,&
 &0.3100_JPRB, 0.2900_JPRB, 0.2900_JPRB, 0.3100_JPRB, 0.2700_JPRB, 0.2300_JPRB, 0.2000_JPRB, 0.1700_JPRB,&
 &0.1500_JPRB, 0.1400_JPRB, 0.1400_JPRB /)
ZOZCL(:, 5, 8) = (/&
 &0.2400_JPRB, 0.2400_JPRB, 0.2500_JPRB, 0.2500_JPRB, 0.2300_JPRB, 0.2300_JPRB, 0.2400_JPRB, 0.2200_JPRB,&
 &0.1900_JPRB, 0.1800_JPRB, 0.1800_JPRB, 0.1900_JPRB, 0.1700_JPRB, 0.1600_JPRB, 0.1500_JPRB, 0.1400_JPRB,&
 &0.1400_JPRB, 0.1300_JPRB, 0.1300_JPRB /)
ZOZCL(:, 6, 8) = (/&
 &0.2300_JPRB, 0.2300_JPRB, 0.2400_JPRB, 0.2400_JPRB, 0.2000_JPRB, 0.1900_JPRB, 0.1800_JPRB, 0.1600_JPRB,&
 &0.1400_JPRB, 0.1400_JPRB, 0.1400_JPRB, 0.1500_JPRB, 0.1400_JPRB, 0.1400_JPRB, 0.1400_JPRB, 0.1400_JPRB,&
 &0.1500_JPRB, 0.1500_JPRB, 0.1500_JPRB /)
ZOZCL(:, 7, 8) = (/&
 &0.2300_JPRB, 0.2300_JPRB, 0.2400_JPRB, 0.2400_JPRB, 0.1900_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB,&
 &0.1600_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1700_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1700_JPRB, 0.1800_JPRB,&
 &0.1800_JPRB, 0.1900_JPRB, 0.1900_JPRB /)
ZOZCL(:, 8, 8) = (/&
 &0.3200_JPRB, 0.3200_JPRB, 0.3300_JPRB, 0.3300_JPRB, 0.3200_JPRB, 0.3100_JPRB, 0.3000_JPRB, 0.2600_JPRB,&
 &0.2500_JPRB, 0.2500_JPRB, 0.2500_JPRB, 0.2500_JPRB, 0.2400_JPRB, 0.2500_JPRB, 0.2600_JPRB, 0.2700_JPRB,&
 &0.2700_JPRB, 0.2900_JPRB, 0.2900_JPRB /)
ZOZCL(:, 9, 8) = (/&
 &0.4200_JPRB, 0.4200_JPRB, 0.4400_JPRB, 0.4400_JPRB, 0.4700_JPRB, 0.4800_JPRB, 0.4400_JPRB, 0.3800_JPRB,&
 &0.3500_JPRB, 0.3500_JPRB, 0.3500_JPRB, 0.3400_JPRB, 0.3400_JPRB, 0.3600_JPRB, 0.3800_JPRB, 0.3800_JPRB,&
 &0.3800_JPRB, 0.3900_JPRB, 0.3900_JPRB /)
ZOZCL(:,10, 8) = (/&
 &0.5800_JPRB, 0.5800_JPRB, 0.6000_JPRB, 0.6000_JPRB, 0.6100_JPRB, 0.6200_JPRB, 0.5900_JPRB, 0.5400_JPRB,&
 &0.5200_JPRB, 0.5300_JPRB, 0.5300_JPRB, 0.5200_JPRB, 0.5200_JPRB, 0.5300_JPRB, 0.5300_JPRB, 0.5200_JPRB,&
 &0.5200_JPRB, 0.5400_JPRB, 0.5400_JPRB /)
ZOZCL(:,11, 8) = (/&
 &0.8100_JPRB, 0.8100_JPRB, 0.8400_JPRB, 0.8400_JPRB, 0.8500_JPRB, 0.8800_JPRB, 0.8700_JPRB, 0.8200_JPRB,&
 &0.7900_JPRB, 0.7900_JPRB, 0.7900_JPRB, 0.7900_JPRB, 0.8000_JPRB, 0.8100_JPRB, 0.8000_JPRB, 0.7600_JPRB,&
 &0.7500_JPRB, 0.7300_JPRB, 0.7300_JPRB /)
ZOZCL(:,12, 8) = (/&
 &0.9700_JPRB, 0.9700_JPRB, 1.0100_JPRB, 1.0100_JPRB, 1.0900_JPRB, 1.1200_JPRB, 1.1100_JPRB, 1.0500_JPRB,&
 &1.0200_JPRB, 1.0100_JPRB, 1.0100_JPRB, 1.0300_JPRB, 1.0400_JPRB, 1.0500_JPRB, 1.0200_JPRB, 0.9600_JPRB,&
 &0.9200_JPRB, 0.8900_JPRB, 0.8900_JPRB /)
ZOZCL(:,13, 8) = (/&
 &1.1300_JPRB, 1.1300_JPRB, 1.1800_JPRB, 1.1800_JPRB, 1.5600_JPRB, 1.5800_JPRB, 1.5400_JPRB, 1.4700_JPRB,&
 &1.4300_JPRB, 1.4000_JPRB, 1.3900_JPRB, 1.4200_JPRB, 1.4600_JPRB, 1.4500_JPRB, 1.3800_JPRB, 1.3000_JPRB,&
 &1.2300_JPRB, 1.1800_JPRB, 1.1800_JPRB /)
ZOZCL(:,14, 8) = (/&
 &1.8200_JPRB, 1.8200_JPRB, 1.9000_JPRB, 1.9000_JPRB, 2.1900_JPRB, 2.2200_JPRB, 2.1100_JPRB, 2.0000_JPRB,&
 &1.9700_JPRB, 1.9500_JPRB, 1.9400_JPRB, 1.9700_JPRB, 2.0200_JPRB, 1.9800_JPRB, 1.8500_JPRB, 1.7400_JPRB,&
 &1.6400_JPRB, 1.5600_JPRB, 1.5600_JPRB /)
ZOZCL(:,15, 8) = (/&
 &2.2000_JPRB, 2.2000_JPRB, 2.5000_JPRB, 2.5500_JPRB, 2.7600_JPRB, 2.7900_JPRB, 2.6000_JPRB, 2.4500_JPRB,&
 &2.4000_JPRB, 2.3900_JPRB, 2.4000_JPRB, 2.4400_JPRB, 2.5000_JPRB, 2.4400_JPRB, 2.2600_JPRB, 2.1100_JPRB,&
 &2.0100_JPRB, 1.9200_JPRB, 1.9200_JPRB /)
ZOZCL(:,16, 8) = (/&
 &2.8400_JPRB, 2.8400_JPRB, 3.3500_JPRB, 3.5400_JPRB, 3.8700_JPRB, 3.8700_JPRB, 3.5500_JPRB, 3.2900_JPRB,&
 &3.1700_JPRB, 3.1300_JPRB, 3.1400_JPRB, 3.2200_JPRB, 3.2800_JPRB, 3.1800_JPRB, 2.9500_JPRB, 2.7700_JPRB,&
 &2.6500_JPRB, 2.5500_JPRB, 2.5500_JPRB /)
ZOZCL(:,17, 8) = (/&
 &3.7800_JPRB, 3.7800_JPRB, 4.4100_JPRB, 4.9700_JPRB, 5.5100_JPRB, 5.4300_JPRB, 4.9700_JPRB, 4.5500_JPRB,&
 &4.3100_JPRB, 4.2400_JPRB, 4.2700_JPRB, 4.3900_JPRB, 4.4200_JPRB, 4.2500_JPRB, 3.9800_JPRB, 3.7800_JPRB,&
 &3.6100_JPRB, 3.4800_JPRB, 3.4800_JPRB /) 

ZOZCL(:,18, 8) = (/&
 &4.3800_JPRB, 4.3800_JPRB, 4.9200_JPRB, 5.7900_JPRB, 6.6000_JPRB, 6.5500_JPRB, 6.0900_JPRB, 5.6800_JPRB,&
 &5.4200_JPRB, 5.3300_JPRB, 5.3700_JPRB, 5.5100_JPRB, 5.4900_JPRB, 5.2700_JPRB, 4.9900_JPRB, 4.7700_JPRB,&
 &4.5300_JPRB, 4.3200_JPRB, 4.3200_JPRB /)
ZOZCL(:,19, 8) = (/&
 &4.8800_JPRB, 4.8800_JPRB, 5.2100_JPRB, 6.3500_JPRB, 7.5700_JPRB, 7.7800_JPRB, 7.5400_JPRB, 7.3700_JPRB,&
 &7.2300_JPRB, 7.1600_JPRB, 7.2000_JPRB, 7.3200_JPRB, 7.2300_JPRB, 6.9400_JPRB, 6.6400_JPRB, 6.3400_JPRB,&
 &5.8600_JPRB, 5.4300_JPRB, 5.4300_JPRB /)
ZOZCL(:,20, 8) = (/&
 &5.2400_JPRB, 5.2400_JPRB, 5.3400_JPRB, 6.1400_JPRB, 7.2600_JPRB, 7.9400_JPRB, 8.1700_JPRB, 8.5200_JPRB,&
 &8.8400_JPRB, 8.9000_JPRB, 8.9100_JPRB, 8.7400_JPRB, 8.5500_JPRB, 8.2000_JPRB, 7.7500_JPRB, 7.1100_JPRB,&
 &6.1300_JPRB, 5.3000_JPRB, 5.3000_JPRB /)
ZOZCL(:,21, 8) = (/&
 &5.1700_JPRB, 5.1700_JPRB, 5.2900_JPRB, 5.5900_JPRB, 6.5700_JPRB, 7.5000_JPRB, 7.9800_JPRB, 8.6200_JPRB,&
 &9.2200_JPRB, 9.3700_JPRB, 9.4200_JPRB, 9.1600_JPRB, 8.8300_JPRB, 8.3600_JPRB, 7.7000_JPRB, 6.8700_JPRB,&
 &5.6600_JPRB, 4.6800_JPRB, 4.6800_JPRB /)
ZOZCL(:,22, 8) = (/&
 &4.8300_JPRB, 4.8300_JPRB, 5.1100_JPRB, 4.9400_JPRB, 5.7000_JPRB, 6.7600_JPRB, 7.3600_JPRB, 8.2000_JPRB,&
 &9.0800_JPRB, 9.2400_JPRB, 9.3100_JPRB, 8.9200_JPRB, 8.4600_JPRB, 7.8800_JPRB, 7.0800_JPRB, 6.2200_JPRB,&
 &5.0300_JPRB, 4.0600_JPRB, 4.0600_JPRB /)
ZOZCL(:,23, 8) = (/&
 &4.4114_JPRB, 4.4114_JPRB, 4.3392_JPRB, 3.8500_JPRB, 5.2000_JPRB, 6.0800_JPRB, 6.5300_JPRB, 7.0900_JPRB,&
 &7.7200_JPRB, 7.8900_JPRB, 8.0000_JPRB, 7.6600_JPRB, 7.2800_JPRB, 6.8400_JPRB, 6.1300_JPRB, 5.3300_JPRB,&
 &4.3300_JPRB, 3.6200_JPRB, 3.6200_JPRB /)
ZOZCL(:,24, 8) = (/&
 &3.8642_JPRB, 3.8642_JPRB, 3.7532_JPRB, 3.3850_JPRB, 4.9400_JPRB, 5.6200_JPRB, 5.8700_JPRB, 6.1300_JPRB,&
 &6.4200_JPRB, 6.5400_JPRB, 6.7200_JPRB, 6.5200_JPRB, 6.2600_JPRB, 5.9800_JPRB, 5.4700_JPRB, 4.8100_JPRB,&
 &3.9600_JPRB, 3.4500_JPRB, 3.4500_JPRB /)
ZOZCL(:,25, 8) = (/&
 &3.2527_JPRB, 3.2527_JPRB, 3.1107_JPRB, 3.1000_JPRB, 4.9600_JPRB, 4.9954_JPRB, 4.9525_JPRB, 4.6300_JPRB,&
 &4.2568_JPRB, 4.4121_JPRB, 4.7500_JPRB, 4.8600_JPRB, 4.7875_JPRB, 4.6815_JPRB, 4.3089_JPRB, 3.7158_JPRB,&
 &3.3159_JPRB, 3.1320_JPRB, 3.1320_JPRB /)
ZOZCL(:,26, 8) = (/&
 &2.8269_JPRB, 2.8269_JPRB, 2.5633_JPRB, 2.3880_JPRB, 3.0680_JPRB, 3.0094_JPRB, 2.5760_JPRB, 2.2800_JPRB,&
 &1.6597_JPRB, 1.6279_JPRB, 1.9500_JPRB, 2.1300_JPRB, 2.1947_JPRB, 2.4610_JPRB, 2.5566_JPRB, 2.5730_JPRB,&
 &2.5703_JPRB, 2.6306_JPRB, 2.6306_JPRB /)
ZOZCL(:,27, 8) = (/&
 &2.0124_JPRB, 2.0124_JPRB, 1.7867_JPRB, 1.4700_JPRB, 1.7214_JPRB, 1.6495_JPRB, 0.9482_JPRB, 1.0400_JPRB,&
 &0.6012_JPRB, 0.6575_JPRB, 0.8800_JPRB, 1.0100_JPRB, 0.9167_JPRB, 1.2381_JPRB, 1.4940_JPRB, 1.7246_JPRB,&
 &1.8416_JPRB, 1.9963_JPRB, 1.9963_JPRB /)
ZOZCL(:,28, 8) = (/&
 &1.0946_JPRB, 1.0946_JPRB, 1.0225_JPRB, 0.9160_JPRB, 0.8850_JPRB, 0.7602_JPRB, 0.2500_JPRB, 0.2237_JPRB,&
 &0.1148_JPRB, 0.1680_JPRB, 0.1830_JPRB, 0.1922_JPRB, 0.1848_JPRB, 0.4119_JPRB, 0.6847_JPRB, 0.8300_JPRB,&
 &0.9963_JPRB, 1.0967_JPRB, 1.0967_JPRB /)
ZOZCL(:,29, 8) = (/&
 &0.4743_JPRB, 0.4743_JPRB, 0.4304_JPRB, 0.3907_JPRB, 0.3920_JPRB, 0.3548_JPRB, 0.1347_JPRB, 0.1200_JPRB,&
 &0.0588_JPRB, 0.0724_JPRB, 0.0580_JPRB, 0.0565_JPRB, 0.0841_JPRB, 0.1486_JPRB, 0.3128_JPRB, 0.3640_JPRB,&
 &0.4621_JPRB, 0.5082_JPRB, 0.5082_JPRB /)
ZOZCL(:,30, 8) = (/&
 &0.2241_JPRB, 0.2241_JPRB, 0.2028_JPRB, 0.2759_JPRB, 0.2695_JPRB, 0.2556_JPRB, 0.1030_JPRB, 0.0919_JPRB,&
 &0.0441_JPRB, 0.0555_JPRB, 0.0540_JPRB, 0.0374_JPRB, 0.0641_JPRB, 0.1085_JPRB, 0.1991_JPRB, 0.2510_JPRB,&
 &0.3501_JPRB, 0.3990_JPRB, 0.3990_JPRB /)
ZOZCL(:,31, 8) = (/&
 &0.0529_JPRB, 0.0529_JPRB, 0.0549_JPRB, 0.0463_JPRB, 0.0600_JPRB, 0.0714_JPRB, 0.0710_JPRB, 0.0651_JPRB,&
 &0.0403_JPRB, 0.0451_JPRB, 0.0387_JPRB, 0.0299_JPRB, 0.0512_JPRB, 0.0798_JPRB, 0.0908_JPRB, 0.0883_JPRB,&
 &0.1016_JPRB, 0.1352_JPRB, 0.1352_JPRB /)
ZOZCL(:,32, 8) = (/&
 &0.0373_JPRB, 0.0373_JPRB, 0.0374_JPRB, 0.0390_JPRB, 0.0406_JPRB, 0.0402_JPRB, 0.0606_JPRB, 0.0559_JPRB,&
 &0.0394_JPRB, 0.0454_JPRB, 0.0280_JPRB, 0.0336_JPRB, 0.0450_JPRB, 0.0673_JPRB, 0.0685_JPRB, 0.0632_JPRB,&
 &0.0622_JPRB, 0.0549_JPRB, 0.0549_JPRB /)
ZOZCL(:,33, 8) = (/&
 &0.0311_JPRB, 0.0311_JPRB, 0.0313_JPRB, 0.0353_JPRB, 0.0357_JPRB, 0.0353_JPRB, 0.0543_JPRB, 0.0502_JPRB,&
 &0.0337_JPRB, 0.0366_JPRB, 0.0286_JPRB, 0.0355_JPRB, 0.0340_JPRB, 0.0563_JPRB, 0.0561_JPRB, 0.0500_JPRB,&
 &0.0496_JPRB, 0.0427_JPRB, 0.0427_JPRB /)
ZOZCL(:,34, 8) = (/&
 &0.0311_JPRB, 0.0311_JPRB, 0.0313_JPRB, 0.0353_JPRB, 0.0357_JPRB, 0.0353_JPRB, 0.0543_JPRB, 0.0502_JPRB,&
 &0.0337_JPRB, 0.0366_JPRB, 0.0286_JPRB, 0.0355_JPRB, 0.0340_JPRB, 0.0563_JPRB, 0.0561_JPRB, 0.0500_JPRB,&
 &0.0496_JPRB, 0.0427_JPRB, 0.0427_JPRB /) 

! Month:  9
ZOZCL(:, 1, 9) = (/&
 &0.4200_JPRB, 0.4200_JPRB, 0.5800_JPRB, 0.5900_JPRB, 0.6400_JPRB, 0.7400_JPRB, 0.7900_JPRB, 0.7700_JPRB,&
 &0.7700_JPRB, 0.7700_JPRB, 0.7500_JPRB, 0.7600_JPRB, 0.7600_JPRB, 0.6900_JPRB, 0.6100_JPRB, 0.6000_JPRB,&
 &0.5600_JPRB, 0.4600_JPRB, 0.4600_JPRB /)
ZOZCL(:, 2, 9) = (/&
 &0.2700_JPRB, 0.2700_JPRB, 0.3300_JPRB, 0.3600_JPRB, 0.3900_JPRB, 0.4600_JPRB, 0.5200_JPRB, 0.5100_JPRB,&
 &0.4800_JPRB, 0.4800_JPRB, 0.4700_JPRB, 0.4900_JPRB, 0.5300_JPRB, 0.4700_JPRB, 0.3700_JPRB, 0.3100_JPRB,&
 &0.2800_JPRB, 0.2100_JPRB, 0.2100_JPRB /)
ZOZCL(:, 3, 9) = (/&
 &0.2300_JPRB, 0.2300_JPRB, 0.2600_JPRB, 0.2900_JPRB, 0.3300_JPRB, 0.3800_JPRB, 0.4300_JPRB, 0.4300_JPRB,&
 &0.4000_JPRB, 0.3800_JPRB, 0.3800_JPRB, 0.4000_JPRB, 0.4200_JPRB, 0.3800_JPRB, 0.2900_JPRB, 0.2300_JPRB,&
 &0.2000_JPRB, 0.1600_JPRB, 0.1600_JPRB /)
ZOZCL(:, 4, 9) = (/&
 &0.2400_JPRB, 0.2400_JPRB, 0.2800_JPRB, 0.3100_JPRB, 0.3400_JPRB, 0.3700_JPRB, 0.3700_JPRB, 0.3500_JPRB,&
 &0.3200_JPRB, 0.2900_JPRB, 0.2900_JPRB, 0.3200_JPRB, 0.3400_JPRB, 0.3100_JPRB, 0.2500_JPRB, 0.2000_JPRB,&
 &0.1900_JPRB, 0.1600_JPRB, 0.1600_JPRB /)
ZOZCL(:, 5, 9) = (/&
 &0.2700_JPRB, 0.2700_JPRB, 0.3100_JPRB, 0.3100_JPRB, 0.3200_JPRB, 0.3000_JPRB, 0.2700_JPRB, 0.2300_JPRB,&
 &0.2100_JPRB, 0.2000_JPRB, 0.1900_JPRB, 0.2100_JPRB, 0.2200_JPRB, 0.2200_JPRB, 0.1900_JPRB, 0.1700_JPRB,&
 &0.1600_JPRB, 0.1700_JPRB, 0.1700_JPRB /)
ZOZCL(:, 6, 9) = (/&
 &0.2800_JPRB, 0.2800_JPRB, 0.3000_JPRB, 0.2700_JPRB, 0.2500_JPRB, 0.2300_JPRB, 0.1900_JPRB, 0.1700_JPRB,&
 &0.1600_JPRB, 0.1600_JPRB, 0.1500_JPRB, 0.1600_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1600_JPRB, 0.1500_JPRB,&
 &0.1500_JPRB, 0.1800_JPRB, 0.1800_JPRB /)
ZOZCL(:, 7, 9) = (/&
 &0.2800_JPRB, 0.2800_JPRB, 0.2800_JPRB, 0.2200_JPRB, 0.1900_JPRB, 0.1700_JPRB, 0.1600_JPRB, 0.1700_JPRB,&
 &0.1700_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1500_JPRB, 0.1500_JPRB, 0.1600_JPRB, 0.1600_JPRB,&
 &0.1700_JPRB, 0.2100_JPRB, 0.2100_JPRB /)
ZOZCL(:, 8, 9) = (/&
 &0.3300_JPRB, 0.3300_JPRB, 0.3300_JPRB, 0.3100_JPRB, 0.3100_JPRB, 0.2900_JPRB, 0.2800_JPRB, 0.2600_JPRB,&
 &0.2400_JPRB, 0.2300_JPRB, 0.2400_JPRB, 0.2400_JPRB, 0.2300_JPRB, 0.2300_JPRB, 0.2500_JPRB, 0.2600_JPRB,&
 &0.2700_JPRB, 0.2900_JPRB, 0.2900_JPRB /)
ZOZCL(:, 9, 9) = (/&
 &0.4100_JPRB, 0.4100_JPRB, 0.4300_JPRB, 0.4400_JPRB, 0.4500_JPRB, 0.4400_JPRB, 0.4100_JPRB, 0.3700_JPRB,&
 &0.3400_JPRB, 0.3300_JPRB, 0.3400_JPRB, 0.3400_JPRB, 0.3400_JPRB, 0.3500_JPRB, 0.3800_JPRB, 0.3900_JPRB,&
 &0.3800_JPRB, 0.3800_JPRB, 0.3800_JPRB /)
ZOZCL(:,10, 9) = (/&
 &0.5200_JPRB, 0.5200_JPRB, 0.5700_JPRB, 0.5800_JPRB, 0.5900_JPRB, 0.5800_JPRB, 0.5400_JPRB, 0.5000_JPRB,&
 &0.4900_JPRB, 0.5000_JPRB, 0.4900_JPRB, 0.4700_JPRB, 0.4600_JPRB, 0.4700_JPRB, 0.4900_JPRB, 0.4800_JPRB,&
 &0.4900_JPRB, 0.5000_JPRB, 0.5000_JPRB /)
ZOZCL(:,11, 9) = (/&
 &0.7000_JPRB, 0.7000_JPRB, 0.8000_JPRB, 0.8000_JPRB, 0.8300_JPRB, 0.8400_JPRB, 0.8000_JPRB, 0.7700_JPRB,&
 &0.7600_JPRB, 0.7600_JPRB, 0.7400_JPRB, 0.7200_JPRB, 0.7000_JPRB, 0.7200_JPRB, 0.7300_JPRB, 0.7000_JPRB,&
 &0.6700_JPRB, 0.6700_JPRB, 0.6700_JPRB /)
ZOZCL(:,12, 9) = (/&
 &0.8700_JPRB, 0.8700_JPRB, 0.9900_JPRB, 1.0100_JPRB, 1.0500_JPRB, 1.0600_JPRB, 1.0300_JPRB, 1.0000_JPRB,&
 &0.9900_JPRB, 0.9800_JPRB, 0.9700_JPRB, 0.9600_JPRB, 0.9600_JPRB, 0.9700_JPRB, 0.9700_JPRB, 0.9400_JPRB,&
 &0.8900_JPRB, 0.8600_JPRB, 0.8600_JPRB /)
ZOZCL(:,13, 9) = (/&
 &1.2800_JPRB, 1.2800_JPRB, 1.3500_JPRB, 1.4000_JPRB, 1.4700_JPRB, 1.4800_JPRB, 1.4300_JPRB, 1.4100_JPRB,&
 &1.4100_JPRB, 1.3800_JPRB, 1.3600_JPRB, 1.3800_JPRB, 1.4000_JPRB, 1.4000_JPRB, 1.4000_JPRB, 1.3600_JPRB,&
 &1.2800_JPRB, 1.2500_JPRB, 1.2500_JPRB /)
ZOZCL(:,14, 9) = (/&
 &1.7800_JPRB, 1.7800_JPRB, 1.8800_JPRB, 1.9800_JPRB, 2.1000_JPRB, 2.1000_JPRB, 2.0200_JPRB, 1.9600_JPRB,&
 &1.9500_JPRB, 1.9300_JPRB, 1.9200_JPRB, 1.9400_JPRB, 1.9600_JPRB, 1.9500_JPRB, 1.9200_JPRB, 1.8900_JPRB,&
 &1.8700_JPRB, 1.9300_JPRB, 1.9300_JPRB /)
ZOZCL(:,15, 9) = (/&
 &2.3800_JPRB, 2.3800_JPRB, 2.3400_JPRB, 2.4800_JPRB, 2.6700_JPRB, 2.6400_JPRB, 2.4700_JPRB, 2.3800_JPRB,&
 &2.3600_JPRB, 2.3500_JPRB, 2.3600_JPRB, 2.3800_JPRB, 2.4000_JPRB, 2.3800_JPRB, 2.3600_JPRB, 2.3700_JPRB,&
 &2.4100_JPRB, 2.4800_JPRB, 2.4800_JPRB /)
ZOZCL(:,16, 9) = (/&
 &3.1900_JPRB, 3.1900_JPRB, 3.1800_JPRB, 3.3800_JPRB, 3.6600_JPRB, 3.6200_JPRB, 3.3600_JPRB, 3.1500_JPRB,&
 &3.0600_JPRB, 3.0400_JPRB, 3.0700_JPRB, 3.1500_JPRB, 3.2300_JPRB, 3.2300_JPRB, 3.2300_JPRB, 3.3000_JPRB,&
 &3.3700_JPRB, 3.3400_JPRB, 3.3400_JPRB /)
ZOZCL(:,17, 9) = (/&
 &4.2600_JPRB, 4.2600_JPRB, 4.3800_JPRB, 4.7200_JPRB, 5.1000_JPRB, 5.0700_JPRB, 4.7100_JPRB, 4.3500_JPRB,&
 &4.1300_JPRB, 4.0700_JPRB, 4.1500_JPRB, 4.3400_JPRB, 4.4800_JPRB, 4.5100_JPRB, 4.5400_JPRB, 4.6600_JPRB,&
 &4.6900_JPRB, 4.3300_JPRB, 4.3300_JPRB /) 

ZOZCL(:,18, 9) = (/&
 &4.8600_JPRB, 4.8600_JPRB, 5.1600_JPRB, 5.7200_JPRB, 6.2300_JPRB, 6.2600_JPRB, 5.9000_JPRB, 5.5000_JPRB,&
 &5.2100_JPRB, 5.1300_JPRB, 5.2100_JPRB, 5.4500_JPRB, 5.6000_JPRB, 5.5900_JPRB, 5.6000_JPRB, 5.6700_JPRB,&
 &5.5200_JPRB, 4.8700_JPRB, 4.8700_JPRB /)
ZOZCL(:,19, 9) = (/&
 &5.3400_JPRB, 5.3400_JPRB, 5.8900_JPRB, 6.8600_JPRB, 7.5800_JPRB, 7.8000_JPRB, 7.6300_JPRB, 7.3600_JPRB,&
 &7.0800_JPRB, 6.9700_JPRB, 7.0400_JPRB, 7.2500_JPRB, 7.3100_JPRB, 7.1700_JPRB, 7.0300_JPRB, 6.8200_JPRB,&
 &6.2300_JPRB, 5.2200_JPRB, 5.2200_JPRB /)
ZOZCL(:,20, 9) = (/&
 &5.3600_JPRB, 5.3600_JPRB, 5.9400_JPRB, 6.7700_JPRB, 7.8900_JPRB, 8.3600_JPRB, 8.7000_JPRB, 8.9000_JPRB,&
 &8.9000_JPRB, 8.8200_JPRB, 8.8300_JPRB, 8.7300_JPRB, 8.6200_JPRB, 8.2000_JPRB, 7.7200_JPRB, 7.0700_JPRB,&
 &6.0700_JPRB, 4.9700_JPRB, 4.9700_JPRB /)
ZOZCL(:,21, 9) = (/&
 &5.2800_JPRB, 5.2800_JPRB, 5.6200_JPRB, 6.3600_JPRB, 7.3900_JPRB, 8.0400_JPRB, 8.5700_JPRB, 9.0700_JPRB,&
 &9.4700_JPRB, 9.4700_JPRB, 9.5000_JPRB, 9.2000_JPRB, 8.8300_JPRB, 8.2500_JPRB, 7.4800_JPRB, 6.6000_JPRB,&
 &5.4700_JPRB, 4.5800_JPRB, 4.5800_JPRB /)
ZOZCL(:,22, 9) = (/&
 &5.1500_JPRB, 5.1500_JPRB, 5.1800_JPRB, 5.7500_JPRB, 6.5900_JPRB, 7.3200_JPRB, 7.9000_JPRB, 8.6000_JPRB,&
 &9.4100_JPRB, 9.4800_JPRB, 9.5200_JPRB, 9.0100_JPRB, 8.4200_JPRB, 7.7400_JPRB, 6.7700_JPRB, 5.8200_JPRB,&
 &4.7100_JPRB, 4.1400_JPRB, 4.1400_JPRB /)
ZOZCL(:,23, 9) = (/&
 &4.6717_JPRB, 4.6717_JPRB, 4.8458_JPRB, 3.7400_JPRB, 5.8700_JPRB, 6.4500_JPRB, 6.8700_JPRB, 7.3500_JPRB,&
 &7.9500_JPRB, 8.0500_JPRB, 8.1400_JPRB, 7.7000_JPRB, 7.2100_JPRB, 6.6900_JPRB, 5.8500_JPRB, 5.0300_JPRB,&
 &4.1300_JPRB, 3.7500_JPRB, 3.7500_JPRB /)
ZOZCL(:,24, 9) = (/&
 &3.8037_JPRB, 3.8037_JPRB, 3.8848_JPRB, 2.9500_JPRB, 5.4400_JPRB, 5.8800_JPRB, 6.1100_JPRB, 6.3000_JPRB,&
 &6.5900_JPRB, 6.6600_JPRB, 6.8000_JPRB, 6.5100_JPRB, 6.1700_JPRB, 5.8600_JPRB, 5.2400_JPRB, 4.5800_JPRB,&
 &3.8900_JPRB, 3.5300_JPRB, 3.5300_JPRB /)
ZOZCL(:,25, 9) = (/&
 &2.3519_JPRB, 2.3519_JPRB, 2.4684_JPRB, 2.5767_JPRB, 5.0900_JPRB, 5.0874_JPRB, 4.8300_JPRB, 4.6000_JPRB,&
 &4.2822_JPRB, 4.4093_JPRB, 4.7200_JPRB, 4.7400_JPRB, 4.7275_JPRB, 4.5475_JPRB, 4.1553_JPRB, 3.7417_JPRB,&
 &3.4637_JPRB, 3.1593_JPRB, 3.1593_JPRB /)
ZOZCL(:,26, 9) = (/&
 &1.6783_JPRB, 1.6783_JPRB, 1.8105_JPRB, 1.8080_JPRB, 3.2640_JPRB, 3.1160_JPRB, 2.5420_JPRB, 2.1000_JPRB,&
 &1.6258_JPRB, 1.6928_JPRB, 1.9000_JPRB, 2.0000_JPRB, 2.0931_JPRB, 2.3483_JPRB, 2.4707_JPRB, 2.5830_JPRB,&
 &2.5729_JPRB, 2.5568_JPRB, 2.5568_JPRB /)
ZOZCL(:,27, 9) = (/&
 &1.2168_JPRB, 1.2168_JPRB, 1.2714_JPRB, 1.0043_JPRB, 1.8843_JPRB, 1.7599_JPRB, 1.1100_JPRB, 0.9300_JPRB,&
 &0.5827_JPRB, 0.6564_JPRB, 0.7900_JPRB, 0.8800_JPRB, 0.8406_JPRB, 1.2144_JPRB, 1.4516_JPRB, 1.7825_JPRB,&
 &1.9065_JPRB, 2.1061_JPRB, 2.1061_JPRB /)
ZOZCL(:,28, 9) = (/&
 &0.7290_JPRB, 0.7290_JPRB, 0.7549_JPRB, 0.6280_JPRB, 0.8840_JPRB, 0.7060_JPRB, 0.2840_JPRB, 0.2657_JPRB,&
 &0.1308_JPRB, 0.1540_JPRB, 0.1600_JPRB, 0.1884_JPRB, 0.1743_JPRB, 0.4245_JPRB, 0.6122_JPRB, 0.8520_JPRB,&
 &1.0364_JPRB, 1.1360_JPRB, 1.1360_JPRB /)
ZOZCL(:,29, 9) = (/&
 &0.3900_JPRB, 0.3900_JPRB, 0.3966_JPRB, 0.3887_JPRB, 0.4313_JPRB, 0.3504_JPRB, 0.1280_JPRB, 0.1188_JPRB,&
 &0.0577_JPRB, 0.0775_JPRB, 0.0687_JPRB, 0.0665_JPRB, 0.0818_JPRB, 0.1571_JPRB, 0.2472_JPRB, 0.3527_JPRB,&
 &0.4632_JPRB, 0.5169_JPRB, 0.5169_JPRB /)
ZOZCL(:,30, 9) = (/&
 &0.1897_JPRB, 0.1897_JPRB, 0.1921_JPRB, 0.2789_JPRB, 0.2805_JPRB, 0.2363_JPRB, 0.1080_JPRB, 0.1004_JPRB,&
 &0.0515_JPRB, 0.0685_JPRB, 0.0550_JPRB, 0.0409_JPRB, 0.0646_JPRB, 0.1032_JPRB, 0.1543_JPRB, 0.2500_JPRB,&
 &0.2984_JPRB, 0.3550_JPRB, 0.3550_JPRB /)
ZOZCL(:,31, 9) = (/&
 &0.0479_JPRB, 0.0479_JPRB, 0.0560_JPRB, 0.0593_JPRB, 0.0707_JPRB, 0.0820_JPRB, 0.0993_JPRB, 0.0918_JPRB,&
 &0.0458_JPRB, 0.0618_JPRB, 0.0393_JPRB, 0.0401_JPRB, 0.0538_JPRB, 0.0639_JPRB, 0.0778_JPRB, 0.0907_JPRB,&
 &0.0977_JPRB, 0.1328_JPRB, 0.1328_JPRB /)
ZOZCL(:,32, 9) = (/&
 &0.0367_JPRB, 0.0367_JPRB, 0.0404_JPRB, 0.0436_JPRB, 0.0488_JPRB, 0.0421_JPRB, 0.0834_JPRB, 0.0781_JPRB,&
 &0.0480_JPRB, 0.0545_JPRB, 0.0236_JPRB, 0.0382_JPRB, 0.0543_JPRB, 0.0546_JPRB, 0.0595_JPRB, 0.0560_JPRB,&
 &0.0579_JPRB, 0.0574_JPRB, 0.0574_JPRB /)
ZOZCL(:,33, 9) = (/&
 &0.0316_JPRB, 0.0316_JPRB, 0.0346_JPRB, 0.0357_JPRB, 0.0379_JPRB, 0.0368_JPRB, 0.0790_JPRB, 0.0735_JPRB,&
 &0.0401_JPRB, 0.0458_JPRB, 0.0190_JPRB, 0.0343_JPRB, 0.0441_JPRB, 0.0496_JPRB, 0.0498_JPRB, 0.0431_JPRB,&
 &0.0462_JPRB, 0.0475_JPRB, 0.0475_JPRB /)
ZOZCL(:,34, 9) = (/&
 &0.0316_JPRB, 0.0316_JPRB, 0.0346_JPRB, 0.0357_JPRB, 0.0379_JPRB, 0.0368_JPRB, 0.0790_JPRB, 0.0735_JPRB,&
 &0.0401_JPRB, 0.0458_JPRB, 0.0190_JPRB, 0.0343_JPRB, 0.0441_JPRB, 0.0496_JPRB, 0.0498_JPRB, 0.0431_JPRB,&
 &0.0462_JPRB, 0.0475_JPRB, 0.0475_JPRB /) 

! Month: 10
ZOZCL(:, 1,10) = (/&
 &0.5700_JPRB, 0.5700_JPRB, 0.5600_JPRB, 0.5400_JPRB, 0.6100_JPRB, 0.8000_JPRB, 0.9300_JPRB, 0.8700_JPRB,&
 &0.8000_JPRB, 0.8400_JPRB, 0.8100_JPRB, 0.7600_JPRB, 0.8400_JPRB, 0.8700_JPRB, 0.7500_JPRB, 0.6600_JPRB,&
 &0.6500_JPRB, 0.6300_JPRB, 0.6300_JPRB /)
ZOZCL(:, 2,10) = (/&
 &0.3800_JPRB, 0.3800_JPRB, 0.4100_JPRB, 0.4100_JPRB, 0.4500_JPRB, 0.5800_JPRB, 0.6600_JPRB, 0.6000_JPRB,&
 &0.5300_JPRB, 0.5500_JPRB, 0.5400_JPRB, 0.5100_JPRB, 0.5500_JPRB, 0.5500_JPRB, 0.4400_JPRB, 0.3400_JPRB,&
 &0.3000_JPRB, 0.2300_JPRB, 0.2300_JPRB /)
ZOZCL(:, 3,10) = (/&
 &0.3100_JPRB, 0.3100_JPRB, 0.3800_JPRB, 0.4100_JPRB, 0.4400_JPRB, 0.5000_JPRB, 0.5200_JPRB, 0.4700_JPRB,&
 &0.4200_JPRB, 0.4300_JPRB, 0.4200_JPRB, 0.3900_JPRB, 0.4100_JPRB, 0.4100_JPRB, 0.3300_JPRB, 0.2500_JPRB,&
 &0.1900_JPRB, 0.1200_JPRB, 0.1200_JPRB /)
ZOZCL(:, 4,10) = (/&
 &0.2800_JPRB, 0.2800_JPRB, 0.3800_JPRB, 0.4300_JPRB, 0.4500_JPRB, 0.4400_JPRB, 0.3900_JPRB, 0.3400_JPRB,&
 &0.3300_JPRB, 0.3300_JPRB, 0.3100_JPRB, 0.3000_JPRB, 0.3000_JPRB, 0.3100_JPRB, 0.2800_JPRB, 0.2300_JPRB,&
 &0.1900_JPRB, 0.1200_JPRB, 0.1200_JPRB /)
ZOZCL(:, 5,10) = (/&
 &0.2600_JPRB, 0.2600_JPRB, 0.3200_JPRB, 0.3400_JPRB, 0.3400_JPRB, 0.3100_JPRB, 0.2600_JPRB, 0.2300_JPRB,&
 &0.2400_JPRB, 0.2400_JPRB, 0.2200_JPRB, 0.2200_JPRB, 0.2200_JPRB, 0.2200_JPRB, 0.2300_JPRB, 0.2500_JPRB,&
 &0.2500_JPRB, 0.1900_JPRB, 0.1900_JPRB /)
ZOZCL(:, 6,10) = (/&
 &0.2300_JPRB, 0.2300_JPRB, 0.2400_JPRB, 0.2500_JPRB, 0.2500_JPRB, 0.2300_JPRB, 0.1900_JPRB, 0.1900_JPRB,&
 &0.1900_JPRB, 0.2000_JPRB, 0.1800_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1800_JPRB, 0.2000_JPRB, 0.2500_JPRB,&
 &0.2900_JPRB, 0.2500_JPRB, 0.2500_JPRB /)
ZOZCL(:, 7,10) = (/&
 &0.2400_JPRB, 0.2400_JPRB, 0.2100_JPRB, 0.2000_JPRB, 0.1900_JPRB, 0.1800_JPRB, 0.1700_JPRB, 0.1700_JPRB,&
 &0.1800_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1800_JPRB, 0.2400_JPRB,&
 &0.3300_JPRB, 0.3100_JPRB, 0.3100_JPRB /)
ZOZCL(:, 8,10) = (/&
 &0.3500_JPRB, 0.3500_JPRB, 0.3300_JPRB, 0.3200_JPRB, 0.3100_JPRB, 0.2800_JPRB, 0.2600_JPRB, 0.2600_JPRB,&
 &0.2600_JPRB, 0.2500_JPRB, 0.2400_JPRB, 0.2400_JPRB, 0.2500_JPRB, 0.2500_JPRB, 0.2600_JPRB, 0.2800_JPRB,&
 &0.3500_JPRB, 0.3700_JPRB, 0.3700_JPRB /)
ZOZCL(:, 9,10) = (/&
 &0.4500_JPRB, 0.4500_JPRB, 0.4500_JPRB, 0.4400_JPRB, 0.4300_JPRB, 0.4100_JPRB, 0.3900_JPRB, 0.3800_JPRB,&
 &0.3700_JPRB, 0.3600_JPRB, 0.3500_JPRB, 0.3500_JPRB, 0.3600_JPRB, 0.3700_JPRB, 0.3800_JPRB, 0.3800_JPRB,&
 &0.4000_JPRB, 0.4100_JPRB, 0.4100_JPRB /)
ZOZCL(:,10,10) = (/&
 &0.5600_JPRB, 0.5600_JPRB, 0.5500_JPRB, 0.5400_JPRB, 0.5200_JPRB, 0.5000_JPRB, 0.4800_JPRB, 0.4800_JPRB,&
 &0.4600_JPRB, 0.4600_JPRB, 0.4500_JPRB, 0.5200_JPRB, 0.5300_JPRB, 0.5500_JPRB, 0.5600_JPRB, 0.5400_JPRB,&
 &0.5100_JPRB, 0.4900_JPRB, 0.4900_JPRB /)
ZOZCL(:,11,10) = (/&
 &0.7800_JPRB, 0.7800_JPRB, 0.7500_JPRB, 0.7500_JPRB, 0.7500_JPRB, 0.7400_JPRB, 0.7400_JPRB, 0.7300_JPRB,&
 &0.7100_JPRB, 0.6800_JPRB, 0.6900_JPRB, 0.7900_JPRB, 0.6500_JPRB, 0.6800_JPRB, 0.7000_JPRB, 0.6900_JPRB,&
 &0.7200_JPRB, 0.6900_JPRB, 0.6900_JPRB /)
ZOZCL(:,12,10) = (/&
 &0.9700_JPRB, 0.9700_JPRB, 0.9300_JPRB, 0.9400_JPRB, 0.9500_JPRB, 0.9600_JPRB, 0.9600_JPRB, 0.9600_JPRB,&
 &0.9400_JPRB, 0.9200_JPRB, 0.9200_JPRB, 0.9300_JPRB, 0.9200_JPRB, 0.9300_JPRB, 0.9200_JPRB, 0.9100_JPRB,&
 &0.9400_JPRB, 0.9000_JPRB, 0.9000_JPRB /)
ZOZCL(:,13,10) = (/&
 &1.3100_JPRB, 1.3100_JPRB, 1.2800_JPRB, 1.3000_JPRB, 1.3300_JPRB, 1.3700_JPRB, 1.3900_JPRB, 1.3900_JPRB,&
 &1.3900_JPRB, 1.3700_JPRB, 1.3800_JPRB, 1.4100_JPRB, 1.3900_JPRB, 1.3700_JPRB, 1.3600_JPRB, 1.3600_JPRB,&
 &1.3700_JPRB, 1.3100_JPRB, 1.3100_JPRB /)
ZOZCL(:,14,10) = (/&
 &1.7600_JPRB, 1.7600_JPRB, 1.7900_JPRB, 1.8600_JPRB, 1.9100_JPRB, 1.9300_JPRB, 1.9400_JPRB, 1.9500_JPRB,&
 &1.9700_JPRB, 1.9700_JPRB, 1.9700_JPRB, 1.9600_JPRB, 1.9400_JPRB, 1.9700_JPRB, 2.0700_JPRB, 2.1600_JPRB,&
 &2.1600_JPRB, 2.0900_JPRB, 2.0900_JPRB /)
ZOZCL(:,15,10) = (/&
 &2.1600_JPRB, 2.1600_JPRB, 2.1800_JPRB, 2.3300_JPRB, 2.4000_JPRB, 2.3600_JPRB, 2.3100_JPRB, 2.3300_JPRB,&
 &2.3500_JPRB, 2.3700_JPRB, 2.3700_JPRB, 2.3400_JPRB, 2.3200_JPRB, 2.4400_JPRB, 2.6800_JPRB, 2.8400_JPRB,&
 &2.8800_JPRB, 2.9400_JPRB, 2.9400_JPRB /)
ZOZCL(:,16,10) = (/&
 &2.8300_JPRB, 2.8300_JPRB, 2.8700_JPRB, 3.1000_JPRB, 3.2200_JPRB, 3.1700_JPRB, 3.0700_JPRB, 3.0400_JPRB,&
 &3.0300_JPRB, 3.0400_JPRB, 3.0600_JPRB, 3.1000_JPRB, 3.1800_JPRB, 3.4400_JPRB, 3.8000_JPRB, 4.0500_JPRB,&
 &4.0600_JPRB, 3.9600_JPRB, 3.9600_JPRB /)
ZOZCL(:,17,10) = (/&
 &3.8600_JPRB, 3.8600_JPRB, 3.9300_JPRB, 4.2600_JPRB, 4.4700_JPRB, 4.4300_JPRB, 4.2600_JPRB, 4.1400_JPRB,&
 &4.0500_JPRB, 4.0300_JPRB, 4.0900_JPRB, 4.2600_JPRB, 4.5300_JPRB, 4.9600_JPRB, 5.4100_JPRB, 5.6600_JPRB,&
 &5.4900_JPRB, 4.9600_JPRB, 4.9600_JPRB /) 

ZOZCL(:,18,10) = (/&
 &4.7500_JPRB, 4.7500_JPRB, 4.9100_JPRB, 5.3400_JPRB, 5.6400_JPRB, 5.6600_JPRB, 5.4700_JPRB, 5.2700_JPRB,&
 &5.1100_JPRB, 5.0300_JPRB, 5.1100_JPRB, 5.3400_JPRB, 5.6700_JPRB, 6.0900_JPRB, 6.4200_JPRB, 6.4900_JPRB,&
 &6.0700_JPRB, 5.2600_JPRB, 5.2600_JPRB /)
ZOZCL(:,19,10) = (/&
 &5.9200_JPRB, 5.9200_JPRB, 6.3300_JPRB, 6.9300_JPRB, 7.3900_JPRB, 7.5800_JPRB, 7.4700_JPRB, 7.2400_JPRB,&
 &6.9800_JPRB, 6.8200_JPRB, 6.8600_JPRB, 7.1000_JPRB, 7.3200_JPRB, 7.4100_JPRB, 7.3000_JPRB, 6.9200_JPRB,&
 &6.1800_JPRB, 5.1800_JPRB, 5.1800_JPRB /)
ZOZCL(:,20,10) = (/&
 &6.1800_JPRB, 6.1800_JPRB, 6.6100_JPRB, 7.3800_JPRB, 8.0400_JPRB, 8.5000_JPRB, 8.8700_JPRB, 9.0500_JPRB,&
 &8.8300_JPRB, 8.7100_JPRB, 8.7600_JPRB, 8.7000_JPRB, 8.5300_JPRB, 7.9900_JPRB, 7.3800_JPRB, 6.7500_JPRB,&
 &5.9200_JPRB, 5.0300_JPRB, 5.0300_JPRB /)
ZOZCL(:,21,10) = (/&
 &6.0000_JPRB, 6.0000_JPRB, 6.4300_JPRB, 7.2000_JPRB, 7.8300_JPRB, 8.3700_JPRB, 8.9500_JPRB, 9.4600_JPRB,&
 &9.5800_JPRB, 9.6000_JPRB, 9.5900_JPRB, 9.2900_JPRB, 8.7500_JPRB, 7.7900_JPRB, 6.9600_JPRB, 6.2400_JPRB,&
 &5.5200_JPRB, 4.8100_JPRB, 4.8100_JPRB /)
ZOZCL(:,22,10) = (/&
 &5.7600_JPRB, 5.7600_JPRB, 6.0700_JPRB, 6.7200_JPRB, 7.2100_JPRB, 7.7200_JPRB, 8.3700_JPRB, 9.1400_JPRB,&
 &9.6500_JPRB, 9.8700_JPRB, 9.8100_JPRB, 9.2500_JPRB, 8.4100_JPRB, 7.2000_JPRB, 6.2600_JPRB, 5.5400_JPRB,&
 &4.9900_JPRB, 4.4500_JPRB, 4.4500_JPRB /)
ZOZCL(:,23,10) = (/&
 &5.2232_JPRB, 5.2232_JPRB, 5.5374_JPRB, 5.2400_JPRB, 6.4300_JPRB, 6.7200_JPRB, 7.1800_JPRB, 7.7400_JPRB,&
 &8.1300_JPRB, 8.3600_JPRB, 8.3600_JPRB, 7.8600_JPRB, 7.1900_JPRB, 6.2900_JPRB, 5.5800_JPRB, 4.9700_JPRB,&
 &4.4900_JPRB, 3.9800_JPRB, 3.9800_JPRB /)
ZOZCL(:,24,10) = (/&
 &4.1747_JPRB, 4.1747_JPRB, 4.6023_JPRB, 4.3050_JPRB, 5.9400_JPRB, 6.0800_JPRB, 6.3100_JPRB, 6.5900_JPRB,&
 &6.6800_JPRB, 6.7700_JPRB, 6.8000_JPRB, 6.5300_JPRB, 6.1200_JPRB, 5.5800_JPRB, 5.1000_JPRB, 4.7000_JPRB,&
 &4.1900_JPRB, 3.6200_JPRB, 3.6200_JPRB /)
ZOZCL(:,25,10) = (/&
 &2.7866_JPRB, 2.7866_JPRB, 3.1177_JPRB, 3.2367_JPRB, 4.9933_JPRB, 5.0993_JPRB, 4.9783_JPRB, 4.7000_JPRB,&
 &4.2500_JPRB, 4.3832_JPRB, 4.4600_JPRB, 4.4700_JPRB, 4.4959_JPRB, 4.4443_JPRB, 4.2617_JPRB, 4.1667_JPRB,&
 &3.4780_JPRB, 3.1447_JPRB, 3.1447_JPRB /)
ZOZCL(:,26,10) = (/&
 &0.9992_JPRB, 0.9992_JPRB, 1.3984_JPRB, 1.7960_JPRB, 3.1540_JPRB, 3.2618_JPRB, 2.5540_JPRB, 2.1500_JPRB,&
 &1.6459_JPRB, 1.5903_JPRB, 1.6300_JPRB, 1.8000_JPRB, 1.9871_JPRB, 2.2845_JPRB, 2.4964_JPRB, 2.5960_JPRB,&
 &2.5710_JPRB, 2.6438_JPRB, 2.6438_JPRB /)
ZOZCL(:,27,10) = (/&
 &0.5779_JPRB, 0.5779_JPRB, 0.7611_JPRB, 1.0371_JPRB, 1.8243_JPRB, 1.7040_JPRB, 1.0114_JPRB, 0.8600_JPRB,&
 &0.6233_JPRB, 0.5728_JPRB, 0.5700_JPRB, 0.7500_JPRB, 0.8863_JPRB, 1.2364_JPRB, 1.4982_JPRB, 1.7757_JPRB,&
 &1.9050_JPRB, 2.0538_JPRB, 2.0538_JPRB /)
ZOZCL(:,28,10) = (/&
 &0.3652_JPRB, 0.3652_JPRB, 0.4404_JPRB, 0.4940_JPRB, 0.8220_JPRB, 0.6328_JPRB, 0.2510_JPRB, 0.2327_JPRB,&
 &0.1303_JPRB, 0.1350_JPRB, 0.1380_JPRB, 0.1498_JPRB, 0.2285_JPRB, 0.4636_JPRB, 0.6430_JPRB, 0.8710_JPRB,&
 &1.0466_JPRB, 1.2723_JPRB, 1.2723_JPRB /)
ZOZCL(:,29,10) = (/&
 &0.3389_JPRB, 0.3389_JPRB, 0.3542_JPRB, 0.2953_JPRB, 0.3893_JPRB, 0.3197_JPRB, 0.1213_JPRB, 0.1104_JPRB,&
 &0.0632_JPRB, 0.0823_JPRB, 0.0647_JPRB, 0.0665_JPRB, 0.1016_JPRB, 0.1857_JPRB, 0.2449_JPRB, 0.3827_JPRB,&
 &0.4579_JPRB, 0.4815_JPRB, 0.4815_JPRB /)
ZOZCL(:,30,10) = (/&
 &0.1870_JPRB, 0.1870_JPRB, 0.2085_JPRB, 0.2174_JPRB, 0.2435_JPRB, 0.2014_JPRB, 0.1030_JPRB, 0.0932_JPRB,&
 &0.0541_JPRB, 0.0718_JPRB, 0.0475_JPRB, 0.0496_JPRB, 0.0732_JPRB, 0.1118_JPRB, 0.1368_JPRB, 0.2495_JPRB,&
 &0.2686_JPRB, 0.3042_JPRB, 0.3042_JPRB /)
ZOZCL(:,31,10) = (/&
 &0.0500_JPRB, 0.0500_JPRB, 0.0650_JPRB, 0.0617_JPRB, 0.0787_JPRB, 0.0777_JPRB, 0.0897_JPRB, 0.0823_JPRB,&
 &0.0509_JPRB, 0.0618_JPRB, 0.0443_JPRB, 0.0411_JPRB, 0.0544_JPRB, 0.0596_JPRB, 0.0680_JPRB, 0.1030_JPRB,&
 &0.0955_JPRB, 0.1119_JPRB, 0.1119_JPRB /)
ZOZCL(:,32,10) = (/&
 &0.0336_JPRB, 0.0336_JPRB, 0.0420_JPRB, 0.0396_JPRB, 0.0458_JPRB, 0.0480_JPRB, 0.0698_JPRB, 0.0658_JPRB,&
 &0.0539_JPRB, 0.0641_JPRB, 0.0462_JPRB, 0.0411_JPRB, 0.0496_JPRB, 0.0501_JPRB, 0.0543_JPRB, 0.0592_JPRB,&
 &0.0524_JPRB, 0.0541_JPRB, 0.0541_JPRB /)
ZOZCL(:,33,10) = (/&
 &0.0273_JPRB, 0.0273_JPRB, 0.0336_JPRB, 0.0323_JPRB, 0.0376_JPRB, 0.0347_JPRB, 0.0579_JPRB, 0.0540_JPRB,&
 &0.0438_JPRB, 0.0563_JPRB, 0.0390_JPRB, 0.0351_JPRB, 0.0453_JPRB, 0.0459_JPRB, 0.0470_JPRB, 0.0487_JPRB,&
 &0.0453_JPRB, 0.0401_JPRB, 0.0401_JPRB /)
ZOZCL(:,34,10) = (/&
 &0.0273_JPRB, 0.0273_JPRB, 0.0336_JPRB, 0.0323_JPRB, 0.0376_JPRB, 0.0347_JPRB, 0.0579_JPRB, 0.0540_JPRB,&
 &0.0438_JPRB, 0.0563_JPRB, 0.0390_JPRB, 0.0351_JPRB, 0.0453_JPRB, 0.0459_JPRB, 0.0470_JPRB, 0.0487_JPRB,&
 &0.0453_JPRB, 0.0401_JPRB, 0.0401_JPRB /) 

! Month: 11
ZOZCL(:, 1,11) = (/&
 &0.5000_JPRB, 0.5000_JPRB, 0.6000_JPRB, 0.6700_JPRB, 0.7400_JPRB, 0.8200_JPRB, 0.8400_JPRB, 0.7700_JPRB,&
 &0.7600_JPRB, 0.7900_JPRB, 0.8000_JPRB, 0.7700_JPRB, 0.8400_JPRB, 0.9800_JPRB, 0.9700_JPRB, 0.8800_JPRB,&
 &0.8800_JPRB, 0.7700_JPRB, 0.7700_JPRB /)
ZOZCL(:, 2,11) = (/&
 &0.3300_JPRB, 0.3300_JPRB, 0.4100_JPRB, 0.4800_JPRB, 0.5400_JPRB, 0.5900_JPRB, 0.5900_JPRB, 0.5500_JPRB,&
 &0.5300_JPRB, 0.5500_JPRB, 0.5700_JPRB, 0.5400_JPRB, 0.5400_JPRB, 0.5900_JPRB, 0.5200_JPRB, 0.4500_JPRB,&
 &0.4500_JPRB, 0.4000_JPRB, 0.4000_JPRB /)
ZOZCL(:, 3,11) = (/&
 &0.2400_JPRB, 0.2400_JPRB, 0.3000_JPRB, 0.3700_JPRB, 0.4200_JPRB, 0.4500_JPRB, 0.4500_JPRB, 0.4300_JPRB,&
 &0.4300_JPRB, 0.4500_JPRB, 0.4700_JPRB, 0.4300_JPRB, 0.4100_JPRB, 0.4100_JPRB, 0.3200_JPRB, 0.2400_JPRB,&
 &0.2400_JPRB, 0.2100_JPRB, 0.2100_JPRB /)
ZOZCL(:, 4,11) = (/&
 &0.1700_JPRB, 0.1700_JPRB, 0.2200_JPRB, 0.2600_JPRB, 0.3100_JPRB, 0.3200_JPRB, 0.3300_JPRB, 0.3200_JPRB,&
 &0.3300_JPRB, 0.3500_JPRB, 0.3700_JPRB, 0.3500_JPRB, 0.3200_JPRB, 0.3000_JPRB, 0.2400_JPRB, 0.1700_JPRB,&
 &0.1800_JPRB, 0.1600_JPRB, 0.1600_JPRB /)
ZOZCL(:, 5,11) = (/&
 &0.1500_JPRB, 0.1500_JPRB, 0.1700_JPRB, 0.1900_JPRB, 0.2100_JPRB, 0.2200_JPRB, 0.2200_JPRB, 0.2300_JPRB,&
 &0.2400_JPRB, 0.2500_JPRB, 0.2500_JPRB, 0.2500_JPRB, 0.2500_JPRB, 0.2400_JPRB, 0.2500_JPRB, 0.2200_JPRB,&
 &0.2200_JPRB, 0.1900_JPRB, 0.1900_JPRB /)
ZOZCL(:, 6,11) = (/&
 &0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1800_JPRB, 0.1800_JPRB, 0.1800_JPRB, 0.1800_JPRB, 0.1800_JPRB,&
 &0.2000_JPRB, 0.2000_JPRB, 0.2000_JPRB, 0.2000_JPRB, 0.2000_JPRB, 0.2000_JPRB, 0.2400_JPRB, 0.2600_JPRB,&
 &0.2600_JPRB, 0.2300_JPRB, 0.2300_JPRB /)
ZOZCL(:, 7,11) = (/&
 &0.2100_JPRB, 0.2100_JPRB, 0.2000_JPRB, 0.2000_JPRB, 0.2000_JPRB, 0.1900_JPRB, 0.1800_JPRB, 0.1700_JPRB,&
 &0.1800_JPRB, 0.1700_JPRB, 0.1600_JPRB, 0.1800_JPRB, 0.1800_JPRB, 0.1900_JPRB, 0.2400_JPRB, 0.3100_JPRB,&
 &0.3100_JPRB, 0.2700_JPRB, 0.2700_JPRB /)
ZOZCL(:, 8,11) = (/&
 &0.3100_JPRB, 0.3100_JPRB, 0.3000_JPRB, 0.3000_JPRB, 0.3000_JPRB, 0.2800_JPRB, 0.2700_JPRB, 0.2600_JPRB,&
 &0.2500_JPRB, 0.2500_JPRB, 0.2400_JPRB, 0.2500_JPRB, 0.2700_JPRB, 0.2800_JPRB, 0.3100_JPRB, 0.3800_JPRB,&
 &0.3800_JPRB, 0.3300_JPRB, 0.3300_JPRB /)
ZOZCL(:, 9,11) = (/&
 &0.4300_JPRB, 0.4300_JPRB, 0.4100_JPRB, 0.4100_JPRB, 0.4100_JPRB, 0.4000_JPRB, 0.3900_JPRB, 0.3800_JPRB,&
 &0.3700_JPRB, 0.3600_JPRB, 0.3700_JPRB, 0.3800_JPRB, 0.3900_JPRB, 0.4100_JPRB, 0.4300_JPRB, 0.4400_JPRB,&
 &0.4400_JPRB, 0.3900_JPRB, 0.3900_JPRB /)
ZOZCL(:,10,11) = (/&
 &0.5400_JPRB, 0.5400_JPRB, 0.5200_JPRB, 0.5100_JPRB, 0.4900_JPRB, 0.4600_JPRB, 0.4600_JPRB, 0.4600_JPRB,&
 &0.4600_JPRB, 0.4700_JPRB, 0.4800_JPRB, 0.5700_JPRB, 0.5700_JPRB, 0.5800_JPRB, 0.5900_JPRB, 0.5700_JPRB,&
 &0.5800_JPRB, 0.5100_JPRB, 0.5100_JPRB /)
ZOZCL(:,11,11) = (/&
 &0.7400_JPRB, 0.7400_JPRB, 0.7300_JPRB, 0.7400_JPRB, 0.7300_JPRB, 0.7100_JPRB, 0.7200_JPRB, 0.7100_JPRB,&
 &0.7000_JPRB, 0.7000_JPRB, 0.7100_JPRB, 0.7300_JPRB, 0.7000_JPRB, 0.7000_JPRB, 0.7100_JPRB, 0.7900_JPRB,&
 &0.7900_JPRB, 0.7000_JPRB, 0.7000_JPRB /)
ZOZCL(:,12,11) = (/&
 &0.9100_JPRB, 0.9100_JPRB, 0.9100_JPRB, 0.9100_JPRB, 0.9300_JPRB, 0.9300_JPRB, 0.9400_JPRB, 0.9400_JPRB,&
 &0.9400_JPRB, 0.9300_JPRB, 0.9400_JPRB, 0.9500_JPRB, 0.9600_JPRB, 0.9500_JPRB, 0.9100_JPRB, 0.9100_JPRB,&
 &0.9100_JPRB, 0.8000_JPRB, 0.8000_JPRB /)
ZOZCL(:,13,11) = (/&
 &1.2000_JPRB, 1.2000_JPRB, 1.2100_JPRB, 1.2400_JPRB, 1.2800_JPRB, 1.3200_JPRB, 1.3500_JPRB, 1.3800_JPRB,&
 &1.4000_JPRB, 1.3800_JPRB, 1.3800_JPRB, 1.4100_JPRB, 1.4500_JPRB, 1.4200_JPRB, 1.3700_JPRB, 1.2700_JPRB,&
 &1.2700_JPRB, 1.1200_JPRB, 1.1200_JPRB /)
ZOZCL(:,14,11) = (/&
 &1.5900_JPRB, 1.5900_JPRB, 1.6400_JPRB, 1.7200_JPRB, 1.7900_JPRB, 1.8500_JPRB, 1.9000_JPRB, 1.9400_JPRB,&
 &1.9800_JPRB, 1.9800_JPRB, 1.9800_JPRB, 1.9600_JPRB, 1.9900_JPRB, 2.0800_JPRB, 2.1900_JPRB, 2.0900_JPRB,&
 &2.0900_JPRB, 1.8400_JPRB, 1.8400_JPRB /)
ZOZCL(:,15,11) = (/&
 &1.8600_JPRB, 1.8600_JPRB, 1.9300_JPRB, 2.0700_JPRB, 2.1500_JPRB, 2.2100_JPRB, 2.2600_JPRB, 2.3000_JPRB,&
 &2.3600_JPRB, 2.3900_JPRB, 2.3700_JPRB, 2.3100_JPRB, 2.3700_JPRB, 2.6000_JPRB, 2.8700_JPRB, 2.9800_JPRB,&
 &2.8900_JPRB, 2.4200_JPRB, 2.4200_JPRB /)
ZOZCL(:,16,11) = (/&
 &2.4200_JPRB, 2.4200_JPRB, 2.4700_JPRB, 2.6300_JPRB, 2.7200_JPRB, 2.7800_JPRB, 2.8600_JPRB, 2.9400_JPRB,&
 &3.0200_JPRB, 3.0700_JPRB, 3.0600_JPRB, 3.0400_JPRB, 3.2200_JPRB, 3.6800_JPRB, 4.1400_JPRB, 4.2400_JPRB,&
 &3.9800_JPRB, 3.2400_JPRB, 3.2400_JPRB /)
ZOZCL(:,17,11) = (/&
 &3.3700_JPRB, 3.3700_JPRB, 3.3800_JPRB, 3.5500_JPRB, 3.6400_JPRB, 3.7100_JPRB, 3.8200_JPRB, 3.9400_JPRB,&
 &4.0200_JPRB, 4.0600_JPRB, 4.0900_JPRB, 4.1900_JPRB, 4.6000_JPRB, 5.3400_JPRB, 5.8700_JPRB, 5.7600_JPRB,&
 &5.2600_JPRB, 4.1400_JPRB, 4.1400_JPRB /) 

ZOZCL(:,18,11) = (/&
 &4.3800_JPRB, 4.3800_JPRB, 4.3900_JPRB, 4.5900_JPRB, 4.7100_JPRB, 4.7900_JPRB, 4.8900_JPRB, 5.0100_JPRB,&
 &5.0400_JPRB, 5.0500_JPRB, 5.0900_JPRB, 5.2600_JPRB, 5.7600_JPRB, 6.4600_JPRB, 6.7700_JPRB, 6.3800_JPRB,&
 &5.7800_JPRB, 4.5500_JPRB, 4.5500_JPRB /)
ZOZCL(:,19,11) = (/&
 &5.9600_JPRB, 5.9600_JPRB, 6.0600_JPRB, 6.3200_JPRB, 6.6100_JPRB, 6.7600_JPRB, 6.8500_JPRB, 6.9000_JPRB,&
 &6.8100_JPRB, 6.7000_JPRB, 6.7200_JPRB, 6.9200_JPRB, 7.2500_JPRB, 7.4300_JPRB, 7.1800_JPRB, 6.4500_JPRB,&
 &5.8800_JPRB, 4.7400_JPRB, 4.7400_JPRB /)
ZOZCL(:,20,11) = (/&
 &6.3900_JPRB, 6.3900_JPRB, 6.4800_JPRB, 7.1500_JPRB, 7.7700_JPRB, 8.2100_JPRB, 8.5200_JPRB, 8.6800_JPRB,&
 &8.5100_JPRB, 8.2700_JPRB, 8.2500_JPRB, 8.2200_JPRB, 7.9900_JPRB, 7.5200_JPRB, 6.8200_JPRB, 6.0400_JPRB,&
 &5.6700_JPRB, 4.2900_JPRB, 4.2900_JPRB /)
ZOZCL(:,21,11) = (/&
 &6.0300_JPRB, 6.0300_JPRB, 6.2400_JPRB, 7.0000_JPRB, 7.7200_JPRB, 8.3000_JPRB, 8.8100_JPRB, 9.1800_JPRB,&
 &9.2600_JPRB, 9.1100_JPRB, 8.9400_JPRB, 8.6200_JPRB, 8.0200_JPRB, 7.1400_JPRB, 6.3300_JPRB, 5.6700_JPRB,&
 &5.3900_JPRB, 3.8200_JPRB, 3.8200_JPRB /)
ZOZCL(:,22,11) = (/&
 &5.5800_JPRB, 5.5800_JPRB, 5.7800_JPRB, 6.5000_JPRB, 7.1600_JPRB, 7.7000_JPRB, 8.4000_JPRB, 8.9800_JPRB,&
 &9.4400_JPRB, 9.5900_JPRB, 9.2100_JPRB, 8.5300_JPRB, 7.6800_JPRB, 6.5700_JPRB, 5.7600_JPRB, 5.3100_JPRB,&
 &4.9900_JPRB, 3.4200_JPRB, 3.4200_JPRB /)
ZOZCL(:,23,11) = (/&
 &5.2715_JPRB, 5.2715_JPRB, 5.3393_JPRB, 5.9000_JPRB, 6.3100_JPRB, 6.7100_JPRB, 7.2900_JPRB, 7.7600_JPRB,&
 &8.1600_JPRB, 8.3100_JPRB, 8.0600_JPRB, 7.5100_JPRB, 6.8200_JPRB, 5.9300_JPRB, 5.3900_JPRB, 4.9800_JPRB,&
 &4.5200_JPRB, 3.1800_JPRB, 3.1800_JPRB /)
ZOZCL(:,24,11) = (/&
 &5.0164_JPRB, 5.0164_JPRB, 5.1827_JPRB, 5.2200_JPRB, 5.7300_JPRB, 5.9600_JPRB, 6.3300_JPRB, 6.5700_JPRB,&
 &6.7500_JPRB, 6.7700_JPRB, 6.6400_JPRB, 6.3600_JPRB, 5.9600_JPRB, 5.3900_JPRB, 5.0500_JPRB, 4.6800_JPRB,&
 &4.1100_JPRB, 3.0100_JPRB, 3.0100_JPRB /)
ZOZCL(:,25,11) = (/&
 &3.8180_JPRB, 3.8180_JPRB, 4.0890_JPRB, 4.4433_JPRB, 4.6700_JPRB, 4.8787_JPRB, 4.7767_JPRB, 4.6600_JPRB,&
 &4.3413_JPRB, 4.1637_JPRB, 4.3100_JPRB, 4.3700_JPRB, 4.4538_JPRB, 4.5045_JPRB, 4.5130_JPRB, 3.8410_JPRB,&
 &3.4766_JPRB, 2.9674_JPRB, 2.9674_JPRB /)
ZOZCL(:,26,11) = (/&
 &1.8826_JPRB, 1.8826_JPRB, 2.0512_JPRB, 2.7920_JPRB, 2.9240_JPRB, 2.9289_JPRB, 2.2350_JPRB, 2.0200_JPRB,&
 &1.6868_JPRB, 1.5394_JPRB, 1.6600_JPRB, 1.8100_JPRB, 1.9540_JPRB, 2.4411_JPRB, 2.6708_JPRB, 3.0020_JPRB,&
 &2.8432_JPRB, 2.9248_JPRB, 2.9248_JPRB /)
ZOZCL(:,27,11) = (/&
 &1.0698_JPRB, 1.0698_JPRB, 1.1287_JPRB, 1.9386_JPRB, 1.6729_JPRB, 1.5172_JPRB, 0.8607_JPRB, 0.8600_JPRB,&
 &0.6016_JPRB, 0.5556_JPRB, 0.6600_JPRB, 0.8100_JPRB, 0.8538_JPRB, 1.3784_JPRB, 1.6005_JPRB, 1.9543_JPRB,&
 &2.0807_JPRB, 2.1844_JPRB, 2.1844_JPRB /)
ZOZCL(:,28,11) = (/&
 &0.5528_JPRB, 0.5528_JPRB, 0.5834_JPRB, 0.8250_JPRB, 0.6770_JPRB, 0.6063_JPRB, 0.1660_JPRB, 0.1592_JPRB,&
 &0.1180_JPRB, 0.1394_JPRB, 0.1610_JPRB, 0.1603_JPRB, 0.2309_JPRB, 0.5118_JPRB, 0.6898_JPRB, 1.1380_JPRB,&
 &1.2988_JPRB, 1.4342_JPRB, 1.4342_JPRB /)
ZOZCL(:,29,11) = (/&
 &0.3854_JPRB, 0.3854_JPRB, 0.3701_JPRB, 0.3700_JPRB, 0.3027_JPRB, 0.3665_JPRB, 0.1187_JPRB, 0.1093_JPRB,&
 &0.0550_JPRB, 0.0837_JPRB, 0.0893_JPRB, 0.0756_JPRB, 0.1015_JPRB, 0.2158_JPRB, 0.2926_JPRB, 0.5020_JPRB,&
 &0.5740_JPRB, 0.6050_JPRB, 0.6050_JPRB /)
ZOZCL(:,30,11) = (/&
 &0.2489_JPRB, 0.2489_JPRB, 0.2443_JPRB, 0.2711_JPRB, 0.2035_JPRB, 0.2187_JPRB, 0.0980_JPRB, 0.0910_JPRB,&
 &0.0491_JPRB, 0.0595_JPRB, 0.0587_JPRB, 0.0516_JPRB, 0.0680_JPRB, 0.1358_JPRB, 0.1652_JPRB, 0.2735_JPRB,&
 &0.3147_JPRB, 0.3034_JPRB, 0.3034_JPRB /)
ZOZCL(:,31,11) = (/&
 &0.0634_JPRB, 0.0634_JPRB, 0.0734_JPRB, 0.0733_JPRB, 0.0687_JPRB, 0.0717_JPRB, 0.0807_JPRB, 0.0749_JPRB,&
 &0.0420_JPRB, 0.0545_JPRB, 0.0463_JPRB, 0.0464_JPRB, 0.0556_JPRB, 0.0645_JPRB, 0.0703_JPRB, 0.0897_JPRB,&
 &0.1083_JPRB, 0.0987_JPRB, 0.0987_JPRB /)
ZOZCL(:,32,11) = (/&
 &0.0297_JPRB, 0.0297_JPRB, 0.0362_JPRB, 0.0356_JPRB, 0.0432_JPRB, 0.0435_JPRB, 0.0682_JPRB, 0.0645_JPRB,&
 &0.0441_JPRB, 0.0525_JPRB, 0.0412_JPRB, 0.0434_JPRB, 0.0487_JPRB, 0.0479_JPRB, 0.0513_JPRB, 0.0498_JPRB,&
 &0.0487_JPRB, 0.0490_JPRB, 0.0490_JPRB /)
ZOZCL(:,33,11) = (/&
 &0.0238_JPRB, 0.0238_JPRB, 0.0277_JPRB, 0.0271_JPRB, 0.0351_JPRB, 0.0343_JPRB, 0.0571_JPRB, 0.0542_JPRB,&
 &0.0375_JPRB, 0.0434_JPRB, 0.0345_JPRB, 0.0362_JPRB, 0.0434_JPRB, 0.0439_JPRB, 0.0445_JPRB, 0.0443_JPRB,&
 &0.0422_JPRB, 0.0414_JPRB, 0.0414_JPRB /)
ZOZCL(:,34,11) = (/&
 &0.0238_JPRB, 0.0238_JPRB, 0.0277_JPRB, 0.0271_JPRB, 0.0351_JPRB, 0.0343_JPRB, 0.0571_JPRB, 0.0542_JPRB,&
 &0.0375_JPRB, 0.0434_JPRB, 0.0345_JPRB, 0.0362_JPRB, 0.0434_JPRB, 0.0439_JPRB, 0.0445_JPRB, 0.0443_JPRB,&
 &0.0422_JPRB, 0.0414_JPRB, 0.0414_JPRB /) 

! Month: 12
ZOZCL(:, 1,12) = (/&
 &0.5400_JPRB, 0.5400_JPRB, 0.7000_JPRB, 0.7900_JPRB, 0.8000_JPRB, 0.7500_JPRB, 0.6600_JPRB, 0.5800_JPRB,&
 &0.5700_JPRB, 0.5500_JPRB, 0.5200_JPRB, 0.6000_JPRB, 0.7900_JPRB, 0.9400_JPRB, 0.9600_JPRB, 0.9600_JPRB,&
 &0.8500_JPRB, 0.8200_JPRB, 0.8200_JPRB /)
ZOZCL(:, 2,12) = (/&
 &0.2800_JPRB, 0.2800_JPRB, 0.3500_JPRB, 0.4400_JPRB, 0.5200_JPRB, 0.5200_JPRB, 0.4700_JPRB, 0.4400_JPRB,&
 &0.4500_JPRB, 0.4400_JPRB, 0.4100_JPRB, 0.4100_JPRB, 0.4900_JPRB, 0.5800_JPRB, 0.5600_JPRB, 0.5700_JPRB,&
 &0.5000_JPRB, 0.4900_JPRB, 0.4900_JPRB /)
ZOZCL(:, 3,12) = (/&
 &0.2000_JPRB, 0.2000_JPRB, 0.2200_JPRB, 0.2700_JPRB, 0.3500_JPRB, 0.3800_JPRB, 0.3600_JPRB, 0.3700_JPRB,&
 &0.4000_JPRB, 0.4100_JPRB, 0.3900_JPRB, 0.3600_JPRB, 0.3500_JPRB, 0.3700_JPRB, 0.3300_JPRB, 0.3300_JPRB,&
 &0.2900_JPRB, 0.2800_JPRB, 0.2800_JPRB /)
ZOZCL(:, 4,12) = (/&
 &0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1900_JPRB, 0.2200_JPRB, 0.2500_JPRB, 0.2500_JPRB, 0.2800_JPRB,&
 &0.3200_JPRB, 0.3300_JPRB, 0.3300_JPRB, 0.3400_JPRB, 0.3100_JPRB, 0.2600_JPRB, 0.2100_JPRB, 0.2100_JPRB,&
 &0.1900_JPRB, 0.1800_JPRB, 0.1800_JPRB /)
ZOZCL(:, 5,12) = (/&
 &0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1800_JPRB, 0.2000_JPRB,&
 &0.2200_JPRB, 0.2200_JPRB, 0.2300_JPRB, 0.2600_JPRB, 0.2700_JPRB, 0.2600_JPRB, 0.2400_JPRB, 0.2400_JPRB,&
 &0.2100_JPRB, 0.2100_JPRB, 0.2100_JPRB /)
ZOZCL(:, 6,12) = (/&
 &0.1800_JPRB, 0.1800_JPRB, 0.1800_JPRB, 0.1700_JPRB, 0.1600_JPRB, 0.1600_JPRB, 0.1500_JPRB, 0.1600_JPRB,&
 &0.1700_JPRB, 0.1700_JPRB, 0.1800_JPRB, 0.2000_JPRB, 0.2300_JPRB, 0.2500_JPRB, 0.2700_JPRB, 0.2700_JPRB,&
 &0.2400_JPRB, 0.2300_JPRB, 0.2300_JPRB /)
ZOZCL(:, 7,12) = (/&
 &0.2200_JPRB, 0.2200_JPRB, 0.2000_JPRB, 0.2000_JPRB, 0.1900_JPRB, 0.1700_JPRB, 0.1600_JPRB, 0.1600_JPRB,&
 &0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1700_JPRB, 0.1900_JPRB, 0.2300_JPRB, 0.3100_JPRB, 0.3100_JPRB,&
 &0.2700_JPRB, 0.2700_JPRB, 0.2700_JPRB /)
ZOZCL(:, 8,12) = (/&
 &0.3300_JPRB, 0.3300_JPRB, 0.3000_JPRB, 0.2900_JPRB, 0.2800_JPRB, 0.2700_JPRB, 0.2500_JPRB, 0.2400_JPRB,&
 &0.2500_JPRB, 0.2500_JPRB, 0.2400_JPRB, 0.2600_JPRB, 0.3000_JPRB, 0.3400_JPRB, 0.3900_JPRB, 0.3900_JPRB,&
 &0.3400_JPRB, 0.3300_JPRB, 0.3300_JPRB /)
ZOZCL(:, 9,12) = (/&
 &0.4300_JPRB, 0.4300_JPRB, 0.4100_JPRB, 0.4000_JPRB, 0.3900_JPRB, 0.3900_JPRB, 0.3800_JPRB, 0.3600_JPRB,&
 &0.3500_JPRB, 0.3500_JPRB, 0.3500_JPRB, 0.3800_JPRB, 0.4500_JPRB, 0.4900_JPRB, 0.5100_JPRB, 0.5100_JPRB,&
 &0.4500_JPRB, 0.4400_JPRB, 0.4400_JPRB /)
ZOZCL(:,10,12) = (/&
 &0.5800_JPRB, 0.5800_JPRB, 0.5700_JPRB, 0.5200_JPRB, 0.5000_JPRB, 0.4800_JPRB, 0.4900_JPRB, 0.5100_JPRB,&
 &0.5000_JPRB, 0.4900_JPRB, 0.4800_JPRB, 0.4900_JPRB, 0.6500_JPRB, 0.7100_JPRB, 0.6900_JPRB, 0.7000_JPRB,&
 &0.6200_JPRB, 0.6000_JPRB, 0.6000_JPRB /)
ZOZCL(:,11,12) = (/&
 &0.7800_JPRB, 0.7800_JPRB, 0.7700_JPRB, 0.7600_JPRB, 0.7500_JPRB, 0.7500_JPRB, 0.7700_JPRB, 0.7700_JPRB,&
 &0.7400_JPRB, 0.7100_JPRB, 0.7100_JPRB, 0.7200_JPRB, 0.7600_JPRB, 0.8000_JPRB, 0.9900_JPRB, 0.9900_JPRB,&
 &0.8700_JPRB, 0.8500_JPRB, 0.8500_JPRB /)
ZOZCL(:,12,12) = (/&
 &0.9400_JPRB, 0.9400_JPRB, 0.9300_JPRB, 0.9500_JPRB, 0.9500_JPRB, 0.9600_JPRB, 1.0000_JPRB, 1.0100_JPRB,&
 &0.9600_JPRB, 0.9400_JPRB, 0.9400_JPRB, 0.9700_JPRB, 1.0200_JPRB, 1.0400_JPRB, 1.2500_JPRB, 1.2500_JPRB,&
 &1.1000_JPRB, 1.0700_JPRB, 1.0700_JPRB /)
ZOZCL(:,13,12) = (/&
 &1.2000_JPRB, 1.2000_JPRB, 1.2200_JPRB, 1.2600_JPRB, 1.2900_JPRB, 1.3300_JPRB, 1.3900_JPRB, 1.4200_JPRB,&
 &1.3900_JPRB, 1.3600_JPRB, 1.3700_JPRB, 1.4200_JPRB, 1.4800_JPRB, 1.5000_JPRB, 1.7800_JPRB, 1.7800_JPRB,&
 &1.5700_JPRB, 1.5200_JPRB, 1.5200_JPRB /)
ZOZCL(:,14,12) = (/&
 &1.4700_JPRB, 1.4700_JPRB, 1.5500_JPRB, 1.6500_JPRB, 1.7700_JPRB, 1.8600_JPRB, 1.9300_JPRB, 1.9700_JPRB,&
 &1.9800_JPRB, 1.9800_JPRB, 1.9800_JPRB, 1.9700_JPRB, 1.9900_JPRB, 2.0900_JPRB, 1.9400_JPRB, 1.9400_JPRB,&
 &1.7100_JPRB, 1.6600_JPRB, 1.6600_JPRB /)
ZOZCL(:,15,12) = (/&
 &1.6500_JPRB, 1.6500_JPRB, 1.7700_JPRB, 1.9400_JPRB, 2.1000_JPRB, 2.2100_JPRB, 2.2900_JPRB, 2.3400_JPRB,&
 &2.4000_JPRB, 2.4400_JPRB, 2.4100_JPRB, 2.3500_JPRB, 2.3800_JPRB, 2.5700_JPRB, 2.7100_JPRB, 2.6800_JPRB,&
 &2.2100_JPRB, 2.1500_JPRB, 2.1500_JPRB /)
ZOZCL(:,16,12) = (/&
 &2.1100_JPRB, 2.1100_JPRB, 2.2300_JPRB, 2.4200_JPRB, 2.5700_JPRB, 2.7200_JPRB, 2.8600_JPRB, 2.9900_JPRB,&
 &3.1100_JPRB, 3.1800_JPRB, 3.1500_JPRB, 3.1300_JPRB, 3.2500_JPRB, 3.6300_JPRB, 3.9200_JPRB, 3.7300_JPRB,&
 &3.0000_JPRB, 2.9300_JPRB, 2.9300_JPRB /)
ZOZCL(:,17,12) = (/&
 &2.9200_JPRB, 2.9200_JPRB, 3.0000_JPRB, 3.1900_JPRB, 3.3400_JPRB, 3.5300_JPRB, 3.7700_JPRB, 4.0100_JPRB,&
 &4.1800_JPRB, 4.2700_JPRB, 4.2900_JPRB, 4.3500_JPRB, 4.6600_JPRB, 5.2600_JPRB, 5.5900_JPRB, 5.1000_JPRB,&
 &4.1400_JPRB, 4.0300_JPRB, 4.0300_JPRB /)  

ZOZCL(:,18,12) = (/&
 &3.9000_JPRB, 3.9000_JPRB, 3.9500_JPRB, 4.1300_JPRB, 4.3100_JPRB, 4.5400_JPRB, 4.8100_JPRB, 5.0800_JPRB,&
 &5.2500_JPRB, 5.3200_JPRB, 5.3500_JPRB, 5.4500_JPRB, 5.8000_JPRB, 6.3600_JPRB, 6.4900_JPRB, 5.7900_JPRB,&
 &4.8600_JPRB, 4.7200_JPRB, 4.7200_JPRB /)
ZOZCL(:,19,12) = (/&
 &5.6100_JPRB, 5.6100_JPRB, 5.6400_JPRB, 5.8300_JPRB, 6.1600_JPRB, 6.4500_JPRB, 6.7100_JPRB, 6.9600_JPRB,&
 &7.0400_JPRB, 6.9900_JPRB, 6.9700_JPRB, 7.0200_JPRB, 7.1800_JPRB, 7.3100_JPRB, 6.9200_JPRB, 6.1000_JPRB,&
 &5.3900_JPRB, 5.2100_JPRB, 5.2100_JPRB /)
ZOZCL(:,20,12) = (/&
 &6.2700_JPRB, 6.2700_JPRB, 6.2300_JPRB, 6.8800_JPRB, 7.6200_JPRB, 7.9400_JPRB, 8.4000_JPRB, 8.7500_JPRB,&
 &8.7200_JPRB, 8.4800_JPRB, 8.1600_JPRB, 7.9900_JPRB, 7.8000_JPRB, 7.3300_JPRB, 6.5300_JPRB, 5.9400_JPRB,&
 &5.1900_JPRB, 4.9800_JPRB, 4.9800_JPRB /)
ZOZCL(:,21,12) = (/&
 &5.7900_JPRB, 5.7900_JPRB, 5.9500_JPRB, 6.8600_JPRB, 7.7600_JPRB, 8.2900_JPRB, 8.8600_JPRB, 9.2900_JPRB,&
 &9.3700_JPRB, 9.0300_JPRB, 8.6000_JPRB, 8.1500_JPRB, 7.7100_JPRB, 6.9600_JPRB, 6.0900_JPRB, 5.6900_JPRB,&
 &4.8100_JPRB, 4.6200_JPRB, 4.6200_JPRB /)
ZOZCL(:,22,12) = (/&
 &4.9900_JPRB, 4.9900_JPRB, 5.3900_JPRB, 6.3800_JPRB, 7.3500_JPRB, 8.0200_JPRB, 8.6600_JPRB, 9.1400_JPRB,&
 &9.4500_JPRB, 9.2400_JPRB, 8.6900_JPRB, 7.9100_JPRB, 7.2800_JPRB, 6.4100_JPRB, 5.6000_JPRB, 5.4200_JPRB,&
 &4.3700_JPRB, 4.2500_JPRB, 4.2500_JPRB /)
ZOZCL(:,23,12) = (/&
 &4.6332_JPRB, 4.6332_JPRB, 4.9550_JPRB, 5.8500_JPRB, 6.4400_JPRB, 7.0100_JPRB, 7.5100_JPRB, 7.8800_JPRB,&
 &8.1500_JPRB, 8.0800_JPRB, 7.6500_JPRB, 7.0200_JPRB, 6.5700_JPRB, 5.9400_JPRB, 5.4200_JPRB, 5.1000_JPRB,&
 &4.0800_JPRB, 4.0000_JPRB, 4.0000_JPRB /)
ZOZCL(:,24,12) = (/&
 &4.8574_JPRB, 4.8574_JPRB, 4.9240_JPRB, 5.4500_JPRB, 5.7500_JPRB, 6.1500_JPRB, 6.4700_JPRB, 6.6400_JPRB,&
 &6.6900_JPRB, 6.5500_JPRB, 6.3400_JPRB, 6.0500_JPRB, 5.8600_JPRB, 5.5400_JPRB, 5.2300_JPRB, 4.7700_JPRB,&
 &3.8600_JPRB, 3.7700_JPRB, 3.7700_JPRB /)
ZOZCL(:,25,12) = (/&
 &4.7325_JPRB, 4.7325_JPRB, 4.4182_JPRB, 4.3533_JPRB, 4.2633_JPRB, 4.4898_JPRB, 4.5542_JPRB, 4.6100_JPRB,&
 &4.4068_JPRB, 4.3667_JPRB, 4.3200_JPRB, 4.4100_JPRB, 4.6224_JPRB, 4.8237_JPRB, 4.8392_JPRB, 3.9730_JPRB,&
 &3.3764_JPRB, 3.4643_JPRB, 3.4643_JPRB /)
ZOZCL(:,26,12) = (/&
 &3.0907_JPRB, 3.0907_JPRB, 2.8831_JPRB, 2.4640_JPRB, 2.4420_JPRB, 2.6292_JPRB, 2.1590_JPRB, 2.0700_JPRB,&
 &1.5686_JPRB, 1.4776_JPRB, 1.5800_JPRB, 1.9000_JPRB, 2.1818_JPRB, 2.7110_JPRB, 3.0231_JPRB, 3.1760_JPRB,&
 &2.8928_JPRB, 3.1586_JPRB, 3.1586_JPRB /)
ZOZCL(:,27,12) = (/&
 &1.7454_JPRB, 1.7454_JPRB, 1.5773_JPRB, 1.6300_JPRB, 1.2857_JPRB, 1.3283_JPRB, 0.7750_JPRB, 0.9300_JPRB,&
 &0.5321_JPRB, 0.4725_JPRB, 0.6400_JPRB, 0.8800_JPRB, 0.9425_JPRB, 1.5350_JPRB, 1.8095_JPRB, 2.1829_JPRB,&
 &2.1034_JPRB, 2.3644_JPRB, 2.3644_JPRB /)
ZOZCL(:,28,12) = (/&
 &0.7455_JPRB, 0.7455_JPRB, 0.7238_JPRB, 0.8030_JPRB, 0.4890_JPRB, 0.4723_JPRB, 0.1650_JPRB, 0.1559_JPRB,&
 &0.0825_JPRB, 0.1756_JPRB, 0.1840_JPRB, 0.1397_JPRB, 0.3389_JPRB, 0.6753_JPRB, 0.8529_JPRB, 1.3150_JPRB,&
 &1.2478_JPRB, 1.4815_JPRB, 1.4815_JPRB /)
ZOZCL(:,29,12) = (/&
 &0.3825_JPRB, 0.3825_JPRB, 0.3773_JPRB, 0.3720_JPRB, 0.2427_JPRB, 0.1998_JPRB, 0.1060_JPRB, 0.0997_JPRB,&
 &0.0485_JPRB, 0.1056_JPRB, 0.1140_JPRB, 0.0693_JPRB, 0.1087_JPRB, 0.2997_JPRB, 0.3720_JPRB, 0.6467_JPRB,&
 &0.6166_JPRB, 0.6367_JPRB, 0.6367_JPRB /)
ZOZCL(:,30,12) = (/&
 &0.2977_JPRB, 0.2977_JPRB, 0.2726_JPRB, 0.2711_JPRB, 0.1600_JPRB, 0.1016_JPRB, 0.0905_JPRB, 0.0847_JPRB,&
 &0.0374_JPRB, 0.0820_JPRB, 0.0700_JPRB, 0.0536_JPRB, 0.0939_JPRB, 0.1798_JPRB, 0.2019_JPRB, 0.3510_JPRB,&
 &0.2935_JPRB, 0.3471_JPRB, 0.3471_JPRB /)
ZOZCL(:,31,12) = (/&
 &0.0783_JPRB, 0.0783_JPRB, 0.0717_JPRB, 0.0693_JPRB, 0.0600_JPRB, 0.0517_JPRB, 0.0713_JPRB, 0.0676_JPRB,&
 &0.0371_JPRB, 0.0614_JPRB, 0.0483_JPRB, 0.0488_JPRB, 0.0639_JPRB, 0.0688_JPRB, 0.0764_JPRB, 0.0943_JPRB,&
 &0.0892_JPRB, 0.1108_JPRB, 0.1108_JPRB /)
ZOZCL(:,32,12) = (/&
 &0.0262_JPRB, 0.0262_JPRB, 0.0372_JPRB, 0.0300_JPRB, 0.0378_JPRB, 0.0365_JPRB, 0.0552_JPRB, 0.0530_JPRB,&
 &0.0373_JPRB, 0.0685_JPRB, 0.0362_JPRB, 0.0437_JPRB, 0.0419_JPRB, 0.0452_JPRB, 0.0515_JPRB, 0.0458_JPRB,&
 &0.0440_JPRB, 0.0453_JPRB, 0.0453_JPRB /)
ZOZCL(:,33,12) = (/&
 &0.0220_JPRB, 0.0220_JPRB, 0.0281_JPRB, 0.0234_JPRB, 0.0307_JPRB, 0.0337_JPRB, 0.0520_JPRB, 0.0494_JPRB,&
 &0.0280_JPRB, 0.0420_JPRB, 0.0300_JPRB, 0.0379_JPRB, 0.0426_JPRB, 0.0409_JPRB, 0.0453_JPRB, 0.0411_JPRB,&
 &0.0391_JPRB, 0.0393_JPRB, 0.0393_JPRB /)
ZOZCL(:,34,12) = (/&
 &0.0220_JPRB, 0.0220_JPRB, 0.0281_JPRB, 0.0234_JPRB, 0.0307_JPRB, 0.0337_JPRB, 0.0520_JPRB, 0.0494_JPRB,&
 &0.0280_JPRB, 0.0420_JPRB, 0.0300_JPRB, 0.0379_JPRB, 0.0426_JPRB, 0.0409_JPRB, 0.0453_JPRB, 0.0411_JPRB,&
 &0.0391_JPRB, 0.0393_JPRB, 0.0393_JPRB /) 


! PRESSURE LEVELS FOR O3 CLIMATOLOGY

RPROC = (/&
            &_ZERO_ &
           &,                    0.3_JPRB,    _HALF_,    0.7_JPRB,      _ONE_ &
           &,     1.5_JPRB,    _TWO_,     3._JPRB,     5._JPRB,     7._JPRB,     10._JPRB &
           &,    15._JPRB,    20._JPRB,    30._JPRB,    50._JPRB,    70._JPRB,    100._JPRB &
           &,   150._JPRB,   200._JPRB,   300._JPRB,   500._JPRB,   700._JPRB,   1000._JPRB &
           &,  1500._JPRB,  2000._JPRB,  3000._JPRB,  5000._JPRB,  7000._JPRB,  10000._JPRB &
           &, 15000._JPRB, 20000._JPRB, 30000._JPRB, 50000._JPRB, 70000._JPRB, 100000._JPRB &
           &,                                         110000._JPRB &
           &/)

!     ------------------------------------------------------------------

!*         1.     TIME INDEX WITHIN OZONE CLIMATOLOGY
!                 -----------------------------------


IDY=NDD(KINDAT)-1
IMN=NMM(KINDAT)
IF (IMN == 1) THEN
  ZXTIME=REAL(IDY,KIND(ZXTIME))*1440._JPRB + KMINUT
ELSEIF (IMN == 2) THEN
  IF(IDY == 28) IDY=IDY-1
! A DAY IN FEB. IS 28.25*24*60/28=1452.8571min LONG.
  ZXTIME=44640._JPRB+REAL(IDY,KIND(ZXTIME))*1452.8571_JPRB+KMINUT
ELSE
  ZXTIME=(ZMDAY(IMN-1)+REAL(IDY,KIND(ZXTIME)))*1440._JPRB+KMINUT
ENDIF
! 525960=MINUTES IN A SIDERAL YEAR (365.25d)
ZXTIME=MOD(ZXTIME,525960._JPRB)

IM1=0
IM2=0
IF (ZXTIME <= ZYTIME(1)) THEN
  IM1=12
  IM2=1
  ZTIMI=(ZYTIME(1)-ZXTIME)/44640._JPRB
ELSEIF(ZXTIME > ZYTIME(12)) THEN
  IM1=12
  IM2=1
  ZTIMI=(548280._JPRB-ZXTIME)/44640._JPRB
! 548280.=(365.25d + 15.5d)*24*60
ELSE
  DO IM=1,11
    IF (ZXTIME > ZYTIME(IM) .AND. ZXTIME <= ZYTIME(IM+1)) THEN
      IM1=IM
      IM2=IM+1
      ZTIMI=(ZXTIME-ZYTIME(IM2))/(ZYTIME(IM1)-ZYTIME(IM2))
    ENDIF
  ENDDO
  IF (IM1 == 0.OR. IM2 == 0 ) THEN
!    CALL ABOR1('Problem with time interpolation in suecozc!')
    PRINT *,'Problem with time interpolation in suecozc!'
    STOP
  ENDIF
ENDIF


!*         2.0    TIME INTERPOLATED FIELD
!                 -----------------------


!*( Field is also transformed in kg/kg! )

DO JL=1,19
  DO JK=1,34
    ROZT(JL,JK)=RO3 * (ZOZCL(JL,JK,IM2)&
     &+ZTIMI*(ZOZCL(JL,JK,IM1)-ZOZCL(JL,JK,IM2)))
  ENDDO
  ROZT(JL, 0)=_ZERO_
  ROZT(JL,35)=ROZT(JL,34)
ENDDO


!     VECTOR OF LATITUDES FOR OZONE CLIMATOLOGY:

DO JL=1,19
  RSINC(JL)=SIN((-90._JPRB+(JL-1)*10._JPRB)*RPI/180._JPRB)
ENDDO

RETURN
END SUBROUTINE SUECOZC
