SUBROUTINE SUECAESU_01

!**   OPTICAL THICKNESS OF SULFATE-TYPE AEROSOLS
!                          January

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESU* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSU


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,1:1)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Total Sulfate Aerosol    month:  1 --- lat:  1  90.0
ZAER (:, 1, 1) = (/&
&.571E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,&
&.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,&
&.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,&
&.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,&
&.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,&
&.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,&
&.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,&
&.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,&
&.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,&
&.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,&
&.583E-02_JPRB,.583E-02_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat:  2  86.0
ZAER (:, 2, 1) = (/&
&.974E-02_JPRB,.106E-01_JPRB,.113E-01_JPRB,.118E-01_JPRB,.123E-01_JPRB,.124E-01_JPRB,.127E-01_JPRB,&
&.129E-01_JPRB,.131E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.130E-01_JPRB,.105E-01_JPRB,.965E-02_JPRB,&
&.869E-02_JPRB,.797E-02_JPRB,.738E-02_JPRB,.691E-02_JPRB,.642E-02_JPRB,.602E-02_JPRB,.580E-02_JPRB,&
&.560E-02_JPRB,.555E-02_JPRB,.559E-02_JPRB,.512E-02_JPRB,.517E-02_JPRB,.528E-02_JPRB,.540E-02_JPRB,&
&.551E-02_JPRB,.560E-02_JPRB,.569E-02_JPRB,.576E-02_JPRB,.581E-02_JPRB,.593E-02_JPRB,.598E-02_JPRB,&
&.598E-02_JPRB,.546E-02_JPRB,.541E-02_JPRB,.534E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.535E-02_JPRB,&
&.538E-02_JPRB,.539E-02_JPRB,.550E-02_JPRB,.556E-02_JPRB,.563E-02_JPRB,.569E-02_JPRB,.551E-02_JPRB,&
&.543E-02_JPRB,.533E-02_JPRB,.525E-02_JPRB,.516E-02_JPRB,.509E-02_JPRB,.507E-02_JPRB,.499E-02_JPRB,&
&.499E-02_JPRB,.497E-02_JPRB,.498E-02_JPRB,.500E-02_JPRB,.533E-02_JPRB,.536E-02_JPRB,.540E-02_JPRB,&
&.549E-02_JPRB,.568E-02_JPRB,.584E-02_JPRB,.604E-02_JPRB,.629E-02_JPRB,.661E-02_JPRB,.700E-02_JPRB,&
&.740E-02_JPRB,.792E-02_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat:  3  82.0
ZAER (:, 3, 1) = (/&
&.211E-01_JPRB,.229E-01_JPRB,.247E-01_JPRB,.260E-01_JPRB,.277E-01_JPRB,.287E-01_JPRB,.269E-01_JPRB,&
&.239E-01_JPRB,.215E-01_JPRB,.195E-01_JPRB,.180E-01_JPRB,.169E-01_JPRB,.144E-01_JPRB,.137E-01_JPRB,&
&.132E-01_JPRB,.124E-01_JPRB,.116E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.102E-01_JPRB,.943E-02_JPRB,&
&.856E-02_JPRB,.750E-02_JPRB,.628E-02_JPRB,.715E-02_JPRB,.753E-02_JPRB,.787E-02_JPRB,.813E-02_JPRB,&
&.843E-02_JPRB,.864E-02_JPRB,.742E-02_JPRB,.720E-02_JPRB,.713E-02_JPRB,.714E-02_JPRB,.738E-02_JPRB,&
&.767E-02_JPRB,.634E-02_JPRB,.627E-02_JPRB,.625E-02_JPRB,.624E-02_JPRB,.627E-02_JPRB,.623E-02_JPRB,&
&.573E-02_JPRB,.558E-02_JPRB,.559E-02_JPRB,.557E-02_JPRB,.565E-02_JPRB,.574E-02_JPRB,.570E-02_JPRB,&
&.567E-02_JPRB,.560E-02_JPRB,.555E-02_JPRB,.545E-02_JPRB,.531E-02_JPRB,.549E-02_JPRB,.545E-02_JPRB,&
&.530E-02_JPRB,.516E-02_JPRB,.505E-02_JPRB,.492E-02_JPRB,.533E-02_JPRB,.525E-02_JPRB,.534E-02_JPRB,&
&.554E-02_JPRB,.588E-02_JPRB,.627E-02_JPRB,.790E-02_JPRB,.774E-02_JPRB,.829E-02_JPRB,.981E-02_JPRB,&
&.122E-01_JPRB,.157E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat:  4  78.0
ZAER (:, 4, 1) = (/&
&.306E-01_JPRB,.322E-01_JPRB,.332E-01_JPRB,.323E-01_JPRB,.337E-01_JPRB,.366E-01_JPRB,.348E-01_JPRB,&
&.296E-01_JPRB,.252E-01_JPRB,.175E-01_JPRB,.148E-01_JPRB,.131E-01_JPRB,.121E-01_JPRB,.124E-01_JPRB,&
&.122E-01_JPRB,.128E-01_JPRB,.127E-01_JPRB,.126E-01_JPRB,.121E-01_JPRB,.116E-01_JPRB,.109E-01_JPRB,&
&.101E-01_JPRB,.848E-02_JPRB,.777E-02_JPRB,.860E-02_JPRB,.906E-02_JPRB,.105E-01_JPRB,.108E-01_JPRB,&
&.106E-01_JPRB,.102E-01_JPRB,.931E-02_JPRB,.917E-02_JPRB,.884E-02_JPRB,.705E-02_JPRB,.693E-02_JPRB,&
&.698E-02_JPRB,.629E-02_JPRB,.647E-02_JPRB,.662E-02_JPRB,.655E-02_JPRB,.659E-02_JPRB,.677E-02_JPRB,&
&.691E-02_JPRB,.705E-02_JPRB,.729E-02_JPRB,.792E-02_JPRB,.786E-02_JPRB,.780E-02_JPRB,.787E-02_JPRB,&
&.749E-02_JPRB,.693E-02_JPRB,.595E-02_JPRB,.593E-02_JPRB,.623E-02_JPRB,.610E-02_JPRB,.589E-02_JPRB,&
&.571E-02_JPRB,.575E-02_JPRB,.555E-02_JPRB,.544E-02_JPRB,.583E-02_JPRB,.612E-02_JPRB,.671E-02_JPRB,&
&.727E-02_JPRB,.775E-02_JPRB,.884E-02_JPRB,.101E-01_JPRB,.106E-01_JPRB,.128E-01_JPRB,.193E-01_JPRB,&
&.243E-01_JPRB,.276E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat:  5  74.0
ZAER (:, 5, 1) = (/&
&.317E-01_JPRB,.338E-01_JPRB,.327E-01_JPRB,.341E-01_JPRB,.372E-01_JPRB,.417E-01_JPRB,.423E-01_JPRB,&
&.364E-01_JPRB,.319E-01_JPRB,.277E-01_JPRB,.242E-01_JPRB,.201E-01_JPRB,.171E-01_JPRB,.170E-01_JPRB,&
&.178E-01_JPRB,.187E-01_JPRB,.205E-01_JPRB,.216E-01_JPRB,.193E-01_JPRB,.188E-01_JPRB,.184E-01_JPRB,&
&.156E-01_JPRB,.112E-01_JPRB,.914E-02_JPRB,.959E-02_JPRB,.123E-01_JPRB,.157E-01_JPRB,.167E-01_JPRB,&
&.148E-01_JPRB,.125E-01_JPRB,.121E-01_JPRB,.135E-01_JPRB,.117E-01_JPRB,.885E-02_JPRB,.752E-02_JPRB,&
&.701E-02_JPRB,.668E-02_JPRB,.640E-02_JPRB,.635E-02_JPRB,.662E-02_JPRB,.739E-02_JPRB,.868E-02_JPRB,&
&.949E-02_JPRB,.966E-02_JPRB,.903E-02_JPRB,.862E-02_JPRB,.867E-02_JPRB,.947E-02_JPRB,.108E-01_JPRB,&
&.121E-01_JPRB,.113E-01_JPRB,.890E-02_JPRB,.762E-02_JPRB,.765E-02_JPRB,.748E-02_JPRB,.720E-02_JPRB,&
&.723E-02_JPRB,.719E-02_JPRB,.711E-02_JPRB,.723E-02_JPRB,.750E-02_JPRB,.847E-02_JPRB,.968E-02_JPRB,&
&.105E-01_JPRB,.113E-01_JPRB,.122E-01_JPRB,.138E-01_JPRB,.155E-01_JPRB,.175E-01_JPRB,.216E-01_JPRB,&
&.273E-01_JPRB,.305E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat:  6  70.0
ZAER (:, 6, 1) = (/&
&.274E-01_JPRB,.318E-01_JPRB,.358E-01_JPRB,.372E-01_JPRB,.382E-01_JPRB,.417E-01_JPRB,.445E-01_JPRB,&
&.393E-01_JPRB,.364E-01_JPRB,.362E-01_JPRB,.349E-01_JPRB,.315E-01_JPRB,.272E-01_JPRB,.260E-01_JPRB,&
&.252E-01_JPRB,.209E-01_JPRB,.235E-01_JPRB,.259E-01_JPRB,.240E-01_JPRB,.278E-01_JPRB,.284E-01_JPRB,&
&.268E-01_JPRB,.223E-01_JPRB,.163E-01_JPRB,.142E-01_JPRB,.156E-01_JPRB,.170E-01_JPRB,.214E-01_JPRB,&
&.245E-01_JPRB,.200E-01_JPRB,.185E-01_JPRB,.165E-01_JPRB,.158E-01_JPRB,.112E-01_JPRB,.981E-02_JPRB,&
&.854E-02_JPRB,.829E-02_JPRB,.884E-02_JPRB,.110E-01_JPRB,.158E-01_JPRB,.220E-01_JPRB,.283E-01_JPRB,&
&.279E-01_JPRB,.235E-01_JPRB,.192E-01_JPRB,.150E-01_JPRB,.118E-01_JPRB,.100E-01_JPRB,.123E-01_JPRB,&
&.184E-01_JPRB,.245E-01_JPRB,.191E-01_JPRB,.135E-01_JPRB,.999E-02_JPRB,.867E-02_JPRB,.722E-02_JPRB,&
&.688E-02_JPRB,.725E-02_JPRB,.777E-02_JPRB,.850E-02_JPRB,.948E-02_JPRB,.103E-01_JPRB,.110E-01_JPRB,&
&.112E-01_JPRB,.117E-01_JPRB,.139E-01_JPRB,.160E-01_JPRB,.177E-01_JPRB,.202E-01_JPRB,.243E-01_JPRB,&
&.285E-01_JPRB,.282E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat:  7  66.0
ZAER (:, 7, 1) = (/&
&.336E-01_JPRB,.373E-01_JPRB,.384E-01_JPRB,.403E-01_JPRB,.404E-01_JPRB,.411E-01_JPRB,.385E-01_JPRB,&
&.388E-01_JPRB,.409E-01_JPRB,.450E-01_JPRB,.447E-01_JPRB,.392E-01_JPRB,.340E-01_JPRB,.266E-01_JPRB,&
&.240E-01_JPRB,.239E-01_JPRB,.229E-01_JPRB,.236E-01_JPRB,.246E-01_JPRB,.237E-01_JPRB,.236E-01_JPRB,&
&.247E-01_JPRB,.264E-01_JPRB,.220E-01_JPRB,.225E-01_JPRB,.250E-01_JPRB,.249E-01_JPRB,.280E-01_JPRB,&
&.314E-01_JPRB,.301E-01_JPRB,.254E-01_JPRB,.242E-01_JPRB,.220E-01_JPRB,.177E-01_JPRB,.152E-01_JPRB,&
&.138E-01_JPRB,.148E-01_JPRB,.195E-01_JPRB,.235E-01_JPRB,.296E-01_JPRB,.324E-01_JPRB,.335E-01_JPRB,&
&.389E-01_JPRB,.395E-01_JPRB,.353E-01_JPRB,.323E-01_JPRB,.337E-01_JPRB,.311E-01_JPRB,.312E-01_JPRB,&
&.307E-01_JPRB,.309E-01_JPRB,.289E-01_JPRB,.259E-01_JPRB,.211E-01_JPRB,.171E-01_JPRB,.147E-01_JPRB,&
&.130E-01_JPRB,.116E-01_JPRB,.118E-01_JPRB,.125E-01_JPRB,.139E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,&
&.149E-01_JPRB,.173E-01_JPRB,.211E-01_JPRB,.228E-01_JPRB,.249E-01_JPRB,.279E-01_JPRB,.301E-01_JPRB,&
&.299E-01_JPRB,.306E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat:  8  62.0
ZAER (:, 8, 1) = (/&
&.339E-01_JPRB,.349E-01_JPRB,.337E-01_JPRB,.329E-01_JPRB,.334E-01_JPRB,.344E-01_JPRB,.335E-01_JPRB,&
&.324E-01_JPRB,.332E-01_JPRB,.348E-01_JPRB,.364E-01_JPRB,.353E-01_JPRB,.310E-01_JPRB,.240E-01_JPRB,&
&.235E-01_JPRB,.237E-01_JPRB,.254E-01_JPRB,.252E-01_JPRB,.244E-01_JPRB,.233E-01_JPRB,.223E-01_JPRB,&
&.199E-01_JPRB,.194E-01_JPRB,.208E-01_JPRB,.235E-01_JPRB,.267E-01_JPRB,.299E-01_JPRB,.261E-01_JPRB,&
&.257E-01_JPRB,.290E-01_JPRB,.283E-01_JPRB,.248E-01_JPRB,.247E-01_JPRB,.272E-01_JPRB,.268E-01_JPRB,&
&.267E-01_JPRB,.262E-01_JPRB,.291E-01_JPRB,.340E-01_JPRB,.376E-01_JPRB,.382E-01_JPRB,.372E-01_JPRB,&
&.367E-01_JPRB,.391E-01_JPRB,.413E-01_JPRB,.405E-01_JPRB,.362E-01_JPRB,.338E-01_JPRB,.313E-01_JPRB,&
&.306E-01_JPRB,.294E-01_JPRB,.294E-01_JPRB,.324E-01_JPRB,.352E-01_JPRB,.360E-01_JPRB,.297E-01_JPRB,&
&.278E-01_JPRB,.247E-01_JPRB,.200E-01_JPRB,.179E-01_JPRB,.228E-01_JPRB,.256E-01_JPRB,.210E-01_JPRB,&
&.212E-01_JPRB,.241E-01_JPRB,.258E-01_JPRB,.259E-01_JPRB,.265E-01_JPRB,.257E-01_JPRB,.267E-01_JPRB,&
&.269E-01_JPRB,.299E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat:  9  58.0
ZAER (:, 9, 1) = (/&
&.248E-01_JPRB,.254E-01_JPRB,.263E-01_JPRB,.277E-01_JPRB,.294E-01_JPRB,.301E-01_JPRB,.299E-01_JPRB,&
&.305E-01_JPRB,.297E-01_JPRB,.277E-01_JPRB,.280E-01_JPRB,.302E-01_JPRB,.289E-01_JPRB,.249E-01_JPRB,&
&.226E-01_JPRB,.215E-01_JPRB,.224E-01_JPRB,.239E-01_JPRB,.229E-01_JPRB,.208E-01_JPRB,.209E-01_JPRB,&
&.208E-01_JPRB,.206E-01_JPRB,.200E-01_JPRB,.198E-01_JPRB,.194E-01_JPRB,.197E-01_JPRB,.212E-01_JPRB,&
&.230E-01_JPRB,.247E-01_JPRB,.249E-01_JPRB,.233E-01_JPRB,.288E-01_JPRB,.299E-01_JPRB,.319E-01_JPRB,&
&.334E-01_JPRB,.345E-01_JPRB,.373E-01_JPRB,.384E-01_JPRB,.398E-01_JPRB,.402E-01_JPRB,.369E-01_JPRB,&
&.332E-01_JPRB,.323E-01_JPRB,.311E-01_JPRB,.308E-01_JPRB,.300E-01_JPRB,.298E-01_JPRB,.263E-01_JPRB,&
&.281E-01_JPRB,.295E-01_JPRB,.307E-01_JPRB,.310E-01_JPRB,.307E-01_JPRB,.320E-01_JPRB,.313E-01_JPRB,&
&.307E-01_JPRB,.294E-01_JPRB,.289E-01_JPRB,.267E-01_JPRB,.298E-01_JPRB,.295E-01_JPRB,.228E-01_JPRB,&
&.207E-01_JPRB,.225E-01_JPRB,.232E-01_JPRB,.242E-01_JPRB,.236E-01_JPRB,.228E-01_JPRB,.230E-01_JPRB,&
&.244E-01_JPRB,.248E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 10  54.0
ZAER (:,10, 1) = (/&
&.209E-01_JPRB,.225E-01_JPRB,.237E-01_JPRB,.246E-01_JPRB,.250E-01_JPRB,.253E-01_JPRB,.265E-01_JPRB,&
&.277E-01_JPRB,.266E-01_JPRB,.256E-01_JPRB,.262E-01_JPRB,.277E-01_JPRB,.270E-01_JPRB,.242E-01_JPRB,&
&.230E-01_JPRB,.231E-01_JPRB,.226E-01_JPRB,.213E-01_JPRB,.207E-01_JPRB,.201E-01_JPRB,.207E-01_JPRB,&
&.204E-01_JPRB,.111E-01_JPRB,.184E-01_JPRB,.184E-01_JPRB,.184E-01_JPRB,.180E-01_JPRB,.194E-01_JPRB,&
&.209E-01_JPRB,.218E-01_JPRB,.223E-01_JPRB,.238E-01_JPRB,.265E-01_JPRB,.255E-01_JPRB,.260E-01_JPRB,&
&.307E-01_JPRB,.314E-01_JPRB,.318E-01_JPRB,.313E-01_JPRB,.305E-01_JPRB,.287E-01_JPRB,.275E-01_JPRB,&
&.256E-01_JPRB,.217E-01_JPRB,.205E-01_JPRB,.211E-01_JPRB,.235E-01_JPRB,.260E-01_JPRB,.260E-01_JPRB,&
&.258E-01_JPRB,.259E-01_JPRB,.248E-01_JPRB,.245E-01_JPRB,.247E-01_JPRB,.233E-01_JPRB,.224E-01_JPRB,&
&.236E-01_JPRB,.234E-01_JPRB,.245E-01_JPRB,.258E-01_JPRB,.258E-01_JPRB,.244E-01_JPRB,.245E-01_JPRB,&
&.225E-01_JPRB,.208E-01_JPRB,.209E-01_JPRB,.212E-01_JPRB,.212E-01_JPRB,.209E-01_JPRB,.203E-01_JPRB,&
&.208E-01_JPRB,.210E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 11  50.0
ZAER (:,11, 1) = (/&
&.206E-01_JPRB,.216E-01_JPRB,.224E-01_JPRB,.222E-01_JPRB,.218E-01_JPRB,.217E-01_JPRB,.217E-01_JPRB,&
&.221E-01_JPRB,.231E-01_JPRB,.227E-01_JPRB,.219E-01_JPRB,.226E-01_JPRB,.224E-01_JPRB,.203E-01_JPRB,&
&.196E-01_JPRB,.199E-01_JPRB,.200E-01_JPRB,.182E-01_JPRB,.168E-01_JPRB,.164E-01_JPRB,.161E-01_JPRB,&
&.149E-01_JPRB,.864E-02_JPRB,.145E-01_JPRB,.141E-01_JPRB,.146E-01_JPRB,.152E-01_JPRB,.167E-01_JPRB,&
&.184E-01_JPRB,.201E-01_JPRB,.213E-01_JPRB,.232E-01_JPRB,.244E-01_JPRB,.242E-01_JPRB,.225E-01_JPRB,&
&.227E-01_JPRB,.235E-01_JPRB,.230E-01_JPRB,.218E-01_JPRB,.211E-01_JPRB,.210E-01_JPRB,.186E-01_JPRB,&
&.169E-01_JPRB,.168E-01_JPRB,.171E-01_JPRB,.191E-01_JPRB,.214E-01_JPRB,.228E-01_JPRB,.212E-01_JPRB,&
&.215E-01_JPRB,.226E-01_JPRB,.213E-01_JPRB,.209E-01_JPRB,.204E-01_JPRB,.190E-01_JPRB,.174E-01_JPRB,&
&.175E-01_JPRB,.185E-01_JPRB,.187E-01_JPRB,.195E-01_JPRB,.207E-01_JPRB,.208E-01_JPRB,.214E-01_JPRB,&
&.219E-01_JPRB,.214E-01_JPRB,.200E-01_JPRB,.193E-01_JPRB,.196E-01_JPRB,.200E-01_JPRB,.197E-01_JPRB,&
&.195E-01_JPRB,.196E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 12  46.0
ZAER (:,12, 1) = (/&
&.202E-01_JPRB,.202E-01_JPRB,.192E-01_JPRB,.187E-01_JPRB,.190E-01_JPRB,.185E-01_JPRB,.179E-01_JPRB,&
&.175E-01_JPRB,.174E-01_JPRB,.191E-01_JPRB,.190E-01_JPRB,.188E-01_JPRB,.186E-01_JPRB,.180E-01_JPRB,&
&.155E-01_JPRB,.149E-01_JPRB,.147E-01_JPRB,.154E-01_JPRB,.149E-01_JPRB,.147E-01_JPRB,.150E-01_JPRB,&
&.144E-01_JPRB,.813E-02_JPRB,.145E-01_JPRB,.147E-01_JPRB,.149E-01_JPRB,.148E-01_JPRB,.158E-01_JPRB,&
&.167E-01_JPRB,.170E-01_JPRB,.175E-01_JPRB,.178E-01_JPRB,.180E-01_JPRB,.177E-01_JPRB,.182E-01_JPRB,&
&.186E-01_JPRB,.187E-01_JPRB,.188E-01_JPRB,.184E-01_JPRB,.183E-01_JPRB,.181E-01_JPRB,.174E-01_JPRB,&
&.165E-01_JPRB,.168E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.193E-01_JPRB,.207E-01_JPRB,.202E-01_JPRB,&
&.212E-01_JPRB,.207E-01_JPRB,.186E-01_JPRB,.180E-01_JPRB,.176E-01_JPRB,.165E-01_JPRB,.161E-01_JPRB,&
&.155E-01_JPRB,.154E-01_JPRB,.146E-01_JPRB,.147E-01_JPRB,.164E-01_JPRB,.181E-01_JPRB,.195E-01_JPRB,&
&.191E-01_JPRB,.186E-01_JPRB,.188E-01_JPRB,.188E-01_JPRB,.186E-01_JPRB,.188E-01_JPRB,.190E-01_JPRB,&
&.181E-01_JPRB,.188E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 13  42.0
ZAER (:,13, 1) = (/&
&.201E-01_JPRB,.189E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.173E-01_JPRB,.147E-01_JPRB,.138E-01_JPRB,&
&.136E-01_JPRB,.136E-01_JPRB,.137E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.141E-01_JPRB,.148E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB,.145E-01_JPRB,.143E-01_JPRB,.133E-01_JPRB,.123E-01_JPRB,.126E-01_JPRB,&
&.144E-01_JPRB,.879E-02_JPRB,.106E-01_JPRB,.191E-01_JPRB,.198E-01_JPRB,.176E-01_JPRB,.172E-01_JPRB,&
&.171E-01_JPRB,.174E-01_JPRB,.168E-01_JPRB,.158E-01_JPRB,.158E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,&
&.161E-01_JPRB,.158E-01_JPRB,.157E-01_JPRB,.156E-01_JPRB,.152E-01_JPRB,.158E-01_JPRB,.162E-01_JPRB,&
&.158E-01_JPRB,.171E-01_JPRB,.179E-01_JPRB,.173E-01_JPRB,.169E-01_JPRB,.165E-01_JPRB,.174E-01_JPRB,&
&.169E-01_JPRB,.167E-01_JPRB,.157E-01_JPRB,.153E-01_JPRB,.144E-01_JPRB,.121E-01_JPRB,.130E-01_JPRB,&
&.147E-01_JPRB,.156E-01_JPRB,.154E-01_JPRB,.147E-01_JPRB,.168E-01_JPRB,.173E-01_JPRB,.175E-01_JPRB,&
&.173E-01_JPRB,.177E-01_JPRB,.175E-01_JPRB,.181E-01_JPRB,.184E-01_JPRB,.188E-01_JPRB,.180E-01_JPRB,&
&.169E-01_JPRB,.173E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 14  38.0
ZAER (:,14, 1) = (/&
&.176E-01_JPRB,.145E-01_JPRB,.136E-01_JPRB,.142E-01_JPRB,.158E-01_JPRB,.134E-01_JPRB,.121E-01_JPRB,&
&.136E-01_JPRB,.134E-01_JPRB,.131E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.132E-01_JPRB,.134E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB,.129E-01_JPRB,.125E-01_JPRB,.121E-01_JPRB,.116E-01_JPRB,.122E-01_JPRB,&
&.169E-01_JPRB,.120E-01_JPRB,.153E-01_JPRB,.154E-01_JPRB,.269E-01_JPRB,.232E-01_JPRB,.215E-01_JPRB,&
&.203E-01_JPRB,.201E-01_JPRB,.194E-01_JPRB,.190E-01_JPRB,.184E-01_JPRB,.170E-01_JPRB,.155E-01_JPRB,&
&.150E-01_JPRB,.137E-01_JPRB,.136E-01_JPRB,.141E-01_JPRB,.150E-01_JPRB,.181E-01_JPRB,.188E-01_JPRB,&
&.176E-01_JPRB,.168E-01_JPRB,.167E-01_JPRB,.163E-01_JPRB,.163E-01_JPRB,.148E-01_JPRB,.143E-01_JPRB,&
&.149E-01_JPRB,.148E-01_JPRB,.136E-01_JPRB,.133E-01_JPRB,.130E-01_JPRB,.121E-01_JPRB,.114E-01_JPRB,&
&.120E-01_JPRB,.132E-01_JPRB,.146E-01_JPRB,.181E-01_JPRB,.177E-01_JPRB,.189E-01_JPRB,.179E-01_JPRB,&
&.182E-01_JPRB,.191E-01_JPRB,.117E-01_JPRB,.222E-01_JPRB,.214E-01_JPRB,.183E-01_JPRB,.165E-01_JPRB,&
&.158E-01_JPRB,.147E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 15  34.0
ZAER (:,15, 1) = (/&
&.149E-01_JPRB,.154E-01_JPRB,.150E-01_JPRB,.151E-01_JPRB,.153E-01_JPRB,.150E-01_JPRB,.148E-01_JPRB,&
&.147E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.144E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.142E-01_JPRB,&
&.140E-01_JPRB,.135E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.126E-01_JPRB,.124E-01_JPRB,.125E-01_JPRB,&
&.175E-01_JPRB,.146E-01_JPRB,.213E-01_JPRB,.188E-01_JPRB,.188E-01_JPRB,.275E-01_JPRB,.228E-01_JPRB,&
&.215E-01_JPRB,.206E-01_JPRB,.199E-01_JPRB,.192E-01_JPRB,.178E-01_JPRB,.159E-01_JPRB,.147E-01_JPRB,&
&.134E-01_JPRB,.130E-01_JPRB,.137E-01_JPRB,.149E-01_JPRB,.175E-01_JPRB,.116E-01_JPRB,.216E-01_JPRB,&
&.213E-01_JPRB,.186E-01_JPRB,.170E-01_JPRB,.158E-01_JPRB,.149E-01_JPRB,.146E-01_JPRB,.142E-01_JPRB,&
&.149E-01_JPRB,.147E-01_JPRB,.132E-01_JPRB,.136E-01_JPRB,.137E-01_JPRB,.118E-01_JPRB,.100E-01_JPRB,&
&.104E-01_JPRB,.123E-01_JPRB,.167E-01_JPRB,.220E-01_JPRB,.123E-01_JPRB,.196E-01_JPRB,.173E-01_JPRB,&
&.186E-01_JPRB,.111E-01_JPRB,.122E-01_JPRB,.117E-01_JPRB,.186E-01_JPRB,.161E-01_JPRB,.152E-01_JPRB,&
&.148E-01_JPRB,.153E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 16  30.0
ZAER (:,16, 1) = (/&
&.150E-01_JPRB,.154E-01_JPRB,.156E-01_JPRB,.155E-01_JPRB,.148E-01_JPRB,.147E-01_JPRB,.151E-01_JPRB,&
&.157E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.154E-01_JPRB,.157E-01_JPRB,.157E-01_JPRB,.153E-01_JPRB,&
&.147E-01_JPRB,.133E-01_JPRB,.127E-01_JPRB,.126E-01_JPRB,.125E-01_JPRB,.134E-01_JPRB,.135E-01_JPRB,&
&.229E-01_JPRB,.190E-01_JPRB,.215E-01_JPRB,.199E-01_JPRB,.192E-01_JPRB,.292E-01_JPRB,.250E-01_JPRB,&
&.214E-01_JPRB,.189E-01_JPRB,.189E-01_JPRB,.186E-01_JPRB,.173E-01_JPRB,.156E-01_JPRB,.151E-01_JPRB,&
&.146E-01_JPRB,.151E-01_JPRB,.168E-01_JPRB,.194E-01_JPRB,.216E-01_JPRB,.128E-01_JPRB,.172E-01_JPRB,&
&.164E-01_JPRB,.246E-01_JPRB,.180E-01_JPRB,.161E-01_JPRB,.150E-01_JPRB,.145E-01_JPRB,.153E-01_JPRB,&
&.163E-01_JPRB,.150E-01_JPRB,.144E-01_JPRB,.145E-01_JPRB,.135E-01_JPRB,.124E-01_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.144E-01_JPRB,.224E-01_JPRB,.166E-01_JPRB,.124E-01_JPRB,.119E-01_JPRB,.127E-01_JPRB,&
&.126E-01_JPRB,.120E-01_JPRB,.129E-01_JPRB,.109E-01_JPRB,.174E-01_JPRB,.149E-01_JPRB,.144E-01_JPRB,&
&.148E-01_JPRB,.149E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 17  26.0
ZAER (:,17, 1) = (/&
&.157E-01_JPRB,.156E-01_JPRB,.153E-01_JPRB,.145E-01_JPRB,.146E-01_JPRB,.147E-01_JPRB,.149E-01_JPRB,&
&.153E-01_JPRB,.153E-01_JPRB,.161E-01_JPRB,.168E-01_JPRB,.180E-01_JPRB,.189E-01_JPRB,.197E-01_JPRB,&
&.175E-01_JPRB,.155E-01_JPRB,.145E-01_JPRB,.123E-01_JPRB,.132E-01_JPRB,.154E-01_JPRB,.189E-01_JPRB,&
&.325E-01_JPRB,.190E-01_JPRB,.186E-01_JPRB,.181E-01_JPRB,.173E-01_JPRB,.180E-01_JPRB,.304E-01_JPRB,&
&.204E-01_JPRB,.167E-01_JPRB,.166E-01_JPRB,.169E-01_JPRB,.166E-01_JPRB,.156E-01_JPRB,.159E-01_JPRB,&
&.167E-01_JPRB,.161E-01_JPRB,.188E-01_JPRB,.226E-01_JPRB,.126E-01_JPRB,.137E-01_JPRB,.210E-01_JPRB,&
&.177E-01_JPRB,.254E-01_JPRB,.180E-01_JPRB,.150E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.156E-01_JPRB,&
&.165E-01_JPRB,.156E-01_JPRB,.143E-01_JPRB,.150E-01_JPRB,.147E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.151E-01_JPRB,.237E-01_JPRB,.346E-01_JPRB,.202E-01_JPRB,.135E-01_JPRB,.123E-01_JPRB,.138E-01_JPRB,&
&.167E-01_JPRB,.135E-01_JPRB,.132E-01_JPRB,.108E-01_JPRB,.176E-01_JPRB,.185E-01_JPRB,.192E-01_JPRB,&
&.178E-01_JPRB,.167E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 18  22.0
ZAER (:,18, 1) = (/&
&.183E-01_JPRB,.164E-01_JPRB,.157E-01_JPRB,.148E-01_JPRB,.153E-01_JPRB,.155E-01_JPRB,.158E-01_JPRB,&
&.159E-01_JPRB,.166E-01_JPRB,.175E-01_JPRB,.185E-01_JPRB,.198E-01_JPRB,.205E-01_JPRB,.207E-01_JPRB,&
&.205E-01_JPRB,.223E-01_JPRB,.224E-01_JPRB,.230E-01_JPRB,.273E-01_JPRB,.313E-01_JPRB,.366E-01_JPRB,&
&.491E-01_JPRB,.263E-01_JPRB,.182E-01_JPRB,.174E-01_JPRB,.145E-01_JPRB,.165E-01_JPRB,.143E-01_JPRB,&
&.184E-01_JPRB,.155E-01_JPRB,.158E-01_JPRB,.159E-01_JPRB,.156E-01_JPRB,.157E-01_JPRB,.163E-01_JPRB,&
&.177E-01_JPRB,.203E-01_JPRB,.239E-01_JPRB,.251E-01_JPRB,.112E-01_JPRB,.114E-01_JPRB,.164E-01_JPRB,&
&.157E-01_JPRB,.136E-01_JPRB,.161E-01_JPRB,.855E-02_JPRB,.145E-01_JPRB,.147E-01_JPRB,.155E-01_JPRB,&
&.152E-01_JPRB,.159E-01_JPRB,.155E-01_JPRB,.157E-01_JPRB,.163E-01_JPRB,.156E-01_JPRB,.167E-01_JPRB,&
&.227E-01_JPRB,.316E-01_JPRB,.379E-01_JPRB,.324E-01_JPRB,.150E-01_JPRB,.143E-01_JPRB,.153E-01_JPRB,&
&.185E-01_JPRB,.146E-01_JPRB,.126E-01_JPRB,.196E-01_JPRB,.223E-01_JPRB,.274E-01_JPRB,.313E-01_JPRB,&
&.267E-01_JPRB,.216E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 19  18.0
ZAER (:,19, 1) = (/&
&.180E-01_JPRB,.165E-01_JPRB,.163E-01_JPRB,.162E-01_JPRB,.169E-01_JPRB,.177E-01_JPRB,.183E-01_JPRB,&
&.188E-01_JPRB,.195E-01_JPRB,.200E-01_JPRB,.202E-01_JPRB,.199E-01_JPRB,.183E-01_JPRB,.190E-01_JPRB,&
&.207E-01_JPRB,.250E-01_JPRB,.275E-01_JPRB,.304E-01_JPRB,.337E-01_JPRB,.394E-01_JPRB,.526E-01_JPRB,&
&.962E-01_JPRB,.318E-01_JPRB,.205E-01_JPRB,.155E-01_JPRB,.129E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.106E-01_JPRB,.156E-01_JPRB,.158E-01_JPRB,.158E-01_JPRB,.152E-01_JPRB,.154E-01_JPRB,.167E-01_JPRB,&
&.196E-01_JPRB,.259E-01_JPRB,.299E-01_JPRB,.300E-01_JPRB,.116E-01_JPRB,.111E-01_JPRB,.149E-01_JPRB,&
&.116E-01_JPRB,.916E-02_JPRB,.130E-01_JPRB,.781E-02_JPRB,.126E-01_JPRB,.129E-01_JPRB,.136E-01_JPRB,&
&.143E-01_JPRB,.149E-01_JPRB,.159E-01_JPRB,.170E-01_JPRB,.182E-01_JPRB,.190E-01_JPRB,.211E-01_JPRB,&
&.268E-01_JPRB,.326E-01_JPRB,.386E-01_JPRB,.361E-01_JPRB,.297E-01_JPRB,.158E-01_JPRB,.156E-01_JPRB,&
&.172E-01_JPRB,.158E-01_JPRB,.135E-01_JPRB,.240E-01_JPRB,.295E-01_JPRB,.353E-01_JPRB,.468E-01_JPRB,&
&.386E-01_JPRB,.226E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 20  14.0
ZAER (:,20, 1) = (/&
&.181E-01_JPRB,.176E-01_JPRB,.181E-01_JPRB,.188E-01_JPRB,.197E-01_JPRB,.211E-01_JPRB,.222E-01_JPRB,&
&.230E-01_JPRB,.238E-01_JPRB,.241E-01_JPRB,.233E-01_JPRB,.219E-01_JPRB,.197E-01_JPRB,.207E-01_JPRB,&
&.242E-01_JPRB,.265E-01_JPRB,.280E-01_JPRB,.296E-01_JPRB,.338E-01_JPRB,.447E-01_JPRB,.652E-01_JPRB,&
&.390E-01_JPRB,.269E-01_JPRB,.184E-01_JPRB,.133E-01_JPRB,.119E-01_JPRB,.114E-01_JPRB,.121E-01_JPRB,&
&.110E-01_JPRB,.165E-01_JPRB,.163E-01_JPRB,.160E-01_JPRB,.151E-01_JPRB,.154E-01_JPRB,.166E-01_JPRB,&
&.197E-01_JPRB,.225E-01_JPRB,.279E-01_JPRB,.274E-01_JPRB,.106E-01_JPRB,.102E-01_JPRB,.150E-01_JPRB,&
&.113E-01_JPRB,.793E-02_JPRB,.685E-02_JPRB,.123E-01_JPRB,.120E-01_JPRB,.125E-01_JPRB,.131E-01_JPRB,&
&.142E-01_JPRB,.152E-01_JPRB,.168E-01_JPRB,.184E-01_JPRB,.207E-01_JPRB,.233E-01_JPRB,.269E-01_JPRB,&
&.319E-01_JPRB,.388E-01_JPRB,.442E-01_JPRB,.352E-01_JPRB,.343E-01_JPRB,.331E-01_JPRB,.189E-01_JPRB,&
&.200E-01_JPRB,.343E-01_JPRB,.327E-01_JPRB,.331E-01_JPRB,.354E-01_JPRB,.399E-01_JPRB,.492E-01_JPRB,&
&.366E-01_JPRB,.223E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 21  10.0
ZAER (:,21, 1) = (/&
&.200E-01_JPRB,.203E-01_JPRB,.212E-01_JPRB,.219E-01_JPRB,.232E-01_JPRB,.248E-01_JPRB,.261E-01_JPRB,&
&.271E-01_JPRB,.284E-01_JPRB,.286E-01_JPRB,.281E-01_JPRB,.272E-01_JPRB,.270E-01_JPRB,.266E-01_JPRB,&
&.283E-01_JPRB,.313E-01_JPRB,.315E-01_JPRB,.310E-01_JPRB,.418E-01_JPRB,.569E-01_JPRB,.457E-01_JPRB,&
&.204E-01_JPRB,.196E-01_JPRB,.140E-01_JPRB,.128E-01_JPRB,.122E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.120E-01_JPRB,.177E-01_JPRB,.171E-01_JPRB,.170E-01_JPRB,.153E-01_JPRB,.148E-01_JPRB,.150E-01_JPRB,&
&.153E-01_JPRB,.190E-01_JPRB,.206E-01_JPRB,.221E-01_JPRB,.107E-01_JPRB,.106E-01_JPRB,.129E-01_JPRB,&
&.102E-01_JPRB,.788E-02_JPRB,.114E-01_JPRB,.121E-01_JPRB,.126E-01_JPRB,.132E-01_JPRB,.137E-01_JPRB,&
&.147E-01_JPRB,.161E-01_JPRB,.181E-01_JPRB,.202E-01_JPRB,.238E-01_JPRB,.271E-01_JPRB,.316E-01_JPRB,&
&.402E-01_JPRB,.637E-01_JPRB,.814E-01_JPRB,.517E-01_JPRB,.424E-01_JPRB,.426E-01_JPRB,.406E-01_JPRB,&
&.455E-01_JPRB,.510E-01_JPRB,.498E-01_JPRB,.445E-01_JPRB,.435E-01_JPRB,.418E-01_JPRB,.414E-01_JPRB,&
&.308E-01_JPRB,.219E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 22   6.0
ZAER (:,22, 1) = (/&
&.234E-01_JPRB,.241E-01_JPRB,.250E-01_JPRB,.259E-01_JPRB,.274E-01_JPRB,.293E-01_JPRB,.308E-01_JPRB,&
&.320E-01_JPRB,.342E-01_JPRB,.348E-01_JPRB,.345E-01_JPRB,.325E-01_JPRB,.316E-01_JPRB,.326E-01_JPRB,&
&.344E-01_JPRB,.376E-01_JPRB,.407E-01_JPRB,.424E-01_JPRB,.482E-01_JPRB,.489E-01_JPRB,.242E-01_JPRB,&
&.192E-01_JPRB,.163E-01_JPRB,.145E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.148E-01_JPRB,.133E-01_JPRB,&
&.132E-01_JPRB,.191E-01_JPRB,.195E-01_JPRB,.190E-01_JPRB,.178E-01_JPRB,.169E-01_JPRB,.172E-01_JPRB,&
&.189E-01_JPRB,.211E-01_JPRB,.209E-01_JPRB,.213E-01_JPRB,.121E-01_JPRB,.128E-01_JPRB,.136E-01_JPRB,&
&.109E-01_JPRB,.891E-02_JPRB,.129E-01_JPRB,.138E-01_JPRB,.140E-01_JPRB,.145E-01_JPRB,.150E-01_JPRB,&
&.158E-01_JPRB,.173E-01_JPRB,.201E-01_JPRB,.234E-01_JPRB,.283E-01_JPRB,.325E-01_JPRB,.392E-01_JPRB,&
&.536E-01_JPRB,.791E-01_JPRB,.855E-01_JPRB,.651E-01_JPRB,.554E-01_JPRB,.540E-01_JPRB,.534E-01_JPRB,&
&.567E-01_JPRB,.334E-01_JPRB,.370E-01_JPRB,.589E-01_JPRB,.479E-01_JPRB,.409E-01_JPRB,.335E-01_JPRB,&
&.273E-01_JPRB,.236E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 23   2.0
ZAER (:,23, 1) = (/&
&.288E-01_JPRB,.304E-01_JPRB,.325E-01_JPRB,.338E-01_JPRB,.357E-01_JPRB,.388E-01_JPRB,.410E-01_JPRB,&
&.428E-01_JPRB,.474E-01_JPRB,.495E-01_JPRB,.500E-01_JPRB,.526E-01_JPRB,.545E-01_JPRB,.562E-01_JPRB,&
&.583E-01_JPRB,.563E-01_JPRB,.575E-01_JPRB,.566E-01_JPRB,.604E-01_JPRB,.495E-01_JPRB,.271E-01_JPRB,&
&.229E-01_JPRB,.174E-01_JPRB,.166E-01_JPRB,.161E-01_JPRB,.163E-01_JPRB,.173E-01_JPRB,.159E-01_JPRB,&
&.252E-01_JPRB,.253E-01_JPRB,.251E-01_JPRB,.243E-01_JPRB,.235E-01_JPRB,.222E-01_JPRB,.211E-01_JPRB,&
&.213E-01_JPRB,.210E-01_JPRB,.213E-01_JPRB,.132E-01_JPRB,.139E-01_JPRB,.152E-01_JPRB,.178E-01_JPRB,&
&.129E-01_JPRB,.103E-01_JPRB,.863E-02_JPRB,.153E-01_JPRB,.161E-01_JPRB,.167E-01_JPRB,.172E-01_JPRB,&
&.183E-01_JPRB,.198E-01_JPRB,.225E-01_JPRB,.268E-01_JPRB,.310E-01_JPRB,.357E-01_JPRB,.402E-01_JPRB,&
&.504E-01_JPRB,.387E-01_JPRB,.604E-01_JPRB,.321E-01_JPRB,.566E-01_JPRB,.626E-01_JPRB,.652E-01_JPRB,&
&.330E-01_JPRB,.549E-01_JPRB,.565E-01_JPRB,.507E-01_JPRB,.394E-01_JPRB,.340E-01_JPRB,.304E-01_JPRB,&
&.286E-01_JPRB,.279E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 24  -2.0
ZAER (:,24, 1) = (/&
&.372E-01_JPRB,.409E-01_JPRB,.440E-01_JPRB,.475E-01_JPRB,.502E-01_JPRB,.538E-01_JPRB,.569E-01_JPRB,&
&.608E-01_JPRB,.661E-01_JPRB,.675E-01_JPRB,.697E-01_JPRB,.729E-01_JPRB,.753E-01_JPRB,.758E-01_JPRB,&
&.748E-01_JPRB,.754E-01_JPRB,.769E-01_JPRB,.638E-01_JPRB,.523E-01_JPRB,.417E-01_JPRB,.406E-01_JPRB,&
&.205E-01_JPRB,.186E-01_JPRB,.185E-01_JPRB,.183E-01_JPRB,.189E-01_JPRB,.306E-01_JPRB,.304E-01_JPRB,&
&.306E-01_JPRB,.291E-01_JPRB,.283E-01_JPRB,.263E-01_JPRB,.252E-01_JPRB,.235E-01_JPRB,.223E-01_JPRB,&
&.215E-01_JPRB,.213E-01_JPRB,.221E-01_JPRB,.137E-01_JPRB,.148E-01_JPRB,.159E-01_JPRB,.164E-01_JPRB,&
&.147E-01_JPRB,.126E-01_JPRB,.123E-01_JPRB,.118E-01_JPRB,.190E-01_JPRB,.198E-01_JPRB,.207E-01_JPRB,&
&.219E-01_JPRB,.231E-01_JPRB,.244E-01_JPRB,.258E-01_JPRB,.279E-01_JPRB,.310E-01_JPRB,.372E-01_JPRB,&
&.261E-01_JPRB,.526E-01_JPRB,.504E-01_JPRB,.280E-01_JPRB,.641E-01_JPRB,.913E-01_JPRB,.723E-01_JPRB,&
&.568E-01_JPRB,.515E-01_JPRB,.459E-01_JPRB,.416E-01_JPRB,.348E-01_JPRB,.326E-01_JPRB,.318E-01_JPRB,&
&.326E-01_JPRB,.346E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 25  -6.0
ZAER (:,25, 1) = (/&
&.389E-01_JPRB,.416E-01_JPRB,.442E-01_JPRB,.468E-01_JPRB,.494E-01_JPRB,.518E-01_JPRB,.549E-01_JPRB,&
&.594E-01_JPRB,.636E-01_JPRB,.665E-01_JPRB,.677E-01_JPRB,.687E-01_JPRB,.704E-01_JPRB,.734E-01_JPRB,&
&.752E-01_JPRB,.754E-01_JPRB,.733E-01_JPRB,.636E-01_JPRB,.529E-01_JPRB,.433E-01_JPRB,.362E-01_JPRB,&
&.201E-01_JPRB,.208E-01_JPRB,.195E-01_JPRB,.196E-01_JPRB,.335E-01_JPRB,.334E-01_JPRB,.339E-01_JPRB,&
&.328E-01_JPRB,.325E-01_JPRB,.328E-01_JPRB,.313E-01_JPRB,.297E-01_JPRB,.278E-01_JPRB,.165E-01_JPRB,&
&.161E-01_JPRB,.163E-01_JPRB,.155E-01_JPRB,.147E-01_JPRB,.152E-01_JPRB,.166E-01_JPRB,.160E-01_JPRB,&
&.151E-01_JPRB,.137E-01_JPRB,.125E-01_JPRB,.141E-01_JPRB,.222E-01_JPRB,.231E-01_JPRB,.238E-01_JPRB,&
&.249E-01_JPRB,.260E-01_JPRB,.273E-01_JPRB,.262E-01_JPRB,.264E-01_JPRB,.271E-01_JPRB,.311E-01_JPRB,&
&.360E-01_JPRB,.382E-01_JPRB,.439E-01_JPRB,.488E-01_JPRB,.657E-01_JPRB,.629E-01_JPRB,.514E-01_JPRB,&
&.470E-01_JPRB,.433E-01_JPRB,.401E-01_JPRB,.376E-01_JPRB,.335E-01_JPRB,.326E-01_JPRB,.329E-01_JPRB,&
&.344E-01_JPRB,.365E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 26 -10.0
ZAER (:,26, 1) = (/&
&.382E-01_JPRB,.410E-01_JPRB,.433E-01_JPRB,.447E-01_JPRB,.450E-01_JPRB,.461E-01_JPRB,.487E-01_JPRB,&
&.542E-01_JPRB,.591E-01_JPRB,.629E-01_JPRB,.655E-01_JPRB,.690E-01_JPRB,.724E-01_JPRB,.758E-01_JPRB,&
&.790E-01_JPRB,.804E-01_JPRB,.811E-01_JPRB,.823E-01_JPRB,.908E-01_JPRB,.521E-01_JPRB,.353E-01_JPRB,&
&.211E-01_JPRB,.207E-01_JPRB,.195E-01_JPRB,.333E-01_JPRB,.335E-01_JPRB,.335E-01_JPRB,.338E-01_JPRB,&
&.349E-01_JPRB,.376E-01_JPRB,.410E-01_JPRB,.437E-01_JPRB,.430E-01_JPRB,.393E-01_JPRB,.220E-01_JPRB,&
&.230E-01_JPRB,.244E-01_JPRB,.224E-01_JPRB,.196E-01_JPRB,.176E-01_JPRB,.156E-01_JPRB,.153E-01_JPRB,&
&.140E-01_JPRB,.136E-01_JPRB,.131E-01_JPRB,.141E-01_JPRB,.146E-01_JPRB,.264E-01_JPRB,.270E-01_JPRB,&
&.274E-01_JPRB,.277E-01_JPRB,.283E-01_JPRB,.284E-01_JPRB,.289E-01_JPRB,.291E-01_JPRB,.317E-01_JPRB,&
&.317E-01_JPRB,.331E-01_JPRB,.388E-01_JPRB,.476E-01_JPRB,.526E-01_JPRB,.459E-01_JPRB,.428E-01_JPRB,&
&.412E-01_JPRB,.391E-01_JPRB,.368E-01_JPRB,.348E-01_JPRB,.322E-01_JPRB,.319E-01_JPRB,.328E-01_JPRB,&
&.344E-01_JPRB,.360E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 27 -14.0
ZAER (:,27, 1) = (/&
&.374E-01_JPRB,.420E-01_JPRB,.472E-01_JPRB,.486E-01_JPRB,.423E-01_JPRB,.345E-01_JPRB,.345E-01_JPRB,&
&.365E-01_JPRB,.425E-01_JPRB,.490E-01_JPRB,.553E-01_JPRB,.629E-01_JPRB,.730E-01_JPRB,.778E-01_JPRB,&
&.805E-01_JPRB,.800E-01_JPRB,.772E-01_JPRB,.812E-01_JPRB,.373E-01_JPRB,.227E-01_JPRB,.337E-01_JPRB,&
&.340E-01_JPRB,.347E-01_JPRB,.327E-01_JPRB,.320E-01_JPRB,.319E-01_JPRB,.319E-01_JPRB,.326E-01_JPRB,&
&.342E-01_JPRB,.380E-01_JPRB,.429E-01_JPRB,.454E-01_JPRB,.467E-01_JPRB,.287E-01_JPRB,.268E-01_JPRB,&
&.247E-01_JPRB,.234E-01_JPRB,.219E-01_JPRB,.207E-01_JPRB,.221E-01_JPRB,.193E-01_JPRB,.146E-01_JPRB,&
&.131E-01_JPRB,.143E-01_JPRB,.149E-01_JPRB,.134E-01_JPRB,.243E-01_JPRB,.267E-01_JPRB,.290E-01_JPRB,&
&.326E-01_JPRB,.342E-01_JPRB,.183E-01_JPRB,.301E-01_JPRB,.336E-01_JPRB,.358E-01_JPRB,.409E-01_JPRB,&
&.212E-01_JPRB,.200E-01_JPRB,.368E-01_JPRB,.441E-01_JPRB,.444E-01_JPRB,.401E-01_JPRB,.393E-01_JPRB,&
&.387E-01_JPRB,.376E-01_JPRB,.350E-01_JPRB,.321E-01_JPRB,.306E-01_JPRB,.303E-01_JPRB,.311E-01_JPRB,&
&.326E-01_JPRB,.346E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 28 -18.0
ZAER (:,28, 1) = (/&
&.350E-01_JPRB,.436E-01_JPRB,.592E-01_JPRB,.731E-01_JPRB,.807E-01_JPRB,.255E-01_JPRB,.200E-01_JPRB,&
&.200E-01_JPRB,.243E-01_JPRB,.298E-01_JPRB,.380E-01_JPRB,.492E-01_JPRB,.637E-01_JPRB,.731E-01_JPRB,&
&.718E-01_JPRB,.723E-01_JPRB,.348E-01_JPRB,.309E-01_JPRB,.246E-01_JPRB,.344E-01_JPRB,.325E-01_JPRB,&
&.312E-01_JPRB,.329E-01_JPRB,.319E-01_JPRB,.311E-01_JPRB,.306E-01_JPRB,.312E-01_JPRB,.340E-01_JPRB,&
&.369E-01_JPRB,.388E-01_JPRB,.404E-01_JPRB,.431E-01_JPRB,.464E-01_JPRB,.280E-01_JPRB,.268E-01_JPRB,&
&.252E-01_JPRB,.225E-01_JPRB,.208E-01_JPRB,.199E-01_JPRB,.189E-01_JPRB,.201E-01_JPRB,.237E-01_JPRB,&
&.186E-01_JPRB,.162E-01_JPRB,.282E-01_JPRB,.163E-01_JPRB,.165E-01_JPRB,.158E-01_JPRB,.277E-01_JPRB,&
&.318E-01_JPRB,.417E-01_JPRB,.228E-01_JPRB,.213E-01_JPRB,.376E-01_JPRB,.535E-01_JPRB,.438E-01_JPRB,&
&.423E-01_JPRB,.283E-01_JPRB,.412E-01_JPRB,.383E-01_JPRB,.360E-01_JPRB,.356E-01_JPRB,.359E-01_JPRB,&
&.357E-01_JPRB,.361E-01_JPRB,.334E-01_JPRB,.281E-01_JPRB,.262E-01_JPRB,.259E-01_JPRB,.264E-01_JPRB,&
&.281E-01_JPRB,.314E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 29 -22.0
ZAER (:,29, 1) = (/&
&.361E-01_JPRB,.444E-01_JPRB,.552E-01_JPRB,.547E-01_JPRB,.331E-01_JPRB,.171E-01_JPRB,.152E-01_JPRB,&
&.148E-01_JPRB,.149E-01_JPRB,.170E-01_JPRB,.233E-01_JPRB,.345E-01_JPRB,.480E-01_JPRB,.606E-01_JPRB,&
&.645E-01_JPRB,.365E-01_JPRB,.287E-01_JPRB,.460E-01_JPRB,.421E-01_JPRB,.395E-01_JPRB,.342E-01_JPRB,&
&.311E-01_JPRB,.305E-01_JPRB,.309E-01_JPRB,.304E-01_JPRB,.306E-01_JPRB,.316E-01_JPRB,.339E-01_JPRB,&
&.337E-01_JPRB,.337E-01_JPRB,.350E-01_JPRB,.384E-01_JPRB,.415E-01_JPRB,.248E-01_JPRB,.259E-01_JPRB,&
&.236E-01_JPRB,.211E-01_JPRB,.205E-01_JPRB,.223E-01_JPRB,.229E-01_JPRB,.216E-01_JPRB,.276E-01_JPRB,&
&.269E-01_JPRB,.231E-01_JPRB,.242E-01_JPRB,.351E-01_JPRB,.272E-01_JPRB,.207E-01_JPRB,.339E-01_JPRB,&
&.415E-01_JPRB,.299E-01_JPRB,.284E-01_JPRB,.299E-01_JPRB,.254E-01_JPRB,.307E-01_JPRB,.514E-01_JPRB,&
&.587E-01_JPRB,.545E-01_JPRB,.413E-01_JPRB,.458E-01_JPRB,.332E-01_JPRB,.317E-01_JPRB,.314E-01_JPRB,&
&.316E-01_JPRB,.323E-01_JPRB,.280E-01_JPRB,.231E-01_JPRB,.216E-01_JPRB,.213E-01_JPRB,.214E-01_JPRB,&
&.232E-01_JPRB,.283E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 30 -26.0
ZAER (:,30, 1) = (/&
&.240E-01_JPRB,.252E-01_JPRB,.289E-01_JPRB,.310E-01_JPRB,.224E-01_JPRB,.162E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.139E-01_JPRB,.142E-01_JPRB,.147E-01_JPRB,.211E-01_JPRB,.385E-01_JPRB,.491E-01_JPRB,&
&.307E-01_JPRB,.258E-01_JPRB,.287E-01_JPRB,.541E-01_JPRB,.459E-01_JPRB,.443E-01_JPRB,.397E-01_JPRB,&
&.381E-01_JPRB,.314E-01_JPRB,.297E-01_JPRB,.276E-01_JPRB,.271E-01_JPRB,.275E-01_JPRB,.262E-01_JPRB,&
&.231E-01_JPRB,.227E-01_JPRB,.279E-01_JPRB,.317E-01_JPRB,.375E-01_JPRB,.358E-01_JPRB,.169E-01_JPRB,&
&.159E-01_JPRB,.149E-01_JPRB,.130E-01_JPRB,.151E-01_JPRB,.203E-01_JPRB,.250E-01_JPRB,.318E-01_JPRB,&
&.376E-01_JPRB,.305E-01_JPRB,.363E-01_JPRB,.464E-01_JPRB,.378E-01_JPRB,.507E-01_JPRB,.293E-01_JPRB,&
&.311E-01_JPRB,.399E-01_JPRB,.389E-01_JPRB,.312E-01_JPRB,.198E-01_JPRB,.292E-01_JPRB,.433E-01_JPRB,&
&.534E-01_JPRB,.647E-01_JPRB,.696E-01_JPRB,.563E-01_JPRB,.493E-01_JPRB,.336E-01_JPRB,.356E-01_JPRB,&
&.399E-01_JPRB,.398E-01_JPRB,.332E-01_JPRB,.284E-01_JPRB,.247E-01_JPRB,.215E-01_JPRB,.193E-01_JPRB,&
&.204E-01_JPRB,.229E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 31 -30.0
ZAER (:,31, 1) = (/&
&.203E-01_JPRB,.193E-01_JPRB,.210E-01_JPRB,.226E-01_JPRB,.190E-01_JPRB,.171E-01_JPRB,.162E-01_JPRB,&
&.151E-01_JPRB,.140E-01_JPRB,.132E-01_JPRB,.145E-01_JPRB,.181E-01_JPRB,.294E-01_JPRB,.396E-01_JPRB,&
&.194E-01_JPRB,.187E-01_JPRB,.198E-01_JPRB,.216E-01_JPRB,.269E-01_JPRB,.235E-01_JPRB,.433E-01_JPRB,&
&.457E-01_JPRB,.383E-01_JPRB,.340E-01_JPRB,.283E-01_JPRB,.237E-01_JPRB,.236E-01_JPRB,.223E-01_JPRB,&
&.202E-01_JPRB,.181E-01_JPRB,.173E-01_JPRB,.209E-01_JPRB,.246E-01_JPRB,.286E-01_JPRB,.126E-01_JPRB,&
&.122E-01_JPRB,.139E-01_JPRB,.136E-01_JPRB,.145E-01_JPRB,.179E-01_JPRB,.249E-01_JPRB,.252E-01_JPRB,&
&.268E-01_JPRB,.339E-01_JPRB,.388E-01_JPRB,.485E-01_JPRB,.381E-01_JPRB,.327E-01_JPRB,.365E-01_JPRB,&
&.321E-01_JPRB,.371E-01_JPRB,.302E-01_JPRB,.143E-01_JPRB,.852E-02_JPRB,.679E-02_JPRB,.894E-02_JPRB,&
&.213E-01_JPRB,.842E-01_JPRB,.893E-01_JPRB,.814E-01_JPRB,.544E-01_JPRB,.650E-01_JPRB,.540E-01_JPRB,&
&.650E-01_JPRB,.484E-01_JPRB,.408E-01_JPRB,.332E-01_JPRB,.301E-01_JPRB,.273E-01_JPRB,.246E-01_JPRB,&
&.222E-01_JPRB,.217E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 32 -34.0
ZAER (:,32, 1) = (/&
&.207E-01_JPRB,.194E-01_JPRB,.190E-01_JPRB,.204E-01_JPRB,.199E-01_JPRB,.186E-01_JPRB,.172E-01_JPRB,&
&.160E-01_JPRB,.145E-01_JPRB,.140E-01_JPRB,.159E-01_JPRB,.228E-01_JPRB,.305E-01_JPRB,.210E-01_JPRB,&
&.175E-01_JPRB,.153E-01_JPRB,.137E-01_JPRB,.213E-01_JPRB,.290E-01_JPRB,.292E-01_JPRB,.381E-01_JPRB,&
&.565E-01_JPRB,.539E-01_JPRB,.420E-01_JPRB,.323E-01_JPRB,.260E-01_JPRB,.217E-01_JPRB,.207E-01_JPRB,&
&.201E-01_JPRB,.169E-01_JPRB,.154E-01_JPRB,.166E-01_JPRB,.202E-01_JPRB,.234E-01_JPRB,.266E-01_JPRB,&
&.172E-01_JPRB,.180E-01_JPRB,.169E-01_JPRB,.191E-01_JPRB,.435E-01_JPRB,.481E-01_JPRB,.426E-01_JPRB,&
&.415E-01_JPRB,.448E-01_JPRB,.382E-01_JPRB,.436E-01_JPRB,.332E-01_JPRB,.445E-01_JPRB,.446E-01_JPRB,&
&.292E-01_JPRB,.293E-01_JPRB,.244E-01_JPRB,.107E-01_JPRB,.691E-02_JPRB,.615E-02_JPRB,.542E-02_JPRB,&
&.107E-01_JPRB,.544E-01_JPRB,.785E-01_JPRB,.803E-01_JPRB,.636E-01_JPRB,.892E-01_JPRB,.671E-01_JPRB,&
&.363E-01_JPRB,.446E-01_JPRB,.398E-01_JPRB,.337E-01_JPRB,.308E-01_JPRB,.286E-01_JPRB,.261E-01_JPRB,&
&.240E-01_JPRB,.220E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 33 -38.0
ZAER (:,33, 1) = (/&
&.187E-01_JPRB,.183E-01_JPRB,.172E-01_JPRB,.174E-01_JPRB,.176E-01_JPRB,.181E-01_JPRB,.176E-01_JPRB,&
&.161E-01_JPRB,.146E-01_JPRB,.139E-01_JPRB,.160E-01_JPRB,.250E-01_JPRB,.153E-01_JPRB,.136E-01_JPRB,&
&.145E-01_JPRB,.132E-01_JPRB,.145E-01_JPRB,.188E-01_JPRB,.281E-01_JPRB,.405E-01_JPRB,.468E-01_JPRB,&
&.906E-01_JPRB,.547E-01_JPRB,.428E-01_JPRB,.330E-01_JPRB,.258E-01_JPRB,.223E-01_JPRB,.187E-01_JPRB,&
&.173E-01_JPRB,.152E-01_JPRB,.136E-01_JPRB,.138E-01_JPRB,.150E-01_JPRB,.175E-01_JPRB,.268E-01_JPRB,&
&.181E-01_JPRB,.282E-01_JPRB,.352E-01_JPRB,.355E-01_JPRB,.418E-01_JPRB,.518E-01_JPRB,.482E-01_JPRB,&
&.279E-01_JPRB,.289E-01_JPRB,.343E-01_JPRB,.320E-01_JPRB,.408E-01_JPRB,.426E-01_JPRB,.432E-01_JPRB,&
&.514E-01_JPRB,.255E-01_JPRB,.197E-01_JPRB,.210E-01_JPRB,.140E-01_JPRB,.950E-02_JPRB,.785E-02_JPRB,&
&.107E-01_JPRB,.269E-01_JPRB,.436E-01_JPRB,.427E-01_JPRB,.663E-01_JPRB,.505E-01_JPRB,.531E-01_JPRB,&
&.549E-01_JPRB,.264E-01_JPRB,.383E-01_JPRB,.333E-01_JPRB,.290E-01_JPRB,.256E-01_JPRB,.237E-01_JPRB,&
&.224E-01_JPRB,.202E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 34 -42.0
ZAER (:,34, 1) = (/&
&.176E-01_JPRB,.169E-01_JPRB,.165E-01_JPRB,.160E-01_JPRB,.162E-01_JPRB,.160E-01_JPRB,.163E-01_JPRB,&
&.158E-01_JPRB,.146E-01_JPRB,.138E-01_JPRB,.156E-01_JPRB,.194E-01_JPRB,.105E-01_JPRB,.103E-01_JPRB,&
&.111E-01_JPRB,.129E-01_JPRB,.144E-01_JPRB,.209E-01_JPRB,.307E-01_JPRB,.389E-01_JPRB,.427E-01_JPRB,&
&.503E-01_JPRB,.595E-01_JPRB,.498E-01_JPRB,.364E-01_JPRB,.301E-01_JPRB,.249E-01_JPRB,.202E-01_JPRB,&
&.169E-01_JPRB,.147E-01_JPRB,.136E-01_JPRB,.129E-01_JPRB,.127E-01_JPRB,.134E-01_JPRB,.189E-01_JPRB,&
&.156E-01_JPRB,.155E-01_JPRB,.358E-01_JPRB,.277E-01_JPRB,.307E-01_JPRB,.252E-01_JPRB,.252E-01_JPRB,&
&.408E-01_JPRB,.428E-01_JPRB,.225E-01_JPRB,.226E-01_JPRB,.494E-01_JPRB,.359E-01_JPRB,.432E-01_JPRB,&
&.576E-01_JPRB,.405E-01_JPRB,.211E-01_JPRB,.152E-01_JPRB,.206E-01_JPRB,.237E-01_JPRB,.177E-01_JPRB,&
&.207E-01_JPRB,.211E-01_JPRB,.181E-01_JPRB,.175E-01_JPRB,.216E-01_JPRB,.184E-01_JPRB,.233E-01_JPRB,&
&.439E-01_JPRB,.337E-01_JPRB,.341E-01_JPRB,.348E-01_JPRB,.297E-01_JPRB,.252E-01_JPRB,.226E-01_JPRB,&
&.205E-01_JPRB,.191E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 35 -46.0
ZAER (:,35, 1) = (/&
&.184E-01_JPRB,.174E-01_JPRB,.170E-01_JPRB,.161E-01_JPRB,.159E-01_JPRB,.155E-01_JPRB,.154E-01_JPRB,&
&.155E-01_JPRB,.147E-01_JPRB,.139E-01_JPRB,.143E-01_JPRB,.158E-01_JPRB,.105E-01_JPRB,.972E-02_JPRB,&
&.101E-01_JPRB,.120E-01_JPRB,.144E-01_JPRB,.183E-01_JPRB,.252E-01_JPRB,.267E-01_JPRB,.375E-01_JPRB,&
&.479E-01_JPRB,.340E-01_JPRB,.263E-01_JPRB,.398E-01_JPRB,.368E-01_JPRB,.339E-01_JPRB,.271E-01_JPRB,&
&.211E-01_JPRB,.171E-01_JPRB,.144E-01_JPRB,.130E-01_JPRB,.123E-01_JPRB,.124E-01_JPRB,.161E-01_JPRB,&
&.290E-01_JPRB,.228E-01_JPRB,.205E-01_JPRB,.225E-01_JPRB,.225E-01_JPRB,.256E-01_JPRB,.339E-01_JPRB,&
&.400E-01_JPRB,.271E-01_JPRB,.250E-01_JPRB,.304E-01_JPRB,.441E-01_JPRB,.373E-01_JPRB,.402E-01_JPRB,&
&.411E-01_JPRB,.456E-01_JPRB,.406E-01_JPRB,.267E-01_JPRB,.247E-01_JPRB,.206E-01_JPRB,.178E-01_JPRB,&
&.157E-01_JPRB,.133E-01_JPRB,.136E-01_JPRB,.159E-01_JPRB,.179E-01_JPRB,.175E-01_JPRB,.193E-01_JPRB,&
&.202E-01_JPRB,.325E-01_JPRB,.274E-01_JPRB,.247E-01_JPRB,.260E-01_JPRB,.262E-01_JPRB,.241E-01_JPRB,&
&.222E-01_JPRB,.204E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 36 -50.0
ZAER (:,36, 1) = (/&
&.193E-01_JPRB,.179E-01_JPRB,.172E-01_JPRB,.165E-01_JPRB,.156E-01_JPRB,.154E-01_JPRB,.162E-01_JPRB,&
&.171E-01_JPRB,.160E-01_JPRB,.148E-01_JPRB,.151E-01_JPRB,.948E-02_JPRB,.115E-01_JPRB,.109E-01_JPRB,&
&.139E-01_JPRB,.150E-01_JPRB,.185E-01_JPRB,.210E-01_JPRB,.235E-01_JPRB,.255E-01_JPRB,.363E-01_JPRB,&
&.339E-01_JPRB,.297E-01_JPRB,.229E-01_JPRB,.333E-01_JPRB,.341E-01_JPRB,.291E-01_JPRB,.234E-01_JPRB,&
&.206E-01_JPRB,.174E-01_JPRB,.149E-01_JPRB,.133E-01_JPRB,.127E-01_JPRB,.123E-01_JPRB,.130E-01_JPRB,&
&.176E-01_JPRB,.134E-01_JPRB,.160E-01_JPRB,.159E-01_JPRB,.191E-01_JPRB,.237E-01_JPRB,.296E-01_JPRB,&
&.264E-01_JPRB,.315E-01_JPRB,.297E-01_JPRB,.364E-01_JPRB,.389E-01_JPRB,.339E-01_JPRB,.387E-01_JPRB,&
&.381E-01_JPRB,.371E-01_JPRB,.448E-01_JPRB,.495E-01_JPRB,.273E-01_JPRB,.164E-01_JPRB,.144E-01_JPRB,&
&.139E-01_JPRB,.152E-01_JPRB,.169E-01_JPRB,.163E-01_JPRB,.167E-01_JPRB,.171E-01_JPRB,.194E-01_JPRB,&
&.210E-01_JPRB,.177E-01_JPRB,.250E-01_JPRB,.227E-01_JPRB,.219E-01_JPRB,.269E-01_JPRB,.267E-01_JPRB,&
&.242E-01_JPRB,.211E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 37 -54.0
ZAER (:,37, 1) = (/&
&.191E-01_JPRB,.193E-01_JPRB,.167E-01_JPRB,.152E-01_JPRB,.153E-01_JPRB,.152E-01_JPRB,.163E-01_JPRB,&
&.160E-01_JPRB,.157E-01_JPRB,.151E-01_JPRB,.900E-02_JPRB,.944E-02_JPRB,.130E-01_JPRB,.131E-01_JPRB,&
&.135E-01_JPRB,.166E-01_JPRB,.160E-01_JPRB,.193E-01_JPRB,.209E-01_JPRB,.182E-01_JPRB,.333E-01_JPRB,&
&.270E-01_JPRB,.238E-01_JPRB,.193E-01_JPRB,.171E-01_JPRB,.287E-01_JPRB,.237E-01_JPRB,.204E-01_JPRB,&
&.188E-01_JPRB,.176E-01_JPRB,.157E-01_JPRB,.143E-01_JPRB,.127E-01_JPRB,.122E-01_JPRB,.128E-01_JPRB,&
&.863E-02_JPRB,.178E-01_JPRB,.296E-01_JPRB,.213E-01_JPRB,.227E-01_JPRB,.281E-01_JPRB,.271E-01_JPRB,&
&.268E-01_JPRB,.304E-01_JPRB,.277E-01_JPRB,.337E-01_JPRB,.283E-01_JPRB,.292E-01_JPRB,.308E-01_JPRB,&
&.390E-01_JPRB,.378E-01_JPRB,.370E-01_JPRB,.498E-01_JPRB,.438E-01_JPRB,.249E-01_JPRB,.207E-01_JPRB,&
&.183E-01_JPRB,.176E-01_JPRB,.180E-01_JPRB,.176E-01_JPRB,.183E-01_JPRB,.194E-01_JPRB,.227E-01_JPRB,&
&.228E-01_JPRB,.266E-01_JPRB,.245E-01_JPRB,.205E-01_JPRB,.191E-01_JPRB,.131E-01_JPRB,.225E-01_JPRB,&
&.206E-01_JPRB,.205E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 38 -58.0
ZAER (:,38, 1) = (/&
&.206E-01_JPRB,.205E-01_JPRB,.170E-01_JPRB,.176E-01_JPRB,.197E-01_JPRB,.171E-01_JPRB,.166E-01_JPRB,&
&.171E-01_JPRB,.177E-01_JPRB,.985E-02_JPRB,.872E-02_JPRB,.917E-02_JPRB,.137E-01_JPRB,.151E-01_JPRB,&
&.147E-01_JPRB,.158E-01_JPRB,.169E-01_JPRB,.198E-01_JPRB,.338E-01_JPRB,.326E-01_JPRB,.365E-01_JPRB,&
&.242E-01_JPRB,.221E-01_JPRB,.159E-01_JPRB,.286E-01_JPRB,.266E-01_JPRB,.200E-01_JPRB,.181E-01_JPRB,&
&.169E-01_JPRB,.164E-01_JPRB,.156E-01_JPRB,.142E-01_JPRB,.130E-01_JPRB,.123E-01_JPRB,.125E-01_JPRB,&
&.142E-01_JPRB,.160E-01_JPRB,.207E-01_JPRB,.114E-01_JPRB,.111E-01_JPRB,.212E-01_JPRB,.141E-01_JPRB,&
&.163E-01_JPRB,.184E-01_JPRB,.219E-01_JPRB,.289E-01_JPRB,.288E-01_JPRB,.295E-01_JPRB,.308E-01_JPRB,&
&.347E-01_JPRB,.390E-01_JPRB,.385E-01_JPRB,.397E-01_JPRB,.436E-01_JPRB,.412E-01_JPRB,.382E-01_JPRB,&
&.289E-01_JPRB,.254E-01_JPRB,.210E-01_JPRB,.194E-01_JPRB,.196E-01_JPRB,.204E-01_JPRB,.251E-01_JPRB,&
&.228E-01_JPRB,.195E-01_JPRB,.303E-01_JPRB,.260E-01_JPRB,.232E-01_JPRB,.141E-01_JPRB,.231E-01_JPRB,&
&.230E-01_JPRB,.212E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 39 -62.0
ZAER (:,39, 1) = (/&
&.234E-01_JPRB,.264E-01_JPRB,.228E-01_JPRB,.209E-01_JPRB,.124E-01_JPRB,.113E-01_JPRB,.908E-02_JPRB,&
&.805E-02_JPRB,.753E-02_JPRB,.835E-02_JPRB,.849E-02_JPRB,.988E-02_JPRB,.122E-01_JPRB,.128E-01_JPRB,&
&.131E-01_JPRB,.139E-01_JPRB,.149E-01_JPRB,.174E-01_JPRB,.349E-01_JPRB,.405E-01_JPRB,.343E-01_JPRB,&
&.183E-01_JPRB,.299E-01_JPRB,.313E-01_JPRB,.276E-01_JPRB,.258E-01_JPRB,.202E-01_JPRB,.881E-02_JPRB,&
&.162E-01_JPRB,.170E-01_JPRB,.160E-01_JPRB,.146E-01_JPRB,.140E-01_JPRB,.127E-01_JPRB,.124E-01_JPRB,&
&.123E-01_JPRB,.119E-01_JPRB,.122E-01_JPRB,.708E-02_JPRB,.723E-02_JPRB,.129E-01_JPRB,.799E-02_JPRB,&
&.891E-02_JPRB,.112E-01_JPRB,.113E-01_JPRB,.158E-01_JPRB,.195E-01_JPRB,.216E-01_JPRB,.255E-01_JPRB,&
&.294E-01_JPRB,.327E-01_JPRB,.330E-01_JPRB,.318E-01_JPRB,.357E-01_JPRB,.349E-01_JPRB,.386E-01_JPRB,&
&.415E-01_JPRB,.366E-01_JPRB,.346E-01_JPRB,.309E-01_JPRB,.290E-01_JPRB,.305E-01_JPRB,.284E-01_JPRB,&
&.215E-01_JPRB,.163E-01_JPRB,.155E-01_JPRB,.136E-01_JPRB,.146E-01_JPRB,.159E-01_JPRB,.143E-01_JPRB,&
&.135E-01_JPRB,.240E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 40 -66.0
ZAER (:,40, 1) = (/&
&.172E-01_JPRB,.151E-01_JPRB,.253E-01_JPRB,.262E-01_JPRB,.141E-01_JPRB,.127E-01_JPRB,.111E-01_JPRB,&
&.975E-02_JPRB,.894E-02_JPRB,.936E-02_JPRB,.101E-01_JPRB,.105E-01_JPRB,.122E-01_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.135E-01_JPRB,.173E-01_JPRB,.194E-01_JPRB,.241E-01_JPRB,.247E-01_JPRB,.314E-01_JPRB,&
&.154E-01_JPRB,.150E-01_JPRB,.158E-01_JPRB,.267E-01_JPRB,.232E-01_JPRB,.102E-01_JPRB,.709E-02_JPRB,&
&.700E-02_JPRB,.140E-01_JPRB,.168E-01_JPRB,.172E-01_JPRB,.161E-01_JPRB,.149E-01_JPRB,.142E-01_JPRB,&
&.134E-01_JPRB,.121E-01_JPRB,.107E-01_JPRB,.105E-01_JPRB,.607E-02_JPRB,.682E-02_JPRB,.704E-02_JPRB,&
&.754E-02_JPRB,.902E-02_JPRB,.933E-02_JPRB,.989E-02_JPRB,.128E-01_JPRB,.180E-01_JPRB,.189E-01_JPRB,&
&.222E-01_JPRB,.230E-01_JPRB,.262E-01_JPRB,.284E-01_JPRB,.338E-01_JPRB,.352E-01_JPRB,.360E-01_JPRB,&
&.396E-01_JPRB,.391E-01_JPRB,.361E-01_JPRB,.351E-01_JPRB,.366E-01_JPRB,.348E-01_JPRB,.280E-01_JPRB,&
&.197E-01_JPRB,.157E-01_JPRB,.160E-01_JPRB,.156E-01_JPRB,.168E-01_JPRB,.172E-01_JPRB,.165E-01_JPRB,&
&.190E-01_JPRB,.188E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 41 -70.0
ZAER (:,41, 1) = (/&
&.312E-01_JPRB,.311E-01_JPRB,.296E-01_JPRB,.308E-01_JPRB,.185E-01_JPRB,.155E-01_JPRB,.139E-01_JPRB,&
&.124E-01_JPRB,.188E-01_JPRB,.191E-01_JPRB,.120E-01_JPRB,.218E-01_JPRB,.242E-01_JPRB,.155E-01_JPRB,&
&.148E-01_JPRB,.149E-01_JPRB,.290E-01_JPRB,.216E-01_JPRB,.231E-01_JPRB,.198E-01_JPRB,.176E-01_JPRB,&
&.160E-01_JPRB,.143E-01_JPRB,.247E-01_JPRB,.222E-01_JPRB,.189E-01_JPRB,.877E-02_JPRB,.652E-02_JPRB,&
&.550E-02_JPRB,.469E-02_JPRB,.489E-02_JPRB,.724E-02_JPRB,.159E-01_JPRB,.163E-01_JPRB,.164E-01_JPRB,&
&.160E-01_JPRB,.151E-01_JPRB,.132E-01_JPRB,.116E-01_JPRB,.112E-01_JPRB,.115E-01_JPRB,.754E-02_JPRB,&
&.770E-02_JPRB,.127E-01_JPRB,.131E-01_JPRB,.174E-01_JPRB,.240E-01_JPRB,.290E-01_JPRB,.324E-01_JPRB,&
&.312E-01_JPRB,.178E-01_JPRB,.200E-01_JPRB,.263E-01_JPRB,.287E-01_JPRB,.349E-01_JPRB,.388E-01_JPRB,&
&.340E-01_JPRB,.342E-01_JPRB,.357E-01_JPRB,.379E-01_JPRB,.361E-01_JPRB,.321E-01_JPRB,.288E-01_JPRB,&
&.232E-01_JPRB,.205E-01_JPRB,.199E-01_JPRB,.201E-01_JPRB,.196E-01_JPRB,.209E-01_JPRB,.202E-01_JPRB,&
&.345E-01_JPRB,.202E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 42 -74.0
ZAER (:,42, 1) = (/&
&.330E-01_JPRB,.317E-01_JPRB,.321E-01_JPRB,.344E-01_JPRB,.338E-01_JPRB,.314E-01_JPRB,.293E-01_JPRB,&
&.245E-01_JPRB,.228E-01_JPRB,.229E-01_JPRB,.235E-01_JPRB,.238E-01_JPRB,.145E-01_JPRB,.155E-01_JPRB,&
&.288E-01_JPRB,.316E-01_JPRB,.312E-01_JPRB,.324E-01_JPRB,.314E-01_JPRB,.168E-01_JPRB,.284E-01_JPRB,&
&.294E-01_JPRB,.293E-01_JPRB,.267E-01_JPRB,.209E-01_JPRB,.971E-02_JPRB,.735E-02_JPRB,.592E-02_JPRB,&
&.499E-02_JPRB,.457E-02_JPRB,.470E-02_JPRB,.589E-02_JPRB,.159E-01_JPRB,.201E-01_JPRB,.218E-01_JPRB,&
&.215E-01_JPRB,.206E-01_JPRB,.198E-01_JPRB,.189E-01_JPRB,.190E-01_JPRB,.184E-01_JPRB,.175E-01_JPRB,&
&.183E-01_JPRB,.186E-01_JPRB,.202E-01_JPRB,.221E-01_JPRB,.218E-01_JPRB,.229E-01_JPRB,.274E-01_JPRB,&
&.312E-01_JPRB,.297E-01_JPRB,.392E-01_JPRB,.456E-01_JPRB,.271E-01_JPRB,.310E-01_JPRB,.482E-01_JPRB,&
&.438E-01_JPRB,.430E-01_JPRB,.413E-01_JPRB,.395E-01_JPRB,.617E-01_JPRB,.571E-01_JPRB,.488E-01_JPRB,&
&.419E-01_JPRB,.420E-01_JPRB,.430E-01_JPRB,.438E-01_JPRB,.400E-01_JPRB,.372E-01_JPRB,.373E-01_JPRB,&
&.386E-01_JPRB,.371E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 43 -78.0
ZAER (:,43, 1) = (/&
&.311E-01_JPRB,.294E-01_JPRB,.288E-01_JPRB,.308E-01_JPRB,.325E-01_JPRB,.334E-01_JPRB,.327E-01_JPRB,&
&.304E-01_JPRB,.302E-01_JPRB,.300E-01_JPRB,.287E-01_JPRB,.276E-01_JPRB,.268E-01_JPRB,.266E-01_JPRB,&
&.276E-01_JPRB,.287E-01_JPRB,.298E-01_JPRB,.306E-01_JPRB,.176E-01_JPRB,.167E-01_JPRB,.168E-01_JPRB,&
&.296E-01_JPRB,.294E-01_JPRB,.162E-01_JPRB,.111E-01_JPRB,.941E-02_JPRB,.818E-02_JPRB,.691E-02_JPRB,&
&.676E-02_JPRB,.674E-02_JPRB,.788E-02_JPRB,.878E-02_JPRB,.168E-01_JPRB,.221E-01_JPRB,.247E-01_JPRB,&
&.263E-01_JPRB,.252E-01_JPRB,.246E-01_JPRB,.244E-01_JPRB,.145E-01_JPRB,.250E-01_JPRB,.248E-01_JPRB,&
&.256E-01_JPRB,.268E-01_JPRB,.289E-01_JPRB,.332E-01_JPRB,.312E-01_JPRB,.307E-01_JPRB,.312E-01_JPRB,&
&.324E-01_JPRB,.341E-01_JPRB,.341E-01_JPRB,.336E-01_JPRB,.368E-01_JPRB,.427E-01_JPRB,.495E-01_JPRB,&
&.563E-01_JPRB,.387E-01_JPRB,.626E-01_JPRB,.575E-01_JPRB,.533E-01_JPRB,.494E-01_JPRB,.482E-01_JPRB,&
&.490E-01_JPRB,.472E-01_JPRB,.482E-01_JPRB,.474E-01_JPRB,.426E-01_JPRB,.393E-01_JPRB,.376E-01_JPRB,&
&.350E-01_JPRB,.330E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 44 -82.0
ZAER (:,44, 1) = (/&
&.287E-01_JPRB,.286E-01_JPRB,.289E-01_JPRB,.296E-01_JPRB,.309E-01_JPRB,.325E-01_JPRB,.332E-01_JPRB,&
&.321E-01_JPRB,.317E-01_JPRB,.314E-01_JPRB,.315E-01_JPRB,.317E-01_JPRB,.315E-01_JPRB,.296E-01_JPRB,&
&.283E-01_JPRB,.274E-01_JPRB,.269E-01_JPRB,.273E-01_JPRB,.272E-01_JPRB,.268E-01_JPRB,.158E-01_JPRB,&
&.156E-01_JPRB,.153E-01_JPRB,.149E-01_JPRB,.139E-01_JPRB,.132E-01_JPRB,.127E-01_JPRB,.123E-01_JPRB,&
&.120E-01_JPRB,.119E-01_JPRB,.121E-01_JPRB,.119E-01_JPRB,.123E-01_JPRB,.215E-01_JPRB,.230E-01_JPRB,&
&.257E-01_JPRB,.277E-01_JPRB,.282E-01_JPRB,.284E-01_JPRB,.285E-01_JPRB,.292E-01_JPRB,.296E-01_JPRB,&
&.308E-01_JPRB,.321E-01_JPRB,.332E-01_JPRB,.341E-01_JPRB,.347E-01_JPRB,.352E-01_JPRB,.357E-01_JPRB,&
&.360E-01_JPRB,.367E-01_JPRB,.376E-01_JPRB,.384E-01_JPRB,.394E-01_JPRB,.405E-01_JPRB,.422E-01_JPRB,&
&.430E-01_JPRB,.438E-01_JPRB,.439E-01_JPRB,.432E-01_JPRB,.408E-01_JPRB,.389E-01_JPRB,.384E-01_JPRB,&
&.386E-01_JPRB,.405E-01_JPRB,.431E-01_JPRB,.421E-01_JPRB,.377E-01_JPRB,.345E-01_JPRB,.320E-01_JPRB,&
&.304E-01_JPRB,.296E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 45 -86.0
ZAER (:,45, 1) = (/&
&.306E-01_JPRB,.307E-01_JPRB,.303E-01_JPRB,.303E-01_JPRB,.300E-01_JPRB,.302E-01_JPRB,.304E-01_JPRB,&
&.305E-01_JPRB,.308E-01_JPRB,.311E-01_JPRB,.313E-01_JPRB,.317E-01_JPRB,.318E-01_JPRB,.311E-01_JPRB,&
&.303E-01_JPRB,.295E-01_JPRB,.289E-01_JPRB,.287E-01_JPRB,.283E-01_JPRB,.282E-01_JPRB,.282E-01_JPRB,&
&.284E-01_JPRB,.288E-01_JPRB,.291E-01_JPRB,.285E-01_JPRB,.283E-01_JPRB,.281E-01_JPRB,.281E-01_JPRB,&
&.281E-01_JPRB,.281E-01_JPRB,.283E-01_JPRB,.282E-01_JPRB,.286E-01_JPRB,.290E-01_JPRB,.293E-01_JPRB,&
&.298E-01_JPRB,.296E-01_JPRB,.299E-01_JPRB,.299E-01_JPRB,.302E-01_JPRB,.307E-01_JPRB,.312E-01_JPRB,&
&.316E-01_JPRB,.320E-01_JPRB,.326E-01_JPRB,.332E-01_JPRB,.337E-01_JPRB,.345E-01_JPRB,.347E-01_JPRB,&
&.350E-01_JPRB,.351E-01_JPRB,.351E-01_JPRB,.350E-01_JPRB,.347E-01_JPRB,.345E-01_JPRB,.341E-01_JPRB,&
&.336E-01_JPRB,.331E-01_JPRB,.322E-01_JPRB,.316E-01_JPRB,.306E-01_JPRB,.307E-01_JPRB,.308E-01_JPRB,&
&.308E-01_JPRB,.310E-01_JPRB,.309E-01_JPRB,.308E-01_JPRB,.308E-01_JPRB,.308E-01_JPRB,.307E-01_JPRB,&
&.304E-01_JPRB,.303E-01_JPRB/)
!-- Total Sulfate Aerosol    month:  1 --- lat: 46 -90.0
ZAER (:,46, 1) = (/&
&.320E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,&
&.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,&
&.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,&
&.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,&
&.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,&
&.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,&
&.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,&
&.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,&
&.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,&
&.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,.327E-01_JPRB,&
&.327E-01_JPRB,.327E-01_JPRB/)


!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=1   
  DO JI=1,46
    DO JL=1,72
      RAERSU(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SULFATE AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESU_01
