SUBROUTINE SUECAESS_11

!**   OPTICAL THICKNESS OF AEROSOLS OF SEA-SALT ORIGIN
!                                      November

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESS* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSS


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,11:11)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Sea Salt Aerosol         month: 11 --- lat:  1  90.0
ZAER (:, 1,11) = (/&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  2  86.0
ZAER (:, 2,11) = (/&
&.264E-03_JPRB,.264E-03_JPRB,.297E-03_JPRB,.297E-03_JPRB,.325E-03_JPRB,.325E-03_JPRB,.347E-03_JPRB,&
&.347E-03_JPRB,.375E-03_JPRB,.375E-03_JPRB,.401E-03_JPRB,.401E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,&
&.400E-03_JPRB,.400E-03_JPRB,.378E-03_JPRB,.378E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.306E-03_JPRB,.306E-03_JPRB,.296E-03_JPRB,.296E-03_JPRB,.309E-03_JPRB,.309E-03_JPRB,&
&.347E-03_JPRB,.347E-03_JPRB,.352E-03_JPRB,.352E-03_JPRB,.313E-03_JPRB,.313E-03_JPRB,.233E-03_JPRB,&
&.233E-03_JPRB,.168E-03_JPRB,.168E-03_JPRB,.149E-03_JPRB,.149E-03_JPRB,.150E-03_JPRB,.150E-03_JPRB,&
&.165E-03_JPRB,.165E-03_JPRB,.180E-03_JPRB,.180E-03_JPRB,.182E-03_JPRB,.182E-03_JPRB,.165E-03_JPRB,&
&.165E-03_JPRB,.151E-03_JPRB,.151E-03_JPRB,.136E-03_JPRB,.136E-03_JPRB,.118E-03_JPRB,.118E-03_JPRB,&
&.997E-04_JPRB,.997E-04_JPRB,.905E-04_JPRB,.905E-04_JPRB,.938E-04_JPRB,.938E-04_JPRB,.985E-04_JPRB,&
&.985E-04_JPRB,.108E-03_JPRB,.108E-03_JPRB,.128E-03_JPRB,.128E-03_JPRB,.166E-03_JPRB,.166E-03_JPRB,&
&.220E-03_JPRB,.220E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  3  82.0
ZAER (:, 3,11) = (/&
&.264E-03_JPRB,.264E-03_JPRB,.297E-03_JPRB,.297E-03_JPRB,.325E-03_JPRB,.325E-03_JPRB,.347E-03_JPRB,&
&.347E-03_JPRB,.375E-03_JPRB,.375E-03_JPRB,.401E-03_JPRB,.401E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,&
&.400E-03_JPRB,.400E-03_JPRB,.378E-03_JPRB,.378E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.306E-03_JPRB,.306E-03_JPRB,.296E-03_JPRB,.296E-03_JPRB,.309E-03_JPRB,.309E-03_JPRB,&
&.347E-03_JPRB,.347E-03_JPRB,.352E-03_JPRB,.352E-03_JPRB,.313E-03_JPRB,.313E-03_JPRB,.233E-03_JPRB,&
&.233E-03_JPRB,.168E-03_JPRB,.168E-03_JPRB,.149E-03_JPRB,.149E-03_JPRB,.150E-03_JPRB,.150E-03_JPRB,&
&.165E-03_JPRB,.165E-03_JPRB,.180E-03_JPRB,.180E-03_JPRB,.182E-03_JPRB,.182E-03_JPRB,.165E-03_JPRB,&
&.165E-03_JPRB,.151E-03_JPRB,.151E-03_JPRB,.136E-03_JPRB,.136E-03_JPRB,.118E-03_JPRB,.118E-03_JPRB,&
&.997E-04_JPRB,.997E-04_JPRB,.905E-04_JPRB,.905E-04_JPRB,.938E-04_JPRB,.938E-04_JPRB,.985E-04_JPRB,&
&.985E-04_JPRB,.108E-03_JPRB,.108E-03_JPRB,.128E-03_JPRB,.128E-03_JPRB,.166E-03_JPRB,.166E-03_JPRB,&
&.220E-03_JPRB,.220E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  4  78.0
ZAER (:, 4,11) = (/&
&.246E-03_JPRB,.246E-03_JPRB,.314E-03_JPRB,.314E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.420E-03_JPRB,&
&.420E-03_JPRB,.476E-03_JPRB,.476E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.680E-03_JPRB,.680E-03_JPRB,&
&.777E-03_JPRB,.777E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.777E-03_JPRB,.777E-03_JPRB,.640E-03_JPRB,&
&.640E-03_JPRB,.576E-03_JPRB,.576E-03_JPRB,.509E-03_JPRB,.509E-03_JPRB,.613E-03_JPRB,.613E-03_JPRB,&
&.744E-03_JPRB,.744E-03_JPRB,.719E-03_JPRB,.719E-03_JPRB,.635E-03_JPRB,.635E-03_JPRB,.513E-03_JPRB,&
&.513E-03_JPRB,.277E-03_JPRB,.277E-03_JPRB,.160E-03_JPRB,.160E-03_JPRB,.178E-03_JPRB,.178E-03_JPRB,&
&.238E-03_JPRB,.238E-03_JPRB,.278E-03_JPRB,.278E-03_JPRB,.305E-03_JPRB,.305E-03_JPRB,.338E-03_JPRB,&
&.338E-03_JPRB,.360E-03_JPRB,.360E-03_JPRB,.266E-03_JPRB,.266E-03_JPRB,.183E-03_JPRB,.183E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.121E-03_JPRB,.121E-03_JPRB,.135E-03_JPRB,.135E-03_JPRB,.182E-03_JPRB,&
&.182E-03_JPRB,.175E-03_JPRB,.175E-03_JPRB,.170E-03_JPRB,.170E-03_JPRB,.175E-03_JPRB,.175E-03_JPRB,&
&.205E-03_JPRB,.205E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  5  74.0
ZAER (:, 5,11) = (/&
&.246E-03_JPRB,.246E-03_JPRB,.314E-03_JPRB,.314E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.420E-03_JPRB,&
&.420E-03_JPRB,.476E-03_JPRB,.476E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.680E-03_JPRB,.680E-03_JPRB,&
&.777E-03_JPRB,.777E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.777E-03_JPRB,.777E-03_JPRB,.640E-03_JPRB,&
&.640E-03_JPRB,.576E-03_JPRB,.576E-03_JPRB,.509E-03_JPRB,.509E-03_JPRB,.613E-03_JPRB,.613E-03_JPRB,&
&.744E-03_JPRB,.744E-03_JPRB,.719E-03_JPRB,.719E-03_JPRB,.635E-03_JPRB,.635E-03_JPRB,.513E-03_JPRB,&
&.513E-03_JPRB,.277E-03_JPRB,.277E-03_JPRB,.160E-03_JPRB,.160E-03_JPRB,.178E-03_JPRB,.178E-03_JPRB,&
&.238E-03_JPRB,.238E-03_JPRB,.278E-03_JPRB,.278E-03_JPRB,.305E-03_JPRB,.305E-03_JPRB,.338E-03_JPRB,&
&.338E-03_JPRB,.360E-03_JPRB,.360E-03_JPRB,.266E-03_JPRB,.266E-03_JPRB,.183E-03_JPRB,.183E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.121E-03_JPRB,.121E-03_JPRB,.135E-03_JPRB,.135E-03_JPRB,.182E-03_JPRB,&
&.182E-03_JPRB,.175E-03_JPRB,.175E-03_JPRB,.170E-03_JPRB,.170E-03_JPRB,.175E-03_JPRB,.175E-03_JPRB,&
&.205E-03_JPRB,.205E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  6  70.0
ZAER (:, 6,11) = (/&
&.732E-03_JPRB,.732E-03_JPRB,.174E-02_JPRB,.174E-02_JPRB,.976E-03_JPRB,.976E-03_JPRB,.894E-03_JPRB,&
&.894E-03_JPRB,.116E-02_JPRB,.116E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,&
&.259E-02_JPRB,.259E-02_JPRB,.297E-02_JPRB,.297E-02_JPRB,.276E-02_JPRB,.276E-02_JPRB,.189E-02_JPRB,&
&.189E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.992E-03_JPRB,.992E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.967E-03_JPRB,.967E-03_JPRB,.849E-03_JPRB,.849E-03_JPRB,.786E-03_JPRB,&
&.786E-03_JPRB,.107E-02_JPRB,.107E-02_JPRB,.325E-03_JPRB,.325E-03_JPRB,.263E-03_JPRB,.263E-03_JPRB,&
&.556E-03_JPRB,.556E-03_JPRB,.851E-03_JPRB,.851E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.169E-02_JPRB,&
&.169E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.861E-03_JPRB,.861E-03_JPRB,&
&.915E-03_JPRB,.915E-03_JPRB,.850E-03_JPRB,.850E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.159E-02_JPRB,&
&.159E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.114E-02_JPRB,.114E-02_JPRB,&
&.101E-02_JPRB,.101E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  7  66.0
ZAER (:, 7,11) = (/&
&.732E-03_JPRB,.732E-03_JPRB,.174E-02_JPRB,.174E-02_JPRB,.976E-03_JPRB,.976E-03_JPRB,.894E-03_JPRB,&
&.894E-03_JPRB,.116E-02_JPRB,.116E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,&
&.259E-02_JPRB,.259E-02_JPRB,.297E-02_JPRB,.297E-02_JPRB,.276E-02_JPRB,.276E-02_JPRB,.189E-02_JPRB,&
&.189E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.992E-03_JPRB,.992E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.967E-03_JPRB,.967E-03_JPRB,.849E-03_JPRB,.849E-03_JPRB,.786E-03_JPRB,&
&.786E-03_JPRB,.107E-02_JPRB,.107E-02_JPRB,.325E-03_JPRB,.325E-03_JPRB,.263E-03_JPRB,.263E-03_JPRB,&
&.556E-03_JPRB,.556E-03_JPRB,.851E-03_JPRB,.851E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.169E-02_JPRB,&
&.169E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.861E-03_JPRB,.861E-03_JPRB,&
&.915E-03_JPRB,.915E-03_JPRB,.850E-03_JPRB,.850E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.159E-02_JPRB,&
&.159E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.114E-02_JPRB,.114E-02_JPRB,&
&.101E-02_JPRB,.101E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  8  62.0
ZAER (:, 8,11) = (/&
&.744E-02_JPRB,.744E-02_JPRB,.653E-02_JPRB,.653E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.613E-02_JPRB,&
&.613E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,&
&.317E-02_JPRB,.317E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.546E-03_JPRB,.546E-03_JPRB,.713E-03_JPRB,.713E-03_JPRB,&
&.995E-03_JPRB,.995E-03_JPRB,.360E-02_JPRB,.360E-02_JPRB,.504E-02_JPRB,.504E-02_JPRB,.541E-02_JPRB,&
&.541E-02_JPRB,.535E-02_JPRB,.535E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,.520E-02_JPRB,.520E-02_JPRB,&
&.521E-02_JPRB,.521E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.593E-02_JPRB,&
&.593E-02_JPRB,.461E-02_JPRB,.461E-02_JPRB,.522E-02_JPRB,.522E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,&
&.811E-02_JPRB,.811E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  9  58.0
ZAER (:, 9,11) = (/&
&.744E-02_JPRB,.744E-02_JPRB,.653E-02_JPRB,.653E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.613E-02_JPRB,&
&.613E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,&
&.317E-02_JPRB,.317E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.546E-03_JPRB,.546E-03_JPRB,.713E-03_JPRB,.713E-03_JPRB,&
&.995E-03_JPRB,.995E-03_JPRB,.360E-02_JPRB,.360E-02_JPRB,.504E-02_JPRB,.504E-02_JPRB,.541E-02_JPRB,&
&.541E-02_JPRB,.535E-02_JPRB,.535E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,.520E-02_JPRB,.520E-02_JPRB,&
&.521E-02_JPRB,.521E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.593E-02_JPRB,&
&.593E-02_JPRB,.461E-02_JPRB,.461E-02_JPRB,.522E-02_JPRB,.522E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,&
&.811E-02_JPRB,.811E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 10  54.0
ZAER (:,10,11) = (/&
&.739E-02_JPRB,.739E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.797E-02_JPRB,&
&.797E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.968E-02_JPRB,.968E-02_JPRB,.990E-02_JPRB,.990E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,&
&.895E-02_JPRB,.895E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.585E-02_JPRB,&
&.585E-02_JPRB,.518E-02_JPRB,.518E-02_JPRB,.502E-02_JPRB,.502E-02_JPRB,.398E-02_JPRB,.398E-02_JPRB,&
&.456E-02_JPRB,.456E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,&
&.874E-02_JPRB,.874E-02_JPRB,.918E-02_JPRB,.918E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,.941E-02_JPRB,&
&.941E-02_JPRB,.879E-02_JPRB,.879E-02_JPRB,.874E-02_JPRB,.874E-02_JPRB,.832E-02_JPRB,.832E-02_JPRB,&
&.724E-02_JPRB,.724E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 11  50.0
ZAER (:,11,11) = (/&
&.739E-02_JPRB,.739E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.797E-02_JPRB,&
&.797E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.968E-02_JPRB,.968E-02_JPRB,.990E-02_JPRB,.990E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,&
&.895E-02_JPRB,.895E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.585E-02_JPRB,&
&.585E-02_JPRB,.518E-02_JPRB,.518E-02_JPRB,.502E-02_JPRB,.502E-02_JPRB,.398E-02_JPRB,.398E-02_JPRB,&
&.456E-02_JPRB,.456E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,&
&.874E-02_JPRB,.874E-02_JPRB,.918E-02_JPRB,.918E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,.941E-02_JPRB,&
&.941E-02_JPRB,.879E-02_JPRB,.879E-02_JPRB,.874E-02_JPRB,.874E-02_JPRB,.832E-02_JPRB,.832E-02_JPRB,&
&.724E-02_JPRB,.724E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 12  46.0
ZAER (:,12,11) = (/&
&.678E-02_JPRB,.678E-02_JPRB,.680E-02_JPRB,.680E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.695E-02_JPRB,&
&.695E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,&
&.666E-02_JPRB,.666E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.732E-02_JPRB,&
&.732E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.659E-02_JPRB,.659E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,&
&.938E-02_JPRB,.938E-02_JPRB,.866E-02_JPRB,.866E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.757E-02_JPRB,&
&.757E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,&
&.678E-02_JPRB,.678E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.901E-02_JPRB,&
&.901E-02_JPRB,.994E-02_JPRB,.994E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.978E-02_JPRB,.978E-02_JPRB,.975E-02_JPRB,.975E-02_JPRB,.948E-02_JPRB,&
&.948E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.818E-02_JPRB,.818E-02_JPRB,.733E-02_JPRB,.733E-02_JPRB,&
&.534E-02_JPRB,.534E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 13  42.0
ZAER (:,13,11) = (/&
&.678E-02_JPRB,.678E-02_JPRB,.680E-02_JPRB,.680E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.695E-02_JPRB,&
&.695E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,&
&.666E-02_JPRB,.666E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.732E-02_JPRB,&
&.732E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.659E-02_JPRB,.659E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,&
&.938E-02_JPRB,.938E-02_JPRB,.866E-02_JPRB,.866E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.757E-02_JPRB,&
&.757E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,&
&.678E-02_JPRB,.678E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.901E-02_JPRB,&
&.901E-02_JPRB,.994E-02_JPRB,.994E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.978E-02_JPRB,.978E-02_JPRB,.975E-02_JPRB,.975E-02_JPRB,.948E-02_JPRB,&
&.948E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.818E-02_JPRB,.818E-02_JPRB,.733E-02_JPRB,.733E-02_JPRB,&
&.534E-02_JPRB,.534E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 14  38.0
ZAER (:,14,11) = (/&
&.626E-02_JPRB,.626E-02_JPRB,.648E-02_JPRB,.648E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.680E-02_JPRB,&
&.680E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.580E-02_JPRB,.580E-02_JPRB,&
&.563E-02_JPRB,.563E-02_JPRB,.541E-02_JPRB,.541E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.511E-02_JPRB,&
&.511E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,&
&.723E-02_JPRB,.723E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.673E-02_JPRB,&
&.673E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,&
&.687E-02_JPRB,.687E-02_JPRB,.741E-02_JPRB,.741E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.797E-02_JPRB,&
&.797E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.846E-02_JPRB,.846E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,&
&.753E-02_JPRB,.753E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.524E-02_JPRB,&
&.524E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,&
&.646E-02_JPRB,.646E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 15  34.0
ZAER (:,15,11) = (/&
&.626E-02_JPRB,.626E-02_JPRB,.648E-02_JPRB,.648E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.680E-02_JPRB,&
&.680E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.580E-02_JPRB,.580E-02_JPRB,&
&.563E-02_JPRB,.563E-02_JPRB,.541E-02_JPRB,.541E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.511E-02_JPRB,&
&.511E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,&
&.723E-02_JPRB,.723E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.673E-02_JPRB,&
&.673E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,&
&.687E-02_JPRB,.687E-02_JPRB,.741E-02_JPRB,.741E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.797E-02_JPRB,&
&.797E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.846E-02_JPRB,.846E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,&
&.753E-02_JPRB,.753E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.524E-02_JPRB,&
&.524E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,&
&.646E-02_JPRB,.646E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 16  30.0
ZAER (:,16,11) = (/&
&.683E-02_JPRB,.683E-02_JPRB,.691E-02_JPRB,.691E-02_JPRB,.704E-02_JPRB,.704E-02_JPRB,.762E-02_JPRB,&
&.762E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.808E-02_JPRB,.808E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,&
&.838E-02_JPRB,.838E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.565E-02_JPRB,&
&.565E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,&
&.630E-02_JPRB,.630E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,.655E-02_JPRB,&
&.655E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.240E-02_JPRB,.240E-02_JPRB,&
&.443E-02_JPRB,.443E-02_JPRB,.703E-02_JPRB,.703E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.732E-02_JPRB,&
&.732E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,&
&.729E-02_JPRB,.729E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,.251E-02_JPRB,&
&.251E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.384E-02_JPRB,.384E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,&
&.726E-02_JPRB,.726E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 17  26.0
ZAER (:,17,11) = (/&
&.683E-02_JPRB,.683E-02_JPRB,.691E-02_JPRB,.691E-02_JPRB,.704E-02_JPRB,.704E-02_JPRB,.762E-02_JPRB,&
&.762E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.808E-02_JPRB,.808E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,&
&.838E-02_JPRB,.838E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.565E-02_JPRB,&
&.565E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,&
&.630E-02_JPRB,.630E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,.655E-02_JPRB,&
&.655E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.240E-02_JPRB,.240E-02_JPRB,&
&.443E-02_JPRB,.443E-02_JPRB,.703E-02_JPRB,.703E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.732E-02_JPRB,&
&.732E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,&
&.729E-02_JPRB,.729E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,.251E-02_JPRB,&
&.251E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.384E-02_JPRB,.384E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,&
&.726E-02_JPRB,.726E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 18  22.0
ZAER (:,18,11) = (/&
&.977E-02_JPRB,.977E-02_JPRB,.987E-02_JPRB,.987E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.863E-02_JPRB,&
&.863E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.912E-02_JPRB,.912E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.541E-02_JPRB,&
&.541E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,.902E-03_JPRB,.902E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,&
&.457E-02_JPRB,.457E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.585E-02_JPRB,&
&.585E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.429E-02_JPRB,.429E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.211E-02_JPRB,.211E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.808E-02_JPRB,.808E-02_JPRB,.938E-02_JPRB,&
&.938E-02_JPRB,.977E-02_JPRB,.977E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.402E-02_JPRB,&
&.402E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,&
&.930E-02_JPRB,.930E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 19  18.0
ZAER (:,19,11) = (/&
&.977E-02_JPRB,.977E-02_JPRB,.987E-02_JPRB,.987E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.863E-02_JPRB,&
&.863E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.912E-02_JPRB,.912E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.541E-02_JPRB,&
&.541E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,.902E-03_JPRB,.902E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,&
&.457E-02_JPRB,.457E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.585E-02_JPRB,&
&.585E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.429E-02_JPRB,.429E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.211E-02_JPRB,.211E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.808E-02_JPRB,.808E-02_JPRB,.938E-02_JPRB,&
&.938E-02_JPRB,.977E-02_JPRB,.977E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.402E-02_JPRB,&
&.402E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,&
&.930E-02_JPRB,.930E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 20  14.0
ZAER (:,20,11) = (/&
&.970E-02_JPRB,.970E-02_JPRB,.944E-02_JPRB,.944E-02_JPRB,.986E-02_JPRB,.986E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.794E-02_JPRB,.794E-02_JPRB,.534E-02_JPRB,.534E-02_JPRB,.290E-02_JPRB,&
&.290E-02_JPRB,.462E-03_JPRB,.462E-03_JPRB,.338E-03_JPRB,.338E-03_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.442E-02_JPRB,.442E-02_JPRB,.821E-02_JPRB,.821E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,.539E-02_JPRB,&
&.539E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.982E-03_JPRB,.982E-03_JPRB,&
&.308E-02_JPRB,.308E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.850E-02_JPRB,.850E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.567E-02_JPRB,&
&.567E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,&
&.939E-02_JPRB,.939E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 21  10.0
ZAER (:,21,11) = (/&
&.970E-02_JPRB,.970E-02_JPRB,.944E-02_JPRB,.944E-02_JPRB,.986E-02_JPRB,.986E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.794E-02_JPRB,.794E-02_JPRB,.534E-02_JPRB,.534E-02_JPRB,.290E-02_JPRB,&
&.290E-02_JPRB,.462E-03_JPRB,.462E-03_JPRB,.338E-03_JPRB,.338E-03_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.442E-02_JPRB,.442E-02_JPRB,.821E-02_JPRB,.821E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,.539E-02_JPRB,&
&.539E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.982E-03_JPRB,.982E-03_JPRB,&
&.308E-02_JPRB,.308E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.850E-02_JPRB,.850E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.567E-02_JPRB,&
&.567E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,&
&.939E-02_JPRB,.939E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 22   6.0
ZAER (:,22,11) = (/&
&.107E-01_JPRB,.107E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.778E-02_JPRB,.778E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.148E-02_JPRB,&
&.148E-02_JPRB,.444E-03_JPRB,.444E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.368E-02_JPRB,.368E-02_JPRB,&
&.798E-02_JPRB,.798E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.799E-02_JPRB,.799E-02_JPRB,.536E-02_JPRB,&
&.536E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.999E-03_JPRB,.999E-03_JPRB,&
&.410E-02_JPRB,.410E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.975E-02_JPRB,.975E-02_JPRB,.888E-02_JPRB,&
&.888E-02_JPRB,.727E-02_JPRB,.727E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,&
&.397E-02_JPRB,.397E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.477E-02_JPRB,&
&.477E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,&
&.907E-02_JPRB,.907E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 23   2.0
ZAER (:,23,11) = (/&
&.107E-01_JPRB,.107E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.778E-02_JPRB,.778E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.148E-02_JPRB,&
&.148E-02_JPRB,.444E-03_JPRB,.444E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.368E-02_JPRB,.368E-02_JPRB,&
&.798E-02_JPRB,.798E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.799E-02_JPRB,.799E-02_JPRB,.536E-02_JPRB,&
&.536E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.999E-03_JPRB,.999E-03_JPRB,&
&.410E-02_JPRB,.410E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.975E-02_JPRB,.975E-02_JPRB,.888E-02_JPRB,&
&.888E-02_JPRB,.727E-02_JPRB,.727E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,&
&.397E-02_JPRB,.397E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.477E-02_JPRB,&
&.477E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,&
&.907E-02_JPRB,.907E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 24  -2.0
ZAER (:,24,11) = (/&
&.922E-02_JPRB,.922E-02_JPRB,.997E-02_JPRB,.997E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.998E-02_JPRB,.998E-02_JPRB,&
&.814E-02_JPRB,.814E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.701E-02_JPRB,.701E-02_JPRB,.336E-02_JPRB,&
&.336E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.430E-02_JPRB,.430E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,&
&.975E-02_JPRB,.975E-02_JPRB,.960E-02_JPRB,.960E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.507E-02_JPRB,&
&.507E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,&
&.446E-02_JPRB,.446E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,.907E-02_JPRB,.907E-02_JPRB,.792E-02_JPRB,&
&.792E-02_JPRB,.707E-02_JPRB,.707E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.490E-02_JPRB,.490E-02_JPRB,&
&.421E-02_JPRB,.421E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.881E-02_JPRB,&
&.881E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.787E-02_JPRB,.787E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,&
&.842E-02_JPRB,.842E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 25  -6.0
ZAER (:,25,11) = (/&
&.922E-02_JPRB,.922E-02_JPRB,.997E-02_JPRB,.997E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.998E-02_JPRB,.998E-02_JPRB,&
&.814E-02_JPRB,.814E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.701E-02_JPRB,.701E-02_JPRB,.336E-02_JPRB,&
&.336E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.430E-02_JPRB,.430E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,&
&.975E-02_JPRB,.975E-02_JPRB,.960E-02_JPRB,.960E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.507E-02_JPRB,&
&.507E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,&
&.446E-02_JPRB,.446E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,.907E-02_JPRB,.907E-02_JPRB,.792E-02_JPRB,&
&.792E-02_JPRB,.707E-02_JPRB,.707E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.490E-02_JPRB,.490E-02_JPRB,&
&.421E-02_JPRB,.421E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.881E-02_JPRB,&
&.881E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.787E-02_JPRB,.787E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,&
&.842E-02_JPRB,.842E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 26 -10.0
ZAER (:,26,11) = (/&
&.902E-02_JPRB,.902E-02_JPRB,.831E-02_JPRB,.831E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.936E-02_JPRB,.936E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,.751E-02_JPRB,&
&.751E-02_JPRB,.862E-02_JPRB,.862E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.752E-02_JPRB,.752E-02_JPRB,.414E-02_JPRB,&
&.414E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.173E-02_JPRB,.173E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,&
&.297E-02_JPRB,.297E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,.932E-02_JPRB,&
&.932E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.658E-02_JPRB,.658E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,&
&.663E-02_JPRB,.663E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 27 -14.0
ZAER (:,27,11) = (/&
&.902E-02_JPRB,.902E-02_JPRB,.831E-02_JPRB,.831E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.936E-02_JPRB,.936E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,.751E-02_JPRB,&
&.751E-02_JPRB,.862E-02_JPRB,.862E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.752E-02_JPRB,.752E-02_JPRB,.414E-02_JPRB,&
&.414E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.173E-02_JPRB,.173E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,&
&.297E-02_JPRB,.297E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,.932E-02_JPRB,&
&.932E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.658E-02_JPRB,.658E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,&
&.663E-02_JPRB,.663E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 28 -18.0
ZAER (:,28,11) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.876E-02_JPRB,.876E-02_JPRB,.775E-02_JPRB,.775E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.912E-02_JPRB,&
&.912E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.131E-01_JPRB,.131E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.794E-02_JPRB,.794E-02_JPRB,.502E-02_JPRB,&
&.502E-02_JPRB,.437E-02_JPRB,.437E-02_JPRB,.374E-02_JPRB,.374E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,&
&.291E-02_JPRB,.291E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.408E-02_JPRB,.408E-02_JPRB,.450E-02_JPRB,.450E-02_JPRB,&
&.583E-02_JPRB,.583E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.200E-01_JPRB,&
&.200E-01_JPRB,.196E-01_JPRB,.196E-01_JPRB,.175E-01_JPRB,.175E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 29 -22.0
ZAER (:,29,11) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.876E-02_JPRB,.876E-02_JPRB,.775E-02_JPRB,.775E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.912E-02_JPRB,&
&.912E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.131E-01_JPRB,.131E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.794E-02_JPRB,.794E-02_JPRB,.502E-02_JPRB,&
&.502E-02_JPRB,.437E-02_JPRB,.437E-02_JPRB,.374E-02_JPRB,.374E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,&
&.291E-02_JPRB,.291E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.408E-02_JPRB,.408E-02_JPRB,.450E-02_JPRB,.450E-02_JPRB,&
&.583E-02_JPRB,.583E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.200E-01_JPRB,&
&.200E-01_JPRB,.196E-01_JPRB,.196E-01_JPRB,.175E-01_JPRB,.175E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 30 -26.0
ZAER (:,30,11) = (/&
&.132E-01_JPRB,.132E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.945E-02_JPRB,.945E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,&
&.669E-02_JPRB,.669E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.840E-02_JPRB,&
&.840E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.501E-02_JPRB,.501E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.403E-02_JPRB,.403E-02_JPRB,&
&.355E-02_JPRB,.355E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,.264E-02_JPRB,.264E-02_JPRB,.263E-02_JPRB,&
&.263E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,&
&.209E-02_JPRB,.209E-02_JPRB,.360E-02_JPRB,.360E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 31 -30.0
ZAER (:,31,11) = (/&
&.132E-01_JPRB,.132E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.945E-02_JPRB,.945E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,&
&.669E-02_JPRB,.669E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.840E-02_JPRB,&
&.840E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.501E-02_JPRB,.501E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.403E-02_JPRB,.403E-02_JPRB,&
&.355E-02_JPRB,.355E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,.264E-02_JPRB,.264E-02_JPRB,.263E-02_JPRB,&
&.263E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,&
&.209E-02_JPRB,.209E-02_JPRB,.360E-02_JPRB,.360E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 32 -34.0
ZAER (:,32,11) = (/&
&.125E-01_JPRB,.125E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.843E-02_JPRB,.843E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,&
&.358E-02_JPRB,.358E-02_JPRB,.336E-02_JPRB,.336E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,.352E-02_JPRB,&
&.352E-02_JPRB,.829E-02_JPRB,.829E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.141E-01_JPRB,.141E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.823E-02_JPRB,&
&.823E-02_JPRB,.616E-02_JPRB,.616E-02_JPRB,.589E-02_JPRB,.589E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,&
&.434E-02_JPRB,.434E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.219E-02_JPRB,&
&.219E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.279E-02_JPRB,.279E-02_JPRB,.427E-02_JPRB,&
&.427E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.976E-02_JPRB,.976E-02_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 33 -38.0
ZAER (:,33,11) = (/&
&.125E-01_JPRB,.125E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.843E-02_JPRB,.843E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,&
&.358E-02_JPRB,.358E-02_JPRB,.336E-02_JPRB,.336E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,.352E-02_JPRB,&
&.352E-02_JPRB,.829E-02_JPRB,.829E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.141E-01_JPRB,.141E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.823E-02_JPRB,&
&.823E-02_JPRB,.616E-02_JPRB,.616E-02_JPRB,.589E-02_JPRB,.589E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,&
&.434E-02_JPRB,.434E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.219E-02_JPRB,&
&.219E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.279E-02_JPRB,.279E-02_JPRB,.427E-02_JPRB,&
&.427E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.976E-02_JPRB,.976E-02_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 34 -42.0
ZAER (:,34,11) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.123E-01_JPRB,&
&.123E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.792E-02_JPRB,.792E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,&
&.209E-02_JPRB,.209E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.657E-02_JPRB,.657E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,&
&.399E-02_JPRB,.399E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.200E-02_JPRB,&
&.200E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,&
&.128E-02_JPRB,.128E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.956E-03_JPRB,.956E-03_JPRB,.183E-02_JPRB,&
&.183E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.126E-01_JPRB,.126E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 35 -46.0
ZAER (:,35,11) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.123E-01_JPRB,&
&.123E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.792E-02_JPRB,.792E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,&
&.209E-02_JPRB,.209E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.657E-02_JPRB,.657E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,&
&.399E-02_JPRB,.399E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.200E-02_JPRB,&
&.200E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,&
&.128E-02_JPRB,.128E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.956E-03_JPRB,.956E-03_JPRB,.183E-02_JPRB,&
&.183E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.126E-01_JPRB,.126E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 36 -50.0
ZAER (:,36,11) = (/&
&.121E-01_JPRB,.121E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.580E-02_JPRB,.580E-02_JPRB,.240E-02_JPRB,.240E-02_JPRB,&
&.178E-02_JPRB,.178E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.145E-02_JPRB,&
&.145E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.404E-02_JPRB,.404E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.677E-02_JPRB,.677E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,&
&.253E-02_JPRB,.253E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.175E-02_JPRB,&
&.175E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,&
&.112E-02_JPRB,.112E-02_JPRB,.952E-03_JPRB,.952E-03_JPRB,.831E-03_JPRB,.831E-03_JPRB,.862E-03_JPRB,&
&.862E-03_JPRB,.396E-02_JPRB,.396E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 37 -54.0
ZAER (:,37,11) = (/&
&.121E-01_JPRB,.121E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.580E-02_JPRB,.580E-02_JPRB,.240E-02_JPRB,.240E-02_JPRB,&
&.178E-02_JPRB,.178E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.145E-02_JPRB,&
&.145E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.404E-02_JPRB,.404E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.677E-02_JPRB,.677E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,&
&.253E-02_JPRB,.253E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.175E-02_JPRB,&
&.175E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,&
&.112E-02_JPRB,.112E-02_JPRB,.952E-03_JPRB,.952E-03_JPRB,.831E-03_JPRB,.831E-03_JPRB,.862E-03_JPRB,&
&.862E-03_JPRB,.396E-02_JPRB,.396E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 38 -58.0
ZAER (:,38,11) = (/&
&.751E-02_JPRB,.751E-02_JPRB,.818E-02_JPRB,.818E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.656E-02_JPRB,&
&.656E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.278E-02_JPRB,.278E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,&
&.138E-02_JPRB,.138E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.470E-02_JPRB,.470E-02_JPRB,.259E-02_JPRB,&
&.259E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.614E-02_JPRB,.614E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.917E-02_JPRB,.917E-02_JPRB,.484E-02_JPRB,.484E-02_JPRB,.358E-02_JPRB,.358E-02_JPRB,&
&.229E-02_JPRB,.229E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.171E-02_JPRB,&
&.171E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.995E-03_JPRB,.995E-03_JPRB,&
&.872E-03_JPRB,.872E-03_JPRB,.787E-03_JPRB,.787E-03_JPRB,.777E-03_JPRB,.777E-03_JPRB,.977E-03_JPRB,&
&.977E-03_JPRB,.299E-02_JPRB,.299E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,&
&.847E-02_JPRB,.847E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 39 -62.0
ZAER (:,39,11) = (/&
&.751E-02_JPRB,.751E-02_JPRB,.818E-02_JPRB,.818E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.656E-02_JPRB,&
&.656E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.278E-02_JPRB,.278E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,&
&.138E-02_JPRB,.138E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.470E-02_JPRB,.470E-02_JPRB,.259E-02_JPRB,&
&.259E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.614E-02_JPRB,.614E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.917E-02_JPRB,.917E-02_JPRB,.484E-02_JPRB,.484E-02_JPRB,.358E-02_JPRB,.358E-02_JPRB,&
&.229E-02_JPRB,.229E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.171E-02_JPRB,&
&.171E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.995E-03_JPRB,.995E-03_JPRB,&
&.872E-03_JPRB,.872E-03_JPRB,.787E-03_JPRB,.787E-03_JPRB,.777E-03_JPRB,.777E-03_JPRB,.977E-03_JPRB,&
&.977E-03_JPRB,.299E-02_JPRB,.299E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,&
&.847E-02_JPRB,.847E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 40 -66.0
ZAER (:,40,11) = (/&
&.250E-02_JPRB,.250E-02_JPRB,.291E-02_JPRB,.291E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.215E-02_JPRB,&
&.215E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.150E-02_JPRB,.150E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,&
&.819E-03_JPRB,.819E-03_JPRB,.958E-03_JPRB,.958E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.820E-03_JPRB,.820E-03_JPRB,.324E-02_JPRB,.324E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,&
&.494E-02_JPRB,.494E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,.979E-02_JPRB,.979E-02_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.764E-02_JPRB,.764E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,&
&.370E-02_JPRB,.370E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.299E-02_JPRB,.299E-02_JPRB,.197E-02_JPRB,&
&.197E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.828E-03_JPRB,.828E-03_JPRB,.765E-03_JPRB,.765E-03_JPRB,&
&.731E-03_JPRB,.731E-03_JPRB,.760E-03_JPRB,.760E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,&
&.262E-02_JPRB,.262E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 41 -70.0
ZAER (:,41,11) = (/&
&.250E-02_JPRB,.250E-02_JPRB,.291E-02_JPRB,.291E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.215E-02_JPRB,&
&.215E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.150E-02_JPRB,.150E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,&
&.819E-03_JPRB,.819E-03_JPRB,.958E-03_JPRB,.958E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.820E-03_JPRB,.820E-03_JPRB,.324E-02_JPRB,.324E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,&
&.494E-02_JPRB,.494E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,.979E-02_JPRB,.979E-02_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.764E-02_JPRB,.764E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,&
&.370E-02_JPRB,.370E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.299E-02_JPRB,.299E-02_JPRB,.197E-02_JPRB,&
&.197E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.828E-03_JPRB,.828E-03_JPRB,.765E-03_JPRB,.765E-03_JPRB,&
&.731E-03_JPRB,.731E-03_JPRB,.760E-03_JPRB,.760E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,&
&.262E-02_JPRB,.262E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 42 -74.0
ZAER (:,42,11) = (/&
&.954E-03_JPRB,.954E-03_JPRB,.825E-03_JPRB,.825E-03_JPRB,.700E-03_JPRB,.700E-03_JPRB,.590E-03_JPRB,&
&.590E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.577E-03_JPRB,.577E-03_JPRB,.518E-03_JPRB,.518E-03_JPRB,&
&.499E-03_JPRB,.499E-03_JPRB,.510E-03_JPRB,.510E-03_JPRB,.508E-03_JPRB,.508E-03_JPRB,.615E-03_JPRB,&
&.615E-03_JPRB,.800E-03_JPRB,.800E-03_JPRB,.176E-02_JPRB,.176E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,&
&.230E-02_JPRB,.230E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.279E-02_JPRB,.279E-02_JPRB,.463E-02_JPRB,&
&.463E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.616E-02_JPRB,.616E-02_JPRB,.570E-02_JPRB,.570E-02_JPRB,&
&.528E-02_JPRB,.528E-02_JPRB,.397E-02_JPRB,.397E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.148E-02_JPRB,&
&.148E-02_JPRB,.932E-03_JPRB,.932E-03_JPRB,.787E-03_JPRB,.787E-03_JPRB,.667E-03_JPRB,.667E-03_JPRB,&
&.636E-03_JPRB,.636E-03_JPRB,.752E-03_JPRB,.752E-03_JPRB,.133E-02_JPRB,.133E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,&
&.108E-02_JPRB,.108E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 43 -78.0
ZAER (:,43,11) = (/&
&.954E-03_JPRB,.954E-03_JPRB,.825E-03_JPRB,.825E-03_JPRB,.700E-03_JPRB,.700E-03_JPRB,.590E-03_JPRB,&
&.590E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.577E-03_JPRB,.577E-03_JPRB,.518E-03_JPRB,.518E-03_JPRB,&
&.499E-03_JPRB,.499E-03_JPRB,.510E-03_JPRB,.510E-03_JPRB,.508E-03_JPRB,.508E-03_JPRB,.615E-03_JPRB,&
&.615E-03_JPRB,.800E-03_JPRB,.800E-03_JPRB,.176E-02_JPRB,.176E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,&
&.230E-02_JPRB,.230E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.279E-02_JPRB,.279E-02_JPRB,.463E-02_JPRB,&
&.463E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.616E-02_JPRB,.616E-02_JPRB,.570E-02_JPRB,.570E-02_JPRB,&
&.528E-02_JPRB,.528E-02_JPRB,.397E-02_JPRB,.397E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.148E-02_JPRB,&
&.148E-02_JPRB,.932E-03_JPRB,.932E-03_JPRB,.787E-03_JPRB,.787E-03_JPRB,.667E-03_JPRB,.667E-03_JPRB,&
&.636E-03_JPRB,.636E-03_JPRB,.752E-03_JPRB,.752E-03_JPRB,.133E-02_JPRB,.133E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,&
&.108E-02_JPRB,.108E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 44 -82.0
ZAER (:,44,11) = (/&
&.662E-03_JPRB,.662E-03_JPRB,.631E-03_JPRB,.631E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,.572E-03_JPRB,&
&.572E-03_JPRB,.566E-03_JPRB,.566E-03_JPRB,.579E-03_JPRB,.579E-03_JPRB,.609E-03_JPRB,.609E-03_JPRB,&
&.660E-03_JPRB,.660E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,.105E-02_JPRB,&
&.105E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.212E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.199E-02_JPRB,&
&.199E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,&
&.890E-03_JPRB,.890E-03_JPRB,.770E-03_JPRB,.770E-03_JPRB,.723E-03_JPRB,.723E-03_JPRB,.698E-03_JPRB,&
&.698E-03_JPRB,.704E-03_JPRB,.704E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.768E-03_JPRB,.768E-03_JPRB,&
&.794E-03_JPRB,.794E-03_JPRB,.840E-03_JPRB,.840E-03_JPRB,.867E-03_JPRB,.867E-03_JPRB,.853E-03_JPRB,&
&.853E-03_JPRB,.825E-03_JPRB,.825E-03_JPRB,.778E-03_JPRB,.778E-03_JPRB,.726E-03_JPRB,.726E-03_JPRB,&
&.689E-03_JPRB,.689E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 45 -86.0
ZAER (:,45,11) = (/&
&.662E-03_JPRB,.662E-03_JPRB,.631E-03_JPRB,.631E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,.572E-03_JPRB,&
&.572E-03_JPRB,.566E-03_JPRB,.566E-03_JPRB,.579E-03_JPRB,.579E-03_JPRB,.609E-03_JPRB,.609E-03_JPRB,&
&.660E-03_JPRB,.660E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,.105E-02_JPRB,&
&.105E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.212E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.199E-02_JPRB,&
&.199E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,&
&.890E-03_JPRB,.890E-03_JPRB,.770E-03_JPRB,.770E-03_JPRB,.723E-03_JPRB,.723E-03_JPRB,.698E-03_JPRB,&
&.698E-03_JPRB,.704E-03_JPRB,.704E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.768E-03_JPRB,.768E-03_JPRB,&
&.794E-03_JPRB,.794E-03_JPRB,.840E-03_JPRB,.840E-03_JPRB,.867E-03_JPRB,.867E-03_JPRB,.853E-03_JPRB,&
&.853E-03_JPRB,.825E-03_JPRB,.825E-03_JPRB,.778E-03_JPRB,.778E-03_JPRB,.726E-03_JPRB,.726E-03_JPRB,&
&.689E-03_JPRB,.689E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 46 -90.0
ZAER (:,46,11) = (/&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB/)

!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=11  
  DO JI=1,46
    DO JL=1,72
      RAERSS(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SEA-SALT AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESS_11
