SUBROUTINE SUECAESS_10

!**   OPTICAL THICKNESS OF AEROSOLS OF SEA-SALT ORIGIN
!                                      October  

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESS* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSS


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,10:10)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Sea Salt Aerosol         month: 10 --- lat:  1  90.0
ZAER (:, 1,10) = (/&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  2  86.0
ZAER (:, 2,10) = (/&
&.512E-03_JPRB,.512E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.581E-03_JPRB,&
&.581E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.721E-03_JPRB,.721E-03_JPRB,&
&.735E-03_JPRB,.735E-03_JPRB,.745E-03_JPRB,.745E-03_JPRB,.724E-03_JPRB,.724E-03_JPRB,.683E-03_JPRB,&
&.683E-03_JPRB,.605E-03_JPRB,.605E-03_JPRB,.539E-03_JPRB,.539E-03_JPRB,.483E-03_JPRB,.483E-03_JPRB,&
&.424E-03_JPRB,.424E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.295E-03_JPRB,.295E-03_JPRB,.243E-03_JPRB,&
&.243E-03_JPRB,.212E-03_JPRB,.212E-03_JPRB,.220E-03_JPRB,.220E-03_JPRB,.241E-03_JPRB,.241E-03_JPRB,&
&.268E-03_JPRB,.268E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.287E-03_JPRB,&
&.287E-03_JPRB,.287E-03_JPRB,.287E-03_JPRB,.280E-03_JPRB,.280E-03_JPRB,.289E-03_JPRB,.289E-03_JPRB,&
&.318E-03_JPRB,.318E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.396E-03_JPRB,.396E-03_JPRB,.434E-03_JPRB,&
&.434E-03_JPRB,.450E-03_JPRB,.450E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.525E-03_JPRB,.525E-03_JPRB,&
&.530E-03_JPRB,.530E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  3  82.0
ZAER (:, 3,10) = (/&
&.512E-03_JPRB,.512E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.581E-03_JPRB,&
&.581E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.721E-03_JPRB,.721E-03_JPRB,&
&.735E-03_JPRB,.735E-03_JPRB,.745E-03_JPRB,.745E-03_JPRB,.724E-03_JPRB,.724E-03_JPRB,.683E-03_JPRB,&
&.683E-03_JPRB,.605E-03_JPRB,.605E-03_JPRB,.539E-03_JPRB,.539E-03_JPRB,.483E-03_JPRB,.483E-03_JPRB,&
&.424E-03_JPRB,.424E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.295E-03_JPRB,.295E-03_JPRB,.243E-03_JPRB,&
&.243E-03_JPRB,.212E-03_JPRB,.212E-03_JPRB,.220E-03_JPRB,.220E-03_JPRB,.241E-03_JPRB,.241E-03_JPRB,&
&.268E-03_JPRB,.268E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.287E-03_JPRB,&
&.287E-03_JPRB,.287E-03_JPRB,.287E-03_JPRB,.280E-03_JPRB,.280E-03_JPRB,.289E-03_JPRB,.289E-03_JPRB,&
&.318E-03_JPRB,.318E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.396E-03_JPRB,.396E-03_JPRB,.434E-03_JPRB,&
&.434E-03_JPRB,.450E-03_JPRB,.450E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.525E-03_JPRB,.525E-03_JPRB,&
&.530E-03_JPRB,.530E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  4  78.0
ZAER (:, 4,10) = (/&
&.434E-03_JPRB,.434E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.374E-03_JPRB,&
&.374E-03_JPRB,.383E-03_JPRB,.383E-03_JPRB,.421E-03_JPRB,.421E-03_JPRB,.641E-03_JPRB,.641E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.976E-03_JPRB,&
&.976E-03_JPRB,.883E-03_JPRB,.883E-03_JPRB,.772E-03_JPRB,.772E-03_JPRB,.633E-03_JPRB,.633E-03_JPRB,&
&.485E-03_JPRB,.485E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.296E-03_JPRB,.296E-03_JPRB,.269E-03_JPRB,&
&.269E-03_JPRB,.199E-03_JPRB,.199E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.259E-03_JPRB,.259E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.407E-03_JPRB,&
&.407E-03_JPRB,.409E-03_JPRB,.409E-03_JPRB,.283E-03_JPRB,.283E-03_JPRB,.226E-03_JPRB,.226E-03_JPRB,&
&.191E-03_JPRB,.191E-03_JPRB,.185E-03_JPRB,.185E-03_JPRB,.205E-03_JPRB,.205E-03_JPRB,.300E-03_JPRB,&
&.300E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.385E-03_JPRB,.385E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,&
&.441E-03_JPRB,.441E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  5  74.0
ZAER (:, 5,10) = (/&
&.434E-03_JPRB,.434E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.374E-03_JPRB,&
&.374E-03_JPRB,.383E-03_JPRB,.383E-03_JPRB,.421E-03_JPRB,.421E-03_JPRB,.641E-03_JPRB,.641E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.976E-03_JPRB,&
&.976E-03_JPRB,.883E-03_JPRB,.883E-03_JPRB,.772E-03_JPRB,.772E-03_JPRB,.633E-03_JPRB,.633E-03_JPRB,&
&.485E-03_JPRB,.485E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.296E-03_JPRB,.296E-03_JPRB,.269E-03_JPRB,&
&.269E-03_JPRB,.199E-03_JPRB,.199E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.259E-03_JPRB,.259E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.407E-03_JPRB,&
&.407E-03_JPRB,.409E-03_JPRB,.409E-03_JPRB,.283E-03_JPRB,.283E-03_JPRB,.226E-03_JPRB,.226E-03_JPRB,&
&.191E-03_JPRB,.191E-03_JPRB,.185E-03_JPRB,.185E-03_JPRB,.205E-03_JPRB,.205E-03_JPRB,.300E-03_JPRB,&
&.300E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.385E-03_JPRB,.385E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,&
&.441E-03_JPRB,.441E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  6  70.0
ZAER (:, 6,10) = (/&
&.157E-02_JPRB,.157E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.223E-02_JPRB,.223E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,&
&.559E-03_JPRB,.559E-03_JPRB,.338E-03_JPRB,.338E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,.708E-03_JPRB,&
&.708E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.432E-03_JPRB,.432E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,&
&.891E-03_JPRB,.891E-03_JPRB,.115E-02_JPRB,.115E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.185E-02_JPRB,&
&.185E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.922E-03_JPRB,.922E-03_JPRB,&
&.940E-03_JPRB,.940E-03_JPRB,.937E-03_JPRB,.937E-03_JPRB,.127E-02_JPRB,.127E-02_JPRB,.186E-02_JPRB,&
&.186E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,&
&.163E-02_JPRB,.163E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  7  66.0
ZAER (:, 7,10) = (/&
&.157E-02_JPRB,.157E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.223E-02_JPRB,.223E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,&
&.559E-03_JPRB,.559E-03_JPRB,.338E-03_JPRB,.338E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,.708E-03_JPRB,&
&.708E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.432E-03_JPRB,.432E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,&
&.891E-03_JPRB,.891E-03_JPRB,.115E-02_JPRB,.115E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.185E-02_JPRB,&
&.185E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.922E-03_JPRB,.922E-03_JPRB,&
&.940E-03_JPRB,.940E-03_JPRB,.937E-03_JPRB,.937E-03_JPRB,.127E-02_JPRB,.127E-02_JPRB,.186E-02_JPRB,&
&.186E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,&
&.163E-02_JPRB,.163E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  8  62.0
ZAER (:, 8,10) = (/&
&.911E-02_JPRB,.911E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.906E-02_JPRB,.906E-02_JPRB,.837E-02_JPRB,&
&.837E-02_JPRB,.821E-02_JPRB,.821E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.990E-02_JPRB,&
&.990E-02_JPRB,.819E-02_JPRB,.819E-02_JPRB,.647E-02_JPRB,.647E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,&
&.163E-02_JPRB,.163E-02_JPRB,.665E-03_JPRB,.665E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.162E-02_JPRB,&
&.162E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,&
&.198E-02_JPRB,.198E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.670E-02_JPRB,&
&.670E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,&
&.627E-02_JPRB,.627E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.778E-02_JPRB,&
&.778E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,&
&.877E-02_JPRB,.877E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  9  58.0
ZAER (:, 9,10) = (/&
&.911E-02_JPRB,.911E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.906E-02_JPRB,.906E-02_JPRB,.837E-02_JPRB,&
&.837E-02_JPRB,.821E-02_JPRB,.821E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.990E-02_JPRB,&
&.990E-02_JPRB,.819E-02_JPRB,.819E-02_JPRB,.647E-02_JPRB,.647E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,&
&.163E-02_JPRB,.163E-02_JPRB,.665E-03_JPRB,.665E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.162E-02_JPRB,&
&.162E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,&
&.198E-02_JPRB,.198E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.670E-02_JPRB,&
&.670E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,&
&.627E-02_JPRB,.627E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.778E-02_JPRB,&
&.778E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,&
&.877E-02_JPRB,.877E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 10  54.0
ZAER (:,10,10) = (/&
&.995E-02_JPRB,.995E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.722E-02_JPRB,.722E-02_JPRB,.862E-02_JPRB,.862E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.918E-02_JPRB,.918E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.913E-02_JPRB,.913E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,&
&.717E-02_JPRB,.717E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.930E-02_JPRB,&
&.930E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.919E-02_JPRB,.919E-02_JPRB,&
&.914E-02_JPRB,.914E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.884E-02_JPRB,&
&.884E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,&
&.936E-02_JPRB,.936E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 11  50.0
ZAER (:,11,10) = (/&
&.995E-02_JPRB,.995E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.722E-02_JPRB,.722E-02_JPRB,.862E-02_JPRB,.862E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.918E-02_JPRB,.918E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.913E-02_JPRB,.913E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,&
&.717E-02_JPRB,.717E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.930E-02_JPRB,&
&.930E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.919E-02_JPRB,.919E-02_JPRB,&
&.914E-02_JPRB,.914E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.884E-02_JPRB,&
&.884E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,&
&.936E-02_JPRB,.936E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 12  46.0
ZAER (:,12,10) = (/&
&.763E-02_JPRB,.763E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.830E-02_JPRB,&
&.830E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,&
&.848E-02_JPRB,.848E-02_JPRB,.907E-02_JPRB,.907E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.723E-02_JPRB,&
&.723E-02_JPRB,.456E-02_JPRB,.456E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.981E-02_JPRB,.981E-02_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.991E-02_JPRB,.991E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,&
&.932E-02_JPRB,.932E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.753E-02_JPRB,&
&.753E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,&
&.557E-02_JPRB,.557E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 13  42.0
ZAER (:,13,10) = (/&
&.763E-02_JPRB,.763E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.830E-02_JPRB,&
&.830E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,&
&.848E-02_JPRB,.848E-02_JPRB,.907E-02_JPRB,.907E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.723E-02_JPRB,&
&.723E-02_JPRB,.456E-02_JPRB,.456E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.981E-02_JPRB,.981E-02_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.991E-02_JPRB,.991E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,&
&.932E-02_JPRB,.932E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.753E-02_JPRB,&
&.753E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,&
&.557E-02_JPRB,.557E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 14  38.0
ZAER (:,14,10) = (/&
&.746E-02_JPRB,.746E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.726E-02_JPRB,&
&.726E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,&
&.748E-02_JPRB,.748E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.567E-02_JPRB,&
&.567E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,&
&.895E-02_JPRB,.895E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.838E-02_JPRB,&
&.838E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,&
&.912E-02_JPRB,.912E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.877E-02_JPRB,&
&.877E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,&
&.740E-02_JPRB,.740E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.626E-02_JPRB,&
&.626E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,&
&.714E-02_JPRB,.714E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 15  34.0
ZAER (:,15,10) = (/&
&.746E-02_JPRB,.746E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.726E-02_JPRB,&
&.726E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,&
&.748E-02_JPRB,.748E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.567E-02_JPRB,&
&.567E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,&
&.895E-02_JPRB,.895E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.838E-02_JPRB,&
&.838E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,&
&.912E-02_JPRB,.912E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.877E-02_JPRB,&
&.877E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,&
&.740E-02_JPRB,.740E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.626E-02_JPRB,&
&.626E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,&
&.714E-02_JPRB,.714E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 16  30.0
ZAER (:,16,10) = (/&
&.811E-02_JPRB,.811E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.787E-02_JPRB,&
&.787E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.824E-02_JPRB,.824E-02_JPRB,&
&.862E-02_JPRB,.862E-02_JPRB,.928E-02_JPRB,.928E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,&
&.769E-02_JPRB,.769E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.686E-02_JPRB,&
&.686E-02_JPRB,.712E-02_JPRB,.712E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,&
&.491E-02_JPRB,.491E-02_JPRB,.759E-02_JPRB,.759E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.686E-02_JPRB,&
&.686E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,&
&.768E-02_JPRB,.768E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.337E-02_JPRB,&
&.337E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.451E-02_JPRB,.451E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,&
&.803E-02_JPRB,.803E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 17  26.0
ZAER (:,17,10) = (/&
&.811E-02_JPRB,.811E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.787E-02_JPRB,&
&.787E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.824E-02_JPRB,.824E-02_JPRB,&
&.862E-02_JPRB,.862E-02_JPRB,.928E-02_JPRB,.928E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,&
&.769E-02_JPRB,.769E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.686E-02_JPRB,&
&.686E-02_JPRB,.712E-02_JPRB,.712E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,&
&.491E-02_JPRB,.491E-02_JPRB,.759E-02_JPRB,.759E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.686E-02_JPRB,&
&.686E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,&
&.768E-02_JPRB,.768E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.337E-02_JPRB,&
&.337E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.451E-02_JPRB,.451E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,&
&.803E-02_JPRB,.803E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 18  22.0
ZAER (:,18,10) = (/&
&.963E-02_JPRB,.963E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.961E-02_JPRB,.961E-02_JPRB,.719E-02_JPRB,&
&.719E-02_JPRB,.366E-02_JPRB,.366E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,&
&.634E-02_JPRB,.634E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.619E-02_JPRB,&
&.619E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,&
&.270E-02_JPRB,.270E-02_JPRB,.519E-02_JPRB,.519E-02_JPRB,.728E-02_JPRB,.728E-02_JPRB,.902E-02_JPRB,&
&.902E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.946E-02_JPRB,.946E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.458E-02_JPRB,&
&.458E-02_JPRB,.454E-02_JPRB,.454E-02_JPRB,.667E-02_JPRB,.667E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,&
&.869E-02_JPRB,.869E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 19  18.0
ZAER (:,19,10) = (/&
&.963E-02_JPRB,.963E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.961E-02_JPRB,.961E-02_JPRB,.719E-02_JPRB,&
&.719E-02_JPRB,.366E-02_JPRB,.366E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,&
&.634E-02_JPRB,.634E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.619E-02_JPRB,&
&.619E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,&
&.270E-02_JPRB,.270E-02_JPRB,.519E-02_JPRB,.519E-02_JPRB,.728E-02_JPRB,.728E-02_JPRB,.902E-02_JPRB,&
&.902E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.946E-02_JPRB,.946E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.458E-02_JPRB,&
&.458E-02_JPRB,.454E-02_JPRB,.454E-02_JPRB,.667E-02_JPRB,.667E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,&
&.869E-02_JPRB,.869E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 20  14.0
ZAER (:,20,10) = (/&
&.118E-01_JPRB,.118E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.118E-01_JPRB,.118E-01_JPRB,.918E-02_JPRB,.918E-02_JPRB,.666E-02_JPRB,.666E-02_JPRB,.396E-02_JPRB,&
&.396E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,&
&.648E-02_JPRB,.648E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.706E-02_JPRB,.706E-02_JPRB,.499E-02_JPRB,&
&.499E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.121E-02_JPRB,.121E-02_JPRB,&
&.241E-02_JPRB,.241E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.137E-01_JPRB,&
&.137E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.939E-02_JPRB,.939E-02_JPRB,.759E-02_JPRB,.759E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.974E-02_JPRB,.974E-02_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 21  10.0
ZAER (:,21,10) = (/&
&.118E-01_JPRB,.118E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.118E-01_JPRB,.118E-01_JPRB,.918E-02_JPRB,.918E-02_JPRB,.666E-02_JPRB,.666E-02_JPRB,.396E-02_JPRB,&
&.396E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,&
&.648E-02_JPRB,.648E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.706E-02_JPRB,.706E-02_JPRB,.499E-02_JPRB,&
&.499E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.121E-02_JPRB,.121E-02_JPRB,&
&.241E-02_JPRB,.241E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.137E-01_JPRB,&
&.137E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.939E-02_JPRB,.939E-02_JPRB,.759E-02_JPRB,.759E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.974E-02_JPRB,.974E-02_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 22   6.0
ZAER (:,22,10) = (/&
&.135E-01_JPRB,.135E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.886E-02_JPRB,.886E-02_JPRB,&
&.710E-02_JPRB,.710E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.151E-02_JPRB,&
&.151E-02_JPRB,.819E-03_JPRB,.819E-03_JPRB,.215E-02_JPRB,.215E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.687E-02_JPRB,.687E-02_JPRB,.480E-02_JPRB,&
&.480E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.914E-03_JPRB,.914E-03_JPRB,&
&.302E-02_JPRB,.302E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.925E-02_JPRB,.925E-02_JPRB,.986E-02_JPRB,&
&.986E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,&
&.470E-02_JPRB,.470E-02_JPRB,.492E-02_JPRB,.492E-02_JPRB,.578E-02_JPRB,.578E-02_JPRB,.487E-02_JPRB,&
&.487E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.847E-02_JPRB,.847E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 23   2.0
ZAER (:,23,10) = (/&
&.135E-01_JPRB,.135E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.886E-02_JPRB,.886E-02_JPRB,&
&.710E-02_JPRB,.710E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.151E-02_JPRB,&
&.151E-02_JPRB,.819E-03_JPRB,.819E-03_JPRB,.215E-02_JPRB,.215E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.687E-02_JPRB,.687E-02_JPRB,.480E-02_JPRB,&
&.480E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.914E-03_JPRB,.914E-03_JPRB,&
&.302E-02_JPRB,.302E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.925E-02_JPRB,.925E-02_JPRB,.986E-02_JPRB,&
&.986E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,&
&.470E-02_JPRB,.470E-02_JPRB,.492E-02_JPRB,.492E-02_JPRB,.578E-02_JPRB,.578E-02_JPRB,.487E-02_JPRB,&
&.487E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.847E-02_JPRB,.847E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 24  -2.0
ZAER (:,24,10) = (/&
&.949E-02_JPRB,.949E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.950E-02_JPRB,.950E-02_JPRB,&
&.748E-02_JPRB,.748E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,.650E-02_JPRB,.650E-02_JPRB,.287E-02_JPRB,&
&.287E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.993E-02_JPRB,.993E-02_JPRB,.705E-02_JPRB,.705E-02_JPRB,.415E-02_JPRB,&
&.415E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.643E-03_JPRB,.643E-03_JPRB,.107E-02_JPRB,.107E-02_JPRB,&
&.292E-02_JPRB,.292E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.849E-02_JPRB,&
&.849E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,&
&.306E-02_JPRB,.306E-02_JPRB,.454E-02_JPRB,.454E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.618E-02_JPRB,&
&.618E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,&
&.941E-02_JPRB,.941E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 25  -6.0
ZAER (:,25,10) = (/&
&.949E-02_JPRB,.949E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.950E-02_JPRB,.950E-02_JPRB,&
&.748E-02_JPRB,.748E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,.650E-02_JPRB,.650E-02_JPRB,.287E-02_JPRB,&
&.287E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.993E-02_JPRB,.993E-02_JPRB,.705E-02_JPRB,.705E-02_JPRB,.415E-02_JPRB,&
&.415E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.643E-03_JPRB,.643E-03_JPRB,.107E-02_JPRB,.107E-02_JPRB,&
&.292E-02_JPRB,.292E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.849E-02_JPRB,&
&.849E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,&
&.306E-02_JPRB,.306E-02_JPRB,.454E-02_JPRB,.454E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.618E-02_JPRB,&
&.618E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,&
&.941E-02_JPRB,.941E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 26 -10.0
ZAER (:,26,10) = (/&
&.801E-02_JPRB,.801E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.471E-02_JPRB,.471E-02_JPRB,.528E-02_JPRB,&
&.528E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.992E-02_JPRB,.992E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB,.977E-02_JPRB,.977E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.961E-03_JPRB,.961E-03_JPRB,.850E-03_JPRB,.850E-03_JPRB,.129E-02_JPRB,.129E-02_JPRB,&
&.216E-02_JPRB,.216E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.684E-02_JPRB,.684E-02_JPRB,.701E-02_JPRB,&
&.701E-02_JPRB,.525E-02_JPRB,.525E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,&
&.347E-02_JPRB,.347E-02_JPRB,.706E-02_JPRB,.706E-02_JPRB,.726E-02_JPRB,.726E-02_JPRB,.819E-02_JPRB,&
&.819E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.894E-02_JPRB,.894E-02_JPRB,&
&.865E-02_JPRB,.865E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 27 -14.0
ZAER (:,27,10) = (/&
&.801E-02_JPRB,.801E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.471E-02_JPRB,.471E-02_JPRB,.528E-02_JPRB,&
&.528E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.992E-02_JPRB,.992E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB,.977E-02_JPRB,.977E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.961E-03_JPRB,.961E-03_JPRB,.850E-03_JPRB,.850E-03_JPRB,.129E-02_JPRB,.129E-02_JPRB,&
&.216E-02_JPRB,.216E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.684E-02_JPRB,.684E-02_JPRB,.701E-02_JPRB,&
&.701E-02_JPRB,.525E-02_JPRB,.525E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,&
&.347E-02_JPRB,.347E-02_JPRB,.706E-02_JPRB,.706E-02_JPRB,.726E-02_JPRB,.726E-02_JPRB,.819E-02_JPRB,&
&.819E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.894E-02_JPRB,.894E-02_JPRB,&
&.865E-02_JPRB,.865E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 28 -18.0
ZAER (:,28,10) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.804E-02_JPRB,.804E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.900E-02_JPRB,&
&.900E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.812E-02_JPRB,.812E-02_JPRB,.444E-02_JPRB,&
&.444E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,.227E-02_JPRB,.227E-02_JPRB,&
&.249E-02_JPRB,.249E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.453E-02_JPRB,&
&.453E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,&
&.232E-02_JPRB,.232E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 29 -22.0
ZAER (:,29,10) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.804E-02_JPRB,.804E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.900E-02_JPRB,&
&.900E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.812E-02_JPRB,.812E-02_JPRB,.444E-02_JPRB,&
&.444E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,.227E-02_JPRB,.227E-02_JPRB,&
&.249E-02_JPRB,.249E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.453E-02_JPRB,&
&.453E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,&
&.232E-02_JPRB,.232E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 30 -26.0
ZAER (:,30,10) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.866E-02_JPRB,.866E-02_JPRB,&
&.632E-02_JPRB,.632E-02_JPRB,.621E-02_JPRB,.621E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.894E-02_JPRB,&
&.894E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.642E-02_JPRB,&
&.642E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,&
&.346E-02_JPRB,.346E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.237E-02_JPRB,&
&.237E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,&
&.117E-02_JPRB,.117E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,.785E-02_JPRB,&
&.785E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 31 -30.0
ZAER (:,31,10) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.866E-02_JPRB,.866E-02_JPRB,&
&.632E-02_JPRB,.632E-02_JPRB,.621E-02_JPRB,.621E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.894E-02_JPRB,&
&.894E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.642E-02_JPRB,&
&.642E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,&
&.346E-02_JPRB,.346E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.237E-02_JPRB,&
&.237E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,&
&.117E-02_JPRB,.117E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,.785E-02_JPRB,&
&.785E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 32 -34.0
ZAER (:,32,10) = (/&
&.999E-02_JPRB,.999E-02_JPRB,.896E-02_JPRB,.896E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.910E-02_JPRB,&
&.910E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.478E-02_JPRB,.478E-02_JPRB,&
&.394E-02_JPRB,.394E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,.413E-02_JPRB,&
&.413E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.774E-02_JPRB,&
&.774E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,&
&.455E-02_JPRB,.455E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.200E-02_JPRB,&
&.200E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.998E-03_JPRB,.998E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB,.953E-03_JPRB,.953E-03_JPRB,.247E-02_JPRB,.247E-02_JPRB,.352E-02_JPRB,&
&.352E-02_JPRB,.647E-02_JPRB,.647E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.115E-01_JPRB,.115E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 33 -38.0
ZAER (:,33,10) = (/&
&.999E-02_JPRB,.999E-02_JPRB,.896E-02_JPRB,.896E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.910E-02_JPRB,&
&.910E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.478E-02_JPRB,.478E-02_JPRB,&
&.394E-02_JPRB,.394E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,.413E-02_JPRB,&
&.413E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.774E-02_JPRB,&
&.774E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,&
&.455E-02_JPRB,.455E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.200E-02_JPRB,&
&.200E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.998E-03_JPRB,.998E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB,.953E-03_JPRB,.953E-03_JPRB,.247E-02_JPRB,.247E-02_JPRB,.352E-02_JPRB,&
&.352E-02_JPRB,.647E-02_JPRB,.647E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.115E-01_JPRB,.115E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 34 -42.0
ZAER (:,34,10) = (/&
&.880E-02_JPRB,.880E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.713E-02_JPRB,.713E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,&
&.205E-02_JPRB,.205E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.612E-02_JPRB,.612E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.843E-02_JPRB,&
&.843E-02_JPRB,.503E-02_JPRB,.503E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,&
&.438E-02_JPRB,.438E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.290E-02_JPRB,.290E-02_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,&
&.999E-03_JPRB,.999E-03_JPRB,.930E-03_JPRB,.930E-03_JPRB,.870E-03_JPRB,.870E-03_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,&
&.915E-02_JPRB,.915E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 35 -46.0
ZAER (:,35,10) = (/&
&.880E-02_JPRB,.880E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.713E-02_JPRB,.713E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,&
&.205E-02_JPRB,.205E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.612E-02_JPRB,.612E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.843E-02_JPRB,&
&.843E-02_JPRB,.503E-02_JPRB,.503E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,&
&.438E-02_JPRB,.438E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.290E-02_JPRB,.290E-02_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,&
&.999E-03_JPRB,.999E-03_JPRB,.930E-03_JPRB,.930E-03_JPRB,.870E-03_JPRB,.870E-03_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,&
&.915E-02_JPRB,.915E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 36 -50.0
ZAER (:,36,10) = (/&
&.794E-02_JPRB,.794E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.825E-02_JPRB,.825E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.665E-02_JPRB,.665E-02_JPRB,.264E-02_JPRB,.264E-02_JPRB,&
&.161E-02_JPRB,.161E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.172E-02_JPRB,&
&.172E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.332E-02_JPRB,.332E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.827E-02_JPRB,&
&.827E-02_JPRB,.539E-02_JPRB,.539E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.273E-02_JPRB,.273E-02_JPRB,&
&.251E-02_JPRB,.251E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.169E-02_JPRB,&
&.169E-02_JPRB,.150E-02_JPRB,.150E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.935E-03_JPRB,.935E-03_JPRB,.772E-03_JPRB,.772E-03_JPRB,.719E-03_JPRB,&
&.719E-03_JPRB,.301E-02_JPRB,.301E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,&
&.808E-02_JPRB,.808E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 37 -54.0
ZAER (:,37,10) = (/&
&.794E-02_JPRB,.794E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.825E-02_JPRB,.825E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.665E-02_JPRB,.665E-02_JPRB,.264E-02_JPRB,.264E-02_JPRB,&
&.161E-02_JPRB,.161E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.172E-02_JPRB,&
&.172E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.332E-02_JPRB,.332E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.827E-02_JPRB,&
&.827E-02_JPRB,.539E-02_JPRB,.539E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.273E-02_JPRB,.273E-02_JPRB,&
&.251E-02_JPRB,.251E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.169E-02_JPRB,&
&.169E-02_JPRB,.150E-02_JPRB,.150E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.935E-03_JPRB,.935E-03_JPRB,.772E-03_JPRB,.772E-03_JPRB,.719E-03_JPRB,&
&.719E-03_JPRB,.301E-02_JPRB,.301E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,&
&.808E-02_JPRB,.808E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 38 -58.0
ZAER (:,38,10) = (/&
&.461E-02_JPRB,.461E-02_JPRB,.546E-02_JPRB,.546E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.301E-02_JPRB,.301E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,&
&.989E-03_JPRB,.989E-03_JPRB,.104E-02_JPRB,.104E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.303E-02_JPRB,&
&.303E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,&
&.925E-02_JPRB,.925E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.929E-02_JPRB,&
&.929E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.359E-02_JPRB,.359E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.193E-02_JPRB,.193E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.133E-02_JPRB,&
&.133E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,&
&.897E-03_JPRB,.897E-03_JPRB,.789E-03_JPRB,.789E-03_JPRB,.672E-03_JPRB,.672E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.170E-02_JPRB,.170E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,&
&.367E-02_JPRB,.367E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 39 -62.0
ZAER (:,39,10) = (/&
&.461E-02_JPRB,.461E-02_JPRB,.546E-02_JPRB,.546E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.301E-02_JPRB,.301E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,&
&.989E-03_JPRB,.989E-03_JPRB,.104E-02_JPRB,.104E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.303E-02_JPRB,&
&.303E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,&
&.925E-02_JPRB,.925E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.929E-02_JPRB,&
&.929E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.359E-02_JPRB,.359E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.193E-02_JPRB,.193E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.133E-02_JPRB,&
&.133E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,&
&.897E-03_JPRB,.897E-03_JPRB,.789E-03_JPRB,.789E-03_JPRB,.672E-03_JPRB,.672E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.170E-02_JPRB,.170E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,&
&.367E-02_JPRB,.367E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 40 -66.0
ZAER (:,40,10) = (/&
&.117E-02_JPRB,.117E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.124E-02_JPRB,&
&.124E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.959E-03_JPRB,.959E-03_JPRB,&
&.560E-03_JPRB,.560E-03_JPRB,.685E-03_JPRB,.685E-03_JPRB,.726E-03_JPRB,.726E-03_JPRB,.136E-02_JPRB,&
&.136E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,&
&.267E-02_JPRB,.267E-02_JPRB,.440E-02_JPRB,.440E-02_JPRB,.551E-02_JPRB,.551E-02_JPRB,.719E-02_JPRB,&
&.719E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,&
&.318E-02_JPRB,.318E-02_JPRB,.372E-02_JPRB,.372E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.184E-02_JPRB,&
&.184E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.839E-03_JPRB,.839E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,&
&.633E-03_JPRB,.633E-03_JPRB,.587E-03_JPRB,.587E-03_JPRB,.548E-03_JPRB,.548E-03_JPRB,.470E-03_JPRB,&
&.470E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.554E-03_JPRB,.554E-03_JPRB,.548E-03_JPRB,.548E-03_JPRB,&
&.682E-03_JPRB,.682E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 41 -70.0
ZAER (:,41,10) = (/&
&.117E-02_JPRB,.117E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.124E-02_JPRB,&
&.124E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.959E-03_JPRB,.959E-03_JPRB,&
&.560E-03_JPRB,.560E-03_JPRB,.685E-03_JPRB,.685E-03_JPRB,.726E-03_JPRB,.726E-03_JPRB,.136E-02_JPRB,&
&.136E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,&
&.267E-02_JPRB,.267E-02_JPRB,.440E-02_JPRB,.440E-02_JPRB,.551E-02_JPRB,.551E-02_JPRB,.719E-02_JPRB,&
&.719E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,&
&.318E-02_JPRB,.318E-02_JPRB,.372E-02_JPRB,.372E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.184E-02_JPRB,&
&.184E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.839E-03_JPRB,.839E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,&
&.633E-03_JPRB,.633E-03_JPRB,.587E-03_JPRB,.587E-03_JPRB,.548E-03_JPRB,.548E-03_JPRB,.470E-03_JPRB,&
&.470E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.554E-03_JPRB,.554E-03_JPRB,.548E-03_JPRB,.548E-03_JPRB,&
&.682E-03_JPRB,.682E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 42 -74.0
ZAER (:,42,10) = (/&
&.439E-03_JPRB,.439E-03_JPRB,.503E-03_JPRB,.503E-03_JPRB,.556E-03_JPRB,.556E-03_JPRB,.581E-03_JPRB,&
&.581E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,&
&.445E-03_JPRB,.445E-03_JPRB,.415E-03_JPRB,.415E-03_JPRB,.468E-03_JPRB,.468E-03_JPRB,.585E-03_JPRB,&
&.585E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,&
&.148E-02_JPRB,.148E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.114E-02_JPRB,.114E-02_JPRB,.276E-02_JPRB,&
&.276E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.527E-02_JPRB,.527E-02_JPRB,&
&.539E-02_JPRB,.539E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.298E-02_JPRB,.298E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.678E-03_JPRB,.678E-03_JPRB,.479E-03_JPRB,.479E-03_JPRB,&
&.455E-03_JPRB,.455E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.954E-03_JPRB,&
&.954E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,.374E-03_JPRB,.374E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 43 -78.0
ZAER (:,43,10) = (/&
&.439E-03_JPRB,.439E-03_JPRB,.503E-03_JPRB,.503E-03_JPRB,.556E-03_JPRB,.556E-03_JPRB,.581E-03_JPRB,&
&.581E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,&
&.445E-03_JPRB,.445E-03_JPRB,.415E-03_JPRB,.415E-03_JPRB,.468E-03_JPRB,.468E-03_JPRB,.585E-03_JPRB,&
&.585E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,&
&.148E-02_JPRB,.148E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.114E-02_JPRB,.114E-02_JPRB,.276E-02_JPRB,&
&.276E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.527E-02_JPRB,.527E-02_JPRB,&
&.539E-02_JPRB,.539E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.298E-02_JPRB,.298E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.678E-03_JPRB,.678E-03_JPRB,.479E-03_JPRB,.479E-03_JPRB,&
&.455E-03_JPRB,.455E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.954E-03_JPRB,&
&.954E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,.374E-03_JPRB,.374E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 44 -82.0
ZAER (:,44,10) = (/&
&.345E-03_JPRB,.345E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.416E-03_JPRB,&
&.416E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.423E-03_JPRB,.423E-03_JPRB,&
&.433E-03_JPRB,.433E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.534E-03_JPRB,&
&.534E-03_JPRB,.638E-03_JPRB,.638E-03_JPRB,.857E-03_JPRB,.857E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.953E-03_JPRB,.953E-03_JPRB,.856E-03_JPRB,.856E-03_JPRB,.759E-03_JPRB,.759E-03_JPRB,.721E-03_JPRB,&
&.721E-03_JPRB,.740E-03_JPRB,.740E-03_JPRB,.917E-03_JPRB,.917E-03_JPRB,.558E-03_JPRB,.558E-03_JPRB,&
&.457E-03_JPRB,.457E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.428E-03_JPRB,&
&.428E-03_JPRB,.411E-03_JPRB,.411E-03_JPRB,.412E-03_JPRB,.412E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.471E-03_JPRB,.471E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.514E-03_JPRB,.514E-03_JPRB,.424E-03_JPRB,&
&.424E-03_JPRB,.343E-03_JPRB,.343E-03_JPRB,.334E-03_JPRB,.334E-03_JPRB,.345E-03_JPRB,.345E-03_JPRB,&
&.345E-03_JPRB,.345E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 45 -86.0
ZAER (:,45,10) = (/&
&.345E-03_JPRB,.345E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.416E-03_JPRB,&
&.416E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.423E-03_JPRB,.423E-03_JPRB,&
&.433E-03_JPRB,.433E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.534E-03_JPRB,&
&.534E-03_JPRB,.638E-03_JPRB,.638E-03_JPRB,.857E-03_JPRB,.857E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.953E-03_JPRB,.953E-03_JPRB,.856E-03_JPRB,.856E-03_JPRB,.759E-03_JPRB,.759E-03_JPRB,.721E-03_JPRB,&
&.721E-03_JPRB,.740E-03_JPRB,.740E-03_JPRB,.917E-03_JPRB,.917E-03_JPRB,.558E-03_JPRB,.558E-03_JPRB,&
&.457E-03_JPRB,.457E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.428E-03_JPRB,&
&.428E-03_JPRB,.411E-03_JPRB,.411E-03_JPRB,.412E-03_JPRB,.412E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.471E-03_JPRB,.471E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.514E-03_JPRB,.514E-03_JPRB,.424E-03_JPRB,&
&.424E-03_JPRB,.343E-03_JPRB,.343E-03_JPRB,.334E-03_JPRB,.334E-03_JPRB,.345E-03_JPRB,.345E-03_JPRB,&
&.345E-03_JPRB,.345E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 46 -90.0
ZAER (:,46,10) = (/&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB/)

!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=10   
  DO JI=1,46
    DO JL=1,72
      RAERSS(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SEA-SALT AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESS_10
