SUBROUTINE SUECAESS_04

!**   OPTICAL THICKNESS OF AEROSOLS OF SEA-SALT ORIGIN
!                                      April

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESS* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSS


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,4:4)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Sea Salt Aerosol         month:  4 --- lat:  1  90.0
ZAER (:, 1, 4) = (/&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  2  86.0
ZAER (:, 2, 4) = (/&
&.374E-03_JPRB,.374E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,.442E-03_JPRB,&
&.442E-03_JPRB,.460E-03_JPRB,.460E-03_JPRB,.485E-03_JPRB,.485E-03_JPRB,.514E-03_JPRB,.514E-03_JPRB,&
&.537E-03_JPRB,.537E-03_JPRB,.537E-03_JPRB,.537E-03_JPRB,.532E-03_JPRB,.532E-03_JPRB,.526E-03_JPRB,&
&.526E-03_JPRB,.530E-03_JPRB,.530E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,.505E-03_JPRB,.505E-03_JPRB,&
&.471E-03_JPRB,.471E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.365E-03_JPRB,.365E-03_JPRB,.285E-03_JPRB,&
&.285E-03_JPRB,.216E-03_JPRB,.216E-03_JPRB,.165E-03_JPRB,.165E-03_JPRB,.144E-03_JPRB,.144E-03_JPRB,&
&.152E-03_JPRB,.152E-03_JPRB,.162E-03_JPRB,.162E-03_JPRB,.175E-03_JPRB,.175E-03_JPRB,.183E-03_JPRB,&
&.183E-03_JPRB,.186E-03_JPRB,.186E-03_JPRB,.187E-03_JPRB,.187E-03_JPRB,.188E-03_JPRB,.188E-03_JPRB,&
&.194E-03_JPRB,.194E-03_JPRB,.206E-03_JPRB,.206E-03_JPRB,.224E-03_JPRB,.224E-03_JPRB,.242E-03_JPRB,&
&.242E-03_JPRB,.268E-03_JPRB,.268E-03_JPRB,.295E-03_JPRB,.295E-03_JPRB,.325E-03_JPRB,.325E-03_JPRB,&
&.351E-03_JPRB,.351E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  3  82.0
ZAER (:, 3, 4) = (/&
&.374E-03_JPRB,.374E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,.442E-03_JPRB,&
&.442E-03_JPRB,.460E-03_JPRB,.460E-03_JPRB,.485E-03_JPRB,.485E-03_JPRB,.514E-03_JPRB,.514E-03_JPRB,&
&.537E-03_JPRB,.537E-03_JPRB,.537E-03_JPRB,.537E-03_JPRB,.532E-03_JPRB,.532E-03_JPRB,.526E-03_JPRB,&
&.526E-03_JPRB,.530E-03_JPRB,.530E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,.505E-03_JPRB,.505E-03_JPRB,&
&.471E-03_JPRB,.471E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.365E-03_JPRB,.365E-03_JPRB,.285E-03_JPRB,&
&.285E-03_JPRB,.216E-03_JPRB,.216E-03_JPRB,.165E-03_JPRB,.165E-03_JPRB,.144E-03_JPRB,.144E-03_JPRB,&
&.152E-03_JPRB,.152E-03_JPRB,.162E-03_JPRB,.162E-03_JPRB,.175E-03_JPRB,.175E-03_JPRB,.183E-03_JPRB,&
&.183E-03_JPRB,.186E-03_JPRB,.186E-03_JPRB,.187E-03_JPRB,.187E-03_JPRB,.188E-03_JPRB,.188E-03_JPRB,&
&.194E-03_JPRB,.194E-03_JPRB,.206E-03_JPRB,.206E-03_JPRB,.224E-03_JPRB,.224E-03_JPRB,.242E-03_JPRB,&
&.242E-03_JPRB,.268E-03_JPRB,.268E-03_JPRB,.295E-03_JPRB,.295E-03_JPRB,.325E-03_JPRB,.325E-03_JPRB,&
&.351E-03_JPRB,.351E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  4  78.0
ZAER (:, 4, 4) = (/&
&.560E-03_JPRB,.560E-03_JPRB,.990E-03_JPRB,.990E-03_JPRB,.105E-02_JPRB,.105E-02_JPRB,.863E-03_JPRB,&
&.863E-03_JPRB,.678E-03_JPRB,.678E-03_JPRB,.542E-03_JPRB,.542E-03_JPRB,.473E-03_JPRB,.473E-03_JPRB,&
&.560E-03_JPRB,.560E-03_JPRB,.715E-03_JPRB,.715E-03_JPRB,.802E-03_JPRB,.802E-03_JPRB,.864E-03_JPRB,&
&.864E-03_JPRB,.887E-03_JPRB,.887E-03_JPRB,.864E-03_JPRB,.864E-03_JPRB,.783E-03_JPRB,.783E-03_JPRB,&
&.666E-03_JPRB,.666E-03_JPRB,.599E-03_JPRB,.599E-03_JPRB,.522E-03_JPRB,.522E-03_JPRB,.411E-03_JPRB,&
&.411E-03_JPRB,.293E-03_JPRB,.293E-03_JPRB,.174E-03_JPRB,.174E-03_JPRB,.167E-03_JPRB,.167E-03_JPRB,&
&.224E-03_JPRB,.224E-03_JPRB,.294E-03_JPRB,.294E-03_JPRB,.350E-03_JPRB,.350E-03_JPRB,.352E-03_JPRB,&
&.352E-03_JPRB,.333E-03_JPRB,.333E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.322E-03_JPRB,.322E-03_JPRB,&
&.314E-03_JPRB,.314E-03_JPRB,.280E-03_JPRB,.280E-03_JPRB,.246E-03_JPRB,.246E-03_JPRB,.274E-03_JPRB,&
&.274E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,&
&.437E-03_JPRB,.437E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  5  74.0
ZAER (:, 5, 4) = (/&
&.560E-03_JPRB,.560E-03_JPRB,.990E-03_JPRB,.990E-03_JPRB,.105E-02_JPRB,.105E-02_JPRB,.863E-03_JPRB,&
&.863E-03_JPRB,.678E-03_JPRB,.678E-03_JPRB,.542E-03_JPRB,.542E-03_JPRB,.473E-03_JPRB,.473E-03_JPRB,&
&.560E-03_JPRB,.560E-03_JPRB,.715E-03_JPRB,.715E-03_JPRB,.802E-03_JPRB,.802E-03_JPRB,.864E-03_JPRB,&
&.864E-03_JPRB,.887E-03_JPRB,.887E-03_JPRB,.864E-03_JPRB,.864E-03_JPRB,.783E-03_JPRB,.783E-03_JPRB,&
&.666E-03_JPRB,.666E-03_JPRB,.599E-03_JPRB,.599E-03_JPRB,.522E-03_JPRB,.522E-03_JPRB,.411E-03_JPRB,&
&.411E-03_JPRB,.293E-03_JPRB,.293E-03_JPRB,.174E-03_JPRB,.174E-03_JPRB,.167E-03_JPRB,.167E-03_JPRB,&
&.224E-03_JPRB,.224E-03_JPRB,.294E-03_JPRB,.294E-03_JPRB,.350E-03_JPRB,.350E-03_JPRB,.352E-03_JPRB,&
&.352E-03_JPRB,.333E-03_JPRB,.333E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.322E-03_JPRB,.322E-03_JPRB,&
&.314E-03_JPRB,.314E-03_JPRB,.280E-03_JPRB,.280E-03_JPRB,.246E-03_JPRB,.246E-03_JPRB,.274E-03_JPRB,&
&.274E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,&
&.437E-03_JPRB,.437E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  6  70.0
ZAER (:, 6, 4) = (/&
&.270E-02_JPRB,.270E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.376E-02_JPRB,.376E-02_JPRB,.227E-02_JPRB,&
&.227E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,&
&.187E-02_JPRB,.187E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.246E-02_JPRB,&
&.246E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.201E-02_JPRB,.201E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,&
&.111E-02_JPRB,.111E-02_JPRB,.839E-03_JPRB,.839E-03_JPRB,.662E-03_JPRB,.662E-03_JPRB,.527E-03_JPRB,&
&.527E-03_JPRB,.412E-03_JPRB,.412E-03_JPRB,.306E-03_JPRB,.306E-03_JPRB,.294E-03_JPRB,.294E-03_JPRB,&
&.405E-03_JPRB,.405E-03_JPRB,.672E-03_JPRB,.672E-03_JPRB,.811E-03_JPRB,.811E-03_JPRB,.867E-03_JPRB,&
&.867E-03_JPRB,.975E-03_JPRB,.975E-03_JPRB,.969E-03_JPRB,.969E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.114E-02_JPRB,.114E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.175E-02_JPRB,.175E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  7  66.0
ZAER (:, 7, 4) = (/&
&.270E-02_JPRB,.270E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.376E-02_JPRB,.376E-02_JPRB,.227E-02_JPRB,&
&.227E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,&
&.187E-02_JPRB,.187E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.246E-02_JPRB,&
&.246E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.201E-02_JPRB,.201E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,&
&.111E-02_JPRB,.111E-02_JPRB,.839E-03_JPRB,.839E-03_JPRB,.662E-03_JPRB,.662E-03_JPRB,.527E-03_JPRB,&
&.527E-03_JPRB,.412E-03_JPRB,.412E-03_JPRB,.306E-03_JPRB,.306E-03_JPRB,.294E-03_JPRB,.294E-03_JPRB,&
&.405E-03_JPRB,.405E-03_JPRB,.672E-03_JPRB,.672E-03_JPRB,.811E-03_JPRB,.811E-03_JPRB,.867E-03_JPRB,&
&.867E-03_JPRB,.975E-03_JPRB,.975E-03_JPRB,.969E-03_JPRB,.969E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.114E-02_JPRB,.114E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.175E-02_JPRB,.175E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  8  62.0
ZAER (:, 8, 4) = (/&
&.871E-02_JPRB,.871E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.586E-02_JPRB,&
&.586E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,&
&.982E-02_JPRB,.982E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.994E-02_JPRB,&
&.994E-02_JPRB,.802E-02_JPRB,.802E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,.364E-02_JPRB,.364E-02_JPRB,&
&.238E-02_JPRB,.238E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.397E-02_JPRB,&
&.397E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.330E-02_JPRB,.330E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,&
&.707E-02_JPRB,.707E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.781E-02_JPRB,&
&.781E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,&
&.841E-02_JPRB,.841E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  9  58.0
ZAER (:, 9, 4) = (/&
&.871E-02_JPRB,.871E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.586E-02_JPRB,&
&.586E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,&
&.982E-02_JPRB,.982E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.994E-02_JPRB,&
&.994E-02_JPRB,.802E-02_JPRB,.802E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,.364E-02_JPRB,.364E-02_JPRB,&
&.238E-02_JPRB,.238E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.397E-02_JPRB,&
&.397E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.330E-02_JPRB,.330E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,&
&.707E-02_JPRB,.707E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.781E-02_JPRB,&
&.781E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,&
&.841E-02_JPRB,.841E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 10  54.0
ZAER (:,10, 4) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.845E-02_JPRB,.845E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,&
&.864E-02_JPRB,.864E-02_JPRB,.966E-02_JPRB,.966E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.821E-02_JPRB,.821E-02_JPRB,.937E-02_JPRB,.937E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.885E-02_JPRB,.885E-02_JPRB,.714E-02_JPRB,&
&.714E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.590E-02_JPRB,.590E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,&
&.770E-02_JPRB,.770E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.962E-02_JPRB,.962E-02_JPRB,.952E-02_JPRB,&
&.952E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,&
&.836E-02_JPRB,.836E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 11  50.0
ZAER (:,11, 4) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.845E-02_JPRB,.845E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,&
&.864E-02_JPRB,.864E-02_JPRB,.966E-02_JPRB,.966E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.821E-02_JPRB,.821E-02_JPRB,.937E-02_JPRB,.937E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.885E-02_JPRB,.885E-02_JPRB,.714E-02_JPRB,&
&.714E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.590E-02_JPRB,.590E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,&
&.770E-02_JPRB,.770E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.962E-02_JPRB,.962E-02_JPRB,.952E-02_JPRB,&
&.952E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,&
&.836E-02_JPRB,.836E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 12  46.0
ZAER (:,12, 4) = (/&
&.995E-02_JPRB,.995E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.912E-02_JPRB,&
&.912E-02_JPRB,.857E-02_JPRB,.857E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,&
&.807E-02_JPRB,.807E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.801E-02_JPRB,&
&.801E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.136E-01_JPRB,.136E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.989E-02_JPRB,.989E-02_JPRB,.915E-02_JPRB,.915E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,&
&.921E-02_JPRB,.921E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.861E-02_JPRB,&
&.861E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,&
&.857E-02_JPRB,.857E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.930E-02_JPRB,&
&.930E-02_JPRB,.825E-02_JPRB,.825E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.788E-02_JPRB,.788E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 13  42.0
ZAER (:,13, 4) = (/&
&.995E-02_JPRB,.995E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.912E-02_JPRB,&
&.912E-02_JPRB,.857E-02_JPRB,.857E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,&
&.807E-02_JPRB,.807E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.801E-02_JPRB,&
&.801E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.136E-01_JPRB,.136E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.989E-02_JPRB,.989E-02_JPRB,.915E-02_JPRB,.915E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,&
&.921E-02_JPRB,.921E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.861E-02_JPRB,&
&.861E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,&
&.857E-02_JPRB,.857E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.930E-02_JPRB,&
&.930E-02_JPRB,.825E-02_JPRB,.825E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.788E-02_JPRB,.788E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 14  38.0
ZAER (:,14, 4) = (/&
&.829E-02_JPRB,.829E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.833E-02_JPRB,&
&.833E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,&
&.833E-02_JPRB,.833E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,.892E-02_JPRB,.892E-02_JPRB,.706E-02_JPRB,&
&.706E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,&
&.982E-02_JPRB,.982E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,.946E-02_JPRB,.946E-02_JPRB,.988E-02_JPRB,&
&.988E-02_JPRB,.951E-02_JPRB,.951E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.712E-02_JPRB,.712E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB,.823E-02_JPRB,.823E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.751E-02_JPRB,&
&.751E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,&
&.867E-02_JPRB,.867E-02_JPRB,.817E-02_JPRB,.817E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.652E-02_JPRB,&
&.652E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,&
&.737E-02_JPRB,.737E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 15  34.0
ZAER (:,15, 4) = (/&
&.829E-02_JPRB,.829E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.833E-02_JPRB,&
&.833E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,&
&.833E-02_JPRB,.833E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,.892E-02_JPRB,.892E-02_JPRB,.706E-02_JPRB,&
&.706E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,&
&.982E-02_JPRB,.982E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,.946E-02_JPRB,.946E-02_JPRB,.988E-02_JPRB,&
&.988E-02_JPRB,.951E-02_JPRB,.951E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.712E-02_JPRB,.712E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB,.823E-02_JPRB,.823E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.751E-02_JPRB,&
&.751E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,&
&.867E-02_JPRB,.867E-02_JPRB,.817E-02_JPRB,.817E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.652E-02_JPRB,&
&.652E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,&
&.737E-02_JPRB,.737E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 16  30.0
ZAER (:,16, 4) = (/&
&.816E-02_JPRB,.816E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.751E-02_JPRB,&
&.751E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.945E-02_JPRB,.945E-02_JPRB,&
&.993E-02_JPRB,.993E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.995E-02_JPRB,.995E-02_JPRB,.857E-02_JPRB,&
&.857E-02_JPRB,.527E-02_JPRB,.527E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,.555E-02_JPRB,.555E-02_JPRB,&
&.802E-02_JPRB,.802E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.905E-02_JPRB,&
&.905E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.389E-02_JPRB,.389E-02_JPRB,&
&.650E-02_JPRB,.650E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,.938E-02_JPRB,&
&.938E-02_JPRB,.913E-02_JPRB,.913E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.921E-02_JPRB,.921E-02_JPRB,.558E-02_JPRB,.558E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.395E-02_JPRB,.395E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,&
&.850E-02_JPRB,.850E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 17  26.0
ZAER (:,17, 4) = (/&
&.816E-02_JPRB,.816E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.751E-02_JPRB,&
&.751E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.945E-02_JPRB,.945E-02_JPRB,&
&.993E-02_JPRB,.993E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.995E-02_JPRB,.995E-02_JPRB,.857E-02_JPRB,&
&.857E-02_JPRB,.527E-02_JPRB,.527E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,.555E-02_JPRB,.555E-02_JPRB,&
&.802E-02_JPRB,.802E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.905E-02_JPRB,&
&.905E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.389E-02_JPRB,.389E-02_JPRB,&
&.650E-02_JPRB,.650E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,.938E-02_JPRB,&
&.938E-02_JPRB,.913E-02_JPRB,.913E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.921E-02_JPRB,.921E-02_JPRB,.558E-02_JPRB,.558E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.395E-02_JPRB,.395E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,&
&.850E-02_JPRB,.850E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 18  22.0
ZAER (:,18, 4) = (/&
&.887E-02_JPRB,.887E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,.862E-02_JPRB,&
&.862E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.901E-02_JPRB,&
&.901E-02_JPRB,.487E-02_JPRB,.487E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,&
&.715E-02_JPRB,.715E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.900E-02_JPRB,&
&.900E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.521E-02_JPRB,.521E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,&
&.429E-02_JPRB,.429E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.716E-02_JPRB,.716E-02_JPRB,.579E-02_JPRB,&
&.579E-02_JPRB,.561E-02_JPRB,.561E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,&
&.889E-02_JPRB,.889E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 19  18.0
ZAER (:,19, 4) = (/&
&.887E-02_JPRB,.887E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,.862E-02_JPRB,&
&.862E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.901E-02_JPRB,&
&.901E-02_JPRB,.487E-02_JPRB,.487E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,&
&.715E-02_JPRB,.715E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.900E-02_JPRB,&
&.900E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.521E-02_JPRB,.521E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,&
&.429E-02_JPRB,.429E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.716E-02_JPRB,.716E-02_JPRB,.579E-02_JPRB,&
&.579E-02_JPRB,.561E-02_JPRB,.561E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,&
&.889E-02_JPRB,.889E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 20  14.0
ZAER (:,20, 4) = (/&
&.925E-02_JPRB,.925E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.817E-02_JPRB,.817E-02_JPRB,.427E-02_JPRB,&
&.427E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.302E-02_JPRB,.302E-02_JPRB,&
&.756E-02_JPRB,.756E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.664E-02_JPRB,.664E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,&
&.284E-02_JPRB,.284E-02_JPRB,.639E-02_JPRB,.639E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.972E-02_JPRB,.972E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.727E-02_JPRB,.727E-02_JPRB,.542E-02_JPRB,&
&.542E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,&
&.859E-02_JPRB,.859E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 21  10.0
ZAER (:,21, 4) = (/&
&.925E-02_JPRB,.925E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.817E-02_JPRB,.817E-02_JPRB,.427E-02_JPRB,&
&.427E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.302E-02_JPRB,.302E-02_JPRB,&
&.756E-02_JPRB,.756E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.664E-02_JPRB,.664E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,&
&.284E-02_JPRB,.284E-02_JPRB,.639E-02_JPRB,.639E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.972E-02_JPRB,.972E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.727E-02_JPRB,.727E-02_JPRB,.542E-02_JPRB,&
&.542E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,&
&.859E-02_JPRB,.859E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 22   6.0
ZAER (:,22, 4) = (/&
&.111E-01_JPRB,.111E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.741E-02_JPRB,.741E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.969E-03_JPRB,&
&.969E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.627E-02_JPRB,.627E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.760E-02_JPRB,&
&.760E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,&
&.537E-02_JPRB,.537E-02_JPRB,.937E-02_JPRB,.937E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.935E-02_JPRB,&
&.935E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,.521E-02_JPRB,.521E-02_JPRB,&
&.436E-02_JPRB,.436E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.397E-02_JPRB,&
&.397E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 23   2.0
ZAER (:,23, 4) = (/&
&.111E-01_JPRB,.111E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.741E-02_JPRB,.741E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.969E-03_JPRB,&
&.969E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.627E-02_JPRB,.627E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.760E-02_JPRB,&
&.760E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,&
&.537E-02_JPRB,.537E-02_JPRB,.937E-02_JPRB,.937E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.935E-02_JPRB,&
&.935E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,.521E-02_JPRB,.521E-02_JPRB,&
&.436E-02_JPRB,.436E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.397E-02_JPRB,&
&.397E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 24  -2.0
ZAER (:,24, 4) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.876E-02_JPRB,.876E-02_JPRB,.696E-02_JPRB,.696E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,&
&.998E-02_JPRB,.998E-02_JPRB,.818E-02_JPRB,.818E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.327E-02_JPRB,&
&.327E-02_JPRB,.233E-02_JPRB,.233E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.231E-02_JPRB,.231E-02_JPRB,&
&.420E-02_JPRB,.420E-02_JPRB,.634E-02_JPRB,.634E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.772E-02_JPRB,&
&.772E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,&
&.478E-02_JPRB,.478E-02_JPRB,.572E-02_JPRB,.572E-02_JPRB,.704E-02_JPRB,.704E-02_JPRB,.773E-02_JPRB,&
&.773E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.942E-02_JPRB,.942E-02_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 25  -6.0
ZAER (:,25, 4) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.876E-02_JPRB,.876E-02_JPRB,.696E-02_JPRB,.696E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,&
&.998E-02_JPRB,.998E-02_JPRB,.818E-02_JPRB,.818E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.327E-02_JPRB,&
&.327E-02_JPRB,.233E-02_JPRB,.233E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.231E-02_JPRB,.231E-02_JPRB,&
&.420E-02_JPRB,.420E-02_JPRB,.634E-02_JPRB,.634E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.772E-02_JPRB,&
&.772E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,&
&.478E-02_JPRB,.478E-02_JPRB,.572E-02_JPRB,.572E-02_JPRB,.704E-02_JPRB,.704E-02_JPRB,.773E-02_JPRB,&
&.773E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.942E-02_JPRB,.942E-02_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 26 -10.0
ZAER (:,26, 4) = (/&
&.132E-01_JPRB,.132E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.145E-01_JPRB,&
&.145E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.835E-02_JPRB,.835E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.853E-02_JPRB,&
&.853E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,.970E-02_JPRB,.970E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.943E-02_JPRB,.943E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.253E-02_JPRB,&
&.253E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.579E-02_JPRB,&
&.579E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.644E-02_JPRB,.644E-02_JPRB,.648E-02_JPRB,.648E-02_JPRB,&
&.572E-02_JPRB,.572E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 27 -14.0
ZAER (:,27, 4) = (/&
&.132E-01_JPRB,.132E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.145E-01_JPRB,&
&.145E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.835E-02_JPRB,.835E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.853E-02_JPRB,&
&.853E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,.970E-02_JPRB,.970E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.943E-02_JPRB,.943E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.253E-02_JPRB,&
&.253E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.579E-02_JPRB,&
&.579E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.644E-02_JPRB,.644E-02_JPRB,.648E-02_JPRB,.648E-02_JPRB,&
&.572E-02_JPRB,.572E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 28 -18.0
ZAER (:,28, 4) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.988E-02_JPRB,.988E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,&
&.940E-02_JPRB,.940E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.909E-02_JPRB,&
&.909E-02_JPRB,.999E-02_JPRB,.999E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.966E-02_JPRB,.966E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,.274E-02_JPRB,&
&.274E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.222E-02_JPRB,.222E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.192E-02_JPRB,.192E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,.432E-02_JPRB,&
&.432E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,.352E-02_JPRB,.352E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,&
&.373E-02_JPRB,.373E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.117E-01_JPRB,&
&.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 29 -22.0
ZAER (:,29, 4) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.988E-02_JPRB,.988E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,&
&.940E-02_JPRB,.940E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.909E-02_JPRB,&
&.909E-02_JPRB,.999E-02_JPRB,.999E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.966E-02_JPRB,.966E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,.274E-02_JPRB,&
&.274E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.222E-02_JPRB,.222E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.192E-02_JPRB,.192E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,.432E-02_JPRB,&
&.432E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,.352E-02_JPRB,.352E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,&
&.373E-02_JPRB,.373E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.117E-01_JPRB,&
&.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 30 -26.0
ZAER (:,30, 4) = (/&
&.783E-02_JPRB,.783E-02_JPRB,.779E-02_JPRB,.779E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.801E-02_JPRB,&
&.801E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.640E-02_JPRB,.640E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,&
&.411E-02_JPRB,.411E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.754E-02_JPRB,&
&.754E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.847E-02_JPRB,.847E-02_JPRB,.942E-02_JPRB,.942E-02_JPRB,&
&.953E-02_JPRB,.953E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.345E-02_JPRB,&
&.345E-02_JPRB,.262E-02_JPRB,.262E-02_JPRB,.250E-02_JPRB,.250E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,&
&.222E-02_JPRB,.222E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.173E-02_JPRB,&
&.173E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,&
&.154E-02_JPRB,.154E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.721E-02_JPRB,&
&.721E-02_JPRB,.806E-02_JPRB,.806E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 31 -30.0
ZAER (:,31, 4) = (/&
&.783E-02_JPRB,.783E-02_JPRB,.779E-02_JPRB,.779E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.801E-02_JPRB,&
&.801E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.640E-02_JPRB,.640E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,&
&.411E-02_JPRB,.411E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.754E-02_JPRB,&
&.754E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.847E-02_JPRB,.847E-02_JPRB,.942E-02_JPRB,.942E-02_JPRB,&
&.953E-02_JPRB,.953E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.345E-02_JPRB,&
&.345E-02_JPRB,.262E-02_JPRB,.262E-02_JPRB,.250E-02_JPRB,.250E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,&
&.222E-02_JPRB,.222E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.173E-02_JPRB,&
&.173E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,&
&.154E-02_JPRB,.154E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.721E-02_JPRB,&
&.721E-02_JPRB,.806E-02_JPRB,.806E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 32 -34.0
ZAER (:,32, 4) = (/&
&.774E-02_JPRB,.774E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.789E-02_JPRB,&
&.789E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.576E-02_JPRB,.576E-02_JPRB,.231E-02_JPRB,.231E-02_JPRB,&
&.111E-02_JPRB,.111E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.195E-02_JPRB,.195E-02_JPRB,.297E-02_JPRB,&
&.297E-02_JPRB,.611E-02_JPRB,.611E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,&
&.870E-02_JPRB,.870E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.500E-02_JPRB,&
&.500E-02_JPRB,.327E-02_JPRB,.327E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,&
&.295E-02_JPRB,.295E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.106E-02_JPRB,&
&.106E-02_JPRB,.887E-03_JPRB,.887E-03_JPRB,.984E-03_JPRB,.984E-03_JPRB,.965E-03_JPRB,.965E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB,.674E-03_JPRB,.674E-03_JPRB,.206E-02_JPRB,.206E-02_JPRB,.349E-02_JPRB,&
&.349E-02_JPRB,.560E-02_JPRB,.560E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.866E-02_JPRB,.866E-02_JPRB,&
&.825E-02_JPRB,.825E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 33 -38.0
ZAER (:,33, 4) = (/&
&.774E-02_JPRB,.774E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.789E-02_JPRB,&
&.789E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.576E-02_JPRB,.576E-02_JPRB,.231E-02_JPRB,.231E-02_JPRB,&
&.111E-02_JPRB,.111E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.195E-02_JPRB,.195E-02_JPRB,.297E-02_JPRB,&
&.297E-02_JPRB,.611E-02_JPRB,.611E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,&
&.870E-02_JPRB,.870E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.500E-02_JPRB,&
&.500E-02_JPRB,.327E-02_JPRB,.327E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,&
&.295E-02_JPRB,.295E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.106E-02_JPRB,&
&.106E-02_JPRB,.887E-03_JPRB,.887E-03_JPRB,.984E-03_JPRB,.984E-03_JPRB,.965E-03_JPRB,.965E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB,.674E-03_JPRB,.674E-03_JPRB,.206E-02_JPRB,.206E-02_JPRB,.349E-02_JPRB,&
&.349E-02_JPRB,.560E-02_JPRB,.560E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.866E-02_JPRB,.866E-02_JPRB,&
&.825E-02_JPRB,.825E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 34 -42.0
ZAER (:,34, 4) = (/&
&.716E-02_JPRB,.716E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,.864E-02_JPRB,&
&.864E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,&
&.738E-03_JPRB,.738E-03_JPRB,.451E-03_JPRB,.451E-03_JPRB,.598E-03_JPRB,.598E-03_JPRB,.588E-03_JPRB,&
&.588E-03_JPRB,.219E-02_JPRB,.219E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,&
&.934E-02_JPRB,.934E-02_JPRB,.865E-02_JPRB,.865E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.615E-02_JPRB,&
&.615E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,&
&.243E-02_JPRB,.243E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.924E-03_JPRB,&
&.924E-03_JPRB,.679E-03_JPRB,.679E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,&
&.518E-03_JPRB,.518E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.175E-02_JPRB,&
&.175E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,&
&.693E-02_JPRB,.693E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 35 -46.0
ZAER (:,35, 4) = (/&
&.716E-02_JPRB,.716E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,.864E-02_JPRB,&
&.864E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,&
&.738E-03_JPRB,.738E-03_JPRB,.451E-03_JPRB,.451E-03_JPRB,.598E-03_JPRB,.598E-03_JPRB,.588E-03_JPRB,&
&.588E-03_JPRB,.219E-02_JPRB,.219E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,&
&.934E-02_JPRB,.934E-02_JPRB,.865E-02_JPRB,.865E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.615E-02_JPRB,&
&.615E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,&
&.243E-02_JPRB,.243E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.924E-03_JPRB,&
&.924E-03_JPRB,.679E-03_JPRB,.679E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,&
&.518E-03_JPRB,.518E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.175E-02_JPRB,&
&.175E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,&
&.693E-02_JPRB,.693E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 36 -50.0
ZAER (:,36, 4) = (/&
&.646E-02_JPRB,.646E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.692E-02_JPRB,&
&.692E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,&
&.570E-03_JPRB,.570E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.816E-03_JPRB,.816E-03_JPRB,.727E-03_JPRB,&
&.727E-03_JPRB,.895E-03_JPRB,.895E-03_JPRB,.336E-02_JPRB,.336E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,&
&.958E-02_JPRB,.958E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.999E-02_JPRB,.999E-02_JPRB,.724E-02_JPRB,&
&.724E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,&
&.989E-03_JPRB,.989E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.988E-03_JPRB,.988E-03_JPRB,.856E-03_JPRB,&
&.856E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,.496E-03_JPRB,.496E-03_JPRB,&
&.418E-03_JPRB,.418E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.349E-03_JPRB,.349E-03_JPRB,.603E-03_JPRB,&
&.603E-03_JPRB,.236E-02_JPRB,.236E-02_JPRB,.457E-02_JPRB,.457E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,&
&.570E-02_JPRB,.570E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 37 -54.0
ZAER (:,37, 4) = (/&
&.646E-02_JPRB,.646E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.692E-02_JPRB,&
&.692E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,&
&.570E-03_JPRB,.570E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.816E-03_JPRB,.816E-03_JPRB,.727E-03_JPRB,&
&.727E-03_JPRB,.895E-03_JPRB,.895E-03_JPRB,.336E-02_JPRB,.336E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,&
&.958E-02_JPRB,.958E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.999E-02_JPRB,.999E-02_JPRB,.724E-02_JPRB,&
&.724E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,&
&.989E-03_JPRB,.989E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.988E-03_JPRB,.988E-03_JPRB,.856E-03_JPRB,&
&.856E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,.496E-03_JPRB,.496E-03_JPRB,&
&.418E-03_JPRB,.418E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.349E-03_JPRB,.349E-03_JPRB,.603E-03_JPRB,&
&.603E-03_JPRB,.236E-02_JPRB,.236E-02_JPRB,.457E-02_JPRB,.457E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,&
&.570E-02_JPRB,.570E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 38 -58.0
ZAER (:,38, 4) = (/&
&.432E-02_JPRB,.432E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.299E-02_JPRB,&
&.299E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.812E-03_JPRB,.812E-03_JPRB,&
&.570E-03_JPRB,.570E-03_JPRB,.808E-03_JPRB,.808E-03_JPRB,.287E-02_JPRB,.287E-02_JPRB,.157E-02_JPRB,&
&.157E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,&
&.920E-02_JPRB,.920E-02_JPRB,.123E-01_JPRB,.123E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.990E-02_JPRB,&
&.990E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.934E-03_JPRB,&
&.934E-03_JPRB,.784E-03_JPRB,.784E-03_JPRB,.619E-03_JPRB,.619E-03_JPRB,.487E-03_JPRB,.487E-03_JPRB,&
&.409E-03_JPRB,.409E-03_JPRB,.336E-03_JPRB,.336E-03_JPRB,.315E-03_JPRB,.315E-03_JPRB,.534E-03_JPRB,&
&.534E-03_JPRB,.150E-02_JPRB,.150E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.338E-02_JPRB,.338E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 39 -62.0
ZAER (:,39, 4) = (/&
&.432E-02_JPRB,.432E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.299E-02_JPRB,&
&.299E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.812E-03_JPRB,.812E-03_JPRB,&
&.570E-03_JPRB,.570E-03_JPRB,.808E-03_JPRB,.808E-03_JPRB,.287E-02_JPRB,.287E-02_JPRB,.157E-02_JPRB,&
&.157E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,&
&.920E-02_JPRB,.920E-02_JPRB,.123E-01_JPRB,.123E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.990E-02_JPRB,&
&.990E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.934E-03_JPRB,&
&.934E-03_JPRB,.784E-03_JPRB,.784E-03_JPRB,.619E-03_JPRB,.619E-03_JPRB,.487E-03_JPRB,.487E-03_JPRB,&
&.409E-03_JPRB,.409E-03_JPRB,.336E-03_JPRB,.336E-03_JPRB,.315E-03_JPRB,.315E-03_JPRB,.534E-03_JPRB,&
&.534E-03_JPRB,.150E-02_JPRB,.150E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.338E-02_JPRB,.338E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 40 -66.0
ZAER (:,40, 4) = (/&
&.169E-02_JPRB,.169E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.803E-03_JPRB,.803E-03_JPRB,.108E-02_JPRB,&
&.108E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.885E-03_JPRB,.885E-03_JPRB,&
&.645E-03_JPRB,.645E-03_JPRB,.895E-03_JPRB,.895E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.832E-03_JPRB,&
&.832E-03_JPRB,.142E-02_JPRB,.142E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,&
&.321E-02_JPRB,.321E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.974E-02_JPRB,&
&.974E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.667E-02_JPRB,.667E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,&
&.279E-02_JPRB,.279E-02_JPRB,.298E-02_JPRB,.298E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.147E-02_JPRB,&
&.147E-02_JPRB,.934E-03_JPRB,.934E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.424E-03_JPRB,.424E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,.394E-03_JPRB,&
&.394E-03_JPRB,.457E-03_JPRB,.457E-03_JPRB,.574E-03_JPRB,.574E-03_JPRB,.904E-03_JPRB,.904E-03_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 41 -70.0
ZAER (:,41, 4) = (/&
&.169E-02_JPRB,.169E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.803E-03_JPRB,.803E-03_JPRB,.108E-02_JPRB,&
&.108E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.885E-03_JPRB,.885E-03_JPRB,&
&.645E-03_JPRB,.645E-03_JPRB,.895E-03_JPRB,.895E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.832E-03_JPRB,&
&.832E-03_JPRB,.142E-02_JPRB,.142E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,&
&.321E-02_JPRB,.321E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.974E-02_JPRB,&
&.974E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.667E-02_JPRB,.667E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,&
&.279E-02_JPRB,.279E-02_JPRB,.298E-02_JPRB,.298E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.147E-02_JPRB,&
&.147E-02_JPRB,.934E-03_JPRB,.934E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.424E-03_JPRB,.424E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,.394E-03_JPRB,&
&.394E-03_JPRB,.457E-03_JPRB,.457E-03_JPRB,.574E-03_JPRB,.574E-03_JPRB,.904E-03_JPRB,.904E-03_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 42 -74.0
ZAER (:,42, 4) = (/&
&.157E-02_JPRB,.157E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.608E-03_JPRB,.608E-03_JPRB,.672E-03_JPRB,&
&.672E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.629E-03_JPRB,.629E-03_JPRB,&
&.565E-03_JPRB,.565E-03_JPRB,.589E-03_JPRB,.589E-03_JPRB,.565E-03_JPRB,.565E-03_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.140E-02_JPRB,.140E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.617E-02_JPRB,.617E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,&
&.521E-02_JPRB,.521E-02_JPRB,.419E-02_JPRB,.419E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,.176E-02_JPRB,&
&.176E-02_JPRB,.262E-02_JPRB,.262E-02_JPRB,.195E-02_JPRB,.195E-02_JPRB,.485E-03_JPRB,.485E-03_JPRB,&
&.481E-03_JPRB,.481E-03_JPRB,.726E-03_JPRB,.726E-03_JPRB,.212E-02_JPRB,.212E-02_JPRB,.191E-02_JPRB,&
&.191E-02_JPRB,.556E-03_JPRB,.556E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.650E-03_JPRB,.650E-03_JPRB,&
&.127E-02_JPRB,.127E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 43 -78.0
ZAER (:,43, 4) = (/&
&.157E-02_JPRB,.157E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.608E-03_JPRB,.608E-03_JPRB,.672E-03_JPRB,&
&.672E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.629E-03_JPRB,.629E-03_JPRB,&
&.565E-03_JPRB,.565E-03_JPRB,.589E-03_JPRB,.589E-03_JPRB,.565E-03_JPRB,.565E-03_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.140E-02_JPRB,.140E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.617E-02_JPRB,.617E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,&
&.521E-02_JPRB,.521E-02_JPRB,.419E-02_JPRB,.419E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,.176E-02_JPRB,&
&.176E-02_JPRB,.262E-02_JPRB,.262E-02_JPRB,.195E-02_JPRB,.195E-02_JPRB,.485E-03_JPRB,.485E-03_JPRB,&
&.481E-03_JPRB,.481E-03_JPRB,.726E-03_JPRB,.726E-03_JPRB,.212E-02_JPRB,.212E-02_JPRB,.191E-02_JPRB,&
&.191E-02_JPRB,.556E-03_JPRB,.556E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.650E-03_JPRB,.650E-03_JPRB,&
&.127E-02_JPRB,.127E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 44 -82.0
ZAER (:,44, 4) = (/&
&.476E-03_JPRB,.476E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,.448E-03_JPRB,.448E-03_JPRB,.470E-03_JPRB,&
&.470E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.490E-03_JPRB,.490E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,.632E-03_JPRB,.632E-03_JPRB,.775E-03_JPRB,&
&.775E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.968E-03_JPRB,.968E-03_JPRB,.108E-02_JPRB,.108E-02_JPRB,&
&.117E-02_JPRB,.117E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,.212E-02_JPRB,&
&.212E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,&
&.824E-03_JPRB,.824E-03_JPRB,.717E-03_JPRB,.717E-03_JPRB,.655E-03_JPRB,.655E-03_JPRB,.659E-03_JPRB,&
&.659E-03_JPRB,.691E-03_JPRB,.691E-03_JPRB,.634E-03_JPRB,.634E-03_JPRB,.638E-03_JPRB,.638E-03_JPRB,&
&.710E-03_JPRB,.710E-03_JPRB,.893E-03_JPRB,.893E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,.940E-03_JPRB,&
&.940E-03_JPRB,.489E-03_JPRB,.489E-03_JPRB,.448E-03_JPRB,.448E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,&
&.476E-03_JPRB,.476E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 45 -86.0
ZAER (:,45, 4) = (/&
&.476E-03_JPRB,.476E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,.448E-03_JPRB,.448E-03_JPRB,.470E-03_JPRB,&
&.470E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.490E-03_JPRB,.490E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,.632E-03_JPRB,.632E-03_JPRB,.775E-03_JPRB,&
&.775E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.968E-03_JPRB,.968E-03_JPRB,.108E-02_JPRB,.108E-02_JPRB,&
&.117E-02_JPRB,.117E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,.212E-02_JPRB,&
&.212E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,&
&.824E-03_JPRB,.824E-03_JPRB,.717E-03_JPRB,.717E-03_JPRB,.655E-03_JPRB,.655E-03_JPRB,.659E-03_JPRB,&
&.659E-03_JPRB,.691E-03_JPRB,.691E-03_JPRB,.634E-03_JPRB,.634E-03_JPRB,.638E-03_JPRB,.638E-03_JPRB,&
&.710E-03_JPRB,.710E-03_JPRB,.893E-03_JPRB,.893E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,.940E-03_JPRB,&
&.940E-03_JPRB,.489E-03_JPRB,.489E-03_JPRB,.448E-03_JPRB,.448E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,&
&.476E-03_JPRB,.476E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 46 -90.0
ZAER (:,46, 4) = (/&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB/)

!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=4    
  DO JI=1,46
    DO JL=1,72
      RAERSS(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SEA-SALT AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESS_04
