SUBROUTINE SUECAESS_02

!**   OPTICAL THICKNESS OF AEROSOLS OF SEA-SALT ORIGIN
!                                      February

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESS* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSS


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,2:2)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Sea Salt Aerosol         month:  2 --- lat:  1  90.0
ZAER (:, 1, 2) = (/&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  2  86.0
ZAER (:, 2, 2) = (/&
&.337E-03_JPRB,.337E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.343E-03_JPRB,.343E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.296E-03_JPRB,.296E-03_JPRB,.281E-03_JPRB,.281E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,&
&.329E-03_JPRB,.329E-03_JPRB,.379E-03_JPRB,.379E-03_JPRB,.446E-03_JPRB,.446E-03_JPRB,.454E-03_JPRB,&
&.454E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.305E-03_JPRB,.305E-03_JPRB,.272E-03_JPRB,.272E-03_JPRB,&
&.216E-03_JPRB,.216E-03_JPRB,.156E-03_JPRB,.156E-03_JPRB,.112E-03_JPRB,.112E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.116E-03_JPRB,.116E-03_JPRB,.144E-03_JPRB,.144E-03_JPRB,.156E-03_JPRB,.156E-03_JPRB,&
&.155E-03_JPRB,.155E-03_JPRB,.161E-03_JPRB,.161E-03_JPRB,.173E-03_JPRB,.173E-03_JPRB,.177E-03_JPRB,&
&.177E-03_JPRB,.165E-03_JPRB,.165E-03_JPRB,.142E-03_JPRB,.142E-03_JPRB,.121E-03_JPRB,.121E-03_JPRB,&
&.110E-03_JPRB,.110E-03_JPRB,.111E-03_JPRB,.111E-03_JPRB,.118E-03_JPRB,.118E-03_JPRB,.121E-03_JPRB,&
&.121E-03_JPRB,.123E-03_JPRB,.123E-03_JPRB,.139E-03_JPRB,.139E-03_JPRB,.189E-03_JPRB,.189E-03_JPRB,&
&.270E-03_JPRB,.270E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  3  82.0
ZAER (:, 3, 2) = (/&
&.337E-03_JPRB,.337E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.343E-03_JPRB,.343E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.296E-03_JPRB,.296E-03_JPRB,.281E-03_JPRB,.281E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,&
&.329E-03_JPRB,.329E-03_JPRB,.379E-03_JPRB,.379E-03_JPRB,.446E-03_JPRB,.446E-03_JPRB,.454E-03_JPRB,&
&.454E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.305E-03_JPRB,.305E-03_JPRB,.272E-03_JPRB,.272E-03_JPRB,&
&.216E-03_JPRB,.216E-03_JPRB,.156E-03_JPRB,.156E-03_JPRB,.112E-03_JPRB,.112E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.116E-03_JPRB,.116E-03_JPRB,.144E-03_JPRB,.144E-03_JPRB,.156E-03_JPRB,.156E-03_JPRB,&
&.155E-03_JPRB,.155E-03_JPRB,.161E-03_JPRB,.161E-03_JPRB,.173E-03_JPRB,.173E-03_JPRB,.177E-03_JPRB,&
&.177E-03_JPRB,.165E-03_JPRB,.165E-03_JPRB,.142E-03_JPRB,.142E-03_JPRB,.121E-03_JPRB,.121E-03_JPRB,&
&.110E-03_JPRB,.110E-03_JPRB,.111E-03_JPRB,.111E-03_JPRB,.118E-03_JPRB,.118E-03_JPRB,.121E-03_JPRB,&
&.121E-03_JPRB,.123E-03_JPRB,.123E-03_JPRB,.139E-03_JPRB,.139E-03_JPRB,.189E-03_JPRB,.189E-03_JPRB,&
&.270E-03_JPRB,.270E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  4  78.0
ZAER (:, 4, 2) = (/&
&.806E-03_JPRB,.806E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,.674E-03_JPRB,.674E-03_JPRB,.601E-03_JPRB,&
&.601E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,.347E-03_JPRB,.347E-03_JPRB,.387E-03_JPRB,.387E-03_JPRB,&
&.567E-03_JPRB,.567E-03_JPRB,.769E-03_JPRB,.769E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.713E-03_JPRB,.713E-03_JPRB,.559E-03_JPRB,.559E-03_JPRB,&
&.404E-03_JPRB,.404E-03_JPRB,.294E-03_JPRB,.294E-03_JPRB,.256E-03_JPRB,.256E-03_JPRB,.170E-03_JPRB,&
&.170E-03_JPRB,.117E-03_JPRB,.117E-03_JPRB,.188E-03_JPRB,.188E-03_JPRB,.295E-03_JPRB,.295E-03_JPRB,&
&.316E-03_JPRB,.316E-03_JPRB,.258E-03_JPRB,.258E-03_JPRB,.279E-03_JPRB,.279E-03_JPRB,.341E-03_JPRB,&
&.341E-03_JPRB,.327E-03_JPRB,.327E-03_JPRB,.247E-03_JPRB,.247E-03_JPRB,.198E-03_JPRB,.198E-03_JPRB,&
&.158E-03_JPRB,.158E-03_JPRB,.194E-03_JPRB,.194E-03_JPRB,.253E-03_JPRB,.253E-03_JPRB,.251E-03_JPRB,&
&.251E-03_JPRB,.247E-03_JPRB,.247E-03_JPRB,.271E-03_JPRB,.271E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,&
&.793E-03_JPRB,.793E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  5  74.0
ZAER (:, 5, 2) = (/&
&.806E-03_JPRB,.806E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,.674E-03_JPRB,.674E-03_JPRB,.601E-03_JPRB,&
&.601E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,.347E-03_JPRB,.347E-03_JPRB,.387E-03_JPRB,.387E-03_JPRB,&
&.567E-03_JPRB,.567E-03_JPRB,.769E-03_JPRB,.769E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.713E-03_JPRB,.713E-03_JPRB,.559E-03_JPRB,.559E-03_JPRB,&
&.404E-03_JPRB,.404E-03_JPRB,.294E-03_JPRB,.294E-03_JPRB,.256E-03_JPRB,.256E-03_JPRB,.170E-03_JPRB,&
&.170E-03_JPRB,.117E-03_JPRB,.117E-03_JPRB,.188E-03_JPRB,.188E-03_JPRB,.295E-03_JPRB,.295E-03_JPRB,&
&.316E-03_JPRB,.316E-03_JPRB,.258E-03_JPRB,.258E-03_JPRB,.279E-03_JPRB,.279E-03_JPRB,.341E-03_JPRB,&
&.341E-03_JPRB,.327E-03_JPRB,.327E-03_JPRB,.247E-03_JPRB,.247E-03_JPRB,.198E-03_JPRB,.198E-03_JPRB,&
&.158E-03_JPRB,.158E-03_JPRB,.194E-03_JPRB,.194E-03_JPRB,.253E-03_JPRB,.253E-03_JPRB,.251E-03_JPRB,&
&.251E-03_JPRB,.247E-03_JPRB,.247E-03_JPRB,.271E-03_JPRB,.271E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,&
&.793E-03_JPRB,.793E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  6  70.0
ZAER (:, 6, 2) = (/&
&.437E-02_JPRB,.437E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.210E-02_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.273E-02_JPRB,.273E-02_JPRB,&
&.378E-02_JPRB,.378E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.505E-02_JPRB,&
&.505E-02_JPRB,.421E-02_JPRB,.421E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,&
&.915E-03_JPRB,.915E-03_JPRB,.535E-03_JPRB,.535E-03_JPRB,.148E-02_JPRB,.148E-02_JPRB,.158E-02_JPRB,&
&.158E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,&
&.196E-02_JPRB,.196E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.160E-02_JPRB,&
&.160E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.942E-03_JPRB,.942E-03_JPRB,.768E-03_JPRB,.768E-03_JPRB,&
&.859E-03_JPRB,.859E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,&
&.441E-02_JPRB,.441E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  7  66.0
ZAER (:, 7, 2) = (/&
&.437E-02_JPRB,.437E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.210E-02_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.273E-02_JPRB,.273E-02_JPRB,&
&.378E-02_JPRB,.378E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.505E-02_JPRB,&
&.505E-02_JPRB,.421E-02_JPRB,.421E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,&
&.915E-03_JPRB,.915E-03_JPRB,.535E-03_JPRB,.535E-03_JPRB,.148E-02_JPRB,.148E-02_JPRB,.158E-02_JPRB,&
&.158E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,&
&.196E-02_JPRB,.196E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.160E-02_JPRB,&
&.160E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.942E-03_JPRB,.942E-03_JPRB,.768E-03_JPRB,.768E-03_JPRB,&
&.859E-03_JPRB,.859E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,&
&.441E-02_JPRB,.441E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  8  62.0
ZAER (:, 8, 2) = (/&
&.102E-01_JPRB,.102E-01_JPRB,.916E-02_JPRB,.916E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.665E-02_JPRB,&
&.665E-02_JPRB,.712E-02_JPRB,.712E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.966E-02_JPRB,.966E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.970E-02_JPRB,.970E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,&
&.441E-02_JPRB,.441E-02_JPRB,.369E-02_JPRB,.369E-02_JPRB,.427E-02_JPRB,.427E-02_JPRB,.452E-02_JPRB,&
&.452E-02_JPRB,.483E-02_JPRB,.483E-02_JPRB,.608E-02_JPRB,.608E-02_JPRB,.694E-02_JPRB,.694E-02_JPRB,&
&.736E-02_JPRB,.736E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.630E-02_JPRB,&
&.630E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,&
&.543E-02_JPRB,.543E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.863E-02_JPRB,&
&.863E-02_JPRB,.985E-02_JPRB,.985E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  9  58.0
ZAER (:, 9, 2) = (/&
&.102E-01_JPRB,.102E-01_JPRB,.916E-02_JPRB,.916E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.665E-02_JPRB,&
&.665E-02_JPRB,.712E-02_JPRB,.712E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.966E-02_JPRB,.966E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.970E-02_JPRB,.970E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,&
&.441E-02_JPRB,.441E-02_JPRB,.369E-02_JPRB,.369E-02_JPRB,.427E-02_JPRB,.427E-02_JPRB,.452E-02_JPRB,&
&.452E-02_JPRB,.483E-02_JPRB,.483E-02_JPRB,.608E-02_JPRB,.608E-02_JPRB,.694E-02_JPRB,.694E-02_JPRB,&
&.736E-02_JPRB,.736E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.630E-02_JPRB,&
&.630E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,&
&.543E-02_JPRB,.543E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.863E-02_JPRB,&
&.863E-02_JPRB,.985E-02_JPRB,.985E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 10  54.0
ZAER (:,10, 2) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.994E-02_JPRB,.994E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.985E-02_JPRB,.985E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,.822E-02_JPRB,&
&.822E-02_JPRB,.635E-02_JPRB,.635E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,&
&.781E-02_JPRB,.781E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.641E-02_JPRB,&
&.641E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,&
&.782E-02_JPRB,.782E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,&
&.889E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB,.891E-02_JPRB,.891E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.953E-02_JPRB,&
&.953E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 11  50.0
ZAER (:,11, 2) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.994E-02_JPRB,.994E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.985E-02_JPRB,.985E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,.822E-02_JPRB,&
&.822E-02_JPRB,.635E-02_JPRB,.635E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,&
&.781E-02_JPRB,.781E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.641E-02_JPRB,&
&.641E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,&
&.782E-02_JPRB,.782E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,&
&.889E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB,.891E-02_JPRB,.891E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.953E-02_JPRB,&
&.953E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 12  46.0
ZAER (:,12, 2) = (/&
&.694E-02_JPRB,.694E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.802E-02_JPRB,.802E-02_JPRB,.814E-02_JPRB,&
&.814E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,&
&.757E-02_JPRB,.757E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.644E-02_JPRB,.644E-02_JPRB,.511E-02_JPRB,&
&.511E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.629E-02_JPRB,.629E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,&
&.823E-02_JPRB,.823E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.752E-02_JPRB,.752E-02_JPRB,.744E-02_JPRB,&
&.744E-02_JPRB,.760E-02_JPRB,.760E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,&
&.725E-02_JPRB,.725E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.810E-02_JPRB,&
&.810E-02_JPRB,.827E-02_JPRB,.827E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,&
&.797E-02_JPRB,.797E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.706E-02_JPRB,.706E-02_JPRB,.735E-02_JPRB,&
&.735E-02_JPRB,.698E-02_JPRB,.698E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,&
&.614E-02_JPRB,.614E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 13  42.0
ZAER (:,13, 2) = (/&
&.694E-02_JPRB,.694E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.802E-02_JPRB,.802E-02_JPRB,.814E-02_JPRB,&
&.814E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,&
&.757E-02_JPRB,.757E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.644E-02_JPRB,.644E-02_JPRB,.511E-02_JPRB,&
&.511E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.629E-02_JPRB,.629E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,&
&.823E-02_JPRB,.823E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.752E-02_JPRB,.752E-02_JPRB,.744E-02_JPRB,&
&.744E-02_JPRB,.760E-02_JPRB,.760E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,&
&.725E-02_JPRB,.725E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.810E-02_JPRB,&
&.810E-02_JPRB,.827E-02_JPRB,.827E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,&
&.797E-02_JPRB,.797E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.706E-02_JPRB,.706E-02_JPRB,.735E-02_JPRB,&
&.735E-02_JPRB,.698E-02_JPRB,.698E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,&
&.614E-02_JPRB,.614E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 14  38.0
ZAER (:,14, 2) = (/&
&.671E-02_JPRB,.671E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.677E-02_JPRB,&
&.677E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.672E-02_JPRB,.672E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,&
&.760E-02_JPRB,.760E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,.633E-02_JPRB,.633E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,&
&.790E-02_JPRB,.790E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.798E-02_JPRB,&
&.798E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.727E-02_JPRB,.727E-02_JPRB,.632E-02_JPRB,.632E-02_JPRB,&
&.861E-02_JPRB,.861E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.747E-02_JPRB,&
&.747E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,.800E-02_JPRB,.800E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,&
&.756E-02_JPRB,.756E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,&
&.653E-02_JPRB,.653E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 15  34.0
ZAER (:,15, 2) = (/&
&.671E-02_JPRB,.671E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.677E-02_JPRB,&
&.677E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.672E-02_JPRB,.672E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,&
&.760E-02_JPRB,.760E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,.633E-02_JPRB,.633E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,&
&.790E-02_JPRB,.790E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.798E-02_JPRB,&
&.798E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.727E-02_JPRB,.727E-02_JPRB,.632E-02_JPRB,.632E-02_JPRB,&
&.861E-02_JPRB,.861E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.747E-02_JPRB,&
&.747E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,.800E-02_JPRB,.800E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,&
&.756E-02_JPRB,.756E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,&
&.653E-02_JPRB,.653E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 16  30.0
ZAER (:,16, 2) = (/&
&.862E-02_JPRB,.862E-02_JPRB,.756E-02_JPRB,.756E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.817E-02_JPRB,&
&.817E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.928E-02_JPRB,.928E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,.599E-02_JPRB,&
&.599E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,&
&.711E-02_JPRB,.711E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.946E-02_JPRB,.946E-02_JPRB,.944E-02_JPRB,&
&.944E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.479E-02_JPRB,.479E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.918E-02_JPRB,&
&.918E-02_JPRB,.929E-02_JPRB,.929E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,&
&.821E-02_JPRB,.821E-02_JPRB,.608E-02_JPRB,.608E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.303E-02_JPRB,&
&.303E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,&
&.906E-02_JPRB,.906E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 17  26.0
ZAER (:,17, 2) = (/&
&.862E-02_JPRB,.862E-02_JPRB,.756E-02_JPRB,.756E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.817E-02_JPRB,&
&.817E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.928E-02_JPRB,.928E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,.599E-02_JPRB,&
&.599E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,&
&.711E-02_JPRB,.711E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.946E-02_JPRB,.946E-02_JPRB,.944E-02_JPRB,&
&.944E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.479E-02_JPRB,.479E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.918E-02_JPRB,&
&.918E-02_JPRB,.929E-02_JPRB,.929E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,&
&.821E-02_JPRB,.821E-02_JPRB,.608E-02_JPRB,.608E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.303E-02_JPRB,&
&.303E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,&
&.906E-02_JPRB,.906E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 18  22.0
ZAER (:,18, 2) = (/&
&.818E-02_JPRB,.818E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.123E-01_JPRB,&
&.123E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.937E-02_JPRB,.937E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.521E-02_JPRB,&
&.521E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.507E-03_JPRB,.507E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,&
&.728E-02_JPRB,.728E-02_JPRB,.956E-02_JPRB,.956E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.793E-02_JPRB,&
&.793E-02_JPRB,.577E-02_JPRB,.577E-02_JPRB,.318E-02_JPRB,.318E-02_JPRB,.681E-03_JPRB,.681E-03_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.694E-02_JPRB,.694E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.884E-02_JPRB,.884E-02_JPRB,.633E-02_JPRB,.633E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,.291E-02_JPRB,&
&.291E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,&
&.709E-02_JPRB,.709E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 19  18.0
ZAER (:,19, 2) = (/&
&.818E-02_JPRB,.818E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.123E-01_JPRB,&
&.123E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.937E-02_JPRB,.937E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.521E-02_JPRB,&
&.521E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.507E-03_JPRB,.507E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,&
&.728E-02_JPRB,.728E-02_JPRB,.956E-02_JPRB,.956E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.793E-02_JPRB,&
&.793E-02_JPRB,.577E-02_JPRB,.577E-02_JPRB,.318E-02_JPRB,.318E-02_JPRB,.681E-03_JPRB,.681E-03_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.694E-02_JPRB,.694E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.884E-02_JPRB,.884E-02_JPRB,.633E-02_JPRB,.633E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,.291E-02_JPRB,&
&.291E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,&
&.709E-02_JPRB,.709E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 20  14.0
ZAER (:,20, 2) = (/&
&.869E-02_JPRB,.869E-02_JPRB,.129E-01_JPRB,.129E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.936E-02_JPRB,.936E-02_JPRB,.711E-02_JPRB,.711E-02_JPRB,.520E-02_JPRB,.520E-02_JPRB,.290E-02_JPRB,&
&.290E-02_JPRB,.485E-03_JPRB,.485E-03_JPRB,.168E-03_JPRB,.168E-03_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.780E-02_JPRB,.780E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.643E-02_JPRB,&
&.643E-02_JPRB,.450E-02_JPRB,.450E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.544E-03_JPRB,.544E-03_JPRB,&
&.140E-02_JPRB,.140E-02_JPRB,.473E-02_JPRB,.473E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.875E-02_JPRB,&
&.875E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,&
&.792E-02_JPRB,.792E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.462E-02_JPRB,.462E-02_JPRB,.361E-02_JPRB,&
&.361E-02_JPRB,.470E-02_JPRB,.470E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,&
&.559E-02_JPRB,.559E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 21  10.0
ZAER (:,21, 2) = (/&
&.869E-02_JPRB,.869E-02_JPRB,.129E-01_JPRB,.129E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.936E-02_JPRB,.936E-02_JPRB,.711E-02_JPRB,.711E-02_JPRB,.520E-02_JPRB,.520E-02_JPRB,.290E-02_JPRB,&
&.290E-02_JPRB,.485E-03_JPRB,.485E-03_JPRB,.168E-03_JPRB,.168E-03_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.780E-02_JPRB,.780E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.643E-02_JPRB,&
&.643E-02_JPRB,.450E-02_JPRB,.450E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.544E-03_JPRB,.544E-03_JPRB,&
&.140E-02_JPRB,.140E-02_JPRB,.473E-02_JPRB,.473E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.875E-02_JPRB,&
&.875E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,&
&.792E-02_JPRB,.792E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.462E-02_JPRB,.462E-02_JPRB,.361E-02_JPRB,&
&.361E-02_JPRB,.470E-02_JPRB,.470E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,&
&.559E-02_JPRB,.559E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 22   6.0
ZAER (:,22, 2) = (/&
&.146E-01_JPRB,.146E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.149E-01_JPRB,&
&.149E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.445E-03_JPRB,.445E-03_JPRB,.505E-03_JPRB,.505E-03_JPRB,.217E-02_JPRB,.217E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.882E-02_JPRB,.882E-02_JPRB,.661E-02_JPRB,&
&.661E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,&
&.398E-02_JPRB,.398E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,.814E-02_JPRB,.814E-02_JPRB,.766E-02_JPRB,&
&.766E-02_JPRB,.635E-02_JPRB,.635E-02_JPRB,.490E-02_JPRB,.490E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,&
&.302E-02_JPRB,.302E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.394E-02_JPRB,.394E-02_JPRB,.416E-02_JPRB,&
&.416E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 23   2.0
ZAER (:,23, 2) = (/&
&.146E-01_JPRB,.146E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.149E-01_JPRB,&
&.149E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.445E-03_JPRB,.445E-03_JPRB,.505E-03_JPRB,.505E-03_JPRB,.217E-02_JPRB,.217E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.882E-02_JPRB,.882E-02_JPRB,.661E-02_JPRB,&
&.661E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,&
&.398E-02_JPRB,.398E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,.814E-02_JPRB,.814E-02_JPRB,.766E-02_JPRB,&
&.766E-02_JPRB,.635E-02_JPRB,.635E-02_JPRB,.490E-02_JPRB,.490E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,&
&.302E-02_JPRB,.302E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.394E-02_JPRB,.394E-02_JPRB,.416E-02_JPRB,&
&.416E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 24  -2.0
ZAER (:,24, 2) = (/&
&.148E-01_JPRB,.148E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.913E-02_JPRB,.913E-02_JPRB,.782E-02_JPRB,.782E-02_JPRB,.655E-02_JPRB,.655E-02_JPRB,.421E-02_JPRB,&
&.421E-02_JPRB,.388E-02_JPRB,.388E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,.952E-02_JPRB,.952E-02_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.929E-02_JPRB,.929E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.531E-02_JPRB,&
&.531E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,&
&.525E-02_JPRB,.525E-02_JPRB,.782E-02_JPRB,.782E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.963E-02_JPRB,&
&.963E-02_JPRB,.782E-02_JPRB,.782E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.647E-02_JPRB,.647E-02_JPRB,&
&.549E-02_JPRB,.549E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,&
&.152E-01_JPRB,.152E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 25  -6.0
ZAER (:,25, 2) = (/&
&.148E-01_JPRB,.148E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.913E-02_JPRB,.913E-02_JPRB,.782E-02_JPRB,.782E-02_JPRB,.655E-02_JPRB,.655E-02_JPRB,.421E-02_JPRB,&
&.421E-02_JPRB,.388E-02_JPRB,.388E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,.952E-02_JPRB,.952E-02_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.929E-02_JPRB,.929E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.531E-02_JPRB,&
&.531E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,&
&.525E-02_JPRB,.525E-02_JPRB,.782E-02_JPRB,.782E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.963E-02_JPRB,&
&.963E-02_JPRB,.782E-02_JPRB,.782E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.647E-02_JPRB,.647E-02_JPRB,&
&.549E-02_JPRB,.549E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,&
&.152E-01_JPRB,.152E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 26 -10.0
ZAER (:,26, 2) = (/&
&.146E-01_JPRB,.146E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.932E-02_JPRB,.932E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.931E-02_JPRB,.931E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,.489E-02_JPRB,&
&.489E-02_JPRB,.394E-02_JPRB,.394E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,&
&.385E-02_JPRB,.385E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.955E-02_JPRB,.955E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,&
&.673E-02_JPRB,.673E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,.995E-02_JPRB,.995E-02_JPRB,.160E-01_JPRB,&
&.160E-01_JPRB,.176E-01_JPRB,.176E-01_JPRB,.178E-01_JPRB,.178E-01_JPRB,.168E-01_JPRB,.168E-01_JPRB,&
&.157E-01_JPRB,.157E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 27 -14.0
ZAER (:,27, 2) = (/&
&.146E-01_JPRB,.146E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.932E-02_JPRB,.932E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.931E-02_JPRB,.931E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,.489E-02_JPRB,&
&.489E-02_JPRB,.394E-02_JPRB,.394E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,&
&.385E-02_JPRB,.385E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.955E-02_JPRB,.955E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,&
&.673E-02_JPRB,.673E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,.995E-02_JPRB,.995E-02_JPRB,.160E-01_JPRB,&
&.160E-01_JPRB,.176E-01_JPRB,.176E-01_JPRB,.178E-01_JPRB,.178E-01_JPRB,.168E-01_JPRB,.168E-01_JPRB,&
&.157E-01_JPRB,.157E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 28 -18.0
ZAER (:,28, 2) = (/&
&.142E-01_JPRB,.142E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.967E-02_JPRB,.967E-02_JPRB,.857E-02_JPRB,.857E-02_JPRB,&
&.857E-02_JPRB,.857E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.839E-02_JPRB,.839E-02_JPRB,.542E-02_JPRB,.542E-02_JPRB,.372E-02_JPRB,&
&.372E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,&
&.324E-02_JPRB,.324E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.345E-02_JPRB,.345E-02_JPRB,.537E-02_JPRB,&
&.537E-02_JPRB,.580E-02_JPRB,.580E-02_JPRB,.526E-02_JPRB,.526E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,&
&.458E-02_JPRB,.458E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.157E-01_JPRB,&
&.157E-01_JPRB,.193E-01_JPRB,.193E-01_JPRB,.189E-01_JPRB,.189E-01_JPRB,.178E-01_JPRB,.178E-01_JPRB,&
&.167E-01_JPRB,.167E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 29 -22.0
ZAER (:,29, 2) = (/&
&.142E-01_JPRB,.142E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.967E-02_JPRB,.967E-02_JPRB,.857E-02_JPRB,.857E-02_JPRB,&
&.857E-02_JPRB,.857E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.839E-02_JPRB,.839E-02_JPRB,.542E-02_JPRB,.542E-02_JPRB,.372E-02_JPRB,&
&.372E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,&
&.324E-02_JPRB,.324E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.345E-02_JPRB,.345E-02_JPRB,.537E-02_JPRB,&
&.537E-02_JPRB,.580E-02_JPRB,.580E-02_JPRB,.526E-02_JPRB,.526E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,&
&.458E-02_JPRB,.458E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.157E-01_JPRB,&
&.157E-01_JPRB,.193E-01_JPRB,.193E-01_JPRB,.189E-01_JPRB,.189E-01_JPRB,.178E-01_JPRB,.178E-01_JPRB,&
&.167E-01_JPRB,.167E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 30 -26.0
ZAER (:,30, 2) = (/&
&.123E-01_JPRB,.123E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.989E-02_JPRB,.989E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.998E-02_JPRB,.998E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,&
&.404E-02_JPRB,.404E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.849E-02_JPRB,&
&.849E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.955E-02_JPRB,.955E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.394E-02_JPRB,&
&.394E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,&
&.257E-02_JPRB,.257E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.204E-02_JPRB,&
&.204E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.292E-02_JPRB,.292E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,&
&.196E-02_JPRB,.196E-02_JPRB,.259E-02_JPRB,.259E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,.893E-02_JPRB,&
&.893E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,&
&.131E-01_JPRB,.131E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 31 -30.0
ZAER (:,31, 2) = (/&
&.123E-01_JPRB,.123E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.989E-02_JPRB,.989E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.998E-02_JPRB,.998E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,&
&.404E-02_JPRB,.404E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.849E-02_JPRB,&
&.849E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.955E-02_JPRB,.955E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.394E-02_JPRB,&
&.394E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,&
&.257E-02_JPRB,.257E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.204E-02_JPRB,&
&.204E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.292E-02_JPRB,.292E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,&
&.196E-02_JPRB,.196E-02_JPRB,.259E-02_JPRB,.259E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,.893E-02_JPRB,&
&.893E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,&
&.131E-01_JPRB,.131E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 32 -34.0
ZAER (:,32, 2) = (/&
&.123E-01_JPRB,.123E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.984E-02_JPRB,.984E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,&
&.183E-02_JPRB,.183E-02_JPRB,.195E-02_JPRB,.195E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.336E-02_JPRB,&
&.336E-02_JPRB,.894E-02_JPRB,.894E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.579E-02_JPRB,&
&.579E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,&
&.327E-02_JPRB,.327E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.970E-03_JPRB,&
&.970E-03_JPRB,.947E-03_JPRB,.947E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,&
&.832E-03_JPRB,.832E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.243E-02_JPRB,.243E-02_JPRB,.337E-02_JPRB,&
&.337E-02_JPRB,.551E-02_JPRB,.551E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.118E-01_JPRB,.118E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 33 -38.0
ZAER (:,33, 2) = (/&
&.123E-01_JPRB,.123E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.984E-02_JPRB,.984E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,&
&.183E-02_JPRB,.183E-02_JPRB,.195E-02_JPRB,.195E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.336E-02_JPRB,&
&.336E-02_JPRB,.894E-02_JPRB,.894E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.579E-02_JPRB,&
&.579E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,&
&.327E-02_JPRB,.327E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.970E-03_JPRB,&
&.970E-03_JPRB,.947E-03_JPRB,.947E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,&
&.832E-03_JPRB,.832E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.243E-02_JPRB,.243E-02_JPRB,.337E-02_JPRB,&
&.337E-02_JPRB,.551E-02_JPRB,.551E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.118E-01_JPRB,.118E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 34 -42.0
ZAER (:,34, 2) = (/&
&.143E-01_JPRB,.143E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.816E-02_JPRB,.816E-02_JPRB,.299E-02_JPRB,.299E-02_JPRB,&
&.195E-02_JPRB,.195E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.911E-03_JPRB,&
&.911E-03_JPRB,.286E-02_JPRB,.286E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.149E-01_JPRB,.149E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.653E-02_JPRB,.653E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,.301E-02_JPRB,.301E-02_JPRB,&
&.305E-02_JPRB,.305E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.787E-03_JPRB,.787E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.576E-03_JPRB,.576E-03_JPRB,&
&.512E-03_JPRB,.512E-03_JPRB,.472E-03_JPRB,.472E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.479E-02_JPRB,.479E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 35 -46.0
ZAER (:,35, 2) = (/&
&.143E-01_JPRB,.143E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.816E-02_JPRB,.816E-02_JPRB,.299E-02_JPRB,.299E-02_JPRB,&
&.195E-02_JPRB,.195E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.911E-03_JPRB,&
&.911E-03_JPRB,.286E-02_JPRB,.286E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.149E-01_JPRB,.149E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.653E-02_JPRB,.653E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,.301E-02_JPRB,.301E-02_JPRB,&
&.305E-02_JPRB,.305E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.787E-03_JPRB,.787E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.576E-03_JPRB,.576E-03_JPRB,&
&.512E-03_JPRB,.512E-03_JPRB,.472E-03_JPRB,.472E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.479E-02_JPRB,.479E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 36 -50.0
ZAER (:,36, 2) = (/&
&.138E-01_JPRB,.138E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.153E-01_JPRB,&
&.153E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.632E-02_JPRB,.632E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,&
&.161E-02_JPRB,.161E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.102E-02_JPRB,&
&.102E-02_JPRB,.860E-03_JPRB,.860E-03_JPRB,.427E-02_JPRB,.427E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB,.192E-01_JPRB,.192E-01_JPRB,.234E-01_JPRB,.234E-01_JPRB,.174E-01_JPRB,&
&.174E-01_JPRB,.995E-02_JPRB,.995E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.222E-02_JPRB,.222E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.108E-02_JPRB,&
&.108E-02_JPRB,.913E-03_JPRB,.913E-03_JPRB,.747E-03_JPRB,.747E-03_JPRB,.597E-03_JPRB,.597E-03_JPRB,&
&.548E-03_JPRB,.548E-03_JPRB,.624E-03_JPRB,.624E-03_JPRB,.822E-03_JPRB,.822E-03_JPRB,.928E-03_JPRB,&
&.928E-03_JPRB,.972E-03_JPRB,.972E-03_JPRB,.209E-02_JPRB,.209E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 37 -54.0
ZAER (:,37, 2) = (/&
&.138E-01_JPRB,.138E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.153E-01_JPRB,&
&.153E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.632E-02_JPRB,.632E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,&
&.161E-02_JPRB,.161E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.102E-02_JPRB,&
&.102E-02_JPRB,.860E-03_JPRB,.860E-03_JPRB,.427E-02_JPRB,.427E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB,.192E-01_JPRB,.192E-01_JPRB,.234E-01_JPRB,.234E-01_JPRB,.174E-01_JPRB,&
&.174E-01_JPRB,.995E-02_JPRB,.995E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.222E-02_JPRB,.222E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.108E-02_JPRB,&
&.108E-02_JPRB,.913E-03_JPRB,.913E-03_JPRB,.747E-03_JPRB,.747E-03_JPRB,.597E-03_JPRB,.597E-03_JPRB,&
&.548E-03_JPRB,.548E-03_JPRB,.624E-03_JPRB,.624E-03_JPRB,.822E-03_JPRB,.822E-03_JPRB,.928E-03_JPRB,&
&.928E-03_JPRB,.972E-03_JPRB,.972E-03_JPRB,.209E-02_JPRB,.209E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 38 -58.0
ZAER (:,38, 2) = (/&
&.645E-02_JPRB,.645E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.636E-02_JPRB,.636E-02_JPRB,.822E-02_JPRB,&
&.822E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.312E-02_JPRB,.312E-02_JPRB,.206E-02_JPRB,&
&.206E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.174E-01_JPRB,.174E-01_JPRB,.162E-01_JPRB,&
&.162E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.605E-02_JPRB,.605E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,&
&.265E-02_JPRB,.265E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.995E-03_JPRB,&
&.995E-03_JPRB,.856E-03_JPRB,.856E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.704E-03_JPRB,.704E-03_JPRB,&
&.730E-03_JPRB,.730E-03_JPRB,.975E-03_JPRB,.975E-03_JPRB,.119E-02_JPRB,.119E-02_JPRB,.147E-02_JPRB,&
&.147E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.443E-02_JPRB,.443E-02_JPRB,&
&.715E-02_JPRB,.715E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 39 -62.0
ZAER (:,39, 2) = (/&
&.645E-02_JPRB,.645E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.636E-02_JPRB,.636E-02_JPRB,.822E-02_JPRB,&
&.822E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.312E-02_JPRB,.312E-02_JPRB,.206E-02_JPRB,&
&.206E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.174E-01_JPRB,.174E-01_JPRB,.162E-01_JPRB,&
&.162E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.605E-02_JPRB,.605E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,&
&.265E-02_JPRB,.265E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.995E-03_JPRB,&
&.995E-03_JPRB,.856E-03_JPRB,.856E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.704E-03_JPRB,.704E-03_JPRB,&
&.730E-03_JPRB,.730E-03_JPRB,.975E-03_JPRB,.975E-03_JPRB,.119E-02_JPRB,.119E-02_JPRB,.147E-02_JPRB,&
&.147E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.443E-02_JPRB,.443E-02_JPRB,&
&.715E-02_JPRB,.715E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 40 -66.0
ZAER (:,40, 2) = (/&
&.193E-02_JPRB,.193E-02_JPRB,.268E-02_JPRB,.268E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.253E-02_JPRB,&
&.253E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,&
&.117E-02_JPRB,.117E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.154E-02_JPRB,&
&.154E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,.480E-02_JPRB,.480E-02_JPRB,&
&.426E-02_JPRB,.426E-02_JPRB,.779E-02_JPRB,.779E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.439E-02_JPRB,.439E-02_JPRB,&
&.325E-02_JPRB,.325E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.931E-03_JPRB,&
&.931E-03_JPRB,.651E-03_JPRB,.651E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.797E-03_JPRB,.797E-03_JPRB,&
&.944E-03_JPRB,.944E-03_JPRB,.117E-02_JPRB,.117E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.157E-02_JPRB,&
&.157E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,&
&.157E-02_JPRB,.157E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 41 -70.0
ZAER (:,41, 2) = (/&
&.193E-02_JPRB,.193E-02_JPRB,.268E-02_JPRB,.268E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.253E-02_JPRB,&
&.253E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,&
&.117E-02_JPRB,.117E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.154E-02_JPRB,&
&.154E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,.480E-02_JPRB,.480E-02_JPRB,&
&.426E-02_JPRB,.426E-02_JPRB,.779E-02_JPRB,.779E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.439E-02_JPRB,.439E-02_JPRB,&
&.325E-02_JPRB,.325E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.931E-03_JPRB,&
&.931E-03_JPRB,.651E-03_JPRB,.651E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.797E-03_JPRB,.797E-03_JPRB,&
&.944E-03_JPRB,.944E-03_JPRB,.117E-02_JPRB,.117E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.157E-02_JPRB,&
&.157E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,&
&.157E-02_JPRB,.157E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 42 -74.0
ZAER (:,42, 2) = (/&
&.868E-03_JPRB,.868E-03_JPRB,.976E-03_JPRB,.976E-03_JPRB,.976E-03_JPRB,.976E-03_JPRB,.951E-03_JPRB,&
&.951E-03_JPRB,.970E-03_JPRB,.970E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.104E-02_JPRB,.104E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,.152E-02_JPRB,&
&.152E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.272E-02_JPRB,.272E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,&
&.140E-02_JPRB,.140E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.334E-02_JPRB,.334E-02_JPRB,.611E-02_JPRB,&
&.611E-02_JPRB,.824E-02_JPRB,.824E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,&
&.433E-02_JPRB,.433E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.912E-03_JPRB,.912E-03_JPRB,.667E-03_JPRB,&
&.667E-03_JPRB,.678E-03_JPRB,.678E-03_JPRB,.755E-03_JPRB,.755E-03_JPRB,.738E-03_JPRB,.738E-03_JPRB,&
&.752E-03_JPRB,.752E-03_JPRB,.842E-03_JPRB,.842E-03_JPRB,.942E-03_JPRB,.942E-03_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.884E-03_JPRB,.884E-03_JPRB,.846E-03_JPRB,.846E-03_JPRB,.835E-03_JPRB,.835E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 43 -78.0
ZAER (:,43, 2) = (/&
&.868E-03_JPRB,.868E-03_JPRB,.976E-03_JPRB,.976E-03_JPRB,.976E-03_JPRB,.976E-03_JPRB,.951E-03_JPRB,&
&.951E-03_JPRB,.970E-03_JPRB,.970E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.104E-02_JPRB,.104E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,.152E-02_JPRB,&
&.152E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.272E-02_JPRB,.272E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,&
&.140E-02_JPRB,.140E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.334E-02_JPRB,.334E-02_JPRB,.611E-02_JPRB,&
&.611E-02_JPRB,.824E-02_JPRB,.824E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,&
&.433E-02_JPRB,.433E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.912E-03_JPRB,.912E-03_JPRB,.667E-03_JPRB,&
&.667E-03_JPRB,.678E-03_JPRB,.678E-03_JPRB,.755E-03_JPRB,.755E-03_JPRB,.738E-03_JPRB,.738E-03_JPRB,&
&.752E-03_JPRB,.752E-03_JPRB,.842E-03_JPRB,.842E-03_JPRB,.942E-03_JPRB,.942E-03_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.884E-03_JPRB,.884E-03_JPRB,.846E-03_JPRB,.846E-03_JPRB,.835E-03_JPRB,.835E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 44 -82.0
ZAER (:,44, 2) = (/&
&.808E-03_JPRB,.808E-03_JPRB,.829E-03_JPRB,.829E-03_JPRB,.874E-03_JPRB,.874E-03_JPRB,.926E-03_JPRB,&
&.926E-03_JPRB,.979E-03_JPRB,.979E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.128E-02_JPRB,&
&.128E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.989E-03_JPRB,.989E-03_JPRB,&
&.979E-03_JPRB,.979E-03_JPRB,.105E-02_JPRB,.105E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,&
&.840E-03_JPRB,.840E-03_JPRB,.715E-03_JPRB,.715E-03_JPRB,.664E-03_JPRB,.664E-03_JPRB,.638E-03_JPRB,&
&.638E-03_JPRB,.640E-03_JPRB,.640E-03_JPRB,.646E-03_JPRB,.646E-03_JPRB,.639E-03_JPRB,.639E-03_JPRB,&
&.646E-03_JPRB,.646E-03_JPRB,.649E-03_JPRB,.649E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.664E-03_JPRB,&
&.664E-03_JPRB,.688E-03_JPRB,.688E-03_JPRB,.716E-03_JPRB,.716E-03_JPRB,.749E-03_JPRB,.749E-03_JPRB,&
&.786E-03_JPRB,.786E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 45 -86.0
ZAER (:,45, 2) = (/&
&.808E-03_JPRB,.808E-03_JPRB,.829E-03_JPRB,.829E-03_JPRB,.874E-03_JPRB,.874E-03_JPRB,.926E-03_JPRB,&
&.926E-03_JPRB,.979E-03_JPRB,.979E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.128E-02_JPRB,&
&.128E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.989E-03_JPRB,.989E-03_JPRB,&
&.979E-03_JPRB,.979E-03_JPRB,.105E-02_JPRB,.105E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,&
&.840E-03_JPRB,.840E-03_JPRB,.715E-03_JPRB,.715E-03_JPRB,.664E-03_JPRB,.664E-03_JPRB,.638E-03_JPRB,&
&.638E-03_JPRB,.640E-03_JPRB,.640E-03_JPRB,.646E-03_JPRB,.646E-03_JPRB,.639E-03_JPRB,.639E-03_JPRB,&
&.646E-03_JPRB,.646E-03_JPRB,.649E-03_JPRB,.649E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.664E-03_JPRB,&
&.664E-03_JPRB,.688E-03_JPRB,.688E-03_JPRB,.716E-03_JPRB,.716E-03_JPRB,.749E-03_JPRB,.749E-03_JPRB,&
&.786E-03_JPRB,.786E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 46 -90.0
ZAER (:,46, 2) = (/&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB/)

!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=2   
  DO JI=1,46
    DO JL=1,72
      RAERSS(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SEA-SALT AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESS_02
