SUBROUTINE SUECAESS_01

!**   OPTICAL THICKNESS OF AEROSOLS OF SEA-SALT ORIGIN
!                                      January

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESS* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSS


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,1:1)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Sea Salt Aerosol         month:  1 --- lat:  1  90.0
ZAER (:, 1, 1) = (/&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  2  86.0
ZAER (:, 2, 1) = (/&
&.330E-03_JPRB,.330E-03_JPRB,.376E-03_JPRB,.376E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.496E-03_JPRB,&
&.496E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,&
&.248E-03_JPRB,.248E-03_JPRB,.191E-03_JPRB,.191E-03_JPRB,.148E-03_JPRB,.148E-03_JPRB,.108E-03_JPRB,&
&.108E-03_JPRB,.723E-04_JPRB,.723E-04_JPRB,.660E-04_JPRB,.660E-04_JPRB,.687E-04_JPRB,.687E-04_JPRB,&
&.753E-04_JPRB,.753E-04_JPRB,.817E-04_JPRB,.817E-04_JPRB,.816E-04_JPRB,.816E-04_JPRB,.774E-04_JPRB,&
&.774E-04_JPRB,.771E-04_JPRB,.771E-04_JPRB,.869E-04_JPRB,.869E-04_JPRB,.100E-03_JPRB,.100E-03_JPRB,&
&.111E-03_JPRB,.111E-03_JPRB,.112E-03_JPRB,.112E-03_JPRB,.111E-03_JPRB,.111E-03_JPRB,.107E-03_JPRB,&
&.107E-03_JPRB,.881E-04_JPRB,.881E-04_JPRB,.787E-04_JPRB,.787E-04_JPRB,.722E-04_JPRB,.722E-04_JPRB,&
&.718E-04_JPRB,.718E-04_JPRB,.758E-04_JPRB,.758E-04_JPRB,.855E-04_JPRB,.855E-04_JPRB,.997E-04_JPRB,&
&.997E-04_JPRB,.119E-03_JPRB,.119E-03_JPRB,.144E-03_JPRB,.144E-03_JPRB,.195E-03_JPRB,.195E-03_JPRB,&
&.276E-03_JPRB,.276E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  3  82.0
ZAER (:, 3, 1) = (/&
&.330E-03_JPRB,.330E-03_JPRB,.376E-03_JPRB,.376E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.496E-03_JPRB,&
&.496E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,&
&.248E-03_JPRB,.248E-03_JPRB,.191E-03_JPRB,.191E-03_JPRB,.148E-03_JPRB,.148E-03_JPRB,.108E-03_JPRB,&
&.108E-03_JPRB,.723E-04_JPRB,.723E-04_JPRB,.660E-04_JPRB,.660E-04_JPRB,.687E-04_JPRB,.687E-04_JPRB,&
&.753E-04_JPRB,.753E-04_JPRB,.817E-04_JPRB,.817E-04_JPRB,.816E-04_JPRB,.816E-04_JPRB,.774E-04_JPRB,&
&.774E-04_JPRB,.771E-04_JPRB,.771E-04_JPRB,.869E-04_JPRB,.869E-04_JPRB,.100E-03_JPRB,.100E-03_JPRB,&
&.111E-03_JPRB,.111E-03_JPRB,.112E-03_JPRB,.112E-03_JPRB,.111E-03_JPRB,.111E-03_JPRB,.107E-03_JPRB,&
&.107E-03_JPRB,.881E-04_JPRB,.881E-04_JPRB,.787E-04_JPRB,.787E-04_JPRB,.722E-04_JPRB,.722E-04_JPRB,&
&.718E-04_JPRB,.718E-04_JPRB,.758E-04_JPRB,.758E-04_JPRB,.855E-04_JPRB,.855E-04_JPRB,.997E-04_JPRB,&
&.997E-04_JPRB,.119E-03_JPRB,.119E-03_JPRB,.144E-03_JPRB,.144E-03_JPRB,.195E-03_JPRB,.195E-03_JPRB,&
&.276E-03_JPRB,.276E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  4  78.0
ZAER (:, 4, 1) = (/&
&.673E-03_JPRB,.673E-03_JPRB,.707E-03_JPRB,.707E-03_JPRB,.757E-03_JPRB,.757E-03_JPRB,.933E-03_JPRB,&
&.933E-03_JPRB,.872E-03_JPRB,.872E-03_JPRB,.630E-03_JPRB,.630E-03_JPRB,.445E-03_JPRB,.445E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB,.360E-03_JPRB,.360E-03_JPRB,.387E-03_JPRB,.387E-03_JPRB,.420E-03_JPRB,&
&.420E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.132E-03_JPRB,.132E-03_JPRB,.139E-03_JPRB,.139E-03_JPRB,&
&.163E-03_JPRB,.163E-03_JPRB,.159E-03_JPRB,.159E-03_JPRB,.180E-03_JPRB,.180E-03_JPRB,.144E-03_JPRB,&
&.144E-03_JPRB,.992E-04_JPRB,.992E-04_JPRB,.138E-03_JPRB,.138E-03_JPRB,.209E-03_JPRB,.209E-03_JPRB,&
&.274E-03_JPRB,.274E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.267E-03_JPRB,.267E-03_JPRB,.327E-03_JPRB,&
&.327E-03_JPRB,.270E-03_JPRB,.270E-03_JPRB,.167E-03_JPRB,.167E-03_JPRB,.106E-03_JPRB,.106E-03_JPRB,&
&.809E-04_JPRB,.809E-04_JPRB,.105E-03_JPRB,.105E-03_JPRB,.129E-03_JPRB,.129E-03_JPRB,.123E-03_JPRB,&
&.123E-03_JPRB,.162E-03_JPRB,.162E-03_JPRB,.220E-03_JPRB,.220E-03_JPRB,.321E-03_JPRB,.321E-03_JPRB,&
&.499E-03_JPRB,.499E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  5  74.0
ZAER (:, 5, 1) = (/&
&.673E-03_JPRB,.673E-03_JPRB,.707E-03_JPRB,.707E-03_JPRB,.757E-03_JPRB,.757E-03_JPRB,.933E-03_JPRB,&
&.933E-03_JPRB,.872E-03_JPRB,.872E-03_JPRB,.630E-03_JPRB,.630E-03_JPRB,.445E-03_JPRB,.445E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB,.360E-03_JPRB,.360E-03_JPRB,.387E-03_JPRB,.387E-03_JPRB,.420E-03_JPRB,&
&.420E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.132E-03_JPRB,.132E-03_JPRB,.139E-03_JPRB,.139E-03_JPRB,&
&.163E-03_JPRB,.163E-03_JPRB,.159E-03_JPRB,.159E-03_JPRB,.180E-03_JPRB,.180E-03_JPRB,.144E-03_JPRB,&
&.144E-03_JPRB,.992E-04_JPRB,.992E-04_JPRB,.138E-03_JPRB,.138E-03_JPRB,.209E-03_JPRB,.209E-03_JPRB,&
&.274E-03_JPRB,.274E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.267E-03_JPRB,.267E-03_JPRB,.327E-03_JPRB,&
&.327E-03_JPRB,.270E-03_JPRB,.270E-03_JPRB,.167E-03_JPRB,.167E-03_JPRB,.106E-03_JPRB,.106E-03_JPRB,&
&.809E-04_JPRB,.809E-04_JPRB,.105E-03_JPRB,.105E-03_JPRB,.129E-03_JPRB,.129E-03_JPRB,.123E-03_JPRB,&
&.123E-03_JPRB,.162E-03_JPRB,.162E-03_JPRB,.220E-03_JPRB,.220E-03_JPRB,.321E-03_JPRB,.321E-03_JPRB,&
&.499E-03_JPRB,.499E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  6  70.0
ZAER (:, 6, 1) = (/&
&.306E-02_JPRB,.306E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.246E-02_JPRB,&
&.246E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,&
&.221E-02_JPRB,.221E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.230E-02_JPRB,&
&.230E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.743E-03_JPRB,.743E-03_JPRB,.700E-03_JPRB,.700E-03_JPRB,&
&.735E-03_JPRB,.735E-03_JPRB,.577E-03_JPRB,.577E-03_JPRB,.113E-02_JPRB,.113E-02_JPRB,.114E-02_JPRB,&
&.114E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.131E-02_JPRB,.131E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.174E-02_JPRB,&
&.174E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.827E-03_JPRB,.827E-03_JPRB,.419E-03_JPRB,.419E-03_JPRB,&
&.263E-03_JPRB,.263E-03_JPRB,.510E-03_JPRB,.510E-03_JPRB,.120E-02_JPRB,.120E-02_JPRB,.101E-02_JPRB,&
&.101E-02_JPRB,.671E-03_JPRB,.671E-03_JPRB,.900E-03_JPRB,.900E-03_JPRB,.171E-02_JPRB,.171E-02_JPRB,&
&.265E-02_JPRB,.265E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  7  66.0
ZAER (:, 7, 1) = (/&
&.306E-02_JPRB,.306E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.246E-02_JPRB,&
&.246E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,&
&.221E-02_JPRB,.221E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.230E-02_JPRB,&
&.230E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.743E-03_JPRB,.743E-03_JPRB,.700E-03_JPRB,.700E-03_JPRB,&
&.735E-03_JPRB,.735E-03_JPRB,.577E-03_JPRB,.577E-03_JPRB,.113E-02_JPRB,.113E-02_JPRB,.114E-02_JPRB,&
&.114E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.131E-02_JPRB,.131E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.174E-02_JPRB,&
&.174E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.827E-03_JPRB,.827E-03_JPRB,.419E-03_JPRB,.419E-03_JPRB,&
&.263E-03_JPRB,.263E-03_JPRB,.510E-03_JPRB,.510E-03_JPRB,.120E-02_JPRB,.120E-02_JPRB,.101E-02_JPRB,&
&.101E-02_JPRB,.671E-03_JPRB,.671E-03_JPRB,.900E-03_JPRB,.900E-03_JPRB,.171E-02_JPRB,.171E-02_JPRB,&
&.265E-02_JPRB,.265E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  8  62.0
ZAER (:, 8, 1) = (/&
&.729E-02_JPRB,.729E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.622E-02_JPRB,&
&.622E-02_JPRB,.602E-02_JPRB,.602E-02_JPRB,.576E-02_JPRB,.576E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,&
&.579E-02_JPRB,.579E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.634E-02_JPRB,&
&.634E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.456E-02_JPRB,.456E-02_JPRB,.424E-02_JPRB,.424E-02_JPRB,&
&.423E-02_JPRB,.423E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.338E-02_JPRB,&
&.338E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,&
&.465E-02_JPRB,.465E-02_JPRB,.539E-02_JPRB,.539E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.544E-02_JPRB,&
&.544E-02_JPRB,.537E-02_JPRB,.537E-02_JPRB,.503E-02_JPRB,.503E-02_JPRB,.442E-02_JPRB,.442E-02_JPRB,&
&.388E-02_JPRB,.388E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,.371E-02_JPRB,.371E-02_JPRB,.404E-02_JPRB,&
&.404E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.526E-02_JPRB,.526E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,&
&.770E-02_JPRB,.770E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  9  58.0
ZAER (:, 9, 1) = (/&
&.729E-02_JPRB,.729E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.622E-02_JPRB,&
&.622E-02_JPRB,.602E-02_JPRB,.602E-02_JPRB,.576E-02_JPRB,.576E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,&
&.579E-02_JPRB,.579E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.634E-02_JPRB,&
&.634E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.456E-02_JPRB,.456E-02_JPRB,.424E-02_JPRB,.424E-02_JPRB,&
&.423E-02_JPRB,.423E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.338E-02_JPRB,&
&.338E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,&
&.465E-02_JPRB,.465E-02_JPRB,.539E-02_JPRB,.539E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.544E-02_JPRB,&
&.544E-02_JPRB,.537E-02_JPRB,.537E-02_JPRB,.503E-02_JPRB,.503E-02_JPRB,.442E-02_JPRB,.442E-02_JPRB,&
&.388E-02_JPRB,.388E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,.371E-02_JPRB,.371E-02_JPRB,.404E-02_JPRB,&
&.404E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.526E-02_JPRB,.526E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,&
&.770E-02_JPRB,.770E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 10  54.0
ZAER (:,10, 1) = (/&
&.893E-02_JPRB,.893E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.863E-02_JPRB,&
&.863E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,&
&.717E-02_JPRB,.717E-02_JPRB,.732E-02_JPRB,.732E-02_JPRB,.795E-02_JPRB,.795E-02_JPRB,.761E-02_JPRB,&
&.761E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,&
&.724E-02_JPRB,.724E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.636E-02_JPRB,&
&.636E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.632E-02_JPRB,.632E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,&
&.719E-02_JPRB,.719E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.796E-02_JPRB,&
&.796E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.795E-02_JPRB,.795E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,&
&.760E-02_JPRB,.760E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.837E-02_JPRB,&
&.837E-02_JPRB,.837E-02_JPRB,.837E-02_JPRB,.875E-02_JPRB,.875E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,&
&.934E-02_JPRB,.934E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 11  50.0
ZAER (:,11, 1) = (/&
&.893E-02_JPRB,.893E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.863E-02_JPRB,&
&.863E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,&
&.717E-02_JPRB,.717E-02_JPRB,.732E-02_JPRB,.732E-02_JPRB,.795E-02_JPRB,.795E-02_JPRB,.761E-02_JPRB,&
&.761E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,&
&.724E-02_JPRB,.724E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.636E-02_JPRB,&
&.636E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.632E-02_JPRB,.632E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,&
&.719E-02_JPRB,.719E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.796E-02_JPRB,&
&.796E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.795E-02_JPRB,.795E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,&
&.760E-02_JPRB,.760E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.837E-02_JPRB,&
&.837E-02_JPRB,.837E-02_JPRB,.837E-02_JPRB,.875E-02_JPRB,.875E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,&
&.934E-02_JPRB,.934E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 12  46.0
ZAER (:,12, 1) = (/&
&.705E-02_JPRB,.705E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,.798E-02_JPRB,&
&.798E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,&
&.550E-02_JPRB,.550E-02_JPRB,.526E-02_JPRB,.526E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.522E-02_JPRB,&
&.522E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,.558E-02_JPRB,.558E-02_JPRB,.846E-02_JPRB,.846E-02_JPRB,&
&.899E-02_JPRB,.899E-02_JPRB,.895E-02_JPRB,.895E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.929E-02_JPRB,&
&.929E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,&
&.708E-02_JPRB,.708E-02_JPRB,.716E-02_JPRB,.716E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.775E-02_JPRB,&
&.775E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.789E-02_JPRB,.789E-02_JPRB,&
&.828E-02_JPRB,.828E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,&
&.580E-02_JPRB,.580E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 13  42.0
ZAER (:,13, 1) = (/&
&.705E-02_JPRB,.705E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,.798E-02_JPRB,&
&.798E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,&
&.550E-02_JPRB,.550E-02_JPRB,.526E-02_JPRB,.526E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.522E-02_JPRB,&
&.522E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,.558E-02_JPRB,.558E-02_JPRB,.846E-02_JPRB,.846E-02_JPRB,&
&.899E-02_JPRB,.899E-02_JPRB,.895E-02_JPRB,.895E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.929E-02_JPRB,&
&.929E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,&
&.708E-02_JPRB,.708E-02_JPRB,.716E-02_JPRB,.716E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.775E-02_JPRB,&
&.775E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.789E-02_JPRB,.789E-02_JPRB,&
&.828E-02_JPRB,.828E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,&
&.580E-02_JPRB,.580E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 14  38.0
ZAER (:,14, 1) = (/&
&.563E-02_JPRB,.563E-02_JPRB,.579E-02_JPRB,.579E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.563E-02_JPRB,&
&.563E-02_JPRB,.557E-02_JPRB,.557E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,&
&.568E-02_JPRB,.568E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.622E-02_JPRB,.622E-02_JPRB,.571E-02_JPRB,&
&.571E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,.632E-02_JPRB,.632E-02_JPRB,&
&.733E-02_JPRB,.733E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,.860E-02_JPRB,&
&.860E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,&
&.640E-02_JPRB,.640E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.646E-02_JPRB,&
&.646E-02_JPRB,.656E-02_JPRB,.656E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.558E-02_JPRB,.558E-02_JPRB,&
&.601E-02_JPRB,.601E-02_JPRB,.617E-02_JPRB,.617E-02_JPRB,.524E-02_JPRB,.524E-02_JPRB,.514E-02_JPRB,&
&.514E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.491E-02_JPRB,.491E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,&
&.553E-02_JPRB,.553E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 15  34.0
ZAER (:,15, 1) = (/&
&.563E-02_JPRB,.563E-02_JPRB,.579E-02_JPRB,.579E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.563E-02_JPRB,&
&.563E-02_JPRB,.557E-02_JPRB,.557E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,&
&.568E-02_JPRB,.568E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.622E-02_JPRB,.622E-02_JPRB,.571E-02_JPRB,&
&.571E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,.632E-02_JPRB,.632E-02_JPRB,&
&.733E-02_JPRB,.733E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,.860E-02_JPRB,&
&.860E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,&
&.640E-02_JPRB,.640E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.646E-02_JPRB,&
&.646E-02_JPRB,.656E-02_JPRB,.656E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.558E-02_JPRB,.558E-02_JPRB,&
&.601E-02_JPRB,.601E-02_JPRB,.617E-02_JPRB,.617E-02_JPRB,.524E-02_JPRB,.524E-02_JPRB,.514E-02_JPRB,&
&.514E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.491E-02_JPRB,.491E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,&
&.553E-02_JPRB,.553E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 16  30.0
ZAER (:,16, 1) = (/&
&.710E-02_JPRB,.710E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.904E-02_JPRB,.904E-02_JPRB,.992E-02_JPRB,.992E-02_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.903E-02_JPRB,.903E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,&
&.597E-02_JPRB,.597E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,.767E-02_JPRB,&
&.767E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,&
&.409E-02_JPRB,.409E-02_JPRB,.704E-02_JPRB,.704E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.738E-02_JPRB,&
&.738E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,&
&.869E-02_JPRB,.869E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.224E-02_JPRB,&
&.224E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.793E-02_JPRB,.793E-02_JPRB,&
&.699E-02_JPRB,.699E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 17  26.0
ZAER (:,17, 1) = (/&
&.710E-02_JPRB,.710E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.904E-02_JPRB,.904E-02_JPRB,.992E-02_JPRB,.992E-02_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.903E-02_JPRB,.903E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,&
&.597E-02_JPRB,.597E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,.767E-02_JPRB,&
&.767E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,&
&.409E-02_JPRB,.409E-02_JPRB,.704E-02_JPRB,.704E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.738E-02_JPRB,&
&.738E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,&
&.869E-02_JPRB,.869E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.224E-02_JPRB,&
&.224E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.793E-02_JPRB,.793E-02_JPRB,&
&.699E-02_JPRB,.699E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 18  22.0
ZAER (:,18, 1) = (/&
&.833E-02_JPRB,.833E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.732E-02_JPRB,.732E-02_JPRB,.817E-02_JPRB,&
&.817E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.916E-02_JPRB,.916E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.456E-02_JPRB,&
&.456E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.617E-03_JPRB,.617E-03_JPRB,.754E-03_JPRB,.754E-03_JPRB,&
&.569E-02_JPRB,.569E-02_JPRB,.883E-02_JPRB,.883E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,.761E-02_JPRB,&
&.761E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.334E-02_JPRB,.334E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.170E-02_JPRB,.170E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.782E-02_JPRB,&
&.782E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.768E-02_JPRB,.768E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,.190E-02_JPRB,&
&.190E-02_JPRB,.373E-02_JPRB,.373E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,&
&.747E-02_JPRB,.747E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 19  18.0
ZAER (:,19, 1) = (/&
&.833E-02_JPRB,.833E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.732E-02_JPRB,.732E-02_JPRB,.817E-02_JPRB,&
&.817E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.916E-02_JPRB,.916E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.456E-02_JPRB,&
&.456E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.617E-03_JPRB,.617E-03_JPRB,.754E-03_JPRB,.754E-03_JPRB,&
&.569E-02_JPRB,.569E-02_JPRB,.883E-02_JPRB,.883E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,.761E-02_JPRB,&
&.761E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.334E-02_JPRB,.334E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.170E-02_JPRB,.170E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.782E-02_JPRB,&
&.782E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.768E-02_JPRB,.768E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,.190E-02_JPRB,&
&.190E-02_JPRB,.373E-02_JPRB,.373E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,&
&.747E-02_JPRB,.747E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 20  14.0
ZAER (:,20, 1) = (/&
&.848E-02_JPRB,.848E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.839E-02_JPRB,.839E-02_JPRB,.582E-02_JPRB,.582E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.217E-02_JPRB,&
&.217E-02_JPRB,.341E-03_JPRB,.341E-03_JPRB,.192E-03_JPRB,.192E-03_JPRB,.170E-02_JPRB,.170E-02_JPRB,&
&.671E-02_JPRB,.671E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.875E-02_JPRB,.875E-02_JPRB,.607E-02_JPRB,&
&.607E-02_JPRB,.413E-02_JPRB,.413E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.343E-03_JPRB,.343E-03_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.679E-02_JPRB,&
&.679E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,.874E-02_JPRB,.874E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,&
&.699E-02_JPRB,.699E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.319E-02_JPRB,&
&.319E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,&
&.783E-02_JPRB,.783E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 21  10.0
ZAER (:,21, 1) = (/&
&.848E-02_JPRB,.848E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.839E-02_JPRB,.839E-02_JPRB,.582E-02_JPRB,.582E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.217E-02_JPRB,&
&.217E-02_JPRB,.341E-03_JPRB,.341E-03_JPRB,.192E-03_JPRB,.192E-03_JPRB,.170E-02_JPRB,.170E-02_JPRB,&
&.671E-02_JPRB,.671E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.875E-02_JPRB,.875E-02_JPRB,.607E-02_JPRB,&
&.607E-02_JPRB,.413E-02_JPRB,.413E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.343E-03_JPRB,.343E-03_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.679E-02_JPRB,&
&.679E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,.874E-02_JPRB,.874E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,&
&.699E-02_JPRB,.699E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.319E-02_JPRB,&
&.319E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,&
&.783E-02_JPRB,.783E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 22   6.0
ZAER (:,22, 1) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.803E-02_JPRB,.803E-02_JPRB,&
&.589E-02_JPRB,.589E-02_JPRB,.456E-02_JPRB,.456E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.861E-03_JPRB,&
&.861E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,.294E-02_JPRB,.294E-02_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.792E-02_JPRB,.792E-02_JPRB,.557E-02_JPRB,&
&.557E-02_JPRB,.374E-02_JPRB,.374E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.310E-02_JPRB,.310E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.562E-02_JPRB,&
&.562E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.474E-02_JPRB,.474E-02_JPRB,.442E-02_JPRB,.442E-02_JPRB,&
&.348E-02_JPRB,.348E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.472E-02_JPRB,.472E-02_JPRB,.460E-02_JPRB,&
&.460E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.958E-02_JPRB,.958E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 23   2.0
ZAER (:,23, 1) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.803E-02_JPRB,.803E-02_JPRB,&
&.589E-02_JPRB,.589E-02_JPRB,.456E-02_JPRB,.456E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.861E-03_JPRB,&
&.861E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,.294E-02_JPRB,.294E-02_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.792E-02_JPRB,.792E-02_JPRB,.557E-02_JPRB,&
&.557E-02_JPRB,.374E-02_JPRB,.374E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.310E-02_JPRB,.310E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.562E-02_JPRB,&
&.562E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.474E-02_JPRB,.474E-02_JPRB,.442E-02_JPRB,.442E-02_JPRB,&
&.348E-02_JPRB,.348E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.472E-02_JPRB,.472E-02_JPRB,.460E-02_JPRB,&
&.460E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.958E-02_JPRB,.958E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 24  -2.0
ZAER (:,24, 1) = (/&
&.121E-01_JPRB,.121E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.129E-01_JPRB,&
&.129E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.905E-02_JPRB,.905E-02_JPRB,&
&.797E-02_JPRB,.797E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.371E-02_JPRB,&
&.371E-02_JPRB,.419E-02_JPRB,.419E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.127E-01_JPRB,.127E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.741E-02_JPRB,.741E-02_JPRB,.475E-02_JPRB,&
&.475E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.302E-02_JPRB,.302E-02_JPRB,&
&.455E-02_JPRB,.455E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.820E-02_JPRB,&
&.820E-02_JPRB,.726E-02_JPRB,.726E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.634E-02_JPRB,.634E-02_JPRB,&
&.682E-02_JPRB,.682E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.874E-02_JPRB,.874E-02_JPRB,.931E-02_JPRB,&
&.931E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 25  -6.0
ZAER (:,25, 1) = (/&
&.121E-01_JPRB,.121E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.129E-01_JPRB,&
&.129E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.905E-02_JPRB,.905E-02_JPRB,&
&.797E-02_JPRB,.797E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.371E-02_JPRB,&
&.371E-02_JPRB,.419E-02_JPRB,.419E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.127E-01_JPRB,.127E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.741E-02_JPRB,.741E-02_JPRB,.475E-02_JPRB,&
&.475E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.302E-02_JPRB,.302E-02_JPRB,&
&.455E-02_JPRB,.455E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.820E-02_JPRB,&
&.820E-02_JPRB,.726E-02_JPRB,.726E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.634E-02_JPRB,.634E-02_JPRB,&
&.682E-02_JPRB,.682E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.874E-02_JPRB,.874E-02_JPRB,.931E-02_JPRB,&
&.931E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 26 -10.0
ZAER (:,26, 1) = (/&
&.125E-01_JPRB,.125E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB,.974E-02_JPRB,.974E-02_JPRB,.914E-02_JPRB,.914E-02_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,&
&.135E-01_JPRB,.135E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.738E-02_JPRB,.738E-02_JPRB,.430E-02_JPRB,&
&.430E-02_JPRB,.290E-02_JPRB,.290E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,&
&.377E-02_JPRB,.377E-02_JPRB,.593E-02_JPRB,.593E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,.920E-02_JPRB,&
&.920E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.787E-02_JPRB,.787E-02_JPRB,&
&.828E-02_JPRB,.828E-02_JPRB,.128E-01_JPRB,.128E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.178E-01_JPRB,&
&.178E-01_JPRB,.190E-01_JPRB,.190E-01_JPRB,.184E-01_JPRB,.184E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,&
&.141E-01_JPRB,.141E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 27 -14.0
ZAER (:,27, 1) = (/&
&.125E-01_JPRB,.125E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB,.974E-02_JPRB,.974E-02_JPRB,.914E-02_JPRB,.914E-02_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,&
&.135E-01_JPRB,.135E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.738E-02_JPRB,.738E-02_JPRB,.430E-02_JPRB,&
&.430E-02_JPRB,.290E-02_JPRB,.290E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,&
&.377E-02_JPRB,.377E-02_JPRB,.593E-02_JPRB,.593E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,.920E-02_JPRB,&
&.920E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.787E-02_JPRB,.787E-02_JPRB,&
&.828E-02_JPRB,.828E-02_JPRB,.128E-01_JPRB,.128E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.178E-01_JPRB,&
&.178E-01_JPRB,.190E-01_JPRB,.190E-01_JPRB,.184E-01_JPRB,.184E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,&
&.141E-01_JPRB,.141E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 28 -18.0
ZAER (:,28, 1) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.994E-02_JPRB,.994E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.907E-02_JPRB,.907E-02_JPRB,&
&.852E-02_JPRB,.852E-02_JPRB,.808E-02_JPRB,.808E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.946E-02_JPRB,.946E-02_JPRB,.537E-02_JPRB,.537E-02_JPRB,.343E-02_JPRB,&
&.343E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,&
&.260E-02_JPRB,.260E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,.384E-02_JPRB,.384E-02_JPRB,.575E-02_JPRB,&
&.575E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.344E-02_JPRB,.344E-02_JPRB,&
&.461E-02_JPRB,.461E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.171E-01_JPRB,.171E-01_JPRB,.211E-01_JPRB,&
&.211E-01_JPRB,.213E-01_JPRB,.213E-01_JPRB,.181E-01_JPRB,.181E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 29 -22.0
ZAER (:,29, 1) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.994E-02_JPRB,.994E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.907E-02_JPRB,.907E-02_JPRB,&
&.852E-02_JPRB,.852E-02_JPRB,.808E-02_JPRB,.808E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.946E-02_JPRB,.946E-02_JPRB,.537E-02_JPRB,.537E-02_JPRB,.343E-02_JPRB,&
&.343E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,&
&.260E-02_JPRB,.260E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,.384E-02_JPRB,.384E-02_JPRB,.575E-02_JPRB,&
&.575E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.344E-02_JPRB,.344E-02_JPRB,&
&.461E-02_JPRB,.461E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.171E-01_JPRB,.171E-01_JPRB,.211E-01_JPRB,&
&.211E-01_JPRB,.213E-01_JPRB,.213E-01_JPRB,.181E-01_JPRB,.181E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 30 -26.0
ZAER (:,30, 1) = (/&
&.134E-01_JPRB,.134E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.909E-02_JPRB,.909E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,.475E-02_JPRB,.475E-02_JPRB,&
&.353E-02_JPRB,.353E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,.535E-02_JPRB,.535E-02_JPRB,.742E-02_JPRB,&
&.742E-02_JPRB,.980E-02_JPRB,.980E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.990E-02_JPRB,.990E-02_JPRB,&
&.961E-02_JPRB,.961E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.619E-02_JPRB,.619E-02_JPRB,.287E-02_JPRB,&
&.287E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.244E-02_JPRB,.244E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.226E-02_JPRB,&
&.226E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.206E-02_JPRB,.206E-02_JPRB,.467E-02_JPRB,.467E-02_JPRB,.969E-02_JPRB,.969E-02_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 31 -30.0
ZAER (:,31, 1) = (/&
&.134E-01_JPRB,.134E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.909E-02_JPRB,.909E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,.475E-02_JPRB,.475E-02_JPRB,&
&.353E-02_JPRB,.353E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,.535E-02_JPRB,.535E-02_JPRB,.742E-02_JPRB,&
&.742E-02_JPRB,.980E-02_JPRB,.980E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.990E-02_JPRB,.990E-02_JPRB,&
&.961E-02_JPRB,.961E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.619E-02_JPRB,.619E-02_JPRB,.287E-02_JPRB,&
&.287E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.244E-02_JPRB,.244E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.226E-02_JPRB,&
&.226E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.206E-02_JPRB,.206E-02_JPRB,.467E-02_JPRB,.467E-02_JPRB,.969E-02_JPRB,.969E-02_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 32 -34.0
ZAER (:,32, 1) = (/&
&.151E-01_JPRB,.151E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.946E-02_JPRB,&
&.946E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,&
&.193E-02_JPRB,.193E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.312E-02_JPRB,&
&.312E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.961E-02_JPRB,.961E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.549E-02_JPRB,&
&.549E-02_JPRB,.331E-02_JPRB,.331E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,.418E-02_JPRB,.418E-02_JPRB,&
&.269E-02_JPRB,.269E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.969E-03_JPRB,.969E-03_JPRB,.818E-03_JPRB,.818E-03_JPRB,&
&.733E-03_JPRB,.733E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.303E-02_JPRB,.303E-02_JPRB,.406E-02_JPRB,&
&.406E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 33 -38.0
ZAER (:,33, 1) = (/&
&.151E-01_JPRB,.151E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.946E-02_JPRB,&
&.946E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,&
&.193E-02_JPRB,.193E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.312E-02_JPRB,&
&.312E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.961E-02_JPRB,.961E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.549E-02_JPRB,&
&.549E-02_JPRB,.331E-02_JPRB,.331E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,.418E-02_JPRB,.418E-02_JPRB,&
&.269E-02_JPRB,.269E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.969E-03_JPRB,.969E-03_JPRB,.818E-03_JPRB,.818E-03_JPRB,&
&.733E-03_JPRB,.733E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.303E-02_JPRB,.303E-02_JPRB,.406E-02_JPRB,&
&.406E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 34 -42.0
ZAER (:,34, 1) = (/&
&.198E-01_JPRB,.198E-01_JPRB,.168E-01_JPRB,.168E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.119E-01_JPRB,&
&.119E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.842E-02_JPRB,.842E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,&
&.231E-02_JPRB,.231E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.659E-02_JPRB,.659E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,&
&.166E-01_JPRB,.166E-01_JPRB,.174E-01_JPRB,.174E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.461E-02_JPRB,.461E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,&
&.290E-02_JPRB,.290E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.963E-03_JPRB,.963E-03_JPRB,.775E-03_JPRB,.775E-03_JPRB,.662E-03_JPRB,.662E-03_JPRB,&
&.606E-03_JPRB,.606E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.179E-01_JPRB,.179E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 35 -46.0
ZAER (:,35, 1) = (/&
&.198E-01_JPRB,.198E-01_JPRB,.168E-01_JPRB,.168E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.119E-01_JPRB,&
&.119E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.842E-02_JPRB,.842E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,&
&.231E-02_JPRB,.231E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.659E-02_JPRB,.659E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,&
&.166E-01_JPRB,.166E-01_JPRB,.174E-01_JPRB,.174E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.461E-02_JPRB,.461E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,&
&.290E-02_JPRB,.290E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.963E-03_JPRB,.963E-03_JPRB,.775E-03_JPRB,.775E-03_JPRB,.662E-03_JPRB,.662E-03_JPRB,&
&.606E-03_JPRB,.606E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.179E-01_JPRB,.179E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 36 -50.0
ZAER (:,36, 1) = (/&
&.152E-01_JPRB,.152E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.652E-02_JPRB,.652E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,&
&.205E-02_JPRB,.205E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.991E-03_JPRB,&
&.991E-03_JPRB,.968E-03_JPRB,.968E-03_JPRB,.340E-02_JPRB,.340E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.189E-01_JPRB,.189E-01_JPRB,.227E-01_JPRB,.227E-01_JPRB,.208E-01_JPRB,.208E-01_JPRB,.135E-01_JPRB,&
&.135E-01_JPRB,.814E-02_JPRB,.814E-02_JPRB,.522E-02_JPRB,.522E-02_JPRB,.392E-02_JPRB,.392E-02_JPRB,&
&.313E-02_JPRB,.313E-02_JPRB,.243E-02_JPRB,.243E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.164E-02_JPRB,&
&.164E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.931E-03_JPRB,.931E-03_JPRB,&
&.857E-03_JPRB,.857E-03_JPRB,.775E-03_JPRB,.775E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.664E-03_JPRB,&
&.664E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.130E-02_JPRB,.130E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,&
&.144E-01_JPRB,.144E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 37 -54.0
ZAER (:,37, 1) = (/&
&.152E-01_JPRB,.152E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.652E-02_JPRB,.652E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,&
&.205E-02_JPRB,.205E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.991E-03_JPRB,&
&.991E-03_JPRB,.968E-03_JPRB,.968E-03_JPRB,.340E-02_JPRB,.340E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.189E-01_JPRB,.189E-01_JPRB,.227E-01_JPRB,.227E-01_JPRB,.208E-01_JPRB,.208E-01_JPRB,.135E-01_JPRB,&
&.135E-01_JPRB,.814E-02_JPRB,.814E-02_JPRB,.522E-02_JPRB,.522E-02_JPRB,.392E-02_JPRB,.392E-02_JPRB,&
&.313E-02_JPRB,.313E-02_JPRB,.243E-02_JPRB,.243E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.164E-02_JPRB,&
&.164E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.931E-03_JPRB,.931E-03_JPRB,&
&.857E-03_JPRB,.857E-03_JPRB,.775E-03_JPRB,.775E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.664E-03_JPRB,&
&.664E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.130E-02_JPRB,.130E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,&
&.144E-01_JPRB,.144E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 38 -58.0
ZAER (:,38, 1) = (/&
&.632E-02_JPRB,.632E-02_JPRB,.471E-02_JPRB,.471E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.556E-02_JPRB,&
&.556E-02_JPRB,.464E-02_JPRB,.464E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.143E-02_JPRB,&
&.143E-02_JPRB,.683E-03_JPRB,.683E-03_JPRB,.582E-02_JPRB,.582E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,&
&.178E-01_JPRB,.178E-01_JPRB,.213E-01_JPRB,.213E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.186E-01_JPRB,&
&.186E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.860E-02_JPRB,.860E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,&
&.441E-02_JPRB,.441E-02_JPRB,.331E-02_JPRB,.331E-02_JPRB,.263E-02_JPRB,.263E-02_JPRB,.209E-02_JPRB,&
&.209E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.909E-03_JPRB,.909E-03_JPRB,.815E-03_JPRB,.815E-03_JPRB,.709E-03_JPRB,&
&.709E-03_JPRB,.755E-03_JPRB,.755E-03_JPRB,.162E-02_JPRB,.162E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,&
&.770E-02_JPRB,.770E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 39 -62.0
ZAER (:,39, 1) = (/&
&.632E-02_JPRB,.632E-02_JPRB,.471E-02_JPRB,.471E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.556E-02_JPRB,&
&.556E-02_JPRB,.464E-02_JPRB,.464E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.143E-02_JPRB,&
&.143E-02_JPRB,.683E-03_JPRB,.683E-03_JPRB,.582E-02_JPRB,.582E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,&
&.178E-01_JPRB,.178E-01_JPRB,.213E-01_JPRB,.213E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.186E-01_JPRB,&
&.186E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.860E-02_JPRB,.860E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,&
&.441E-02_JPRB,.441E-02_JPRB,.331E-02_JPRB,.331E-02_JPRB,.263E-02_JPRB,.263E-02_JPRB,.209E-02_JPRB,&
&.209E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.909E-03_JPRB,.909E-03_JPRB,.815E-03_JPRB,.815E-03_JPRB,.709E-03_JPRB,&
&.709E-03_JPRB,.755E-03_JPRB,.755E-03_JPRB,.162E-02_JPRB,.162E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,&
&.770E-02_JPRB,.770E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 40 -66.0
ZAER (:,40, 1) = (/&
&.151E-02_JPRB,.151E-02_JPRB,.243E-02_JPRB,.243E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.158E-02_JPRB,&
&.158E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,.969E-03_JPRB,.969E-03_JPRB,&
&.713E-03_JPRB,.713E-03_JPRB,.859E-03_JPRB,.859E-03_JPRB,.878E-03_JPRB,.878E-03_JPRB,.553E-03_JPRB,&
&.553E-03_JPRB,.358E-03_JPRB,.358E-03_JPRB,.136E-02_JPRB,.136E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,&
&.464E-02_JPRB,.464E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.921E-02_JPRB,.921E-02_JPRB,.117E-01_JPRB,&
&.117E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.621E-02_JPRB,.621E-02_JPRB,&
&.470E-02_JPRB,.470E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,.331E-02_JPRB,.331E-02_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.895E-03_JPRB,.895E-03_JPRB,.805E-03_JPRB,.805E-03_JPRB,.735E-03_JPRB,.735E-03_JPRB,.749E-03_JPRB,&
&.749E-03_JPRB,.795E-03_JPRB,.795E-03_JPRB,.836E-03_JPRB,.836E-03_JPRB,.919E-03_JPRB,.919E-03_JPRB,&
&.113E-02_JPRB,.113E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 41 -70.0
ZAER (:,41, 1) = (/&
&.151E-02_JPRB,.151E-02_JPRB,.243E-02_JPRB,.243E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.158E-02_JPRB,&
&.158E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,.969E-03_JPRB,.969E-03_JPRB,&
&.713E-03_JPRB,.713E-03_JPRB,.859E-03_JPRB,.859E-03_JPRB,.878E-03_JPRB,.878E-03_JPRB,.553E-03_JPRB,&
&.553E-03_JPRB,.358E-03_JPRB,.358E-03_JPRB,.136E-02_JPRB,.136E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,&
&.464E-02_JPRB,.464E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.921E-02_JPRB,.921E-02_JPRB,.117E-01_JPRB,&
&.117E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.621E-02_JPRB,.621E-02_JPRB,&
&.470E-02_JPRB,.470E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,.331E-02_JPRB,.331E-02_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.895E-03_JPRB,.895E-03_JPRB,.805E-03_JPRB,.805E-03_JPRB,.735E-03_JPRB,.735E-03_JPRB,.749E-03_JPRB,&
&.749E-03_JPRB,.795E-03_JPRB,.795E-03_JPRB,.836E-03_JPRB,.836E-03_JPRB,.919E-03_JPRB,.919E-03_JPRB,&
&.113E-02_JPRB,.113E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 42 -74.0
ZAER (:,42, 1) = (/&
&.558E-03_JPRB,.558E-03_JPRB,.601E-03_JPRB,.601E-03_JPRB,.655E-03_JPRB,.655E-03_JPRB,.684E-03_JPRB,&
&.684E-03_JPRB,.648E-03_JPRB,.648E-03_JPRB,.567E-03_JPRB,.567E-03_JPRB,.516E-03_JPRB,.516E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.401E-03_JPRB,.401E-03_JPRB,.362E-03_JPRB,&
&.362E-03_JPRB,.331E-03_JPRB,.331E-03_JPRB,.511E-03_JPRB,.511E-03_JPRB,.939E-03_JPRB,.939E-03_JPRB,&
&.112E-02_JPRB,.112E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.214E-02_JPRB,&
&.214E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,&
&.562E-02_JPRB,.562E-02_JPRB,.325E-02_JPRB,.325E-02_JPRB,.173E-02_JPRB,.173E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.859E-03_JPRB,.859E-03_JPRB,.691E-03_JPRB,.691E-03_JPRB,&
&.560E-03_JPRB,.560E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,.671E-03_JPRB,&
&.671E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.659E-03_JPRB,.659E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,&
&.541E-03_JPRB,.541E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 43 -78.0
ZAER (:,43, 1) = (/&
&.558E-03_JPRB,.558E-03_JPRB,.601E-03_JPRB,.601E-03_JPRB,.655E-03_JPRB,.655E-03_JPRB,.684E-03_JPRB,&
&.684E-03_JPRB,.648E-03_JPRB,.648E-03_JPRB,.567E-03_JPRB,.567E-03_JPRB,.516E-03_JPRB,.516E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.401E-03_JPRB,.401E-03_JPRB,.362E-03_JPRB,&
&.362E-03_JPRB,.331E-03_JPRB,.331E-03_JPRB,.511E-03_JPRB,.511E-03_JPRB,.939E-03_JPRB,.939E-03_JPRB,&
&.112E-02_JPRB,.112E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.214E-02_JPRB,&
&.214E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,&
&.562E-02_JPRB,.562E-02_JPRB,.325E-02_JPRB,.325E-02_JPRB,.173E-02_JPRB,.173E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.859E-03_JPRB,.859E-03_JPRB,.691E-03_JPRB,.691E-03_JPRB,&
&.560E-03_JPRB,.560E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,.671E-03_JPRB,&
&.671E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.659E-03_JPRB,.659E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,&
&.541E-03_JPRB,.541E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 44 -82.0
ZAER (:,44, 1) = (/&
&.559E-03_JPRB,.559E-03_JPRB,.545E-03_JPRB,.545E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.463E-03_JPRB,&
&.463E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,&
&.409E-03_JPRB,.409E-03_JPRB,.415E-03_JPRB,.415E-03_JPRB,.421E-03_JPRB,.421E-03_JPRB,.409E-03_JPRB,&
&.409E-03_JPRB,.406E-03_JPRB,.406E-03_JPRB,.436E-03_JPRB,.436E-03_JPRB,.530E-03_JPRB,.530E-03_JPRB,&
&.649E-03_JPRB,.649E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.786E-03_JPRB,.786E-03_JPRB,.893E-03_JPRB,&
&.893E-03_JPRB,.110E-02_JPRB,.110E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,&
&.995E-03_JPRB,.995E-03_JPRB,.880E-03_JPRB,.880E-03_JPRB,.779E-03_JPRB,.779E-03_JPRB,.686E-03_JPRB,&
&.686E-03_JPRB,.605E-03_JPRB,.605E-03_JPRB,.529E-03_JPRB,.529E-03_JPRB,.479E-03_JPRB,.479E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,.494E-03_JPRB,.494E-03_JPRB,.538E-03_JPRB,&
&.538E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.611E-03_JPRB,.611E-03_JPRB,.592E-03_JPRB,.592E-03_JPRB,&
&.571E-03_JPRB,.571E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 45 -86.0
ZAER (:,45, 1) = (/&
&.559E-03_JPRB,.559E-03_JPRB,.545E-03_JPRB,.545E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.463E-03_JPRB,&
&.463E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,&
&.409E-03_JPRB,.409E-03_JPRB,.415E-03_JPRB,.415E-03_JPRB,.421E-03_JPRB,.421E-03_JPRB,.409E-03_JPRB,&
&.409E-03_JPRB,.406E-03_JPRB,.406E-03_JPRB,.436E-03_JPRB,.436E-03_JPRB,.530E-03_JPRB,.530E-03_JPRB,&
&.649E-03_JPRB,.649E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.786E-03_JPRB,.786E-03_JPRB,.893E-03_JPRB,&
&.893E-03_JPRB,.110E-02_JPRB,.110E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,&
&.995E-03_JPRB,.995E-03_JPRB,.880E-03_JPRB,.880E-03_JPRB,.779E-03_JPRB,.779E-03_JPRB,.686E-03_JPRB,&
&.686E-03_JPRB,.605E-03_JPRB,.605E-03_JPRB,.529E-03_JPRB,.529E-03_JPRB,.479E-03_JPRB,.479E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,.494E-03_JPRB,.494E-03_JPRB,.538E-03_JPRB,&
&.538E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.611E-03_JPRB,.611E-03_JPRB,.592E-03_JPRB,.592E-03_JPRB,&
&.571E-03_JPRB,.571E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 46 -90.0
ZAER (:,46, 1) = (/&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB/)

!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=1   
  DO JI=1,46
    DO JL=1,72
      RAERSS(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SEA-SALT AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESS_01
