SUBROUTINE SUECAESD_07

!**   OPTICAL THICKNESS OF AEROSOLS OF SOIL-DUST ORIGIN
!                                      July

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESD* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSD


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,7:7)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Total Soil Dust Aerosol  month:  7 --- lat:  1  90.0
ZAER (:, 1, 7) = (/&
&.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat:  2  86.0
ZAER (:, 2, 7) = (/&
&.120E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.118E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.117E-02_JPRB,.118E-02_JPRB,.119E-02_JPRB,.121E-02_JPRB,.122E-02_JPRB,.123E-02_JPRB,&
&.124E-02_JPRB,.126E-02_JPRB,.127E-02_JPRB,.128E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.128E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,&
&.129E-02_JPRB,.129E-02_JPRB,.128E-02_JPRB,.126E-02_JPRB,.125E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.122E-02_JPRB,.121E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.119E-02_JPRB,.118E-02_JPRB,.117E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,&
&.117E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.117E-02_JPRB,.117E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat:  3  82.0
ZAER (:, 3, 7) = (/&
&.105E-02_JPRB,.104E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,&
&.105E-02_JPRB,.107E-02_JPRB,.109E-02_JPRB,.112E-02_JPRB,.116E-02_JPRB,.121E-02_JPRB,.126E-02_JPRB,&
&.129E-02_JPRB,.133E-02_JPRB,.136E-02_JPRB,.139E-02_JPRB,.141E-02_JPRB,.142E-02_JPRB,.140E-02_JPRB,&
&.137E-02_JPRB,.135E-02_JPRB,.133E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.134E-02_JPRB,.135E-02_JPRB,&
&.137E-02_JPRB,.139E-02_JPRB,.141E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.141E-02_JPRB,.139E-02_JPRB,&
&.136E-02_JPRB,.132E-02_JPRB,.127E-02_JPRB,.124E-02_JPRB,.121E-02_JPRB,.118E-02_JPRB,.116E-02_JPRB,&
&.114E-02_JPRB,.114E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.115E-02_JPRB,&
&.115E-02_JPRB,.115E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.116E-02_JPRB,.115E-02_JPRB,.114E-02_JPRB,&
&.113E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.113E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.114E-02_JPRB,.113E-02_JPRB,.112E-02_JPRB,&
&.110E-02_JPRB,.107E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat:  4  78.0
ZAER (:, 4, 7) = (/&
&.109E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.108E-02_JPRB,.109E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.111E-02_JPRB,.115E-02_JPRB,.121E-02_JPRB,.127E-02_JPRB,&
&.131E-02_JPRB,.135E-02_JPRB,.139E-02_JPRB,.142E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.144E-02_JPRB,&
&.143E-02_JPRB,.142E-02_JPRB,.139E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.141E-02_JPRB,.145E-02_JPRB,&
&.148E-02_JPRB,.151E-02_JPRB,.152E-02_JPRB,.155E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.153E-02_JPRB,&
&.147E-02_JPRB,.141E-02_JPRB,.134E-02_JPRB,.127E-02_JPRB,.121E-02_JPRB,.117E-02_JPRB,.116E-02_JPRB,&
&.117E-02_JPRB,.118E-02_JPRB,.120E-02_JPRB,.121E-02_JPRB,.121E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.121E-02_JPRB,.122E-02_JPRB,.121E-02_JPRB,.118E-02_JPRB,.117E-02_JPRB,.115E-02_JPRB,.114E-02_JPRB,&
&.115E-02_JPRB,.115E-02_JPRB,.116E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.114E-02_JPRB,.113E-02_JPRB,.111E-02_JPRB,.109E-02_JPRB,.106E-02_JPRB,&
&.106E-02_JPRB,.107E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat:  5  74.0
ZAER (:, 5, 7) = (/&
&.115E-02_JPRB,.119E-02_JPRB,.121E-02_JPRB,.123E-02_JPRB,.130E-02_JPRB,.134E-02_JPRB,.131E-02_JPRB,&
&.125E-02_JPRB,.121E-02_JPRB,.119E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.119E-02_JPRB,.121E-02_JPRB,&
&.123E-02_JPRB,.125E-02_JPRB,.129E-02_JPRB,.134E-02_JPRB,.140E-02_JPRB,.142E-02_JPRB,.140E-02_JPRB,&
&.140E-02_JPRB,.144E-02_JPRB,.148E-02_JPRB,.152E-02_JPRB,.158E-02_JPRB,.164E-02_JPRB,.168E-02_JPRB,&
&.171E-02_JPRB,.173E-02_JPRB,.169E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.167E-02_JPRB,.166E-02_JPRB,&
&.161E-02_JPRB,.153E-02_JPRB,.142E-02_JPRB,.130E-02_JPRB,.124E-02_JPRB,.123E-02_JPRB,.127E-02_JPRB,&
&.132E-02_JPRB,.136E-02_JPRB,.139E-02_JPRB,.141E-02_JPRB,.140E-02_JPRB,.136E-02_JPRB,.131E-02_JPRB,&
&.127E-02_JPRB,.128E-02_JPRB,.130E-02_JPRB,.127E-02_JPRB,.124E-02_JPRB,.122E-02_JPRB,.120E-02_JPRB,&
&.121E-02_JPRB,.121E-02_JPRB,.120E-02_JPRB,.119E-02_JPRB,.118E-02_JPRB,.119E-02_JPRB,.120E-02_JPRB,&
&.119E-02_JPRB,.118E-02_JPRB,.116E-02_JPRB,.113E-02_JPRB,.109E-02_JPRB,.105E-02_JPRB,.104E-02_JPRB,&
&.106E-02_JPRB,.110E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat:  6  70.0
ZAER (:, 6, 7) = (/&
&.135E-02_JPRB,.136E-02_JPRB,.135E-02_JPRB,.136E-02_JPRB,.149E-02_JPRB,.165E-02_JPRB,.172E-02_JPRB,&
&.162E-02_JPRB,.147E-02_JPRB,.141E-02_JPRB,.139E-02_JPRB,.137E-02_JPRB,.130E-02_JPRB,.125E-02_JPRB,&
&.121E-02_JPRB,.120E-02_JPRB,.121E-02_JPRB,.126E-02_JPRB,.135E-02_JPRB,.139E-02_JPRB,.140E-02_JPRB,&
&.143E-02_JPRB,.153E-02_JPRB,.166E-02_JPRB,.170E-02_JPRB,.173E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,&
&.179E-02_JPRB,.181E-02_JPRB,.180E-02_JPRB,.179E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.174E-02_JPRB,&
&.169E-02_JPRB,.162E-02_JPRB,.148E-02_JPRB,.135E-02_JPRB,.131E-02_JPRB,.133E-02_JPRB,.140E-02_JPRB,&
&.147E-02_JPRB,.151E-02_JPRB,.157E-02_JPRB,.163E-02_JPRB,.167E-02_JPRB,.165E-02_JPRB,.156E-02_JPRB,&
&.145E-02_JPRB,.140E-02_JPRB,.142E-02_JPRB,.141E-02_JPRB,.138E-02_JPRB,.135E-02_JPRB,.132E-02_JPRB,&
&.129E-02_JPRB,.125E-02_JPRB,.122E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.121E-02_JPRB,.123E-02_JPRB,&
&.123E-02_JPRB,.122E-02_JPRB,.118E-02_JPRB,.113E-02_JPRB,.107E-02_JPRB,.105E-02_JPRB,.107E-02_JPRB,&
&.118E-02_JPRB,.130E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat:  7  66.0
ZAER (:, 7, 7) = (/&
&.188E-02_JPRB,.175E-02_JPRB,.165E-02_JPRB,.162E-02_JPRB,.168E-02_JPRB,.185E-02_JPRB,.197E-02_JPRB,&
&.199E-02_JPRB,.183E-02_JPRB,.171E-02_JPRB,.164E-02_JPRB,.155E-02_JPRB,.145E-02_JPRB,.137E-02_JPRB,&
&.134E-02_JPRB,.131E-02_JPRB,.126E-02_JPRB,.125E-02_JPRB,.128E-02_JPRB,.131E-02_JPRB,.137E-02_JPRB,&
&.140E-02_JPRB,.153E-02_JPRB,.181E-02_JPRB,.201E-02_JPRB,.193E-02_JPRB,.176E-02_JPRB,.173E-02_JPRB,&
&.172E-02_JPRB,.175E-02_JPRB,.180E-02_JPRB,.185E-02_JPRB,.179E-02_JPRB,.176E-02_JPRB,.179E-02_JPRB,&
&.178E-02_JPRB,.171E-02_JPRB,.162E-02_JPRB,.153E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.155E-02_JPRB,&
&.163E-02_JPRB,.163E-02_JPRB,.168E-02_JPRB,.181E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.179E-02_JPRB,&
&.170E-02_JPRB,.162E-02_JPRB,.157E-02_JPRB,.155E-02_JPRB,.150E-02_JPRB,.146E-02_JPRB,.139E-02_JPRB,&
&.134E-02_JPRB,.129E-02_JPRB,.123E-02_JPRB,.119E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.120E-02_JPRB,&
&.127E-02_JPRB,.132E-02_JPRB,.133E-02_JPRB,.135E-02_JPRB,.146E-02_JPRB,.162E-02_JPRB,.177E-02_JPRB,&
&.193E-02_JPRB,.197E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat:  8  62.0
ZAER (:, 8, 7) = (/&
&.264E-02_JPRB,.243E-02_JPRB,.226E-02_JPRB,.218E-02_JPRB,.215E-02_JPRB,.228E-02_JPRB,.242E-02_JPRB,&
&.253E-02_JPRB,.246E-02_JPRB,.224E-02_JPRB,.210E-02_JPRB,.195E-02_JPRB,.179E-02_JPRB,.168E-02_JPRB,&
&.160E-02_JPRB,.152E-02_JPRB,.147E-02_JPRB,.141E-02_JPRB,.134E-02_JPRB,.133E-02_JPRB,.136E-02_JPRB,&
&.140E-02_JPRB,.149E-02_JPRB,.193E-02_JPRB,.251E-02_JPRB,.249E-02_JPRB,.211E-02_JPRB,.196E-02_JPRB,&
&.189E-02_JPRB,.192E-02_JPRB,.195E-02_JPRB,.192E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.186E-02_JPRB,&
&.192E-02_JPRB,.189E-02_JPRB,.188E-02_JPRB,.184E-02_JPRB,.180E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,&
&.187E-02_JPRB,.181E-02_JPRB,.186E-02_JPRB,.201E-02_JPRB,.213E-02_JPRB,.216E-02_JPRB,.208E-02_JPRB,&
&.198E-02_JPRB,.189E-02_JPRB,.182E-02_JPRB,.178E-02_JPRB,.168E-02_JPRB,.159E-02_JPRB,.149E-02_JPRB,&
&.143E-02_JPRB,.138E-02_JPRB,.130E-02_JPRB,.123E-02_JPRB,.118E-02_JPRB,.115E-02_JPRB,.119E-02_JPRB,&
&.130E-02_JPRB,.148E-02_JPRB,.180E-02_JPRB,.249E-02_JPRB,.308E-02_JPRB,.321E-02_JPRB,.313E-02_JPRB,&
&.298E-02_JPRB,.285E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat:  9  58.0
ZAER (:, 9, 7) = (/&
&.423E-02_JPRB,.391E-02_JPRB,.368E-02_JPRB,.341E-02_JPRB,.316E-02_JPRB,.308E-02_JPRB,.299E-02_JPRB,&
&.284E-02_JPRB,.273E-02_JPRB,.260E-02_JPRB,.254E-02_JPRB,.246E-02_JPRB,.236E-02_JPRB,.229E-02_JPRB,&
&.218E-02_JPRB,.205E-02_JPRB,.194E-02_JPRB,.177E-02_JPRB,.164E-02_JPRB,.157E-02_JPRB,.153E-02_JPRB,&
&.158E-02_JPRB,.180E-02_JPRB,.234E-02_JPRB,.324E-02_JPRB,.327E-02_JPRB,.275E-02_JPRB,.261E-02_JPRB,&
&.246E-02_JPRB,.242E-02_JPRB,.240E-02_JPRB,.248E-02_JPRB,.260E-02_JPRB,.273E-02_JPRB,.265E-02_JPRB,&
&.243E-02_JPRB,.232E-02_JPRB,.232E-02_JPRB,.238E-02_JPRB,.234E-02_JPRB,.225E-02_JPRB,.216E-02_JPRB,&
&.219E-02_JPRB,.209E-02_JPRB,.204E-02_JPRB,.214E-02_JPRB,.226E-02_JPRB,.231E-02_JPRB,.230E-02_JPRB,&
&.228E-02_JPRB,.222E-02_JPRB,.214E-02_JPRB,.210E-02_JPRB,.202E-02_JPRB,.194E-02_JPRB,.185E-02_JPRB,&
&.177E-02_JPRB,.172E-02_JPRB,.165E-02_JPRB,.153E-02_JPRB,.142E-02_JPRB,.138E-02_JPRB,.141E-02_JPRB,&
&.157E-02_JPRB,.195E-02_JPRB,.270E-02_JPRB,.428E-02_JPRB,.529E-02_JPRB,.547E-02_JPRB,.529E-02_JPRB,&
&.496E-02_JPRB,.460E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 10  54.0
ZAER (:,10, 7) = (/&
&.597E-02_JPRB,.544E-02_JPRB,.516E-02_JPRB,.464E-02_JPRB,.412E-02_JPRB,.352E-02_JPRB,.316E-02_JPRB,&
&.316E-02_JPRB,.324E-02_JPRB,.316E-02_JPRB,.310E-02_JPRB,.304E-02_JPRB,.296E-02_JPRB,.290E-02_JPRB,&
&.275E-02_JPRB,.264E-02_JPRB,.253E-02_JPRB,.243E-02_JPRB,.232E-02_JPRB,.222E-02_JPRB,.210E-02_JPRB,&
&.210E-02_JPRB,.234E-02_JPRB,.304E-02_JPRB,.493E-02_JPRB,.473E-02_JPRB,.403E-02_JPRB,.360E-02_JPRB,&
&.312E-02_JPRB,.301E-02_JPRB,.298E-02_JPRB,.382E-02_JPRB,.386E-02_JPRB,.362E-02_JPRB,.319E-02_JPRB,&
&.303E-02_JPRB,.299E-02_JPRB,.302E-02_JPRB,.300E-02_JPRB,.290E-02_JPRB,.280E-02_JPRB,.268E-02_JPRB,&
&.262E-02_JPRB,.246E-02_JPRB,.225E-02_JPRB,.223E-02_JPRB,.228E-02_JPRB,.231E-02_JPRB,.243E-02_JPRB,&
&.255E-02_JPRB,.258E-02_JPRB,.248E-02_JPRB,.241E-02_JPRB,.235E-02_JPRB,.232E-02_JPRB,.230E-02_JPRB,&
&.223E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.211E-02_JPRB,.200E-02_JPRB,.195E-02_JPRB,.204E-02_JPRB,&
&.214E-02_JPRB,.290E-02_JPRB,.499E-02_JPRB,.856E-02_JPRB,.994E-02_JPRB,.941E-02_JPRB,.861E-02_JPRB,&
&.782E-02_JPRB,.684E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 11  50.0
ZAER (:,11, 7) = (/&
&.773E-02_JPRB,.677E-02_JPRB,.601E-02_JPRB,.540E-02_JPRB,.494E-02_JPRB,.403E-02_JPRB,.360E-02_JPRB,&
&.369E-02_JPRB,.381E-02_JPRB,.380E-02_JPRB,.373E-02_JPRB,.355E-02_JPRB,.344E-02_JPRB,.339E-02_JPRB,&
&.335E-02_JPRB,.332E-02_JPRB,.330E-02_JPRB,.325E-02_JPRB,.312E-02_JPRB,.298E-02_JPRB,.286E-02_JPRB,&
&.280E-02_JPRB,.428E-02_JPRB,.807E-02_JPRB,.910E-02_JPRB,.719E-02_JPRB,.727E-02_JPRB,.565E-02_JPRB,&
&.422E-02_JPRB,.385E-02_JPRB,.365E-02_JPRB,.381E-02_JPRB,.437E-02_JPRB,.423E-02_JPRB,.365E-02_JPRB,&
&.370E-02_JPRB,.377E-02_JPRB,.373E-02_JPRB,.372E-02_JPRB,.368E-02_JPRB,.347E-02_JPRB,.329E-02_JPRB,&
&.312E-02_JPRB,.287E-02_JPRB,.265E-02_JPRB,.256E-02_JPRB,.263E-02_JPRB,.275E-02_JPRB,.295E-02_JPRB,&
&.315E-02_JPRB,.324E-02_JPRB,.313E-02_JPRB,.299E-02_JPRB,.287E-02_JPRB,.277E-02_JPRB,.271E-02_JPRB,&
&.273E-02_JPRB,.300E-02_JPRB,.313E-02_JPRB,.307E-02_JPRB,.283E-02_JPRB,.287E-02_JPRB,.285E-02_JPRB,&
&.304E-02_JPRB,.582E-02_JPRB,.107E-01_JPRB,.134E-01_JPRB,.115E-01_JPRB,.878E-02_JPRB,.939E-02_JPRB,&
&.104E-01_JPRB,.913E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 12  46.0
ZAER (:,12, 7) = (/&
&.847E-02_JPRB,.748E-02_JPRB,.685E-02_JPRB,.628E-02_JPRB,.562E-02_JPRB,.484E-02_JPRB,.429E-02_JPRB,&
&.420E-02_JPRB,.427E-02_JPRB,.398E-02_JPRB,.369E-02_JPRB,.353E-02_JPRB,.343E-02_JPRB,.346E-02_JPRB,&
&.355E-02_JPRB,.358E-02_JPRB,.360E-02_JPRB,.359E-02_JPRB,.358E-02_JPRB,.355E-02_JPRB,.347E-02_JPRB,&
&.348E-02_JPRB,.496E-02_JPRB,.197E-01_JPRB,.218E-01_JPRB,.134E-01_JPRB,.106E-01_JPRB,.726E-02_JPRB,&
&.493E-02_JPRB,.422E-02_JPRB,.398E-02_JPRB,.377E-02_JPRB,.395E-02_JPRB,.429E-02_JPRB,.445E-02_JPRB,&
&.439E-02_JPRB,.420E-02_JPRB,.404E-02_JPRB,.415E-02_JPRB,.430E-02_JPRB,.423E-02_JPRB,.418E-02_JPRB,&
&.388E-02_JPRB,.357E-02_JPRB,.346E-02_JPRB,.355E-02_JPRB,.392E-02_JPRB,.401E-02_JPRB,.388E-02_JPRB,&
&.386E-02_JPRB,.388E-02_JPRB,.380E-02_JPRB,.363E-02_JPRB,.345E-02_JPRB,.331E-02_JPRB,.322E-02_JPRB,&
&.361E-02_JPRB,.528E-02_JPRB,.683E-02_JPRB,.558E-02_JPRB,.457E-02_JPRB,.443E-02_JPRB,.415E-02_JPRB,&
&.623E-02_JPRB,.124E-01_JPRB,.156E-01_JPRB,.128E-01_JPRB,.907E-02_JPRB,.920E-02_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.982E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 13  42.0
ZAER (:,13, 7) = (/&
&.818E-02_JPRB,.765E-02_JPRB,.759E-02_JPRB,.726E-02_JPRB,.651E-02_JPRB,.581E-02_JPRB,.530E-02_JPRB,&
&.505E-02_JPRB,.492E-02_JPRB,.449E-02_JPRB,.418E-02_JPRB,.404E-02_JPRB,.380E-02_JPRB,.373E-02_JPRB,&
&.379E-02_JPRB,.380E-02_JPRB,.371E-02_JPRB,.360E-02_JPRB,.363E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,&
&.386E-02_JPRB,.727E-02_JPRB,.382E-01_JPRB,.373E-01_JPRB,.183E-01_JPRB,.114E-01_JPRB,.832E-02_JPRB,&
&.623E-02_JPRB,.514E-02_JPRB,.465E-02_JPRB,.439E-02_JPRB,.446E-02_JPRB,.478E-02_JPRB,.498E-02_JPRB,&
&.479E-02_JPRB,.448E-02_JPRB,.436E-02_JPRB,.464E-02_JPRB,.459E-02_JPRB,.486E-02_JPRB,.522E-02_JPRB,&
&.523E-02_JPRB,.520E-02_JPRB,.533E-02_JPRB,.559E-02_JPRB,.559E-02_JPRB,.512E-02_JPRB,.478E-02_JPRB,&
&.465E-02_JPRB,.461E-02_JPRB,.454E-02_JPRB,.443E-02_JPRB,.418E-02_JPRB,.397E-02_JPRB,.408E-02_JPRB,&
&.564E-02_JPRB,.111E-01_JPRB,.179E-01_JPRB,.188E-01_JPRB,.141E-01_JPRB,.101E-01_JPRB,.920E-02_JPRB,&
&.156E-01_JPRB,.199E-01_JPRB,.165E-01_JPRB,.112E-01_JPRB,.924E-02_JPRB,.106E-01_JPRB,.123E-01_JPRB,&
&.113E-01_JPRB,.942E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 14  38.0
ZAER (:,14, 7) = (/&
&.906E-02_JPRB,.887E-02_JPRB,.891E-02_JPRB,.856E-02_JPRB,.796E-02_JPRB,.733E-02_JPRB,.677E-02_JPRB,&
&.635E-02_JPRB,.600E-02_JPRB,.563E-02_JPRB,.525E-02_JPRB,.487E-02_JPRB,.465E-02_JPRB,.455E-02_JPRB,&
&.441E-02_JPRB,.420E-02_JPRB,.403E-02_JPRB,.398E-02_JPRB,.398E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,&
&.401E-02_JPRB,.612E-02_JPRB,.291E-01_JPRB,.336E-01_JPRB,.186E-01_JPRB,.117E-01_JPRB,.926E-02_JPRB,&
&.783E-02_JPRB,.673E-02_JPRB,.606E-02_JPRB,.570E-02_JPRB,.551E-02_JPRB,.543E-02_JPRB,.523E-02_JPRB,&
&.481E-02_JPRB,.465E-02_JPRB,.481E-02_JPRB,.556E-02_JPRB,.584E-02_JPRB,.700E-02_JPRB,.680E-02_JPRB,&
&.749E-02_JPRB,.799E-02_JPRB,.800E-02_JPRB,.724E-02_JPRB,.609E-02_JPRB,.546E-02_JPRB,.544E-02_JPRB,&
&.551E-02_JPRB,.553E-02_JPRB,.544E-02_JPRB,.540E-02_JPRB,.519E-02_JPRB,.493E-02_JPRB,.537E-02_JPRB,&
&.792E-02_JPRB,.154E-01_JPRB,.243E-01_JPRB,.280E-01_JPRB,.299E-01_JPRB,.263E-01_JPRB,.290E-01_JPRB,&
&.355E-01_JPRB,.326E-01_JPRB,.259E-01_JPRB,.187E-01_JPRB,.147E-01_JPRB,.128E-01_JPRB,.123E-01_JPRB,&
&.107E-01_JPRB,.914E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 15  34.0
ZAER (:,15, 7) = (/&
&.120E-01_JPRB,.115E-01_JPRB,.112E-01_JPRB,.106E-01_JPRB,.960E-02_JPRB,.879E-02_JPRB,.809E-02_JPRB,&
&.762E-02_JPRB,.722E-02_JPRB,.687E-02_JPRB,.645E-02_JPRB,.613E-02_JPRB,.605E-02_JPRB,.591E-02_JPRB,&
&.558E-02_JPRB,.528E-02_JPRB,.510E-02_JPRB,.501E-02_JPRB,.483E-02_JPRB,.463E-02_JPRB,.462E-02_JPRB,&
&.475E-02_JPRB,.686E-02_JPRB,.130E-01_JPRB,.181E-01_JPRB,.144E-01_JPRB,.112E-01_JPRB,.955E-02_JPRB,&
&.852E-02_JPRB,.782E-02_JPRB,.746E-02_JPRB,.690E-02_JPRB,.635E-02_JPRB,.629E-02_JPRB,.598E-02_JPRB,&
&.544E-02_JPRB,.523E-02_JPRB,.594E-02_JPRB,.880E-02_JPRB,.119E-01_JPRB,.151E-01_JPRB,.166E-01_JPRB,&
&.149E-01_JPRB,.122E-01_JPRB,.989E-02_JPRB,.797E-02_JPRB,.688E-02_JPRB,.647E-02_JPRB,.655E-02_JPRB,&
&.671E-02_JPRB,.698E-02_JPRB,.719E-02_JPRB,.705E-02_JPRB,.662E-02_JPRB,.647E-02_JPRB,.721E-02_JPRB,&
&.885E-02_JPRB,.174E-01_JPRB,.229E-01_JPRB,.282E-01_JPRB,.418E-01_JPRB,.609E-01_JPRB,.980E-01_JPRB,&
&.113E+00_JPRB,.939E-01_JPRB,.558E-01_JPRB,.356E-01_JPRB,.266E-01_JPRB,.214E-01_JPRB,.183E-01_JPRB,&
&.155E-01_JPRB,.130E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 16  30.0
ZAER (:,16, 7) = (/&
&.162E-01_JPRB,.152E-01_JPRB,.138E-01_JPRB,.124E-01_JPRB,.112E-01_JPRB,.103E-01_JPRB,.958E-02_JPRB,&
&.901E-02_JPRB,.857E-02_JPRB,.831E-02_JPRB,.804E-02_JPRB,.763E-02_JPRB,.725E-02_JPRB,.686E-02_JPRB,&
&.642E-02_JPRB,.615E-02_JPRB,.597E-02_JPRB,.570E-02_JPRB,.547E-02_JPRB,.536E-02_JPRB,.539E-02_JPRB,&
&.631E-02_JPRB,.116E-01_JPRB,.133E-01_JPRB,.115E-01_JPRB,.109E-01_JPRB,.933E-02_JPRB,.826E-02_JPRB,&
&.806E-02_JPRB,.815E-02_JPRB,.812E-02_JPRB,.791E-02_JPRB,.761E-02_JPRB,.741E-02_JPRB,.699E-02_JPRB,&
&.628E-02_JPRB,.623E-02_JPRB,.807E-02_JPRB,.137E-01_JPRB,.224E-01_JPRB,.341E-01_JPRB,.307E-01_JPRB,&
&.216E-01_JPRB,.158E-01_JPRB,.119E-01_JPRB,.945E-02_JPRB,.824E-02_JPRB,.802E-02_JPRB,.844E-02_JPRB,&
&.922E-02_JPRB,.100E-01_JPRB,.104E-01_JPRB,.995E-02_JPRB,.930E-02_JPRB,.925E-02_JPRB,.990E-02_JPRB,&
&.107E-01_JPRB,.210E-01_JPRB,.301E-01_JPRB,.422E-01_JPRB,.656E-01_JPRB,.963E-01_JPRB,.192E+00_JPRB,&
&.222E+00_JPRB,.140E+00_JPRB,.665E-01_JPRB,.427E-01_JPRB,.341E-01_JPRB,.289E-01_JPRB,.247E-01_JPRB,&
&.208E-01_JPRB,.179E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 17  26.0
ZAER (:,17, 7) = (/&
&.179E-01_JPRB,.164E-01_JPRB,.153E-01_JPRB,.143E-01_JPRB,.129E-01_JPRB,.118E-01_JPRB,.112E-01_JPRB,&
&.106E-01_JPRB,.997E-02_JPRB,.917E-02_JPRB,.817E-02_JPRB,.707E-02_JPRB,.654E-02_JPRB,.636E-02_JPRB,&
&.625E-02_JPRB,.619E-02_JPRB,.604E-02_JPRB,.575E-02_JPRB,.563E-02_JPRB,.568E-02_JPRB,.602E-02_JPRB,&
&.741E-02_JPRB,.131E-01_JPRB,.172E-01_JPRB,.146E-01_JPRB,.119E-01_JPRB,.104E-01_JPRB,.922E-02_JPRB,&
&.852E-02_JPRB,.843E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.816E-02_JPRB,.773E-02_JPRB,.709E-02_JPRB,&
&.653E-02_JPRB,.726E-02_JPRB,.991E-02_JPRB,.150E-01_JPRB,.256E-01_JPRB,.387E-01_JPRB,.338E-01_JPRB,&
&.265E-01_JPRB,.202E-01_JPRB,.149E-01_JPRB,.128E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.123E-01_JPRB,&
&.128E-01_JPRB,.132E-01_JPRB,.134E-01_JPRB,.132E-01_JPRB,.127E-01_JPRB,.124E-01_JPRB,.129E-01_JPRB,&
&.140E-01_JPRB,.251E-01_JPRB,.429E-01_JPRB,.728E-01_JPRB,.109E+00_JPRB,.125E+00_JPRB,.159E+00_JPRB,&
&.154E+00_JPRB,.853E-01_JPRB,.508E-01_JPRB,.355E-01_JPRB,.291E-01_JPRB,.256E-01_JPRB,.236E-01_JPRB,&
&.215E-01_JPRB,.197E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 18  22.0
ZAER (:,18, 7) = (/&
&.160E-01_JPRB,.150E-01_JPRB,.140E-01_JPRB,.126E-01_JPRB,.112E-01_JPRB,.100E-01_JPRB,.942E-02_JPRB,&
&.888E-02_JPRB,.814E-02_JPRB,.720E-02_JPRB,.636E-02_JPRB,.571E-02_JPRB,.554E-02_JPRB,.566E-02_JPRB,&
&.587E-02_JPRB,.603E-02_JPRB,.599E-02_JPRB,.577E-02_JPRB,.570E-02_JPRB,.583E-02_JPRB,.632E-02_JPRB,&
&.798E-02_JPRB,.124E-01_JPRB,.187E-01_JPRB,.253E-01_JPRB,.144E-01_JPRB,.113E-01_JPRB,.102E-01_JPRB,&
&.914E-02_JPRB,.882E-02_JPRB,.884E-02_JPRB,.868E-02_JPRB,.830E-02_JPRB,.795E-02_JPRB,.764E-02_JPRB,&
&.784E-02_JPRB,.939E-02_JPRB,.119E-01_JPRB,.160E-01_JPRB,.274E-01_JPRB,.365E-01_JPRB,.349E-01_JPRB,&
&.291E-01_JPRB,.243E-01_JPRB,.211E-01_JPRB,.250E-01_JPRB,.194E-01_JPRB,.175E-01_JPRB,.173E-01_JPRB,&
&.167E-01_JPRB,.160E-01_JPRB,.157E-01_JPRB,.158E-01_JPRB,.155E-01_JPRB,.149E-01_JPRB,.155E-01_JPRB,&
&.207E-01_JPRB,.343E-01_JPRB,.513E-01_JPRB,.755E-01_JPRB,.841E-01_JPRB,.789E-01_JPRB,.912E-01_JPRB,&
&.776E-01_JPRB,.520E-01_JPRB,.389E-01_JPRB,.293E-01_JPRB,.216E-01_JPRB,.188E-01_JPRB,.180E-01_JPRB,&
&.175E-01_JPRB,.168E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 19  18.0
ZAER (:,19, 7) = (/&
&.124E-01_JPRB,.115E-01_JPRB,.104E-01_JPRB,.898E-02_JPRB,.779E-02_JPRB,.691E-02_JPRB,.635E-02_JPRB,&
&.598E-02_JPRB,.557E-02_JPRB,.529E-02_JPRB,.511E-02_JPRB,.500E-02_JPRB,.515E-02_JPRB,.543E-02_JPRB,&
&.577E-02_JPRB,.596E-02_JPRB,.605E-02_JPRB,.596E-02_JPRB,.587E-02_JPRB,.597E-02_JPRB,.640E-02_JPRB,&
&.801E-02_JPRB,.135E-01_JPRB,.229E-01_JPRB,.235E-01_JPRB,.133E-01_JPRB,.114E-01_JPRB,.105E-01_JPRB,&
&.960E-02_JPRB,.933E-02_JPRB,.911E-02_JPRB,.893E-02_JPRB,.891E-02_JPRB,.907E-02_JPRB,.951E-02_JPRB,&
&.105E-01_JPRB,.123E-01_JPRB,.152E-01_JPRB,.211E-01_JPRB,.274E-01_JPRB,.311E-01_JPRB,.329E-01_JPRB,&
&.312E-01_JPRB,.292E-01_JPRB,.347E-01_JPRB,.391E-01_JPRB,.269E-01_JPRB,.231E-01_JPRB,.210E-01_JPRB,&
&.192E-01_JPRB,.181E-01_JPRB,.173E-01_JPRB,.170E-01_JPRB,.169E-01_JPRB,.175E-01_JPRB,.206E-01_JPRB,&
&.275E-01_JPRB,.342E-01_JPRB,.432E-01_JPRB,.513E-01_JPRB,.528E-01_JPRB,.544E-01_JPRB,.535E-01_JPRB,&
&.431E-01_JPRB,.326E-01_JPRB,.239E-01_JPRB,.194E-01_JPRB,.160E-01_JPRB,.145E-01_JPRB,.140E-01_JPRB,&
&.136E-01_JPRB,.131E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 20  14.0
ZAER (:,20, 7) = (/&
&.889E-02_JPRB,.831E-02_JPRB,.746E-02_JPRB,.633E-02_JPRB,.547E-02_JPRB,.490E-02_JPRB,.468E-02_JPRB,&
&.449E-02_JPRB,.444E-02_JPRB,.448E-02_JPRB,.456E-02_JPRB,.476E-02_JPRB,.521E-02_JPRB,.561E-02_JPRB,&
&.600E-02_JPRB,.621E-02_JPRB,.642E-02_JPRB,.662E-02_JPRB,.686E-02_JPRB,.714E-02_JPRB,.745E-02_JPRB,&
&.912E-02_JPRB,.170E-01_JPRB,.212E-01_JPRB,.143E-01_JPRB,.115E-01_JPRB,.112E-01_JPRB,.105E-01_JPRB,&
&.102E-01_JPRB,.107E-01_JPRB,.109E-01_JPRB,.111E-01_JPRB,.118E-01_JPRB,.128E-01_JPRB,.141E-01_JPRB,&
&.161E-01_JPRB,.186E-01_JPRB,.234E-01_JPRB,.289E-01_JPRB,.317E-01_JPRB,.335E-01_JPRB,.346E-01_JPRB,&
&.343E-01_JPRB,.370E-01_JPRB,.414E-01_JPRB,.353E-01_JPRB,.274E-01_JPRB,.232E-01_JPRB,.207E-01_JPRB,&
&.183E-01_JPRB,.168E-01_JPRB,.153E-01_JPRB,.147E-01_JPRB,.156E-01_JPRB,.172E-01_JPRB,.207E-01_JPRB,&
&.248E-01_JPRB,.278E-01_JPRB,.309E-01_JPRB,.315E-01_JPRB,.324E-01_JPRB,.323E-01_JPRB,.286E-01_JPRB,&
&.236E-01_JPRB,.183E-01_JPRB,.144E-01_JPRB,.119E-01_JPRB,.109E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,&
&.998E-02_JPRB,.922E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 21  10.0
ZAER (:,21, 7) = (/&
&.594E-02_JPRB,.558E-02_JPRB,.506E-02_JPRB,.452E-02_JPRB,.423E-02_JPRB,.419E-02_JPRB,.427E-02_JPRB,&
&.436E-02_JPRB,.449E-02_JPRB,.466E-02_JPRB,.490E-02_JPRB,.526E-02_JPRB,.567E-02_JPRB,.600E-02_JPRB,&
&.632E-02_JPRB,.670E-02_JPRB,.719E-02_JPRB,.769E-02_JPRB,.833E-02_JPRB,.908E-02_JPRB,.101E-01_JPRB,&
&.123E-01_JPRB,.144E-01_JPRB,.131E-01_JPRB,.107E-01_JPRB,.111E-01_JPRB,.116E-01_JPRB,.121E-01_JPRB,&
&.130E-01_JPRB,.145E-01_JPRB,.157E-01_JPRB,.166E-01_JPRB,.179E-01_JPRB,.195E-01_JPRB,.220E-01_JPRB,&
&.250E-01_JPRB,.281E-01_JPRB,.316E-01_JPRB,.357E-01_JPRB,.370E-01_JPRB,.380E-01_JPRB,.401E-01_JPRB,&
&.414E-01_JPRB,.410E-01_JPRB,.331E-01_JPRB,.248E-01_JPRB,.208E-01_JPRB,.180E-01_JPRB,.160E-01_JPRB,&
&.139E-01_JPRB,.125E-01_JPRB,.113E-01_JPRB,.104E-01_JPRB,.106E-01_JPRB,.120E-01_JPRB,.139E-01_JPRB,&
&.158E-01_JPRB,.177E-01_JPRB,.201E-01_JPRB,.201E-01_JPRB,.185E-01_JPRB,.156E-01_JPRB,.126E-01_JPRB,&
&.109E-01_JPRB,.951E-02_JPRB,.799E-02_JPRB,.690E-02_JPRB,.667E-02_JPRB,.627E-02_JPRB,.610E-02_JPRB,&
&.612E-02_JPRB,.593E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 22   6.0
ZAER (:,22, 7) = (/&
&.393E-02_JPRB,.389E-02_JPRB,.387E-02_JPRB,.389E-02_JPRB,.410E-02_JPRB,.435E-02_JPRB,.459E-02_JPRB,&
&.486E-02_JPRB,.515E-02_JPRB,.543E-02_JPRB,.564E-02_JPRB,.587E-02_JPRB,.609E-02_JPRB,.631E-02_JPRB,&
&.662E-02_JPRB,.699E-02_JPRB,.749E-02_JPRB,.796E-02_JPRB,.848E-02_JPRB,.896E-02_JPRB,.939E-02_JPRB,&
&.100E-01_JPRB,.104E-01_JPRB,.105E-01_JPRB,.115E-01_JPRB,.127E-01_JPRB,.140E-01_JPRB,.155E-01_JPRB,&
&.173E-01_JPRB,.192E-01_JPRB,.211E-01_JPRB,.229E-01_JPRB,.250E-01_JPRB,.277E-01_JPRB,.323E-01_JPRB,&
&.360E-01_JPRB,.399E-01_JPRB,.420E-01_JPRB,.438E-01_JPRB,.431E-01_JPRB,.425E-01_JPRB,.437E-01_JPRB,&
&.453E-01_JPRB,.360E-01_JPRB,.210E-01_JPRB,.163E-01_JPRB,.137E-01_JPRB,.112E-01_JPRB,.921E-02_JPRB,&
&.803E-02_JPRB,.723E-02_JPRB,.648E-02_JPRB,.612E-02_JPRB,.627E-02_JPRB,.664E-02_JPRB,.725E-02_JPRB,&
&.781E-02_JPRB,.840E-02_JPRB,.845E-02_JPRB,.764E-02_JPRB,.647E-02_JPRB,.478E-02_JPRB,.360E-02_JPRB,&
&.348E-02_JPRB,.354E-02_JPRB,.345E-02_JPRB,.346E-02_JPRB,.343E-02_JPRB,.332E-02_JPRB,.348E-02_JPRB,&
&.379E-02_JPRB,.390E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 23   2.0
ZAER (:,23, 7) = (/&
&.282E-02_JPRB,.301E-02_JPRB,.326E-02_JPRB,.356E-02_JPRB,.390E-02_JPRB,.424E-02_JPRB,.462E-02_JPRB,&
&.498E-02_JPRB,.527E-02_JPRB,.549E-02_JPRB,.563E-02_JPRB,.580E-02_JPRB,.601E-02_JPRB,.632E-02_JPRB,&
&.665E-02_JPRB,.695E-02_JPRB,.723E-02_JPRB,.767E-02_JPRB,.839E-02_JPRB,.886E-02_JPRB,.881E-02_JPRB,&
&.945E-02_JPRB,.102E-01_JPRB,.115E-01_JPRB,.132E-01_JPRB,.150E-01_JPRB,.167E-01_JPRB,.182E-01_JPRB,&
&.199E-01_JPRB,.220E-01_JPRB,.244E-01_JPRB,.266E-01_JPRB,.290E-01_JPRB,.322E-01_JPRB,.364E-01_JPRB,&
&.408E-01_JPRB,.464E-01_JPRB,.517E-01_JPRB,.558E-01_JPRB,.571E-01_JPRB,.590E-01_JPRB,.612E-01_JPRB,&
&.617E-01_JPRB,.511E-01_JPRB,.260E-01_JPRB,.119E-01_JPRB,.884E-02_JPRB,.658E-02_JPRB,.556E-02_JPRB,&
&.509E-02_JPRB,.468E-02_JPRB,.416E-02_JPRB,.377E-02_JPRB,.357E-02_JPRB,.336E-02_JPRB,.322E-02_JPRB,&
&.327E-02_JPRB,.323E-02_JPRB,.295E-02_JPRB,.246E-02_JPRB,.193E-02_JPRB,.151E-02_JPRB,.148E-02_JPRB,&
&.162E-02_JPRB,.172E-02_JPRB,.181E-02_JPRB,.192E-02_JPRB,.201E-02_JPRB,.215E-02_JPRB,.238E-02_JPRB,&
&.260E-02_JPRB,.269E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 24  -2.0
ZAER (:,24, 7) = (/&
&.183E-02_JPRB,.198E-02_JPRB,.226E-02_JPRB,.268E-02_JPRB,.309E-02_JPRB,.343E-02_JPRB,.376E-02_JPRB,&
&.407E-02_JPRB,.437E-02_JPRB,.461E-02_JPRB,.478E-02_JPRB,.496E-02_JPRB,.519E-02_JPRB,.534E-02_JPRB,&
&.555E-02_JPRB,.574E-02_JPRB,.581E-02_JPRB,.625E-02_JPRB,.683E-02_JPRB,.701E-02_JPRB,.781E-02_JPRB,&
&.893E-02_JPRB,.961E-02_JPRB,.102E-01_JPRB,.112E-01_JPRB,.137E-01_JPRB,.170E-01_JPRB,.186E-01_JPRB,&
&.195E-01_JPRB,.199E-01_JPRB,.203E-01_JPRB,.203E-01_JPRB,.211E-01_JPRB,.242E-01_JPRB,.283E-01_JPRB,&
&.319E-01_JPRB,.369E-01_JPRB,.444E-01_JPRB,.557E-01_JPRB,.681E-01_JPRB,.827E-01_JPRB,.103E+00_JPRB,&
&.121E+00_JPRB,.126E+00_JPRB,.998E-01_JPRB,.579E-01_JPRB,.258E-01_JPRB,.140E-01_JPRB,.910E-02_JPRB,&
&.780E-02_JPRB,.699E-02_JPRB,.618E-02_JPRB,.481E-02_JPRB,.348E-02_JPRB,.229E-02_JPRB,.175E-02_JPRB,&
&.138E-02_JPRB,.121E-02_JPRB,.108E-02_JPRB,.913E-03_JPRB,.829E-03_JPRB,.820E-03_JPRB,.877E-03_JPRB,&
&.966E-03_JPRB,.106E-02_JPRB,.115E-02_JPRB,.122E-02_JPRB,.128E-02_JPRB,.136E-02_JPRB,.150E-02_JPRB,&
&.164E-02_JPRB,.174E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 25  -6.0
ZAER (:,25, 7) = (/&
&.161E-02_JPRB,.182E-02_JPRB,.214E-02_JPRB,.260E-02_JPRB,.306E-02_JPRB,.339E-02_JPRB,.364E-02_JPRB,&
&.381E-02_JPRB,.397E-02_JPRB,.413E-02_JPRB,.422E-02_JPRB,.434E-02_JPRB,.452E-02_JPRB,.459E-02_JPRB,&
&.469E-02_JPRB,.470E-02_JPRB,.476E-02_JPRB,.510E-02_JPRB,.562E-02_JPRB,.633E-02_JPRB,.733E-02_JPRB,&
&.917E-02_JPRB,.106E-01_JPRB,.112E-01_JPRB,.130E-01_JPRB,.179E-01_JPRB,.238E-01_JPRB,.265E-01_JPRB,&
&.286E-01_JPRB,.272E-01_JPRB,.237E-01_JPRB,.203E-01_JPRB,.192E-01_JPRB,.225E-01_JPRB,.268E-01_JPRB,&
&.279E-01_JPRB,.296E-01_JPRB,.341E-01_JPRB,.468E-01_JPRB,.660E-01_JPRB,.908E-01_JPRB,.128E+00_JPRB,&
&.179E+00_JPRB,.250E+00_JPRB,.317E+00_JPRB,.324E+00_JPRB,.345E+00_JPRB,.122E+00_JPRB,.362E-01_JPRB,&
&.257E-01_JPRB,.202E-01_JPRB,.210E-01_JPRB,.202E-01_JPRB,.144E-01_JPRB,.663E-02_JPRB,.269E-02_JPRB,&
&.136E-02_JPRB,.900E-03_JPRB,.715E-03_JPRB,.608E-03_JPRB,.559E-03_JPRB,.560E-03_JPRB,.591E-03_JPRB,&
&.658E-03_JPRB,.752E-03_JPRB,.852E-03_JPRB,.917E-03_JPRB,.976E-03_JPRB,.103E-02_JPRB,.114E-02_JPRB,&
&.129E-02_JPRB,.144E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 26 -10.0
ZAER (:,26, 7) = (/&
&.233E-02_JPRB,.272E-02_JPRB,.316E-02_JPRB,.369E-02_JPRB,.428E-02_JPRB,.485E-02_JPRB,.518E-02_JPRB,&
&.514E-02_JPRB,.497E-02_JPRB,.460E-02_JPRB,.417E-02_JPRB,.402E-02_JPRB,.406E-02_JPRB,.414E-02_JPRB,&
&.421E-02_JPRB,.420E-02_JPRB,.425E-02_JPRB,.438E-02_JPRB,.501E-02_JPRB,.631E-02_JPRB,.830E-02_JPRB,&
&.113E-01_JPRB,.146E-01_JPRB,.180E-01_JPRB,.234E-01_JPRB,.323E-01_JPRB,.414E-01_JPRB,.479E-01_JPRB,&
&.523E-01_JPRB,.534E-01_JPRB,.510E-01_JPRB,.458E-01_JPRB,.363E-01_JPRB,.399E-01_JPRB,.487E-01_JPRB,&
&.469E-01_JPRB,.446E-01_JPRB,.458E-01_JPRB,.491E-01_JPRB,.610E-01_JPRB,.873E-01_JPRB,.125E+00_JPRB,&
&.171E+00_JPRB,.276E+00_JPRB,.475E+00_JPRB,.699E+00_JPRB,.983E+00_JPRB,.547E+00_JPRB,.160E+00_JPRB,&
&.971E-01_JPRB,.657E-01_JPRB,.698E-01_JPRB,.798E-01_JPRB,.674E-01_JPRB,.302E-01_JPRB,.775E-02_JPRB,&
&.432E-02_JPRB,.380E-02_JPRB,.271E-02_JPRB,.165E-02_JPRB,.112E-02_JPRB,.856E-03_JPRB,.593E-03_JPRB,&
&.678E-03_JPRB,.913E-03_JPRB,.123E-02_JPRB,.153E-02_JPRB,.167E-02_JPRB,.172E-02_JPRB,.168E-02_JPRB,&
&.178E-02_JPRB,.201E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 27 -14.0
ZAER (:,27, 7) = (/&
&.315E-02_JPRB,.373E-02_JPRB,.453E-02_JPRB,.549E-02_JPRB,.668E-02_JPRB,.798E-02_JPRB,.895E-02_JPRB,&
&.919E-02_JPRB,.908E-02_JPRB,.858E-02_JPRB,.793E-02_JPRB,.760E-02_JPRB,.764E-02_JPRB,.757E-02_JPRB,&
&.750E-02_JPRB,.745E-02_JPRB,.691E-02_JPRB,.580E-02_JPRB,.575E-02_JPRB,.666E-02_JPRB,.920E-02_JPRB,&
&.128E-01_JPRB,.178E-01_JPRB,.237E-01_JPRB,.312E-01_JPRB,.433E-01_JPRB,.564E-01_JPRB,.646E-01_JPRB,&
&.717E-01_JPRB,.792E-01_JPRB,.854E-01_JPRB,.900E-01_JPRB,.932E-01_JPRB,.105E+00_JPRB,.110E+00_JPRB,&
&.108E+00_JPRB,.998E-01_JPRB,.988E-01_JPRB,.920E-01_JPRB,.101E+00_JPRB,.123E+00_JPRB,.147E+00_JPRB,&
&.207E+00_JPRB,.329E+00_JPRB,.480E+00_JPRB,.541E+00_JPRB,.671E+00_JPRB,.643E+00_JPRB,.383E+00_JPRB,&
&.208E+00_JPRB,.135E+00_JPRB,.138E+00_JPRB,.169E+00_JPRB,.155E+00_JPRB,.850E-01_JPRB,.342E-01_JPRB,&
&.177E-01_JPRB,.150E-01_JPRB,.108E-01_JPRB,.591E-02_JPRB,.364E-02_JPRB,.290E-02_JPRB,.193E-02_JPRB,&
&.159E-02_JPRB,.186E-02_JPRB,.229E-02_JPRB,.289E-02_JPRB,.328E-02_JPRB,.331E-02_JPRB,.312E-02_JPRB,&
&.284E-02_JPRB,.283E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 28 -18.0
ZAER (:,28, 7) = (/&
&.493E-02_JPRB,.529E-02_JPRB,.646E-02_JPRB,.809E-02_JPRB,.984E-02_JPRB,.116E-01_JPRB,.130E-01_JPRB,&
&.141E-01_JPRB,.149E-01_JPRB,.151E-01_JPRB,.155E-01_JPRB,.164E-01_JPRB,.179E-01_JPRB,.200E-01_JPRB,&
&.215E-01_JPRB,.213E-01_JPRB,.173E-01_JPRB,.134E-01_JPRB,.112E-01_JPRB,.979E-02_JPRB,.116E-01_JPRB,&
&.146E-01_JPRB,.186E-01_JPRB,.252E-01_JPRB,.331E-01_JPRB,.414E-01_JPRB,.486E-01_JPRB,.545E-01_JPRB,&
&.624E-01_JPRB,.751E-01_JPRB,.955E-01_JPRB,.125E+00_JPRB,.168E+00_JPRB,.196E+00_JPRB,.186E+00_JPRB,&
&.183E+00_JPRB,.172E+00_JPRB,.165E+00_JPRB,.164E+00_JPRB,.177E+00_JPRB,.199E+00_JPRB,.223E+00_JPRB,&
&.256E+00_JPRB,.341E+00_JPRB,.406E+00_JPRB,.395E+00_JPRB,.380E+00_JPRB,.489E+00_JPRB,.458E+00_JPRB,&
&.364E+00_JPRB,.237E+00_JPRB,.202E+00_JPRB,.244E+00_JPRB,.216E+00_JPRB,.140E+00_JPRB,.759E-01_JPRB,&
&.466E-01_JPRB,.351E-01_JPRB,.267E-01_JPRB,.160E-01_JPRB,.937E-02_JPRB,.707E-02_JPRB,.594E-02_JPRB,&
&.494E-02_JPRB,.524E-02_JPRB,.581E-02_JPRB,.674E-02_JPRB,.783E-02_JPRB,.807E-02_JPRB,.774E-02_JPRB,&
&.649E-02_JPRB,.529E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 29 -22.0
ZAER (:,29, 7) = (/&
&.103E-01_JPRB,.888E-02_JPRB,.861E-02_JPRB,.956E-02_JPRB,.112E-01_JPRB,.132E-01_JPRB,.155E-01_JPRB,&
&.176E-01_JPRB,.190E-01_JPRB,.191E-01_JPRB,.192E-01_JPRB,.208E-01_JPRB,.241E-01_JPRB,.302E-01_JPRB,&
&.383E-01_JPRB,.443E-01_JPRB,.374E-01_JPRB,.275E-01_JPRB,.232E-01_JPRB,.170E-01_JPRB,.139E-01_JPRB,&
&.138E-01_JPRB,.164E-01_JPRB,.205E-01_JPRB,.251E-01_JPRB,.268E-01_JPRB,.273E-01_JPRB,.265E-01_JPRB,&
&.292E-01_JPRB,.383E-01_JPRB,.571E-01_JPRB,.980E-01_JPRB,.166E+00_JPRB,.222E+00_JPRB,.213E+00_JPRB,&
&.209E+00_JPRB,.209E+00_JPRB,.197E+00_JPRB,.203E+00_JPRB,.225E+00_JPRB,.219E+00_JPRB,.218E+00_JPRB,&
&.230E+00_JPRB,.286E+00_JPRB,.344E+00_JPRB,.347E+00_JPRB,.368E+00_JPRB,.421E+00_JPRB,.446E+00_JPRB,&
&.420E+00_JPRB,.353E+00_JPRB,.292E+00_JPRB,.271E+00_JPRB,.201E+00_JPRB,.146E+00_JPRB,.107E+00_JPRB,&
&.674E-01_JPRB,.430E-01_JPRB,.321E-01_JPRB,.249E-01_JPRB,.178E-01_JPRB,.156E-01_JPRB,.145E-01_JPRB,&
&.126E-01_JPRB,.116E-01_JPRB,.117E-01_JPRB,.135E-01_JPRB,.154E-01_JPRB,.173E-01_JPRB,.175E-01_JPRB,&
&.150E-01_JPRB,.122E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 30 -26.0
ZAER (:,30, 7) = (/&
&.213E-01_JPRB,.181E-01_JPRB,.156E-01_JPRB,.147E-01_JPRB,.153E-01_JPRB,.170E-01_JPRB,.191E-01_JPRB,&
&.206E-01_JPRB,.222E-01_JPRB,.232E-01_JPRB,.229E-01_JPRB,.232E-01_JPRB,.260E-01_JPRB,.350E-01_JPRB,&
&.468E-01_JPRB,.627E-01_JPRB,.593E-01_JPRB,.354E-01_JPRB,.316E-01_JPRB,.274E-01_JPRB,.218E-01_JPRB,&
&.174E-01_JPRB,.161E-01_JPRB,.171E-01_JPRB,.191E-01_JPRB,.187E-01_JPRB,.168E-01_JPRB,.153E-01_JPRB,&
&.148E-01_JPRB,.163E-01_JPRB,.231E-01_JPRB,.403E-01_JPRB,.869E-01_JPRB,.156E+00_JPRB,.192E+00_JPRB,&
&.207E+00_JPRB,.236E+00_JPRB,.210E+00_JPRB,.191E+00_JPRB,.214E+00_JPRB,.191E+00_JPRB,.166E+00_JPRB,&
&.170E+00_JPRB,.234E+00_JPRB,.308E+00_JPRB,.338E+00_JPRB,.360E+00_JPRB,.359E+00_JPRB,.359E+00_JPRB,&
&.346E+00_JPRB,.357E+00_JPRB,.338E+00_JPRB,.249E+00_JPRB,.156E+00_JPRB,.112E+00_JPRB,.989E-01_JPRB,&
&.801E-01_JPRB,.539E-01_JPRB,.377E-01_JPRB,.303E-01_JPRB,.307E-01_JPRB,.345E-01_JPRB,.356E-01_JPRB,&
&.322E-01_JPRB,.267E-01_JPRB,.230E-01_JPRB,.242E-01_JPRB,.262E-01_JPRB,.285E-01_JPRB,.292E-01_JPRB,&
&.265E-01_JPRB,.239E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 31 -30.0
ZAER (:,31, 7) = (/&
&.306E-01_JPRB,.289E-01_JPRB,.271E-01_JPRB,.256E-01_JPRB,.244E-01_JPRB,.244E-01_JPRB,.249E-01_JPRB,&
&.244E-01_JPRB,.253E-01_JPRB,.266E-01_JPRB,.273E-01_JPRB,.268E-01_JPRB,.270E-01_JPRB,.324E-01_JPRB,&
&.427E-01_JPRB,.678E-01_JPRB,.665E-01_JPRB,.343E-01_JPRB,.293E-01_JPRB,.302E-01_JPRB,.274E-01_JPRB,&
&.222E-01_JPRB,.183E-01_JPRB,.171E-01_JPRB,.182E-01_JPRB,.173E-01_JPRB,.156E-01_JPRB,.145E-01_JPRB,&
&.142E-01_JPRB,.141E-01_JPRB,.142E-01_JPRB,.168E-01_JPRB,.244E-01_JPRB,.548E-01_JPRB,.121E+00_JPRB,&
&.185E+00_JPRB,.236E+00_JPRB,.232E+00_JPRB,.185E+00_JPRB,.164E+00_JPRB,.152E+00_JPRB,.117E+00_JPRB,&
&.106E+00_JPRB,.169E+00_JPRB,.253E+00_JPRB,.320E+00_JPRB,.371E+00_JPRB,.337E+00_JPRB,.309E+00_JPRB,&
&.299E+00_JPRB,.301E+00_JPRB,.245E+00_JPRB,.186E+00_JPRB,.142E+00_JPRB,.105E+00_JPRB,.897E-01_JPRB,&
&.756E-01_JPRB,.552E-01_JPRB,.409E-01_JPRB,.378E-01_JPRB,.424E-01_JPRB,.462E-01_JPRB,.510E-01_JPRB,&
&.505E-01_JPRB,.451E-01_JPRB,.368E-01_JPRB,.339E-01_JPRB,.334E-01_JPRB,.337E-01_JPRB,.325E-01_JPRB,&
&.306E-01_JPRB,.299E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 32 -34.0
ZAER (:,32, 7) = (/&
&.332E-01_JPRB,.331E-01_JPRB,.316E-01_JPRB,.304E-01_JPRB,.294E-01_JPRB,.287E-01_JPRB,.281E-01_JPRB,&
&.270E-01_JPRB,.267E-01_JPRB,.273E-01_JPRB,.297E-01_JPRB,.316E-01_JPRB,.315E-01_JPRB,.316E-01_JPRB,&
&.351E-01_JPRB,.495E-01_JPRB,.570E-01_JPRB,.342E-01_JPRB,.273E-01_JPRB,.271E-01_JPRB,.252E-01_JPRB,&
&.220E-01_JPRB,.193E-01_JPRB,.174E-01_JPRB,.178E-01_JPRB,.170E-01_JPRB,.156E-01_JPRB,.149E-01_JPRB,&
&.147E-01_JPRB,.146E-01_JPRB,.147E-01_JPRB,.144E-01_JPRB,.148E-01_JPRB,.198E-01_JPRB,.434E-01_JPRB,&
&.971E-01_JPRB,.167E+00_JPRB,.185E+00_JPRB,.135E+00_JPRB,.965E-01_JPRB,.842E-01_JPRB,.642E-01_JPRB,&
&.584E-01_JPRB,.935E-01_JPRB,.152E+00_JPRB,.235E+00_JPRB,.282E+00_JPRB,.274E+00_JPRB,.242E+00_JPRB,&
&.245E+00_JPRB,.233E+00_JPRB,.206E+00_JPRB,.172E+00_JPRB,.148E+00_JPRB,.137E+00_JPRB,.121E+00_JPRB,&
&.807E-01_JPRB,.538E-01_JPRB,.415E-01_JPRB,.417E-01_JPRB,.469E-01_JPRB,.487E-01_JPRB,.520E-01_JPRB,&
&.547E-01_JPRB,.499E-01_JPRB,.406E-01_JPRB,.350E-01_JPRB,.332E-01_JPRB,.367E-01_JPRB,.358E-01_JPRB,&
&.331E-01_JPRB,.326E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 33 -38.0
ZAER (:,33, 7) = (/&
&.332E-01_JPRB,.316E-01_JPRB,.295E-01_JPRB,.281E-01_JPRB,.269E-01_JPRB,.263E-01_JPRB,.261E-01_JPRB,&
&.258E-01_JPRB,.256E-01_JPRB,.260E-01_JPRB,.288E-01_JPRB,.343E-01_JPRB,.374E-01_JPRB,.351E-01_JPRB,&
&.326E-01_JPRB,.357E-01_JPRB,.402E-01_JPRB,.330E-01_JPRB,.280E-01_JPRB,.269E-01_JPRB,.248E-01_JPRB,&
&.218E-01_JPRB,.195E-01_JPRB,.173E-01_JPRB,.169E-01_JPRB,.167E-01_JPRB,.163E-01_JPRB,.158E-01_JPRB,&
&.153E-01_JPRB,.148E-01_JPRB,.146E-01_JPRB,.144E-01_JPRB,.148E-01_JPRB,.162E-01_JPRB,.222E-01_JPRB,&
&.483E-01_JPRB,.901E-01_JPRB,.901E-01_JPRB,.821E-01_JPRB,.690E-01_JPRB,.582E-01_JPRB,.483E-01_JPRB,&
&.451E-01_JPRB,.583E-01_JPRB,.800E-01_JPRB,.118E+00_JPRB,.176E+00_JPRB,.195E+00_JPRB,.160E+00_JPRB,&
&.150E+00_JPRB,.144E+00_JPRB,.145E+00_JPRB,.177E+00_JPRB,.164E+00_JPRB,.155E+00_JPRB,.149E+00_JPRB,&
&.108E+00_JPRB,.630E-01_JPRB,.552E-01_JPRB,.542E-01_JPRB,.571E-01_JPRB,.608E-01_JPRB,.665E-01_JPRB,&
&.606E-01_JPRB,.493E-01_JPRB,.400E-01_JPRB,.357E-01_JPRB,.361E-01_JPRB,.421E-01_JPRB,.402E-01_JPRB,&
&.362E-01_JPRB,.343E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 34 -42.0
ZAER (:,34, 7) = (/&
&.333E-01_JPRB,.295E-01_JPRB,.269E-01_JPRB,.246E-01_JPRB,.227E-01_JPRB,.220E-01_JPRB,.224E-01_JPRB,&
&.229E-01_JPRB,.232E-01_JPRB,.236E-01_JPRB,.253E-01_JPRB,.307E-01_JPRB,.363E-01_JPRB,.373E-01_JPRB,&
&.355E-01_JPRB,.373E-01_JPRB,.380E-01_JPRB,.315E-01_JPRB,.280E-01_JPRB,.264E-01_JPRB,.249E-01_JPRB,&
&.226E-01_JPRB,.208E-01_JPRB,.193E-01_JPRB,.185E-01_JPRB,.178E-01_JPRB,.172E-01_JPRB,.165E-01_JPRB,&
&.157E-01_JPRB,.152E-01_JPRB,.147E-01_JPRB,.143E-01_JPRB,.144E-01_JPRB,.148E-01_JPRB,.172E-01_JPRB,&
&.296E-01_JPRB,.497E-01_JPRB,.505E-01_JPRB,.527E-01_JPRB,.532E-01_JPRB,.462E-01_JPRB,.377E-01_JPRB,&
&.332E-01_JPRB,.389E-01_JPRB,.512E-01_JPRB,.750E-01_JPRB,.136E+00_JPRB,.159E+00_JPRB,.135E+00_JPRB,&
&.132E+00_JPRB,.130E+00_JPRB,.127E+00_JPRB,.152E+00_JPRB,.155E+00_JPRB,.168E+00_JPRB,.186E+00_JPRB,&
&.205E+00_JPRB,.146E+00_JPRB,.125E+00_JPRB,.137E+00_JPRB,.106E+00_JPRB,.985E-01_JPRB,.951E-01_JPRB,&
&.804E-01_JPRB,.619E-01_JPRB,.512E-01_JPRB,.443E-01_JPRB,.422E-01_JPRB,.457E-01_JPRB,.436E-01_JPRB,&
&.408E-01_JPRB,.380E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 35 -46.0
ZAER (:,35, 7) = (/&
&.325E-01_JPRB,.274E-01_JPRB,.247E-01_JPRB,.215E-01_JPRB,.193E-01_JPRB,.189E-01_JPRB,.192E-01_JPRB,&
&.200E-01_JPRB,.206E-01_JPRB,.211E-01_JPRB,.222E-01_JPRB,.256E-01_JPRB,.308E-01_JPRB,.344E-01_JPRB,&
&.364E-01_JPRB,.387E-01_JPRB,.365E-01_JPRB,.298E-01_JPRB,.262E-01_JPRB,.243E-01_JPRB,.232E-01_JPRB,&
&.220E-01_JPRB,.208E-01_JPRB,.196E-01_JPRB,.186E-01_JPRB,.178E-01_JPRB,.170E-01_JPRB,.163E-01_JPRB,&
&.157E-01_JPRB,.155E-01_JPRB,.152E-01_JPRB,.146E-01_JPRB,.141E-01_JPRB,.136E-01_JPRB,.140E-01_JPRB,&
&.186E-01_JPRB,.308E-01_JPRB,.335E-01_JPRB,.340E-01_JPRB,.337E-01_JPRB,.325E-01_JPRB,.290E-01_JPRB,&
&.263E-01_JPRB,.315E-01_JPRB,.569E-01_JPRB,.844E-01_JPRB,.951E-01_JPRB,.904E-01_JPRB,.114E+00_JPRB,&
&.133E+00_JPRB,.132E+00_JPRB,.145E+00_JPRB,.168E+00_JPRB,.148E+00_JPRB,.171E+00_JPRB,.210E+00_JPRB,&
&.242E+00_JPRB,.243E+00_JPRB,.243E+00_JPRB,.245E+00_JPRB,.194E+00_JPRB,.135E+00_JPRB,.112E+00_JPRB,&
&.878E-01_JPRB,.652E-01_JPRB,.534E-01_JPRB,.479E-01_JPRB,.447E-01_JPRB,.439E-01_JPRB,.424E-01_JPRB,&
&.407E-01_JPRB,.387E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 36 -50.0
ZAER (:,36, 7) = (/&
&.320E-01_JPRB,.269E-01_JPRB,.237E-01_JPRB,.216E-01_JPRB,.190E-01_JPRB,.172E-01_JPRB,.169E-01_JPRB,&
&.174E-01_JPRB,.177E-01_JPRB,.182E-01_JPRB,.195E-01_JPRB,.223E-01_JPRB,.255E-01_JPRB,.278E-01_JPRB,&
&.313E-01_JPRB,.329E-01_JPRB,.292E-01_JPRB,.255E-01_JPRB,.234E-01_JPRB,.216E-01_JPRB,.210E-01_JPRB,&
&.209E-01_JPRB,.200E-01_JPRB,.191E-01_JPRB,.183E-01_JPRB,.174E-01_JPRB,.164E-01_JPRB,.158E-01_JPRB,&
&.153E-01_JPRB,.149E-01_JPRB,.144E-01_JPRB,.138E-01_JPRB,.133E-01_JPRB,.128E-01_JPRB,.125E-01_JPRB,&
&.140E-01_JPRB,.191E-01_JPRB,.239E-01_JPRB,.258E-01_JPRB,.252E-01_JPRB,.241E-01_JPRB,.231E-01_JPRB,&
&.234E-01_JPRB,.293E-01_JPRB,.446E-01_JPRB,.571E-01_JPRB,.625E-01_JPRB,.568E-01_JPRB,.675E-01_JPRB,&
&.847E-01_JPRB,.104E+00_JPRB,.123E+00_JPRB,.145E+00_JPRB,.146E+00_JPRB,.144E+00_JPRB,.155E+00_JPRB,&
&.166E+00_JPRB,.173E+00_JPRB,.190E+00_JPRB,.212E+00_JPRB,.189E+00_JPRB,.138E+00_JPRB,.969E-01_JPRB,&
&.660E-01_JPRB,.507E-01_JPRB,.431E-01_JPRB,.386E-01_JPRB,.360E-01_JPRB,.359E-01_JPRB,.363E-01_JPRB,&
&.364E-01_JPRB,.365E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 37 -54.0
ZAER (:,37, 7) = (/&
&.307E-01_JPRB,.258E-01_JPRB,.227E-01_JPRB,.225E-01_JPRB,.203E-01_JPRB,.172E-01_JPRB,.164E-01_JPRB,&
&.162E-01_JPRB,.161E-01_JPRB,.166E-01_JPRB,.184E-01_JPRB,.214E-01_JPRB,.231E-01_JPRB,.236E-01_JPRB,&
&.242E-01_JPRB,.243E-01_JPRB,.231E-01_JPRB,.215E-01_JPRB,.208E-01_JPRB,.199E-01_JPRB,.196E-01_JPRB,&
&.207E-01_JPRB,.196E-01_JPRB,.183E-01_JPRB,.170E-01_JPRB,.158E-01_JPRB,.152E-01_JPRB,.147E-01_JPRB,&
&.139E-01_JPRB,.133E-01_JPRB,.129E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.126E-01_JPRB,.142E-01_JPRB,.171E-01_JPRB,.195E-01_JPRB,.207E-01_JPRB,.214E-01_JPRB,.217E-01_JPRB,&
&.219E-01_JPRB,.240E-01_JPRB,.300E-01_JPRB,.337E-01_JPRB,.341E-01_JPRB,.337E-01_JPRB,.381E-01_JPRB,&
&.467E-01_JPRB,.530E-01_JPRB,.561E-01_JPRB,.651E-01_JPRB,.807E-01_JPRB,.931E-01_JPRB,.995E-01_JPRB,&
&.961E-01_JPRB,.943E-01_JPRB,.106E+00_JPRB,.109E+00_JPRB,.976E-01_JPRB,.706E-01_JPRB,.521E-01_JPRB,&
&.412E-01_JPRB,.352E-01_JPRB,.311E-01_JPRB,.276E-01_JPRB,.277E-01_JPRB,.300E-01_JPRB,.315E-01_JPRB,&
&.320E-01_JPRB,.324E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 38 -58.0
ZAER (:,38, 7) = (/&
&.260E-01_JPRB,.239E-01_JPRB,.222E-01_JPRB,.223E-01_JPRB,.209E-01_JPRB,.187E-01_JPRB,.176E-01_JPRB,&
&.175E-01_JPRB,.174E-01_JPRB,.178E-01_JPRB,.191E-01_JPRB,.213E-01_JPRB,.227E-01_JPRB,.225E-01_JPRB,&
&.222E-01_JPRB,.216E-01_JPRB,.211E-01_JPRB,.208E-01_JPRB,.202E-01_JPRB,.197E-01_JPRB,.190E-01_JPRB,&
&.198E-01_JPRB,.183E-01_JPRB,.165E-01_JPRB,.147E-01_JPRB,.135E-01_JPRB,.132E-01_JPRB,.126E-01_JPRB,&
&.118E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.114E-01_JPRB,.115E-01_JPRB,.114E-01_JPRB,.116E-01_JPRB,&
&.119E-01_JPRB,.124E-01_JPRB,.138E-01_JPRB,.152E-01_JPRB,.165E-01_JPRB,.181E-01_JPRB,.194E-01_JPRB,&
&.210E-01_JPRB,.217E-01_JPRB,.230E-01_JPRB,.263E-01_JPRB,.270E-01_JPRB,.286E-01_JPRB,.317E-01_JPRB,&
&.329E-01_JPRB,.281E-01_JPRB,.247E-01_JPRB,.272E-01_JPRB,.313E-01_JPRB,.401E-01_JPRB,.474E-01_JPRB,&
&.498E-01_JPRB,.499E-01_JPRB,.509E-01_JPRB,.501E-01_JPRB,.443E-01_JPRB,.380E-01_JPRB,.335E-01_JPRB,&
&.294E-01_JPRB,.255E-01_JPRB,.224E-01_JPRB,.201E-01_JPRB,.203E-01_JPRB,.229E-01_JPRB,.251E-01_JPRB,&
&.261E-01_JPRB,.268E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 39 -62.0
ZAER (:,39, 7) = (/&
&.225E-01_JPRB,.229E-01_JPRB,.221E-01_JPRB,.219E-01_JPRB,.224E-01_JPRB,.216E-01_JPRB,.202E-01_JPRB,&
&.197E-01_JPRB,.199E-01_JPRB,.203E-01_JPRB,.210E-01_JPRB,.223E-01_JPRB,.234E-01_JPRB,.235E-01_JPRB,&
&.233E-01_JPRB,.227E-01_JPRB,.225E-01_JPRB,.229E-01_JPRB,.215E-01_JPRB,.205E-01_JPRB,.195E-01_JPRB,&
&.189E-01_JPRB,.171E-01_JPRB,.152E-01_JPRB,.134E-01_JPRB,.125E-01_JPRB,.122E-01_JPRB,.123E-01_JPRB,&
&.114E-01_JPRB,.107E-01_JPRB,.109E-01_JPRB,.110E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.107E-01_JPRB,.110E-01_JPRB,.118E-01_JPRB,.129E-01_JPRB,.134E-01_JPRB,.142E-01_JPRB,.158E-01_JPRB,&
&.174E-01_JPRB,.184E-01_JPRB,.186E-01_JPRB,.210E-01_JPRB,.228E-01_JPRB,.235E-01_JPRB,.249E-01_JPRB,&
&.249E-01_JPRB,.225E-01_JPRB,.226E-01_JPRB,.232E-01_JPRB,.231E-01_JPRB,.237E-01_JPRB,.247E-01_JPRB,&
&.252E-01_JPRB,.248E-01_JPRB,.247E-01_JPRB,.252E-01_JPRB,.254E-01_JPRB,.248E-01_JPRB,.245E-01_JPRB,&
&.234E-01_JPRB,.221E-01_JPRB,.198E-01_JPRB,.175E-01_JPRB,.173E-01_JPRB,.191E-01_JPRB,.214E-01_JPRB,&
&.224E-01_JPRB,.224E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 40 -66.0
ZAER (:,40, 7) = (/&
&.212E-01_JPRB,.219E-01_JPRB,.218E-01_JPRB,.215E-01_JPRB,.225E-01_JPRB,.235E-01_JPRB,.233E-01_JPRB,&
&.226E-01_JPRB,.221E-01_JPRB,.217E-01_JPRB,.223E-01_JPRB,.232E-01_JPRB,.240E-01_JPRB,.244E-01_JPRB,&
&.248E-01_JPRB,.254E-01_JPRB,.256E-01_JPRB,.265E-01_JPRB,.246E-01_JPRB,.211E-01_JPRB,.191E-01_JPRB,&
&.178E-01_JPRB,.168E-01_JPRB,.153E-01_JPRB,.133E-01_JPRB,.121E-01_JPRB,.124E-01_JPRB,.131E-01_JPRB,&
&.130E-01_JPRB,.125E-01_JPRB,.121E-01_JPRB,.117E-01_JPRB,.113E-01_JPRB,.110E-01_JPRB,.107E-01_JPRB,&
&.105E-01_JPRB,.106E-01_JPRB,.108E-01_JPRB,.115E-01_JPRB,.121E-01_JPRB,.124E-01_JPRB,.128E-01_JPRB,&
&.138E-01_JPRB,.144E-01_JPRB,.146E-01_JPRB,.159E-01_JPRB,.186E-01_JPRB,.209E-01_JPRB,.224E-01_JPRB,&
&.231E-01_JPRB,.223E-01_JPRB,.218E-01_JPRB,.215E-01_JPRB,.202E-01_JPRB,.188E-01_JPRB,.183E-01_JPRB,&
&.182E-01_JPRB,.181E-01_JPRB,.184E-01_JPRB,.191E-01_JPRB,.198E-01_JPRB,.210E-01_JPRB,.216E-01_JPRB,&
&.222E-01_JPRB,.220E-01_JPRB,.196E-01_JPRB,.182E-01_JPRB,.180E-01_JPRB,.186E-01_JPRB,.201E-01_JPRB,&
&.207E-01_JPRB,.208E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 41 -70.0
ZAER (:,41, 7) = (/&
&.216E-01_JPRB,.216E-01_JPRB,.211E-01_JPRB,.218E-01_JPRB,.225E-01_JPRB,.231E-01_JPRB,.232E-01_JPRB,&
&.231E-01_JPRB,.225E-01_JPRB,.220E-01_JPRB,.220E-01_JPRB,.222E-01_JPRB,.230E-01_JPRB,.241E-01_JPRB,&
&.251E-01_JPRB,.252E-01_JPRB,.241E-01_JPRB,.226E-01_JPRB,.213E-01_JPRB,.198E-01_JPRB,.182E-01_JPRB,&
&.169E-01_JPRB,.160E-01_JPRB,.153E-01_JPRB,.143E-01_JPRB,.126E-01_JPRB,.125E-01_JPRB,.135E-01_JPRB,&
&.140E-01_JPRB,.141E-01_JPRB,.142E-01_JPRB,.134E-01_JPRB,.122E-01_JPRB,.117E-01_JPRB,.112E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.111E-01_JPRB,.114E-01_JPRB,.117E-01_JPRB,.120E-01_JPRB,.122E-01_JPRB,&
&.124E-01_JPRB,.126E-01_JPRB,.128E-01_JPRB,.131E-01_JPRB,.140E-01_JPRB,.156E-01_JPRB,.173E-01_JPRB,&
&.187E-01_JPRB,.190E-01_JPRB,.187E-01_JPRB,.180E-01_JPRB,.169E-01_JPRB,.162E-01_JPRB,.165E-01_JPRB,&
&.172E-01_JPRB,.174E-01_JPRB,.176E-01_JPRB,.180E-01_JPRB,.185E-01_JPRB,.197E-01_JPRB,.208E-01_JPRB,&
&.230E-01_JPRB,.227E-01_JPRB,.194E-01_JPRB,.184E-01_JPRB,.184E-01_JPRB,.185E-01_JPRB,.190E-01_JPRB,&
&.193E-01_JPRB,.194E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 42 -74.0
ZAER (:,42, 7) = (/&
&.209E-01_JPRB,.205E-01_JPRB,.201E-01_JPRB,.205E-01_JPRB,.209E-01_JPRB,.211E-01_JPRB,.211E-01_JPRB,&
&.209E-01_JPRB,.206E-01_JPRB,.205E-01_JPRB,.201E-01_JPRB,.201E-01_JPRB,.212E-01_JPRB,.228E-01_JPRB,&
&.228E-01_JPRB,.218E-01_JPRB,.217E-01_JPRB,.200E-01_JPRB,.198E-01_JPRB,.187E-01_JPRB,.171E-01_JPRB,&
&.165E-01_JPRB,.163E-01_JPRB,.160E-01_JPRB,.151E-01_JPRB,.142E-01_JPRB,.138E-01_JPRB,.143E-01_JPRB,&
&.147E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.145E-01_JPRB,.135E-01_JPRB,.123E-01_JPRB,.121E-01_JPRB,&
&.120E-01_JPRB,.117E-01_JPRB,.116E-01_JPRB,.118E-01_JPRB,.119E-01_JPRB,.121E-01_JPRB,.123E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB,.127E-01_JPRB,.130E-01_JPRB,.133E-01_JPRB,.138E-01_JPRB,.139E-01_JPRB,&
&.145E-01_JPRB,.152E-01_JPRB,.153E-01_JPRB,.154E-01_JPRB,.169E-01_JPRB,.203E-01_JPRB,.222E-01_JPRB,&
&.222E-01_JPRB,.197E-01_JPRB,.187E-01_JPRB,.180E-01_JPRB,.184E-01_JPRB,.195E-01_JPRB,.211E-01_JPRB,&
&.248E-01_JPRB,.276E-01_JPRB,.232E-01_JPRB,.190E-01_JPRB,.183E-01_JPRB,.182E-01_JPRB,.182E-01_JPRB,&
&.184E-01_JPRB,.193E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 43 -78.0
ZAER (:,43, 7) = (/&
&.191E-01_JPRB,.191E-01_JPRB,.191E-01_JPRB,.191E-01_JPRB,.190E-01_JPRB,.188E-01_JPRB,.186E-01_JPRB,&
&.185E-01_JPRB,.184E-01_JPRB,.183E-01_JPRB,.181E-01_JPRB,.183E-01_JPRB,.202E-01_JPRB,.204E-01_JPRB,&
&.196E-01_JPRB,.194E-01_JPRB,.198E-01_JPRB,.194E-01_JPRB,.189E-01_JPRB,.185E-01_JPRB,.180E-01_JPRB,&
&.181E-01_JPRB,.196E-01_JPRB,.187E-01_JPRB,.164E-01_JPRB,.155E-01_JPRB,.148E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.145E-01_JPRB,.140E-01_JPRB,.130E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.128E-01_JPRB,.130E-01_JPRB,.133E-01_JPRB,.135E-01_JPRB,&
&.136E-01_JPRB,.137E-01_JPRB,.140E-01_JPRB,.142E-01_JPRB,.143E-01_JPRB,.145E-01_JPRB,.148E-01_JPRB,&
&.154E-01_JPRB,.158E-01_JPRB,.160E-01_JPRB,.164E-01_JPRB,.167E-01_JPRB,.172E-01_JPRB,.178E-01_JPRB,&
&.185E-01_JPRB,.195E-01_JPRB,.202E-01_JPRB,.190E-01_JPRB,.184E-01_JPRB,.185E-01_JPRB,.189E-01_JPRB,&
&.194E-01_JPRB,.193E-01_JPRB,.186E-01_JPRB,.182E-01_JPRB,.184E-01_JPRB,.186E-01_JPRB,.187E-01_JPRB,&
&.187E-01_JPRB,.188E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 44 -82.0
ZAER (:,44, 7) = (/&
&.181E-01_JPRB,.179E-01_JPRB,.178E-01_JPRB,.178E-01_JPRB,.176E-01_JPRB,.175E-01_JPRB,.173E-01_JPRB,&
&.172E-01_JPRB,.171E-01_JPRB,.170E-01_JPRB,.169E-01_JPRB,.168E-01_JPRB,.171E-01_JPRB,.169E-01_JPRB,&
&.167E-01_JPRB,.167E-01_JPRB,.168E-01_JPRB,.167E-01_JPRB,.169E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,&
&.173E-01_JPRB,.174E-01_JPRB,.172E-01_JPRB,.162E-01_JPRB,.154E-01_JPRB,.151E-01_JPRB,.149E-01_JPRB,&
&.148E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.148E-01_JPRB,.144E-01_JPRB,.138E-01_JPRB,.134E-01_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.135E-01_JPRB,.137E-01_JPRB,.140E-01_JPRB,.144E-01_JPRB,.147E-01_JPRB,&
&.148E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.151E-01_JPRB,.153E-01_JPRB,.156E-01_JPRB,&
&.158E-01_JPRB,.161E-01_JPRB,.168E-01_JPRB,.172E-01_JPRB,.172E-01_JPRB,.172E-01_JPRB,.175E-01_JPRB,&
&.178E-01_JPRB,.181E-01_JPRB,.179E-01_JPRB,.175E-01_JPRB,.173E-01_JPRB,.172E-01_JPRB,.172E-01_JPRB,&
&.171E-01_JPRB,.172E-01_JPRB,.176E-01_JPRB,.179E-01_JPRB,.181E-01_JPRB,.183E-01_JPRB,.183E-01_JPRB,&
&.183E-01_JPRB,.183E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 45 -86.0
ZAER (:,45, 7) = (/&
&.160E-01_JPRB,.159E-01_JPRB,.158E-01_JPRB,.157E-01_JPRB,.155E-01_JPRB,.154E-01_JPRB,.153E-01_JPRB,&
&.152E-01_JPRB,.151E-01_JPRB,.150E-01_JPRB,.148E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB,.145E-01_JPRB,.144E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.143E-01_JPRB,&
&.144E-01_JPRB,.146E-01_JPRB,.147E-01_JPRB,.148E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.150E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.150E-01_JPRB,.151E-01_JPRB,.151E-01_JPRB,.152E-01_JPRB,&
&.153E-01_JPRB,.154E-01_JPRB,.155E-01_JPRB,.156E-01_JPRB,.157E-01_JPRB,.158E-01_JPRB,.158E-01_JPRB,&
&.159E-01_JPRB,.158E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.160E-01_JPRB,.161E-01_JPRB,.161E-01_JPRB,&
&.162E-01_JPRB,.162E-01_JPRB,.163E-01_JPRB,.163E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.163E-01_JPRB,&
&.162E-01_JPRB,.162E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  7 --- lat: 46 -90.0
ZAER (:,46, 7) = (/&
&.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.147E-01_JPRB/)


!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=7  
  DO JI=1,46
    DO JL=1,72
      RAERSD(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SOIL DUST AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESD_07
